/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.core.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.ems.core.managers.AbstractEnvManager;
import org.eclipse.ptp.internal.ems.core.messages.Messages;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public final class LmodEnvManager
extends AbstractEnvManager {
    private static final String CMD_MODULE_HELP = "module help";
    private static final String CMD_MODULE_LIST = "module list";
    private static final String CMD_MODULE_AVAIL = "module avail";
    private static final String CMD_MODULE_PURGE = "module purge >/dev/null 2>&1";
    private static final String CMDFMT_MODULE_LOAD = "module load %s";
    private static final String CMDFMT_ECHO = "echo '%s'";
    private static final Pattern MODULES_SIGNATURE = Pattern.compile("^Modules based on Lua: Version ([^ \t\r\n]+).*");
    private static final int MODULES_SIGNATURE_VERSION_CAPTURE_GROUP = 1;
    private static final Pattern MODULE_NAME_PATTERN = Pattern.compile("[A-Za-z0-9-_/.]+");
    private static final Pattern NUMERIC_PREFIX = Pattern.compile("[0-9]+[)]");

    @Override
    public String getName() {
        return "Lmod";
    }

    @Override
    public boolean checkForCompatibleInstallation(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        return this.getDescription(pm) != null;
    }

    @Override
    public String getDescription(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        List<String> output = this.runCommandInBashLoginShell(pm, CMD_MODULE_HELP);
        if (output == null) {
            return null;
        }
        for (String line : output) {
            Matcher matcher = MODULES_SIGNATURE.matcher(line);
            if (!matcher.find()) continue;
            return "Lmod " + matcher.group(1);
        }
        return null;
    }

    @Override
    public String getInstructions() {
        return Messages.ModulesEnvManager_SelectModulesToBeLoaded;
    }

    @Override
    public List<String> determineAvailableElements(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        List<String> output = this.runCommandInBashLoginShell(pm, CMD_MODULE_AVAIL);
        if (output == null) {
            return Collections.emptyList();
        }
        List<String> collectedModules = this.collectModuleNamesFrom(output);
        TreeSet<String> listedModules = new TreeSet<String>(collectedModules);
        TreeSet<String> unversionedModules = new TreeSet<String>(this.removeVersionNumbersFrom(collectedModules));
        return Collections.unmodifiableList(new ArrayList<String>(this.union(listedModules, unversionedModules)));
    }

    private List<String> removeVersionNumbersFrom(List<String> listedModules) {
        ArrayList<String> result = new ArrayList<String>();
        for (String moduleName : listedModules) {
            int slashPosition = moduleName.indexOf(47);
            if (slashPosition < 0) {
                result.add(moduleName);
                continue;
            }
            result.add(moduleName.substring(0, slashPosition));
        }
        return result;
    }

    private Set<? extends String> union(Set<String> set1, Set<String> set2) {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(set1);
        result.addAll(set2);
        return result;
    }

    private List<String> collectModuleNamesFrom(List<String> output) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : output) {
            if (this.shouldIgnore(line)) continue;
            String[] stringArray = line.trim().split(" +");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleName = stringArray[n2];
                if (!(moduleName.equals("") || moduleName.equals("(default)") || NUMERIC_PREFIX.matcher(moduleName).matches() || !MODULE_NAME_PATTERN.matcher(moduleName).matches() || result.contains(moduleName))) {
                    result.add(moduleName);
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean shouldIgnore(String line) {
        return !line.startsWith(" ");
    }

    @Override
    public List<String> determineDefaultElements(IProgressMonitor pm) throws RemoteConnectionException, IOException {
        List<String> output = this.runCommandInBashLoginShell(pm, CMD_MODULE_LIST);
        if (output == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.collectModuleNamesFrom(output));
    }

    @Override
    protected List<String> getInitialBashCommands(boolean echo) {
        String echoCommand = String.format(CMDFMT_ECHO, CMD_MODULE_PURGE);
        if (echo) {
            return Arrays.asList(echoCommand, CMD_MODULE_PURGE);
        }
        return Arrays.asList(CMD_MODULE_PURGE);
    }

    @Override
    protected List<String> getBashCommand(boolean echo, String moduleName) {
        String loadCommand = String.format(CMDFMT_MODULE_LOAD, moduleName);
        String echoCommand = String.format(CMDFMT_ECHO, loadCommand);
        if (echo) {
            return Arrays.asList(echoCommand, loadCommand);
        }
        return Arrays.asList(loadCommand);
    }
}

