/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.ToolkitVersion;
import com.nvidia.common.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class LocallyInstalledToolkits
implements IToolkitLookup {
    @Override
    public ICudaToolkit[] discover() {
        ArrayList<CudaToolkit> paths = new ArrayList<CudaToolkit>(ToolkitVersion.supportedToolkits.length);
        int i = 1;
        ToolkitVersion[] toolkitVersionArray = ToolkitVersion.supportedToolkits;
        int n = ToolkitVersion.supportedToolkits.length;
        int n2 = 0;
        while (n2 < n) {
            ToolkitVersion tk = toolkitVersionArray[n2];
            try {
                String path = OS.local() == OS.MacOSX ? tk.defaultMacBinPath : tk.defaultBinPath;
                File file = new File(path).getAbsoluteFile().getCanonicalFile();
                File nvcc = new File(file, "nvcc");
                if (nvcc.isFile()) {
                    paths.add(new CudaToolkit("local." + i++, (IPath)new Path(nvcc.getParentFile().getAbsolutePath()), tk.label));
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
            ++n2;
        }
        return paths.toArray(new ICudaToolkit[paths.size()]);
    }
}

