/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.activity.CuptiActivityOverheadKind;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CuptiActivityOverhead
extends CuptiActivityBase
implements ICuptiActivity {
    public int overheadKind;
    public int objectKind;
    public int objectProcessId;
    public int objectThreadId;
    public int objectDeviceId;
    public int objectContextId;
    public int objectStreamId;
    public long start;
    public long end;

    public CuptiActivityOverhead() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.start > 0L && this.end > 0L && this.start < this.end;
    }

    public CuptiActivityObjectKind getObjectKind() {
        return CuptiActivityObjectKind.valueOf(this.objectKind);
    }

    public CuptiActivityOverheadKind getOverheadKind() {
        return CuptiActivityOverheadKind.valueOf(this.overheadKind);
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }
}

