/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.Session;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class GuidedAnalysisStageControl
extends Composite {
    private static final int CONTROLS_PER_STAGE = 4;
    private IExpertSystemStage expertSystemStage;
    private final SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Integer stepIndex = (Integer)e.widget.getData();
            GuidedAnalysisStageControl.this.runAction(stepIndex);
        }
    };
    private final Label description;
    private final Font mediumFont;
    private final Font smallFont;
    private Control[] stepControls = new Control[0];

    private static Button newButton(Composite parent, SelectionListener listener) {
        Button button = new Button(parent, 0);
        button.setBackground(parent.getBackground());
        button.setImage(ViperImages.get("icons/en/run_analysis.png"));
        button.addSelectionListener(listener);
        button.setLayoutData((Object)new GridData(768));
        return button;
    }

    private static CLabel newCompletedLabel(Composite parent) {
        CLabel label = new CLabel(parent, 0x1000000);
        label.setAlignment(0x1000000);
        label.setLayoutData((Object)new GridData(768));
        label.setImage(ViperImages.get("icons/en/analysis_visited.png"));
        label.setBackground(parent.getBackground());
        return label;
    }

    private static Label newDescriptionLabel(Composite parent, Font font) {
        Label label = new Label(parent, 64);
        GridData gd_lblNewLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblNewLabel.widthHint = 50;
        label.setLayoutData((Object)gd_lblNewLabel);
        label.setBackground(parent.getBackground());
        label.setFont(font);
        return label;
    }

    private static Control newSeparator(Composite parent) {
        Label label = new Label(parent, 0);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 1;
        label.setLayoutData((Object)layoutData);
        label.setBackground(parent.getBackground());
        return label;
    }

    private static void toggleVisible(Control control, boolean visible) {
        GridData gridData = (GridData)control.getLayoutData();
        gridData.exclude = !visible;
        control.setLayoutData((Object)gridData);
        control.setVisible(visible);
    }

    public GuidedAnalysisStageControl(Composite parent, int style) {
        super(parent, 0);
        this.setBackground(ColorConstants.white);
        GridLayout gridLayout = new GridLayout(1, false);
        this.setLayout((Layout)gridLayout);
        Font f = this.getFont();
        FontData data = f.getFontData()[0];
        this.smallFont = new Font((Device)this.getDisplay(), new FontData(data.getName(), data.getHeight() - 2, 0));
        this.mediumFont = new Font((Device)this.getDisplay(), new FontData(data.getName(), data.getHeight() - 1, 0));
        this.description = new Label((Composite)this, 64);
        GridData gd_description = new GridData(4, 0x1000000, true, false);
        gd_description.widthHint = 50;
        this.description.setLayoutData((Object)gd_description);
        this.description.setBackground(this.getBackground());
        this.description.setText("Description");
        this.description.setFont(this.mediumFont);
        Label label = new Label((Composite)this, 258);
        label.setBackground(this.getBackground());
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)layoutData);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GuidedAnalysisStageControl.this.disposeResources();
            }
        });
    }

    private void dispose(Font font) {
        if (font != null && !font.isDisposed()) {
            font.dispose();
        }
    }

    protected void disposeResources() {
        this.dispose(this.smallFont);
        this.dispose(this.mediumFont);
    }

    private void fixElementLists(int numSteps) {
        Control[] newControls = new Control[numSteps * 4];
        System.arraycopy(this.stepControls, 0, newControls, 0, Math.min(this.stepControls.length, newControls.length));
        if (numSteps * 4 > this.stepControls.length) {
            int i = this.stepControls.length / 4;
            while (i < numSteps) {
                newControls[i * 4] = GuidedAnalysisStageControl.newCompletedLabel(this);
                newControls[i * 4 + 1] = GuidedAnalysisStageControl.newButton(this, this.buttonListener);
                newControls[i * 4 + 2] = GuidedAnalysisStageControl.newDescriptionLabel(this, this.smallFont);
                newControls[i * 4 + 3] = GuidedAnalysisStageControl.newSeparator(this);
                ++i;
            }
        } else {
            int i = this.stepControls.length - 1;
            while (i >= newControls.length) {
                this.stepControls[i].dispose();
                --i;
            }
        }
        this.stepControls = newControls;
    }

    protected void runAction(Integer stepIndex) {
        ExpertSystem expertSystem = this.expertSystemStage.getExpertSystem();
        Session session = expertSystem.getSession();
        ExpertSystemStepAction action = this.expertSystemStage.getStepAction(stepIndex);
        IStatus status = action.perform(session);
        if (!Status.OK_STATUS.equals(status) && !Status.CANCEL_STATUS.equals(status)) {
            ViperExceptionHandler.logError("unable to perform expert system action " + (Object)((Object)action.getKind()));
        }
    }

    public IExpertSystemStage getExpertSystemStage() {
        return this.expertSystemStage;
    }

    public void setExpertSystemStage(IExpertSystemStage stage) {
        this.expertSystemStage = stage;
        this.description.setText(stage.getDescription(ResultOutput.UI));
        int numSteps = stage.getNumSteps();
        if (numSteps != this.stepControls.length / 4) {
            this.fixElementLists(numSteps);
        }
        int i = 0;
        while (i < numSteps) {
            CLabel completedLabel = (CLabel)this.stepControls[i * 4];
            Button button = (Button)this.stepControls[i * 4 + 1];
            Label stepDescription = (Label)this.stepControls[i * 4 + 2];
            String stepTitle = stage.getStepTitle(i);
            boolean completed = stage.isStepCompleted(i);
            boolean enabled = stage.canPerformStep(i);
            completedLabel.setText(stepTitle);
            button.setText(stepTitle);
            GuidedAnalysisStageControl.toggleVisible((Control)completedLabel, completed);
            GuidedAnalysisStageControl.toggleVisible((Control)button, !completed);
            button.setEnabled(enabled);
            String desc = stage.getStepDescription(i);
            boolean visible = desc != null;
            GuidedAnalysisStageControl.toggleVisible((Control)stepDescription, visible);
            GuidedAnalysisStageControl.toggleVisible(this.stepControls[i * 4 + 3], visible);
            if (visible) {
                stepDescription.setText(desc);
                stepDescription.setEnabled(enabled || completed);
            }
            button.setData((Object)new Integer(i));
            ++i;
        }
    }
}

