/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.eclipse.remote.internal.core.RemoteServicesDescriptor;

public class RemoteServicesImpl {
    public static final String REMOTE_SERVICES_EXTENSION_POINT_ID = "remoteServices";
    private static final Map<String, RemoteServicesDescriptor> fRemoteServicesById = Collections.synchronizedMap(new HashMap());
    private static final Map<String, RemoteServicesDescriptor> fRemoteServicesByScheme = Collections.synchronizedMap(new HashMap());

    private RemoteServicesImpl() {
    }

    public static RemoteServicesDescriptor getRemoteServiceDescriptorById(String id) {
        RemoteServicesImpl.retrieveRemoteServices();
        return fRemoteServicesById.get(id);
    }

    public static RemoteServicesDescriptor getRemoteServiceDescriptorByURI(URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null) {
            RemoteServicesImpl.retrieveRemoteServices();
            return fRemoteServicesByScheme.get(scheme);
        }
        return null;
    }

    public static List<RemoteServicesDescriptor> getRemoteServiceDescriptors() {
        RemoteServicesImpl.retrieveRemoteServices();
        ArrayList<RemoteServicesDescriptor> descriptors = new ArrayList<RemoteServicesDescriptor>();
        for (RemoteServicesDescriptor descriptor : fRemoteServicesById.values()) {
            if (descriptor.getId().equals("org.eclipse.remote.LocalServices")) continue;
            descriptors.add(descriptor);
        }
        Collections.sort(descriptors);
        return descriptors;
    }

    private static void retrieveRemoteServices() {
        if (fRemoteServicesById.isEmpty()) {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(RemoteCorePlugin.getUniqueIdentifier(), REMOTE_SERVICES_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    RemoteServicesDescriptor proxy = new RemoteServicesDescriptor(ce);
                    fRemoteServicesById.put(proxy.getId(), proxy);
                    fRemoteServicesByScheme.put(proxy.getScheme(), proxy);
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

