/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.output.MIShared;

public class SharedLibrary
extends CObject
implements ICDISharedLibrary {
    MIShared miShared;

    public SharedLibrary(Target target, MIShared slib) {
        super(target);
        this.miShared = slib;
    }

    public void setMIShared(MIShared slib) {
        this.miShared = slib;
    }

    public MIShared getMIShared() {
        return this.miShared;
    }

    public String getFileName() {
        return this.miShared.getName();
    }

    public BigInteger getStartAddress() {
        return MIFormat.getBigInteger(this.miShared.getFrom());
    }

    public BigInteger getEndAddress() {
        return MIFormat.getBigInteger(this.miShared.getTo());
    }

    public boolean areSymbolsLoaded() {
        return this.miShared.isRead();
    }

    public void loadSymbols() throws CDIException {
        Target target = (Target)this.getTarget();
        SharedLibraryManager mgr = ((Session)target.getSession()).getSharedLibraryManager();
        mgr.loadSymbols(target, new ICDISharedLibrary[]{this});
    }
}

