/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisResultDivergentBranch;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.analysis.AnalysisResultSharedAccess;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultUncoalescedGlobalMemory;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.editor.DivergentBranchManager;
import com.nvidia.viper.editor.GPRAccessManager;
import com.nvidia.viper.editor.GlobalAccessManager;
import com.nvidia.viper.editor.IViewerColumnsManager;
import com.nvidia.viper.editor.InstructionExecutionManager;
import com.nvidia.viper.editor.PCSamplingLatencyManager;
import com.nvidia.viper.editor.PCSamplingManager;
import com.nvidia.viper.editor.SharedAccessManager;
import com.nvidia.viper.editor.ViewerControl;
import java.util.Arrays;
import java.util.List;

public enum AnalysisResultSourceLevelKind {
    INSTRUCTION_EXECUTION_KIND(AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION, new InstructionExecutionManager(), new InstructionExecutionManager(), "Execution Count", AnalysisResultInstructionExecution.class),
    PC_SAMPLING_KIND(AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, new PCSamplingManager(), new PCSamplingManager(), "Warp State", AnalysisResultPCSampling.class),
    PC_SAMPLING_LATENCY_KIND(AnalysisStage.KERNEL_INSTANCE_PC_SAMPLING, new PCSamplingLatencyManager(), new PCSamplingLatencyManager(), "Latency Reasons", AnalysisResultPCSampling.class, "Kernel Profile - PC Sampling - Latency"),
    DIVERGENT_EXECUTION_KIND(AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, new DivergentBranchManager(), new DivergentBranchManager(), "Divergent Branch", AnalysisResultDivergentBranch.class),
    GLOBAL_ACCESS_KIND(AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, new GlobalAccessManager(), new GlobalAccessManager(), "Global Access", AnalysisResultUncoalescedGlobalMemory.class),
    SHARED_ACCESS_KIND(AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, new SharedAccessManager(), new SharedAccessManager(), "Shared Access", AnalysisResultSharedAccess.class),
    GENERAL_PURPOSE_REGISTER_KIND(null, null, new GPRAccessManager(), "Registers", null, "Register Pressure");

    private AnalysisStage analysisStage;
    private IViewerColumnsManager sourceColumnManager;
    private IViewerColumnsManager sassColumnManager;
    private String label;
    private String viewLabel;
    private Class<? extends AnalysisResultSourceLevel> classSourceLevelResult;

    private AnalysisResultSourceLevelKind(AnalysisStage stage, IViewerColumnsManager sourceColumnManager, IViewerColumnsManager sassColumnManager, String label, Class<? extends AnalysisResultSourceLevel> sourceLevelResult) {
        this(stage, sourceColumnManager, sassColumnManager, label, sourceLevelResult, null);
    }

    private AnalysisResultSourceLevelKind(AnalysisStage stage, IViewerColumnsManager sourceColumnManager, IViewerColumnsManager sassColumnManager, String label, Class<? extends AnalysisResultSourceLevel> sourceLevelResult, String viewLabel) {
        this.analysisStage = stage;
        this.sourceColumnManager = sourceColumnManager;
        this.sassColumnManager = sassColumnManager;
        this.label = label;
        this.classSourceLevelResult = sourceLevelResult;
        this.viewLabel = viewLabel;
    }

    public AnalysisStage getAnalysisStage() {
        return this.analysisStage;
    }

    public IViewerColumnsManager getColumnsManager(ViewerControl.ViewerControlType type) {
        if (type.equals((Object)ViewerControl.ViewerControlType.SOURCE_VIEWER_CONTOL)) {
            return this.sourceColumnManager;
        }
        return this.sassColumnManager;
    }

    public Class<? extends AnalysisResultSourceLevel> getSourceLevelResultClass() {
        return this.classSourceLevelResult;
    }

    public static List<AnalysisResultSourceLevelKind> getOrderedResults(int computeCapabilityMajor) {
        if (computeCapabilityMajor > 5) {
            return Arrays.asList(DIVERGENT_EXECUTION_KIND, GLOBAL_ACCESS_KIND, SHARED_ACCESS_KIND, INSTRUCTION_EXECUTION_KIND, PC_SAMPLING_KIND, PC_SAMPLING_LATENCY_KIND, GENERAL_PURPOSE_REGISTER_KIND);
        }
        return Arrays.asList(DIVERGENT_EXECUTION_KIND, GLOBAL_ACCESS_KIND, SHARED_ACCESS_KIND, INSTRUCTION_EXECUTION_KIND, PC_SAMPLING_KIND, GENERAL_PURPOSE_REGISTER_KIND);
    }

    public static List<AnalysisResultSourceLevelKind> getResultsMenu(int computeCapabilityMajor) {
        if (computeCapabilityMajor > 5) {
            return Arrays.asList(INSTRUCTION_EXECUTION_KIND, PC_SAMPLING_KIND, PC_SAMPLING_LATENCY_KIND, DIVERGENT_EXECUTION_KIND, GLOBAL_ACCESS_KIND, SHARED_ACCESS_KIND, GENERAL_PURPOSE_REGISTER_KIND);
        }
        return Arrays.asList(INSTRUCTION_EXECUTION_KIND, PC_SAMPLING_KIND, DIVERGENT_EXECUTION_KIND, GLOBAL_ACCESS_KIND, SHARED_ACCESS_KIND, GENERAL_PURPOSE_REGISTER_KIND);
    }

    public String getLabel() {
        return this.label;
    }

    public String getViewLabel() {
        if (this.viewLabel != null) {
            return this.viewLabel;
        }
        if (this.analysisStage != null) {
            return this.analysisStage.getLabel();
        }
        return "";
    }
}

