/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.birt.report.ReportTableData;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.report.util.SwingGraphicsObject;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.IAnalysisResultSVG;
import com.nvidia.viper.ui.analysis.InstructionExecutionDataTablePointer;
import com.nvidia.viper.ui.analysis.SVGGraphics2DUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class InstructionExecutionResultSVG
implements IAnalysisResultSVG {
    protected AnalysisResult result;
    protected Session activeSession;
    private static final int COMPONENTSPACE = 8;
    private static final int ROW_HEIGHT = 26;
    private static final int HEADER_SPACE = 2;
    private static final int NUM_LABELS = 9;
    private static final int NUM_COMPONENTS = 3;
    private static final int NUM_HEADERS = 2;
    private static final int INSET = 4;

    public InstructionExecutionResultSVG(AnalysisResult result, Session session) {
        this.activeSession = session;
        this.result = result;
    }

    protected DataGrid createTable(String[] str) {
        DataGrid table = new DataGrid(new InstructionExecutionDataTablePointer());
        this.setInput(str, table);
        return table;
    }

    private void setInput(String[] str, DataGrid table) {
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            table.addRow(st);
            ++n2;
        }
    }

    @Override
    public boolean createSVG(String filePath, int width, int height, GC gc) {
        return this.drawSVG(filePath, width, height, gc);
    }

    protected boolean drawSVG(String filePath, int width, int height, GC gc) {
        String svgNS;
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(svgNS = "http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        boolean drawn = this.paint(svgGenerator, gc, width, height);
        if (!drawn) {
            return false;
        }
        String chartName = filePath;
        Element svgElement = svgGenerator.getRoot();
        Attr widthAttr = document.createAttribute("width");
        widthAttr.setValue("100%");
        Attr heightAttr = document.createAttribute("height");
        heightAttr.setValue("100%");
        Attr viewBoxAttr = document.createAttribute("viewBox");
        viewBoxAttr.setValue("0 0 " + width + " " + height);
        svgElement.setAttributeNode(widthAttr);
        svgElement.setAttributeNode(heightAttr);
        svgElement.setAttributeNode(viewBoxAttr);
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(chartName), "UTF-8");
            svgGenerator.stream(svgElement, (Writer)out);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean paint(SVGGraphics2D svg2d, GC gc, int width, int height) {
        int currentX = 0;
        int currentY = 0;
        final SwingGraphicsObject wtgo = new SwingGraphicsObject((Graphics2D)svg2d, gc);
        wtgo.setForeground(SwingGraphicsObject.SwingToSWTColor(Color.BLACK, gc));
        int avgFontHeight = wtgo.getFontHeight();
        AnalysisResultInstructionExecution analysisResultInstExec = (AnalysisResultInstructionExecution)this.result;
        String[] funcNameList = analysisResultInstExec.getFunctionNameList(this.activeSession);
        if (funcNameList != null && funcNameList.length > 0) {
            wtgo.drawString("Cuda Fuctions :", currentX, currentY, true);
            final DataGrid table = this.createTable(funcNameList);
            height = table.computeHeight(wtgo);
            final Rectangle rect = new Rectangle(currentX, currentY += avgFontHeight + 2, width, height);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    table.paintDataGrid(wtgo, rect);
                }
            });
            wtgo.drawRectangle(currentX, currentY, width, height + 4);
            currentY += height + 8;
        }
        wtgo.drawString("Maximum instruction execution count in assembly: " + analysisResultInstExec.getMaxInstExecuted(this.activeSession), currentX, currentY, true);
        wtgo.drawString("Average instruction execution count in assembly: " + analysisResultInstExec.getAvgInstCount(this.activeSession), currentX, currentY += avgFontHeight, true);
        wtgo.drawString("Instructions executed for the kernel: " + analysisResultInstExec.getTotalInstExecuted(this.activeSession), currentX, currentY += avgFontHeight, true);
        wtgo.drawString("Thread instructions executed for the kernel: " + analysisResultInstExec.getTotalThreadInstExecuted(this.activeSession), currentX, currentY += avgFontHeight, true);
        wtgo.drawString("Non-predicated thread instructions executed for the kernel: " + analysisResultInstExec.getTotalNonPredThreadInstExecuted(this.activeSession), currentX, currentY += avgFontHeight, true);
        double warpNonPredEfficiency = analysisResultInstExec.getWarpNonPredEfficiency(this.activeSession);
        wtgo.drawString(String.format("Warp non-predicated execution efficiency of the kernel: %.1f%%", warpNonPredEfficiency), currentX, currentY += avgFontHeight, true);
        double warpEfficiency = analysisResultInstExec.getWarpEfficiency(this.activeSession);
        wtgo.drawString(String.format("Warp execution efficiency of the kernel: %.1f%%", warpEfficiency), currentX, currentY += avgFontHeight, true);
        currentY += avgFontHeight;
        currentY += 8;
        String[] srcFileNameList = analysisResultInstExec.getSourceFileNameList(this.activeSession);
        if (srcFileNameList != null && srcFileNameList.length > 0) {
            wtgo.drawString("Source files :", currentX, currentY, true);
            final DataGrid table = this.createTable(srcFileNameList);
            height = table.computeHeight(wtgo);
            final Rectangle rect = new Rectangle(currentX, currentY += avgFontHeight + 2, width, height);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    table.paintDataGrid(wtgo, rect);
                }
            });
            wtgo.drawRectangle(currentX, currentY, width, height + 4);
            currentY += height + 8;
        }
        return true;
    }

    @Override
    public int getPreferredSVGHieght(GC gc) {
        AnalysisResultInstructionExecution analysisResultInstExec = (AnalysisResultInstructionExecution)this.result;
        SVGGraphics2D svg2d = SVGGraphics2DUtils.getGenericSVGGraphics2D();
        int height = 0;
        int avgFontHeight = svg2d.getFontMetrics().getHeight();
        height = avgFontHeight * 9;
        height += 24;
        height += analysisResultInstExec.getSourceFileNameList(this.activeSession).length * 26;
        height += analysisResultInstExec.getFunctionNameList(this.activeSession).length * 26;
        return height += 4;
    }

    @Override
    public ReportTableData[] getTableElements() {
        return null;
    }
}

