/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.cuda.ide.util.ISourceIntegration;
import com.nvidia.cuda.ide.util.ISourceMarker;
import com.nvidia.viper.analysis.AnalysisSourceMarker;
import com.nvidia.viper.model.Session;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class CCFFMessage {
    private String fileName;
    private int lineNo;
    private String message;

    public CCFFMessage(Session session, String fileName, int lineNo, String message) {
        this.fileName = fileName;
        if (fileName.startsWith("./")) {
            fileName = fileName.substring(2);
        }
        this.lineNo = lineNo;
        this.message = message;
        List<CCFFMessage> messageList = session.getMessagesMap().get(fileName);
        if (messageList == null) {
            messageList = new ArrayList<CCFFMessage>();
        }
        messageList.add(this);
        session.getMessagesMap().put(fileName, messageList);
    }

    public static void addMarkers(Session session, ISourceIntegration sourceIntegration, URI sourceUri, String fileName) throws CoreException {
        List<CCFFMessage> messages;
        if (fileName.startsWith("./")) {
            fileName = fileName.substring(2);
        }
        if ((messages = session.getMessagesMap().get(fileName)) != null) {
            for (CCFFMessage message : messages) {
                AnalysisSourceMarker marker = new AnalysisSourceMarker(session, sourceUri, message.lineNo, message.message);
                sourceIntegration.addMarkers(null, new ISourceMarker[]{marker});
            }
        }
    }
}

