/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.util;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.IArchitectureObject;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.devices.CudaDevice;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class UiUtil {
    public static void createDevicesInformationLabel(Composite panel) {
        Architecture[] architectures = Architecture.all();
        ICudaDevice[] devices = CudaDevice.getDevices((boolean)true, null);
        GridData data = GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(1 + architectures.length, 1).create();
        if (devices.length > 0) {
            Text text = new Text(panel, 2114);
            if (devices.length == 1) {
                text.setText(String.format("%s is detected (compute capability %d.%d)", devices[0].getName(), devices[0].getVersionMajor(), devices[0].getVersionMinor()));
            } else {
                StringBuffer message = new StringBuffer("Following CUDA-compatible devices were detected on your system:");
                ICudaDevice[] iCudaDeviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    ICudaDevice device = iCudaDeviceArray[n2];
                    String msg = String.format("\n\t%s (compute capability %d.%d)", device.getName(), device.getVersionMajor(), device.getVersionMinor());
                    message.append(msg);
                    ++n2;
                }
                text.setText(message.toString());
            }
            text.setEnabled(false);
            text.setLayoutData((Object)data);
        } else {
            CLabel cLabel = new CLabel(panel, 0);
            cLabel.setText("No CUDA-compatible devices detected");
            cLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            cLabel.setLayoutData((Object)data);
        }
    }

    private static boolean isCompatible(int physical, int virtual, ICudaModule.Type type, ICudaDevice device, boolean separateCompilation) {
        Architecture architecture;
        int n;
        int n2;
        Architecture[] architectureArray;
        if (separateCompilation && device.getVersionMajor() < 2) {
            return false;
        }
        if (type == ICudaModule.Type.ptx && virtual == 0) {
            return UiUtil.match(device, Architecture.all()[0], false);
        }
        if (type == ICudaModule.Type.cubin && virtual == 0 && physical == 0) {
            return UiUtil.match(device, Architecture.all()[0], true);
        }
        if (type == ICudaModule.Type.fatbin && virtual == 0 && physical == 0) {
            return UiUtil.match(device, Architecture.all()[0], true) || UiUtil.match(device, Architecture.all()[0], false);
        }
        boolean result = false;
        if (type != ICudaModule.Type.ptx) {
            architectureArray = Architecture.decode(physical);
            n2 = architectureArray.length;
            n = 0;
            while (n < n2) {
                architecture = architectureArray[n];
                result = UiUtil.match(device, architecture, true);
                if (result) break;
                ++n;
            }
        }
        if (!result && type != ICudaModule.Type.cubin) {
            architectureArray = Architecture.decode(virtual);
            n2 = architectureArray.length;
            n = 0;
            while (n < n2) {
                architecture = architectureArray[n];
                result = UiUtil.match(device, architecture, false);
                if (result) break;
                ++n;
            }
        }
        return result;
    }

    private static boolean match(ICudaDevice device, Architecture architecture, boolean isphysical) {
        return architecture.compatible(device.getVersionMajor(), device.getVersionMinor(), isphysical);
    }

    public static IStatus validateCompatibility(ICudaModule.Type type, int phys, int virt, Boolean deviceCompilation) {
        IStatus result = Status.OK_STATUS;
        ICudaDevice[] devices = CudaDevice.getDevices((boolean)true, null);
        if (devices != null && devices.length > 0) {
            boolean warn = true;
            String label = "No compatible devices detected on your system";
            TreeSet<ICudaDevice> compatibleDevices = new TreeSet<ICudaDevice>(new DeviceComparator());
            TreeSet<ICudaDevice> incompatibleDevices = new TreeSet<ICudaDevice>(new DeviceComparator());
            ICudaDevice[] iCudaDeviceArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                ICudaDevice device = iCudaDeviceArray[n2];
                if (UiUtil.isCompatible(phys, virt, type, device, deviceCompilation)) {
                    compatibleDevices.add(device);
                } else {
                    incompatibleDevices.add(device);
                }
                ++n2;
            }
            if (!compatibleDevices.isEmpty()) {
                boolean needsComma = false;
                StringBuffer buffer = new StringBuffer("Compatible with ");
                for (ICudaDevice cudaDevice : compatibleDevices) {
                    if (needsComma) {
                        buffer.append(", ");
                    }
                    buffer.append(cudaDevice.getName());
                    needsComma = true;
                }
                if (!incompatibleDevices.isEmpty()) {
                    buffer.append(", not compatible with ");
                    needsComma = false;
                    for (ICudaDevice device : incompatibleDevices) {
                        if (needsComma) {
                            buffer.append(", ");
                        }
                        buffer.append(device.getName());
                    }
                }
                warn = false;
                label = buffer.toString();
            }
            result = new Status(warn ? 2 : 1, "com.nvidia.cuda.ide.build", label);
        }
        return result;
    }

    private UiUtil() {
    }

    public static GridLayout createNoMarginGrid(int columns) {
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    public static GridData createLayoutData(int columns) {
        return new GridData(4, 1, true, false, columns, 1);
    }

    public static void setModuleDefaults(IArchitectureObject executable) {
        Architecture[] all;
        ICudaDevice[] devices;
        TreeSet<Architecture> architectures = new TreeSet<Architecture>();
        ICudaDevice[] iCudaDeviceArray = devices = CudaDevice.getDevices((boolean)false, null);
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            ICudaDevice device = iCudaDeviceArray[n2];
            architectures.add(Architecture.get(device));
            ++n2;
        }
        if (architectures.isEmpty()) {
            architectures.add(Architecture.get(1, 0));
        }
        Architecture[] architectureArray = all = Architecture.all();
        int n3 = all.length;
        n = 0;
        while (n < n3) {
            Architecture architecture = architectureArray[n];
            if (architectures.contains(architecture)) {
                executable.enableArchitecture(architecture, true);
                executable.enableArchitecture(architecture.getVirtual(), false);
            } else {
                executable.disableArchitecture(architecture, true);
                executable.disableArchitecture(architecture, false);
            }
            ++n;
        }
        int majorSmVersion = ((Architecture)architectures.iterator().next()).major;
        executable.setDeviceLinkingEnabled(majorSmVersion >= 2);
    }

    public static void createPath(IResource resource) throws CoreException {
        if (!resource.exists()) {
            if (resource.getType() != 2) {
                throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.build", String.format("Cannot create resource %s - only folders can be created", resource.getFullPath())));
            }
            UiUtil.createPath((IResource)resource.getParent());
            ((IFolder)resource).create(false, true, null);
        }
    }

    private static final class DeviceComparator
    implements Comparator<ICudaDevice> {
        private DeviceComparator() {
        }

        @Override
        public int compare(ICudaDevice o1, ICudaDevice o2) {
            return (int)Math.signum(o1.getOrdinal() - o2.getOrdinal());
        }
    }
}

