/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Warp;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Lane
extends AbstractDMContext
implements ICudaRuntimeObject {
    private final short id;
    private final Warp warp;

    public Lane(Warp warp, short id) {
        super(warp.getSessionId(), new IDMContext[]{warp});
        this.warp = warp;
        this.id = id;
    }

    public short getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Lane) {
            return ((Lane)obj).getId() == this.getId() && ((Lane)obj).warp.equals(this.warp);
        }
        return false;
    }

    public int hashCode() {
        return this.baseHashCode() ^ (this.id << 28) + (this.id << 4);
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.getApplication().getLaneState(this, rm);
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitLane(this);
    }

    @Override
    public ElementType getType() {
        return ElementType.lane;
    }

    public String toString() {
        return String.format("%s lane %d", this.getParents()[0], this.id);
    }

    private ICudaApplication getApplication() {
        return (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)this, ICudaApplication.class);
    }

    @Override
    public void toHardwareElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    @Override
    public void toLogicalElement(final DataRequestMonitor<ICudaRuntimeObject> drm) {
        this.getState(new DataRequestMonitor<CudaRuntimeInformation>(ImmediateExecutor.getInstance(), drm){
            private DeviceThread thread;

            protected void handleSuccess() {
                try {
                    CudaRuntimeInformation information = (CudaRuntimeInformation)this.getData();
                    if (information.getState().isActive()) {
                        Kernel kernel = Lane.this.getApplication().getKernel(information.getKernelId());
                        Block block = kernel.getBlock(information.getBlockIdx());
                        this.thread = block.getThread(information.getThreadIdx());
                        drm.setData((Object)this.thread);
                    }
                }
                catch (CudaException e) {
                    drm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                }
                drm.done();
            }
        });
    }
}

