/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelVMNode;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelFont;
import com.nvidia.cuda.ide.debug.util.CudaObjectLabelImage;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.OccupancyImage;
import com.nvidia.cuda.ide.debug.util.RIRequestMonitor;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.ui.IMemento;

public final class BlockVMNode
extends AbstractCudaDMVMNode<Block> {
    private final boolean ignorePinned;
    private final ParentKind parentKind;

    private static LabelAttribute createConditionalFont() {
        return new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false);
    }

    private static LabelColumnInfo createLabelColumn(String label, String ... properties) {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText(label, properties), new CudaObjectLabelImage(CudaDebugImages.BLOCK, CudaDebugImages.BLOCK_INACTIVE), BlockVMNode.createConditionalFont(), new ConditionalLabelFont(true, false, "cuda_object_pinned")});
    }

    public static boolean isCdpTree() {
        return "device_kernels_child".equals(Activator.getDefault().getPreferenceStore().getString("device.kernels.mode"));
    }

    public static boolean isViewMode(String mode) {
        return mode.equals(Activator.getDefault().getPreferenceStore().getString("debug.view.cuda.layout"));
    }

    public BlockVMNode(AbstractDMVMProvider provider, ParentKind parentKind, DsfSession session, boolean ignorePinned) {
        super(provider, session, Block.class);
        this.parentKind = parentKind;
        this.ignorePinned = ignorePinned;
    }

    @Override
    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (this.isEnabled()) {
            super.buildDelta(event, parent, nodeOffset, requestMonitor);
        } else {
            requestMonitor.done();
        }
    }

    @Override
    protected boolean compareElement(Block object, IMemento memento) {
        Kernel kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)object, Kernel.class);
        if (KernelVMNode.isSameKernel(kernel, memento)) {
            return DebugUtil.compare(object.getBlockIdx(), memento, "MEMENTO_BLOCK_IDX");
        }
        return false;
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", BlockVMNode.createLabelColumn("{0}", "name"));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__SM, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#{2}}", new String[]{"is_active_i", "device_id", "sm_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#SM {2}}", new String[]{"is_active_i", "device_id", "sm_id"})}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#No running threads|1#1 thread of {1} is running|1<{0} threads of {1} are running}", new String[]{"active_block_threads", "block_size"}), BlockVMNode.createConditionalFont(), new OccupancyImage("block_size", "active_block_threads")}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", BlockVMNode.createLabelColumn("Block {0}{2,choice,0#|1# [sm: {1}]}", "name", "sm_id", "is_active_i"));
        return provider;
    }

    @Override
    protected void encodeElement(Block object, IMemento memento) {
        Kernel kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)object, Kernel.class);
        KernelVMNode.store(kernel, memento);
        memento.putString("MEMENTO_BLOCK_IDX", object.getBlockIdx().toString());
    }

    @Override
    public int getDeltaFlags(Object event) {
        if (!this.isEnabled()) {
            return 0;
        }
        if (event instanceof ModelProxyInstalledEvent) {
            return 0x100000;
        }
        return super.getDeltaFlags(event);
    }

    @Override
    protected String getInactiveElementRangeLabel(RangeContext rangeContext, boolean singleColumn) {
        Kernel kernel = null;
        IDMContext[] iDMContextArray = rangeContext.getParents();
        int n = iDMContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc = iDMContextArray[n2];
            kernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)dmc, Kernel.class);
            if (kernel != null) break;
            ++n2;
        }
        long start = rangeContext.getStart();
        long end = rangeContext.getEnd();
        ICoordSorter sorter = rangeContext.getSorter();
        if (kernel != null) {
            CudaDim dim = kernel.getGridDim();
            CudaCoord s = sorter.getCoord(dim, start);
            if (start == end) {
                return MessageFormat.format((String)(singleColumn ? "Block {0}" : "{0}"), (Object[])new Object[]{s});
            }
            return MessageFormat.format((String)(singleColumn ? "Blocks {0} - {1}" : "{0} - {1}"), (Object[])new Object[]{s, sorter.getCoord(dim, end)});
        }
        return MessageFormat.format((String)"Blocks {0} - {1}", (Object[])new Object[]{start, end});
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        long count = rangeContext.getEnd() - rangeContext.getStart() + 1L;
        return count == 1L ? "Inactive" : MessageFormat.format((String)"{0} inactive blocks", (Object[])new Object[]{count});
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.BLOCK_INACTIVE;
    }

    protected final IVMNode getParent() {
        IVMProvider provider = this.getVMProvider();
        IVMNode[] iVMNodeArray = provider.getAllVMNodes();
        int n = iVMNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMNode node = iVMNodeArray[n2];
            IVMNode[] iVMNodeArray2 = provider.getChildVMNodes(node);
            int n3 = iVMNodeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMNode child = iVMNodeArray2[n4];
                if (this == child) {
                    return node;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected final ICudaRuntimeObject getParentElement(IChildrenUpdate update) {
        KernelCallSite dmc = (KernelCallSite)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), KernelCallSite.class);
        ICudaRuntimeObject parent = dmc != null ? dmc.getParent() : (ICudaRuntimeObject)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), Kernel.class);
        return parent;
    }

    private boolean isEnabled() {
        return this.parentKind.isEnabled();
    }

    @Override
    protected boolean isLogicalNode() {
        return true;
    }

    @Override
    protected void selectOrExpand(IDMContext object, VMDelta parent, int nodeOffset, boolean collapseTheRest, RequestMonitor requestMonitor) {
        DeviceThread thread = (DeviceThread)(object instanceof DeviceThread ? object : DMContexts.getAncestorOfType((IDMContext)object, DeviceThread.class));
        if (!this.ignorePinned || thread == null || !DebugUtil.isPinnedOrRemembered(thread)) {
            super.selectOrExpand(object, parent, nodeOffset, collapseTheRest, requestMonitor);
        } else {
            requestMonitor.done();
        }
    }

    public String toString() {
        return "CudaBlockVMNode";
    }

    @Override
    public void update(IChildrenCountUpdate[] updates) {
        if (this.isEnabled()) {
            super.update(updates);
        } else {
            IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                update.setChildCount(0);
                update.done();
                ++n2;
            }
        }
    }

    @Override
    public void update(IChildrenUpdate[] updates) {
        if (!this.isEnabled()) {
            IChildrenUpdate[] iChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenUpdate update = iChildrenUpdateArray[n2];
                update.done();
                ++n2;
            }
        } else {
            super.update(updates);
        }
    }

    @Override
    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            update.setHasChilren(this.isEnabled());
            update.done();
            ++n2;
        }
    }

    @Override
    protected void updatePropertiesInSessionThread(final Block block, final IPropertiesUpdate update) {
        update.setProperty("name", (Object)block.getBlockIdx().toString());
        update.setProperty("cuda_object_pinned", (Object)block.hasExpandedThreads());
        update.setProperty("block_size", (Object)((Kernel)DMContexts.getAncestorOfType((IDMContext)block, Kernel.class)).getBlockDim().elementCount());
        if (update.getProperties().contains("active_block_threads")) {
            block.getActiveThreadCount(new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    Integer count = this.isSuccess() ? (Integer)this.getData() : Integer.valueOf(0);
                    update.setProperty("active_block_threads", (Object)count);
                    RIRequestMonitor.fill(update, (Executor)BlockVMNode.this.getSession().getExecutor(), block);
                }
            });
        } else {
            RIRequestMonitor.fill(update, (Executor)this.getSession().getExecutor(), block);
        }
    }

    public static enum ParentKind {
        ALL_THREADS,
        CDP_CALLSTACK,
        CUDA_INFORMATION_VIEW,
        KERNELS;


        public boolean isEnabled() {
            switch (this) {
                case CUDA_INFORMATION_VIEW: {
                    return true;
                }
                case ALL_THREADS: {
                    return BlockVMNode.isViewMode("debug_view_tree");
                }
                case KERNELS: {
                    return BlockVMNode.isViewMode("debug_view_flat");
                }
                case CDP_CALLSTACK: {
                    return !BlockVMNode.isCdpTree();
                }
            }
            return false;
        }
    }
}

