/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import java.util.Map;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jface.resource.ImageDescriptor;

public final class OccupancyImage
extends LabelAttribute {
    private final String[] propertyNames;

    public OccupancyImage(String allElementsProperties, String ... activeElementsProperties) {
        this.propertyNames = new String[activeElementsProperties.length + 1];
        this.propertyNames[0] = allElementsProperties;
        System.arraycopy(activeElementsProperties, 0, this.propertyNames, 1, activeElementsProperties.length);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
        int all = ((Number)properties.get(this.propertyNames[0])).intValue();
        int active = 0;
        int i = 1;
        while (i < this.propertyNames.length) {
            active += ((Number)properties.get(this.propertyNames[i])).intValue();
            ++i;
        }
        int occupancy = all > 0 ? active * 100 / all : 0;
        update.setImageDescriptor(OccupancyImage.getImage(occupancy), columnIndex);
    }

    private static ImageDescriptor getImage(int value) {
        if (value == 100) {
            return CudaDebugImages.OCCUPANCY_100.getDescriptor();
        }
        if (value > 75) {
            return CudaDebugImages.OCCUPANCY_90.getDescriptor();
        }
        if (value > 50) {
            return CudaDebugImages.OCCUPANCY_75.getDescriptor();
        }
        if (value > 25) {
            return CudaDebugImages.OCCUPANCY_50.getDescriptor();
        }
        if (value > 0) {
            return CudaDebugImages.OCCUPANCY_25.getDescriptor();
        }
        return CudaDebugImages.OCCUPANCY_00.getDescriptor();
    }
}

