#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$2" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$2" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$2" = sfcb
then
	/etc/init.d/sfcb stop
fi

$4/registration/OpenDRIM_Slot-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Card-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Rack-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalConnector-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalElementPackage-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalAssetConformsToProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Chassis-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalAssetRegisteredProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Chip-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SystemPackaging-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalElementInConnector-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalAssetCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalMemory-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalPackage-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ConfigurationCapacity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalPackageCapacity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Realizes-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ComputerSystemPackage-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalFrame-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ConnectedTo-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_PhysicalComponent-remove.sh $1 $2 $3 $4

if test "$2" = sfcb
then
	/etc/init.d/sfcb start
fi

