!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawcorloc
!! NAME
!! pawcorloc
!!
!! FUNCTION
!! Compute
!!  option=1 : local ionic potential and pseudo-core charge
!!  option>1 : contributions of local ionic potential and pseudo-core charge to...
!!     option=2 : ...gradient of E wrt xred
!!     option=3 : ...stress tensor
!!     option=4 : ...second gradient of E wrt xred
!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR, FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  if(option==3) dnqdq0(ntypat)=1/q d(tNcore(q))/dq for q=0
!!  if(option==3) eei=local pseudopotential part of total energy (hartree)
!!  gmet(3,3)=reciprocal space metric ($\textrm{Bohr}^{-2}$).
!!  gprimd(3,3)=reciprocal space dimensional primitive translations
!!  gsqcut=cutoff on $|G|^2$: see setup1 for definition (doubled sphere).
!!  mgfft=maximum size of 1D FFTs
!!  mpi_enreg=informations about MPI parallelization
!!  mqgrid=number of grid pts in q array for f(q) spline.
!!  n3xccc=dimension of the xccc3d array (0 or nfft).
!!  natom=number of atoms in unit cell.
!!  nattyp(ntypat)=number of atoms of each type in cell.
!!  ncspl(mqgrid,2,ntypat)=ncore(q) spline for each type of atom.
!!  nfft=(effective) number of FFT grid points (for this processor)
!!  ngfft(18)=contain all needed information about 3D FFT, see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  ntypat=number of types of atoms.
!!  option= (see above)
!!  ph1d(2,3*(2*mgfft+1)*natom)=1-dim structure factor phase information.
!!  qgrid(mqgrid)=q grid for spline from 0 to qmax.
!!  qprtrb(3)= integer wavevector of possible perturbing potential
!!   in basis of reciprocal lattice translations
!!  rhog(2,nfft)=electron density rho(G) (electrons/$\textrm{Bohr}^3$)
!!               (needed if option==2 or if option==4)
!!  ucvol=unit cell volume ($\textrm{Bohr}^3$).
!!  vlspl(mqgrid,2,ntypat)=q^2 v(q) spline for each type of atom.
!!  vprtrb(2)=complex amplitude of possible perturbing potential; if nonzero,
!!   perturbing potential is added of the form
!!   $V(G)=(vprtrb(1)+I*vprtrb(2))/2$ at the values G=qprtrb and
!!   $(vprtrb(1)-I*vprtrb(2))/2$ at $G=-qprtrb$ (integers)
!!  vxc(2,n3xccc)= xc potential (Hartree) in reciprocal space
!!                 (allocated if option/=1)
!!
!! OUTPUT
!!  (if option==1)
!!     vpsp(nfft)=local crystal pseudopotential in real space.
!!     xccc3d(n3xccc)=3D core electron density for XC core correction, bohr^-3
!!  (if option==2) unallocated if option/=2
!!     grtn(3,natom)=grads of Etot wrt tn.
!!     grxc(3,natom)=d(Exc)/d(xred) derivatives (0 without core charges)
!!  (if option==3) unallocated if option/=3
!!    lpsstr(6)=components of local psp part of stress tensor
!!              (Cartesian coordinates, symmetric tensor) in hartree/$\textrm{bohr}^3$
!!              Store 6 unique components in order 11, 22, 33, 32, 31, 21
!!    corstr(6)=components of core density part of stress tensor
!!  (if option==4) unallocated if option/=4
!!    dyfrlo(3,3,natom)=second derivatives of Etot wrt tn.
!!    dyfrx2(3,3,natom)=d2(Exc)/d(xred)2 derivatives (0 without core charges)
!!
!! NOTES
!! This routine comes from mklocl.F90
!!
!! PARENTS
!!      dyfro3,forces,prcref,setvtr,stress
!!
!! CHILDREN
!!      fourdp,leave_new,timab,wrtout,xcomm_init,xsum_mpi,zerosym
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawcorloc(corstr,dnqdq0,dyfrlo,dyfrx2,eei,gmet,gprimd,grtn,grxc,gsqcut,lpsstr,mgfft,&
&  mpi_enreg,mqgrid,n3xccc,natom,nattyp,ncspl,nfft,ngfft,ntypat,option,ph1d,&
&  qgrid,qprtrb,rhog,ucvol,vlspl,vprtrb,vpsp,vxc,xccc3d)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_13paw, except_this_one => pawcorloc
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mgfft,mqgrid,n3xccc,natom,nfft,ntypat,option
 real(dp),intent(in) :: eei,gsqcut,ucvol
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: nattyp(ntypat),ngfft(18),qprtrb(3)
 real(dp),intent(in) :: dnqdq0(ntypat*(4-option)*(option/3)),gmet(3,3),gprimd(3,3)
 real(dp),intent(in) :: ncspl(mqgrid,2,ntypat),ph1d(2,3*(2*mgfft+1)*natom)
 real(dp),intent(in) :: qgrid(mqgrid),rhog(2,nfft),vlspl(mqgrid,2,ntypat)
 real(dp),intent(in) :: vprtrb(2),vxc(2,n3xccc*((option+1)/3))
 real(dp),intent(out) :: dyfrlo(3,3,natom*(option/4))
 real(dp),intent(out) :: dyfrx2(3,3,natom*(option/4))
 real(dp),intent(out) :: corstr(6*(4-option)*(option/3))
 real(dp),intent(out) :: grtn(3,natom*(3-option)*(4-option)*(option/2)/2)
 real(dp),intent(out) :: grxc(3,natom*(3-option)*(4-option)*(option/2)/2)
 real(dp),intent(out) :: lpsstr(6*(4-option)*(option/3))
 real(dp),intent(out) :: vpsp(nfft),xccc3d(n3xccc)

!Local variables ------------------------------
!scalars
 integer,parameter :: im=2,re=1
 integer :: i1,i2,i3,ia,ia1,ia2,id1,id2,id3,ierr,ig1,ig1_,ig2,ig2_,ig3,ig3_,ii
 integer :: ir,ispden,itypat,jj,me_fft,me_g0,n1,n2,n3,nproc_fft,nri
 integer :: old_paral_level,shift1,shift2,shift3,spaceComm=0
 real(dp),parameter :: tolfix=1.0000001_dp
 real(dp) :: aa,bb,cc,core1,core2,cutoff,dbl_ig1,dbl_ig2,dbl_ig3,dd,diff,dq
 real(dp) :: dq2div6,dqdiv6,dqm1,ee,ff,gg,gmag,gsq,gsquar,hh,ph12i,ph12r,ph1i
 real(dp) :: ph1r,ph2i,ph2r,ph3i,ph3r,phim_igia,phre_igia,score,scorei,scorer
 real(dp) :: sfi,sfr,svion,svioni,svionr,term,termc,vion1,vion2,xnorm
 character(len=500) :: message
!arrays
 real(dp) :: gcart(3),tsec(2)
 real(dp),allocatable :: work1(:,:),work2(:,:)

! *************************************************************************

!Define G^2 based on G space metric gmet.
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: phim
#endif
!End of the abilint section

 gsq(i1,i2,i3)=dble(i1*i1)*gmet(1,1)+dble(i2*i2)*gmet(2,2)+&
& dble(i3*i3)*gmet(3,3)+dble(2*i1*i2)*gmet(1,2)+&
& dble(2*i2*i3)*gmet(2,3)+dble(2*i3*i1)*gmet(3,1)

!-----

!DEBUG
!write(6,*)' pawcorloc : enter '
!ENDDEBUG

 n1=ngfft(1) ; n2=ngfft(2) ; n3=ngfft(3)
 me_fft=ngfft(11)
 nproc_fft=ngfft(10)

!Zero out array to permit accumulation over atom types below:
 if(option==1)then
  allocate(work1(2,nfft));work1(:,:)=zero
  if (n3xccc>0) then
   allocate(work2(2,nfft));work2(:,:)=zero
  end if
 end if
!
 dq=(qgrid(mqgrid)-qgrid(1))/dble(mqgrid-1)
 dqm1=1.0_dp/dq
 dqdiv6=dq/6.0_dp
 dq2div6=dq**2/6.0_dp
 cutoff=gsqcut*tolfix
 id1=n1/2+2
 id2=n2/2+2
 id3=n3/2+2
 if (option==2) then
  grtn(:,:)=zero
  grxc(:,:)=zero
 end if
 if (option==3) then
  lpsstr(:)=zero
  corstr(:)=zero
 end if
 if (option==4) then
  dyfrlo(:,:,:)=zero
  dyfrx2(:,:,:)=zero
 end if

 ia1=1
 do itypat=1,ntypat
! ia1,ia2 sets range of loop over atoms:
  ia2=ia1+nattyp(itypat)-1

  ii=0
  do i3=1,n3
   ig3=i3-(i3/id3)*n3-1
   ig3_=ig3;if ((option==2.or.option==4).and.ig3_==(n3/2+1)) ig3_=0
   do i2=1,n2
    ig2=i2-(i2/id2)*n2-1
    ig2_=ig2;if ((option==2.or.option==4).and.ig2_==(n2/2+1)) ig2_=0
    if (((i2-1)/(n2/nproc_fft))==me_fft) then
     do i1=1,n1
      ig1=i1-(i1/id1)*n1-1
      ig1_=ig1;if ((option==2.or.option==4).and.ig1_==(n1/2+1)) ig1_=0

      ii=ii+1

      gsquar=gsq(ig1,ig2,ig3)
!     Skip G**2 outside cutoff:
      if (gsquar<=cutoff) then
       gmag=sqrt(gsquar)
       me_g0=0;if (ig1==0 .and. ig2==0 .and. ig3==0) me_g0=1

!      Compute vion(G) and core_charge(G) for given type of atom
       jj=1+int(gmag*dqm1)
       diff=gmag-qgrid(jj)

!      Evaluate spline fit:
!      (p. 86 Numerical Recipes, Press et al;
!            NOTE error in book for sign
!         of "aa" term in derivative; also see splfit routine).

       bb = diff*dqm1
       aa = 1.0_dp-bb
       cc = aa*(aa**2-1.0_dp)*dq2div6
       dd = bb*(bb**2-1.0_dp)*dq2div6
       if (me_g0==1) then
        vion1 = zero
       else
        vion1 = (aa*vlspl(jj,1,itypat)+bb*vlspl(jj+1,1,itypat) +&
&                cc*vlspl(jj,2,itypat)+dd*vlspl(jj+1,2,itypat) ) &
&                                                       / gsquar
       end if
       if (n3xccc>0) &
&       core1 = (aa*ncspl(jj,1,itypat)+bb*ncspl(jj+1,1,itypat) +&
&                cc*ncspl(jj,2,itypat)+dd*ncspl(jj+1,2,itypat) )

       if(option==1)then
!       Assemble structure factor over all atoms of given type:
        sfr=zero
        sfi=zero
        do ia=ia1,ia2
         shift1=1+n1+(ia-1)*(2*n1+1)
         shift2=1+n2+(ia-1)*(2*n2+1)+natom*(2*n1+1)
         shift3=1+n3+(ia-1)*(2*n3+1)+natom*(2*n1+1+2*n2+1)
         ph1r=ph1d(1,ig1+shift1);ph1i=ph1d(2,ig1+shift1)
         ph2r=ph1d(1,ig2+shift2);ph2i=ph1d(2,ig2+shift2)
         ph3r=ph1d(1,ig3+shift3);ph3i=ph1d(2,ig3+shift3)
         ph12r=ph1r*ph2r-ph1i*ph2i
         ph12i=ph1r*ph2i+ph1i*ph2r
         phre_igia=ph12r*ph3r-ph12i*ph3i
         phim_igia=ph12r*ph3i+ph12i*ph3r
         sfr=sfr+phre_igia
         sfi=sfi-phim_igia
        end do
!       Multiply structure factor times vion:
        work1(re,ii)=work1(re,ii)+sfr*vion1
        work1(im,ii)=work1(im,ii)+sfi*vion1
        if (n3xccc>0) then
         work2(re,ii)=work2(re,ii)+sfr*core1
         work2(im,ii)=work2(im,ii)+sfi*core1
        end if

       else if(option==2.or.option==4)then
        dbl_ig1=dble(ig1_);dbl_ig2=dble(ig2_);dbl_ig3=dble(ig3_)
!       Compute Re and Im part of (2Pi)*Vion(G)*rho(G):
        svionr=(two_pi*vion1)*rhog(re,ii)
        svioni=(two_pi*vion1)*rhog(im,ii)
!       Compute Re and Im part of (2Pi)*ncore(G)*vxc(G):
        if (n3xccc>0) then
         scorer=(two_pi*core1)*vxc(re,ii)
         scorei=(two_pi*core1)*vxc(im,ii)
        end if
!       Loop over all atoms of this type:
        do ia=ia1,ia2
         shift1=1+n1+(ia-1)*(2*n1+1)
         shift2=1+n2+(ia-1)*(2*n2+1)+natom*(2*n1+1)
         shift3=1+n3+(ia-1)*(2*n3+1)+natom*(2*n1+1+2*n2+1)
         ph1r=ph1d(1,ig1+shift1);ph1i=ph1d(2,ig1+shift1)
         ph2r=ph1d(1,ig2+shift2);ph2i=ph1d(2,ig2+shift2)
         ph3r=ph1d(1,ig3+shift3);ph3i=ph1d(2,ig3+shift3)
         ph12r=ph1r*ph2r-ph1i*ph2i
         ph12i=ph1r*ph2i+ph1i*ph2r
         phre_igia=ph12r*ph3r-ph12i*ph3i
         phim_igia=ph12r*ph3i+ph12i*ph3r
         if(option==2)then
!         Compute "Vion" and "core charge" part of gradient
!         svion=svioni*phre(ig1,ig2,ig3,ia)+svionr*phim(ig1,ig2,ig3,ia)
          svion=svioni*phre_igia+svionr*phim_igia
          if (n3xccc>0) score=scorei*phre_igia+scorer*phim_igia
!         Open loop over 3-index for speed:
          grtn(1,ia)=grtn(1,ia)-dbl_ig1*svion
          grtn(2,ia)=grtn(2,ia)-dbl_ig2*svion
          grtn(3,ia)=grtn(3,ia)-dbl_ig3*svion
          if (n3xccc>0) then
           grxc(1,ia)=grxc(1,ia)-dbl_ig1*score
           grxc(2,ia)=grxc(2,ia)-dbl_ig2*score
           grxc(3,ia)=grxc(3,ia)-dbl_ig3*score
          end if
         else
!         Compute "Vion" and "core charge" part of the second derivative
!         svion=two_pi*(svionr*phre(ig1,ig2,ig3,ia)-svioni*phim(ig1,ig2,ig3,ia))
          svion=two_pi*(svionr*phre_igia-svioni*phim_igia)
          if (n3xccc>0) score=two_pi*(scorer*phre_igia-scorei*phim_igia)
!         Open loop over 3-index for speed
          dyfrlo(1,1,ia)=dyfrlo(1,1,ia)-dbl_ig1*dbl_ig1*svion
          dyfrlo(1,2,ia)=dyfrlo(1,2,ia)-dbl_ig1*dbl_ig2*svion
          dyfrlo(1,3,ia)=dyfrlo(1,3,ia)-dbl_ig1*dbl_ig3*svion
          dyfrlo(2,2,ia)=dyfrlo(2,2,ia)-dbl_ig2*dbl_ig2*svion
          dyfrlo(2,3,ia)=dyfrlo(2,3,ia)-dbl_ig2*dbl_ig3*svion
          dyfrlo(3,3,ia)=dyfrlo(3,3,ia)-dbl_ig3*dbl_ig3*svion
          if (n3xccc>0) then
           dyfrx2(1,1,ia)=dyfrx2(1,1,ia)-dbl_ig1*dbl_ig1*score
           dyfrx2(1,2,ia)=dyfrx2(1,2,ia)-dbl_ig1*dbl_ig2*score
           dyfrx2(1,3,ia)=dyfrx2(1,3,ia)-dbl_ig1*dbl_ig3*score
           dyfrx2(2,2,ia)=dyfrx2(2,2,ia)-dbl_ig2*dbl_ig2*score
           dyfrx2(2,3,ia)=dyfrx2(2,3,ia)-dbl_ig2*dbl_ig3*score
           dyfrx2(3,3,ia)=dyfrx2(3,3,ia)-dbl_ig3*dbl_ig3*score
          end if
         end if
        end do

       else if(option==3)then
!       Also get (dV(q)/dq)/q:
!       (note correction of Numerical Recipes sign error
!                                    before (3._dp*aa**2-1._dp)
!       ee*dqm1 + ff*dqdiv6 is the best estimate of dV(q)/dq from splines
        if (me_g0==1) then
         vion2 = zero
        else
         ee= vlspl(jj+1,1,itypat)-vlspl(jj,1,itypat)
         ff=  (3._dp*bb**2-1._dp)*vlspl(jj+1,2,itypat) &
&           - (3._dp*aa**2-1._dp)*vlspl(jj,2,itypat)
         vion2 = ( ( ee*dqm1 + ff*dqdiv6 )/gmag&
&                 - 2.0_dp*vion1                 ) / gsquar
        end if
!       Get (dNcore(q)/dq)/q:
        if (n3xccc>0) then
         if (me_g0==1) then
          core2 = dnqdq0(itypat)
         else
          gg= ncspl(jj+1,1,itypat)-ncspl(jj,1,itypat)
          hh=  (3._dp*bb**2-1._dp)*ncspl(jj+1,2,itypat) &
&            - (3._dp*aa**2-1._dp)*ncspl(jj,2,itypat)
          core2 = (gg*dqm1 + hh*dqdiv6)/gmag
         end if
        end if
        gcart(1)=gprimd(1,1)*dble(ig1)+gprimd(1,2)*dble(ig2)+&
&                gprimd(1,3)*dble(ig3)
        gcart(2)=gprimd(2,1)*dble(ig1)+gprimd(2,2)*dble(ig2)+&
&                gprimd(2,3)*dble(ig3)
        gcart(3)=gprimd(3,1)*dble(ig1)+gprimd(3,2)*dble(ig2)+&
&                gprimd(3,3)*dble(ig3)
!       Assemble structure over all atoms of given type
        sfr=zero
        sfi=zero
        do ia=ia1,ia2
         shift1=1+n1+(ia-1)*(2*n1+1)
         shift2=1+n2+(ia-1)*(2*n2+1)+natom*(2*n1+1)
         shift3=1+n3+(ia-1)*(2*n3+1)+natom*(2*n1+1+2*n2+1)
         ph1r=ph1d(1,ig1+shift1);ph1i=ph1d(2,ig1+shift1)
         ph2r=ph1d(1,ig2+shift2);ph2i=ph1d(2,ig2+shift2)
         ph3r=ph1d(1,ig3+shift3);ph3i=ph1d(2,ig3+shift3)
         ph12r=ph1r*ph2r-ph1i*ph2i
         ph12i=ph1r*ph2i+ph1i*ph2r
         phre_igia=ph12r*ph3r-ph12i*ph3i
         phim_igia=ph12r*ph3i+ph12i*ph3r
         sfr=sfr+phre_igia
         sfi=sfi-phim_igia
        end do
!       Compute Re( rho^*(G)* sf ) * [(dV(G)/dG)/|G|]
        term=(rhog(re,ii)*sfr+rhog(im,ii)*sfi)*vion2
!       Compute Re( vxc^*(G)* sf ) * [(dV(G)/dG)/|G|]
        if (n3xccc>0) termc=(vxc(re,ii)*sfr+vxc(im,ii)*sfi)*core2
!       Compute contribution to stress tensor
        lpsstr(1)=lpsstr(1)-term*gcart(1)*gcart(1)
        lpsstr(2)=lpsstr(2)-term*gcart(2)*gcart(2)
        lpsstr(3)=lpsstr(3)-term*gcart(3)*gcart(3)
        lpsstr(4)=lpsstr(4)-term*gcart(3)*gcart(2)
        lpsstr(5)=lpsstr(5)-term*gcart(3)*gcart(1)
        lpsstr(6)=lpsstr(6)-term*gcart(2)*gcart(1)
        if (n3xccc>0) then
         corstr(1)=corstr(1)-termc*gcart(1)*gcart(1)
         corstr(2)=corstr(2)-termc*gcart(2)*gcart(2)
         corstr(3)=corstr(3)-termc*gcart(3)*gcart(3)
         corstr(4)=corstr(4)-termc*gcart(3)*gcart(2)
         corstr(5)=corstr(5)-termc*gcart(3)*gcart(1)
         corstr(6)=corstr(6)-termc*gcart(2)*gcart(1)
        end if

       else

        write(message, '(a,a,a,a,i5,a)' ) ch10,&
&        ' pawcorloc : BUG -',ch10,&
&        '  Option=',option,' not allowed.'
        call wrtout(06,message,'COLL')
        call leave_new('COLL')

!      End option choice
       end if

!     End skip G**2 outside cutoff:
      end if

!    End loop on n1, n2, n3. There is a "cycle" inside the loop
     end do
    end if ! this plane is for me_fft
   end do
  end do

 !Symmetrize the dynamical matrix with respect to indices
  if (option==4) then
   do ia=ia1,ia2
    dyfrlo(2,1,ia)=dyfrlo(1,2,ia)
    dyfrlo(3,1,ia)=dyfrlo(1,3,ia)
    dyfrlo(3,2,ia)=dyfrlo(2,3,ia)
   end do
   if (n3xccc>0) then
    do ia=ia1,ia2
     dyfrx2(2,1,ia)=dyfrx2(1,2,ia)
     dyfrx2(3,1,ia)=dyfrx2(1,3,ia)
     dyfrx2(3,2,ia)=dyfrx2(2,3,ia)
    end do
   end if
  end if

  ia1=ia2+1

!End loop on type of atoms
 end do

 if(option==1)then
! Allow for the addition of a perturbing potential
  if ((vprtrb(1)**2+vprtrb(2)**2) > 1.d-30) then
!  Find the linear indices which correspond with the input
!  wavevector qprtrb
!  The double modulus handles both i>=n and i<0, mapping into [0,n-1];
!  then add 1 to get range [1,n] for each
   i3=1+mod(n3+mod(qprtrb(3),n3),n3)
   i2=1+mod(n2+mod(qprtrb(2),n2),n2)
   i1=1+mod(n1+mod(qprtrb(1),n1),n1)
!  Compute the linear index in the 3 dimensional array
   ii=i1+n1*((i2-me_fft*n2/nproc_fft-1)+(n2/nproc_fft)*(i3-1))
!  Add in the perturbation at G=qprtrb
   work1(re,ii)=work1(re,ii)+0.5_dp*vprtrb(1)
   work1(im,ii)=work1(im,ii)+0.5_dp*vprtrb(2)
!  Same thing for G=-qprtrb
   i3=1+mod(n3+mod(-qprtrb(3),n3),n3)
   i2=1+mod(n2+mod(-qprtrb(2),n2),n2)
   i1=1+mod(n1+mod(-qprtrb(1),n1),n1)
!   ii=i1+n1*((i2-1)+n2*(i3-1))
   work1(re,ii)=work1(re,ii)+0.5_dp*vprtrb(1)
   work1(im,ii)=work1(im,ii)-0.5_dp*vprtrb(2)
   write(message, '(a,1p,2e12.4,a,0p,3i4,a)' )&
&    ' pawcorloc: perturbation of vprtrb=', vprtrb,&
&    ' and q=',qprtrb,' has been added'
   call wrtout(06,message,'COLL')
  end if
! work1/work2: non-symetrized non-zero elements have to be nullified
  call zerosym(work1,2,mpi_enreg,n1,n2,n3)
  if (n3xccc>0) call zerosym(work2,2,mpi_enreg,n1,n2,n3)
! Transform back to real space
  call fourdp(1,work1,vpsp,1,mpi_enreg,nfft,ngfft,0)
  if (n3xccc>0) call fourdp(1,work2,xccc3d,1,mpi_enreg,nfft,ngfft,0)
! Divide by unit cell volume
  xnorm=1.0_dp/ucvol
  vpsp(:)=vpsp(:)*xnorm
  if (n3xccc>0) xccc3d(:)=xccc3d(:)*xnorm
  deallocate(work1);if (n3xccc>0) deallocate(work2)
 end if

 if(option==2)then
  if(mpi_enreg%paral_compil_fft==1)then
   old_paral_level=mpi_enreg%paral_level
   mpi_enreg%paral_level=3
   call xcomm_init(mpi_enreg,spaceComm)
   if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
   call timab(48,1,tsec)
   call xsum_mpi(grtn,spaceComm ,ierr)
   if (n3xccc>0) call xsum_mpi(grxc,spaceComm ,ierr)
   call timab(48,2,tsec)
   mpi_enreg%paral_level=old_paral_level
  end if
 end if

 if(option==3)then
  if(mpi_enreg%paral_compil_fft==1)then
   old_paral_level=mpi_enreg%paral_level
   mpi_enreg%paral_level=3
   call xcomm_init(mpi_enreg,spaceComm)
   if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
   call timab(48,1,tsec)
   call xsum_mpi(lpsstr,spaceComm ,ierr)
   if (n3xccc>0) call xsum_mpi(corstr,spaceComm ,ierr)
   call timab(48,2,tsec)
   mpi_enreg%paral_level=old_paral_level
  end if
! Normalize and add term -eei/ucvol on diagonal
  lpsstr(1)=(lpsstr(1)-eei)/ucvol
  lpsstr(2)=(lpsstr(2)-eei)/ucvol
  lpsstr(3)=(lpsstr(3)-eei)/ucvol
  lpsstr(4)=lpsstr(4)/ucvol
  lpsstr(5)=lpsstr(5)/ucvol
  lpsstr(6)=lpsstr(6)/ucvol
  if (n3xccc>0) corstr(:)=corstr(:)/ucvol
 end if

 if(option==4)then
  if(mpi_enreg%paral_compil_fft==1)then
   old_paral_level=mpi_enreg%paral_level
   mpi_enreg%paral_level=3
   call xcomm_init(mpi_enreg,spaceComm)
   if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
   call timab(48,1,tsec)
   call xsum_mpi(dyfrlo,spaceComm ,ierr)
   if (n3xccc>0) call xsum_mpi(dyfrx2,spaceComm ,ierr)
   call timab(48,2,tsec)
   mpi_enreg%paral_level=old_paral_level
  end if
 end if

end subroutine pawcorloc
!!***
