; Event Macros Library
;
; Copyright (C) 2020 Kestrel Institute (http://www.kestrel.edu)
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Author: Alessandro Coglio (coglio@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "ACL2")

(include-book "fail-event")

(include-book "kestrel/utilities/orelse" :dir :system)
(include-book "std/util/define" :dir :system)
(include-book "system/pseudo-event-formp" :dir :system)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define try-event (form ctx erp val (msg msgp))
  :returns (event pseudo-event-formp)
  :parents (event-macros)
  :short "Try to submit an event,
          generating a customized error if the submission fails."
  :long
  (xdoc::topstring
   (xdoc::p
    "This is useful to &ldquo;replace&rdquo; the error generated by an event
     (e.g. a @(tsee defun) or a @(tsee defthm))
     with a customized soft error.
     The event is submitted with all output off (including error output),
     so there is no output if the submission succeeds.
     If the submission fails,
     @(tsee orelse) is used to submit a @(tsee fail-event) to cause an error
     with the specified context, flag, value, and message."))
  `(orelse
    (with-output :gag-mode nil :off :all ,form)
    (fail-event ,ctx ,erp ,val ,msg)))
