; Poseidon Library
;
;    Copyright 2024 Provable Inc.
;
;    Licensed under the Apache License, Version 2.0 (the "License");
;    you may not use this file except in compliance with the License.
;    You may obtain a copy of the License at
;
;      http://www.apache.org/licenses/LICENSE-2.0
;
;    Unless required by applicable law or agreed to in writing, software
;    distributed under the License is distributed on an "AS IS" BASIS,
;    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;    See the License for the specific language governing permissions and
;    limitations under the License.

; Authors: Alessandro Coglio (www.alessandrocoglio.info)
;          Eric McCarthy (bendyarm on GitHub)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "POSEIDON")

(include-book "rate-4-alpha-17")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Tests.
; Checked against the snarkVM console Rust implementation.

(assert-equal
 (hash4 '())
 1044346838034619416100171813313106342224256770546574686139345274096660160611)

(assert-equal
 (hash4 '(0))
 6531918078649604677267704629524208386557917803204512136246020129886969612813)

(assert-equal
 (hash4 '(1))
 4426996492654533614386079842002262353437097961897230015892590642692830916891)

(assert-equal
 (hash4 '(0 1))
 3515567246660071748861271187713830429704652891229797018766869690557265012151)

(assert-equal
 (hash4 '(7 6))
 6569866994757293255004300918458370975674559167201047636575858551784982288595)

(assert-equal
 (hash4 '(3801852864665033841774715284518384682376829752661853198612247855579120198106
          8354898322875240371401674517397790035008442020361740574117886421279083828480
          4810388512520169167962815122521832339992376865086300759308552937986944510606))
 87141345289194987249335251035288105774877062220257664575645549134632926482)

(assert-equal
 (hash4 '(3801852864665033841774715284518384682376829752661853198612247855579120198106
          8354898322875240371401674517397790035008442020361740574117886421279083828480
          4810388512520169167962815122521832339992376865086300759308552937986944510606
          1806278863067630397941269234951941896370617486625414347832536440203404317871))
 7213538381157479600695819072074313481664544179359574938537072092346114865618)

(assert-equal
 (hash4 '(3801852864665033841774715284518384682376829752661853198612247855579120198106
          8354898322875240371401674517397790035008442020361740574117886421279083828480
          4810388512520169167962815122521832339992376865086300759308552937986944510606
          1806278863067630397941269234951941896370617486625414347832536440203404317871
          4017177598231920767921734423139954103557056461408532722673217828464276314809))
 5481099192588700791287898101517060190977970633110857260811993991553610949275)
