# ---------------------------------------------------------------------------
# - MTH0101.als                                                             -
# - afnix:mth module algebra test unit                                      -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2012 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   real matrix test unit
# @author amaury darsch

# get the module
interp:library "afnix-mth"

# create a simple square matrix
const rm (afnix:mth:Rmatrix 2)

# check predicate
assert true (afnix:mth:rmi-p rm)
assert true (afnix:mth:r-matrix-p rm)

# check representation
assert "Rmatrix" (rm:repr)

# check matrix size and elements
assert 2 (rm:get-row-size)
assert 2 (rm:get-col-size)

# check accessors
assert 0.0 (rm:get 0 0)
rm:set 0 0 1.0
assert 1.0 (rm:get 0 0)

assert 0.0 (rm:get 0 1)
assert 0.0 (rm:get 1 0)

assert 0.0 (rm:get 1 1)
rm:set 1 1 1.0
assert 1.0 (rm:get 1 1)

# create a working vector
const xv (afnix:mth:Rvector 2)
xv:set 0 2.0
xv:set 0 3.0

# test the matrix operators
const bv (* rm xv)
assert true (xv:?= bv)
