/***************************************************************************
 *   copyright       : (C) 2003-2011 by Pascal Brachet                     *
 *   http://www.xm1math.net/texmaker/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "algoconsole.h"
#include <QScrollBar>
#include <QAction>
#include <QMenu>
#include <QDebug>

AlgoConsole::AlgoConsole(QWidget *parent) :
	QTextEdit(parent)
{
setFocusPolicy(Qt::WheelFocus);
setTextInteractionFlags(Qt::TextSelectableByMouse|Qt::TextSelectableByKeyboard);
    isLocked = true;
    answer="";
    prompt="";
}


void AlgoConsole::contextMenuEvent(QContextMenuEvent *e)
{
QMenu *menu=new QMenu(this);
//menu = createStandardContextMenu();
QAction *a;


a = menu->addAction(tr("Copy"), this, SLOT(copy()));
a->setShortcut(Qt::CTRL+Qt::Key_C);
a->setEnabled(textCursor().hasSelection());

a = menu->addAction(tr("Select All"), this, SLOT(selectAll()));
a->setShortcut(Qt::CTRL+Qt::Key_A);
a->setEnabled(!document()->isEmpty());

menu->exec(e->globalPos());
delete menu;
}

void AlgoConsole::keyPressEvent(QKeyEvent *event)
{
    if(isLocked) return;
    QString t=event->text();
    QChar l;
    if (t.count()>0) 
    {
      l=t.at(0);
      if (l.isLetterOrNumber() || l.isPrint()) 
	{
	QTextEdit::keyPressEvent(event);
	return;
	}
    }
    if(event->key() >= 0x20 && event->key() <= 0x7e
       && (event->modifiers() == Qt::NoModifier || event->modifiers() == Qt::ShiftModifier))
	QTextEdit::keyPressEvent(event);
#if (QT_VERSION >= 0x040700)
    if(event->key() == Qt::Key_Backspace
       && event->modifiers() == Qt::NoModifier
       && textCursor().positionInBlock() > prompt.length())
	QTextEdit::keyPressEvent(event);
#else
    if(event->key() == Qt::Key_Backspace
       && event->modifiers() == Qt::NoModifier
       && (textCursor().position()-textCursor().block().position()> prompt.length()))
	QTextEdit::keyPressEvent(event);
#endif
    if(event->key() == Qt::Key_Return && event->modifiers() == Qt::NoModifier)
	onEnter();
    if(event->key() == Qt::Key_Enter)
	onEnter();
}

void AlgoConsole::onEnter()
{
#if (QT_VERSION >= 0x040700)
    if(textCursor().positionInBlock() == prompt.length())
    {
	return;
    }
#else
    if(textCursor().position()-textCursor().block().position() == prompt.length())
    {
	return;
    }
#endif
    answer = textCursor().block().text().mid(prompt.length());
    isLocked = true;
    textCursor().insertBlock();
    scrollDown();
    emit done();
}

void AlgoConsole::output(QString s)
{
    prompt=s+" ";
    if (!textCursor().block().text().isEmpty()) textCursor().insertBlock();
    textCursor().insertText(prompt);
    scrollDown();
    setFocus();
    isLocked = false;
    answer="";
}

void AlgoConsole::scrollDown()
{
    QScrollBar *vbar = verticalScrollBar();
    vbar->setValue(vbar->maximum());
}

void AlgoConsole::mouseMoveEvent(QMouseEvent *e)
{
if (isLocked) QTextEdit::mouseMoveEvent(e);
}
