# Were any of the Bolshevik oppositions a real alternative?

As well as the obvious failure of the Russian Revolution (see [section
H.6](secH6.md)), the limitations in Bolshevism can be seen by the various
oppositions to the mainstream of that party. That Bolshevik politics are not a
suitable instrument for working class self-liberation is expressed in the
limited way opposition groups questioned Bolshevik orthodoxy -- even in the
case of the opposition to the rising Stalinist bureaucracy.

All were based on standard vanguardist positions, as discussed in [section
H.5](secH5.md), such as a privileged position for the party, reflected in
the aim for party power and, inevitably, the Bolshevik monopoly of power. This
meant their opposition was focused on seeking reforms in areas which did not
question the role and position of the party (such as economic policy) or
sought to strengthen it (against the bureaucracy). This does not mean that the
various oppositions did not have valid points, just that they shared the key
assumptions of Bolshevism which undermined the Russian revolution either by
their application or their use to justify specific (usually highly
authoritarian) practice.

We will not cover all the various oppositions with the Bolshevik party here
(Robert V. Daniels' **The Conscience of the Revolution** discusses all of them
in some detail, as does Leonard Schapiro's **The Origin of the Communist
Autocracy** ). We will concentrate on the "Left Communists" of 1918 (in
[section 1](append45.md#app1)), the "Workers' Opposition" of 1920-1 (in
[section 2](append45.md#app2)) and the Trotsky-led "Left Opposition" of
1923-7 (in [section 3](append45.md#app3)) . Each opposition is a pale
reflection of the one before it and each had clear limitations in their ideas
which fatally undermined any liberatory potential they had. Indeed, by the
time of the "Left Opposition" we are reduced to simply the more radical
faction of the state and party bureaucracy fighting the dominant faction with
the aim of securing a benevolent state capitalist dictatorship.

As noted, certain elements of these oppositions were undoubtedly correct. So,
for example, the (correct) arguments of the "Left Communists" against Lenin's
policy of _"one-man management"_ were echoed by the "Democratic Centralists"
at the Ninth Party Congress (an opposition we do not cover here). One member
of this grouping (which included such former "Left Communists" as Osinsky)
argued against Lenin's position in favour of appointed managers inside and
outside the party as follows:

> _"The Central Committee finds that the [local] party committee is a
> bourgeois prejudice, is conservatism bordering on the province of treason,
> and that the new form is the replacement of party committees by political
> departments, the heads of which by themselves replace the elected committees
> . . . You transform the members of the party into an obedient gramophone,
> with leaders who order: go and agitate; but they haven't the right to elect
> their own committee, their own organs._

> _"I then put the question to comrade Lenin: Who will appoint the Central
> Committee? You see, there can be individual authority here as well. Here
> also a single commander can be appointed."_ [Sapronov, quoted by Daniels,
> **Op. Cit.** , p. 114]

Obviously a man ahead of his time. As Stalin proved, if _"one-man management"_
was such a good idea then why should it not be practised in the Council of
People's Commissars?

So these oppositions did identify real problems and many of their policies had
elements of real solutions within them. Yet, as discussed in [section
H.3.5](secH3.md#sech35), placing certain libertarian ideas within an overall
centralised vision or system will not undermine its wider authoritarian
nature. Most obviously, the Bolshevik preference (at least before embracing
party dictatorship after 1917) for centralised "democracy" effectively
hollowed out the real democracy at the base which makes it more than just
picking masters and created the structures and social relationships which made
further degeneration inevitable -- the very problems the oppositions
themselves raised but whose real roots evaded them.

Here we indicate the positive ideas of the various oppositions but also
indicate their limitations, which flow from the fact these are **Bolshevik**
oppositions and so shared a similar set of prejudices and vision of
(centralised) socialism.

Finally, to contrast these fake "oppositions" with a genuine opposition, we
will discuss (in [section 4](append45.md#app4)) the "Workers' Group" which
was expelled from the Communist Party of 1922-3 and repressed under Lenin and
Trotsky. This grouping stood for traditional socialist values, including many
of the principles the Bolshevik party claimed to support before it seized
power (such as workers' democracy) and some it did not (such as workers' self-
management of production). We do so to indicate the limited nature of the
previous oppositions and how the repression of a **genuine** dissident working
class group within the Communist Party shows how deeply unlibertarian and so
anti-socialist the real Bolshevik tradition is.

## 1 Were the "Left Communists" of 1918 an alternative?

The first opposition of note in the party to the Leninist mainstream was that
of the "Left Communists" in early 1918. This was clustered around the
Bolshevik leader Bukharin and was focused around opposition to the Brest-
Litovsk peace treaty with Germany and Lenin's advocacy of _"state capitalism"_
as the means of both building socialism and getting Russia out of its economic
problems. Here we focus of the latter issue, namely their critique of Lenin's
economic policies and its limitations. In addition, we will discuss the flaws
in their political ideas.

The first issue of their theoretical journal **Kommunist** was published in
April 1918 and it argued vigorously against Lenin's advocacy of _"one-man
management"_ and _"state capitalism"_ as necessary and immediate steps for the
new regime. It warned of _"bureaucratic centralisation, the rule of various
commissars, the loss of independence for local Soviets and in practice the
rejection of the type of state-commune administered from below"_ if Lenin's
policies were continued to be followed. The second issue saw an article by
Osinsky which correctly predicted that _"for the construction of the
proletarian society by the class creativity of the workers themselves, not by
the Ukases of the captains of industry . . . If the proletariat itself does
not know how to create the necessary prerequisites for the socialist
organisation of labour, no one can do this for it and no one can compel it to
do this. The stick, if raised against the workers, will find itself in the
hands of a social force which is either under the influence of another social
class or is in the hands of the soviet power; but the soviet power will then
be forced to seek support against the proletariat from another class (e.g. the
peasantry) and by this it will destroy itself as the dictatorship of the
proletariat. Socialism and socialist organisation will be set up by the
proletariat itself, or they will not be set up at all: something else will be
set up -- state capitalism."_ [quoted by Brinton, **The Bolsheviks and
Workers' Control** , p. 39]

Lenin reacted sharply, heaping insult upon insult on the "Left Communists" and
arguing against their ideas. Rather than see self-management (or even workers'
control) as the key, he argued forcefully that _" **economically** , state
capitalism is immeasurably superior to our present economic system."_ He
linked this with his previous writings, correctly noting his _"'high'
appreciation of state capitalism"_ had been given _" **before** the Bolsheviks
seized power"_ in, amongst other works, his **State and Revolution** and so it
was _"significant that [his opponents] did **not** emphasise **this** "_. For
Lenin, _"Socialism is inconceivable without large scale capitalist
engineering"_ and _"without planned state organisation, which keeps tens of
millions of people to the strictest observance of a unified standard in
production and distribution."_ Thus _"our task is to study the state
capitalism of the Germans, to spare **no effort** in copying it and not shrink
from adopting **dictatorial** methods to hasten the copying of it."_ [
**Collected Works** , vol. 27, p. 339, p. 341, p. 354, p. 339 and p. 340]

For Lenin, as long as a workers' party held **political** power, the working
class need not fear _"state capitalism"_ and the lack of economic power at the
point of production. Ignoring the awkward fact that it was the Bolsheviks
rather than the proletariat who held political power, Lenin failed to realise
that without economic power working class political power would be fatally
undermined. Unfortunately, Lenin's arguments carried the day (see [section
H.3.14](secH3.md#sech314)) and, in practice, the net effect was simply to
hand over the economy to the state bureaucracy and create the social
relationships which Stalinism thrived upon. As such, the merit of the "Left
Communists" can be seen.

However, the "Left Communists", while correct on socialism needing workers'
economic self-management, were limited in other ways. The major problems were
three-fold.

Firstly, by basing themselves on Bolshevik orthodoxy they allowed Lenin to
dominate the debate. This meant that their more "libertarian" reading of
Lenin's work could be nullified by Lenin himself pointing to the authoritarian
and state capitalist aspects of those very same works. Which is ironic, as
today most Leninists tend to point to these very same democratic sounding
aspects of Lenin's ideas while downplaying the more blatant anti-socialist
ones. Given that Lenin had dismissed such approaches himself during the debate
against the "Left Communists" in 1918, it seems dishonest for his latter day
followers to do this.

Secondly, their perspective on the role of the party undermined their
commitment to true workers' power and freedom. This can be seen from the
comments of Sorin, a leading member of the group, who argued that the "Left
Communists" were _"the most passionate proponents of soviet power, but . . .
only so far as this power does not degenerate . . . in a petty-bourgeois
direction."_ [quoted by Ronald I. Kowalski, **The Bolshevik Party in
Conflict** , p. 135] For them, like any Bolshevik, the party played the key
role for it was the only true bastion of the interests of the proletariat and,
as such, the party _"is in every case and everywhere superior to the soviets .
. . The soviets represent labouring democracy in general; and its interest,
and in particular the interests of the petty bourgeois peasantry, do not
always coincide with the interests of the proletariat."_ [quoted by Richard
Sakwa, **Soviet Communists in Power** , p. 182]

Thus soviet power was limited to approval of the party line and -- as with
Lenin -- any deviation from that line could be denounced as _"petty
bourgeois"_ and, therefore, ignored. _"Ironically,"_ Kowalski summarises,
_"Sorin's call for a revived soviet democracy was becoming vitiated by the
dominant role assigned, in the final analysis, to the party."_ [ **Op. Cit.**
, p. 136] Thus their politics were just as authoritarian as the mainstream
Bolshevism they attacked on other issues:

> _"Ultimately, the only criterion that they appeared able to offer was to
> define 'proletarian' in terms of adherence to their own policy prescriptions
> and 'non-proletarian' by non-adherence to them. In consequence, all who
> dared to oppose them could be accused either of being non-proletarian, or at
> the very least suffering from some form of 'false consciousness' -- and in
> the interests of building socialism must recant or be purged from the party.
> Rather ironically, beneath the surface of their fine rhetoric in defence of
> the soviets, and of the party as 'a forum for all of proletarian democracy,'
> there lay a political philosophy that was arguably as authoritarian as that
> of which they accused Lenin and his faction."_ [Kowalski, **Op. Cit.** , pp.
> 136-7]

_"According to the "Left Communists", therefore,"_ notes Richard Sakwa, _"the
party was the custodian of an interest higher than that of the soviets.
Earlier theoretical considerations on the vanguard role of the party,
developed in response to this problem, were confirmed by the circumstances of
Bolshevism in power. The political dominance of the party over the soviets
encouraged an administrative one as well. Such a development was further
encouraged by the emergence of a massive and unwieldy bureaucratic apparatus
in 1918 . . . The "Left Communists" and the party leadership were therefore in
agreement that . . . the party should play a tutelary role over the soviets."_
Furthermore, _"[w]ith such a formulation it proved difficult to maintain the
vitality of the soviet plenum as the soviet was controlled by a party
fraction, itself controlled by a party committee outside the soviet."_ [ **Op.
Cit.** , p. 182 and p. 182-3]

This position can be traced back to the fundamentals of Bolshevism (see
[section H.5](secH5.md) on vanguardism). With this ideological preference
for party power and the ideological justification for ignoring soviet
democracy, it is doubtful that their (correct) commitment to workers' economic
self-management would have been successful. An economic democracy combined
with what amounts to a party dictatorship would be an impossibility that could
never work in practice.

As such, the fact that Bukharin (one time "Left Communist") _"continued to
eulogise the party's dictatorship, sometimes quite unabashedly"_ during and
after the civil war becomes understandable. In this, he was not being extreme
but rather expressing the orthodoxy, for _"Bolsheviks no longer bothered to
disclaim that the dictatorship of the proletariat was the 'dictatorship of the
party'"_ for _"class immaturity was not a peculiarity of the Russian
proletariat, but a characteristic of proletarian revolutions in general."_
[Stephen F. Cohen, **Bukharin and the Bolshevik Revolution** , p. 145 and p.
142] So by 1921, all the leading Bolsheviks had argued this position for some
time (see [section H.1.2](secH1.md#sech12), for example). Bukharin even went
so far as to argue that _"the watchword"_ taken up by some workers ( _"even
metal workers"_!) of _"For class dictatorship, but against party
dictatorship!"_ showed that the proletariat _"was declassed."_ This also
indicated that a _"misunderstanding arose which threatened the whole system of
the proletarian dictatorship."_ [contained in Al Richardson (ed.), **In
Defence of the Russian Revolution** , p. 192] The echoes of the positions
argued before the civil war can be seen in Bukharin's glib comment that
proletarian management of the revolution meant the end of the "proletarian"
dictatorship!

Thirdly, while correctly stressing the need for workers' management and
participation the "Left Communists" placed it within a centralised
institutional context which nullified it. Incorrectly proclaiming that
anarchists aimed at turning all workplaces into the property of their
workforce, the "Left Communists" argued for a typically Marxist (centralised)
alternative:

> _"It was Bukharin who developed this theme most cogently. In the final
> analysis, the basic distinction between Communists and Anarchists, he
> argued, was not their attitude to the state and its power. While they
> disagreed regarding the role it was to play in the transition period -- the
> Communists ascribed to it a vital role -- both sought its ultimate
> extinction. Rather, what fundamentally divided them was that Communists were
> convinced that only a centrally-planned economy, in which large-scale
> production was predominant, would be able to provide the material basis of
> abundance, on which alone socialism could be founded."_ [Kowalski, **Op.
> Cit.** , p. 111]

Ignoring the akward anarchist advocate no such thing -- see [section
I.3.8](secI3.md#seci38) \-- we will simply note that this typically Marxist
position would lead to a new class system. So while Osinskii argued that
workplaces would be run by boards elected by workers, but **not** composed of
a majority of workers employed in a given enterprise, these would elect
regional economic councils, which in turn would create a central economic
council and it is the higher bodies which would have the power to affirm or
veto those bodies below them: _"in the final analysis the authorities at the
lower levels would have to be overridden. Osinskii and his fellow-thinkers
were compelled to assign the ultimate power of economic decision making to the
centre, as their conception of the economics of socialism demanded."_ In
short, they _"did not comprehend that their conception of central planning was
incompatible with the devolution of authority to the shop floor that they
aspired to"_ and so it is hard not to conclude that the _"ideological
preconceptions of the Left Communists would have spawned a centralised,
bureaucratic system, not an emancipated society in which power was diffused to
the workers."_ [Kowalski, **Op. Cit.** , p. 113, p. 186 and p. 188]

This is unsurprising, given the fact that the "Left Communists" were Marxists,
with a vision of socialism inherited from Marx based on a centralised plan.
Thus we find Osinskii in 1918 defining his vision as _"state socialism, i.e. a
centralised system of socialised production, monopolised product distribution
and planned utilisation of labour."_ [quoted by Silvana Malle, **The Economic
Organization of War Communism 1918-1921** , p. 297] Like other Marxists, they
seemed unaware of the bureaucracy needed to gather and process the necessary
(overwhelming) data to create a plan as well as the means of implementing it.
As we discuss in [section H.3.13](secH3.md#sech313), such a system would be
the very state-capitalism the "Left Communists" correctly railed against: _"we
are by every means -- by nationalisation, by centralisation -- strangling the
forces in our country. The masses are being cut off from living creative power
in all branches of our national economy."_ [Lomov, quoted by Carmen Sirianni,
**Workers Control and Socialist Democracy** , p. 155] Combine this with the
privileged role of the party and all the conditions were there to ensure a
similar outcome to that created by the Leninist mainstream -- even if,
ironically, the "Left Communists" were the most vocal in denouncing the
inevitable bureaucratic inefficiencies and abuses of the centralised system
they both shared.

Finally, how this conflict within the party was resolved is significant, given
that the banning of factions (which is generally seen as a key cause in the
rise of Stalinism) occurred in 1921 (a ban, incidentally, Trotsky defended
throughout the early 1920s). As one historian notes:

> _"The resolution of the party controversy in the spring of 1918 set a
> pattern that was to be followed throughout the history of the Communist
> Opposition in Russia. This was the settlement of the issues not by
> discussion, persuasion, or compromise, but by a high-pressure campaign in
> the party organisations, backed by a barrage of violent invective in the
> party press and in the pronouncements of the party leaders. Lenin's polemics
> set the tone, and his organisational lieutenants brought the membership into
> line."_ [Daniels, **Op. Cit.** , p. 87]

Indeed, _"[s]oon after the party congress had approved the peace [of Brest-
Litovsk in the spring of 1918], a Petrograd city party conference produced a
majority for Lenin. It ordered the suspension of the newspaper **Kommunist**
which had been serving as a Left Communist organ . . . The fourth and final
issue of the Moscow **Kommunist** had to be published as a private factional
paper rather than as the official organ of a party organisation."_ Ultimately,
_"[u]nder the conditions of party life established by Lenin, defence of the
Opposition position became impossible within the terms of Bolshevik
discipline."_ [Daniels, **Op. Cit.** , p. 88 and p. 89] So much for faction
rights -- three years **before** they were officially prohibited in the 10th
Party Congress!

In addition, the "Left Communists" were not defeated by those with superior
ideas winning the debate. Rather, Lenin's arguments _"evinced caricatured
distortion of their positions, evasiveness, and bitter invective more than
principled confrontation and clarification of opposing positions."_. For
example, _"[b]y selectively quoting Osinsky's article so as to make it appear
that the Left Communist opposed all labour discipline, he was able to avoid
confronting their concrete proposals for work norms and self-discipline by
democratically elected workers organisations."_ Lenin _"caricatured"_ other
ideas, so _"[c]ompletely misrepresenting"_ them while in other cases _"not a
word"_ was uttered in reply to their critique. [Carmen Sirianni, **Workers
Control and Socialist Democracy** , pp. 149-50] A similar response befell the
other oppositions discussed here -- whether under Lenin or under Stalin.

In this, though, Lenin was hardly being original. In May 1907 Lenin had
defended himself within the party for the rhetoric he had used against a group
of Mensheviks, arguing that the _"wording is calculated to evoke in the reader
hatred, aversion and contempt . . . Such wording is calculated not to
convince, but to break up the ranks of the opponent . . . to destroy him . . .
to evoke the worse thoughts, the worst suspicions about the opponent."_ This
was part of a struggle to _"struggle to **destroy** the hostile organisation,
destroy its influence over the masses of the proletariat."_ [ **Collected
Works** , Vol. 12, pp. 424-5 and p. 427]

Should we be surprised that such techniques should be utilised **within** the
party when necessary? Ultimately, as well as exposing how Lenin's economic
ideas helped build the bureaucratic state capitalism Stalinism was born from,
the saga of the "Left Communists" shows how the polemical and organisational
techniques of Stalinism also did not fall from the sky.

## 2 What were the limitations of the "Workers' Opposition" of 1920?

The next major group of party dissidents were the "Workers' Opposition" of
late 1920 and early 1921 (not to be confused with the opposition of **actual**
workers to the regime -- see [section H.6.3](secH6.md#sech63)). Lead by
Alexandra Kollontai and Alexander Shlyapnikov, this grouping is better known
than other early oppositions simply because it was the focus for much debate
at the tenth party congress in March 1921 and its existence was a
precipitating factor in the banning of factions within the Communist Party.
Also, the manifesto Kollontai wrote for the group was translated by council
communists in Britain and elsewhere.

Unlike the "Left Communists" (see the [last section](append45.md#app1)),
their support for party dictatorship was more than logically implied, it was
taken for granted. Their manifesto fails to mention political democracy at
all, instead discussing exclusively economic and party democracy. Thus it was
expressing the _"basis on which, in its opinion, the dictatorship of the
proletariat must rest in the sphere of industrial reconstruction"_ , for the
_"whole controversy boils down to one basic question: who shall build the
communist economy, and how shall it be build?"_ [ **Selected Writings of
Alexandra Kollontai** , p. 161 and p. 173]

Kollontai was right to state that the working class _"can alone be the creator
of communism"_ and to ask the question of _"shall we achieve communism through
the workers or over their heads, by the hands of Soviet officials?"_ The
answer was correct, arguing for the former and _" **see[ing] in the unions the
managers and creators of the communist economy**."_ This would be _"a system
of self-activity for the masses"_ for _"the building of Communism can and must
be the work of the toiling masses themselves."_ In short: _" **it is
impossible to decree communism.** "_ [ **Op. Cit.** , p. 176, p. 174, p. 182,
p. 200 and p. 199]

Economically, then, the "Workers' Opposition" had much to recommend it for it
raised ideas long argued by anarchists. Yet, as with the "Left Communists",
these positive ideas are undermined by a typically Marxist centralised
institutional framework in which industrial unions _"elect the central body
directing the whole economic life of the republic."_ [Kollontai, **Op. Cit.**
, p. 176] As such, the arguments raised in the [previous
section](append45.md#app1) apply, namely that the centralised regime within
which these ideas would be applied would nullify them and end up producing a
new class system around the bureaucrats such a system requires.

Likewise with their political ideas. The group did not seek actual workers'
democracy for the _"task of the Party at its present crisis"_ is to _"lend its
ear to the healthy class call of the wide working masses"_ but _"correction of
the activity of the Party"_ meant _"going back to democracy, freedom of
opinion, and criticism inside the Party."_ The struggle was _"to destroy
bureaucracy in the party and replace it by workers' democracy"_ : _"for
establishing democracy in the party, and for the elimination of all
bureaucracy"_. [Kollontai, **Op. Cit.** , p. 172, p. 192 and p. 197] Its
demands were solely concerning the internal regime of the party, **not** a
call for wider democratic reforms in the state or society as a whole:

> _"The arguments of Kollontai were . . . strictly limited in their appeal to
> the communist party . . . Nor did they in any form criticise the domination
> of the communist minority over the majority of the proletariat. The
> fundamental weakness of the case of the Workers' Opposition was that, while
> demanding more freedom of initiative for the workers, it was quite content
> to leave untouched the state of affairs in which a few hundred thousand
> imposed their will on many millions. 'And since when have we been enemies of
> **komitetchina** [manipulation and control by communist party committees], I
> should like to know?' Shlyapnikov asked at the Tenth Party Congress. He went
> on to explain that the trade union congress in which, as he and his
> followers proposed, all control of industry should be vested would 'of
> course' be composed of delegates nominated and elected 'through the party
> cells, as we always do.' But he argued that the local trade union cells
> would ensure the election of men qualified by experience and ability in
> place of those who are 'imposed on us at present' by the centre. Kollontai
> and her supporters had no wish to disturb the communist party's monopoly of
> political power."_ [Leonard Schapiro, **The Origin of the Communist
> Autocracy** , p. 294]

Thus they _"sought to preserve the Bolshevik monopoly of power, condoning the
use of terror whenever necessary to accomplish this. They limited their
demands to internal party reforms, and never advocated sharing political
authority with other socialist organisations."_ Indeed, Kollontai _"declared
that the Workers' Opposition were among the first volunteers to go fight the
[Kronstadt] rebels"_ , who had raised the demand for soviet democracy (see
appendix ["What was the Kronstadt Rebellion?"](append42.md) for more
information). [Paul Avrich, **Kronstadt 1921** , pp. 182-3]

Even this extremely limited demand for more economic democracy was too much
for Lenin. In January 1921, he argued that the Bolsheviks _"have now added to
our platform the following: We must combat the ideological discord and the
unsound elements of the opposition who talk themselves into repudiating all
'militarisation of industry', and not only the 'appointments method', which
has been the prevailing one up to now, but all 'appointments', that is, in the
last analysis, repudiating the Party's leading role in relation to the non-
Party masses. We must combat the syndicalist deviation, which will kill the
Party unless it is entirely cured of it."_ Indeed, _"syndicalist deviation . .
. leads to the collapse of the dictatorship of the proletariat."_ [
**Collected Works** , Vol. 32, p. 53 and p. 86] Maurice Brinton correctly
notes that by this Lenin meant that _"working class power ('the dictatorship
of the proletariat') is impossible if there are militants in the Party who
think the working class should exert more power in production ('the
syndicalist deviation')."_ Moreover, _"Lenin here poses quite clearly the
question of 'power of the Party' or 'power of the class.' He unambiguously
opts for the former -- no doubt rationalising his choice by equating the two.
But he goes even further. He not only equates 'workers power' with the rule of
the Party. He equates it with acceptance of the ideas of the Party leaders!"_
[ **The Bolsheviks and Workers Control** , p. 76]

The "Workers' Opposition," asserted Lenin was a _"syndicalist and anarchist
deviation"_ produced partly by _"the influx into the Party of former
Mensheviks, and also of workers and peasants who have not yet fully
assimilated the communist world outlook."_ Their ideas on economic reform were
_"radically wrong in theory, and represent a complete break with Marxism and
communism, with the practical experience of all semi-proletarian revolutions
and of the present proletarian revolution."_ [Lenin, **Op. Cit.** , pp. 245-6]
Significantly, the _"basic arguments of the Opposition were not dealt with in
any depth"_ at the tenth party congress. _"What argument -- as distinct from
invective -- there was, was often confused,"_ Maurice Brinton summarises.
_"For instance, apart from being (a) 'genuinely counter-revolutionary' and (b)
'objectively counter-revolutionary', the Workers' Opposition was also 'too
revolutionary'. Their demands were 'too advanced' and the Soviet Government
still had to concentrate on overcoming the masses' cultural backwardness.
According to Smilga the extreme demands (of the Workers' Opposition) disrupted
the Party's efforts and raised hopes among the workers which could only be
disappointed. But, most important, the demands of the Workers' Opposition were
revolutionary in a wrong (anarcho-syndicalist) way. This was the ultimate
anathema."_ [ **Op. Cit.** , p. 79]

For Lenin, the idea of industrial democracy was a nonsense. In this he was
simply repeating the perspective he had held from the spring of 1918. As he
put it, it was _"a term that lends itself to misinterpretations. It may be
read as a repudiation of dictatorship and individual authority."_ Industry, he
argued, _"is indispensable, democracy is not"_ and _"on no account must we
renounce dictatorship either."_ Indeed, _"[i]ndustry is indispensable,
democracy is a category proper only to the political sphere"._ He did admit
_"[t]hat [the opposition] has been penetrating into the broad masses is
evident"_ , however the _"bidding for or flirtation with the non-Party
masses"_ was a _"radical departure from Marxism."_ _"Marxism teaches,"_ he
stressed, _"and this tenet has not only been formally endorsed by the whole
Communist International in the decisions of the Second (1920) Congress of the
Comintern on the role of the political party of the proletariat, but has also
been confirmed in practice by our revolution -- that only the political party
of the working class, i.e. the Communist Party, is capable of uniting,
training and organising a vanguard of the proletariat . . . . that alone will
be capable of withstanding the inevitable petty-bourgeois vacillation of this
mass . . . Without this the dictatorship of the proletariat is impossible."_ [
**Collected Works** , vol. 31, p. 82, p. 27, p. 26, p. 197 and p. 246] In
other words, _"Marxism"_ teaches that workers' democracy and protest (the only
means by which _"vacillation"_ can be expressed) is a danger to the
_"dictatorship of the proletariat"_ \-- see [section H.5.3](secH5.md#sech53)
on why this position is the inevitable outcome of vanguardism.

In a way, Lenin was correct for economic democracy combined with political
dictatorship would be a contradiction. Trotsky recognised this contradiction
at the Tenth Congress when attacking the "Workers' Opposition": _"Formally
speaking this [the creation of factory committees] is indeed the clearest line
of workers' democracy. But we are against it. Why? For a basic reason, to
preserve the party's dictatorship, and for subordinate reasons: management
would be inefficient."_ [quoted by Alec Nove, _"Trotsky, collectivization and
the five year plan,"_ **Socialism, Economics and Development** , p. 100] In
terms of his _"subordinate"_ reason, it should suffice to note the waste and
inefficency in the economy which occurred after he and Lenin imposed _"one-man
management"_ and the _"militarisation of labour"_ (see [section
H.6.2](secH6.md#sech62)).

It should be stressed that this opposition and the debate it provoked occurred
after the end of the Civil War. The Whites under Wrangel had been defeated in
November 1920 and the Russian revolution was no longer in immediate danger. As
such, there was an opportunity for constructive activity and mass
participation in the rebuilding of Russia. The leading Bolsheviks rejected
such demands, even in the limited form advocated by the "Workers' Opposition".
Lenin and Trotsky clearly saw **any** working class participation as a danger
to their power. Against the idea of economic participation under Communist
control raised by the "Workers' Opposition", the leading Bolsheviks favoured
the New Economic Policy (NEP). This was a return to the same kind of market-
based _"state capitalist"_ strategy Lenin had advocated against the "Left
Communists" **before** the outbreak of the civil war in May 1918 (and, as
noted, he had argued for in 1917). This shows a remarkable consistency in
Lenin's thoughts, suggesting that claims the policies he advocated and
implemented in power were somehow the opposite of what he "really" wanted are
weak.

As with the "Left Communists" of 1918, Lenin saw his opposition to the
"Workers' Opposition" as reflecting the basic ideas of his politics. _"If we
perish,"_ he said privately at the time according to Trotsky, _"it is all the
more important to preserve our ideological line and give a lesson to our
continuators. This should **never** be forgotten, even in **hopeless**
circumstances."_ [quoted by Daniels, **Op. Cit.** , p. 147] Thus the
opposition to even limited economic democracy was the lesson -- along with
party dictatorship -- he wished his followers to learn:

> _"the dictatorship of the proletariat cannot be exercised through an
> organisation embracing the whole of the class, because in all capitalist
> countries (and not only over here, in one of the most backward) the
> proletariat is still so divided, so degraded, and so corrupted in parts . .
> . that an organisation taking in the whole proletariat cannot directly
> exercise proletarian dictatorship. It can be exercised only by a vanguard .
> . . Such is the basic mechanism of the dictatorship of the proletariat, and
> the essentials of transition from capitalism to communism . . . for the
> dictatorship of the proletariat cannot be exercised by a mass proletarian
> organisation."_ [Lenin, **Op. Cit.** , vol. 32, p. 21]

In short, the proletariat having **economic** power would undermine "the
dictatorship of the proletariat":

> _"To govern you need an army of steeled revolutionary Communists. We have
> it, and it is called the Party. All this syndicalist nonsense about
> mandatory nominations of producers must go into the wastepaper basket. To
> proceed on those lines would mean thrusting the Party aside and making the
> dictatorship of the proletariat in Russia impossible."_ [Lenin, **Op. Cit.**
> , p. 21]

In summary, like the "Left Communists", the "Workers' Opposition" presented a
platform of economic and internal party reforms rooted in the assumption of
Bolshevik party domination. Such a policy would be too contradictory to be
applied: either the economic reforms would remain a dead letter under party
control or the economic reforms would provoke demands for political change.
This last possibility may explain Lenin's vitriolic attacks on the "Workers'
Opposition."

This opposition, like the "Left Communists" of 1918, was ultimately defeated
by organisational pressures within the party and state. Victor Serge _"was
horrified to see the voting rigged for Lenin's and Zinoviev's 'majority'"_ in
late 1920. [ **Memoirs of a Revolutionary** , p. 123] Kollantai complained
that while officially one and a half million copies of the "Workers'
Opposition" manifesto were published, in fact only 1500 were _"and that with
difficulty."_ [quoted by Schaprio, **Op. Cit.** , p. 291] This applied even
more after the banning of factions, when the party machine used state power to
break up the base of the opposition in the trade unions as well as its
influence in the party:

> _"Victimisation of supporters of the "Workers' Opposition" began immediately
> after the Tenth Party Congress. 'The struggle,' as Shlyapnikov later
> recounted, 'took place not along ideological lines but by means . . . of
> edging out from appointments, of systematic transfers from one district to
> another, and even expulsion from the party.' . . . the attack was levelled
> not for heretical opinions, but for criticism of any kind of party
> shortcomings. 'Every member of the party who spoke in defence of the
> resolution on workers' democracy [in the party] was declared a supporter of
> the Workers' Opposition and guilty of disintegrating the party,' and was
> accordingly victimised."_ [Schapiro, **Op. Cit.** , pp. 325-6]

Thus _"the party Secretariat was perfecting its technique of dealing with
recalcitrant individuals by the power of removal and transfer, directed
primarily at the adherents of the Workers' Opposition. (Of the 37 Workers'
Opposition delegates to the Tenth Congress whom Lenin consulted when he was
persuading Shlyapnikov and Kutuzov to enter the Central Committee, only four
managed to return as voting delegates to the next congress.)"_ A similar
process was at work in the trade unions. For example, _"[w]hen the
metalworkers' union held its congress in May 1921, the Central Committee of
the party handed it a list of recommended candidates for the union leadership.
The metalworkers' delegates voted down the party-backed list, but this gesture
proved futile: the party leadership boldly appointed their own men to the
union offices."_ This was _"a show of political force"_ as the union was a
centre of the "Workers' Opposition". [Daniels, **Op. Cit.** , p. 161 and p.
157]

This repression was practised under Lenin and Trotsky, using techniques which
were later used by the Stalinists against Trotsky and his followers. Lenin
himself was not above seeking to remove his opponents from the central
committee by undemocratic methods. At the Tenth Party Congress he had
persuaded Shlyapnikov to be elected to the Central Committee in an attempt to
undermine the opposition. A mere _"five months later, Lenin was demanding his
expulsion for a few sharp words of criticism of the bureaucracy, uttered at a
private meeting of a local party cell. If he was looking for a pretext, he
could scarcely have picked a weaker one."_ [Schapiro, **Op. Cit.** , p. 327]
Lenin failed by only one vote short of the necessary two thirds majority of
the Committee.

In summary, the "Workers' Opposition" vision was limited. Politically, it
merely wanted democracy within the party and did not question the party's
monopoly of power. As such, it definitely did not deserve the labels
_"anarchist"_ and _"syndicalist"_ which its opponents labelled it. As far as
its economic policy goes, it, too, was limited. Its demands for economic
democracy were circumscribed by placing it under the control of the communist
cells within the trade unions as well as within a typically Marxist
centralised economic structure.

## 3 What about Trotsky's "Left Opposition" in the 1920s?

We now turn to what is probably the most famous opposition, namely Trotsky's
"Left Opposition" of 1923-7, for it spawned numerous Trotskyist sects across
the globe as well as the second "Fourth International" (the first had been
formed in 1922 by council communists from Germany, Holland and Britain,
amongst others). Chris Harman (of the UK's SWP) can be considered typical,
arguing that _"there was always an alternative to Stalinism. It meant, in the
late 1920s, returning to genuine workers' democracy and consciously linking
the fate of Russia to the fate of world revolution."_ He asserts that the
_"historical merit of the "Left Opposition"_ was that it _"did link the
question of the expansion of industry with that of working-class democracy and
internationalism."_ [ **Bureaucracy and Revolution in Eastern Europe** , p.
19] Other Leninists make similar claims. Victor Serge, a member of the "Left
Opposition" in Russia and then Trotskyist in exile, stated that its programme
was _"the reform of the Soviet State by a return to working-class democracy."_
[ **Memoirs of a Revolutionary** , p. 256]

Unfortunately, such claims are not true. As Serge himself noted elsewhere,
Trotsky may have _"ever since 1923 [been] for the renovation of the party
through inner party democracy and the struggle against bureaucracy"_ but _"the
greatest reach of boldness of the Left Opposition in the Bolshevik Party was
to demand the restoration of inner-Party democracy, and it never dared dispute
the theory of single-party government -- by this time, it was too late."_ [
**The Serge-Trotsky Papers** , p. 201 and p. 181] Here we show that this was,
indeed, the case and will concentrate on the 1923 to 1927 period, before it
was crushed and all opposition disappeared for decades (for a refutation of
similar claims about Trotsky's opposition to Stalinism which extends into the
1930s, see [section 15](append31.md#app15) of the appendix ["Reply to errors
and distortions in David McNally's pamphlet 'Socialism from
Below'"](append31.md)).

It is indeed the case that since 1919 Trotsky, like Lenin, had been
wholeheartedly in favour of the party dictatorship and had opposed all
oppositions which raised the need for economic reforms which would increase
workers' control. This did not change in the 1920s but by 1923 even he could
not fail to see that something was going wrong. Unsurprisingly, given its
blindness to the substantial evidence of degeneration that had grown every
greater since 1917, his opposition was by far the weakest politically as it
questioned far fewer things. As Cornelius Castoriadis points out:

> _"From the beginning of 1918 until the banning of factions in March 1921,
> tendencies within the Bolshevik party were formed that, with farsightedness
> and sometimes an astonishing clarity, expressed opposition to the Party's
> bureaucratic line and to its very rapid bureaucratisation. These were the
> 'Left Communists' (at the beginning of 1918), then the 'Democratic
> Centralist' tendency (1919), and finally the 'Workers' Opposition'
> (1920-21). . . these oppositions were defeated one by one . . . The very
> feeble echoes of their critique of the bureaucracy that can be found later
> in the (Trotskyist) 'Left Opposition' after 1923 do not have the same
> signification. Trotsky was opposed to the **bad policies** of the
> bureaucracy and to the excesses of its power. He never put into question its
> essential nature. Until practically the end of his life, he never brought up
> the questions raised by the various oppositions of the period from 1918 to
> 1921 (in essence: 'Who manages production?' and 'What is the proletariat
> supposed to do during the 'dictatorship of the proletariat,' other than work
> and follow the orders of 'its' party?')."_ [ **Political and Social
> Writings** , vol. 2, p. 98]

While the "Left Communists" and "Workers' Opposition" had challenged Lenin's
state capitalist economic policies while upholding the Bolshevik monopoly of
power (implicitly or explicitly), Trotsky did not even manage that. His
opposition was firmly limited to internal reforms to the party which he hoped
would result in wider participation in the soviets and trade unions. Just as
he did not bother to explain why continuing party dictatorship would
reinvigorate the soviets or unions, he did not explain how benevolent
dictatorship was possible nor why an economic regime marked by wage-labour
(employed by the state rather than capitalists) would not be exploitative.
Instead, these positions were simply asserted -- for they were, after all,
Leninist orthodoxy and had been for some time.

Politically, Trotsky was unashamedly in favour of party dictatorship. Indeed,
his basic opposition to Stalinism was because he considered it as the end of
that dictatorship by the rule of the bureaucracy. His comments against the
"Workers' Opposition" at the Tenth Party Congress in March 1921 set the tone:

> _"The 'workers opposition' puts forward dangerous slogans which fetishise
> the principles of democracy. Elections from within the working class were
> put above the party, as if the party had no right to defend its dictatorship
> even when this dictatorship was temporarily at odds with the passing
> feelings of workers' democracy . . . It is essential to have a sense of --
> so to speak -- the revolutionary-historical primacy of the party, which is
> obliged to hold on to its dictatorship, despite the temporary waverings of
> the masses . . . even of the workers."_ [quoted by Alec Nove, _"Trotsky,
> collectivization and the five year plan,"_ **Socialism, Economics and
> Development** , p. 100]

In April 1923, he stressed that _"[i]f there is one question which basically
not only does not require revision but does not so much as admit the thought
of revision, it is the question of the dictatorship of the Party."_ [ **Leon
Trotsky Speaks** , p. 158] He was true to his word. In _"The New Course"_
(generally accepted as being the first public expression of his opposition to
the developing Stalinist regime), he stated that _"[w]e are the only party in
the country, and in the period of the dictatorship it could not be
otherwise."_ Moreover, it was _"incontestable that factions [within the party]
are a scourge in the present situation"_ and so the party _"does not want
factions and will not tolerate them."_ [ **The Challenge of the "Left
Opposition" (1923-25)** , p. 78, p. 80 and p. 86] In May 1924, he even went so
far as to proclaim that:

> _"Comrades, none of us wants to be or can be right against the party. In the
> last analysis, the party is always right, because the party is the sole
> historical instrument that the working class possesses for the solution of
> its fundamental tasks. I have already said that nothing would be simpler
> than to say before the party that all these criticisms, all these
> declarations, warnings, and protests -- all were mistaken from beginning to
> end. I cannot say so, however, comrades, because I do not think it. I know
> that no one can be right against the party. It is only possible to be right
> with the party and through it since history has not created any other way to
> determine the correct position."_ [ **Op. Cit.** , p.161]

So his opposition was a loyal one, initially accepting defeats and following
party discipline. In fact, he made a great deal of being the true heir of
Lenin and so not only did not question Bolshevik orthodoxy but instead
championed it in every detail. Hence the limitations of his opposition.

However, confusion creeps into the politics of the "Left Opposition" simply
because it used the term _"workers' democracy"_ a lot. However, a close
reading of Trotsky's argument soon clarifies this issue. Trotsky, following
the Communist Party itself and the "Workers' Opposition", had simply redefined
what _"workers' democracy"_ meant. Rather than mean what you would expect it
would mean, the Bolsheviks had changed its meaning to become _"party
democracy."_ Thus Trotsky could talk about _"party dictatorship"_ and
_"workers' democracy"_ without contradiction. As his supporter Max Eastman
noted in the mid-1920s, Trotsky was in favour of the _"programme of democracy
within the party -- called 'Workers' Democracy' by Lenin."_ This _"was not
something new or especially devised . . . It was part of the essential policy
of Lenin for going forward toward the creation of a Communist society -- a
principle adopted under his leadership at the Tenth Congress of the party,
immediately after the cessation of the civil war."_ [ **Since Lenin Died** ,
p. 35] In the words of historian Robert V. Daniels:

> _"The Opposition's political ideal was summed up in the slogan 'workers'
> democracy,' which referred particularly to two documents [from 1921 and
> 1923] . . . Both these statements concerned the need to combat
> 'bureaucratism' and implement party democracy."_ [ **Op. Cit.** , p. 300]

That this was the case can be seen from the Fourth All-Russian Congress of
Trade Unions in 1921:

> _"At the meeting of delegates who were party members, Tomsky submitted for
> routine approval a set of theses on the tasks of trade unions. The approval
> was a matter of form, but an omission was noted, The theses made no
> reference to the formula of 'proletarian democracy' with which the Tenth
> Congress had tried to assuage the rank and file. Riazanov . . . offered an
> amendment to fill the breach, in language almost identical with the Tenth
> Congress resolution: 'The party must observe with special care the normal
> methods of proletarian democracy, particularly in the trade unions, where
> most of all the selection of leaders should be done by the organised party
> masses themselves.' . . . The party leadership reacted instantaneously to
> this miscarriage of their plans for curtailing the idea of union autonomy.
> Tomksy was summarily ejected from the trade union congress. Lenin put in an
> appearance together with Bukharin and Stalin to rectify the unionists'
> action."_ [Daniels, **Op. Cit.** , p. 157]

The _"New Course Resolution"_ passed in December 1923 stresses this:

> _"Workers' democracy means the liberty of frank discussion of the most
> important questions of party life by all members, and the election of all
> leading party functionaries and commissions by those bodies immediately
> under them. It does not, however, imply the freedom to form factional
> groupings, which are extremely dangerous for the ruling party, since they
> always threaten to split or fragment the government and the state apparatus
> as a whole._

> _"Within a party, which represents a voluntary union of people on the basis
> of definite ideals and practice, it is obvious that there can be no
> toleration of the formation of groupings whose ideological content is
> directed against the party as a whole and against the dictatorship of the
> proletariat, as for instance the Workers' Truth and Workers' Group."_
> [Trotsky, **Op. Cit.** , p. 408]

As we show in the [next section](append45#app4), these groups actually
advocated **genuine** workers' democracy -- that is, they opposed the party's
monopoly of power and supported multi-party elections. Thus Trotsky's
opposition was hardly democratic, defending the practice and concept of _"the
dictatorship of the party"_ throughout the 1920s and -- correctly! -- linking
it to Lenin and so Leninist orthodoxy:

> _"Of course, the foundation of our regime is the dictatorship of a class.
> But this in turn . . . assumes it is a class that has come to self-
> consciousness through its vanguard, which is to say, through the party.
> Without this, the dictatorship could not exist . . . Dictatorship is the
> most highly concentrated function of a class, and therefore the basic
> instrument of a dictatorship is a party. In the most fundamental aspects a
> class realises its dictatorship through a party. That is why Lenin spoke not
> only of the dictatorship of the class but also the dictatorship of the party
> and, **in a certain sense** , made them identical."_ [Trotsky, **The
> Challenge of the "Left Opposition" (1926-27)** , pp. 75-6]

Trotsky argued that Stalin's policies were, in fact, a ploy to substitute the
dictatorship of the party apparatus for the dictatorship of the party. Such a
substitution, he argued, had its roots in a _"disproportion"_ between the
workers and peasants. As long as there was a _"proper 'proportion'"_ between
the two and _"the advance of democratic methods in the party and working class
organisations,"_ then _"the identification of the dictatorship of the class
with that of the party is fully and completely justified historically and
politically."_ Needless to say, Trotsky did not bother to ask how much
democracy (of **any** kind) was possible under a party dictatorship nor how a
class could run society or have democratic organisations if subjected to such
a dictatorship. For him it was a truism that the _"dictatorship of a party
does not contradict the dictatorship of the class either theoretically or
practically, but is an expression of it."_ [ **Op. Cit.** , p. 76]

This was no temporary aberration. As indicated in [section
H.3.8](secH3.md#sech38), Trotsky repeated this support for party
dictatorship ten years later. This was because it was Bolshevik orthodoxy, as
indicated in March 1923 by the Central Committee of the Communist Party when
it summarised the lessons gained from the Russian revolution, namely that
_"the party of the Bolsheviks proved able to stand out fearlessly against the
vacillations within its own class, vacillations which, with the slightest
weakness in the vanguard, could turn into an unprecedented defeat for the
proletariat."_ Vacillations are expressed by workers' democracy and so this
was rejected: _"The dictatorship of the working class finds its expression in
the dictatorship of the party."_ ( _"To the Workers of the USSR"_ , Zinoviev,
**History of the Bolshevik Party** , p. 213 and p. 214)

Unsurprisingly, this perspective was also raised in the 1927 **Platform of the
Opposition** , alongside the same contradictory demands for _"workers'
democracy"_ and the revitalising of the soviets and trade unions. It made the
limited nature of Trotsky's opposition clear, for it attacked Stalin for
**weakening** the party's dictatorship. In its words, the _"growing
replacement of the party by its own apparatus is promoted by a 'theory' of
Stalin's which denies the Leninist principle, inviolable for every Bolshevik,
that the dictatorship of the proletariat is and can be realised only through
the dictatorship of the party."_ It repeats this principle by arguing that
_"the dictatorship of the proletariat demands a single and united proletarian
party as the leader of the working masses and the poor peasantry."_ As such,
_"[w]e will fight with all our power against the idea of two parties, because
the dictatorship of the proletariat demands as its very core a single
proletarian party. It demands a single party."_ [ _"The Platform of the
Opposition"_ , **The Challenge of the "Left Opposition" (1926-27)** , p. 395,
p. 439 and p. 441]

This conviction was so strong that even after the defeat of the "Left
Opposition" it was the case that in the prison camps _"almost all the
Trotskyists continued to consider that 'freedom of party' would be 'the end of
the revolution.' 'Freedom to choose one's party -- that is Menshevism,' was
the Trotskyists' final verdict."_ [Ante Ciliga, **The Russian Enigma** , p.
280] Such is the power of ideology.

So _"workers' democracy"_ had a very specific meaning to the Communist Party,
namely one limited to within the party and **not** a call for **genuine**
democracy in the unions or soviets. Such a definition, obviously, in no way
undermines the dictatorship of the party -- but it does allow the use of
quotations by Leninists to bolster a false narrative on the nature of
Bolshevism.

Politically, then, the opposition urged the benevolent dictatorship of an
internally democratic party. Economically, Trotsky's opposition was far more
backward than previous ones. For Trotsky, economic democracy was not an issue
and so it played no role in determining the socialist nature of a society.
Rather state ownership did. Thus he did not question one-man management in the
workplace nor the capitalist social relationships it generated. For Trotsky,
it was _"necessary for each state-owned factory, with its technical director
and with its commercial director, to be subjected not only to control from the
top -- by the state organs -- but also from below, by the market which will
remain the regulator of the state economy for a long time to come."_ In spite
of the obvious fact that the workers did not control their labour or its
product, Trotsky asserted that _"[n]o class exploitation exists here, and
consequently neither does capitalism exist."_ Moreover, _"socialist industry .
. . utilises methods of development which were invented by capitalist
economy."_ Ultimately, it was not self-management that mattered, it was _"the
growth of Soviet state industry [which] signifies the growth of socialism
itself, a direct strengthening of the power of the proletariat"_. [ **The
First 5 Years of the Communist International** , vol. 2, p. 237 and p. 245]

Unsurprisingly, then, the "Left Opposition" did not even have the merit of the
"Left Communists" or "Workers' Opposition" in raising economic reforms. Its
Platform simply repeated Bolshevik orthodoxies, arguing that _"nationalisation
of the means of production was a decisive step toward the socialist
reconstruction of that whole social system which is founded upon the
exploitation of man by man"_ and that the _"appropriation of surplus value by
a workers' state is not, of course, exploitation."_ However, it also
acknowledged that _"we have a workers' state with bureaucratic distortions"_
and a _"swollen and privileged administrative apparatus devours a very
considerable part of our surplus value"_ while _"all the data testify that the
growth of wages is lagging behind the growth of the productivity of labour."_
[ _"The Platform of the Opposition"_ , **The Challenge of the "Left
Opposition" (1926-27)** , pp. 347-8, p. 350]

So an economic regime marked by one-man management by state-appointed bosses
under a party dictatorship could somehow be without exploitation even though
someone other than the workers controlled both their labour and how its
product (and any surplus) was used? It is hardly surprising that the new
master class sought their own benefit; what is surprising is that the "Left
Opposition" could not see the reality of state-capitalism. Rather, it focused
its attention on the living standards of the working class and paid no
attention to the relations of production in the workplace, raising no
proposals nor demands about establishing workers' control of industry. Given
its self-proclaimed role as defender of Leninist orthodoxy and its social
relations, perhaps this is not so surprising after all.

In summary, Trotsky's "opposition" in no way presented any real alternative to
Stalinism. At no time did he question the fundamental social relationships
within Soviet society. As the 1927 Platform noted, he saw Stalinism as the
victory of the state bureaucracy over the party and **its** dictatorship.
Writing ten years after the Platform, Trotsky reiterated this, arguing that
the _"bureaucracy won the upper hand. It cowed the revolutionary vanguard,
trampled upon Marxism, prostituted the Bolshevik party . . . To the extent
that the political centre of gravity has shifted from the proletarian vanguard
to the bureaucracy, the party has changed its social structure as well as its
ideology."_ He simply wanted to shift the _"political centre of gravity"_ back
towards the party, as it had been in the early 1920s when he and Lenin were in
power. He in no significant way questioned the nature of the regime or the
social relationships it was rooted in (whether political or economic). Indeed,
_"[t]hose who counterpose the abstraction of soviets to the party dictatorship
should understand that only thanks to the Bolshevik leadership were the
soviets able to lift themselves out of the mud of reformism and attain the
state form of the proletariat."_ [ _"Stalinism and Bolshevism"_ , pp. 416-431,
**Writings 1936-37** , p. 422 and p. 430]

This explains his continual self-imposed role after his exile of loyal
opposition to Stalinism in spite of the violence applied to him and his
followers. It also explains the lack of excitement by the Russian working
class over the "Left Opposition" for their choice was between two factions
within the master class. As Serge acknowledged: _"Outraged by the Opposition,
they [the bureaucrats] saw it as treason against them; which in a sense it
was, since the Opposition itself belonged to the ruling bureaucracy."_ [
**Memoirs of a Revolutionary** , p. 225]

This may come as a shock to many readers. This is because Trotskyists are
notorious for their rewriting of the policies of Trotsky's opposition, as seen
by the words of Chris Harman we quoted earlier. Yet this is hardly surprising,
as openly saying that benevolent state-capitalist party dictatorship was the
only alternative to Stalinism would be hard to maintain. Like Trotsky, there
is a pressing need to avoid looking at the social relations under Lenin in
case obvious similarities are noticed to those under Stalin. Thus we find
Harman stating in his summary of the rise Stalinism that it was after
_"Lenin's illness and subsequent death"_ when the _"principles of October were
abandoned one by one."_ [ **Op. Cit.** , p. 14] Presumably, in that case, the
_"principles of October"_ included the practice of, and ideological commitment
to, party dictatorship, one-man management, banning opposition parties and
groups (as well as factions within the Communist Party), censorship, state
repression of working class strikes and protests, piece-work, Taylorism, the
end of independent trade unions and a host of other crimes against socialism
implemented under Lenin and normal practice at the time of his death.

Like Lenin, the "Left Opposition" did **not** question the Bolshevik's
monopoly of power and explicitly supported the idea of party dictatorship.
This fact helps explains what Harman seems puzzled by, namely that Trotsky
_"continued to his death to harbour the illusion that somehow, despite the
lack of workers' democracy, Russia was a 'workers' state.'"_ [ **Op. Cit.** ,
p. 20] Strangely, Harman does not explain why Russia was a _"workers' state"_
under Lenin and Trotsky, given its _"lack of workers' democracy."_ But
illusions are hard to dispel, sometimes.

So, for Trotsky, like the rest of the Communist Party including its "Left
Opposition", **genuine** workers' democracy was **not** considered important
and, in fact, was applicable only within the party. Thus the capitulation of
many of the "Left Opposition" to Stalin once he started a policy of
industrialisation comes as less of a surprise than Harman thinks it was. As
Ante Ciliga saw first-hand in the prison camps:

> _"the majority of the Opposition were . . . looking for a road to
> reconciliation; whilst criticising the Five Year Plan, they put stress not
> on the part of exploited class played by the proletariat, but on the
> technical errors made by the Government **qua** employer in the matter of
> insufficient harmony within the system and inferior quality of production.
> This criticism did not lead to an appeal to the workers against the Central
> Committee and against bureaucratic authority; it restricted itself to
> proposing amendments in a programme of which the essentials were approved.
> The socialist nature of State industry was taken for granted. They denied
> the fact that the proletariat was exploited; for 'we were in a period of
> proletarian dictatorship.'"_ [ **Op. Cit.** , p. 213]

As Victor Serge noted, _"[f]rom 1928-9 onwards, the Politbureau turned to its
own use the great fundamental ideas of the now expelled Opposition (excepting,
of course, that of working-class democracy) and implemented them with ruthless
violence."_ While acknowledging that the Stalinists had applied these ideas in
a more extreme form than the Opposition planned, he also acknowledged that
_"[b]eginning in those years, a good many Oppositionists rallied to the
'general line' and renounced their errors since, as they put it, 'After all,
it is our programme that is being applied.'"_ Nor did it help that at _"the
end of 1928, Trotsky wrote to [the Opposition] from his exile . . . to the
effect that, since the Right represented the danger of a slide towards
capitalism, we had to support the 'Centre' -- Stalin -- against it."_ [ **Op.
Cit.** , p. 252 and p. 253]

However, Serge's comments on _"working-class democracy"_ are somewhat
incredulous, given (as we noted above) that he knew fine well that the
Opposition did not stand for it. His summary of the 1927 Platform was
restricted to it aiming _"to restore life to the Soviets . . . and above all
to revitalise the Party and the trade unions. . . In conclusion, the
Opposition openly demanded a Congress for the reform of the Party, and the
implementation of the excellent resolutions on internal democracy that had
been adopted in 1921 and 1923."_ [ **Op. Cit.** , pp. 224-5] Which is
essentially correct: once we understand that the Platform was based on
redefining "workers' democracy" to mean "party democracy" within the context
of its dictatorship.

Yet we can hardly blame the likes of Harman, as it was Trotsky himself who
started the process of revising history to exclude his own role in creating
the evils he (sometimes) denounced his opponents within the party for. For
example, the 1927 Platform states that _"[n]ever before have the trade unions
and the working mass stood so far from the management of socialist industry as
now"_ and that _"[p]re-revolutionary relations between foremen and workmen are
frequently found."_ [ _"The Platform of the Opposition"_ , **Op. Cit.** , pp.
353-4] Which is hardly surprising, given that Lenin had argued for, and
implemented, appointed one-man management armed with "dictatorial powers" from
April 1918 onwards (see [section H.3.14](secH3.md#sech314)).

Trotsky himself supported it wholeheartedly. Thus we find him arguing in 1923
that the _"system of actual one-man management must be applied in the
organisation of industry from top to bottom. For leading economic organs of
industry to really direct industry and to bear responsibility for its fate, it
is essential for them to have authority over the selection of functionaries
and their transfer and removal."_ These economic organs must _"in actual
practice have full freedom of selection and appointment."_ He also tied
payment to performance, arguing that _"the payment of the directors of
enterprises must be made to depend on their balance sheets, like wages depend
on output."_ [quoted by Robert V. Daniels, **A Documentary History of
Communism** , vol. 1, p. 237] In this, it must be noted, he was repeating
arguments made during the civil war (as expressed, in say, **Terrorism and
Communism** ).

Harman argues that the Stalinist bureaucracy became a ruling class and Russia
state-capitalist in 1928 when it implemented the first five year plan. This
industrialisation was provoked by military competition with the west, which
forced the _"drive to accumulate"_ which caused the bureaucracy to attack
_"the living standards of peasants and workers."_ He quotes Stalin: _"to
slacken the pace (of industrialisation) would mean to lag behind; and those
who lag behind are beaten . . . We must make good this lag in ten years.
Either we do so or they crush us."_ Moreover, the _"environment in which we
are placed . . . at home and abroad . . . compels us to adopt a rapid rate of
industrialisation."_ [ **Op. Cit.** , pp. 15-6] Given that this was exactly
the same argument as Trotsky in 1927, it seems far from clear that the "Left
Opposition" presented any sort of alternative to Stalinism for it, after all,
_"took the stand that large-scale new investment was imperative, especially in
heavy industry, and that comprehensive planning and new sources of capital
accumulation should be employed immediately to effect a high rate of
industrial expansion . . . They also stressed the necessity of rapidly
overtaking the capitalist powers in economic strength, both as a guarantee of
military security and as a demonstration of the superiority of the socialist
system."_ [Robert V. Daniels, **The Conscience of the Revolution** , p. 290]

Indeed, the idea of _"primitive socialist accumulation"_ was raised by Yevgeni
Preobrazhensky, a leading member of "Left Opposition", in 1926. Like
capitalist "primitive accumulation" (see [section F.8](secF8.md)), this
argued that the State had to build industry by means of squeezing more surplus
from the peasantry. Would the industrialisation advocated by the "Left
Opposition" been obtained by any means other than politically enforced
exploitation and the repression of first peasant and then, inevitably,
proletarian protest? Faced with the same objective pressures and goals, would
it have been any different if that faction had become dominant in the party
dictatorship? It is doubtful, unless you argue that who is in charge rather
than social relationships that determine the socialist nature of a regime.
But, then again, that is precisely what Trotskyists like Harman do when they
look at Lenin's Russia.

As an added irony, as we discuss in [section H.3.13](secH3.md#sech313),
Harman's party -- the British SWP -- argues that the USSR under Stalin was
_"state capitalist"_ due to _"the international arms competition."_ [ **Op.
Cit.** , p. 17] Yet the economic policy of the "Left Opposition" was to
industrialise Russia, on increasing accumulation in order to compete
militarily with traditional capitalist states, As the 1927 Platform argued, it
was a case that the _"present tempo of industrialisation and the tempo
indicated for the coming years are obviously inadequate"_ and so argued for an
acceleration of industrialisation for the _"Soviet Union must not fall further
behind the capitalist countries, but in the near future must overtake them."_
Thus industrialisation _"must be sufficient to guarantee the defence of the
country and in particular an adequate growth of war industries."_ [ _"The
Platform of the Opposition"_ , **Op. Cit.** , pp. 369-70] Why does this not
make Trotsky an advocate of state capitalism? All that the Oppositionists
could argue is that their industrialisation would have been less brutal, less
oppressive and with fewer privileges for the bureaucracy... but a nicer ruling
class is still a ruling class.

Given this, it is easy to understand why we will ignore as fundamentally
meaningless the pseudo-scientific comments on the relative weight of "social
forces" in the rise of the bureaucracy so beloved by certain Trotskyists. This
is because, ultimately, it is speculation on what could be the "objective"
conditions required for a benevolent (party) dictatorship and state-capitalist
economy to exist -- a pointless task, for obvious reasons (at least if you are
not a Leninist). While popular resistance and protest can make a ruling class
less oppressive and exploitative, it is something else completely to suggest
that it can stop a ruling class being exploitative and oppressive as such.
However, as Trotsky refused to recognise the class nature of the bureaucracy
-- and the identical social relations that existing under Lenin and which
Trotsky did not question -- perhaps this is unsurprising after all. Indeed,
perhaps all the talk of "social forces" and such like is just an attempt to
obscure the real issue -- the actual, objective, class relationships under the
Bolshevik regime (the state bureaucracy as a class in itself with its own
interests -- see [section H.3.9](secH3.md#sech39)).

So the limitations in Marxist theory means that issue degenerated to such a
degree that it is not recognised that the clash between Stalin and Trotsky
boils down to the whether a benevolent dictatorship is possible and whether
with the right people in charge state-capitalist social relationships cease
being exploitative (Trotsky seems to genuinely believe this while Stalin and
his cronies paid lip-service to the notion). That this is debated seriously --
then and now -- says a lot about the ideological limitations of Bolshevism. As
such, not only does the programme of the "Left Opposition" offer no real
alternative to Stalinism, it present no alternative economic or political
vision which would stop the bureaucratic degeneration that produced Stalin in
the first place.

In addition, it should be basic materialism that it is a person's real social
position which shape their consciousness. As such, it is illusory to expect
the rulers of a party dictatorship, the managers of state-capitalist firms or
bureaucrats in a highly centralised apparatus to act in any other fashion than
according to their social position -- yet Trotsky does so. Apparently being
part of the vanguard party -- or being part of an immense social institution
policed by this small body -- negates the objective pressures created by such
hierarchies and the authoritarian (and so inevitably exploitative) social
relations they produce. As such, he failed to understand the "social forces"
at work in Russia for he failed to understand the class nature of the
bureaucracy. He failed to understand that the bureaucracy overcame the party
because the party itself was -- inevitably -- corrupted by the social position
it held.

Internally, then, the "Left Opposition" was no alternative. As for Harman's
assertion that the "Left Opposition" stood for _"internationalism,"_ that is
less straight forward than he would like to think. As noted, it favoured the
industrialisation of Russia to defend the regime against its foreign
competitors. As such, the "Left Opposition" were as committed to building
"socialism" in the USSR as were the Stalinist promoters of _"socialism in one
country."_ The difference was that the "Left Opposition" also argued for
spreading revolution externally as well. For them, this was the **only** means
of assuring the lasting victory of "socialism" (i.e. a nationalised economy)
in Russia but they also aimed at building the industrial base in a single
country along with this.

Yet this driving necessity to "defend" the conquests of October produced
contradictions from the start. Most obviously, this meant -- just like the
Stalinists later -- interfering in Communist Parties of other nations to
produce outcomes favourable to the USSR. Thus we find the German Council
Communists forming the first "Fourth International" in protest to the
Bolshevik domination of the Third International (Comintern) and the imposition
of policies (such as parliamentarianism) _"determined not only by the needs of
communist agitation in those countries, but also by the political needs of
Soviet Russia."_ [Anton Pannekoek, _"World Revolution and Communist Tactics:
Afterword"_ , **Pannekoek and Gorter's Marxism** , p. 144]

As well as favouring the right-wing in various national parties (not least,
the German and British) the Bolshevik regime signed numerous agreements with
capitalist nations. As anarchist Marie-Louise Berneri summarised in the 1940s:

> _"Quite early in its history, the allegedly revolutionary aims of the
> Comintern stood in contrast to the diplomatic relations of the Soviet Union
> with other countries."_

> _"Thus the Bolsheviks entered into commercial agreements with Mussolini's
> Fascist Government soon after it assumed power in Italy. On the morning
> after the murder of the Socialist deputy Matteotti the Soviet Ambassador
> called on Mussolini. At the very same time when the German Communists were
> planning the overthrow of the State, the Russian government was not only
> making trade agreements with the German capitalist government, but even
> making secret arrangements whereby the Germans could evade the military
> terms of the Treaty of Versailles by establishing arms factories, and
> training armies on Russian soil. Wherever a clash occurred the claims of
> Soviet foreign policy prevailed over the needs of the revolutionary class
> struggle."_ [ **Neither East Nor West** , p. 63]

It is worth discussing the relations between Lenin's Russia and the German
military in more detail. Negotiations between the two states started as early
as 1920 and involved an important aide of Trotsky's. The fruit of the German
military's negotiations were _"secret military understandings"_ and by
September 1922 German officers and pilots were training in Russia. An
organisation of German military and industrial enterprises in Russia was
established and under its auspices shells, tanks and aircraft were
manufactured in Russia for the German army (an attempt to produce poison gas
failed). [E.H. Carr, **The Bolshevik Revolution** , vol. 3, p. 327 and pp.
431-2] In April, 1923, the German High Command ordered 35 million gold marks
worth of war material and _"[w]ith this military rapprochement between Germany
and Russia went increasing trade between the two countries. After the Treaty
of Rapallo, Krassin, the People's Commissar for Foreign Trade warned the
German workers (in an interview in 'Rote Fahne') against strikes which could
lead to the interruption of deliveries of essential materials to Russia.
Already the interests of the Soviet State were above those of the German
proletariat."_ [Aberdeen Solidarity, **Spartakism to National Bolshevism** ,
p. 24]

These relations had their impact on the politics of the German Communist
Party, specifically its so-called _"Schlageter Line"_ of co-operation with
nationalist and fascist groups. This policy was first promoted in the
Comintern by leading Communist Radek and inspired by Zinoviev. According to
Radek, _"national Bolshevism"_ was required as the _"strong emphasis on the
nation in Germany is a revolutionary act."_ [quoted by E.H. Carr, **The
Interregnum 1923-1924** , p. 177] During the summer of 1923, joint meetings
were held and both communist and fascist speakers urged an alliance with
Soviet Russia against the Entente powers. So, for several months, the German
Communists worked with the Nazis, going so as far as to stage rallies and
share podiums together. The Communist leader Ruth Fischer even argued that
_"he who denounces Jewish capital . . . is already a warrior in the class war,
even though he does not know it"_ (she latter said her remarks had been
distorted). [quoted by Carr, **Op. Cit.** , p. 182f] This continued until
_"the Nazis leadership placed a ban on further co-operation."_ [Carr, **Op.
Cit.** , p. 183] Thus the activities of the German communists were tailored to
fit into the needs of Lenin's regime.

How _"internationalist"_ was it to arm and train the very forces which had
crushed revolutionary workers in Germany between 1919 and 1921? How sensible
was it, when pressing for world revolution, to enhance the power of the army
which would be used to attack any revolution in Germany? Which, of course, was
what happened in 1923, when the army repressed the Comintern inspired revolt
in November that year. Trotsky was one of the staunchest in favour of this
insurrection, insisting that it be fixed for the 7th of that month, the
anniversary of the Bolshevik seizure of power. The attempted revolt was a
dismal failure. Rather than a revolution in Berlin on the 7th of November,
there was a diner at the Russian embassy for German officers, industrialists
and officials to celebrate the anniversary of the Russian revolution. [Carr,
**Op. Cit.** , p. 205 and p. 226] The obvious question is how many Communists
and workers killed in the revolt had been at the receiving end of weapons and
training supplied to the German army by the Red Army?

To state another obvious point: _"We are now a long way from the insistence of
Liebknecht that, for socialists, the main enemy lies in your own country. The
activities above need outlining, not refutation. It cannot be claimed that
arming capitalist armies, or working with fascists helps raise the
consciousness of the working class. What is important is to point out how by
1923, the activities of the supine K.P.D. were tailored to fit the needs of
Russia, in this case an alliance with Germany."_ [Aberdeen Solidarity, **Op.
Cit.** , p. 25]

Moreover, the **nature** of any such revolution is what counts. The "Left
Opposition" would have encouraged revolutions which followed (to re-quote the
**Platform of the Opposition** ) the _"Leninist principle"_ ( _"inviolable for
every Bolshevik"_ ) that _"the dictatorship of the proletariat is and can be
realised only through the dictatorship of the party."_ It would have urged
centralisation. It would have opposed workers' self-management in favour of
nationalisation and one-man management. In other words, the influence of the
"Left Opposition" would have been as detrimental to the global workers'
movement and other revolutions as Stalin's was (or, for that matter, Lenin's)
although, of course, in a different way. Generalising Lenin's state capitalism
would not have resulted in socialism, no matter how many revolutions in the
west the "Left Opposition" encouraged. Simon Pirani puts it well:

> _"The legacy of the Bolsheviks' actions was not limited to their impact on
> Soviet history, though. The effect on the political development of the
> workers' movement internationally was just as important. Authoritarian,
> vanguardist and statist ways of thinking and assumptions spread out from
> Moscow -- not only directly through the Comintern and the Communist Parties,
> which for decades influenced radical workers' struggles, but also in many
> indirect ways. Moscow's instructions to Communist Parties might or might not
> be obeyed, but, far beyond the ranks of those parties, Bolshevik ideologies
> clouded, obstructed and diverted efforts to develop socialist ideas and
> strategies for working-class movements. Bolshevik ideology packed the
> powerful punch of association with the first successful workers' revolution:
> it was the great shadow of 1917, hanging over the twentieth century like the
> shadow of 1789 hung over the nineteenth century, that gave these ideologies
> force. Socialism was damaged not only by the choices the Bolsheviks made,
> but by their sincere insistence that those choices were the continuation of
> the revolution, and by the powerful influence of their ideology on
> subsequent movements of social liberation."_ [ **The Russian Revolution in
> Retreat** , p. 241]

Finally, the fate of the "Left Opposition" should be noted. As befell the
previous oppositions, the party machine was used against it. Indeed, by
repeatedly and publicly proclaiming himself the greatest defender of party
unity and the strongest opponent of inner-party factions, Trotsky himself
supplied his enemies with the best argument in favor of the dissolution of the
"Left Opposition". Nor was he willing to call upon any social forces outwith
the party to combat the bureaucracy. Indeed, he refused to publicly support
the party members who had took part in the workers' strike movement and had
been expelled from the party. Worse, _"Trotsky, in the very letters to the
politburo in which he fired his first broadsides against the 'unhealthy
regime' and lack of internal party democracy, supported repressive action
against the far left."_ Indeed, he _"welcomed an instruction by Dzerzhinskii
to party members immediately to report 'any groupings within the party', i.e.
the Workers Group and Workers Truth, not only to the CC but also to the GPU,
and emphasized that making such reports was 'the elementary duty of every
party member'."_ [Simon Pirani, **Op. Cit.** , p. 215]

Thus, the Stalinists began by using the very techniques the likes of Trotsky
had supported against their opponents years before. For example, the Eighth
Party Congress in December 1919 agreed that _"[a]ll decisions of the higher
jurisdiction are absolutely binding for the lower."_ Moreover, _"[e]ach
decision must above all be fulfilled, and only after this is an appeal to the
corresponding party organ permissible."_ Centralism was reaffirmed: _"The
whole matter of assignment of party workers is in the hands of the Central
Committee of the party. Its decision is binding for everyone..."_ These
decisions were used as a weapon against the opposition: _"Translating this
principle into practice, the Secretariat under Krestinsky [a Trotsky
supporter] began deliberately to transfer party officials for political
reasons, to end personal conflicts and curb opposition."_ In 1923, the
Secretariat _"brought into play its power of transfer, which had already
proven to be an effective political weapon against the Ukrainian Leftists and
the Workers' Opposition._ [Robert V. Daniels, **Op. Cit.** , p. 113 and p.
229]

The party itself had been reorganised, with _"the replacement of local party
committees, which were at least democratic in form, by bureaucratically
constituted 'political departments.' With the institution of such bodies, all
political activity . . . was placed under rigid control from above. This
innovation was taken from the army; as its origin suggests, it was strictly a
military, authoritarian institution, designed for transmitting propaganda
downward rather than opinion upward."_ [Daniels, **Op. Cit.** , p. 114]
Needless to say, it was Trotsky himself who implemented that regime in the
army in March 1918 when he abolished the soldier's committees and elected
officers, stating that _"the principle of election is politically purposeless
and technically inexpedient, and it has been, in practice, abolished by
decree."_ [ **How the Revolution Armed** , vol. 1, p. 47] This, of course, did
not stop him asserting in 1936 that the _"demobilisation of the Red Army of
five million played no small role in the formation of the bureaucracy. The
victorious commanders assumed leading posts in the local Soviets, in economy,
in education, and they persistently introduced everywhere that regime which
had ensured success in the civil war."_ [ **The Revolution Betrayed** , pp.
89-90]

It should also be remembered that when, in early in 1922, the "Workers'
Opposition" had appealed to Communists abroad in the form of a statement to a
Congress of the Communist International (Comintern) which included the
accusation that the _"party and trade-union bureaucracy . . . ignore the
decisions of our congresses on putting workers' democracy [inside the party]
into practice."_ Their _"effort to draw the proletarian masses closer to the
state is declared to be 'anarcho-syndicalism,' and its adherents are subjected
to persecution and discrediting."_ They argued that the _"tutelage and
pressure by the bureaucracy goes so far that it is prescribed for members of
the party, under threat of exclusion and other repressive measures, to elect
not those whom the Communists want themselves, but those whom the ignorant
high places want."_ [quoted by Daniels, **Op. Cit.** , p. 162] It was Trotsky
who defended the party against these claims -- unsurprisingly, the Bolshevik
dominated Comintern decided against the opposition.

Even more ironically, the dominant faction of the bureaucracy heaped upon
Trotsky's opposition faction similar insults to those he (and Lenin) had
heaped upon previous oppositions inside and outside the party. In 1924, the
Trotskyist opposition was accused of having _"clearly violated the decision of
the Tenth Congress . . . which prohibited the formation of factions within the
party"_ and has _"enlivened the hopes of all enemies of the party, including
the West-European bourgeoisie, for a split in the ranks of the Russian
Communist Party."_ It was a _"direct departure of Leninism"_ and _"also a
clearly expressed **petty-bourgeois deviation** "_ reflecting _"the pressure
of the petty bourgeois on the position of the proletarian party and its
policy."_ [contained in Daniels, **A Documentary History of Communism** , vol.
1, pp. 247-8] In 1927, it was the case that the "United Opposition" was
_"[o]bjectively . . . a tool of the bourgeois elements."_ [quoted by Daniels,
**The Conscience of the Revolution** , p. 318] This, of course, did not deter
Trotsky making similar claims against his opponents on the left during the
1930s.

Ultimately, the Stalinists had a key weapon in its armoury: _"the GPU security
police. Having been used against the Workers Group and Workers Truth, it was
now mobilized, covertly, against the new opposition."_ [Pirani, **Op. Cit.** ,
p. 219] Indeed, its use in 1923 (as sanctioned by Trotsky) was used as a
precedent when it was the turn of the "Left Opposition".

So what would have happened if the "Left Opposition" had won? The first task
would have been a purge of the party in order to cleanse it of bureaucratic
and corrupt elements. In this it would have repeated the events of 1921 when
Lenin had _"proclaimed a purge of the Party, aimed at those revolutionaries
who had come in from other parties - i.e. those who were not saturated with
the Bolshevik mentality. This meant the establishment within the Party of a
dictatorship of the old Bolsheviks, and the direction of disciplinary
measures, not against the unprincipled careerists and conformist late-comers,
but against those sections with a critical outlook."_ [Serge, **Op. Cit.** ,
p. 135] It is unlikely that another purge would have been any more successful.

Given the identical social relations between Leninism and Stalinism, all that
is left to the supporters of Leninism seeking to differentiate it from
Stalinism is to focus on the regime within the Communist Party itself. It is
stressed that the Bolshevik party under Lenin was far more democratic than
under Stalin and, moreover, the repression of the late 1920s onwards simply
did not exist. True, although the suppression of opposition currents within
Bolshevism did not start under Stalinism for it had existed to some degree
from the start. Of course, the Stalinists did not stop there. Once the "Left
Opposition" was broken its members were brutally repressed. Some were simply
murdered, many more arrested and placed into prison camps where many died.
Which shows, in its own way, a key difference between Lenin's and Stalin's
regime. Under Lenin, the opposition **outside** the party was brutally
repressed. Stalin simply applied the methods used by Lenin outside the party
to oppositions within it. As Emma Goldman summarised:

> _"It does not occur to him that one might detest the savage in the Kremlin
> and his cruel regime and yet not exonerate Leon Trotsky . . . In point of
> truth I see no marked difference between the two protagonists of the
> benevolent system of the dictatorship except that Leon Trotsky is no longer
> in power to enforce its blessings, and Josef Stalin is. No, I hold no brief
> for the present ruler of Russia. I must, however, point out that Stalin did
> not come down as a gift from heaven to the hapless Russian people. He is
> merely continuing the Bolshevik traditions, even if in a more relentless
> manner."_ [ _"Trotsky protests too much"_ , **Writings of Emma Goldman** ,
> p. 251]

Ultimately, Trotsky's "opposition" to the regime he helped shape so much was
based on the utopian notion that there could be a benevolent dictatorship.
That he was sincere in his illusions is as irrelevant as to pointing to a
better internal party regime to differentiate Lenin's regime from Stalin's.

## 4 What do these oppositions tell us about the essence of Leninism?

The history and ideas of these oppositions are important in evaluating the
claims of Leninists. If, as modern-day supporters of Bolshevism argue,
Leninism is inherently democratic then we have to come to the conclusion that
none of the party oppositions represented the real Leninist tradition. Given
that many Trotskyists support the "Left Opposition" as the only alternative to
Stalinism, defending the true essence of Bolshevism (see [last
section](append31.md#app15) for details), we can only wonder what the
**real** Bolshevik tradition is. After all, the "Left Opposition"
wholeheartedly supported party dictatorship, remained silent on workers'
control and urged the speeding up of industrialisation to meet military
competition from the west -- all things which Leninists say they oppose in
Stalinism as being incompatible with genuine socialism.

However, there were groups which did raise more substantial critiques of
mainstream Bolshevism and did so while Lenin and Trotsky were heads of the
State. How Lenin and Trotsky responded to them is significant. Rather than
embrace them as expressing what they (according to Leninists) **really** stood
for, they used state repression to break them. This, anarchists argue, shows
the essence of Leninism was expressed by the regime Lenin and Trotsky had
created -- and now defended -- rather than selective quoting and wishful
thinking about the "Left Opposition".

The only groups associated with the Bolshevik party which advocated democracy
for working people were the dissidents of the "Workers' Truth" and "Workers'
Group." Both were expelled from the party and their members arrested by the
Bolsheviks. The latter group is better known and so, by necessity, we will
concentrate on that. It was also the largest and boldest, composed mainly of
workers. It attacked the _"purely bureaucratic way"_ industry was run and
urging _"the direct participation of the working class"_ in it. However,
unlike the "Workers' Opposition", the "Workers' Group" extended their call for
workers' democracy to beyond the workplace and party. They wondered if the
proletariat might not be _"compelled once again to start anew the struggle . .
. for the overthrow of the oligarchy."_ They noted that ruling clique in the
party _"will tolerate no criticism, since it considers itself just as
infallible as the Pope of Rome."_ [quoted by E.H. Carr, **The Interregnum
1923-1924** , p. 82 and p. 269]

The "Workers' Group" is associated with the old worker Bolshevik G. T.
Miasnikov, its founder and leading thinker (see Paul Avrich's _"Bolshevik
Opposition to Lenin: G. T. Miasnikov and the Workers' Group"_ [ **The Russian
Review** , Vol. 43, No. 1, pp. 1-29] for more details). As Ante Ciliga
recalled about the political debate in the prison camps in the late 1920s and
early 1930s (for was more freedom of expression in prison than in Bolshevik
society):

> _"In the criticism of the Lenin of the revolutionary period the tone was set
> by . . . the Workers Group . . . [It was], in origin, from the Bolshevik old
> guard. But . . . they criticised Lenin's course of action from the
> beginning, and not on details but as a whole. The Workers Opposition
> denounced Lenin's economic line. The Workers Group went even farther and
> attacked the political regime and the single party established by Lenin
> prior to the NEP [that is before the spring of 1921, when the New Economic
> Policy (NEP) was introduced]. . ._

> _"Having put as the basis of its programme Marx's watchword for the 1st
> International -- 'The emancipation of the workers must be the task of the
> workers themselves' -- the Workers Group declared war from the start on the
> Leninist concept of the 'dictatorship of the party' and the bureaucratic
> organisation of production, enunciated by Lenin in the initial period of the
> revolution's decline. Against the Leninist line, they demanded organisation
> of production by the masses themselves, beginning with factory collectives.
> Politically, the Workers Group demanded the control of power and of the
> party by the worker masses. These, the true political leaders of the
> country, must have the right to withdraw power from any political party,
> even from the Communist Party, if they judged that that party was not
> defending their interests. Contrary to . . . the majority of the Workers'
> Opposition, for whom the demand for 'workers' democracy' was practically
> limited to the economic domain, and who tried to reconcile it with the
> 'single party,' the Workers Group extended its struggle for workers'
> democracy to the demand for the workers to choose among competing political
> parties of the worker milieu. Socialism could only be the work of free
> creation by the workers. While that which was being constructed by coercion,
> and given the name of socialism, was for them nothing but bureaucratic State
> capitalism from the very beginning."_ [ **The Russian Enigma** , pp. 277-8]

The group had its origins when Miasnikov had exposed the abuses he had seen
first hand in Lenin's regime. In 1921, he stated the obvious that _"[i]t
stands to reason that workers' democracy presupposes not only the right to
vote but also freedom of speech and press. If workers who govern the country,
manage factories, do not have freedom of speech, we get a highly abnormal
state."_ He urged total freedom of speech for all. He discussed corruption
within the party, noting that a _"special type of Communist is evolving. He is
forward, sensible, and, what counts most, he knows how to please his
superiors, which the latter like only too much."_ Furthermore, _"[i]f one of
the party rank and file dares to have an opinion of his own, he is looked upon
as a heretic and people scoff at him saying, 'Wouldn't Ilyitch (Lenin) have
come to this idea if it were timely now? So you are the only clever man
around, eh, you want to be wiser than all? Ha, ha, ha! You want to be clever
than Ilyitch!' This is the typical 'argumentation' of the honourable Communist
fraternity."_ _"Any one who ventures a critical opinion of his own,"_ he
noted, _"will be labelled a Menshevik or Social-Revolutionist, with all the
consequences that entails."_ [quoted by G. P. Maximoff, **The Guillotine at
Work** , p. 269 and p. 268]

Lenin tried to reply to Miasnikov's demand for freedom of speech. Freedom of
the press, Lenin argued, would, under existing circumstances, strengthen the
forces of counter-revolution. Lenin rejected freedom in the abstract: _"
**what sort** of freedom of the press? What **for**? For **which class**?"_
_"We do not believe in 'absolutes.' We laugh at 'pure democracy,'"_ he
asserted. Freedom of press in Russia, Lenin maintained, _"surrounded by the
bourgeois enemies of the whole world, means freedom of **political
organisation** for the bourgeoisie and its most loyal servants, the Mensheviks
and Socialist Revolutionaries"_ and so _"means facilitating the enemy's task,
means helping the class enemy."_ In short: _"We have no wish to commit
suicide, and therefore, we will not do this."_ According to Lenin, freedom of
speech was a _"non-party, **anti-proletarian** slogan"_ as well as _"an
obvious political mistake."_ [ **Collected Works** , Vol. 32, pp. 504-8]

Miasnikov -- rightly -- was not convinced by Lenin's arguments. He wrote a
strong reply reminding Lenin of his revolutionary credentials:

> _"You say that I want freedom of the press for the bourgeoisie. On the
> contrary, I want freedom of the press for myself, a proletarian, a member of
> the party for fifteen years, who has been a party member in Russia and not
> abroad. I spent seven and a half of the eleven years of my party membership
> before 1917 in prisons and at hard labour, with a total of seventy-five days
> in hunger strikes. I was mercilessly beaten and subjected to other tortures
> . . . I escaped not abroad [like Lenin], but for party work here in Russia.
> To me one can grant at least a little freedom of press. Or is it that I must
> leave or be expelled from the party as soon as I disagree with you in the
> evaluation of social forces? Such simplified treatment evades but does not
> tackle our problems . . ._

> _"To break the jaws of international bourgeoisie, is all very well, but the
> trouble is that, you raise your hand against the bourgeoisie and you strike
> at the worker. Which class now supplies the greatest numbers of people
> arrested on charges of counter-revolution? Peasants and workers, to be sure.
> There is no Communist working class. There is just a working class pure and
> simple . . . "_

> _"Don't you know that thousands of proletarians are kept in prison because
> they talked the way I am talking now, and that bourgeois people are not
> arrested on this score for the simple reason that they are never concerned
> with these questions? If I am still at large, that is so because of my
> standing as a Communist. I have suffered for my Communist views; moreover, I
> am known by the workers; were it not for these facts, were I just an
> ordinary Communist mechanic from the same factory, where would I be now? In
> the Che-Ka [prison], or more than this, I would be made to 'escape', just as
> I made Mikhail Romanov (Tsar's brother) 'escape', as Luxemburg and
> Liebknecht were made to 'escape'. Once more I say: you raise your hand
> against the bourgeoisie, but it is I who am spitting blood, and it is we,
> the workers, whose jaws are being cracked."_ [quoted by Maximoff, **Op.
> Cit.** , pp. 270-1]

After engaging in political activity in his home area, Miasnikov was summoned
to Moscow and placed under the control of the Central Committee. In defiance
of it, he returned to the Urals and resumed his agitation. At the end of
August in 1922 he appeared before a general meeting of Motovilikha party
members and succeeded in winning them over to his side. Adopting a resolution
against the censure of Miasnikov by the Central Committee's Organisational
Bureau (Orgburo), they branded his transfer to Moscow a form of _"banishment"_
and demanded that he be allowed _"full freedom of speech and press within the
party."_ [quoted by Avrich, _"Bolshevik Opposition To Lenin: G. Miasnikov and
the Workers Group"_ , **The Russian Review** , Vol. 43, No. 1, p. 12]

On 25 November he wrote to a sympathiser in Petrograd urging a campaign of
agitation in preparation for the 11th party congress. By now Miasnikov was
being watched by the Cheka and his letter was intercepted. For Lenin, this was
the last straw. _"We must devote greater attention to Miasnikov's agitation,"_
he wrote to Molotov on 5 December, _"and to report on it to the Politburo
twice a month."_ [quoted by Avrich, **Op. Cit.** , p. 13] To deal with
Miasnikov, meanwhile, the Orgburo formed a new commission which recommended
his expulsion from the party, which was agreed by the Central Committee's
Political Bureau (Politburo) on 20 February 1922. This was the first instance,
except for the brief expulsion of S. A. Lozovsky in 1918, where Lenin actually
expelled a well-known Bolshevik of long standing.

By the start of 1923, Miasnikov had organised a clandestine opposition and
formed (despite his expulsion) the "Workers' Group of the Russian Communist
Party." He claimed that it, and not the Bolshevik leadership, represented the
authentic voice of the proletariat. P. B. Moiseev, a Bolshevik since 1914, and
N. V. Kuznetsov, a former member of the "Workers' Opposition", joined the
group. The three men, all workers, constituted themselves as its _"Provisional
Central Organisational Bureau"_. Their first act, in February 1923, was to
draw up a statement of principles in anticipation of the Twelfth Party
Congress called the _"Manifesto of the Workers' Group of the Russian Communist
Party,"_ amongst other things _"denouncing the New Exploitation of the
Proletariat and urging the workers to fight for soviet democracy"_. [I.
Deutscher, **The Prophet Unarmed** , p.107]

The manifesto recapitulated the program of Miasnikov's earlier arguments:
workers' self-determination and self-management, the removal of bourgeois
specialists from positions of authority, freedom of discussion within the
party, and the election of new soviets centred in the factories. It protested
against administrative high-handedness, the expanding bureaucracy, the
predominance of non-workers within the party, and the suppression of local
initiative and debate. It argued that in spite of the abolition of private
ownership, the worst features of capitalism had been preserved: wage slavery,
differences of income and status, hierarchical authority, bureaucratism. In
its words, the _"organisation of this industry since the Ninth Congress of the
RCP(b) is carried out without the direct participation of the working class by
nominations in a purely bureaucratic way."_ [quoted by Daniels, **Op. Cit.** ,
p. 204] It asked:

> _"What are we being told [by the Bolshevik leadership]? 'You sit quiet, go
> out and demonstrate when you're invited, sing the Internationale -- when
> required -- and the rest will be done without you, by first-class people who
> are almost the same sort of workers as you, only cleverer.' . . . But what
> we need is a practice based on the self-activity of the working class, not
> on the party's fear of it."_ [quoted by Simon Pirani, **The Russian
> Revolution in Retreat** , p. 142]

Within the party the manifesto defended the right to form factions and draw up
platforms. _"If criticism does not have a distinct point of view,"_ Miasnikov
wrote to Zinoviev, _"a platform on which to rally a majority of party members,
on which to develop a new policy with regard to this or that question, then it
is not really criticism but a mere collection of words, nothing but chatter."_
He went even further, calling into question the Bolshevik monopoly of power.
Under a single-party dictatorship, he argued, elections remained _"an empty
formality."_ To speak of _"workers' democracy"_ while insisting on one-party
government, he told Zinoviev, was to entwine oneself in a contradiction, a
_"contradiction in terms."_ [quoted by Avrich, **Op. Cit.** , pp. 19-20]

Miasnikov was arrested by the GPU (the new name for the Cheka) on 25 May 1923,
a month after the Twelfth Party Congress (the rest of the group's leadership
was soon to follow). Miasnikov was released from custody and permitted to
leave for Germany (this was a device not infrequently used by the authorities
to rid themselves of dissenters -- for example, many Russian anarchists were
deported in 1921). In Berlin he formed ties with the council communists of the
German Communist Workers' Party (KAPD) and with the left wing of the German
Communist Party. With the aid of these groups, Miasnikov was able to publish
the manifesto of the Workers' Group, prefaced by an appeal drafted by his
associates in Moscow. The appeal concluded with a set of slogans proclaiming
the aims of the Workers' Group: _"The strength of the working class lies in
its solidarity. Long live freedom of speech and press for the proletarians!
Long live Soviet Power! Long live Proletarian Democracy! Long live
Communism!"_ [quoted by Avrich, **Op. Cit.** , p. 22]

Inside Russia the manifesto was having an effect. Fresh recruits were drawn
into the Workers' Group. It established ties with discontented workers in
several cities and began negotiations with leaders of the now defunct
"Workers' Opposition". The group won support within the Red Army garrison
quartered in the Kremlin, a company of which had to be transferred to
Smolensk. By summer of 1923 the group had some 300 members in Moscow, as well
as a sprinkling of adherents in other cities. Many were Old Bolsheviks, and
nearly all were workers. Soon an unexpected opportunity for the group to
extend its influence arrived. In August and September 1923 a wave of strikes
(which recalled the strike wave of February 1921 which inspired the Kronstadt
sailors to rebel) swept Russia's industrial centres. An economic crisis had
been deepening since the beginning of the year, bringing cuts in wages and the
dismissal of large numbers of workers. The resulting strikes, which broke out
in Moscow and other cities, were spontaneous and no evidence existed to
connect them with any oppositionist faction. The Workers' Group, however,
sought to take advantage of the unrest to oppose the party leadership.
Stepping up its agitation, it considered calling a one-day general strike and
organising a mass demonstration of workers on the lines of Bloody Sunday 1905
with a portrait of Lenin (rather than the Tzar) at its head.

The authorities became alarmed. The _"party leaders"_ were _"determined to
suppress the Workers' Group and the Workers' Truth"_ and ordered the GPU into
action. [I. Deutscher, **Op. Cit.** , p. 108] By the end of September its
meeting places had been raided, literature seized, and leaders arrested.
Twelve members were expelled from the party and fourteen others received
reprimands. Miasnikov was considered such a threat that in the autumn of 1923
he was lured back to Russia on assurances from Zinoviev and Krestinsky, the
Soviet ambassador in Berlin, that he would not be arrested. Once in Russia he
was immediately placed behind bars, arrested by Dzerzhinsky himself (the
infamous creator and head of the Cheka) as a sign of the gravity with which
the government viewed the situation.

This response is significant, simply because Trotsky was still an influential
member of the Communist Party leadership and, given that for most modern day
Leninists he raised the banner of authentic Leninism against the obvious evils
of Stalinism, it casts a light on the nature of Bolshevism. More, for as Paul
Avrich points out, _"[i]n January 1924, Lenin died. By then the Workers' Group
had been silenced. It was the last dissident movement within the party to be
liquidated while Lenin was still alive. It was also the last rank-and-file
group to be smashed with the blessing of all the top Soviet leaders, who now
began their struggle for Lenin's mantle."_ [ **Op. Cit.** , p. 24]

Thus the response of Trotsky is particularly important. As Deutscher notes,
Trotsky _"did not protest"_ when the dissidents _"were thrown into prison."_
Dzerzhinsky, the head of the GPU (the renamed Cheka) was given the task of
breaking the opposition groups by the central committee and _"found that even
party members of unquestioned loyalty regarded them as comrades and refused to
testify against them. He then turned to the Politburo and asked it to declare
it was the duty of any party member to denounce to the GPU people inside the
party engaged aggressive action against the official leaders."_ Trotsky _"did
not tell the Politburo plainly that it should reject Dzerzhinsky's demand. He
evaded the question."_ [ **Op. Cit.** , pp. 108-9]

Neo-Trotskyist Tony Cliff presents a similar picture of Trotsky's lack of
concern for opposition groups and his utter failure to support working class
self-activity or calls for **real** democracy. He notes that in July and
August 1923 Moscow and Petrograd _"were shaken by industrial unrest . . .
Unofficial strikes broke out in many places . . . In November 1923, rumours of
a general strike circulated throughout Moscow, and the movement seems at the
point of turning into a political revolt. Not since the Kronstadt rising of
1921 had there been so much tension in the working class and so much alarm in
the ruling circles."_ The ruling elite, including Trotsky, acted to maintain
their position and the secret police turned on any political group which could
influence the movement. The _"strike wave gave a new lease of life to the
Mensheviks"_ and so _"the GPU carried out a massive round up of Mensheviks,
and as many as one thousand were arrested in Moscow alone."_ When it was the
turn of the Workers Group and Workers Truth, Trotsky _"did not condemn their
persecution"_ and he _"did not support their incitement of workers to
industrial unrest."_ Moreover, _"[n]or was Trotsky ready to support the demand
for workers' democracy in the extreme form to which the Workers Group and
Workers Truth raised it."_ [ **Trotsky** , vol. 3, p. 25, p. 26 and pp. 26-7]

By _"extreme,"_ Cliff obviously meant _"genuine"_ as Trotsky did not call for
workers' democracy in any meaningful form (as Cliff acknowledged elsewhere in
his book). Indeed, the _"New Course Resolution"_ \-- a key document of the
"Left Opposition" -- stated _"it is obvious that there can be no toleration of
the formation of groupings whose ideological content is directed against the
party as a whole and against the dictatorship of the proletariat. as for
instance the Workers' Truth and Workers' Group."_ Trotsky himself was at pains
to distance himself from Miasnikov. [ **The Challenge of the "Left Opposition"
(1923-25)** , p. 408 and p. 80] The resolution made it clear that it
considered the dictatorship of the proletariat to be incompatible with
**real** workers democracy given that both these groups advocated actual
soviet and trade union democracy. Indeed, the orthodoxy was reiterated: the
dictatorship of the party **was** the dictatorship of the proletariat.

Thus we come to the strange fact that it was Lenin and Trotsky themselves who
knowingly destroyed the groups which represent what modern day Leninists
assert is the "real" essence of Leninism. Furthermore, modern day Leninists
generally ignore or dismiss these opposition groups when they discuss
alternatives to Stalinism (precisely because they raised their voices on
danger of bureaucratisation **under Lenin** we would suggest). This seems a
strange fate to befall tendencies which, if we take Leninists at their word,
expressed what their tradition stands for. Equally, in spite of their support
for party dictatorship, the "Workers' Opposition" did have some constructive
suggestions to make as regards combating the large-scale bureaucratisation
which existed under Lenin. Yet almost all modern Leninists (like Lenin and
Trotsky before them) dismiss it as utopian. Which is, of course, significant
about the **real** essence of Leninism.

As noted as regards the "Left Communists" and "Workers' Opposition," their
economic reforms were fatally undermined by their Marxist prejudices and they
supported the dominant position of the party. While the "Workers Group" was
more advanced than either in their opposition to party dictatorship,
ultimately the same problem existed -- their opposition (like that of the
left-Mensheviks during the civil war) was premised on certain Marxist dogmas
which would have produced some kind of class society due to its prejudices in
favour of centralisation and representative democracy (see [section
H](secHcon.md)). The key issue is, then, is not whether their alternative
would have produced genuine -- that is, libertarian -- socialism nor, indeed,
what their alternative was as such but rather that they were repressed under
Lenin and Trotsky for advocating ideas modern-day Leninists say they support
-- **precisely because they are Leninists and Trotskyists**. Yet actions speak
louder than words.

Ultimately, the only real alternative existed outwith the party and Leninism.
Whether this was recognising the real sources for its failures (as shown by
numerous anarchist thinkers at the time, not least eye-witnesses like Emma
Goldman and Alexander Berkman) or by creating an actual mass libertarian
alternative in the Ukraine (see the appendix ["Why does the Makhnovist
movement show there is an alternative to Bolshevism?"](append46.md)). Yet
discussing the various Bolshevik oppositions is helpful to understanding why
the revolution failed: for the nature of the various oppositions within the
party and the fate of such real dissidents as the "Workers' Group" says far
more about the real reasons the Russian revolution failed than Trotskyist
books on the matter. It proves that the essence of Bolshevism is not a
democratic one but rather a deeply authoritarian one hidden (at times) behind
libertarian sounding rhetoric. Faced with opposition which were somewhat
libertarian, the response of Lenin and Trotsky was to repress them.

In summary, the various opposition groups within Bolshevism were not
alternatives and instead show that the problems of the revolution and
subsequent civil war did not create but rather revealed Bolshevism's
authoritarian core.

[‹ How did Bolshevik ideology contribute to the failure of the
Revolution?](append44.md "Go to previous page") [up](append4.md "Go to
parent page") [Why does the Makhnovist movement show there is an alternative
to Bolshevism? ›](append46.md "Go to next page")

