/* Bindings of osmesa.ldg
 * Compile this module and link it with the application client
 */

#include <gem.h>
#include <ldg.h>
#define NFOSMESA_NO_MANGLE
#include <ldg/osmesa.h>

#ifndef TRUE
# define TRUE 1
# define FALSE 0
#endif

struct _gl_osmesa gl;

#if defined(__PUREC__) && !defined(__AHCC__)
/*
 * Pure-C is not able to compile the result if you enable it,
 * probable the function gets too large
 */
# define GL_CHECK(x)
#else
# define GL_CHECK(x) if (x == 0) result = FALSE
#endif

int ldg_init_osmesa(LDG *lib)
{
	int result = TRUE;
	
#undef glFrustum
#undef glOrtho
#undef gluLookAt
#undef glClearDepth
	gl.OSMesaColorClamp = (void APIENTRY (*)(GLboolean32 enable)) ldg_find("OSMesaColorClamp", lib);
	GL_CHECK(gl.OSMesaColorClamp);
	gl.OSMesaCreateContext = (OSMesaContext APIENTRY (*)(GLenum format, OSMesaContext sharelist)) ldg_find("OSMesaCreateContext", lib);
	GL_CHECK(gl.OSMesaCreateContext);
	gl.OSMesaCreateContextExt = (OSMesaContext APIENTRY (*)(GLenum format, GLint depthBits, GLint stencilBits, GLint accumBits, OSMesaContext sharelist)) ldg_find("OSMesaCreateContextExt", lib);
	GL_CHECK(gl.OSMesaCreateContextExt);
	gl.OSMesaCreateLDG = (void * APIENTRY (*)(GLenum format, GLenum type, GLint width, GLint height)) ldg_find("OSMesaCreateLDG", lib);
	GL_CHECK(gl.OSMesaCreateLDG);
	gl.OSMesaDestroyContext = (void APIENTRY (*)(OSMesaContext ctx)) ldg_find("OSMesaDestroyContext", lib);
	GL_CHECK(gl.OSMesaDestroyContext);
	gl.OSMesaDestroyLDG = (void APIENTRY (*)(void)) ldg_find("OSMesaDestroyLDG", lib);
	GL_CHECK(gl.OSMesaDestroyLDG);
	gl.OSMesaGetColorBuffer = (GLboolean APIENTRY (*)(OSMesaContext c, GLint *width, GLint *height, GLint *format, void * *buffer)) ldg_find("OSMesaGetColorBuffer", lib);
	GL_CHECK(gl.OSMesaGetColorBuffer);
	gl.OSMesaGetCurrentContext = (OSMesaContext APIENTRY (*)(void)) ldg_find("OSMesaGetCurrentContext", lib);
	GL_CHECK(gl.OSMesaGetCurrentContext);
	gl.OSMesaGetDepthBuffer = (GLboolean APIENTRY (*)(OSMesaContext c, GLint *width, GLint *height, GLint *bytesPerValue, void * *buffer)) ldg_find("OSMesaGetDepthBuffer", lib);
	GL_CHECK(gl.OSMesaGetDepthBuffer);
	gl.OSMesaGetIntegerv = (void APIENTRY (*)(GLint pname, GLint *value)) ldg_find("OSMesaGetIntegerv", lib);
	GL_CHECK(gl.OSMesaGetIntegerv);
	gl.OSMesaGetProcAddress = (OSMESAproc APIENTRY (*)(const char *funcName)) ldg_find("OSMesaGetProcAddress", lib);
	GL_CHECK(gl.OSMesaGetProcAddress);
	gl.OSMesaMakeCurrent = (GLboolean APIENTRY (*)(OSMesaContext ctx, void *buffer, GLenum type, GLsizei width, GLsizei height)) ldg_find("OSMesaMakeCurrent", lib);
	GL_CHECK(gl.OSMesaMakeCurrent);
	gl.OSMesaPixelStore = (void APIENTRY (*)(GLint pname, GLint value)) ldg_find("OSMesaPixelStore", lib);
	GL_CHECK(gl.OSMesaPixelStore);
	gl.OSMesaPostprocess = (void APIENTRY (*)(OSMesaContext osmesa, const char *filter, GLuint enable_value)) ldg_find("OSMesaPostprocess", lib);
	GL_CHECK(gl.OSMesaPostprocess);
	gl.exception_error = (void APIENTRY (*)(void (CALLBACK *exception)(GLenum param) )) ldg_find("exception_error", lib);
	GL_CHECK(gl.exception_error);
	gl.Accum = (void APIENTRY (*)(GLenum op, GLfloat value)) ldg_find("glAccum", lib);
	GL_CHECK(gl.Accum);
	gl.AccumxOES = (void APIENTRY (*)(GLenum op, GLfixed value)) ldg_find("glAccumxOES", lib);
	GL_CHECK(gl.AccumxOES);
	gl.ActiveProgramEXT = (void APIENTRY (*)(GLuint program)) ldg_find("glActiveProgramEXT", lib);
	GL_CHECK(gl.ActiveProgramEXT);
	gl.ActiveShaderProgram = (void APIENTRY (*)(GLuint pipeline, GLuint program)) ldg_find("glActiveShaderProgram", lib);
	GL_CHECK(gl.ActiveShaderProgram);
	gl.ActiveStencilFaceEXT = (void APIENTRY (*)(GLenum face)) ldg_find("glActiveStencilFaceEXT", lib);
	GL_CHECK(gl.ActiveStencilFaceEXT);
	gl.ActiveTexture = (void APIENTRY (*)(GLenum texture)) ldg_find("glActiveTexture", lib);
	GL_CHECK(gl.ActiveTexture);
	gl.ActiveTextureARB = (void APIENTRY (*)(GLenum texture)) ldg_find("glActiveTextureARB", lib);
	GL_CHECK(gl.ActiveTextureARB);
	gl.ActiveVaryingNV = (void APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glActiveVaryingNV", lib);
	GL_CHECK(gl.ActiveVaryingNV);
	gl.AddSwapHintRectWIN = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glAddSwapHintRectWIN", lib);
	GL_CHECK(gl.AddSwapHintRectWIN);
	gl.AlphaFragmentOp1ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)) ldg_find("glAlphaFragmentOp1ATI", lib);
	GL_CHECK(gl.AlphaFragmentOp1ATI);
	gl.AlphaFragmentOp2ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)) ldg_find("glAlphaFragmentOp2ATI", lib);
	GL_CHECK(gl.AlphaFragmentOp2ATI);
	gl.AlphaFragmentOp3ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)) ldg_find("glAlphaFragmentOp3ATI", lib);
	GL_CHECK(gl.AlphaFragmentOp3ATI);
	gl.AlphaFunc = (void APIENTRY (*)(GLenum func, GLclampf ref)) ldg_find("glAlphaFunc", lib);
	GL_CHECK(gl.AlphaFunc);
	gl.AlphaFuncxOES = (void APIENTRY (*)(GLenum func, GLfixed ref)) ldg_find("glAlphaFuncxOES", lib);
	GL_CHECK(gl.AlphaFuncxOES);
	gl.ApplyTextureEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glApplyTextureEXT", lib);
	GL_CHECK(gl.ApplyTextureEXT);
	gl.AreProgramsResidentNV = (GLboolean APIENTRY (*)(GLsizei n, const GLuint *programs, GLboolean *residences)) ldg_find("glAreProgramsResidentNV", lib);
	GL_CHECK(gl.AreProgramsResidentNV);
	gl.AreTexturesResident = (GLboolean APIENTRY (*)(GLsizei n, const GLuint *textures, GLboolean *residences)) ldg_find("glAreTexturesResident", lib);
	GL_CHECK(gl.AreTexturesResident);
	gl.AreTexturesResidentEXT = (GLboolean APIENTRY (*)(GLsizei n, const GLuint *textures, GLboolean *residences)) ldg_find("glAreTexturesResidentEXT", lib);
	GL_CHECK(gl.AreTexturesResidentEXT);
	gl.ArrayElement = (void APIENTRY (*)(GLint i)) ldg_find("glArrayElement", lib);
	GL_CHECK(gl.ArrayElement);
	gl.ArrayElementEXT = (void APIENTRY (*)(GLint i)) ldg_find("glArrayElementEXT", lib);
	GL_CHECK(gl.ArrayElementEXT);
	gl.ArrayObjectATI = (void APIENTRY (*)(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)) ldg_find("glArrayObjectATI", lib);
	GL_CHECK(gl.ArrayObjectATI);
	gl.AsyncMarkerSGIX = (void APIENTRY (*)(GLuint marker)) ldg_find("glAsyncMarkerSGIX", lib);
	GL_CHECK(gl.AsyncMarkerSGIX);
	gl.AttachObjectARB = (void APIENTRY (*)(GLhandleARB containerObj, GLhandleARB obj)) ldg_find("glAttachObjectARB", lib);
	GL_CHECK(gl.AttachObjectARB);
	gl.AttachShader = (void APIENTRY (*)(GLuint program, GLuint shader)) ldg_find("glAttachShader", lib);
	GL_CHECK(gl.AttachShader);
	gl.Begin = (void APIENTRY (*)(GLenum mode)) ldg_find("glBegin", lib);
	GL_CHECK(gl.Begin);
	gl.BeginConditionalRender = (void APIENTRY (*)(GLuint id, GLenum mode)) ldg_find("glBeginConditionalRender", lib);
	GL_CHECK(gl.BeginConditionalRender);
	gl.BeginConditionalRenderNV = (void APIENTRY (*)(GLuint id, GLenum mode)) ldg_find("glBeginConditionalRenderNV", lib);
	GL_CHECK(gl.BeginConditionalRenderNV);
	gl.BeginConditionalRenderNVX = (void APIENTRY (*)(GLuint id)) ldg_find("glBeginConditionalRenderNVX", lib);
	GL_CHECK(gl.BeginConditionalRenderNVX);
	gl.BeginFragmentShaderATI = (void APIENTRY (*)(void)) ldg_find("glBeginFragmentShaderATI", lib);
	GL_CHECK(gl.BeginFragmentShaderATI);
	gl.BeginOcclusionQueryNV = (void APIENTRY (*)(GLuint id)) ldg_find("glBeginOcclusionQueryNV", lib);
	GL_CHECK(gl.BeginOcclusionQueryNV);
	gl.BeginPerfMonitorAMD = (void APIENTRY (*)(GLuint monitor)) ldg_find("glBeginPerfMonitorAMD", lib);
	GL_CHECK(gl.BeginPerfMonitorAMD);
	gl.BeginPerfQueryINTEL = (void APIENTRY (*)(GLuint queryHandle)) ldg_find("glBeginPerfQueryINTEL", lib);
	GL_CHECK(gl.BeginPerfQueryINTEL);
	gl.BeginQuery = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBeginQuery", lib);
	GL_CHECK(gl.BeginQuery);
	gl.BeginQueryARB = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBeginQueryARB", lib);
	GL_CHECK(gl.BeginQueryARB);
	gl.BeginQueryIndexed = (void APIENTRY (*)(GLenum target, GLuint index, GLuint id)) ldg_find("glBeginQueryIndexed", lib);
	GL_CHECK(gl.BeginQueryIndexed);
	gl.BeginTransformFeedback = (void APIENTRY (*)(GLenum primitiveMode)) ldg_find("glBeginTransformFeedback", lib);
	GL_CHECK(gl.BeginTransformFeedback);
	gl.BeginTransformFeedbackEXT = (void APIENTRY (*)(GLenum primitiveMode)) ldg_find("glBeginTransformFeedbackEXT", lib);
	GL_CHECK(gl.BeginTransformFeedbackEXT);
	gl.BeginTransformFeedbackNV = (void APIENTRY (*)(GLenum primitiveMode)) ldg_find("glBeginTransformFeedbackNV", lib);
	GL_CHECK(gl.BeginTransformFeedbackNV);
	gl.BeginVertexShaderEXT = (void APIENTRY (*)(void)) ldg_find("glBeginVertexShaderEXT", lib);
	GL_CHECK(gl.BeginVertexShaderEXT);
	gl.BeginVideoCaptureNV = (void APIENTRY (*)(GLuint video_capture_slot)) ldg_find("glBeginVideoCaptureNV", lib);
	GL_CHECK(gl.BeginVideoCaptureNV);
	gl.BindAttribLocation = (void APIENTRY (*)(GLuint program, GLuint index, const GLchar *name)) ldg_find("glBindAttribLocation", lib);
	GL_CHECK(gl.BindAttribLocation);
	gl.BindAttribLocationARB = (void APIENTRY (*)(GLhandleARB programObj, GLuint index, const GLcharARB *name)) ldg_find("glBindAttribLocationARB", lib);
	GL_CHECK(gl.BindAttribLocationARB);
	gl.BindBuffer = (void APIENTRY (*)(GLenum target, GLuint buffer)) ldg_find("glBindBuffer", lib);
	GL_CHECK(gl.BindBuffer);
	gl.BindBufferARB = (void APIENTRY (*)(GLenum target, GLuint buffer)) ldg_find("glBindBufferARB", lib);
	GL_CHECK(gl.BindBufferARB);
	gl.BindBufferBase = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer)) ldg_find("glBindBufferBase", lib);
	GL_CHECK(gl.BindBufferBase);
	gl.BindBufferBaseEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer)) ldg_find("glBindBufferBaseEXT", lib);
	GL_CHECK(gl.BindBufferBaseEXT);
	gl.BindBufferBaseNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer)) ldg_find("glBindBufferBaseNV", lib);
	GL_CHECK(gl.BindBufferBaseNV);
	gl.BindBufferOffsetEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset)) ldg_find("glBindBufferOffsetEXT", lib);
	GL_CHECK(gl.BindBufferOffsetEXT);
	gl.BindBufferOffsetNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset)) ldg_find("glBindBufferOffsetNV", lib);
	GL_CHECK(gl.BindBufferOffsetNV);
	gl.BindBufferRange = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glBindBufferRange", lib);
	GL_CHECK(gl.BindBufferRange);
	gl.BindBufferRangeEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glBindBufferRangeEXT", lib);
	GL_CHECK(gl.BindBufferRangeEXT);
	gl.BindBufferRangeNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glBindBufferRangeNV", lib);
	GL_CHECK(gl.BindBufferRangeNV);
	gl.BindBuffersBase = (void APIENTRY (*)(GLenum target, GLuint first, GLsizei count, const GLuint *buffers)) ldg_find("glBindBuffersBase", lib);
	GL_CHECK(gl.BindBuffersBase);
	gl.BindBuffersRange = (void APIENTRY (*)(GLenum target, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizeiptr *sizes)) ldg_find("glBindBuffersRange", lib);
	GL_CHECK(gl.BindBuffersRange);
	gl.BindFragDataLocation = (void APIENTRY (*)(GLuint program, GLuint color, const GLchar *name)) ldg_find("glBindFragDataLocation", lib);
	GL_CHECK(gl.BindFragDataLocation);
	gl.BindFragDataLocationEXT = (void APIENTRY (*)(GLuint program, GLuint color, const GLchar *name)) ldg_find("glBindFragDataLocationEXT", lib);
	GL_CHECK(gl.BindFragDataLocationEXT);
	gl.BindFragDataLocationIndexed = (void APIENTRY (*)(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name)) ldg_find("glBindFragDataLocationIndexed", lib);
	GL_CHECK(gl.BindFragDataLocationIndexed);
	gl.BindFragmentShaderATI = (void APIENTRY (*)(GLuint id)) ldg_find("glBindFragmentShaderATI", lib);
	GL_CHECK(gl.BindFragmentShaderATI);
	gl.BindFramebuffer = (void APIENTRY (*)(GLenum target, GLuint framebuffer)) ldg_find("glBindFramebuffer", lib);
	GL_CHECK(gl.BindFramebuffer);
	gl.BindFramebufferEXT = (void APIENTRY (*)(GLenum target, GLuint framebuffer)) ldg_find("glBindFramebufferEXT", lib);
	GL_CHECK(gl.BindFramebufferEXT);
	gl.BindImageTexture = (void APIENTRY (*)(GLuint unit, GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum access, GLenum format)) ldg_find("glBindImageTexture", lib);
	GL_CHECK(gl.BindImageTexture);
	gl.BindImageTextureEXT = (void APIENTRY (*)(GLuint index, GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum access, GLint format)) ldg_find("glBindImageTextureEXT", lib);
	GL_CHECK(gl.BindImageTextureEXT);
	gl.BindImageTextures = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *textures)) ldg_find("glBindImageTextures", lib);
	GL_CHECK(gl.BindImageTextures);
	gl.BindLightParameterEXT = (GLuint APIENTRY (*)(GLenum light, GLenum value)) ldg_find("glBindLightParameterEXT", lib);
	GL_CHECK(gl.BindLightParameterEXT);
	gl.BindMaterialParameterEXT = (GLuint APIENTRY (*)(GLenum face, GLenum value)) ldg_find("glBindMaterialParameterEXT", lib);
	GL_CHECK(gl.BindMaterialParameterEXT);
	gl.BindMultiTextureEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLuint texture)) ldg_find("glBindMultiTextureEXT", lib);
	GL_CHECK(gl.BindMultiTextureEXT);
	gl.BindParameterEXT = (GLuint APIENTRY (*)(GLenum value)) ldg_find("glBindParameterEXT", lib);
	GL_CHECK(gl.BindParameterEXT);
	gl.BindProgramARB = (void APIENTRY (*)(GLenum target, GLuint program)) ldg_find("glBindProgramARB", lib);
	GL_CHECK(gl.BindProgramARB);
	gl.BindProgramNV = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBindProgramNV", lib);
	GL_CHECK(gl.BindProgramNV);
	gl.BindProgramPipeline = (void APIENTRY (*)(GLuint pipeline)) ldg_find("glBindProgramPipeline", lib);
	GL_CHECK(gl.BindProgramPipeline);
	gl.BindRenderbuffer = (void APIENTRY (*)(GLenum target, GLuint renderbuffer)) ldg_find("glBindRenderbuffer", lib);
	GL_CHECK(gl.BindRenderbuffer);
	gl.BindRenderbufferEXT = (void APIENTRY (*)(GLenum target, GLuint renderbuffer)) ldg_find("glBindRenderbufferEXT", lib);
	GL_CHECK(gl.BindRenderbufferEXT);
	gl.BindSampler = (void APIENTRY (*)(GLuint unit, GLuint sampler)) ldg_find("glBindSampler", lib);
	GL_CHECK(gl.BindSampler);
	gl.BindSamplers = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *samplers)) ldg_find("glBindSamplers", lib);
	GL_CHECK(gl.BindSamplers);
	gl.BindTexGenParameterEXT = (GLuint APIENTRY (*)(GLenum unit, GLenum coord, GLenum value)) ldg_find("glBindTexGenParameterEXT", lib);
	GL_CHECK(gl.BindTexGenParameterEXT);
	gl.BindTexture = (void APIENTRY (*)(GLenum target, GLuint texture)) ldg_find("glBindTexture", lib);
	GL_CHECK(gl.BindTexture);
	gl.BindTextureEXT = (void APIENTRY (*)(GLenum target, GLuint texture)) ldg_find("glBindTextureEXT", lib);
	GL_CHECK(gl.BindTextureEXT);
	gl.BindTextureUnitParameterEXT = (GLuint APIENTRY (*)(GLenum unit, GLenum value)) ldg_find("glBindTextureUnitParameterEXT", lib);
	GL_CHECK(gl.BindTextureUnitParameterEXT);
	gl.BindTextures = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *textures)) ldg_find("glBindTextures", lib);
	GL_CHECK(gl.BindTextures);
	gl.BindTransformFeedback = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBindTransformFeedback", lib);
	GL_CHECK(gl.BindTransformFeedback);
	gl.BindTransformFeedbackNV = (void APIENTRY (*)(GLenum target, GLuint id)) ldg_find("glBindTransformFeedbackNV", lib);
	GL_CHECK(gl.BindTransformFeedbackNV);
	gl.BindVertexArray = (void APIENTRY (*)(GLuint array)) ldg_find("glBindVertexArray", lib);
	GL_CHECK(gl.BindVertexArray);
	gl.BindVertexArrayAPPLE = (void APIENTRY (*)(GLuint array)) ldg_find("glBindVertexArrayAPPLE", lib);
	GL_CHECK(gl.BindVertexArrayAPPLE);
	gl.BindVertexBuffer = (void APIENTRY (*)(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)) ldg_find("glBindVertexBuffer", lib);
	GL_CHECK(gl.BindVertexBuffer);
	gl.BindVertexBuffers = (void APIENTRY (*)(GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides)) ldg_find("glBindVertexBuffers", lib);
	GL_CHECK(gl.BindVertexBuffers);
	gl.BindVertexShaderEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glBindVertexShaderEXT", lib);
	GL_CHECK(gl.BindVertexShaderEXT);
	gl.BindVideoCaptureStreamBufferNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset)) ldg_find("glBindVideoCaptureStreamBufferNV", lib);
	GL_CHECK(gl.BindVideoCaptureStreamBufferNV);
	gl.BindVideoCaptureStreamTextureNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture)) ldg_find("glBindVideoCaptureStreamTextureNV", lib);
	GL_CHECK(gl.BindVideoCaptureStreamTextureNV);
	gl.Binormal3bEXT = (void APIENTRY (*)(GLbyte32 bx, GLbyte32 by, GLbyte32 bz)) ldg_find("glBinormal3bEXT", lib);
	GL_CHECK(gl.Binormal3bEXT);
	gl.Binormal3bvEXT = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glBinormal3bvEXT", lib);
	GL_CHECK(gl.Binormal3bvEXT);
	gl.Binormal3dEXT = (void APIENTRY (*)(GLdouble bx, GLdouble by, GLdouble bz)) ldg_find("glBinormal3dEXT", lib);
	GL_CHECK(gl.Binormal3dEXT);
	gl.Binormal3dvEXT = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glBinormal3dvEXT", lib);
	GL_CHECK(gl.Binormal3dvEXT);
	gl.Binormal3fEXT = (void APIENTRY (*)(GLfloat bx, GLfloat by, GLfloat bz)) ldg_find("glBinormal3fEXT", lib);
	GL_CHECK(gl.Binormal3fEXT);
	gl.Binormal3fvEXT = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glBinormal3fvEXT", lib);
	GL_CHECK(gl.Binormal3fvEXT);
	gl.Binormal3iEXT = (void APIENTRY (*)(GLint bx, GLint by, GLint bz)) ldg_find("glBinormal3iEXT", lib);
	GL_CHECK(gl.Binormal3iEXT);
	gl.Binormal3ivEXT = (void APIENTRY (*)(const GLint *v)) ldg_find("glBinormal3ivEXT", lib);
	GL_CHECK(gl.Binormal3ivEXT);
	gl.Binormal3sEXT = (void APIENTRY (*)(GLshort32 bx, GLshort32 by, GLshort32 bz)) ldg_find("glBinormal3sEXT", lib);
	GL_CHECK(gl.Binormal3sEXT);
	gl.Binormal3svEXT = (void APIENTRY (*)(const GLshort *v)) ldg_find("glBinormal3svEXT", lib);
	GL_CHECK(gl.Binormal3svEXT);
	gl.BinormalPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glBinormalPointerEXT", lib);
	GL_CHECK(gl.BinormalPointerEXT);
	gl.Bitmap = (void APIENTRY (*)(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap)) ldg_find("glBitmap", lib);
	GL_CHECK(gl.Bitmap);
	gl.BitmapxOES = (void APIENTRY (*)(GLsizei width, GLsizei height, GLfixed xorig, GLfixed yorig, GLfixed xmove, GLfixed ymove, const GLubyte *bitmap)) ldg_find("glBitmapxOES", lib);
	GL_CHECK(gl.BitmapxOES);
	gl.BlendBarrierNV = (void APIENTRY (*)(void)) ldg_find("glBlendBarrierNV", lib);
	GL_CHECK(gl.BlendBarrierNV);
	gl.BlendColor = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glBlendColor", lib);
	GL_CHECK(gl.BlendColor);
	gl.BlendColorEXT = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glBlendColorEXT", lib);
	GL_CHECK(gl.BlendColorEXT);
	gl.BlendColorxOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glBlendColorxOES", lib);
	GL_CHECK(gl.BlendColorxOES);
	gl.BlendEquation = (void APIENTRY (*)(GLenum mode)) ldg_find("glBlendEquation", lib);
	GL_CHECK(gl.BlendEquation);
	gl.BlendEquationEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glBlendEquationEXT", lib);
	GL_CHECK(gl.BlendEquationEXT);
	gl.BlendEquationIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum mode)) ldg_find("glBlendEquationIndexedAMD", lib);
	GL_CHECK(gl.BlendEquationIndexedAMD);
	gl.BlendEquationSeparate = (void APIENTRY (*)(GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparate", lib);
	GL_CHECK(gl.BlendEquationSeparate);
	gl.BlendEquationSeparateATI = (void APIENTRY (*)(GLenum equationRGB, GLenum equationAlpha)) ldg_find("glBlendEquationSeparateATI", lib);
	GL_CHECK(gl.BlendEquationSeparateATI);
	gl.BlendEquationSeparateEXT = (void APIENTRY (*)(GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparateEXT", lib);
	GL_CHECK(gl.BlendEquationSeparateEXT);
	gl.BlendEquationSeparateIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparateIndexedAMD", lib);
	GL_CHECK(gl.BlendEquationSeparateIndexedAMD);
	gl.BlendEquationSeparatei = (void APIENTRY (*)(GLuint buf, GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparatei", lib);
	GL_CHECK(gl.BlendEquationSeparatei);
	gl.BlendEquationSeparateiARB = (void APIENTRY (*)(GLuint buf, GLenum modeRGB, GLenum modeAlpha)) ldg_find("glBlendEquationSeparateiARB", lib);
	GL_CHECK(gl.BlendEquationSeparateiARB);
	gl.BlendEquationi = (void APIENTRY (*)(GLuint buf, GLenum mode)) ldg_find("glBlendEquationi", lib);
	GL_CHECK(gl.BlendEquationi);
	gl.BlendEquationiARB = (void APIENTRY (*)(GLuint buf, GLenum mode)) ldg_find("glBlendEquationiARB", lib);
	GL_CHECK(gl.BlendEquationiARB);
	gl.BlendFunc = (void APIENTRY (*)(GLenum sfactor, GLenum dfactor)) ldg_find("glBlendFunc", lib);
	GL_CHECK(gl.BlendFunc);
	gl.BlendFuncIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum src, GLenum dst)) ldg_find("glBlendFuncIndexedAMD", lib);
	GL_CHECK(gl.BlendFuncIndexedAMD);
	gl.BlendFuncSeparate = (void APIENTRY (*)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)) ldg_find("glBlendFuncSeparate", lib);
	GL_CHECK(gl.BlendFuncSeparate);
	gl.BlendFuncSeparateEXT = (void APIENTRY (*)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)) ldg_find("glBlendFuncSeparateEXT", lib);
	GL_CHECK(gl.BlendFuncSeparateEXT);
	gl.BlendFuncSeparateINGR = (void APIENTRY (*)(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)) ldg_find("glBlendFuncSeparateINGR", lib);
	GL_CHECK(gl.BlendFuncSeparateINGR);
	gl.BlendFuncSeparateIndexedAMD = (void APIENTRY (*)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)) ldg_find("glBlendFuncSeparateIndexedAMD", lib);
	GL_CHECK(gl.BlendFuncSeparateIndexedAMD);
	gl.BlendFuncSeparatei = (void APIENTRY (*)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)) ldg_find("glBlendFuncSeparatei", lib);
	GL_CHECK(gl.BlendFuncSeparatei);
	gl.BlendFuncSeparateiARB = (void APIENTRY (*)(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)) ldg_find("glBlendFuncSeparateiARB", lib);
	GL_CHECK(gl.BlendFuncSeparateiARB);
	gl.BlendFunci = (void APIENTRY (*)(GLuint buf, GLenum src, GLenum dst)) ldg_find("glBlendFunci", lib);
	GL_CHECK(gl.BlendFunci);
	gl.BlendFunciARB = (void APIENTRY (*)(GLuint buf, GLenum src, GLenum dst)) ldg_find("glBlendFunciARB", lib);
	GL_CHECK(gl.BlendFunciARB);
	gl.BlendParameteriNV = (void APIENTRY (*)(GLenum pname, GLint value)) ldg_find("glBlendParameteriNV", lib);
	GL_CHECK(gl.BlendParameteriNV);
	gl.BlitFramebuffer = (void APIENTRY (*)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)) ldg_find("glBlitFramebuffer", lib);
	GL_CHECK(gl.BlitFramebuffer);
	gl.BlitFramebufferEXT = (void APIENTRY (*)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)) ldg_find("glBlitFramebufferEXT", lib);
	GL_CHECK(gl.BlitFramebufferEXT);
	gl.BufferAddressRangeNV = (void APIENTRY (*)(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length)) ldg_find("glBufferAddressRangeNV", lib);
	GL_CHECK(gl.BufferAddressRangeNV);
	gl.BufferData = (void APIENTRY (*)(GLenum target, GLsizeiptr size, const void *data, GLenum usage)) ldg_find("glBufferData", lib);
	GL_CHECK(gl.BufferData);
	gl.BufferDataARB = (void APIENTRY (*)(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage)) ldg_find("glBufferDataARB", lib);
	GL_CHECK(gl.BufferDataARB);
	gl.BufferParameteriAPPLE = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glBufferParameteriAPPLE", lib);
	GL_CHECK(gl.BufferParameteriAPPLE);
	gl.BufferStorage = (void APIENTRY (*)(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags)) ldg_find("glBufferStorage", lib);
	GL_CHECK(gl.BufferStorage);
	gl.BufferSubData = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glBufferSubData", lib);
	GL_CHECK(gl.BufferSubData);
	gl.BufferSubDataARB = (void APIENTRY (*)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data)) ldg_find("glBufferSubDataARB", lib);
	GL_CHECK(gl.BufferSubDataARB);
	gl.CallList = (void APIENTRY (*)(GLuint list)) ldg_find("glCallList", lib);
	GL_CHECK(gl.CallList);
	gl.CallLists = (void APIENTRY (*)(GLsizei n, GLenum type, const GLvoid *lists)) ldg_find("glCallLists", lib);
	GL_CHECK(gl.CallLists);
	gl.CheckFramebufferStatus = (GLenum APIENTRY (*)(GLenum target)) ldg_find("glCheckFramebufferStatus", lib);
	GL_CHECK(gl.CheckFramebufferStatus);
	gl.CheckFramebufferStatusEXT = (GLenum APIENTRY (*)(GLenum target)) ldg_find("glCheckFramebufferStatusEXT", lib);
	GL_CHECK(gl.CheckFramebufferStatusEXT);
	gl.CheckNamedFramebufferStatusEXT = (GLenum APIENTRY (*)(GLuint framebuffer, GLenum target)) ldg_find("glCheckNamedFramebufferStatusEXT", lib);
	GL_CHECK(gl.CheckNamedFramebufferStatusEXT);
	gl.ClampColor = (void APIENTRY (*)(GLenum target, GLenum clamp)) ldg_find("glClampColor", lib);
	GL_CHECK(gl.ClampColor);
	gl.ClampColorARB = (void APIENTRY (*)(GLenum target, GLenum clamp)) ldg_find("glClampColorARB", lib);
	GL_CHECK(gl.ClampColorARB);
	gl.Clear = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glClear", lib);
	GL_CHECK(gl.Clear);
	gl.ClearAccum = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glClearAccum", lib);
	GL_CHECK(gl.ClearAccum);
	gl.ClearAccumxOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glClearAccumxOES", lib);
	GL_CHECK(gl.ClearAccumxOES);
	gl.ClearBufferData = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data)) ldg_find("glClearBufferData", lib);
	GL_CHECK(gl.ClearBufferData);
	gl.ClearBufferSubData = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)) ldg_find("glClearBufferSubData", lib);
	GL_CHECK(gl.ClearBufferSubData);
	gl.ClearBufferfi = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)) ldg_find("glClearBufferfi", lib);
	GL_CHECK(gl.ClearBufferfi);
	gl.ClearBufferfv = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, const GLfloat *value)) ldg_find("glClearBufferfv", lib);
	GL_CHECK(gl.ClearBufferfv);
	gl.ClearBufferiv = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, const GLint *value)) ldg_find("glClearBufferiv", lib);
	GL_CHECK(gl.ClearBufferiv);
	gl.ClearBufferuiv = (void APIENTRY (*)(GLenum buffer, GLint drawbuffer, const GLuint *value)) ldg_find("glClearBufferuiv", lib);
	GL_CHECK(gl.ClearBufferuiv);
	gl.ClearColor = (void APIENTRY (*)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)) ldg_find("glClearColor", lib);
	GL_CHECK(gl.ClearColor);
	gl.ClearColorIiEXT = (void APIENTRY (*)(GLint red, GLint green, GLint blue, GLint alpha)) ldg_find("glClearColorIiEXT", lib);
	GL_CHECK(gl.ClearColorIiEXT);
	gl.ClearColorIuiEXT = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue, GLuint alpha)) ldg_find("glClearColorIuiEXT", lib);
	GL_CHECK(gl.ClearColorIuiEXT);
	gl.ClearColorxOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glClearColorxOES", lib);
	GL_CHECK(gl.ClearColorxOES);
	gl.ClearDebugLogMESA = (void APIENTRY (*)(GLhandleARB obj, GLenum logType, GLenum shaderType)) ldg_find("glClearDebugLogMESA", lib);
	GL_CHECK(gl.ClearDebugLogMESA);
	gl.ClearDepth = (void APIENTRY (*)(GLclampd depth)) ldg_find("glClearDepthd", lib);
	GL_CHECK(gl.ClearDepth);
	gl.ClearDepthdNV = (void APIENTRY (*)(GLdouble depth)) ldg_find("glClearDepthdNV", lib);
	GL_CHECK(gl.ClearDepthdNV);
	gl.ClearDepthf = (void APIENTRY (*)(GLfloat d)) ldg_find("glClearDepth", lib);
	GL_CHECK(gl.ClearDepthf);
	gl.ClearDepthfOES = (void APIENTRY (*)(GLclampf depth)) ldg_find("glClearDepthfOES", lib);
	GL_CHECK(gl.ClearDepthfOES);
	gl.ClearDepthxOES = (void APIENTRY (*)(GLfixed depth)) ldg_find("glClearDepthxOES", lib);
	GL_CHECK(gl.ClearDepthxOES);
	gl.ClearIndex = (void APIENTRY (*)(GLfloat c)) ldg_find("glClearIndex", lib);
	GL_CHECK(gl.ClearIndex);
	gl.ClearNamedBufferDataEXT = (void APIENTRY (*)(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data)) ldg_find("glClearNamedBufferDataEXT", lib);
	GL_CHECK(gl.ClearNamedBufferDataEXT);
	gl.ClearNamedBufferSubDataEXT = (void APIENTRY (*)(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data)) ldg_find("glClearNamedBufferSubDataEXT", lib);
	GL_CHECK(gl.ClearNamedBufferSubDataEXT);
	gl.ClearStencil = (void APIENTRY (*)(GLint s)) ldg_find("glClearStencil", lib);
	GL_CHECK(gl.ClearStencil);
	gl.ClearTexImage = (void APIENTRY (*)(GLuint texture, GLint level, GLenum format, GLenum type, const void *data)) ldg_find("glClearTexImage", lib);
	GL_CHECK(gl.ClearTexImage);
	gl.ClearTexSubImage = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data)) ldg_find("glClearTexSubImage", lib);
	GL_CHECK(gl.ClearTexSubImage);
	gl.ClientActiveTexture = (void APIENTRY (*)(GLenum texture)) ldg_find("glClientActiveTexture", lib);
	GL_CHECK(gl.ClientActiveTexture);
	gl.ClientActiveTextureARB = (void APIENTRY (*)(GLenum texture)) ldg_find("glClientActiveTextureARB", lib);
	GL_CHECK(gl.ClientActiveTextureARB);
	gl.ClientActiveVertexStreamATI = (void APIENTRY (*)(GLenum stream)) ldg_find("glClientActiveVertexStreamATI", lib);
	GL_CHECK(gl.ClientActiveVertexStreamATI);
	gl.ClientAttribDefaultEXT = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glClientAttribDefaultEXT", lib);
	GL_CHECK(gl.ClientAttribDefaultEXT);
	gl.ClientWaitSync = (GLenum APIENTRY (*)(GLsync sync, GLbitfield flags, GLuint64 timeout)) ldg_find("glClientWaitSync", lib);
	GL_CHECK(gl.ClientWaitSync);
	gl.ClipPlane = (void APIENTRY (*)(GLenum plane, const GLdouble *equation)) ldg_find("glClipPlane", lib);
	GL_CHECK(gl.ClipPlane);
	gl.ClipPlanefOES = (void APIENTRY (*)(GLenum plane, const GLfloat *equation)) ldg_find("glClipPlanefOES", lib);
	GL_CHECK(gl.ClipPlanefOES);
	gl.ClipPlanexOES = (void APIENTRY (*)(GLenum plane, const GLfixed *equation)) ldg_find("glClipPlanexOES", lib);
	GL_CHECK(gl.ClipPlanexOES);
	gl.Color3b = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue)) ldg_find("glColor3b", lib);
	GL_CHECK(gl.Color3b);
	gl.Color3bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glColor3bv", lib);
	GL_CHECK(gl.Color3bv);
	gl.Color3d = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue)) ldg_find("glColor3d", lib);
	GL_CHECK(gl.Color3d);
	gl.Color3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glColor3dv", lib);
	GL_CHECK(gl.Color3dv);
	gl.Color3f = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue)) ldg_find("glColor3f", lib);
	GL_CHECK(gl.Color3f);
	gl.Color3fVertex3fSUN = (void APIENTRY (*)(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glColor3fVertex3fSUN", lib);
	GL_CHECK(gl.Color3fVertex3fSUN);
	gl.Color3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *c, const GLfloat *v)) ldg_find("glColor3fVertex3fvSUN", lib);
	GL_CHECK(gl.Color3fVertex3fvSUN);
	gl.Color3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glColor3fv", lib);
	GL_CHECK(gl.Color3fv);
	gl.Color3hNV = (void APIENTRY (*)(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue)) ldg_find("glColor3hNV", lib);
	GL_CHECK(gl.Color3hNV);
	gl.Color3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glColor3hvNV", lib);
	GL_CHECK(gl.Color3hvNV);
	gl.Color3i = (void APIENTRY (*)(GLint red, GLint green, GLint blue)) ldg_find("glColor3i", lib);
	GL_CHECK(gl.Color3i);
	gl.Color3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glColor3iv", lib);
	GL_CHECK(gl.Color3iv);
	gl.Color3s = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue)) ldg_find("glColor3s", lib);
	GL_CHECK(gl.Color3s);
	gl.Color3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glColor3sv", lib);
	GL_CHECK(gl.Color3sv);
	gl.Color3ub = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue)) ldg_find("glColor3ub", lib);
	GL_CHECK(gl.Color3ub);
	gl.Color3ubv = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glColor3ubv", lib);
	GL_CHECK(gl.Color3ubv);
	gl.Color3ui = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue)) ldg_find("glColor3ui", lib);
	GL_CHECK(gl.Color3ui);
	gl.Color3uiv = (void APIENTRY (*)(const GLuint *v)) ldg_find("glColor3uiv", lib);
	GL_CHECK(gl.Color3uiv);
	gl.Color3us = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue)) ldg_find("glColor3us", lib);
	GL_CHECK(gl.Color3us);
	gl.Color3usv = (void APIENTRY (*)(const GLushort *v)) ldg_find("glColor3usv", lib);
	GL_CHECK(gl.Color3usv);
	gl.Color3xOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue)) ldg_find("glColor3xOES", lib);
	GL_CHECK(gl.Color3xOES);
	gl.Color3xvOES = (void APIENTRY (*)(const GLfixed *components)) ldg_find("glColor3xvOES", lib);
	GL_CHECK(gl.Color3xvOES);
	gl.Color4b = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue, GLbyte32 alpha)) ldg_find("glColor4b", lib);
	GL_CHECK(gl.Color4b);
	gl.Color4bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glColor4bv", lib);
	GL_CHECK(gl.Color4bv);
	gl.Color4d = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)) ldg_find("glColor4d", lib);
	GL_CHECK(gl.Color4d);
	gl.Color4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glColor4dv", lib);
	GL_CHECK(gl.Color4dv);
	gl.Color4f = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)) ldg_find("glColor4f", lib);
	GL_CHECK(gl.Color4f);
	gl.Color4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.Color4fNormal3fVertex3fSUN);
	gl.Color4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.Color4fNormal3fVertex3fvSUN);
	gl.Color4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glColor4fv", lib);
	GL_CHECK(gl.Color4fv);
	gl.Color4hNV = (void APIENTRY (*)(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue, GLhalfNV32 alpha)) ldg_find("glColor4hNV", lib);
	GL_CHECK(gl.Color4hNV);
	gl.Color4hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glColor4hvNV", lib);
	GL_CHECK(gl.Color4hvNV);
	gl.Color4i = (void APIENTRY (*)(GLint red, GLint green, GLint blue, GLint alpha)) ldg_find("glColor4i", lib);
	GL_CHECK(gl.Color4i);
	gl.Color4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glColor4iv", lib);
	GL_CHECK(gl.Color4iv);
	gl.Color4s = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue, GLshort32 alpha)) ldg_find("glColor4s", lib);
	GL_CHECK(gl.Color4s);
	gl.Color4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glColor4sv", lib);
	GL_CHECK(gl.Color4sv);
	gl.Color4ub = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue, GLubyte32 alpha)) ldg_find("glColor4ub", lib);
	GL_CHECK(gl.Color4ub);
	gl.Color4ubVertex2fSUN = (void APIENTRY (*)(GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y)) ldg_find("glColor4ubVertex2fSUN", lib);
	GL_CHECK(gl.Color4ubVertex2fSUN);
	gl.Color4ubVertex2fvSUN = (void APIENTRY (*)(const GLubyte *c, const GLfloat *v)) ldg_find("glColor4ubVertex2fvSUN", lib);
	GL_CHECK(gl.Color4ubVertex2fvSUN);
	gl.Color4ubVertex3fSUN = (void APIENTRY (*)(GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glColor4ubVertex3fSUN", lib);
	GL_CHECK(gl.Color4ubVertex3fSUN);
	gl.Color4ubVertex3fvSUN = (void APIENTRY (*)(const GLubyte *c, const GLfloat *v)) ldg_find("glColor4ubVertex3fvSUN", lib);
	GL_CHECK(gl.Color4ubVertex3fvSUN);
	gl.Color4ubv = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glColor4ubv", lib);
	GL_CHECK(gl.Color4ubv);
	gl.Color4ui = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue, GLuint alpha)) ldg_find("glColor4ui", lib);
	GL_CHECK(gl.Color4ui);
	gl.Color4uiv = (void APIENTRY (*)(const GLuint *v)) ldg_find("glColor4uiv", lib);
	GL_CHECK(gl.Color4uiv);
	gl.Color4us = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue, GLushort32 alpha)) ldg_find("glColor4us", lib);
	GL_CHECK(gl.Color4us);
	gl.Color4usv = (void APIENTRY (*)(const GLushort *v)) ldg_find("glColor4usv", lib);
	GL_CHECK(gl.Color4usv);
	gl.Color4xOES = (void APIENTRY (*)(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)) ldg_find("glColor4xOES", lib);
	GL_CHECK(gl.Color4xOES);
	gl.Color4xvOES = (void APIENTRY (*)(const GLfixed *components)) ldg_find("glColor4xvOES", lib);
	GL_CHECK(gl.Color4xvOES);
	gl.ColorFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glColorFormatNV", lib);
	GL_CHECK(gl.ColorFormatNV);
	gl.ColorFragmentOp1ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)) ldg_find("glColorFragmentOp1ATI", lib);
	GL_CHECK(gl.ColorFragmentOp1ATI);
	gl.ColorFragmentOp2ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)) ldg_find("glColorFragmentOp2ATI", lib);
	GL_CHECK(gl.ColorFragmentOp2ATI);
	gl.ColorFragmentOp3ATI = (void APIENTRY (*)(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)) ldg_find("glColorFragmentOp3ATI", lib);
	GL_CHECK(gl.ColorFragmentOp3ATI);
	gl.ColorMask = (void APIENTRY (*)(GLboolean32 red, GLboolean32 green, GLboolean32 blue, GLboolean32 alpha)) ldg_find("glColorMask", lib);
	GL_CHECK(gl.ColorMask);
	gl.ColorMaskIndexedEXT = (void APIENTRY (*)(GLuint index, GLboolean32 r, GLboolean32 g, GLboolean32 b, GLboolean32 a)) ldg_find("glColorMaskIndexedEXT", lib);
	GL_CHECK(gl.ColorMaskIndexedEXT);
	gl.ColorMaski = (void APIENTRY (*)(GLuint index, GLboolean32 r, GLboolean32 g, GLboolean32 b, GLboolean32 a)) ldg_find("glColorMaski", lib);
	GL_CHECK(gl.ColorMaski);
	gl.ColorMaterial = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glColorMaterial", lib);
	GL_CHECK(gl.ColorMaterial);
	gl.ColorP3ui = (void APIENTRY (*)(GLenum type, GLuint color)) ldg_find("glColorP3ui", lib);
	GL_CHECK(gl.ColorP3ui);
	gl.ColorP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *color)) ldg_find("glColorP3uiv", lib);
	GL_CHECK(gl.ColorP3uiv);
	gl.ColorP4ui = (void APIENTRY (*)(GLenum type, GLuint color)) ldg_find("glColorP4ui", lib);
	GL_CHECK(gl.ColorP4ui);
	gl.ColorP4uiv = (void APIENTRY (*)(GLenum type, const GLuint *color)) ldg_find("glColorP4uiv", lib);
	GL_CHECK(gl.ColorP4uiv);
	gl.ColorPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glColorPointer", lib);
	GL_CHECK(gl.ColorPointer);
	gl.ColorPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glColorPointerEXT", lib);
	GL_CHECK(gl.ColorPointerEXT);
	gl.ColorPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glColorPointerListIBM", lib);
	GL_CHECK(gl.ColorPointerListIBM);
	gl.ColorPointervINTEL = (void APIENTRY (*)(GLint size, GLenum type, const void * *pointer)) ldg_find("glColorPointervINTEL", lib);
	GL_CHECK(gl.ColorPointervINTEL);
	gl.ColorSubTable = (void APIENTRY (*)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data)) ldg_find("glColorSubTable", lib);
	GL_CHECK(gl.ColorSubTable);
	gl.ColorSubTableEXT = (void APIENTRY (*)(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data)) ldg_find("glColorSubTableEXT", lib);
	GL_CHECK(gl.ColorSubTableEXT);
	gl.ColorTable = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table)) ldg_find("glColorTable", lib);
	GL_CHECK(gl.ColorTable);
	gl.ColorTableEXT = (void APIENTRY (*)(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void *table)) ldg_find("glColorTableEXT", lib);
	GL_CHECK(gl.ColorTableEXT);
	gl.ColorTableParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glColorTableParameterfv", lib);
	GL_CHECK(gl.ColorTableParameterfv);
	gl.ColorTableParameterfvSGI = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glColorTableParameterfvSGI", lib);
	GL_CHECK(gl.ColorTableParameterfvSGI);
	gl.ColorTableParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glColorTableParameteriv", lib);
	GL_CHECK(gl.ColorTableParameteriv);
	gl.ColorTableParameterivSGI = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glColorTableParameterivSGI", lib);
	GL_CHECK(gl.ColorTableParameterivSGI);
	gl.ColorTableSGI = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table)) ldg_find("glColorTableSGI", lib);
	GL_CHECK(gl.ColorTableSGI);
	gl.CombinerInputNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)) ldg_find("glCombinerInputNV", lib);
	GL_CHECK(gl.CombinerInputNV);
	gl.CombinerOutputNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean32 abDotProduct, GLboolean32 cdDotProduct, GLboolean32 muxSum)) ldg_find("glCombinerOutputNV", lib);
	GL_CHECK(gl.CombinerOutputNV);
	gl.CombinerParameterfNV = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glCombinerParameterfNV", lib);
	GL_CHECK(gl.CombinerParameterfNV);
	gl.CombinerParameterfvNV = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glCombinerParameterfvNV", lib);
	GL_CHECK(gl.CombinerParameterfvNV);
	gl.CombinerParameteriNV = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glCombinerParameteriNV", lib);
	GL_CHECK(gl.CombinerParameteriNV);
	gl.CombinerParameterivNV = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glCombinerParameterivNV", lib);
	GL_CHECK(gl.CombinerParameterivNV);
	gl.CombinerStageParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum pname, const GLfloat *params)) ldg_find("glCombinerStageParameterfvNV", lib);
	GL_CHECK(gl.CombinerStageParameterfvNV);
	gl.CompileShader = (void APIENTRY (*)(GLuint shader)) ldg_find("glCompileShader", lib);
	GL_CHECK(gl.CompileShader);
	gl.CompileShaderARB = (void APIENTRY (*)(GLhandleARB shaderObj)) ldg_find("glCompileShaderARB", lib);
	GL_CHECK(gl.CompileShaderARB);
	gl.CompileShaderIncludeARB = (void APIENTRY (*)(GLuint shader, GLsizei count, const GLchar *const *path, const GLint *length)) ldg_find("glCompileShaderIncludeARB", lib);
	GL_CHECK(gl.CompileShaderIncludeARB);
	gl.CompressedMultiTexImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexImage1DEXT", lib);
	GL_CHECK(gl.CompressedMultiTexImage1DEXT);
	gl.CompressedMultiTexImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexImage2DEXT", lib);
	GL_CHECK(gl.CompressedMultiTexImage2DEXT);
	gl.CompressedMultiTexImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexImage3DEXT", lib);
	GL_CHECK(gl.CompressedMultiTexImage3DEXT);
	gl.CompressedMultiTexSubImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexSubImage1DEXT", lib);
	GL_CHECK(gl.CompressedMultiTexSubImage1DEXT);
	gl.CompressedMultiTexSubImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexSubImage2DEXT", lib);
	GL_CHECK(gl.CompressedMultiTexSubImage2DEXT);
	gl.CompressedMultiTexSubImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedMultiTexSubImage3DEXT", lib);
	GL_CHECK(gl.CompressedMultiTexSubImage3DEXT);
	gl.CompressedTexImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage1D", lib);
	GL_CHECK(gl.CompressedTexImage1D);
	gl.CompressedTexImage1DARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage1DARB", lib);
	GL_CHECK(gl.CompressedTexImage1DARB);
	gl.CompressedTexImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage2D", lib);
	GL_CHECK(gl.CompressedTexImage2D);
	gl.CompressedTexImage2DARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage2DARB", lib);
	GL_CHECK(gl.CompressedTexImage2DARB);
	gl.CompressedTexImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage3D", lib);
	GL_CHECK(gl.CompressedTexImage3D);
	gl.CompressedTexImage3DARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexImage3DARB", lib);
	GL_CHECK(gl.CompressedTexImage3DARB);
	gl.CompressedTexSubImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage1D", lib);
	GL_CHECK(gl.CompressedTexSubImage1D);
	gl.CompressedTexSubImage1DARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage1DARB", lib);
	GL_CHECK(gl.CompressedTexSubImage1DARB);
	gl.CompressedTexSubImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage2D", lib);
	GL_CHECK(gl.CompressedTexSubImage2D);
	gl.CompressedTexSubImage2DARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage2DARB", lib);
	GL_CHECK(gl.CompressedTexSubImage2DARB);
	gl.CompressedTexSubImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage3D", lib);
	GL_CHECK(gl.CompressedTexSubImage3D);
	gl.CompressedTexSubImage3DARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data)) ldg_find("glCompressedTexSubImage3DARB", lib);
	GL_CHECK(gl.CompressedTexSubImage3DARB);
	gl.CompressedTextureImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureImage1DEXT", lib);
	GL_CHECK(gl.CompressedTextureImage1DEXT);
	gl.CompressedTextureImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureImage2DEXT", lib);
	GL_CHECK(gl.CompressedTextureImage2DEXT);
	gl.CompressedTextureImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureImage3DEXT", lib);
	GL_CHECK(gl.CompressedTextureImage3DEXT);
	gl.CompressedTextureSubImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureSubImage1DEXT", lib);
	GL_CHECK(gl.CompressedTextureSubImage1DEXT);
	gl.CompressedTextureSubImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureSubImage2DEXT", lib);
	GL_CHECK(gl.CompressedTextureSubImage2DEXT);
	gl.CompressedTextureSubImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits)) ldg_find("glCompressedTextureSubImage3DEXT", lib);
	GL_CHECK(gl.CompressedTextureSubImage3DEXT);
	gl.ConvolutionFilter1D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter1D", lib);
	GL_CHECK(gl.ConvolutionFilter1D);
	gl.ConvolutionFilter1DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter1DEXT", lib);
	GL_CHECK(gl.ConvolutionFilter1DEXT);
	gl.ConvolutionFilter2D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter2D", lib);
	GL_CHECK(gl.ConvolutionFilter2D);
	gl.ConvolutionFilter2DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image)) ldg_find("glConvolutionFilter2DEXT", lib);
	GL_CHECK(gl.ConvolutionFilter2DEXT);
	gl.ConvolutionParameterf = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat params)) ldg_find("glConvolutionParameterf", lib);
	GL_CHECK(gl.ConvolutionParameterf);
	gl.ConvolutionParameterfEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat params)) ldg_find("glConvolutionParameterfEXT", lib);
	GL_CHECK(gl.ConvolutionParameterfEXT);
	gl.ConvolutionParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glConvolutionParameterfv", lib);
	GL_CHECK(gl.ConvolutionParameterfv);
	gl.ConvolutionParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glConvolutionParameterfvEXT", lib);
	GL_CHECK(gl.ConvolutionParameterfvEXT);
	gl.ConvolutionParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint params)) ldg_find("glConvolutionParameteri", lib);
	GL_CHECK(gl.ConvolutionParameteri);
	gl.ConvolutionParameteriEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint params)) ldg_find("glConvolutionParameteriEXT", lib);
	GL_CHECK(gl.ConvolutionParameteriEXT);
	gl.ConvolutionParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glConvolutionParameteriv", lib);
	GL_CHECK(gl.ConvolutionParameteriv);
	gl.ConvolutionParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glConvolutionParameterivEXT", lib);
	GL_CHECK(gl.ConvolutionParameterivEXT);
	gl.ConvolutionParameterxOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed param)) ldg_find("glConvolutionParameterxOES", lib);
	GL_CHECK(gl.ConvolutionParameterxOES);
	gl.ConvolutionParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfixed *params)) ldg_find("glConvolutionParameterxvOES", lib);
	GL_CHECK(gl.ConvolutionParameterxvOES);
	gl.CopyBufferSubData = (void APIENTRY (*)(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)) ldg_find("glCopyBufferSubData", lib);
	GL_CHECK(gl.CopyBufferSubData);
	gl.CopyColorSubTable = (void APIENTRY (*)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorSubTable", lib);
	GL_CHECK(gl.CopyColorSubTable);
	gl.CopyColorSubTableEXT = (void APIENTRY (*)(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorSubTableEXT", lib);
	GL_CHECK(gl.CopyColorSubTableEXT);
	gl.CopyColorTable = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorTable", lib);
	GL_CHECK(gl.CopyColorTable);
	gl.CopyColorTableSGI = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyColorTableSGI", lib);
	GL_CHECK(gl.CopyColorTableSGI);
	gl.CopyConvolutionFilter1D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyConvolutionFilter1D", lib);
	GL_CHECK(gl.CopyConvolutionFilter1D);
	gl.CopyConvolutionFilter1DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)) ldg_find("glCopyConvolutionFilter1DEXT", lib);
	GL_CHECK(gl.CopyConvolutionFilter1DEXT);
	gl.CopyConvolutionFilter2D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyConvolutionFilter2D", lib);
	GL_CHECK(gl.CopyConvolutionFilter2D);
	gl.CopyConvolutionFilter2DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyConvolutionFilter2DEXT", lib);
	GL_CHECK(gl.CopyConvolutionFilter2DEXT);
	gl.CopyImageSubData = (void APIENTRY (*)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)) ldg_find("glCopyImageSubData", lib);
	GL_CHECK(gl.CopyImageSubData);
	gl.CopyImageSubDataNV = (void APIENTRY (*)(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glCopyImageSubDataNV", lib);
	GL_CHECK(gl.CopyImageSubDataNV);
	gl.CopyMultiTexImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyMultiTexImage1DEXT", lib);
	GL_CHECK(gl.CopyMultiTexImage1DEXT);
	gl.CopyMultiTexImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyMultiTexImage2DEXT", lib);
	GL_CHECK(gl.CopyMultiTexImage2DEXT);
	gl.CopyMultiTexSubImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyMultiTexSubImage1DEXT", lib);
	GL_CHECK(gl.CopyMultiTexSubImage1DEXT);
	gl.CopyMultiTexSubImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyMultiTexSubImage2DEXT", lib);
	GL_CHECK(gl.CopyMultiTexSubImage2DEXT);
	gl.CopyMultiTexSubImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyMultiTexSubImage3DEXT", lib);
	GL_CHECK(gl.CopyMultiTexSubImage3DEXT);
	gl.CopyPathNV = (void APIENTRY (*)(GLuint resultPath, GLuint srcPath)) ldg_find("glCopyPathNV", lib);
	GL_CHECK(gl.CopyPathNV);
	gl.CopyPixels = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)) ldg_find("glCopyPixels", lib);
	GL_CHECK(gl.CopyPixels);
	gl.CopyTexImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyTexImage1D", lib);
	GL_CHECK(gl.CopyTexImage1D);
	gl.CopyTexImage1DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyTexImage1DEXT", lib);
	GL_CHECK(gl.CopyTexImage1DEXT);
	gl.CopyTexImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyTexImage2D", lib);
	GL_CHECK(gl.CopyTexImage2D);
	gl.CopyTexImage2DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyTexImage2DEXT", lib);
	GL_CHECK(gl.CopyTexImage2DEXT);
	gl.CopyTexSubImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTexSubImage1D", lib);
	GL_CHECK(gl.CopyTexSubImage1D);
	gl.CopyTexSubImage1DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTexSubImage1DEXT", lib);
	GL_CHECK(gl.CopyTexSubImage1DEXT);
	gl.CopyTexSubImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage2D", lib);
	GL_CHECK(gl.CopyTexSubImage2D);
	gl.CopyTexSubImage2DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage2DEXT", lib);
	GL_CHECK(gl.CopyTexSubImage2DEXT);
	gl.CopyTexSubImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage3D", lib);
	GL_CHECK(gl.CopyTexSubImage3D);
	gl.CopyTexSubImage3DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTexSubImage3DEXT", lib);
	GL_CHECK(gl.CopyTexSubImage3DEXT);
	gl.CopyTextureImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)) ldg_find("glCopyTextureImage1DEXT", lib);
	GL_CHECK(gl.CopyTextureImage1DEXT);
	gl.CopyTextureImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)) ldg_find("glCopyTextureImage2DEXT", lib);
	GL_CHECK(gl.CopyTextureImage2DEXT);
	gl.CopyTextureSubImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)) ldg_find("glCopyTextureSubImage1DEXT", lib);
	GL_CHECK(gl.CopyTextureSubImage1DEXT);
	gl.CopyTextureSubImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTextureSubImage2DEXT", lib);
	GL_CHECK(gl.CopyTextureSubImage2DEXT);
	gl.CopyTextureSubImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glCopyTextureSubImage3DEXT", lib);
	GL_CHECK(gl.CopyTextureSubImage3DEXT);
	gl.CoverFillPathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)) ldg_find("glCoverFillPathInstancedNV", lib);
	GL_CHECK(gl.CoverFillPathInstancedNV);
	gl.CoverFillPathNV = (void APIENTRY (*)(GLuint path, GLenum coverMode)) ldg_find("glCoverFillPathNV", lib);
	GL_CHECK(gl.CoverFillPathNV);
	gl.CoverStrokePathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)) ldg_find("glCoverStrokePathInstancedNV", lib);
	GL_CHECK(gl.CoverStrokePathInstancedNV);
	gl.CoverStrokePathNV = (void APIENTRY (*)(GLuint path, GLenum coverMode)) ldg_find("glCoverStrokePathNV", lib);
	GL_CHECK(gl.CoverStrokePathNV);
	gl.CreateDebugObjectMESA = (GLhandleARB APIENTRY (*)(void)) ldg_find("glCreateDebugObjectMESA", lib);
	GL_CHECK(gl.CreateDebugObjectMESA);
	gl.CreatePerfQueryINTEL = (void APIENTRY (*)(GLuint queryId, GLuint *queryHandle)) ldg_find("glCreatePerfQueryINTEL", lib);
	GL_CHECK(gl.CreatePerfQueryINTEL);
	gl.CreateProgram = (GLuint APIENTRY (*)(void)) ldg_find("glCreateProgram", lib);
	GL_CHECK(gl.CreateProgram);
	gl.CreateProgramObjectARB = (GLhandleARB APIENTRY (*)(void)) ldg_find("glCreateProgramObjectARB", lib);
	GL_CHECK(gl.CreateProgramObjectARB);
	gl.CreateShader = (GLuint APIENTRY (*)(GLenum type)) ldg_find("glCreateShader", lib);
	GL_CHECK(gl.CreateShader);
	gl.CreateShaderObjectARB = (GLhandleARB APIENTRY (*)(GLenum shaderType)) ldg_find("glCreateShaderObjectARB", lib);
	GL_CHECK(gl.CreateShaderObjectARB);
	gl.CreateShaderProgramEXT = (GLuint APIENTRY (*)(GLenum type, const GLchar *string)) ldg_find("glCreateShaderProgramEXT", lib);
	GL_CHECK(gl.CreateShaderProgramEXT);
	gl.CreateShaderProgramv = (GLuint APIENTRY (*)(GLenum type, GLsizei count, const GLchar *const *strings)) ldg_find("glCreateShaderProgramv", lib);
	GL_CHECK(gl.CreateShaderProgramv);
	gl.CreateSyncFromCLeventARB = (GLsync APIENTRY (*)(struct _cl_context *context, struct _cl_event *event, GLbitfield flags)) ldg_find("glCreateSyncFromCLeventARB", lib);
	GL_CHECK(gl.CreateSyncFromCLeventARB);
	gl.CullFace = (void APIENTRY (*)(GLenum mode)) ldg_find("glCullFace", lib);
	GL_CHECK(gl.CullFace);
	gl.CullParameterdvEXT = (void APIENTRY (*)(GLenum pname, GLdouble *params)) ldg_find("glCullParameterdvEXT", lib);
	GL_CHECK(gl.CullParameterdvEXT);
	gl.CullParameterfvEXT = (void APIENTRY (*)(GLenum pname, GLfloat *params)) ldg_find("glCullParameterfvEXT", lib);
	GL_CHECK(gl.CullParameterfvEXT);
	gl.CurrentPaletteMatrixARB = (void APIENTRY (*)(GLint index)) ldg_find("glCurrentPaletteMatrixARB", lib);
	GL_CHECK(gl.CurrentPaletteMatrixARB);
	gl.DebugMessageCallback = (void APIENTRY (*)(GLDEBUGPROC callback, const void *userParam)) ldg_find("glDebugMessageCallback", lib);
	GL_CHECK(gl.DebugMessageCallback);
	gl.DebugMessageCallbackAMD = (void APIENTRY (*)(GLDEBUGPROCAMD callback, void *userParam)) ldg_find("glDebugMessageCallbackAMD", lib);
	GL_CHECK(gl.DebugMessageCallbackAMD);
	gl.DebugMessageCallbackARB = (void APIENTRY (*)(GLDEBUGPROCARB callback, const void *userParam)) ldg_find("glDebugMessageCallbackARB", lib);
	GL_CHECK(gl.DebugMessageCallbackARB);
	gl.DebugMessageControl = (void APIENTRY (*)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)) ldg_find("glDebugMessageControl", lib);
	GL_CHECK(gl.DebugMessageControl);
	gl.DebugMessageControlARB = (void APIENTRY (*)(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)) ldg_find("glDebugMessageControlARB", lib);
	GL_CHECK(gl.DebugMessageControlARB);
	gl.DebugMessageEnableAMD = (void APIENTRY (*)(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean32 enabled)) ldg_find("glDebugMessageEnableAMD", lib);
	GL_CHECK(gl.DebugMessageEnableAMD);
	gl.DebugMessageInsert = (void APIENTRY (*)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)) ldg_find("glDebugMessageInsert", lib);
	GL_CHECK(gl.DebugMessageInsert);
	gl.DebugMessageInsertAMD = (void APIENTRY (*)(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf)) ldg_find("glDebugMessageInsertAMD", lib);
	GL_CHECK(gl.DebugMessageInsertAMD);
	gl.DebugMessageInsertARB = (void APIENTRY (*)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf)) ldg_find("glDebugMessageInsertARB", lib);
	GL_CHECK(gl.DebugMessageInsertARB);
	gl.DeformSGIX = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glDeformSGIX", lib);
	GL_CHECK(gl.DeformSGIX);
	gl.DeformationMap3dSGIX = (void APIENTRY (*)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points)) ldg_find("glDeformationMap3dSGIX", lib);
	GL_CHECK(gl.DeformationMap3dSGIX);
	gl.DeformationMap3fSGIX = (void APIENTRY (*)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points)) ldg_find("glDeformationMap3fSGIX", lib);
	GL_CHECK(gl.DeformationMap3fSGIX);
	gl.DeleteAsyncMarkersSGIX = (void APIENTRY (*)(GLuint marker, GLsizei range)) ldg_find("glDeleteAsyncMarkersSGIX", lib);
	GL_CHECK(gl.DeleteAsyncMarkersSGIX);
	gl.DeleteBuffers = (void APIENTRY (*)(GLsizei n, const GLuint *buffers)) ldg_find("glDeleteBuffers", lib);
	GL_CHECK(gl.DeleteBuffers);
	gl.DeleteBuffersARB = (void APIENTRY (*)(GLsizei n, const GLuint *buffers)) ldg_find("glDeleteBuffersARB", lib);
	GL_CHECK(gl.DeleteBuffersARB);
	gl.DeleteFencesAPPLE = (void APIENTRY (*)(GLsizei n, const GLuint *fences)) ldg_find("glDeleteFencesAPPLE", lib);
	GL_CHECK(gl.DeleteFencesAPPLE);
	gl.DeleteFencesNV = (void APIENTRY (*)(GLsizei n, const GLuint *fences)) ldg_find("glDeleteFencesNV", lib);
	GL_CHECK(gl.DeleteFencesNV);
	gl.DeleteFragmentShaderATI = (void APIENTRY (*)(GLuint id)) ldg_find("glDeleteFragmentShaderATI", lib);
	GL_CHECK(gl.DeleteFragmentShaderATI);
	gl.DeleteFramebuffers = (void APIENTRY (*)(GLsizei n, const GLuint *framebuffers)) ldg_find("glDeleteFramebuffers", lib);
	GL_CHECK(gl.DeleteFramebuffers);
	gl.DeleteFramebuffersEXT = (void APIENTRY (*)(GLsizei n, const GLuint *framebuffers)) ldg_find("glDeleteFramebuffersEXT", lib);
	GL_CHECK(gl.DeleteFramebuffersEXT);
	gl.DeleteLists = (void APIENTRY (*)(GLuint list, GLsizei range)) ldg_find("glDeleteLists", lib);
	GL_CHECK(gl.DeleteLists);
	gl.DeleteNamedStringARB = (void APIENTRY (*)(GLint namelen, const GLchar *name)) ldg_find("glDeleteNamedStringARB", lib);
	GL_CHECK(gl.DeleteNamedStringARB);
	gl.DeleteNamesAMD = (void APIENTRY (*)(GLenum identifier, GLuint num, const GLuint *names)) ldg_find("glDeleteNamesAMD", lib);
	GL_CHECK(gl.DeleteNamesAMD);
	gl.DeleteObjectARB = (void APIENTRY (*)(GLhandleARB obj)) ldg_find("glDeleteObjectARB", lib);
	GL_CHECK(gl.DeleteObjectARB);
	gl.DeleteObjectBufferATI = (void APIENTRY (*)(GLuint buffer)) ldg_find("glDeleteObjectBufferATI", lib);
	GL_CHECK(gl.DeleteObjectBufferATI);
	gl.DeleteOcclusionQueriesNV = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteOcclusionQueriesNV", lib);
	GL_CHECK(gl.DeleteOcclusionQueriesNV);
	gl.DeletePathsNV = (void APIENTRY (*)(GLuint path, GLsizei range)) ldg_find("glDeletePathsNV", lib);
	GL_CHECK(gl.DeletePathsNV);
	gl.DeletePerfMonitorsAMD = (void APIENTRY (*)(GLsizei n, GLuint *monitors)) ldg_find("glDeletePerfMonitorsAMD", lib);
	GL_CHECK(gl.DeletePerfMonitorsAMD);
	gl.DeletePerfQueryINTEL = (void APIENTRY (*)(GLuint queryHandle)) ldg_find("glDeletePerfQueryINTEL", lib);
	GL_CHECK(gl.DeletePerfQueryINTEL);
	gl.DeleteProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glDeleteProgram", lib);
	GL_CHECK(gl.DeleteProgram);
	gl.DeleteProgramPipelines = (void APIENTRY (*)(GLsizei n, const GLuint *pipelines)) ldg_find("glDeleteProgramPipelines", lib);
	GL_CHECK(gl.DeleteProgramPipelines);
	gl.DeleteProgramsARB = (void APIENTRY (*)(GLsizei n, const GLuint *programs)) ldg_find("glDeleteProgramsARB", lib);
	GL_CHECK(gl.DeleteProgramsARB);
	gl.DeleteProgramsNV = (void APIENTRY (*)(GLsizei n, const GLuint *programs)) ldg_find("glDeleteProgramsNV", lib);
	GL_CHECK(gl.DeleteProgramsNV);
	gl.DeleteQueries = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteQueries", lib);
	GL_CHECK(gl.DeleteQueries);
	gl.DeleteQueriesARB = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteQueriesARB", lib);
	GL_CHECK(gl.DeleteQueriesARB);
	gl.DeleteRenderbuffers = (void APIENTRY (*)(GLsizei n, const GLuint *renderbuffers)) ldg_find("glDeleteRenderbuffers", lib);
	GL_CHECK(gl.DeleteRenderbuffers);
	gl.DeleteRenderbuffersEXT = (void APIENTRY (*)(GLsizei n, const GLuint *renderbuffers)) ldg_find("glDeleteRenderbuffersEXT", lib);
	GL_CHECK(gl.DeleteRenderbuffersEXT);
	gl.DeleteSamplers = (void APIENTRY (*)(GLsizei count, const GLuint *samplers)) ldg_find("glDeleteSamplers", lib);
	GL_CHECK(gl.DeleteSamplers);
	gl.DeleteShader = (void APIENTRY (*)(GLuint shader)) ldg_find("glDeleteShader", lib);
	GL_CHECK(gl.DeleteShader);
	gl.DeleteSync = (void APIENTRY (*)(GLsync sync)) ldg_find("glDeleteSync", lib);
	GL_CHECK(gl.DeleteSync);
	gl.DeleteTextures = (void APIENTRY (*)(GLsizei n, const GLuint *textures)) ldg_find("glDeleteTextures", lib);
	GL_CHECK(gl.DeleteTextures);
	gl.DeleteTexturesEXT = (void APIENTRY (*)(GLsizei n, const GLuint *textures)) ldg_find("glDeleteTexturesEXT", lib);
	GL_CHECK(gl.DeleteTexturesEXT);
	gl.DeleteTransformFeedbacks = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteTransformFeedbacks", lib);
	GL_CHECK(gl.DeleteTransformFeedbacks);
	gl.DeleteTransformFeedbacksNV = (void APIENTRY (*)(GLsizei n, const GLuint *ids)) ldg_find("glDeleteTransformFeedbacksNV", lib);
	GL_CHECK(gl.DeleteTransformFeedbacksNV);
	gl.DeleteVertexArrays = (void APIENTRY (*)(GLsizei n, const GLuint *arrays)) ldg_find("glDeleteVertexArrays", lib);
	GL_CHECK(gl.DeleteVertexArrays);
	gl.DeleteVertexArraysAPPLE = (void APIENTRY (*)(GLsizei n, const GLuint *arrays)) ldg_find("glDeleteVertexArraysAPPLE", lib);
	GL_CHECK(gl.DeleteVertexArraysAPPLE);
	gl.DeleteVertexShaderEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glDeleteVertexShaderEXT", lib);
	GL_CHECK(gl.DeleteVertexShaderEXT);
	gl.DepthBoundsEXT = (void APIENTRY (*)(GLclampd zmin, GLclampd zmax)) ldg_find("glDepthBoundsEXT", lib);
	GL_CHECK(gl.DepthBoundsEXT);
	gl.DepthBoundsdNV = (void APIENTRY (*)(GLdouble zmin, GLdouble zmax)) ldg_find("glDepthBoundsdNV", lib);
	GL_CHECK(gl.DepthBoundsdNV);
	gl.DepthFunc = (void APIENTRY (*)(GLenum func)) ldg_find("glDepthFunc", lib);
	GL_CHECK(gl.DepthFunc);
	gl.DepthMask = (void APIENTRY (*)(GLboolean32 flag)) ldg_find("glDepthMask", lib);
	GL_CHECK(gl.DepthMask);
	gl.DepthRange = (void APIENTRY (*)(GLclampd zNear, GLclampd zFar)) ldg_find("glDepthRange", lib);
	GL_CHECK(gl.DepthRange);
	gl.DepthRangeArrayv = (void APIENTRY (*)(GLuint first, GLsizei count, const GLdouble *v)) ldg_find("glDepthRangeArrayv", lib);
	GL_CHECK(gl.DepthRangeArrayv);
	gl.DepthRangeIndexed = (void APIENTRY (*)(GLuint index, GLdouble n, GLdouble f)) ldg_find("glDepthRangeIndexed", lib);
	GL_CHECK(gl.DepthRangeIndexed);
	gl.DepthRangedNV = (void APIENTRY (*)(GLdouble zNear, GLdouble zFar)) ldg_find("glDepthRangedNV", lib);
	GL_CHECK(gl.DepthRangedNV);
	gl.DepthRangef = (void APIENTRY (*)(GLfloat n, GLfloat f)) ldg_find("glDepthRangef", lib);
	GL_CHECK(gl.DepthRangef);
	gl.DepthRangefOES = (void APIENTRY (*)(GLclampf n, GLclampf f)) ldg_find("glDepthRangefOES", lib);
	GL_CHECK(gl.DepthRangefOES);
	gl.DepthRangexOES = (void APIENTRY (*)(GLfixed n, GLfixed f)) ldg_find("glDepthRangexOES", lib);
	GL_CHECK(gl.DepthRangexOES);
	gl.DetachObjectARB = (void APIENTRY (*)(GLhandleARB containerObj, GLhandleARB attachedObj)) ldg_find("glDetachObjectARB", lib);
	GL_CHECK(gl.DetachObjectARB);
	gl.DetachShader = (void APIENTRY (*)(GLuint program, GLuint shader)) ldg_find("glDetachShader", lib);
	GL_CHECK(gl.DetachShader);
	gl.DetailTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLsizei n, const GLfloat *points)) ldg_find("glDetailTexFuncSGIS", lib);
	GL_CHECK(gl.DetailTexFuncSGIS);
	gl.Disable = (void APIENTRY (*)(GLenum cap)) ldg_find("glDisable", lib);
	GL_CHECK(gl.Disable);
	gl.DisableClientState = (void APIENTRY (*)(GLenum array)) ldg_find("glDisableClientState", lib);
	GL_CHECK(gl.DisableClientState);
	gl.DisableClientStateIndexedEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glDisableClientStateIndexedEXT", lib);
	GL_CHECK(gl.DisableClientStateIndexedEXT);
	gl.DisableClientStateiEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glDisableClientStateiEXT", lib);
	GL_CHECK(gl.DisableClientStateiEXT);
	gl.DisableIndexedEXT = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glDisableIndexedEXT", lib);
	GL_CHECK(gl.DisableIndexedEXT);
	gl.DisableTraceMESA = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glDisableTraceMESA", lib);
	GL_CHECK(gl.DisableTraceMESA);
	gl.DisableVariantClientStateEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glDisableVariantClientStateEXT", lib);
	GL_CHECK(gl.DisableVariantClientStateEXT);
	gl.DisableVertexArrayAttribEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index)) ldg_find("glDisableVertexArrayAttribEXT", lib);
	GL_CHECK(gl.DisableVertexArrayAttribEXT);
	gl.DisableVertexArrayEXT = (void APIENTRY (*)(GLuint vaobj, GLenum array)) ldg_find("glDisableVertexArrayEXT", lib);
	GL_CHECK(gl.DisableVertexArrayEXT);
	gl.DisableVertexAttribAPPLE = (void APIENTRY (*)(GLuint index, GLenum pname)) ldg_find("glDisableVertexAttribAPPLE", lib);
	GL_CHECK(gl.DisableVertexAttribAPPLE);
	gl.DisableVertexAttribArray = (void APIENTRY (*)(GLuint index)) ldg_find("glDisableVertexAttribArray", lib);
	GL_CHECK(gl.DisableVertexAttribArray);
	gl.DisableVertexAttribArrayARB = (void APIENTRY (*)(GLuint index)) ldg_find("glDisableVertexAttribArrayARB", lib);
	GL_CHECK(gl.DisableVertexAttribArrayARB);
	gl.Disablei = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glDisablei", lib);
	GL_CHECK(gl.Disablei);
	gl.DispatchCompute = (void APIENTRY (*)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)) ldg_find("glDispatchCompute", lib);
	GL_CHECK(gl.DispatchCompute);
	gl.DispatchComputeGroupSizeARB = (void APIENTRY (*)(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z)) ldg_find("glDispatchComputeGroupSizeARB", lib);
	GL_CHECK(gl.DispatchComputeGroupSizeARB);
	gl.DispatchComputeIndirect = (void APIENTRY (*)(GLintptr indirect)) ldg_find("glDispatchComputeIndirect", lib);
	GL_CHECK(gl.DispatchComputeIndirect);
	gl.DrawArrays = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count)) ldg_find("glDrawArrays", lib);
	GL_CHECK(gl.DrawArrays);
	gl.DrawArraysEXT = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count)) ldg_find("glDrawArraysEXT", lib);
	GL_CHECK(gl.DrawArraysEXT);
	gl.DrawArraysIndirect = (void APIENTRY (*)(GLenum mode, const void *indirect)) ldg_find("glDrawArraysIndirect", lib);
	GL_CHECK(gl.DrawArraysIndirect);
	gl.DrawArraysInstanced = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount)) ldg_find("glDrawArraysInstanced", lib);
	GL_CHECK(gl.DrawArraysInstanced);
	gl.DrawArraysInstancedARB = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei primcount)) ldg_find("glDrawArraysInstancedARB", lib);
	GL_CHECK(gl.DrawArraysInstancedARB);
	gl.DrawArraysInstancedBaseInstance = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance)) ldg_find("glDrawArraysInstancedBaseInstance", lib);
	GL_CHECK(gl.DrawArraysInstancedBaseInstance);
	gl.DrawArraysInstancedEXT = (void APIENTRY (*)(GLenum mode, GLint start, GLsizei count, GLsizei primcount)) ldg_find("glDrawArraysInstancedEXT", lib);
	GL_CHECK(gl.DrawArraysInstancedEXT);
	gl.DrawBuffer = (void APIENTRY (*)(GLenum mode)) ldg_find("glDrawBuffer", lib);
	GL_CHECK(gl.DrawBuffer);
	gl.DrawBuffers = (void APIENTRY (*)(GLsizei n, const GLenum *bufs)) ldg_find("glDrawBuffers", lib);
	GL_CHECK(gl.DrawBuffers);
	gl.DrawBuffersARB = (void APIENTRY (*)(GLsizei n, const GLenum *bufs)) ldg_find("glDrawBuffersARB", lib);
	GL_CHECK(gl.DrawBuffersARB);
	gl.DrawBuffersATI = (void APIENTRY (*)(GLsizei n, const GLenum *bufs)) ldg_find("glDrawBuffersATI", lib);
	GL_CHECK(gl.DrawBuffersATI);
	gl.DrawElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count)) ldg_find("glDrawElementArrayAPPLE", lib);
	GL_CHECK(gl.DrawElementArrayAPPLE);
	gl.DrawElementArrayATI = (void APIENTRY (*)(GLenum mode, GLsizei count)) ldg_find("glDrawElementArrayATI", lib);
	GL_CHECK(gl.DrawElementArrayATI);
	gl.DrawElements = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)) ldg_find("glDrawElements", lib);
	GL_CHECK(gl.DrawElements);
	gl.DrawElementsBaseVertex = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex)) ldg_find("glDrawElementsBaseVertex", lib);
	GL_CHECK(gl.DrawElementsBaseVertex);
	gl.DrawElementsIndirect = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect)) ldg_find("glDrawElementsIndirect", lib);
	GL_CHECK(gl.DrawElementsIndirect);
	gl.DrawElementsInstanced = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount)) ldg_find("glDrawElementsInstanced", lib);
	GL_CHECK(gl.DrawElementsInstanced);
	gl.DrawElementsInstancedARB = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)) ldg_find("glDrawElementsInstancedARB", lib);
	GL_CHECK(gl.DrawElementsInstancedARB);
	gl.DrawElementsInstancedBaseInstance = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance)) ldg_find("glDrawElementsInstancedBaseInstance", lib);
	GL_CHECK(gl.DrawElementsInstancedBaseInstance);
	gl.DrawElementsInstancedBaseVertex = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex)) ldg_find("glDrawElementsInstancedBaseVertex", lib);
	GL_CHECK(gl.DrawElementsInstancedBaseVertex);
	gl.DrawElementsInstancedBaseVertexBaseInstance = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance)) ldg_find("glDrawElementsInstancedBaseVertexBaseInstance", lib);
	GL_CHECK(gl.DrawElementsInstancedBaseVertexBaseInstance);
	gl.DrawElementsInstancedEXT = (void APIENTRY (*)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount)) ldg_find("glDrawElementsInstancedEXT", lib);
	GL_CHECK(gl.DrawElementsInstancedEXT);
	gl.DrawMeshArraysSUN = (void APIENTRY (*)(GLenum mode, GLint first, GLsizei count, GLsizei width)) ldg_find("glDrawMeshArraysSUN", lib);
	GL_CHECK(gl.DrawMeshArraysSUN);
	gl.DrawPixels = (void APIENTRY (*)(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glDrawPixels", lib);
	GL_CHECK(gl.DrawPixels);
	gl.DrawRangeElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count)) ldg_find("glDrawRangeElementArrayAPPLE", lib);
	GL_CHECK(gl.DrawRangeElementArrayAPPLE);
	gl.DrawRangeElementArrayATI = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count)) ldg_find("glDrawRangeElementArrayATI", lib);
	GL_CHECK(gl.DrawRangeElementArrayATI);
	gl.DrawRangeElements = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices)) ldg_find("glDrawRangeElements", lib);
	GL_CHECK(gl.DrawRangeElements);
	gl.DrawRangeElementsBaseVertex = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex)) ldg_find("glDrawRangeElementsBaseVertex", lib);
	GL_CHECK(gl.DrawRangeElementsBaseVertex);
	gl.DrawRangeElementsEXT = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices)) ldg_find("glDrawRangeElementsEXT", lib);
	GL_CHECK(gl.DrawRangeElementsEXT);
	gl.DrawTextureNV = (void APIENTRY (*)(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1)) ldg_find("glDrawTextureNV", lib);
	GL_CHECK(gl.DrawTextureNV);
	gl.DrawTransformFeedback = (void APIENTRY (*)(GLenum mode, GLuint id)) ldg_find("glDrawTransformFeedback", lib);
	GL_CHECK(gl.DrawTransformFeedback);
	gl.DrawTransformFeedbackInstanced = (void APIENTRY (*)(GLenum mode, GLuint id, GLsizei instancecount)) ldg_find("glDrawTransformFeedbackInstanced", lib);
	GL_CHECK(gl.DrawTransformFeedbackInstanced);
	gl.DrawTransformFeedbackNV = (void APIENTRY (*)(GLenum mode, GLuint id)) ldg_find("glDrawTransformFeedbackNV", lib);
	GL_CHECK(gl.DrawTransformFeedbackNV);
	gl.DrawTransformFeedbackStream = (void APIENTRY (*)(GLenum mode, GLuint id, GLuint stream)) ldg_find("glDrawTransformFeedbackStream", lib);
	GL_CHECK(gl.DrawTransformFeedbackStream);
	gl.DrawTransformFeedbackStreamInstanced = (void APIENTRY (*)(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount)) ldg_find("glDrawTransformFeedbackStreamInstanced", lib);
	GL_CHECK(gl.DrawTransformFeedbackStreamInstanced);
	gl.EdgeFlag = (void APIENTRY (*)(GLboolean32 flag)) ldg_find("glEdgeFlag", lib);
	GL_CHECK(gl.EdgeFlag);
	gl.EdgeFlagFormatNV = (void APIENTRY (*)(GLsizei stride)) ldg_find("glEdgeFlagFormatNV", lib);
	GL_CHECK(gl.EdgeFlagFormatNV);
	gl.EdgeFlagPointer = (void APIENTRY (*)(GLsizei stride, const GLvoid *pointer)) ldg_find("glEdgeFlagPointer", lib);
	GL_CHECK(gl.EdgeFlagPointer);
	gl.EdgeFlagPointerEXT = (void APIENTRY (*)(GLsizei stride, GLsizei count, const GLboolean *pointer)) ldg_find("glEdgeFlagPointerEXT", lib);
	GL_CHECK(gl.EdgeFlagPointerEXT);
	gl.EdgeFlagPointerListIBM = (void APIENTRY (*)(GLint stride, const GLboolean * *pointer, GLint ptrstride)) ldg_find("glEdgeFlagPointerListIBM", lib);
	GL_CHECK(gl.EdgeFlagPointerListIBM);
	gl.EdgeFlagv = (void APIENTRY (*)(const GLboolean *flag)) ldg_find("glEdgeFlagv", lib);
	GL_CHECK(gl.EdgeFlagv);
	gl.ElementPointerAPPLE = (void APIENTRY (*)(GLenum type, const void *pointer)) ldg_find("glElementPointerAPPLE", lib);
	GL_CHECK(gl.ElementPointerAPPLE);
	gl.ElementPointerATI = (void APIENTRY (*)(GLenum type, const void *pointer)) ldg_find("glElementPointerATI", lib);
	GL_CHECK(gl.ElementPointerATI);
	gl.Enable = (void APIENTRY (*)(GLenum cap)) ldg_find("glEnable", lib);
	GL_CHECK(gl.Enable);
	gl.EnableClientState = (void APIENTRY (*)(GLenum array)) ldg_find("glEnableClientState", lib);
	GL_CHECK(gl.EnableClientState);
	gl.EnableClientStateIndexedEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glEnableClientStateIndexedEXT", lib);
	GL_CHECK(gl.EnableClientStateIndexedEXT);
	gl.EnableClientStateiEXT = (void APIENTRY (*)(GLenum array, GLuint index)) ldg_find("glEnableClientStateiEXT", lib);
	GL_CHECK(gl.EnableClientStateiEXT);
	gl.EnableIndexedEXT = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glEnableIndexedEXT", lib);
	GL_CHECK(gl.EnableIndexedEXT);
	gl.EnableTraceMESA = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glEnableTraceMESA", lib);
	GL_CHECK(gl.EnableTraceMESA);
	gl.EnableVariantClientStateEXT = (void APIENTRY (*)(GLuint id)) ldg_find("glEnableVariantClientStateEXT", lib);
	GL_CHECK(gl.EnableVariantClientStateEXT);
	gl.EnableVertexArrayAttribEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index)) ldg_find("glEnableVertexArrayAttribEXT", lib);
	GL_CHECK(gl.EnableVertexArrayAttribEXT);
	gl.EnableVertexArrayEXT = (void APIENTRY (*)(GLuint vaobj, GLenum array)) ldg_find("glEnableVertexArrayEXT", lib);
	GL_CHECK(gl.EnableVertexArrayEXT);
	gl.EnableVertexAttribAPPLE = (void APIENTRY (*)(GLuint index, GLenum pname)) ldg_find("glEnableVertexAttribAPPLE", lib);
	GL_CHECK(gl.EnableVertexAttribAPPLE);
	gl.EnableVertexAttribArray = (void APIENTRY (*)(GLuint index)) ldg_find("glEnableVertexAttribArray", lib);
	GL_CHECK(gl.EnableVertexAttribArray);
	gl.EnableVertexAttribArrayARB = (void APIENTRY (*)(GLuint index)) ldg_find("glEnableVertexAttribArrayARB", lib);
	GL_CHECK(gl.EnableVertexAttribArrayARB);
	gl.Enablei = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glEnablei", lib);
	GL_CHECK(gl.Enablei);
	gl.End = (void APIENTRY (*)(void)) ldg_find("glEnd", lib);
	GL_CHECK(gl.End);
	gl.EndConditionalRender = (void APIENTRY (*)(void)) ldg_find("glEndConditionalRender", lib);
	GL_CHECK(gl.EndConditionalRender);
	gl.EndConditionalRenderNV = (void APIENTRY (*)(void)) ldg_find("glEndConditionalRenderNV", lib);
	GL_CHECK(gl.EndConditionalRenderNV);
	gl.EndConditionalRenderNVX = (void APIENTRY (*)(void)) ldg_find("glEndConditionalRenderNVX", lib);
	GL_CHECK(gl.EndConditionalRenderNVX);
	gl.EndFragmentShaderATI = (void APIENTRY (*)(void)) ldg_find("glEndFragmentShaderATI", lib);
	GL_CHECK(gl.EndFragmentShaderATI);
	gl.EndList = (void APIENTRY (*)(void)) ldg_find("glEndList", lib);
	GL_CHECK(gl.EndList);
	gl.EndOcclusionQueryNV = (void APIENTRY (*)(void)) ldg_find("glEndOcclusionQueryNV", lib);
	GL_CHECK(gl.EndOcclusionQueryNV);
	gl.EndPerfMonitorAMD = (void APIENTRY (*)(GLuint monitor)) ldg_find("glEndPerfMonitorAMD", lib);
	GL_CHECK(gl.EndPerfMonitorAMD);
	gl.EndPerfQueryINTEL = (void APIENTRY (*)(GLuint queryHandle)) ldg_find("glEndPerfQueryINTEL", lib);
	GL_CHECK(gl.EndPerfQueryINTEL);
	gl.EndQuery = (void APIENTRY (*)(GLenum target)) ldg_find("glEndQuery", lib);
	GL_CHECK(gl.EndQuery);
	gl.EndQueryARB = (void APIENTRY (*)(GLenum target)) ldg_find("glEndQueryARB", lib);
	GL_CHECK(gl.EndQueryARB);
	gl.EndQueryIndexed = (void APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glEndQueryIndexed", lib);
	GL_CHECK(gl.EndQueryIndexed);
	gl.EndTraceMESA = (void APIENTRY (*)(void)) ldg_find("glEndTraceMESA", lib);
	GL_CHECK(gl.EndTraceMESA);
	gl.EndTransformFeedback = (void APIENTRY (*)(void)) ldg_find("glEndTransformFeedback", lib);
	GL_CHECK(gl.EndTransformFeedback);
	gl.EndTransformFeedbackEXT = (void APIENTRY (*)(void)) ldg_find("glEndTransformFeedbackEXT", lib);
	GL_CHECK(gl.EndTransformFeedbackEXT);
	gl.EndTransformFeedbackNV = (void APIENTRY (*)(void)) ldg_find("glEndTransformFeedbackNV", lib);
	GL_CHECK(gl.EndTransformFeedbackNV);
	gl.EndVertexShaderEXT = (void APIENTRY (*)(void)) ldg_find("glEndVertexShaderEXT", lib);
	GL_CHECK(gl.EndVertexShaderEXT);
	gl.EndVideoCaptureNV = (void APIENTRY (*)(GLuint video_capture_slot)) ldg_find("glEndVideoCaptureNV", lib);
	GL_CHECK(gl.EndVideoCaptureNV);
	gl.EvalCoord1d = (void APIENTRY (*)(GLdouble u)) ldg_find("glEvalCoord1d", lib);
	GL_CHECK(gl.EvalCoord1d);
	gl.EvalCoord1dv = (void APIENTRY (*)(const GLdouble *u)) ldg_find("glEvalCoord1dv", lib);
	GL_CHECK(gl.EvalCoord1dv);
	gl.EvalCoord1f = (void APIENTRY (*)(GLfloat u)) ldg_find("glEvalCoord1f", lib);
	GL_CHECK(gl.EvalCoord1f);
	gl.EvalCoord1fv = (void APIENTRY (*)(const GLfloat *u)) ldg_find("glEvalCoord1fv", lib);
	GL_CHECK(gl.EvalCoord1fv);
	gl.EvalCoord1xOES = (void APIENTRY (*)(GLfixed u)) ldg_find("glEvalCoord1xOES", lib);
	GL_CHECK(gl.EvalCoord1xOES);
	gl.EvalCoord1xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glEvalCoord1xvOES", lib);
	GL_CHECK(gl.EvalCoord1xvOES);
	gl.EvalCoord2d = (void APIENTRY (*)(GLdouble u, GLdouble v)) ldg_find("glEvalCoord2d", lib);
	GL_CHECK(gl.EvalCoord2d);
	gl.EvalCoord2dv = (void APIENTRY (*)(const GLdouble *u)) ldg_find("glEvalCoord2dv", lib);
	GL_CHECK(gl.EvalCoord2dv);
	gl.EvalCoord2f = (void APIENTRY (*)(GLfloat u, GLfloat v)) ldg_find("glEvalCoord2f", lib);
	GL_CHECK(gl.EvalCoord2f);
	gl.EvalCoord2fv = (void APIENTRY (*)(const GLfloat *u)) ldg_find("glEvalCoord2fv", lib);
	GL_CHECK(gl.EvalCoord2fv);
	gl.EvalCoord2xOES = (void APIENTRY (*)(GLfixed u, GLfixed v)) ldg_find("glEvalCoord2xOES", lib);
	GL_CHECK(gl.EvalCoord2xOES);
	gl.EvalCoord2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glEvalCoord2xvOES", lib);
	GL_CHECK(gl.EvalCoord2xvOES);
	gl.EvalMapsNV = (void APIENTRY (*)(GLenum target, GLenum mode)) ldg_find("glEvalMapsNV", lib);
	GL_CHECK(gl.EvalMapsNV);
	gl.EvalMesh1 = (void APIENTRY (*)(GLenum mode, GLint i1, GLint i2)) ldg_find("glEvalMesh1", lib);
	GL_CHECK(gl.EvalMesh1);
	gl.EvalMesh2 = (void APIENTRY (*)(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)) ldg_find("glEvalMesh2", lib);
	GL_CHECK(gl.EvalMesh2);
	gl.EvalPoint1 = (void APIENTRY (*)(GLint i)) ldg_find("glEvalPoint1", lib);
	GL_CHECK(gl.EvalPoint1);
	gl.EvalPoint2 = (void APIENTRY (*)(GLint i, GLint j)) ldg_find("glEvalPoint2", lib);
	GL_CHECK(gl.EvalPoint2);
	gl.ExecuteProgramNV = (void APIENTRY (*)(GLenum target, GLuint id, const GLfloat *params)) ldg_find("glExecuteProgramNV", lib);
	GL_CHECK(gl.ExecuteProgramNV);
	gl.ExtractComponentEXT = (void APIENTRY (*)(GLuint res, GLuint src, GLuint num)) ldg_find("glExtractComponentEXT", lib);
	GL_CHECK(gl.ExtractComponentEXT);
	gl.FeedbackBuffer = (void APIENTRY (*)(GLsizei size, GLenum type, GLfloat *buffer)) ldg_find("glFeedbackBuffer", lib);
	GL_CHECK(gl.FeedbackBuffer);
	gl.FeedbackBufferxOES = (void APIENTRY (*)(GLsizei n, GLenum type, const GLfixed *buffer)) ldg_find("glFeedbackBufferxOES", lib);
	GL_CHECK(gl.FeedbackBufferxOES);
	gl.FenceSync = (GLsync APIENTRY (*)(GLenum condition, GLbitfield flags)) ldg_find("glFenceSync", lib);
	GL_CHECK(gl.FenceSync);
	gl.FinalCombinerInputNV = (void APIENTRY (*)(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)) ldg_find("glFinalCombinerInputNV", lib);
	GL_CHECK(gl.FinalCombinerInputNV);
	gl.Finish = (void APIENTRY (*)(void)) ldg_find("glFinish", lib);
	GL_CHECK(gl.Finish);
	gl.FinishAsyncSGIX = (GLint APIENTRY (*)(GLuint *markerp)) ldg_find("glFinishAsyncSGIX", lib);
	GL_CHECK(gl.FinishAsyncSGIX);
	gl.FinishFenceAPPLE = (void APIENTRY (*)(GLuint fence)) ldg_find("glFinishFenceAPPLE", lib);
	GL_CHECK(gl.FinishFenceAPPLE);
	gl.FinishFenceNV = (void APIENTRY (*)(GLuint fence)) ldg_find("glFinishFenceNV", lib);
	GL_CHECK(gl.FinishFenceNV);
	gl.FinishObjectAPPLE = (void APIENTRY (*)(GLenum object, GLuint name)) ldg_find("glFinishObjectAPPLE", lib);
	GL_CHECK(gl.FinishObjectAPPLE);
	gl.FinishRenderAPPLE = (void APIENTRY (*)(void)) ldg_find("glFinishRenderAPPLE", lib);
	GL_CHECK(gl.FinishRenderAPPLE);
	gl.FinishTextureSUNX = (void APIENTRY (*)(void)) ldg_find("glFinishTextureSUNX", lib);
	GL_CHECK(gl.FinishTextureSUNX);
	gl.Flush = (void APIENTRY (*)(void)) ldg_find("glFlush", lib);
	GL_CHECK(gl.Flush);
	gl.FlushMappedBufferRange = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr length)) ldg_find("glFlushMappedBufferRange", lib);
	GL_CHECK(gl.FlushMappedBufferRange);
	gl.FlushMappedBufferRangeAPPLE = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size)) ldg_find("glFlushMappedBufferRangeAPPLE", lib);
	GL_CHECK(gl.FlushMappedBufferRangeAPPLE);
	gl.FlushMappedNamedBufferRangeEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length)) ldg_find("glFlushMappedNamedBufferRangeEXT", lib);
	GL_CHECK(gl.FlushMappedNamedBufferRangeEXT);
	gl.FlushPixelDataRangeNV = (void APIENTRY (*)(GLenum target)) ldg_find("glFlushPixelDataRangeNV", lib);
	GL_CHECK(gl.FlushPixelDataRangeNV);
	gl.FlushRasterSGIX = (void APIENTRY (*)(void)) ldg_find("glFlushRasterSGIX", lib);
	GL_CHECK(gl.FlushRasterSGIX);
	gl.FlushRenderAPPLE = (void APIENTRY (*)(void)) ldg_find("glFlushRenderAPPLE", lib);
	GL_CHECK(gl.FlushRenderAPPLE);
	gl.FlushStaticDataIBM = (void APIENTRY (*)(GLenum target)) ldg_find("glFlushStaticDataIBM", lib);
	GL_CHECK(gl.FlushStaticDataIBM);
	gl.FlushVertexArrayRangeAPPLE = (void APIENTRY (*)(GLsizei length, void *pointer)) ldg_find("glFlushVertexArrayRangeAPPLE", lib);
	GL_CHECK(gl.FlushVertexArrayRangeAPPLE);
	gl.FlushVertexArrayRangeNV = (void APIENTRY (*)(void)) ldg_find("glFlushVertexArrayRangeNV", lib);
	GL_CHECK(gl.FlushVertexArrayRangeNV);
	gl.FogCoordFormatNV = (void APIENTRY (*)(GLenum type, GLsizei stride)) ldg_find("glFogCoordFormatNV", lib);
	GL_CHECK(gl.FogCoordFormatNV);
	gl.FogCoordPointer = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glFogCoordPointer", lib);
	GL_CHECK(gl.FogCoordPointer);
	gl.FogCoordPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glFogCoordPointerEXT", lib);
	GL_CHECK(gl.FogCoordPointerEXT);
	gl.FogCoordPointerListIBM = (void APIENTRY (*)(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glFogCoordPointerListIBM", lib);
	GL_CHECK(gl.FogCoordPointerListIBM);
	gl.FogCoordd = (void APIENTRY (*)(GLdouble coord)) ldg_find("glFogCoordd", lib);
	GL_CHECK(gl.FogCoordd);
	gl.FogCoorddEXT = (void APIENTRY (*)(GLdouble coord)) ldg_find("glFogCoorddEXT", lib);
	GL_CHECK(gl.FogCoorddEXT);
	gl.FogCoorddv = (void APIENTRY (*)(const GLdouble *coord)) ldg_find("glFogCoorddv", lib);
	GL_CHECK(gl.FogCoorddv);
	gl.FogCoorddvEXT = (void APIENTRY (*)(const GLdouble *coord)) ldg_find("glFogCoorddvEXT", lib);
	GL_CHECK(gl.FogCoorddvEXT);
	gl.FogCoordf = (void APIENTRY (*)(GLfloat coord)) ldg_find("glFogCoordf", lib);
	GL_CHECK(gl.FogCoordf);
	gl.FogCoordfEXT = (void APIENTRY (*)(GLfloat coord)) ldg_find("glFogCoordfEXT", lib);
	GL_CHECK(gl.FogCoordfEXT);
	gl.FogCoordfv = (void APIENTRY (*)(const GLfloat *coord)) ldg_find("glFogCoordfv", lib);
	GL_CHECK(gl.FogCoordfv);
	gl.FogCoordfvEXT = (void APIENTRY (*)(const GLfloat *coord)) ldg_find("glFogCoordfvEXT", lib);
	GL_CHECK(gl.FogCoordfvEXT);
	gl.FogCoordhNV = (void APIENTRY (*)(GLhalfNV32 fog)) ldg_find("glFogCoordhNV", lib);
	GL_CHECK(gl.FogCoordhNV);
	gl.FogCoordhvNV = (void APIENTRY (*)(const GLhalfNV *fog)) ldg_find("glFogCoordhvNV", lib);
	GL_CHECK(gl.FogCoordhvNV);
	gl.FogFuncSGIS = (void APIENTRY (*)(GLsizei n, const GLfloat *points)) ldg_find("glFogFuncSGIS", lib);
	GL_CHECK(gl.FogFuncSGIS);
	gl.Fogf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glFogf", lib);
	GL_CHECK(gl.Fogf);
	gl.Fogfv = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glFogfv", lib);
	GL_CHECK(gl.Fogfv);
	gl.Fogi = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glFogi", lib);
	GL_CHECK(gl.Fogi);
	gl.Fogiv = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glFogiv", lib);
	GL_CHECK(gl.Fogiv);
	gl.FogxOES = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glFogxOES", lib);
	GL_CHECK(gl.FogxOES);
	gl.FogxvOES = (void APIENTRY (*)(GLenum pname, const GLfixed *param)) ldg_find("glFogxvOES", lib);
	GL_CHECK(gl.FogxvOES);
	gl.FragmentColorMaterialSGIX = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glFragmentColorMaterialSGIX", lib);
	GL_CHECK(gl.FragmentColorMaterialSGIX);
	gl.FragmentLightModelfSGIX = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glFragmentLightModelfSGIX", lib);
	GL_CHECK(gl.FragmentLightModelfSGIX);
	gl.FragmentLightModelfvSGIX = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glFragmentLightModelfvSGIX", lib);
	GL_CHECK(gl.FragmentLightModelfvSGIX);
	gl.FragmentLightModeliSGIX = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glFragmentLightModeliSGIX", lib);
	GL_CHECK(gl.FragmentLightModeliSGIX);
	gl.FragmentLightModelivSGIX = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glFragmentLightModelivSGIX", lib);
	GL_CHECK(gl.FragmentLightModelivSGIX);
	gl.FragmentLightfSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat param)) ldg_find("glFragmentLightfSGIX", lib);
	GL_CHECK(gl.FragmentLightfSGIX);
	gl.FragmentLightfvSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, const GLfloat *params)) ldg_find("glFragmentLightfvSGIX", lib);
	GL_CHECK(gl.FragmentLightfvSGIX);
	gl.FragmentLightiSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLint param)) ldg_find("glFragmentLightiSGIX", lib);
	GL_CHECK(gl.FragmentLightiSGIX);
	gl.FragmentLightivSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, const GLint *params)) ldg_find("glFragmentLightivSGIX", lib);
	GL_CHECK(gl.FragmentLightivSGIX);
	gl.FragmentMaterialfSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat param)) ldg_find("glFragmentMaterialfSGIX", lib);
	GL_CHECK(gl.FragmentMaterialfSGIX);
	gl.FragmentMaterialfvSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, const GLfloat *params)) ldg_find("glFragmentMaterialfvSGIX", lib);
	GL_CHECK(gl.FragmentMaterialfvSGIX);
	gl.FragmentMaterialiSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLint param)) ldg_find("glFragmentMaterialiSGIX", lib);
	GL_CHECK(gl.FragmentMaterialiSGIX);
	gl.FragmentMaterialivSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, const GLint *params)) ldg_find("glFragmentMaterialivSGIX", lib);
	GL_CHECK(gl.FragmentMaterialivSGIX);
	gl.FrameTerminatorGREMEDY = (void APIENTRY (*)(void)) ldg_find("glFrameTerminatorGREMEDY", lib);
	GL_CHECK(gl.FrameTerminatorGREMEDY);
	gl.FrameZoomSGIX = (void APIENTRY (*)(GLint factor)) ldg_find("glFrameZoomSGIX", lib);
	GL_CHECK(gl.FrameZoomSGIX);
	gl.FramebufferDrawBufferEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum mode)) ldg_find("glFramebufferDrawBufferEXT", lib);
	GL_CHECK(gl.FramebufferDrawBufferEXT);
	gl.FramebufferDrawBuffersEXT = (void APIENTRY (*)(GLuint framebuffer, GLsizei n, const GLenum *bufs)) ldg_find("glFramebufferDrawBuffersEXT", lib);
	GL_CHECK(gl.FramebufferDrawBuffersEXT);
	gl.FramebufferParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glFramebufferParameteri", lib);
	GL_CHECK(gl.FramebufferParameteri);
	gl.FramebufferReadBufferEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum mode)) ldg_find("glFramebufferReadBufferEXT", lib);
	GL_CHECK(gl.FramebufferReadBufferEXT);
	gl.FramebufferRenderbuffer = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glFramebufferRenderbuffer", lib);
	GL_CHECK(gl.FramebufferRenderbuffer);
	gl.FramebufferRenderbufferEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glFramebufferRenderbufferEXT", lib);
	GL_CHECK(gl.FramebufferRenderbufferEXT);
	gl.FramebufferTexture = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level)) ldg_find("glFramebufferTexture", lib);
	GL_CHECK(gl.FramebufferTexture);
	gl.FramebufferTexture1D = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture1D", lib);
	GL_CHECK(gl.FramebufferTexture1D);
	gl.FramebufferTexture1DEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture1DEXT", lib);
	GL_CHECK(gl.FramebufferTexture1DEXT);
	gl.FramebufferTexture2D = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture2D", lib);
	GL_CHECK(gl.FramebufferTexture2D);
	gl.FramebufferTexture2DEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glFramebufferTexture2DEXT", lib);
	GL_CHECK(gl.FramebufferTexture2DEXT);
	gl.FramebufferTexture3D = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)) ldg_find("glFramebufferTexture3D", lib);
	GL_CHECK(gl.FramebufferTexture3D);
	gl.FramebufferTexture3DEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)) ldg_find("glFramebufferTexture3DEXT", lib);
	GL_CHECK(gl.FramebufferTexture3DEXT);
	gl.FramebufferTextureARB = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level)) ldg_find("glFramebufferTextureARB", lib);
	GL_CHECK(gl.FramebufferTextureARB);
	gl.FramebufferTextureEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level)) ldg_find("glFramebufferTextureEXT", lib);
	GL_CHECK(gl.FramebufferTextureEXT);
	gl.FramebufferTextureFaceARB = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)) ldg_find("glFramebufferTextureFaceARB", lib);
	GL_CHECK(gl.FramebufferTextureFaceARB);
	gl.FramebufferTextureFaceEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)) ldg_find("glFramebufferTextureFaceEXT", lib);
	GL_CHECK(gl.FramebufferTextureFaceEXT);
	gl.FramebufferTextureLayer = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glFramebufferTextureLayer", lib);
	GL_CHECK(gl.FramebufferTextureLayer);
	gl.FramebufferTextureLayerARB = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glFramebufferTextureLayerARB", lib);
	GL_CHECK(gl.FramebufferTextureLayerARB);
	gl.FramebufferTextureLayerEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glFramebufferTextureLayerEXT", lib);
	GL_CHECK(gl.FramebufferTextureLayerEXT);
	gl.FreeObjectBufferATI = (void APIENTRY (*)(GLuint buffer)) ldg_find("glFreeObjectBufferATI", lib);
	GL_CHECK(gl.FreeObjectBufferATI);
	gl.FrontFace = (void APIENTRY (*)(GLenum mode)) ldg_find("glFrontFace", lib);
	GL_CHECK(gl.FrontFace);
	gl.Frustum = (void APIENTRY (*)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glFrustumd", lib);
	GL_CHECK(gl.Frustum);
	gl.Frustumf = (void APIENTRY (*)(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near_val, GLfloat far_val)) ldg_find("glFrustum", lib);
	GL_CHECK(gl.Frustumf);
	gl.FrustumfOES = (void APIENTRY (*)(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)) ldg_find("glFrustumfOES", lib);
	GL_CHECK(gl.FrustumfOES);
	gl.FrustumxOES = (void APIENTRY (*)(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)) ldg_find("glFrustumxOES", lib);
	GL_CHECK(gl.FrustumxOES);
	gl.GenAsyncMarkersSGIX = (GLuint APIENTRY (*)(GLsizei range)) ldg_find("glGenAsyncMarkersSGIX", lib);
	GL_CHECK(gl.GenAsyncMarkersSGIX);
	gl.GenBuffers = (void APIENTRY (*)(GLsizei n, GLuint *buffers)) ldg_find("glGenBuffers", lib);
	GL_CHECK(gl.GenBuffers);
	gl.GenBuffersARB = (void APIENTRY (*)(GLsizei n, GLuint *buffers)) ldg_find("glGenBuffersARB", lib);
	GL_CHECK(gl.GenBuffersARB);
	gl.GenFencesAPPLE = (void APIENTRY (*)(GLsizei n, GLuint *fences)) ldg_find("glGenFencesAPPLE", lib);
	GL_CHECK(gl.GenFencesAPPLE);
	gl.GenFencesNV = (void APIENTRY (*)(GLsizei n, GLuint *fences)) ldg_find("glGenFencesNV", lib);
	GL_CHECK(gl.GenFencesNV);
	gl.GenFragmentShadersATI = (GLuint APIENTRY (*)(GLuint range)) ldg_find("glGenFragmentShadersATI", lib);
	GL_CHECK(gl.GenFragmentShadersATI);
	gl.GenFramebuffers = (void APIENTRY (*)(GLsizei n, GLuint *framebuffers)) ldg_find("glGenFramebuffers", lib);
	GL_CHECK(gl.GenFramebuffers);
	gl.GenFramebuffersEXT = (void APIENTRY (*)(GLsizei n, GLuint *framebuffers)) ldg_find("glGenFramebuffersEXT", lib);
	GL_CHECK(gl.GenFramebuffersEXT);
	gl.GenLists = (GLuint APIENTRY (*)(GLsizei range)) ldg_find("glGenLists", lib);
	GL_CHECK(gl.GenLists);
	gl.GenNamesAMD = (void APIENTRY (*)(GLenum identifier, GLuint num, GLuint *names)) ldg_find("glGenNamesAMD", lib);
	GL_CHECK(gl.GenNamesAMD);
	gl.GenOcclusionQueriesNV = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenOcclusionQueriesNV", lib);
	GL_CHECK(gl.GenOcclusionQueriesNV);
	gl.GenPathsNV = (GLuint APIENTRY (*)(GLsizei range)) ldg_find("glGenPathsNV", lib);
	GL_CHECK(gl.GenPathsNV);
	gl.GenPerfMonitorsAMD = (void APIENTRY (*)(GLsizei n, GLuint *monitors)) ldg_find("glGenPerfMonitorsAMD", lib);
	GL_CHECK(gl.GenPerfMonitorsAMD);
	gl.GenProgramPipelines = (void APIENTRY (*)(GLsizei n, GLuint *pipelines)) ldg_find("glGenProgramPipelines", lib);
	GL_CHECK(gl.GenProgramPipelines);
	gl.GenProgramsARB = (void APIENTRY (*)(GLsizei n, GLuint *programs)) ldg_find("glGenProgramsARB", lib);
	GL_CHECK(gl.GenProgramsARB);
	gl.GenProgramsNV = (void APIENTRY (*)(GLsizei n, GLuint *programs)) ldg_find("glGenProgramsNV", lib);
	GL_CHECK(gl.GenProgramsNV);
	gl.GenQueries = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenQueries", lib);
	GL_CHECK(gl.GenQueries);
	gl.GenQueriesARB = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenQueriesARB", lib);
	GL_CHECK(gl.GenQueriesARB);
	gl.GenRenderbuffers = (void APIENTRY (*)(GLsizei n, GLuint *renderbuffers)) ldg_find("glGenRenderbuffers", lib);
	GL_CHECK(gl.GenRenderbuffers);
	gl.GenRenderbuffersEXT = (void APIENTRY (*)(GLsizei n, GLuint *renderbuffers)) ldg_find("glGenRenderbuffersEXT", lib);
	GL_CHECK(gl.GenRenderbuffersEXT);
	gl.GenSamplers = (void APIENTRY (*)(GLsizei count, GLuint *samplers)) ldg_find("glGenSamplers", lib);
	GL_CHECK(gl.GenSamplers);
	gl.GenSymbolsEXT = (GLuint APIENTRY (*)(GLenum datatype, GLenum storagetype, GLenum range, GLuint components)) ldg_find("glGenSymbolsEXT", lib);
	GL_CHECK(gl.GenSymbolsEXT);
	gl.GenTextures = (void APIENTRY (*)(GLsizei n, GLuint *textures)) ldg_find("glGenTextures", lib);
	GL_CHECK(gl.GenTextures);
	gl.GenTexturesEXT = (void APIENTRY (*)(GLsizei n, GLuint *textures)) ldg_find("glGenTexturesEXT", lib);
	GL_CHECK(gl.GenTexturesEXT);
	gl.GenTransformFeedbacks = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenTransformFeedbacks", lib);
	GL_CHECK(gl.GenTransformFeedbacks);
	gl.GenTransformFeedbacksNV = (void APIENTRY (*)(GLsizei n, GLuint *ids)) ldg_find("glGenTransformFeedbacksNV", lib);
	GL_CHECK(gl.GenTransformFeedbacksNV);
	gl.GenVertexArrays = (void APIENTRY (*)(GLsizei n, GLuint *arrays)) ldg_find("glGenVertexArrays", lib);
	GL_CHECK(gl.GenVertexArrays);
	gl.GenVertexArraysAPPLE = (void APIENTRY (*)(GLsizei n, GLuint *arrays)) ldg_find("glGenVertexArraysAPPLE", lib);
	GL_CHECK(gl.GenVertexArraysAPPLE);
	gl.GenVertexShadersEXT = (GLuint APIENTRY (*)(GLuint range)) ldg_find("glGenVertexShadersEXT", lib);
	GL_CHECK(gl.GenVertexShadersEXT);
	gl.GenerateMipmap = (void APIENTRY (*)(GLenum target)) ldg_find("glGenerateMipmap", lib);
	GL_CHECK(gl.GenerateMipmap);
	gl.GenerateMipmapEXT = (void APIENTRY (*)(GLenum target)) ldg_find("glGenerateMipmapEXT", lib);
	GL_CHECK(gl.GenerateMipmapEXT);
	gl.GenerateMultiTexMipmapEXT = (void APIENTRY (*)(GLenum texunit, GLenum target)) ldg_find("glGenerateMultiTexMipmapEXT", lib);
	GL_CHECK(gl.GenerateMultiTexMipmapEXT);
	gl.GenerateTextureMipmapEXT = (void APIENTRY (*)(GLuint texture, GLenum target)) ldg_find("glGenerateTextureMipmapEXT", lib);
	GL_CHECK(gl.GenerateTextureMipmapEXT);
	gl.GetActiveAtomicCounterBufferiv = (void APIENTRY (*)(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params)) ldg_find("glGetActiveAtomicCounterBufferiv", lib);
	GL_CHECK(gl.GetActiveAtomicCounterBufferiv);
	gl.GetActiveAttrib = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)) ldg_find("glGetActiveAttrib", lib);
	GL_CHECK(gl.GetActiveAttrib);
	gl.GetActiveAttribARB = (void APIENTRY (*)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)) ldg_find("glGetActiveAttribARB", lib);
	GL_CHECK(gl.GetActiveAttribARB);
	gl.GetActiveSubroutineName = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)) ldg_find("glGetActiveSubroutineName", lib);
	GL_CHECK(gl.GetActiveSubroutineName);
	gl.GetActiveSubroutineUniformName = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name)) ldg_find("glGetActiveSubroutineUniformName", lib);
	GL_CHECK(gl.GetActiveSubroutineUniformName);
	gl.GetActiveSubroutineUniformiv = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values)) ldg_find("glGetActiveSubroutineUniformiv", lib);
	GL_CHECK(gl.GetActiveSubroutineUniformiv);
	gl.GetActiveUniform = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)) ldg_find("glGetActiveUniform", lib);
	GL_CHECK(gl.GetActiveUniform);
	gl.GetActiveUniformARB = (void APIENTRY (*)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name)) ldg_find("glGetActiveUniformARB", lib);
	GL_CHECK(gl.GetActiveUniformARB);
	gl.GetActiveUniformBlockIndex = (GLuint APIENTRY (*)(GLuint program, const GLchar *uniformBlockName)) ldg_find("glGetActiveUniformBlockIndex", lib);
	GL_CHECK(gl.GetActiveUniformBlockIndex);
	gl.GetActiveUniformBlockName = (void APIENTRY (*)(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName)) ldg_find("glGetActiveUniformBlockName", lib);
	GL_CHECK(gl.GetActiveUniformBlockName);
	gl.GetActiveUniformBlockiv = (void APIENTRY (*)(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params)) ldg_find("glGetActiveUniformBlockiv", lib);
	GL_CHECK(gl.GetActiveUniformBlockiv);
	gl.GetActiveUniformName = (void APIENTRY (*)(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName)) ldg_find("glGetActiveUniformName", lib);
	GL_CHECK(gl.GetActiveUniformName);
	gl.GetActiveUniformsiv = (void APIENTRY (*)(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params)) ldg_find("glGetActiveUniformsiv", lib);
	GL_CHECK(gl.GetActiveUniformsiv);
	gl.GetActiveVaryingNV = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)) ldg_find("glGetActiveVaryingNV", lib);
	GL_CHECK(gl.GetActiveVaryingNV);
	gl.GetArrayObjectfvATI = (void APIENTRY (*)(GLenum array, GLenum pname, GLfloat *params)) ldg_find("glGetArrayObjectfvATI", lib);
	GL_CHECK(gl.GetArrayObjectfvATI);
	gl.GetArrayObjectivATI = (void APIENTRY (*)(GLenum array, GLenum pname, GLint *params)) ldg_find("glGetArrayObjectivATI", lib);
	GL_CHECK(gl.GetArrayObjectivATI);
	gl.GetAttachedObjectsARB = (void APIENTRY (*)(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj)) ldg_find("glGetAttachedObjectsARB", lib);
	GL_CHECK(gl.GetAttachedObjectsARB);
	gl.GetAttachedShaders = (void APIENTRY (*)(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders)) ldg_find("glGetAttachedShaders", lib);
	GL_CHECK(gl.GetAttachedShaders);
	gl.GetAttribLocation = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetAttribLocation", lib);
	GL_CHECK(gl.GetAttribLocation);
	gl.GetAttribLocationARB = (GLint APIENTRY (*)(GLhandleARB programObj, const GLcharARB *name)) ldg_find("glGetAttribLocationARB", lib);
	GL_CHECK(gl.GetAttribLocationARB);
	gl.GetBooleanIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLboolean *data)) ldg_find("glGetBooleanIndexedvEXT", lib);
	GL_CHECK(gl.GetBooleanIndexedvEXT);
	gl.GetBooleani_v = (void APIENTRY (*)(GLenum target, GLuint index, GLboolean *data)) ldg_find("glGetBooleani_v", lib);
	GL_CHECK(gl.GetBooleani_v);
	gl.GetBooleanv = (void APIENTRY (*)(GLenum pname, GLboolean *params)) ldg_find("glGetBooleanv", lib);
	GL_CHECK(gl.GetBooleanv);
	gl.GetBufferParameteri64v = (void APIENTRY (*)(GLenum target, GLenum pname, GLint64 *params)) ldg_find("glGetBufferParameteri64v", lib);
	GL_CHECK(gl.GetBufferParameteri64v);
	gl.GetBufferParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetBufferParameteriv", lib);
	GL_CHECK(gl.GetBufferParameteriv);
	gl.GetBufferParameterivARB = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetBufferParameterivARB", lib);
	GL_CHECK(gl.GetBufferParameterivARB);
	gl.GetBufferParameterui64vNV = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint64EXT *params)) ldg_find("glGetBufferParameterui64vNV", lib);
	GL_CHECK(gl.GetBufferParameterui64vNV);
	gl.GetBufferPointerv = (void APIENTRY (*)(GLenum target, GLenum pname, void * *params)) ldg_find("glGetBufferPointerv", lib);
	GL_CHECK(gl.GetBufferPointerv);
	gl.GetBufferPointervARB = (void APIENTRY (*)(GLenum target, GLenum pname, void * *params)) ldg_find("glGetBufferPointervARB", lib);
	GL_CHECK(gl.GetBufferPointervARB);
	gl.GetBufferSubData = (void APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr size, void *data)) ldg_find("glGetBufferSubData", lib);
	GL_CHECK(gl.GetBufferSubData);
	gl.GetBufferSubDataARB = (void APIENTRY (*)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data)) ldg_find("glGetBufferSubDataARB", lib);
	GL_CHECK(gl.GetBufferSubDataARB);
	gl.GetClipPlane = (void APIENTRY (*)(GLenum plane, GLdouble *equation)) ldg_find("glGetClipPlane", lib);
	GL_CHECK(gl.GetClipPlane);
	gl.GetClipPlanefOES = (void APIENTRY (*)(GLenum plane, GLfloat *equation)) ldg_find("glGetClipPlanefOES", lib);
	GL_CHECK(gl.GetClipPlanefOES);
	gl.GetClipPlanexOES = (void APIENTRY (*)(GLenum plane, GLfixed *equation)) ldg_find("glGetClipPlanexOES", lib);
	GL_CHECK(gl.GetClipPlanexOES);
	gl.GetColorTable = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *table)) ldg_find("glGetColorTable", lib);
	GL_CHECK(gl.GetColorTable);
	gl.GetColorTableEXT = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *data)) ldg_find("glGetColorTableEXT", lib);
	GL_CHECK(gl.GetColorTableEXT);
	gl.GetColorTableParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetColorTableParameterfv", lib);
	GL_CHECK(gl.GetColorTableParameterfv);
	gl.GetColorTableParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetColorTableParameterfvEXT", lib);
	GL_CHECK(gl.GetColorTableParameterfvEXT);
	gl.GetColorTableParameterfvSGI = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetColorTableParameterfvSGI", lib);
	GL_CHECK(gl.GetColorTableParameterfvSGI);
	gl.GetColorTableParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetColorTableParameteriv", lib);
	GL_CHECK(gl.GetColorTableParameteriv);
	gl.GetColorTableParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetColorTableParameterivEXT", lib);
	GL_CHECK(gl.GetColorTableParameterivEXT);
	gl.GetColorTableParameterivSGI = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetColorTableParameterivSGI", lib);
	GL_CHECK(gl.GetColorTableParameterivSGI);
	gl.GetColorTableSGI = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *table)) ldg_find("glGetColorTableSGI", lib);
	GL_CHECK(gl.GetColorTableSGI);
	gl.GetCombinerInputParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params)) ldg_find("glGetCombinerInputParameterfvNV", lib);
	GL_CHECK(gl.GetCombinerInputParameterfvNV);
	gl.GetCombinerInputParameterivNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params)) ldg_find("glGetCombinerInputParameterivNV", lib);
	GL_CHECK(gl.GetCombinerInputParameterivNV);
	gl.GetCombinerOutputParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum pname, GLfloat *params)) ldg_find("glGetCombinerOutputParameterfvNV", lib);
	GL_CHECK(gl.GetCombinerOutputParameterfvNV);
	gl.GetCombinerOutputParameterivNV = (void APIENTRY (*)(GLenum stage, GLenum portion, GLenum pname, GLint *params)) ldg_find("glGetCombinerOutputParameterivNV", lib);
	GL_CHECK(gl.GetCombinerOutputParameterivNV);
	gl.GetCombinerStageParameterfvNV = (void APIENTRY (*)(GLenum stage, GLenum pname, GLfloat *params)) ldg_find("glGetCombinerStageParameterfvNV", lib);
	GL_CHECK(gl.GetCombinerStageParameterfvNV);
	gl.GetCompressedMultiTexImageEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint lod, void *img)) ldg_find("glGetCompressedMultiTexImageEXT", lib);
	GL_CHECK(gl.GetCompressedMultiTexImageEXT);
	gl.GetCompressedTexImage = (void APIENTRY (*)(GLenum target, GLint level, void *img)) ldg_find("glGetCompressedTexImage", lib);
	GL_CHECK(gl.GetCompressedTexImage);
	gl.GetCompressedTexImageARB = (void APIENTRY (*)(GLenum target, GLint level, void *img)) ldg_find("glGetCompressedTexImageARB", lib);
	GL_CHECK(gl.GetCompressedTexImageARB);
	gl.GetCompressedTextureImageEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint lod, void *img)) ldg_find("glGetCompressedTextureImageEXT", lib);
	GL_CHECK(gl.GetCompressedTextureImageEXT);
	gl.GetConvolutionFilter = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *image)) ldg_find("glGetConvolutionFilter", lib);
	GL_CHECK(gl.GetConvolutionFilter);
	gl.GetConvolutionFilterEXT = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *image)) ldg_find("glGetConvolutionFilterEXT", lib);
	GL_CHECK(gl.GetConvolutionFilterEXT);
	gl.GetConvolutionParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetConvolutionParameterfv", lib);
	GL_CHECK(gl.GetConvolutionParameterfv);
	gl.GetConvolutionParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetConvolutionParameterfvEXT", lib);
	GL_CHECK(gl.GetConvolutionParameterfvEXT);
	gl.GetConvolutionParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetConvolutionParameteriv", lib);
	GL_CHECK(gl.GetConvolutionParameteriv);
	gl.GetConvolutionParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetConvolutionParameterivEXT", lib);
	GL_CHECK(gl.GetConvolutionParameterivEXT);
	gl.GetConvolutionParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetConvolutionParameterxvOES", lib);
	GL_CHECK(gl.GetConvolutionParameterxvOES);
	gl.GetDebugLogLengthMESA = (GLsizei APIENTRY (*)(GLhandleARB obj, GLenum logType, GLenum shaderType)) ldg_find("glGetDebugLogLengthMESA", lib);
	GL_CHECK(gl.GetDebugLogLengthMESA);
	gl.GetDebugLogMESA = (void APIENTRY (*)(GLhandleARB obj, GLenum logType, GLenum shaderType, GLsizei maxLength, GLsizei *length, GLcharARB *debugLog)) ldg_find("glGetDebugLogMESA", lib);
	GL_CHECK(gl.GetDebugLogMESA);
	gl.GetDebugMessageLog = (GLuint APIENTRY (*)(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)) ldg_find("glGetDebugMessageLog", lib);
	GL_CHECK(gl.GetDebugMessageLog);
	gl.GetDebugMessageLogAMD = (GLuint APIENTRY (*)(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message)) ldg_find("glGetDebugMessageLogAMD", lib);
	GL_CHECK(gl.GetDebugMessageLogAMD);
	gl.GetDebugMessageLogARB = (GLuint APIENTRY (*)(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog)) ldg_find("glGetDebugMessageLogARB", lib);
	GL_CHECK(gl.GetDebugMessageLogARB);
	gl.GetDetailTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLfloat *points)) ldg_find("glGetDetailTexFuncSGIS", lib);
	GL_CHECK(gl.GetDetailTexFuncSGIS);
	gl.GetDoubleIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *data)) ldg_find("glGetDoubleIndexedvEXT", lib);
	GL_CHECK(gl.GetDoubleIndexedvEXT);
	gl.GetDoublei_v = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *data)) ldg_find("glGetDoublei_v", lib);
	GL_CHECK(gl.GetDoublei_v);
	gl.GetDoublei_vEXT = (void APIENTRY (*)(GLenum pname, GLuint index, GLdouble *params)) ldg_find("glGetDoublei_vEXT", lib);
	GL_CHECK(gl.GetDoublei_vEXT);
	gl.GetDoublev = (void APIENTRY (*)(GLenum pname, GLdouble *params)) ldg_find("glGetDoublev", lib);
	GL_CHECK(gl.GetDoublev);
	gl.GetError = (GLenum APIENTRY (*)(void)) ldg_find("glGetError", lib);
	GL_CHECK(gl.GetError);
	gl.GetFenceivNV = (void APIENTRY (*)(GLuint fence, GLenum pname, GLint *params)) ldg_find("glGetFenceivNV", lib);
	GL_CHECK(gl.GetFenceivNV);
	gl.GetFinalCombinerInputParameterfvNV = (void APIENTRY (*)(GLenum variable, GLenum pname, GLfloat *params)) ldg_find("glGetFinalCombinerInputParameterfvNV", lib);
	GL_CHECK(gl.GetFinalCombinerInputParameterfvNV);
	gl.GetFinalCombinerInputParameterivNV = (void APIENTRY (*)(GLenum variable, GLenum pname, GLint *params)) ldg_find("glGetFinalCombinerInputParameterivNV", lib);
	GL_CHECK(gl.GetFinalCombinerInputParameterivNV);
	gl.GetFirstPerfQueryIdINTEL = (void APIENTRY (*)(GLuint *queryId)) ldg_find("glGetFirstPerfQueryIdINTEL", lib);
	GL_CHECK(gl.GetFirstPerfQueryIdINTEL);
	gl.GetFixedvOES = (void APIENTRY (*)(GLenum pname, GLfixed *params)) ldg_find("glGetFixedvOES", lib);
	GL_CHECK(gl.GetFixedvOES);
	gl.GetFloatIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *data)) ldg_find("glGetFloatIndexedvEXT", lib);
	GL_CHECK(gl.GetFloatIndexedvEXT);
	gl.GetFloati_v = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *data)) ldg_find("glGetFloati_v", lib);
	GL_CHECK(gl.GetFloati_v);
	gl.GetFloati_vEXT = (void APIENTRY (*)(GLenum pname, GLuint index, GLfloat *params)) ldg_find("glGetFloati_vEXT", lib);
	GL_CHECK(gl.GetFloati_vEXT);
	gl.GetFloatv = (void APIENTRY (*)(GLenum pname, GLfloat *params)) ldg_find("glGetFloatv", lib);
	GL_CHECK(gl.GetFloatv);
	gl.GetFogFuncSGIS = (void APIENTRY (*)(GLfloat *points)) ldg_find("glGetFogFuncSGIS", lib);
	GL_CHECK(gl.GetFogFuncSGIS);
	gl.GetFragDataIndex = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetFragDataIndex", lib);
	GL_CHECK(gl.GetFragDataIndex);
	gl.GetFragDataLocation = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetFragDataLocation", lib);
	GL_CHECK(gl.GetFragDataLocation);
	gl.GetFragDataLocationEXT = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetFragDataLocationEXT", lib);
	GL_CHECK(gl.GetFragDataLocationEXT);
	gl.GetFragmentLightfvSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat *params)) ldg_find("glGetFragmentLightfvSGIX", lib);
	GL_CHECK(gl.GetFragmentLightfvSGIX);
	gl.GetFragmentLightivSGIX = (void APIENTRY (*)(GLenum light, GLenum pname, GLint *params)) ldg_find("glGetFragmentLightivSGIX", lib);
	GL_CHECK(gl.GetFragmentLightivSGIX);
	gl.GetFragmentMaterialfvSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat *params)) ldg_find("glGetFragmentMaterialfvSGIX", lib);
	GL_CHECK(gl.GetFragmentMaterialfvSGIX);
	gl.GetFragmentMaterialivSGIX = (void APIENTRY (*)(GLenum face, GLenum pname, GLint *params)) ldg_find("glGetFragmentMaterialivSGIX", lib);
	GL_CHECK(gl.GetFragmentMaterialivSGIX);
	gl.GetFramebufferAttachmentParameteriv = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetFramebufferAttachmentParameteriv", lib);
	GL_CHECK(gl.GetFramebufferAttachmentParameteriv);
	gl.GetFramebufferAttachmentParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetFramebufferAttachmentParameterivEXT", lib);
	GL_CHECK(gl.GetFramebufferAttachmentParameterivEXT);
	gl.GetFramebufferParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetFramebufferParameteriv", lib);
	GL_CHECK(gl.GetFramebufferParameteriv);
	gl.GetFramebufferParameterivEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint *params)) ldg_find("glGetFramebufferParameterivEXT", lib);
	GL_CHECK(gl.GetFramebufferParameterivEXT);
	gl.GetGraphicsResetStatusARB = (GLenum APIENTRY (*)(void)) ldg_find("glGetGraphicsResetStatusARB", lib);
	GL_CHECK(gl.GetGraphicsResetStatusARB);
	gl.GetHandleARB = (GLhandleARB APIENTRY (*)(GLenum pname)) ldg_find("glGetHandleARB", lib);
	GL_CHECK(gl.GetHandleARB);
	gl.GetHistogram = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetHistogram", lib);
	GL_CHECK(gl.GetHistogram);
	gl.GetHistogramEXT = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetHistogramEXT", lib);
	GL_CHECK(gl.GetHistogramEXT);
	gl.GetHistogramParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetHistogramParameterfv", lib);
	GL_CHECK(gl.GetHistogramParameterfv);
	gl.GetHistogramParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetHistogramParameterfvEXT", lib);
	GL_CHECK(gl.GetHistogramParameterfvEXT);
	gl.GetHistogramParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetHistogramParameteriv", lib);
	GL_CHECK(gl.GetHistogramParameteriv);
	gl.GetHistogramParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetHistogramParameterivEXT", lib);
	GL_CHECK(gl.GetHistogramParameterivEXT);
	gl.GetHistogramParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetHistogramParameterxvOES", lib);
	GL_CHECK(gl.GetHistogramParameterxvOES);
	gl.GetImageHandleARB = (GLuint64 APIENTRY (*)(GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum format)) ldg_find("glGetImageHandleARB", lib);
	GL_CHECK(gl.GetImageHandleARB);
	gl.GetImageHandleNV = (GLuint64 APIENTRY (*)(GLuint texture, GLint level, GLboolean32 layered, GLint layer, GLenum format)) ldg_find("glGetImageHandleNV", lib);
	GL_CHECK(gl.GetImageHandleNV);
	gl.GetImageTransformParameterfvHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetImageTransformParameterfvHP", lib);
	GL_CHECK(gl.GetImageTransformParameterfvHP);
	gl.GetImageTransformParameterivHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetImageTransformParameterivHP", lib);
	GL_CHECK(gl.GetImageTransformParameterivHP);
	gl.GetInfoLogARB = (void APIENTRY (*)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog)) ldg_find("glGetInfoLogARB", lib);
	GL_CHECK(gl.GetInfoLogARB);
	gl.GetInstrumentsSGIX = (GLint APIENTRY (*)(void)) ldg_find("glGetInstrumentsSGIX", lib);
	GL_CHECK(gl.GetInstrumentsSGIX);
	gl.GetInteger64i_v = (void APIENTRY (*)(GLenum target, GLuint index, GLint64 *data)) ldg_find("glGetInteger64i_v", lib);
	GL_CHECK(gl.GetInteger64i_v);
	gl.GetInteger64v = (void APIENTRY (*)(GLenum pname, GLint64 *data)) ldg_find("glGetInteger64v", lib);
	GL_CHECK(gl.GetInteger64v);
	gl.GetIntegerIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLint *data)) ldg_find("glGetIntegerIndexedvEXT", lib);
	GL_CHECK(gl.GetIntegerIndexedvEXT);
	gl.GetIntegeri_v = (void APIENTRY (*)(GLenum target, GLuint index, GLint *data)) ldg_find("glGetIntegeri_v", lib);
	GL_CHECK(gl.GetIntegeri_v);
	gl.GetIntegerui64i_vNV = (void APIENTRY (*)(GLenum value, GLuint index, GLuint64EXT *result)) ldg_find("glGetIntegerui64i_vNV", lib);
	GL_CHECK(gl.GetIntegerui64i_vNV);
	gl.GetIntegerui64vNV = (void APIENTRY (*)(GLenum value, GLuint64EXT *result)) ldg_find("glGetIntegerui64vNV", lib);
	GL_CHECK(gl.GetIntegerui64vNV);
	gl.GetIntegerv = (void APIENTRY (*)(GLenum pname, GLint *params)) ldg_find("glGetIntegerv", lib);
	GL_CHECK(gl.GetIntegerv);
	gl.GetInternalformati64v = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params)) ldg_find("glGetInternalformati64v", lib);
	GL_CHECK(gl.GetInternalformati64v);
	gl.GetInternalformativ = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params)) ldg_find("glGetInternalformativ", lib);
	GL_CHECK(gl.GetInternalformativ);
	gl.GetInvariantBooleanvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLboolean *data)) ldg_find("glGetInvariantBooleanvEXT", lib);
	GL_CHECK(gl.GetInvariantBooleanvEXT);
	gl.GetInvariantFloatvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLfloat *data)) ldg_find("glGetInvariantFloatvEXT", lib);
	GL_CHECK(gl.GetInvariantFloatvEXT);
	gl.GetInvariantIntegervEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLint *data)) ldg_find("glGetInvariantIntegervEXT", lib);
	GL_CHECK(gl.GetInvariantIntegervEXT);
	gl.GetLightfv = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat *params)) ldg_find("glGetLightfv", lib);
	GL_CHECK(gl.GetLightfv);
	gl.GetLightiv = (void APIENTRY (*)(GLenum light, GLenum pname, GLint *params)) ldg_find("glGetLightiv", lib);
	GL_CHECK(gl.GetLightiv);
	gl.GetLightxOES = (void APIENTRY (*)(GLenum light, GLenum pname, GLfixed *params)) ldg_find("glGetLightxOES", lib);
	GL_CHECK(gl.GetLightxOES);
	gl.GetListParameterfvSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLfloat *params)) ldg_find("glGetListParameterfvSGIX", lib);
	GL_CHECK(gl.GetListParameterfvSGIX);
	gl.GetListParameterivSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLint *params)) ldg_find("glGetListParameterivSGIX", lib);
	GL_CHECK(gl.GetListParameterivSGIX);
	gl.GetLocalConstantBooleanvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLboolean *data)) ldg_find("glGetLocalConstantBooleanvEXT", lib);
	GL_CHECK(gl.GetLocalConstantBooleanvEXT);
	gl.GetLocalConstantFloatvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLfloat *data)) ldg_find("glGetLocalConstantFloatvEXT", lib);
	GL_CHECK(gl.GetLocalConstantFloatvEXT);
	gl.GetLocalConstantIntegervEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLint *data)) ldg_find("glGetLocalConstantIntegervEXT", lib);
	GL_CHECK(gl.GetLocalConstantIntegervEXT);
	gl.GetMapAttribParameterfvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetMapAttribParameterfvNV", lib);
	GL_CHECK(gl.GetMapAttribParameterfvNV);
	gl.GetMapAttribParameterivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLint *params)) ldg_find("glGetMapAttribParameterivNV", lib);
	GL_CHECK(gl.GetMapAttribParameterivNV);
	gl.GetMapControlPointsNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean32 packed, void *points)) ldg_find("glGetMapControlPointsNV", lib);
	GL_CHECK(gl.GetMapControlPointsNV);
	gl.GetMapParameterfvNV = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMapParameterfvNV", lib);
	GL_CHECK(gl.GetMapParameterfvNV);
	gl.GetMapParameterivNV = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMapParameterivNV", lib);
	GL_CHECK(gl.GetMapParameterivNV);
	gl.GetMapdv = (void APIENTRY (*)(GLenum target, GLenum query, GLdouble *v)) ldg_find("glGetMapdv", lib);
	GL_CHECK(gl.GetMapdv);
	gl.GetMapfv = (void APIENTRY (*)(GLenum target, GLenum query, GLfloat *v)) ldg_find("glGetMapfv", lib);
	GL_CHECK(gl.GetMapfv);
	gl.GetMapiv = (void APIENTRY (*)(GLenum target, GLenum query, GLint *v)) ldg_find("glGetMapiv", lib);
	GL_CHECK(gl.GetMapiv);
	gl.GetMapxvOES = (void APIENTRY (*)(GLenum target, GLenum query, GLfixed *v)) ldg_find("glGetMapxvOES", lib);
	GL_CHECK(gl.GetMapxvOES);
	gl.GetMaterialfv = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat *params)) ldg_find("glGetMaterialfv", lib);
	GL_CHECK(gl.GetMaterialfv);
	gl.GetMaterialiv = (void APIENTRY (*)(GLenum face, GLenum pname, GLint *params)) ldg_find("glGetMaterialiv", lib);
	GL_CHECK(gl.GetMaterialiv);
	gl.GetMaterialxOES = (void APIENTRY (*)(GLenum face, GLenum pname, GLfixed param)) ldg_find("glGetMaterialxOES", lib);
	GL_CHECK(gl.GetMaterialxOES);
	gl.GetMinmax = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetMinmax", lib);
	GL_CHECK(gl.GetMinmax);
	gl.GetMinmaxEXT = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, void *values)) ldg_find("glGetMinmaxEXT", lib);
	GL_CHECK(gl.GetMinmaxEXT);
	gl.GetMinmaxParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMinmaxParameterfv", lib);
	GL_CHECK(gl.GetMinmaxParameterfv);
	gl.GetMinmaxParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMinmaxParameterfvEXT", lib);
	GL_CHECK(gl.GetMinmaxParameterfvEXT);
	gl.GetMinmaxParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMinmaxParameteriv", lib);
	GL_CHECK(gl.GetMinmaxParameteriv);
	gl.GetMinmaxParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMinmaxParameterivEXT", lib);
	GL_CHECK(gl.GetMinmaxParameterivEXT);
	gl.GetMultiTexEnvfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexEnvfvEXT", lib);
	GL_CHECK(gl.GetMultiTexEnvfvEXT);
	gl.GetMultiTexEnvivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMultiTexEnvivEXT", lib);
	GL_CHECK(gl.GetMultiTexEnvivEXT);
	gl.GetMultiTexGendvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params)) ldg_find("glGetMultiTexGendvEXT", lib);
	GL_CHECK(gl.GetMultiTexGendvEXT);
	gl.GetMultiTexGenfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexGenfvEXT", lib);
	GL_CHECK(gl.GetMultiTexGenfvEXT);
	gl.GetMultiTexGenivEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLint *params)) ldg_find("glGetMultiTexGenivEXT", lib);
	GL_CHECK(gl.GetMultiTexGenivEXT);
	gl.GetMultiTexImageEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void *pixels)) ldg_find("glGetMultiTexImageEXT", lib);
	GL_CHECK(gl.GetMultiTexImageEXT);
	gl.GetMultiTexLevelParameterfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexLevelParameterfvEXT", lib);
	GL_CHECK(gl.GetMultiTexLevelParameterfvEXT);
	gl.GetMultiTexLevelParameterivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params)) ldg_find("glGetMultiTexLevelParameterivEXT", lib);
	GL_CHECK(gl.GetMultiTexLevelParameterivEXT);
	gl.GetMultiTexParameterIivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMultiTexParameterIivEXT", lib);
	GL_CHECK(gl.GetMultiTexParameterIivEXT);
	gl.GetMultiTexParameterIuivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetMultiTexParameterIuivEXT", lib);
	GL_CHECK(gl.GetMultiTexParameterIuivEXT);
	gl.GetMultiTexParameterfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetMultiTexParameterfvEXT", lib);
	GL_CHECK(gl.GetMultiTexParameterfvEXT);
	gl.GetMultiTexParameterivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetMultiTexParameterivEXT", lib);
	GL_CHECK(gl.GetMultiTexParameterivEXT);
	gl.GetMultisamplefv = (void APIENTRY (*)(GLenum pname, GLuint index, GLfloat *val)) ldg_find("glGetMultisamplefv", lib);
	GL_CHECK(gl.GetMultisamplefv);
	gl.GetMultisamplefvNV = (void APIENTRY (*)(GLenum pname, GLuint index, GLfloat *val)) ldg_find("glGetMultisamplefvNV", lib);
	GL_CHECK(gl.GetMultisamplefvNV);
	gl.GetNamedBufferParameterivEXT = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLint *params)) ldg_find("glGetNamedBufferParameterivEXT", lib);
	GL_CHECK(gl.GetNamedBufferParameterivEXT);
	gl.GetNamedBufferParameterui64vNV = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLuint64EXT *params)) ldg_find("glGetNamedBufferParameterui64vNV", lib);
	GL_CHECK(gl.GetNamedBufferParameterui64vNV);
	gl.GetNamedBufferPointervEXT = (void APIENTRY (*)(GLuint buffer, GLenum pname, void * *params)) ldg_find("glGetNamedBufferPointervEXT", lib);
	GL_CHECK(gl.GetNamedBufferPointervEXT);
	gl.GetNamedBufferSubDataEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data)) ldg_find("glGetNamedBufferSubDataEXT", lib);
	GL_CHECK(gl.GetNamedBufferSubDataEXT);
	gl.GetNamedFramebufferAttachmentParameterivEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params)) ldg_find("glGetNamedFramebufferAttachmentParameterivEXT", lib);
	GL_CHECK(gl.GetNamedFramebufferAttachmentParameterivEXT);
	gl.GetNamedFramebufferParameterivEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint *params)) ldg_find("glGetNamedFramebufferParameterivEXT", lib);
	GL_CHECK(gl.GetNamedFramebufferParameterivEXT);
	gl.GetNamedProgramLocalParameterIivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLint *params)) ldg_find("glGetNamedProgramLocalParameterIivEXT", lib);
	GL_CHECK(gl.GetNamedProgramLocalParameterIivEXT);
	gl.GetNamedProgramLocalParameterIuivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLuint *params)) ldg_find("glGetNamedProgramLocalParameterIuivEXT", lib);
	GL_CHECK(gl.GetNamedProgramLocalParameterIuivEXT);
	gl.GetNamedProgramLocalParameterdvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLdouble *params)) ldg_find("glGetNamedProgramLocalParameterdvEXT", lib);
	GL_CHECK(gl.GetNamedProgramLocalParameterdvEXT);
	gl.GetNamedProgramLocalParameterfvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLfloat *params)) ldg_find("glGetNamedProgramLocalParameterfvEXT", lib);
	GL_CHECK(gl.GetNamedProgramLocalParameterfvEXT);
	gl.GetNamedProgramStringEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLenum pname, void *string)) ldg_find("glGetNamedProgramStringEXT", lib);
	GL_CHECK(gl.GetNamedProgramStringEXT);
	gl.GetNamedProgramivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetNamedProgramivEXT", lib);
	GL_CHECK(gl.GetNamedProgramivEXT);
	gl.GetNamedRenderbufferParameterivEXT = (void APIENTRY (*)(GLuint renderbuffer, GLenum pname, GLint *params)) ldg_find("glGetNamedRenderbufferParameterivEXT", lib);
	GL_CHECK(gl.GetNamedRenderbufferParameterivEXT);
	gl.GetNamedStringARB = (void APIENTRY (*)(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string)) ldg_find("glGetNamedStringARB", lib);
	GL_CHECK(gl.GetNamedStringARB);
	gl.GetNamedStringivARB = (void APIENTRY (*)(GLint namelen, const GLchar *name, GLenum pname, GLint *params)) ldg_find("glGetNamedStringivARB", lib);
	GL_CHECK(gl.GetNamedStringivARB);
	gl.GetNextPerfQueryIdINTEL = (void APIENTRY (*)(GLuint queryId, GLuint *nextQueryId)) ldg_find("glGetNextPerfQueryIdINTEL", lib);
	GL_CHECK(gl.GetNextPerfQueryIdINTEL);
	gl.GetObjectBufferfvATI = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLfloat *params)) ldg_find("glGetObjectBufferfvATI", lib);
	GL_CHECK(gl.GetObjectBufferfvATI);
	gl.GetObjectBufferivATI = (void APIENTRY (*)(GLuint buffer, GLenum pname, GLint *params)) ldg_find("glGetObjectBufferivATI", lib);
	GL_CHECK(gl.GetObjectBufferivATI);
	gl.GetObjectLabel = (void APIENTRY (*)(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)) ldg_find("glGetObjectLabel", lib);
	GL_CHECK(gl.GetObjectLabel);
	gl.GetObjectLabelEXT = (void APIENTRY (*)(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label)) ldg_find("glGetObjectLabelEXT", lib);
	GL_CHECK(gl.GetObjectLabelEXT);
	gl.GetObjectParameterfvARB = (void APIENTRY (*)(GLhandleARB obj, GLenum pname, GLfloat *params)) ldg_find("glGetObjectParameterfvARB", lib);
	GL_CHECK(gl.GetObjectParameterfvARB);
	gl.GetObjectParameterivAPPLE = (void APIENTRY (*)(GLenum objectType, GLuint name, GLenum pname, GLint *params)) ldg_find("glGetObjectParameterivAPPLE", lib);
	GL_CHECK(gl.GetObjectParameterivAPPLE);
	gl.GetObjectParameterivARB = (void APIENTRY (*)(GLhandleARB obj, GLenum pname, GLint *params)) ldg_find("glGetObjectParameterivARB", lib);
	GL_CHECK(gl.GetObjectParameterivARB);
	gl.GetObjectPtrLabel = (void APIENTRY (*)(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label)) ldg_find("glGetObjectPtrLabel", lib);
	GL_CHECK(gl.GetObjectPtrLabel);
	gl.GetOcclusionQueryivNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetOcclusionQueryivNV", lib);
	GL_CHECK(gl.GetOcclusionQueryivNV);
	gl.GetOcclusionQueryuivNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint *params)) ldg_find("glGetOcclusionQueryuivNV", lib);
	GL_CHECK(gl.GetOcclusionQueryuivNV);
	gl.GetPathColorGenfvNV = (void APIENTRY (*)(GLenum color, GLenum pname, GLfloat *value)) ldg_find("glGetPathColorGenfvNV", lib);
	GL_CHECK(gl.GetPathColorGenfvNV);
	gl.GetPathColorGenivNV = (void APIENTRY (*)(GLenum color, GLenum pname, GLint *value)) ldg_find("glGetPathColorGenivNV", lib);
	GL_CHECK(gl.GetPathColorGenivNV);
	gl.GetPathCommandsNV = (void APIENTRY (*)(GLuint path, GLubyte *commands)) ldg_find("glGetPathCommandsNV", lib);
	GL_CHECK(gl.GetPathCommandsNV);
	gl.GetPathCoordsNV = (void APIENTRY (*)(GLuint path, GLfloat *coords)) ldg_find("glGetPathCoordsNV", lib);
	GL_CHECK(gl.GetPathCoordsNV);
	gl.GetPathDashArrayNV = (void APIENTRY (*)(GLuint path, GLfloat *dashArray)) ldg_find("glGetPathDashArrayNV", lib);
	GL_CHECK(gl.GetPathDashArrayNV);
	gl.GetPathLengthNV = (GLfloat APIENTRY (*)(GLuint path, GLsizei startSegment, GLsizei numSegments)) ldg_find("glGetPathLengthNV", lib);
	GL_CHECK(gl.GetPathLengthNV);
	gl.GetPathMetricRangeNV = (void APIENTRY (*)(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics)) ldg_find("glGetPathMetricRangeNV", lib);
	GL_CHECK(gl.GetPathMetricRangeNV);
	gl.GetPathMetricsNV = (void APIENTRY (*)(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics)) ldg_find("glGetPathMetricsNV", lib);
	GL_CHECK(gl.GetPathMetricsNV);
	gl.GetPathParameterfvNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLfloat *value)) ldg_find("glGetPathParameterfvNV", lib);
	GL_CHECK(gl.GetPathParameterfvNV);
	gl.GetPathParameterivNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLint *value)) ldg_find("glGetPathParameterivNV", lib);
	GL_CHECK(gl.GetPathParameterivNV);
	gl.GetPathSpacingNV = (void APIENTRY (*)(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing)) ldg_find("glGetPathSpacingNV", lib);
	GL_CHECK(gl.GetPathSpacingNV);
	gl.GetPathTexGenfvNV = (void APIENTRY (*)(GLenum texCoordSet, GLenum pname, GLfloat *value)) ldg_find("glGetPathTexGenfvNV", lib);
	GL_CHECK(gl.GetPathTexGenfvNV);
	gl.GetPathTexGenivNV = (void APIENTRY (*)(GLenum texCoordSet, GLenum pname, GLint *value)) ldg_find("glGetPathTexGenivNV", lib);
	GL_CHECK(gl.GetPathTexGenivNV);
	gl.GetPerfCounterInfoINTEL = (void APIENTRY (*)(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue)) ldg_find("glGetPerfCounterInfoINTEL", lib);
	GL_CHECK(gl.GetPerfCounterInfoINTEL);
	gl.GetPerfMonitorCounterDataAMD = (void APIENTRY (*)(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten)) ldg_find("glGetPerfMonitorCounterDataAMD", lib);
	GL_CHECK(gl.GetPerfMonitorCounterDataAMD);
	gl.GetPerfMonitorCounterInfoAMD = (void APIENTRY (*)(GLuint group, GLuint counter, GLenum pname, void *data)) ldg_find("glGetPerfMonitorCounterInfoAMD", lib);
	GL_CHECK(gl.GetPerfMonitorCounterInfoAMD);
	gl.GetPerfMonitorCounterStringAMD = (void APIENTRY (*)(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString)) ldg_find("glGetPerfMonitorCounterStringAMD", lib);
	GL_CHECK(gl.GetPerfMonitorCounterStringAMD);
	gl.GetPerfMonitorCountersAMD = (void APIENTRY (*)(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters)) ldg_find("glGetPerfMonitorCountersAMD", lib);
	GL_CHECK(gl.GetPerfMonitorCountersAMD);
	gl.GetPerfMonitorGroupStringAMD = (void APIENTRY (*)(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString)) ldg_find("glGetPerfMonitorGroupStringAMD", lib);
	GL_CHECK(gl.GetPerfMonitorGroupStringAMD);
	gl.GetPerfMonitorGroupsAMD = (void APIENTRY (*)(GLint *numGroups, GLsizei groupsSize, GLuint *groups)) ldg_find("glGetPerfMonitorGroupsAMD", lib);
	GL_CHECK(gl.GetPerfMonitorGroupsAMD);
	gl.GetPerfQueryDataINTEL = (void APIENTRY (*)(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid *data, GLuint *bytesWritten)) ldg_find("glGetPerfQueryDataINTEL", lib);
	GL_CHECK(gl.GetPerfQueryDataINTEL);
	gl.GetPerfQueryIdByNameINTEL = (void APIENTRY (*)(GLchar *queryName, GLuint *queryId)) ldg_find("glGetPerfQueryIdByNameINTEL", lib);
	GL_CHECK(gl.GetPerfQueryIdByNameINTEL);
	gl.GetPerfQueryInfoINTEL = (void APIENTRY (*)(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask)) ldg_find("glGetPerfQueryInfoINTEL", lib);
	GL_CHECK(gl.GetPerfQueryInfoINTEL);
	gl.GetPixelMapfv = (void APIENTRY (*)(GLenum map, GLfloat *values)) ldg_find("glGetPixelMapfv", lib);
	GL_CHECK(gl.GetPixelMapfv);
	gl.GetPixelMapuiv = (void APIENTRY (*)(GLenum map, GLuint *values)) ldg_find("glGetPixelMapuiv", lib);
	GL_CHECK(gl.GetPixelMapuiv);
	gl.GetPixelMapusv = (void APIENTRY (*)(GLenum map, GLushort *values)) ldg_find("glGetPixelMapusv", lib);
	GL_CHECK(gl.GetPixelMapusv);
	gl.GetPixelMapxv = (void APIENTRY (*)(GLenum map, GLint size, GLfixed *values)) ldg_find("glGetPixelMapxv", lib);
	GL_CHECK(gl.GetPixelMapxv);
	gl.GetPixelTexGenParameterfvSGIS = (void APIENTRY (*)(GLenum pname, GLfloat *params)) ldg_find("glGetPixelTexGenParameterfvSGIS", lib);
	GL_CHECK(gl.GetPixelTexGenParameterfvSGIS);
	gl.GetPixelTexGenParameterivSGIS = (void APIENTRY (*)(GLenum pname, GLint *params)) ldg_find("glGetPixelTexGenParameterivSGIS", lib);
	GL_CHECK(gl.GetPixelTexGenParameterivSGIS);
	gl.GetPixelTransformParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetPixelTransformParameterfvEXT", lib);
	GL_CHECK(gl.GetPixelTransformParameterfvEXT);
	gl.GetPixelTransformParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetPixelTransformParameterivEXT", lib);
	GL_CHECK(gl.GetPixelTransformParameterivEXT);
	gl.GetPointerIndexedvEXT = (void APIENTRY (*)(GLenum target, GLuint index, void * *data)) ldg_find("glGetPointerIndexedvEXT", lib);
	GL_CHECK(gl.GetPointerIndexedvEXT);
	gl.GetPointeri_vEXT = (void APIENTRY (*)(GLenum pname, GLuint index, void * *params)) ldg_find("glGetPointeri_vEXT", lib);
	GL_CHECK(gl.GetPointeri_vEXT);
	gl.GetPointerv = (void APIENTRY (*)(GLenum pname, GLvoid* *params)) ldg_find("glGetPointerv", lib);
	GL_CHECK(gl.GetPointerv);
	gl.GetPointervEXT = (void APIENTRY (*)(GLenum pname, void * *params)) ldg_find("glGetPointervEXT", lib);
	GL_CHECK(gl.GetPointervEXT);
	gl.GetPolygonStipple = (void APIENTRY (*)(GLubyte *mask)) ldg_find("glGetPolygonStipple", lib);
	GL_CHECK(gl.GetPolygonStipple);
	gl.GetProgramBinary = (void APIENTRY (*)(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary)) ldg_find("glGetProgramBinary", lib);
	GL_CHECK(gl.GetProgramBinary);
	gl.GetProgramEnvParameterIivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint *params)) ldg_find("glGetProgramEnvParameterIivNV", lib);
	GL_CHECK(gl.GetProgramEnvParameterIivNV);
	gl.GetProgramEnvParameterIuivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint *params)) ldg_find("glGetProgramEnvParameterIuivNV", lib);
	GL_CHECK(gl.GetProgramEnvParameterIuivNV);
	gl.GetProgramEnvParameterdvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *params)) ldg_find("glGetProgramEnvParameterdvARB", lib);
	GL_CHECK(gl.GetProgramEnvParameterdvARB);
	gl.GetProgramEnvParameterfvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *params)) ldg_find("glGetProgramEnvParameterfvARB", lib);
	GL_CHECK(gl.GetProgramEnvParameterfvARB);
	gl.GetProgramInfoLog = (void APIENTRY (*)(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog)) ldg_find("glGetProgramInfoLog", lib);
	GL_CHECK(gl.GetProgramInfoLog);
	gl.GetProgramInterfaceiv = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLenum pname, GLint *params)) ldg_find("glGetProgramInterfaceiv", lib);
	GL_CHECK(gl.GetProgramInterfaceiv);
	gl.GetProgramLocalParameterIivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint *params)) ldg_find("glGetProgramLocalParameterIivNV", lib);
	GL_CHECK(gl.GetProgramLocalParameterIivNV);
	gl.GetProgramLocalParameterIuivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint *params)) ldg_find("glGetProgramLocalParameterIuivNV", lib);
	GL_CHECK(gl.GetProgramLocalParameterIuivNV);
	gl.GetProgramLocalParameterdvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble *params)) ldg_find("glGetProgramLocalParameterdvARB", lib);
	GL_CHECK(gl.GetProgramLocalParameterdvARB);
	gl.GetProgramLocalParameterfvARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat *params)) ldg_find("glGetProgramLocalParameterfvARB", lib);
	GL_CHECK(gl.GetProgramLocalParameterfvARB);
	gl.GetProgramNamedParameterdvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params)) ldg_find("glGetProgramNamedParameterdvNV", lib);
	GL_CHECK(gl.GetProgramNamedParameterdvNV);
	gl.GetProgramNamedParameterfvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params)) ldg_find("glGetProgramNamedParameterfvNV", lib);
	GL_CHECK(gl.GetProgramNamedParameterfvNV);
	gl.GetProgramParameterdvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetProgramParameterdvNV", lib);
	GL_CHECK(gl.GetProgramParameterdvNV);
	gl.GetProgramParameterfvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetProgramParameterfvNV", lib);
	GL_CHECK(gl.GetProgramParameterfvNV);
	gl.GetProgramPipelineInfoLog = (void APIENTRY (*)(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog)) ldg_find("glGetProgramPipelineInfoLog", lib);
	GL_CHECK(gl.GetProgramPipelineInfoLog);
	gl.GetProgramPipelineiv = (void APIENTRY (*)(GLuint pipeline, GLenum pname, GLint *params)) ldg_find("glGetProgramPipelineiv", lib);
	GL_CHECK(gl.GetProgramPipelineiv);
	gl.GetProgramRegisterfvMESA = (void APIENTRY (*)(GLenum target, GLsizei len, const GLubyte *name, GLfloat *v)) ldg_find("glGetProgramRegisterfvMESA", lib);
	GL_CHECK(gl.GetProgramRegisterfvMESA);
	gl.GetProgramResourceIndex = (GLuint APIENTRY (*)(GLuint program, GLenum programInterface, const GLchar *name)) ldg_find("glGetProgramResourceIndex", lib);
	GL_CHECK(gl.GetProgramResourceIndex);
	gl.GetProgramResourceLocation = (GLint APIENTRY (*)(GLuint program, GLenum programInterface, const GLchar *name)) ldg_find("glGetProgramResourceLocation", lib);
	GL_CHECK(gl.GetProgramResourceLocation);
	gl.GetProgramResourceLocationIndex = (GLint APIENTRY (*)(GLuint program, GLenum programInterface, const GLchar *name)) ldg_find("glGetProgramResourceLocationIndex", lib);
	GL_CHECK(gl.GetProgramResourceLocationIndex);
	gl.GetProgramResourceName = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name)) ldg_find("glGetProgramResourceName", lib);
	GL_CHECK(gl.GetProgramResourceName);
	gl.GetProgramResourceiv = (void APIENTRY (*)(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params)) ldg_find("glGetProgramResourceiv", lib);
	GL_CHECK(gl.GetProgramResourceiv);
	gl.GetProgramStageiv = (void APIENTRY (*)(GLuint program, GLenum shadertype, GLenum pname, GLint *values)) ldg_find("glGetProgramStageiv", lib);
	GL_CHECK(gl.GetProgramStageiv);
	gl.GetProgramStringARB = (void APIENTRY (*)(GLenum target, GLenum pname, void *string)) ldg_find("glGetProgramStringARB", lib);
	GL_CHECK(gl.GetProgramStringARB);
	gl.GetProgramStringNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLubyte *program)) ldg_find("glGetProgramStringNV", lib);
	GL_CHECK(gl.GetProgramStringNV);
	gl.GetProgramSubroutineParameteruivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint *param)) ldg_find("glGetProgramSubroutineParameteruivNV", lib);
	GL_CHECK(gl.GetProgramSubroutineParameteruivNV);
	gl.GetProgramiv = (void APIENTRY (*)(GLuint program, GLenum pname, GLint *params)) ldg_find("glGetProgramiv", lib);
	GL_CHECK(gl.GetProgramiv);
	gl.GetProgramivARB = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetProgramivARB", lib);
	GL_CHECK(gl.GetProgramivARB);
	gl.GetProgramivNV = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetProgramivNV", lib);
	GL_CHECK(gl.GetProgramivNV);
	gl.GetQueryIndexediv = (void APIENTRY (*)(GLenum target, GLuint index, GLenum pname, GLint *params)) ldg_find("glGetQueryIndexediv", lib);
	GL_CHECK(gl.GetQueryIndexediv);
	gl.GetQueryObjecti64v = (void APIENTRY (*)(GLuint id, GLenum pname, GLint64 *params)) ldg_find("glGetQueryObjecti64v", lib);
	GL_CHECK(gl.GetQueryObjecti64v);
	gl.GetQueryObjecti64vEXT = (void APIENTRY (*)(GLuint id, GLenum pname, GLint64 *params)) ldg_find("glGetQueryObjecti64vEXT", lib);
	GL_CHECK(gl.GetQueryObjecti64vEXT);
	gl.GetQueryObjectiv = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetQueryObjectiv", lib);
	GL_CHECK(gl.GetQueryObjectiv);
	gl.GetQueryObjectivARB = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetQueryObjectivARB", lib);
	GL_CHECK(gl.GetQueryObjectivARB);
	gl.GetQueryObjectui64v = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint64 *params)) ldg_find("glGetQueryObjectui64v", lib);
	GL_CHECK(gl.GetQueryObjectui64v);
	gl.GetQueryObjectui64vEXT = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint64 *params)) ldg_find("glGetQueryObjectui64vEXT", lib);
	GL_CHECK(gl.GetQueryObjectui64vEXT);
	gl.GetQueryObjectuiv = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint *params)) ldg_find("glGetQueryObjectuiv", lib);
	GL_CHECK(gl.GetQueryObjectuiv);
	gl.GetQueryObjectuivARB = (void APIENTRY (*)(GLuint id, GLenum pname, GLuint *params)) ldg_find("glGetQueryObjectuivARB", lib);
	GL_CHECK(gl.GetQueryObjectuivARB);
	gl.GetQueryiv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetQueryiv", lib);
	GL_CHECK(gl.GetQueryiv);
	gl.GetQueryivARB = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetQueryivARB", lib);
	GL_CHECK(gl.GetQueryivARB);
	gl.GetRenderbufferParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetRenderbufferParameteriv", lib);
	GL_CHECK(gl.GetRenderbufferParameteriv);
	gl.GetRenderbufferParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetRenderbufferParameterivEXT", lib);
	GL_CHECK(gl.GetRenderbufferParameterivEXT);
	gl.GetSamplerParameterIiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLint *params)) ldg_find("glGetSamplerParameterIiv", lib);
	GL_CHECK(gl.GetSamplerParameterIiv);
	gl.GetSamplerParameterIuiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLuint *params)) ldg_find("glGetSamplerParameterIuiv", lib);
	GL_CHECK(gl.GetSamplerParameterIuiv);
	gl.GetSamplerParameterfv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLfloat *params)) ldg_find("glGetSamplerParameterfv", lib);
	GL_CHECK(gl.GetSamplerParameterfv);
	gl.GetSamplerParameteriv = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLint *params)) ldg_find("glGetSamplerParameteriv", lib);
	GL_CHECK(gl.GetSamplerParameteriv);
	gl.GetSeparableFilter = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span)) ldg_find("glGetSeparableFilter", lib);
	GL_CHECK(gl.GetSeparableFilter);
	gl.GetSeparableFilterEXT = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span)) ldg_find("glGetSeparableFilterEXT", lib);
	GL_CHECK(gl.GetSeparableFilterEXT);
	gl.GetShaderInfoLog = (void APIENTRY (*)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)) ldg_find("glGetShaderInfoLog", lib);
	GL_CHECK(gl.GetShaderInfoLog);
	gl.GetShaderPrecisionFormat = (void APIENTRY (*)(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision)) ldg_find("glGetShaderPrecisionFormat", lib);
	GL_CHECK(gl.GetShaderPrecisionFormat);
	gl.GetShaderSource = (void APIENTRY (*)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)) ldg_find("glGetShaderSource", lib);
	GL_CHECK(gl.GetShaderSource);
	gl.GetShaderSourceARB = (void APIENTRY (*)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source)) ldg_find("glGetShaderSourceARB", lib);
	GL_CHECK(gl.GetShaderSourceARB);
	gl.GetShaderiv = (void APIENTRY (*)(GLuint shader, GLenum pname, GLint *params)) ldg_find("glGetShaderiv", lib);
	GL_CHECK(gl.GetShaderiv);
	gl.GetSharpenTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLfloat *points)) ldg_find("glGetSharpenTexFuncSGIS", lib);
	GL_CHECK(gl.GetSharpenTexFuncSGIS);
	gl.GetString = (const GLubyte * APIENTRY (*)(GLenum name)) ldg_find("glGetString", lib);
	GL_CHECK(gl.GetString);
	gl.GetStringi = (const GLubyte * APIENTRY (*)(GLenum name, GLuint index)) ldg_find("glGetStringi", lib);
	GL_CHECK(gl.GetStringi);
	gl.GetSubroutineIndex = (GLuint APIENTRY (*)(GLuint program, GLenum shadertype, const GLchar *name)) ldg_find("glGetSubroutineIndex", lib);
	GL_CHECK(gl.GetSubroutineIndex);
	gl.GetSubroutineUniformLocation = (GLint APIENTRY (*)(GLuint program, GLenum shadertype, const GLchar *name)) ldg_find("glGetSubroutineUniformLocation", lib);
	GL_CHECK(gl.GetSubroutineUniformLocation);
	gl.GetSynciv = (void APIENTRY (*)(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)) ldg_find("glGetSynciv", lib);
	GL_CHECK(gl.GetSynciv);
	gl.GetTexBumpParameterfvATI = (void APIENTRY (*)(GLenum pname, GLfloat *param)) ldg_find("glGetTexBumpParameterfvATI", lib);
	GL_CHECK(gl.GetTexBumpParameterfvATI);
	gl.GetTexBumpParameterivATI = (void APIENTRY (*)(GLenum pname, GLint *param)) ldg_find("glGetTexBumpParameterivATI", lib);
	GL_CHECK(gl.GetTexBumpParameterivATI);
	gl.GetTexEnvfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetTexEnvfv", lib);
	GL_CHECK(gl.GetTexEnvfv);
	gl.GetTexEnviv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexEnviv", lib);
	GL_CHECK(gl.GetTexEnviv);
	gl.GetTexEnvxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetTexEnvxvOES", lib);
	GL_CHECK(gl.GetTexEnvxvOES);
	gl.GetTexFilterFuncSGIS = (void APIENTRY (*)(GLenum target, GLenum filter, GLfloat *weights)) ldg_find("glGetTexFilterFuncSGIS", lib);
	GL_CHECK(gl.GetTexFilterFuncSGIS);
	gl.GetTexGendv = (void APIENTRY (*)(GLenum coord, GLenum pname, GLdouble *params)) ldg_find("glGetTexGendv", lib);
	GL_CHECK(gl.GetTexGendv);
	gl.GetTexGenfv = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfloat *params)) ldg_find("glGetTexGenfv", lib);
	GL_CHECK(gl.GetTexGenfv);
	gl.GetTexGeniv = (void APIENTRY (*)(GLenum coord, GLenum pname, GLint *params)) ldg_find("glGetTexGeniv", lib);
	GL_CHECK(gl.GetTexGeniv);
	gl.GetTexGenxvOES = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfixed *params)) ldg_find("glGetTexGenxvOES", lib);
	GL_CHECK(gl.GetTexGenxvOES);
	gl.GetTexImage = (void APIENTRY (*)(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)) ldg_find("glGetTexImage", lib);
	GL_CHECK(gl.GetTexImage);
	gl.GetTexLevelParameterfv = (void APIENTRY (*)(GLenum target, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetTexLevelParameterfv", lib);
	GL_CHECK(gl.GetTexLevelParameterfv);
	gl.GetTexLevelParameteriv = (void APIENTRY (*)(GLenum target, GLint level, GLenum pname, GLint *params)) ldg_find("glGetTexLevelParameteriv", lib);
	GL_CHECK(gl.GetTexLevelParameteriv);
	gl.GetTexLevelParameterxvOES = (void APIENTRY (*)(GLenum target, GLint level, GLenum pname, GLfixed *params)) ldg_find("glGetTexLevelParameterxvOES", lib);
	GL_CHECK(gl.GetTexLevelParameterxvOES);
	gl.GetTexParameterIiv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexParameterIiv", lib);
	GL_CHECK(gl.GetTexParameterIiv);
	gl.GetTexParameterIivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexParameterIivEXT", lib);
	GL_CHECK(gl.GetTexParameterIivEXT);
	gl.GetTexParameterIuiv = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetTexParameterIuiv", lib);
	GL_CHECK(gl.GetTexParameterIuiv);
	gl.GetTexParameterIuivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetTexParameterIuivEXT", lib);
	GL_CHECK(gl.GetTexParameterIuivEXT);
	gl.GetTexParameterPointervAPPLE = (void APIENTRY (*)(GLenum target, GLenum pname, void * *params)) ldg_find("glGetTexParameterPointervAPPLE", lib);
	GL_CHECK(gl.GetTexParameterPointervAPPLE);
	gl.GetTexParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetTexParameterfv", lib);
	GL_CHECK(gl.GetTexParameterfv);
	gl.GetTexParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTexParameteriv", lib);
	GL_CHECK(gl.GetTexParameteriv);
	gl.GetTexParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed *params)) ldg_find("glGetTexParameterxvOES", lib);
	GL_CHECK(gl.GetTexParameterxvOES);
	gl.GetTextureHandleARB = (GLuint64 APIENTRY (*)(GLuint texture)) ldg_find("glGetTextureHandleARB", lib);
	GL_CHECK(gl.GetTextureHandleARB);
	gl.GetTextureHandleNV = (GLuint64 APIENTRY (*)(GLuint texture)) ldg_find("glGetTextureHandleNV", lib);
	GL_CHECK(gl.GetTextureHandleNV);
	gl.GetTextureImageEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void *pixels)) ldg_find("glGetTextureImageEXT", lib);
	GL_CHECK(gl.GetTextureImageEXT);
	gl.GetTextureLevelParameterfvEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params)) ldg_find("glGetTextureLevelParameterfvEXT", lib);
	GL_CHECK(gl.GetTextureLevelParameterfvEXT);
	gl.GetTextureLevelParameterivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params)) ldg_find("glGetTextureLevelParameterivEXT", lib);
	GL_CHECK(gl.GetTextureLevelParameterivEXT);
	gl.GetTextureParameterIivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTextureParameterIivEXT", lib);
	GL_CHECK(gl.GetTextureParameterIivEXT);
	gl.GetTextureParameterIuivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLuint *params)) ldg_find("glGetTextureParameterIuivEXT", lib);
	GL_CHECK(gl.GetTextureParameterIuivEXT);
	gl.GetTextureParameterfvEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLfloat *params)) ldg_find("glGetTextureParameterfvEXT", lib);
	GL_CHECK(gl.GetTextureParameterfvEXT);
	gl.GetTextureParameterivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLint *params)) ldg_find("glGetTextureParameterivEXT", lib);
	GL_CHECK(gl.GetTextureParameterivEXT);
	gl.GetTextureSamplerHandleARB = (GLuint64 APIENTRY (*)(GLuint texture, GLuint sampler)) ldg_find("glGetTextureSamplerHandleARB", lib);
	GL_CHECK(gl.GetTextureSamplerHandleARB);
	gl.GetTextureSamplerHandleNV = (GLuint64 APIENTRY (*)(GLuint texture, GLuint sampler)) ldg_find("glGetTextureSamplerHandleNV", lib);
	GL_CHECK(gl.GetTextureSamplerHandleNV);
	gl.GetTrackMatrixivNV = (void APIENTRY (*)(GLenum target, GLuint address, GLenum pname, GLint *params)) ldg_find("glGetTrackMatrixivNV", lib);
	GL_CHECK(gl.GetTrackMatrixivNV);
	gl.GetTransformFeedbackVarying = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)) ldg_find("glGetTransformFeedbackVarying", lib);
	GL_CHECK(gl.GetTransformFeedbackVarying);
	gl.GetTransformFeedbackVaryingEXT = (void APIENTRY (*)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)) ldg_find("glGetTransformFeedbackVaryingEXT", lib);
	GL_CHECK(gl.GetTransformFeedbackVaryingEXT);
	gl.GetTransformFeedbackVaryingNV = (void APIENTRY (*)(GLuint program, GLuint index, GLint *location)) ldg_find("glGetTransformFeedbackVaryingNV", lib);
	GL_CHECK(gl.GetTransformFeedbackVaryingNV);
	gl.GetUniformBlockIndex = (GLuint APIENTRY (*)(GLuint program, const GLchar *uniformBlockName)) ldg_find("glGetUniformBlockIndex", lib);
	GL_CHECK(gl.GetUniformBlockIndex);
	gl.GetUniformBufferSizeEXT = (GLint APIENTRY (*)(GLuint program, GLint location)) ldg_find("glGetUniformBufferSizeEXT", lib);
	GL_CHECK(gl.GetUniformBufferSizeEXT);
	gl.GetUniformIndices = (void APIENTRY (*)(GLuint program, GLsizei uniformCount, const GLchar *const *uniformNames, GLuint *uniformIndices)) ldg_find("glGetUniformIndices", lib);
	GL_CHECK(gl.GetUniformIndices);
	gl.GetUniformLocation = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetUniformLocation", lib);
	GL_CHECK(gl.GetUniformLocation);
	gl.GetUniformLocationARB = (GLint APIENTRY (*)(GLhandleARB programObj, const GLcharARB *name)) ldg_find("glGetUniformLocationARB", lib);
	GL_CHECK(gl.GetUniformLocationARB);
	gl.GetUniformOffsetEXT = (GLintptr APIENTRY (*)(GLuint program, GLint location)) ldg_find("glGetUniformOffsetEXT", lib);
	GL_CHECK(gl.GetUniformOffsetEXT);
	gl.GetUniformSubroutineuiv = (void APIENTRY (*)(GLenum shadertype, GLint location, GLuint *params)) ldg_find("glGetUniformSubroutineuiv", lib);
	GL_CHECK(gl.GetUniformSubroutineuiv);
	gl.GetUniformdv = (void APIENTRY (*)(GLuint program, GLint location, GLdouble *params)) ldg_find("glGetUniformdv", lib);
	GL_CHECK(gl.GetUniformdv);
	gl.GetUniformfv = (void APIENTRY (*)(GLuint program, GLint location, GLfloat *params)) ldg_find("glGetUniformfv", lib);
	GL_CHECK(gl.GetUniformfv);
	gl.GetUniformfvARB = (void APIENTRY (*)(GLhandleARB programObj, GLint location, GLfloat *params)) ldg_find("glGetUniformfvARB", lib);
	GL_CHECK(gl.GetUniformfvARB);
	gl.GetUniformi64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT *params)) ldg_find("glGetUniformi64vNV", lib);
	GL_CHECK(gl.GetUniformi64vNV);
	gl.GetUniformiv = (void APIENTRY (*)(GLuint program, GLint location, GLint *params)) ldg_find("glGetUniformiv", lib);
	GL_CHECK(gl.GetUniformiv);
	gl.GetUniformivARB = (void APIENTRY (*)(GLhandleARB programObj, GLint location, GLint *params)) ldg_find("glGetUniformivARB", lib);
	GL_CHECK(gl.GetUniformivARB);
	gl.GetUniformui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT *params)) ldg_find("glGetUniformui64vNV", lib);
	GL_CHECK(gl.GetUniformui64vNV);
	gl.GetUniformuiv = (void APIENTRY (*)(GLuint program, GLint location, GLuint *params)) ldg_find("glGetUniformuiv", lib);
	GL_CHECK(gl.GetUniformuiv);
	gl.GetUniformuivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint *params)) ldg_find("glGetUniformuivEXT", lib);
	GL_CHECK(gl.GetUniformuivEXT);
	gl.GetVariantArrayObjectfvATI = (void APIENTRY (*)(GLuint id, GLenum pname, GLfloat *params)) ldg_find("glGetVariantArrayObjectfvATI", lib);
	GL_CHECK(gl.GetVariantArrayObjectfvATI);
	gl.GetVariantArrayObjectivATI = (void APIENTRY (*)(GLuint id, GLenum pname, GLint *params)) ldg_find("glGetVariantArrayObjectivATI", lib);
	GL_CHECK(gl.GetVariantArrayObjectivATI);
	gl.GetVariantBooleanvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLboolean *data)) ldg_find("glGetVariantBooleanvEXT", lib);
	GL_CHECK(gl.GetVariantBooleanvEXT);
	gl.GetVariantFloatvEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLfloat *data)) ldg_find("glGetVariantFloatvEXT", lib);
	GL_CHECK(gl.GetVariantFloatvEXT);
	gl.GetVariantIntegervEXT = (void APIENTRY (*)(GLuint id, GLenum value, GLint *data)) ldg_find("glGetVariantIntegervEXT", lib);
	GL_CHECK(gl.GetVariantIntegervEXT);
	gl.GetVariantPointervEXT = (void APIENTRY (*)(GLuint id, GLenum value, void * *data)) ldg_find("glGetVariantPointervEXT", lib);
	GL_CHECK(gl.GetVariantPointervEXT);
	gl.GetVaryingLocationNV = (GLint APIENTRY (*)(GLuint program, const GLchar *name)) ldg_find("glGetVaryingLocationNV", lib);
	GL_CHECK(gl.GetVaryingLocationNV);
	gl.GetVertexArrayIntegeri_vEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLenum pname, GLint *param)) ldg_find("glGetVertexArrayIntegeri_vEXT", lib);
	GL_CHECK(gl.GetVertexArrayIntegeri_vEXT);
	gl.GetVertexArrayIntegervEXT = (void APIENTRY (*)(GLuint vaobj, GLenum pname, GLint *param)) ldg_find("glGetVertexArrayIntegervEXT", lib);
	GL_CHECK(gl.GetVertexArrayIntegervEXT);
	gl.GetVertexArrayPointeri_vEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLenum pname, void * *param)) ldg_find("glGetVertexArrayPointeri_vEXT", lib);
	GL_CHECK(gl.GetVertexArrayPointeri_vEXT);
	gl.GetVertexArrayPointervEXT = (void APIENTRY (*)(GLuint vaobj, GLenum pname, void * *param)) ldg_find("glGetVertexArrayPointervEXT", lib);
	GL_CHECK(gl.GetVertexArrayPointervEXT);
	gl.GetVertexAttribArrayObjectfvATI = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribArrayObjectfvATI", lib);
	GL_CHECK(gl.GetVertexAttribArrayObjectfvATI);
	gl.GetVertexAttribArrayObjectivATI = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribArrayObjectivATI", lib);
	GL_CHECK(gl.GetVertexAttribArrayObjectivATI);
	gl.GetVertexAttribIiv = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribIiv", lib);
	GL_CHECK(gl.GetVertexAttribIiv);
	gl.GetVertexAttribIivEXT = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribIivEXT", lib);
	GL_CHECK(gl.GetVertexAttribIivEXT);
	gl.GetVertexAttribIuiv = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint *params)) ldg_find("glGetVertexAttribIuiv", lib);
	GL_CHECK(gl.GetVertexAttribIuiv);
	gl.GetVertexAttribIuivEXT = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint *params)) ldg_find("glGetVertexAttribIuivEXT", lib);
	GL_CHECK(gl.GetVertexAttribIuivEXT);
	gl.GetVertexAttribLdv = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribLdv", lib);
	GL_CHECK(gl.GetVertexAttribLdv);
	gl.GetVertexAttribLdvEXT = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribLdvEXT", lib);
	GL_CHECK(gl.GetVertexAttribLdvEXT);
	gl.GetVertexAttribLi64vNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLint64EXT *params)) ldg_find("glGetVertexAttribLi64vNV", lib);
	GL_CHECK(gl.GetVertexAttribLi64vNV);
	gl.GetVertexAttribLui64vARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint64EXT *params)) ldg_find("glGetVertexAttribLui64vARB", lib);
	GL_CHECK(gl.GetVertexAttribLui64vARB);
	gl.GetVertexAttribLui64vNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLuint64EXT *params)) ldg_find("glGetVertexAttribLui64vNV", lib);
	GL_CHECK(gl.GetVertexAttribLui64vNV);
	gl.GetVertexAttribPointerv = (void APIENTRY (*)(GLuint index, GLenum pname, void * *pointer)) ldg_find("glGetVertexAttribPointerv", lib);
	GL_CHECK(gl.GetVertexAttribPointerv);
	gl.GetVertexAttribPointervARB = (void APIENTRY (*)(GLuint index, GLenum pname, void * *pointer)) ldg_find("glGetVertexAttribPointervARB", lib);
	GL_CHECK(gl.GetVertexAttribPointervARB);
	gl.GetVertexAttribPointervNV = (void APIENTRY (*)(GLuint index, GLenum pname, void * *pointer)) ldg_find("glGetVertexAttribPointervNV", lib);
	GL_CHECK(gl.GetVertexAttribPointervNV);
	gl.GetVertexAttribdv = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribdv", lib);
	GL_CHECK(gl.GetVertexAttribdv);
	gl.GetVertexAttribdvARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribdvARB", lib);
	GL_CHECK(gl.GetVertexAttribdvARB);
	gl.GetVertexAttribdvNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLdouble *params)) ldg_find("glGetVertexAttribdvNV", lib);
	GL_CHECK(gl.GetVertexAttribdvNV);
	gl.GetVertexAttribfv = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribfv", lib);
	GL_CHECK(gl.GetVertexAttribfv);
	gl.GetVertexAttribfvARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribfvARB", lib);
	GL_CHECK(gl.GetVertexAttribfvARB);
	gl.GetVertexAttribfvNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLfloat *params)) ldg_find("glGetVertexAttribfvNV", lib);
	GL_CHECK(gl.GetVertexAttribfvNV);
	gl.GetVertexAttribiv = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribiv", lib);
	GL_CHECK(gl.GetVertexAttribiv);
	gl.GetVertexAttribivARB = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribivARB", lib);
	GL_CHECK(gl.GetVertexAttribivARB);
	gl.GetVertexAttribivNV = (void APIENTRY (*)(GLuint index, GLenum pname, GLint *params)) ldg_find("glGetVertexAttribivNV", lib);
	GL_CHECK(gl.GetVertexAttribivNV);
	gl.GetVideoCaptureStreamdvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params)) ldg_find("glGetVideoCaptureStreamdvNV", lib);
	GL_CHECK(gl.GetVideoCaptureStreamdvNV);
	gl.GetVideoCaptureStreamfvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params)) ldg_find("glGetVideoCaptureStreamfvNV", lib);
	GL_CHECK(gl.GetVideoCaptureStreamfvNV);
	gl.GetVideoCaptureStreamivNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params)) ldg_find("glGetVideoCaptureStreamivNV", lib);
	GL_CHECK(gl.GetVideoCaptureStreamivNV);
	gl.GetVideoCaptureivNV = (void APIENTRY (*)(GLuint video_capture_slot, GLenum pname, GLint *params)) ldg_find("glGetVideoCaptureivNV", lib);
	GL_CHECK(gl.GetVideoCaptureivNV);
	gl.GetVideoi64vNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLint64EXT *params)) ldg_find("glGetVideoi64vNV", lib);
	GL_CHECK(gl.GetVideoi64vNV);
	gl.GetVideoivNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLint *params)) ldg_find("glGetVideoivNV", lib);
	GL_CHECK(gl.GetVideoivNV);
	gl.GetVideoui64vNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLuint64EXT *params)) ldg_find("glGetVideoui64vNV", lib);
	GL_CHECK(gl.GetVideoui64vNV);
	gl.GetVideouivNV = (void APIENTRY (*)(GLuint video_slot, GLenum pname, GLuint *params)) ldg_find("glGetVideouivNV", lib);
	GL_CHECK(gl.GetVideouivNV);
	gl.GetnColorTableARB = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table)) ldg_find("glGetnColorTableARB", lib);
	GL_CHECK(gl.GetnColorTableARB);
	gl.GetnCompressedTexImageARB = (void APIENTRY (*)(GLenum target, GLint lod, GLsizei bufSize, void *img)) ldg_find("glGetnCompressedTexImageARB", lib);
	GL_CHECK(gl.GetnCompressedTexImageARB);
	gl.GetnConvolutionFilterARB = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image)) ldg_find("glGetnConvolutionFilterARB", lib);
	GL_CHECK(gl.GetnConvolutionFilterARB);
	gl.GetnHistogramARB = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)) ldg_find("glGetnHistogramARB", lib);
	GL_CHECK(gl.GetnHistogramARB);
	gl.GetnMapdvARB = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v)) ldg_find("glGetnMapdvARB", lib);
	GL_CHECK(gl.GetnMapdvARB);
	gl.GetnMapfvARB = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v)) ldg_find("glGetnMapfvARB", lib);
	GL_CHECK(gl.GetnMapfvARB);
	gl.GetnMapivARB = (void APIENTRY (*)(GLenum target, GLenum query, GLsizei bufSize, GLint *v)) ldg_find("glGetnMapivARB", lib);
	GL_CHECK(gl.GetnMapivARB);
	gl.GetnMinmaxARB = (void APIENTRY (*)(GLenum target, GLboolean32 reset, GLenum format, GLenum type, GLsizei bufSize, void *values)) ldg_find("glGetnMinmaxARB", lib);
	GL_CHECK(gl.GetnMinmaxARB);
	gl.GetnPixelMapfvARB = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLfloat *values)) ldg_find("glGetnPixelMapfvARB", lib);
	GL_CHECK(gl.GetnPixelMapfvARB);
	gl.GetnPixelMapuivARB = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLuint *values)) ldg_find("glGetnPixelMapuivARB", lib);
	GL_CHECK(gl.GetnPixelMapuivARB);
	gl.GetnPixelMapusvARB = (void APIENTRY (*)(GLenum map, GLsizei bufSize, GLushort *values)) ldg_find("glGetnPixelMapusvARB", lib);
	GL_CHECK(gl.GetnPixelMapusvARB);
	gl.GetnPolygonStippleARB = (void APIENTRY (*)(GLsizei bufSize, GLubyte *pattern)) ldg_find("glGetnPolygonStippleARB", lib);
	GL_CHECK(gl.GetnPolygonStippleARB);
	gl.GetnSeparableFilterARB = (void APIENTRY (*)(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span)) ldg_find("glGetnSeparableFilterARB", lib);
	GL_CHECK(gl.GetnSeparableFilterARB);
	gl.GetnTexImageARB = (void APIENTRY (*)(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *img)) ldg_find("glGetnTexImageARB", lib);
	GL_CHECK(gl.GetnTexImageARB);
	gl.GetnUniformdvARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLdouble *params)) ldg_find("glGetnUniformdvARB", lib);
	GL_CHECK(gl.GetnUniformdvARB);
	gl.GetnUniformfvARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)) ldg_find("glGetnUniformfvARB", lib);
	GL_CHECK(gl.GetnUniformfvARB);
	gl.GetnUniformivARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLint *params)) ldg_find("glGetnUniformivARB", lib);
	GL_CHECK(gl.GetnUniformivARB);
	gl.GetnUniformuivARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei bufSize, GLuint *params)) ldg_find("glGetnUniformuivARB", lib);
	GL_CHECK(gl.GetnUniformuivARB);
	gl.GlobalAlphaFactorbSUN = (void APIENTRY (*)(GLbyte32 factor)) ldg_find("glGlobalAlphaFactorbSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactorbSUN);
	gl.GlobalAlphaFactordSUN = (void APIENTRY (*)(GLdouble factor)) ldg_find("glGlobalAlphaFactordSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactordSUN);
	gl.GlobalAlphaFactorfSUN = (void APIENTRY (*)(GLfloat factor)) ldg_find("glGlobalAlphaFactorfSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactorfSUN);
	gl.GlobalAlphaFactoriSUN = (void APIENTRY (*)(GLint factor)) ldg_find("glGlobalAlphaFactoriSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactoriSUN);
	gl.GlobalAlphaFactorsSUN = (void APIENTRY (*)(GLshort32 factor)) ldg_find("glGlobalAlphaFactorsSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactorsSUN);
	gl.GlobalAlphaFactorubSUN = (void APIENTRY (*)(GLubyte32 factor)) ldg_find("glGlobalAlphaFactorubSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactorubSUN);
	gl.GlobalAlphaFactoruiSUN = (void APIENTRY (*)(GLuint factor)) ldg_find("glGlobalAlphaFactoruiSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactoruiSUN);
	gl.GlobalAlphaFactorusSUN = (void APIENTRY (*)(GLushort32 factor)) ldg_find("glGlobalAlphaFactorusSUN", lib);
	GL_CHECK(gl.GlobalAlphaFactorusSUN);
	gl.Hint = (void APIENTRY (*)(GLenum target, GLenum mode)) ldg_find("glHint", lib);
	GL_CHECK(gl.Hint);
	gl.HintPGI = (void APIENTRY (*)(GLenum target, GLint mode)) ldg_find("glHintPGI", lib);
	GL_CHECK(gl.HintPGI);
	gl.Histogram = (void APIENTRY (*)(GLenum target, GLsizei width, GLenum internalformat, GLboolean32 sink)) ldg_find("glHistogram", lib);
	GL_CHECK(gl.Histogram);
	gl.HistogramEXT = (void APIENTRY (*)(GLenum target, GLsizei width, GLenum internalformat, GLboolean32 sink)) ldg_find("glHistogramEXT", lib);
	GL_CHECK(gl.HistogramEXT);
	gl.IglooInterfaceSGIX = (void APIENTRY (*)(GLenum pname, const void *params)) ldg_find("glIglooInterfaceSGIX", lib);
	GL_CHECK(gl.IglooInterfaceSGIX);
	gl.ImageTransformParameterfHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glImageTransformParameterfHP", lib);
	GL_CHECK(gl.ImageTransformParameterfHP);
	gl.ImageTransformParameterfvHP = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glImageTransformParameterfvHP", lib);
	GL_CHECK(gl.ImageTransformParameterfvHP);
	gl.ImageTransformParameteriHP = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glImageTransformParameteriHP", lib);
	GL_CHECK(gl.ImageTransformParameteriHP);
	gl.ImageTransformParameterivHP = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glImageTransformParameterivHP", lib);
	GL_CHECK(gl.ImageTransformParameterivHP);
	gl.ImportSyncEXT = (GLsync APIENTRY (*)(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags)) ldg_find("glImportSyncEXT", lib);
	GL_CHECK(gl.ImportSyncEXT);
	gl.IndexFormatNV = (void APIENTRY (*)(GLenum type, GLsizei stride)) ldg_find("glIndexFormatNV", lib);
	GL_CHECK(gl.IndexFormatNV);
	gl.IndexFuncEXT = (void APIENTRY (*)(GLenum func, GLclampf ref)) ldg_find("glIndexFuncEXT", lib);
	GL_CHECK(gl.IndexFuncEXT);
	gl.IndexMask = (void APIENTRY (*)(GLuint mask)) ldg_find("glIndexMask", lib);
	GL_CHECK(gl.IndexMask);
	gl.IndexMaterialEXT = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glIndexMaterialEXT", lib);
	GL_CHECK(gl.IndexMaterialEXT);
	gl.IndexPointer = (void APIENTRY (*)(GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glIndexPointer", lib);
	GL_CHECK(gl.IndexPointer);
	gl.IndexPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glIndexPointerEXT", lib);
	GL_CHECK(gl.IndexPointerEXT);
	gl.IndexPointerListIBM = (void APIENTRY (*)(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glIndexPointerListIBM", lib);
	GL_CHECK(gl.IndexPointerListIBM);
	gl.Indexd = (void APIENTRY (*)(GLdouble c)) ldg_find("glIndexd", lib);
	GL_CHECK(gl.Indexd);
	gl.Indexdv = (void APIENTRY (*)(const GLdouble *c)) ldg_find("glIndexdv", lib);
	GL_CHECK(gl.Indexdv);
	gl.Indexf = (void APIENTRY (*)(GLfloat c)) ldg_find("glIndexf", lib);
	GL_CHECK(gl.Indexf);
	gl.Indexfv = (void APIENTRY (*)(const GLfloat *c)) ldg_find("glIndexfv", lib);
	GL_CHECK(gl.Indexfv);
	gl.Indexi = (void APIENTRY (*)(GLint c)) ldg_find("glIndexi", lib);
	GL_CHECK(gl.Indexi);
	gl.Indexiv = (void APIENTRY (*)(const GLint *c)) ldg_find("glIndexiv", lib);
	GL_CHECK(gl.Indexiv);
	gl.Indexs = (void APIENTRY (*)(GLshort32 c)) ldg_find("glIndexs", lib);
	GL_CHECK(gl.Indexs);
	gl.Indexsv = (void APIENTRY (*)(const GLshort *c)) ldg_find("glIndexsv", lib);
	GL_CHECK(gl.Indexsv);
	gl.Indexub = (void APIENTRY (*)(GLubyte32 c)) ldg_find("glIndexub", lib);
	GL_CHECK(gl.Indexub);
	gl.Indexubv = (void APIENTRY (*)(const GLubyte *c)) ldg_find("glIndexubv", lib);
	GL_CHECK(gl.Indexubv);
	gl.IndexxOES = (void APIENTRY (*)(GLfixed component)) ldg_find("glIndexxOES", lib);
	GL_CHECK(gl.IndexxOES);
	gl.IndexxvOES = (void APIENTRY (*)(const GLfixed *component)) ldg_find("glIndexxvOES", lib);
	GL_CHECK(gl.IndexxvOES);
	gl.InitNames = (void APIENTRY (*)(void)) ldg_find("glInitNames", lib);
	GL_CHECK(gl.InitNames);
	gl.InsertComponentEXT = (void APIENTRY (*)(GLuint res, GLuint src, GLuint num)) ldg_find("glInsertComponentEXT", lib);
	GL_CHECK(gl.InsertComponentEXT);
	gl.InsertEventMarkerEXT = (void APIENTRY (*)(GLsizei length, const GLchar *marker)) ldg_find("glInsertEventMarkerEXT", lib);
	GL_CHECK(gl.InsertEventMarkerEXT);
	gl.InstrumentsBufferSGIX = (void APIENTRY (*)(GLsizei size, GLint *buffer)) ldg_find("glInstrumentsBufferSGIX", lib);
	GL_CHECK(gl.InstrumentsBufferSGIX);
	gl.InterleavedArrays = (void APIENTRY (*)(GLenum format, GLsizei stride, const GLvoid *pointer)) ldg_find("glInterleavedArrays", lib);
	GL_CHECK(gl.InterleavedArrays);
	gl.InterpolatePathsNV = (void APIENTRY (*)(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight)) ldg_find("glInterpolatePathsNV", lib);
	GL_CHECK(gl.InterpolatePathsNV);
	gl.InvalidateBufferData = (void APIENTRY (*)(GLuint buffer)) ldg_find("glInvalidateBufferData", lib);
	GL_CHECK(gl.InvalidateBufferData);
	gl.InvalidateBufferSubData = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length)) ldg_find("glInvalidateBufferSubData", lib);
	GL_CHECK(gl.InvalidateBufferSubData);
	gl.InvalidateFramebuffer = (void APIENTRY (*)(GLenum target, GLsizei numAttachments, const GLenum *attachments)) ldg_find("glInvalidateFramebuffer", lib);
	GL_CHECK(gl.InvalidateFramebuffer);
	gl.InvalidateSubFramebuffer = (void APIENTRY (*)(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glInvalidateSubFramebuffer", lib);
	GL_CHECK(gl.InvalidateSubFramebuffer);
	gl.InvalidateTexImage = (void APIENTRY (*)(GLuint texture, GLint level)) ldg_find("glInvalidateTexImage", lib);
	GL_CHECK(gl.InvalidateTexImage);
	gl.InvalidateTexSubImage = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glInvalidateTexSubImage", lib);
	GL_CHECK(gl.InvalidateTexSubImage);
	gl.IsAsyncMarkerSGIX = (GLboolean APIENTRY (*)(GLuint marker)) ldg_find("glIsAsyncMarkerSGIX", lib);
	GL_CHECK(gl.IsAsyncMarkerSGIX);
	gl.IsBuffer = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsBuffer", lib);
	GL_CHECK(gl.IsBuffer);
	gl.IsBufferARB = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsBufferARB", lib);
	GL_CHECK(gl.IsBufferARB);
	gl.IsBufferResidentNV = (GLboolean APIENTRY (*)(GLenum target)) ldg_find("glIsBufferResidentNV", lib);
	GL_CHECK(gl.IsBufferResidentNV);
	gl.IsEnabled = (GLboolean APIENTRY (*)(GLenum cap)) ldg_find("glIsEnabled", lib);
	GL_CHECK(gl.IsEnabled);
	gl.IsEnabledIndexedEXT = (GLboolean APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glIsEnabledIndexedEXT", lib);
	GL_CHECK(gl.IsEnabledIndexedEXT);
	gl.IsEnabledi = (GLboolean APIENTRY (*)(GLenum target, GLuint index)) ldg_find("glIsEnabledi", lib);
	GL_CHECK(gl.IsEnabledi);
	gl.IsFenceAPPLE = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glIsFenceAPPLE", lib);
	GL_CHECK(gl.IsFenceAPPLE);
	gl.IsFenceNV = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glIsFenceNV", lib);
	GL_CHECK(gl.IsFenceNV);
	gl.IsFramebuffer = (GLboolean APIENTRY (*)(GLuint framebuffer)) ldg_find("glIsFramebuffer", lib);
	GL_CHECK(gl.IsFramebuffer);
	gl.IsFramebufferEXT = (GLboolean APIENTRY (*)(GLuint framebuffer)) ldg_find("glIsFramebufferEXT", lib);
	GL_CHECK(gl.IsFramebufferEXT);
	gl.IsImageHandleResidentARB = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsImageHandleResidentARB", lib);
	GL_CHECK(gl.IsImageHandleResidentARB);
	gl.IsImageHandleResidentNV = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsImageHandleResidentNV", lib);
	GL_CHECK(gl.IsImageHandleResidentNV);
	gl.IsList = (GLboolean APIENTRY (*)(GLuint list)) ldg_find("glIsList", lib);
	GL_CHECK(gl.IsList);
	gl.IsNameAMD = (GLboolean APIENTRY (*)(GLenum identifier, GLuint name)) ldg_find("glIsNameAMD", lib);
	GL_CHECK(gl.IsNameAMD);
	gl.IsNamedBufferResidentNV = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsNamedBufferResidentNV", lib);
	GL_CHECK(gl.IsNamedBufferResidentNV);
	gl.IsNamedStringARB = (GLboolean APIENTRY (*)(GLint namelen, const GLchar *name)) ldg_find("glIsNamedStringARB", lib);
	GL_CHECK(gl.IsNamedStringARB);
	gl.IsObjectBufferATI = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glIsObjectBufferATI", lib);
	GL_CHECK(gl.IsObjectBufferATI);
	gl.IsOcclusionQueryNV = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsOcclusionQueryNV", lib);
	GL_CHECK(gl.IsOcclusionQueryNV);
	gl.IsPathNV = (GLboolean APIENTRY (*)(GLuint path)) ldg_find("glIsPathNV", lib);
	GL_CHECK(gl.IsPathNV);
	gl.IsPointInFillPathNV = (GLboolean APIENTRY (*)(GLuint path, GLuint mask, GLfloat x, GLfloat y)) ldg_find("glIsPointInFillPathNV", lib);
	GL_CHECK(gl.IsPointInFillPathNV);
	gl.IsPointInStrokePathNV = (GLboolean APIENTRY (*)(GLuint path, GLfloat x, GLfloat y)) ldg_find("glIsPointInStrokePathNV", lib);
	GL_CHECK(gl.IsPointInStrokePathNV);
	gl.IsProgram = (GLboolean APIENTRY (*)(GLuint program)) ldg_find("glIsProgram", lib);
	GL_CHECK(gl.IsProgram);
	gl.IsProgramARB = (GLboolean APIENTRY (*)(GLuint program)) ldg_find("glIsProgramARB", lib);
	GL_CHECK(gl.IsProgramARB);
	gl.IsProgramNV = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsProgramNV", lib);
	GL_CHECK(gl.IsProgramNV);
	gl.IsProgramPipeline = (GLboolean APIENTRY (*)(GLuint pipeline)) ldg_find("glIsProgramPipeline", lib);
	GL_CHECK(gl.IsProgramPipeline);
	gl.IsQuery = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsQuery", lib);
	GL_CHECK(gl.IsQuery);
	gl.IsQueryARB = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsQueryARB", lib);
	GL_CHECK(gl.IsQueryARB);
	gl.IsRenderbuffer = (GLboolean APIENTRY (*)(GLuint renderbuffer)) ldg_find("glIsRenderbuffer", lib);
	GL_CHECK(gl.IsRenderbuffer);
	gl.IsRenderbufferEXT = (GLboolean APIENTRY (*)(GLuint renderbuffer)) ldg_find("glIsRenderbufferEXT", lib);
	GL_CHECK(gl.IsRenderbufferEXT);
	gl.IsSampler = (GLboolean APIENTRY (*)(GLuint sampler)) ldg_find("glIsSampler", lib);
	GL_CHECK(gl.IsSampler);
	gl.IsShader = (GLboolean APIENTRY (*)(GLuint shader)) ldg_find("glIsShader", lib);
	GL_CHECK(gl.IsShader);
	gl.IsSync = (GLboolean APIENTRY (*)(GLsync sync)) ldg_find("glIsSync", lib);
	GL_CHECK(gl.IsSync);
	gl.IsTexture = (GLboolean APIENTRY (*)(GLuint texture)) ldg_find("glIsTexture", lib);
	GL_CHECK(gl.IsTexture);
	gl.IsTextureEXT = (GLboolean APIENTRY (*)(GLuint texture)) ldg_find("glIsTextureEXT", lib);
	GL_CHECK(gl.IsTextureEXT);
	gl.IsTextureHandleResidentARB = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsTextureHandleResidentARB", lib);
	GL_CHECK(gl.IsTextureHandleResidentARB);
	gl.IsTextureHandleResidentNV = (GLboolean APIENTRY (*)(GLuint64 handle)) ldg_find("glIsTextureHandleResidentNV", lib);
	GL_CHECK(gl.IsTextureHandleResidentNV);
	gl.IsTransformFeedback = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsTransformFeedback", lib);
	GL_CHECK(gl.IsTransformFeedback);
	gl.IsTransformFeedbackNV = (GLboolean APIENTRY (*)(GLuint id)) ldg_find("glIsTransformFeedbackNV", lib);
	GL_CHECK(gl.IsTransformFeedbackNV);
	gl.IsVariantEnabledEXT = (GLboolean APIENTRY (*)(GLuint id, GLenum cap)) ldg_find("glIsVariantEnabledEXT", lib);
	GL_CHECK(gl.IsVariantEnabledEXT);
	gl.IsVertexArray = (GLboolean APIENTRY (*)(GLuint array)) ldg_find("glIsVertexArray", lib);
	GL_CHECK(gl.IsVertexArray);
	gl.IsVertexArrayAPPLE = (GLboolean APIENTRY (*)(GLuint array)) ldg_find("glIsVertexArrayAPPLE", lib);
	GL_CHECK(gl.IsVertexArrayAPPLE);
	gl.IsVertexAttribEnabledAPPLE = (GLboolean APIENTRY (*)(GLuint index, GLenum pname)) ldg_find("glIsVertexAttribEnabledAPPLE", lib);
	GL_CHECK(gl.IsVertexAttribEnabledAPPLE);
	gl.LabelObjectEXT = (void APIENTRY (*)(GLenum type, GLuint object, GLsizei length, const GLchar *label)) ldg_find("glLabelObjectEXT", lib);
	GL_CHECK(gl.LabelObjectEXT);
	gl.LightEnviSGIX = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glLightEnviSGIX", lib);
	GL_CHECK(gl.LightEnviSGIX);
	gl.LightModelf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glLightModelf", lib);
	GL_CHECK(gl.LightModelf);
	gl.LightModelfv = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glLightModelfv", lib);
	GL_CHECK(gl.LightModelfv);
	gl.LightModeli = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glLightModeli", lib);
	GL_CHECK(gl.LightModeli);
	gl.LightModeliv = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glLightModeliv", lib);
	GL_CHECK(gl.LightModeliv);
	gl.LightModelxOES = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glLightModelxOES", lib);
	GL_CHECK(gl.LightModelxOES);
	gl.LightModelxvOES = (void APIENTRY (*)(GLenum pname, const GLfixed *param)) ldg_find("glLightModelxvOES", lib);
	GL_CHECK(gl.LightModelxvOES);
	gl.Lightf = (void APIENTRY (*)(GLenum light, GLenum pname, GLfloat param)) ldg_find("glLightf", lib);
	GL_CHECK(gl.Lightf);
	gl.Lightfv = (void APIENTRY (*)(GLenum light, GLenum pname, const GLfloat *params)) ldg_find("glLightfv", lib);
	GL_CHECK(gl.Lightfv);
	gl.Lighti = (void APIENTRY (*)(GLenum light, GLenum pname, GLint param)) ldg_find("glLighti", lib);
	GL_CHECK(gl.Lighti);
	gl.Lightiv = (void APIENTRY (*)(GLenum light, GLenum pname, const GLint *params)) ldg_find("glLightiv", lib);
	GL_CHECK(gl.Lightiv);
	gl.LightxOES = (void APIENTRY (*)(GLenum light, GLenum pname, GLfixed param)) ldg_find("glLightxOES", lib);
	GL_CHECK(gl.LightxOES);
	gl.LightxvOES = (void APIENTRY (*)(GLenum light, GLenum pname, const GLfixed *params)) ldg_find("glLightxvOES", lib);
	GL_CHECK(gl.LightxvOES);
	gl.LineStipple = (void APIENTRY (*)(GLint factor, GLushort32 pattern)) ldg_find("glLineStipple", lib);
	GL_CHECK(gl.LineStipple);
	gl.LineWidth = (void APIENTRY (*)(GLfloat width)) ldg_find("glLineWidth", lib);
	GL_CHECK(gl.LineWidth);
	gl.LineWidthxOES = (void APIENTRY (*)(GLfixed width)) ldg_find("glLineWidthxOES", lib);
	GL_CHECK(gl.LineWidthxOES);
	gl.LinkProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glLinkProgram", lib);
	GL_CHECK(gl.LinkProgram);
	gl.LinkProgramARB = (void APIENTRY (*)(GLhandleARB programObj)) ldg_find("glLinkProgramARB", lib);
	GL_CHECK(gl.LinkProgramARB);
	gl.ListBase = (void APIENTRY (*)(GLuint base)) ldg_find("glListBase", lib);
	GL_CHECK(gl.ListBase);
	gl.ListParameterfSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLfloat param)) ldg_find("glListParameterfSGIX", lib);
	GL_CHECK(gl.ListParameterfSGIX);
	gl.ListParameterfvSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, const GLfloat *params)) ldg_find("glListParameterfvSGIX", lib);
	GL_CHECK(gl.ListParameterfvSGIX);
	gl.ListParameteriSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, GLint param)) ldg_find("glListParameteriSGIX", lib);
	GL_CHECK(gl.ListParameteriSGIX);
	gl.ListParameterivSGIX = (void APIENTRY (*)(GLuint list, GLenum pname, const GLint *params)) ldg_find("glListParameterivSGIX", lib);
	GL_CHECK(gl.ListParameterivSGIX);
	gl.LoadIdentity = (void APIENTRY (*)(void)) ldg_find("glLoadIdentity", lib);
	GL_CHECK(gl.LoadIdentity);
	gl.LoadIdentityDeformationMapSGIX = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glLoadIdentityDeformationMapSGIX", lib);
	GL_CHECK(gl.LoadIdentityDeformationMapSGIX);
	gl.LoadMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glLoadMatrixd", lib);
	GL_CHECK(gl.LoadMatrixd);
	gl.LoadMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glLoadMatrixf", lib);
	GL_CHECK(gl.LoadMatrixf);
	gl.LoadMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glLoadMatrixxOES", lib);
	GL_CHECK(gl.LoadMatrixxOES);
	gl.LoadName = (void APIENTRY (*)(GLuint name)) ldg_find("glLoadName", lib);
	GL_CHECK(gl.LoadName);
	gl.LoadProgramNV = (void APIENTRY (*)(GLenum target, GLuint id, GLsizei len, const GLubyte *program)) ldg_find("glLoadProgramNV", lib);
	GL_CHECK(gl.LoadProgramNV);
	gl.LoadTransposeMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glLoadTransposeMatrixd", lib);
	GL_CHECK(gl.LoadTransposeMatrixd);
	gl.LoadTransposeMatrixdARB = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glLoadTransposeMatrixdARB", lib);
	GL_CHECK(gl.LoadTransposeMatrixdARB);
	gl.LoadTransposeMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glLoadTransposeMatrixf", lib);
	GL_CHECK(gl.LoadTransposeMatrixf);
	gl.LoadTransposeMatrixfARB = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glLoadTransposeMatrixfARB", lib);
	GL_CHECK(gl.LoadTransposeMatrixfARB);
	gl.LoadTransposeMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glLoadTransposeMatrixxOES", lib);
	GL_CHECK(gl.LoadTransposeMatrixxOES);
	gl.LockArraysEXT = (void APIENTRY (*)(GLint first, GLsizei count)) ldg_find("glLockArraysEXT", lib);
	GL_CHECK(gl.LockArraysEXT);
	gl.LogicOp = (void APIENTRY (*)(GLenum opcode)) ldg_find("glLogicOp", lib);
	GL_CHECK(gl.LogicOp);
	gl.MakeBufferNonResidentNV = (void APIENTRY (*)(GLenum target)) ldg_find("glMakeBufferNonResidentNV", lib);
	GL_CHECK(gl.MakeBufferNonResidentNV);
	gl.MakeBufferResidentNV = (void APIENTRY (*)(GLenum target, GLenum access)) ldg_find("glMakeBufferResidentNV", lib);
	GL_CHECK(gl.MakeBufferResidentNV);
	gl.MakeImageHandleNonResidentARB = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeImageHandleNonResidentARB", lib);
	GL_CHECK(gl.MakeImageHandleNonResidentARB);
	gl.MakeImageHandleNonResidentNV = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeImageHandleNonResidentNV", lib);
	GL_CHECK(gl.MakeImageHandleNonResidentNV);
	gl.MakeImageHandleResidentARB = (void APIENTRY (*)(GLuint64 handle, GLenum access)) ldg_find("glMakeImageHandleResidentARB", lib);
	GL_CHECK(gl.MakeImageHandleResidentARB);
	gl.MakeImageHandleResidentNV = (void APIENTRY (*)(GLuint64 handle, GLenum access)) ldg_find("glMakeImageHandleResidentNV", lib);
	GL_CHECK(gl.MakeImageHandleResidentNV);
	gl.MakeNamedBufferNonResidentNV = (void APIENTRY (*)(GLuint buffer)) ldg_find("glMakeNamedBufferNonResidentNV", lib);
	GL_CHECK(gl.MakeNamedBufferNonResidentNV);
	gl.MakeNamedBufferResidentNV = (void APIENTRY (*)(GLuint buffer, GLenum access)) ldg_find("glMakeNamedBufferResidentNV", lib);
	GL_CHECK(gl.MakeNamedBufferResidentNV);
	gl.MakeTextureHandleNonResidentARB = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleNonResidentARB", lib);
	GL_CHECK(gl.MakeTextureHandleNonResidentARB);
	gl.MakeTextureHandleNonResidentNV = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleNonResidentNV", lib);
	GL_CHECK(gl.MakeTextureHandleNonResidentNV);
	gl.MakeTextureHandleResidentARB = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleResidentARB", lib);
	GL_CHECK(gl.MakeTextureHandleResidentARB);
	gl.MakeTextureHandleResidentNV = (void APIENTRY (*)(GLuint64 handle)) ldg_find("glMakeTextureHandleResidentNV", lib);
	GL_CHECK(gl.MakeTextureHandleResidentNV);
	gl.Map1d = (void APIENTRY (*)(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)) ldg_find("glMap1d", lib);
	GL_CHECK(gl.Map1d);
	gl.Map1f = (void APIENTRY (*)(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)) ldg_find("glMap1f", lib);
	GL_CHECK(gl.Map1f);
	gl.Map1xOES = (void APIENTRY (*)(GLenum target, GLfixed u1, GLfixed u2, GLint stride, GLint order, GLfixed points)) ldg_find("glMap1xOES", lib);
	GL_CHECK(gl.Map1xOES);
	gl.Map2d = (void APIENTRY (*)(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)) ldg_find("glMap2d", lib);
	GL_CHECK(gl.Map2d);
	gl.Map2f = (void APIENTRY (*)(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)) ldg_find("glMap2f", lib);
	GL_CHECK(gl.Map2f);
	gl.Map2xOES = (void APIENTRY (*)(GLenum target, GLfixed u1, GLfixed u2, GLint ustride, GLint uorder, GLfixed v1, GLfixed v2, GLint vstride, GLint vorder, GLfixed points)) ldg_find("glMap2xOES", lib);
	GL_CHECK(gl.Map2xOES);
	gl.MapBuffer = (void * APIENTRY (*)(GLenum target, GLenum access)) ldg_find("glMapBuffer", lib);
	GL_CHECK(gl.MapBuffer);
	gl.MapBufferARB = (void * APIENTRY (*)(GLenum target, GLenum access)) ldg_find("glMapBufferARB", lib);
	GL_CHECK(gl.MapBufferARB);
	gl.MapBufferRange = (void * APIENTRY (*)(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)) ldg_find("glMapBufferRange", lib);
	GL_CHECK(gl.MapBufferRange);
	gl.MapControlPointsNV = (void APIENTRY (*)(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean32 packed, const void *points)) ldg_find("glMapControlPointsNV", lib);
	GL_CHECK(gl.MapControlPointsNV);
	gl.MapGrid1d = (void APIENTRY (*)(GLint un, GLdouble u1, GLdouble u2)) ldg_find("glMapGrid1d", lib);
	GL_CHECK(gl.MapGrid1d);
	gl.MapGrid1f = (void APIENTRY (*)(GLint un, GLfloat u1, GLfloat u2)) ldg_find("glMapGrid1f", lib);
	GL_CHECK(gl.MapGrid1f);
	gl.MapGrid1xOES = (void APIENTRY (*)(GLint n, GLfixed u1, GLfixed u2)) ldg_find("glMapGrid1xOES", lib);
	GL_CHECK(gl.MapGrid1xOES);
	gl.MapGrid2d = (void APIENTRY (*)(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)) ldg_find("glMapGrid2d", lib);
	GL_CHECK(gl.MapGrid2d);
	gl.MapGrid2f = (void APIENTRY (*)(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)) ldg_find("glMapGrid2f", lib);
	GL_CHECK(gl.MapGrid2f);
	gl.MapGrid2xOES = (void APIENTRY (*)(GLint n, GLfixed u1, GLfixed u2, GLfixed v1, GLfixed v2)) ldg_find("glMapGrid2xOES", lib);
	GL_CHECK(gl.MapGrid2xOES);
	gl.MapNamedBufferEXT = (void * APIENTRY (*)(GLuint buffer, GLenum access)) ldg_find("glMapNamedBufferEXT", lib);
	GL_CHECK(gl.MapNamedBufferEXT);
	gl.MapNamedBufferRangeEXT = (void * APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)) ldg_find("glMapNamedBufferRangeEXT", lib);
	GL_CHECK(gl.MapNamedBufferRangeEXT);
	gl.MapObjectBufferATI = (void * APIENTRY (*)(GLuint buffer)) ldg_find("glMapObjectBufferATI", lib);
	GL_CHECK(gl.MapObjectBufferATI);
	gl.MapParameterfvNV = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glMapParameterfvNV", lib);
	GL_CHECK(gl.MapParameterfvNV);
	gl.MapParameterivNV = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glMapParameterivNV", lib);
	GL_CHECK(gl.MapParameterivNV);
	gl.MapTexture2DINTEL = (void * APIENTRY (*)(GLuint texture, GLint level, GLbitfield access, const GLint *stride, const GLenum *layout)) ldg_find("glMapTexture2DINTEL", lib);
	GL_CHECK(gl.MapTexture2DINTEL);
	gl.MapVertexAttrib1dAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)) ldg_find("glMapVertexAttrib1dAPPLE", lib);
	GL_CHECK(gl.MapVertexAttrib1dAPPLE);
	gl.MapVertexAttrib1fAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)) ldg_find("glMapVertexAttrib1fAPPLE", lib);
	GL_CHECK(gl.MapVertexAttrib1fAPPLE);
	gl.MapVertexAttrib2dAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)) ldg_find("glMapVertexAttrib2dAPPLE", lib);
	GL_CHECK(gl.MapVertexAttrib2dAPPLE);
	gl.MapVertexAttrib2fAPPLE = (void APIENTRY (*)(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)) ldg_find("glMapVertexAttrib2fAPPLE", lib);
	GL_CHECK(gl.MapVertexAttrib2fAPPLE);
	gl.Materialf = (void APIENTRY (*)(GLenum face, GLenum pname, GLfloat param)) ldg_find("glMaterialf", lib);
	GL_CHECK(gl.Materialf);
	gl.Materialfv = (void APIENTRY (*)(GLenum face, GLenum pname, const GLfloat *params)) ldg_find("glMaterialfv", lib);
	GL_CHECK(gl.Materialfv);
	gl.Materiali = (void APIENTRY (*)(GLenum face, GLenum pname, GLint param)) ldg_find("glMateriali", lib);
	GL_CHECK(gl.Materiali);
	gl.Materialiv = (void APIENTRY (*)(GLenum face, GLenum pname, const GLint *params)) ldg_find("glMaterialiv", lib);
	GL_CHECK(gl.Materialiv);
	gl.MaterialxOES = (void APIENTRY (*)(GLenum face, GLenum pname, GLfixed param)) ldg_find("glMaterialxOES", lib);
	GL_CHECK(gl.MaterialxOES);
	gl.MaterialxvOES = (void APIENTRY (*)(GLenum face, GLenum pname, const GLfixed *param)) ldg_find("glMaterialxvOES", lib);
	GL_CHECK(gl.MaterialxvOES);
	gl.MatrixFrustumEXT = (void APIENTRY (*)(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glMatrixFrustumEXT", lib);
	GL_CHECK(gl.MatrixFrustumEXT);
	gl.MatrixIndexPointerARB = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glMatrixIndexPointerARB", lib);
	GL_CHECK(gl.MatrixIndexPointerARB);
	gl.MatrixIndexubvARB = (void APIENTRY (*)(GLint size, const GLubyte *indices)) ldg_find("glMatrixIndexubvARB", lib);
	GL_CHECK(gl.MatrixIndexubvARB);
	gl.MatrixIndexuivARB = (void APIENTRY (*)(GLint size, const GLuint *indices)) ldg_find("glMatrixIndexuivARB", lib);
	GL_CHECK(gl.MatrixIndexuivARB);
	gl.MatrixIndexusvARB = (void APIENTRY (*)(GLint size, const GLushort *indices)) ldg_find("glMatrixIndexusvARB", lib);
	GL_CHECK(gl.MatrixIndexusvARB);
	gl.MatrixLoadIdentityEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixLoadIdentityEXT", lib);
	GL_CHECK(gl.MatrixLoadIdentityEXT);
	gl.MatrixLoadTransposedEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixLoadTransposedEXT", lib);
	GL_CHECK(gl.MatrixLoadTransposedEXT);
	gl.MatrixLoadTransposefEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixLoadTransposefEXT", lib);
	GL_CHECK(gl.MatrixLoadTransposefEXT);
	gl.MatrixLoaddEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixLoaddEXT", lib);
	GL_CHECK(gl.MatrixLoaddEXT);
	gl.MatrixLoadfEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixLoadfEXT", lib);
	GL_CHECK(gl.MatrixLoadfEXT);
	gl.MatrixMode = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixMode", lib);
	GL_CHECK(gl.MatrixMode);
	gl.MatrixMultTransposedEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixMultTransposedEXT", lib);
	GL_CHECK(gl.MatrixMultTransposedEXT);
	gl.MatrixMultTransposefEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixMultTransposefEXT", lib);
	GL_CHECK(gl.MatrixMultTransposefEXT);
	gl.MatrixMultdEXT = (void APIENTRY (*)(GLenum mode, const GLdouble *m)) ldg_find("glMatrixMultdEXT", lib);
	GL_CHECK(gl.MatrixMultdEXT);
	gl.MatrixMultfEXT = (void APIENTRY (*)(GLenum mode, const GLfloat *m)) ldg_find("glMatrixMultfEXT", lib);
	GL_CHECK(gl.MatrixMultfEXT);
	gl.MatrixOrthoEXT = (void APIENTRY (*)(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glMatrixOrthoEXT", lib);
	GL_CHECK(gl.MatrixOrthoEXT);
	gl.MatrixPopEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixPopEXT", lib);
	GL_CHECK(gl.MatrixPopEXT);
	gl.MatrixPushEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glMatrixPushEXT", lib);
	GL_CHECK(gl.MatrixPushEXT);
	gl.MatrixRotatedEXT = (void APIENTRY (*)(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glMatrixRotatedEXT", lib);
	GL_CHECK(gl.MatrixRotatedEXT);
	gl.MatrixRotatefEXT = (void APIENTRY (*)(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glMatrixRotatefEXT", lib);
	GL_CHECK(gl.MatrixRotatefEXT);
	gl.MatrixScaledEXT = (void APIENTRY (*)(GLenum mode, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glMatrixScaledEXT", lib);
	GL_CHECK(gl.MatrixScaledEXT);
	gl.MatrixScalefEXT = (void APIENTRY (*)(GLenum mode, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glMatrixScalefEXT", lib);
	GL_CHECK(gl.MatrixScalefEXT);
	gl.MatrixTranslatedEXT = (void APIENTRY (*)(GLenum mode, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glMatrixTranslatedEXT", lib);
	GL_CHECK(gl.MatrixTranslatedEXT);
	gl.MatrixTranslatefEXT = (void APIENTRY (*)(GLenum mode, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glMatrixTranslatefEXT", lib);
	GL_CHECK(gl.MatrixTranslatefEXT);
	gl.MemoryBarrier = (void APIENTRY (*)(GLbitfield barriers)) ldg_find("glMemoryBarrier", lib);
	GL_CHECK(gl.MemoryBarrier);
	gl.MemoryBarrierEXT = (void APIENTRY (*)(GLbitfield barriers)) ldg_find("glMemoryBarrierEXT", lib);
	GL_CHECK(gl.MemoryBarrierEXT);
	gl.MinSampleShading = (void APIENTRY (*)(GLfloat value)) ldg_find("glMinSampleShading", lib);
	GL_CHECK(gl.MinSampleShading);
	gl.MinSampleShadingARB = (void APIENTRY (*)(GLfloat value)) ldg_find("glMinSampleShadingARB", lib);
	GL_CHECK(gl.MinSampleShadingARB);
	gl.Minmax = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLboolean32 sink)) ldg_find("glMinmax", lib);
	GL_CHECK(gl.Minmax);
	gl.MinmaxEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLboolean32 sink)) ldg_find("glMinmaxEXT", lib);
	GL_CHECK(gl.MinmaxEXT);
	gl.MultMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glMultMatrixd", lib);
	GL_CHECK(gl.MultMatrixd);
	gl.MultMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glMultMatrixf", lib);
	GL_CHECK(gl.MultMatrixf);
	gl.MultMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glMultMatrixxOES", lib);
	GL_CHECK(gl.MultMatrixxOES);
	gl.MultTransposeMatrixd = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glMultTransposeMatrixd", lib);
	GL_CHECK(gl.MultTransposeMatrixd);
	gl.MultTransposeMatrixdARB = (void APIENTRY (*)(const GLdouble *m)) ldg_find("glMultTransposeMatrixdARB", lib);
	GL_CHECK(gl.MultTransposeMatrixdARB);
	gl.MultTransposeMatrixf = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glMultTransposeMatrixf", lib);
	GL_CHECK(gl.MultTransposeMatrixf);
	gl.MultTransposeMatrixfARB = (void APIENTRY (*)(const GLfloat *m)) ldg_find("glMultTransposeMatrixfARB", lib);
	GL_CHECK(gl.MultTransposeMatrixfARB);
	gl.MultTransposeMatrixxOES = (void APIENTRY (*)(const GLfixed *m)) ldg_find("glMultTransposeMatrixxOES", lib);
	GL_CHECK(gl.MultTransposeMatrixxOES);
	gl.MultiDrawArrays = (void APIENTRY (*)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)) ldg_find("glMultiDrawArrays", lib);
	GL_CHECK(gl.MultiDrawArrays);
	gl.MultiDrawArraysEXT = (void APIENTRY (*)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)) ldg_find("glMultiDrawArraysEXT", lib);
	GL_CHECK(gl.MultiDrawArraysEXT);
	gl.MultiDrawArraysIndirect = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirect", lib);
	GL_CHECK(gl.MultiDrawArraysIndirect);
	gl.MultiDrawArraysIndirectAMD = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei primcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirectAMD", lib);
	GL_CHECK(gl.MultiDrawArraysIndirectAMD);
	gl.MultiDrawArraysIndirectBindlessNV = (void APIENTRY (*)(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)) ldg_find("glMultiDrawArraysIndirectBindlessNV", lib);
	GL_CHECK(gl.MultiDrawArraysIndirectBindlessNV);
	gl.MultiDrawArraysIndirectCountARB = (void APIENTRY (*)(GLenum mode, GLintptr indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)) ldg_find("glMultiDrawArraysIndirectCountARB", lib);
	GL_CHECK(gl.MultiDrawArraysIndirectCountARB);
	gl.MultiDrawElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)) ldg_find("glMultiDrawElementArrayAPPLE", lib);
	GL_CHECK(gl.MultiDrawElementArrayAPPLE);
	gl.MultiDrawElements = (void APIENTRY (*)(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei drawcount)) ldg_find("glMultiDrawElements", lib);
	GL_CHECK(gl.MultiDrawElements);
	gl.MultiDrawElementsBaseVertex = (void APIENTRY (*)(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei drawcount, const GLint *basevertex)) ldg_find("glMultiDrawElementsBaseVertex", lib);
	GL_CHECK(gl.MultiDrawElementsBaseVertex);
	gl.MultiDrawElementsEXT = (void APIENTRY (*)(GLenum mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei primcount)) ldg_find("glMultiDrawElementsEXT", lib);
	GL_CHECK(gl.MultiDrawElementsEXT);
	gl.MultiDrawElementsIndirect = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirect", lib);
	GL_CHECK(gl.MultiDrawElementsIndirect);
	gl.MultiDrawElementsIndirectAMD = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei primcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirectAMD", lib);
	GL_CHECK(gl.MultiDrawElementsIndirectAMD);
	gl.MultiDrawElementsIndirectBindlessNV = (void APIENTRY (*)(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)) ldg_find("glMultiDrawElementsIndirectBindlessNV", lib);
	GL_CHECK(gl.MultiDrawElementsIndirectBindlessNV);
	gl.MultiDrawElementsIndirectCountARB = (void APIENTRY (*)(GLenum mode, GLenum type, GLintptr indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)) ldg_find("glMultiDrawElementsIndirectCountARB", lib);
	GL_CHECK(gl.MultiDrawElementsIndirectCountARB);
	gl.MultiDrawRangeElementArrayAPPLE = (void APIENTRY (*)(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount)) ldg_find("glMultiDrawRangeElementArrayAPPLE", lib);
	GL_CHECK(gl.MultiDrawRangeElementArrayAPPLE);
	gl.MultiModeDrawArraysIBM = (void APIENTRY (*)(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride)) ldg_find("glMultiModeDrawArraysIBM", lib);
	GL_CHECK(gl.MultiModeDrawArraysIBM);
	gl.MultiModeDrawElementsIBM = (void APIENTRY (*)(const GLenum *mode, const GLsizei *count, GLenum type, const void *const *indices, GLsizei primcount, GLint modestride)) ldg_find("glMultiModeDrawElementsIBM", lib);
	GL_CHECK(gl.MultiModeDrawElementsIBM);
	gl.MultiTexBufferEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glMultiTexBufferEXT", lib);
	GL_CHECK(gl.MultiTexBufferEXT);
	gl.MultiTexCoord1bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s)) ldg_find("glMultiTexCoord1bOES", lib);
	GL_CHECK(gl.MultiTexCoord1bOES);
	gl.MultiTexCoord1bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord1bvOES", lib);
	GL_CHECK(gl.MultiTexCoord1bvOES);
	gl.MultiTexCoord1d = (void APIENTRY (*)(GLenum target, GLdouble s)) ldg_find("glMultiTexCoord1d", lib);
	GL_CHECK(gl.MultiTexCoord1d);
	gl.MultiTexCoord1dARB = (void APIENTRY (*)(GLenum target, GLdouble s)) ldg_find("glMultiTexCoord1dARB", lib);
	GL_CHECK(gl.MultiTexCoord1dARB);
	gl.MultiTexCoord1dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord1dv", lib);
	GL_CHECK(gl.MultiTexCoord1dv);
	gl.MultiTexCoord1dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord1dvARB", lib);
	GL_CHECK(gl.MultiTexCoord1dvARB);
	gl.MultiTexCoord1f = (void APIENTRY (*)(GLenum target, GLfloat s)) ldg_find("glMultiTexCoord1f", lib);
	GL_CHECK(gl.MultiTexCoord1f);
	gl.MultiTexCoord1fARB = (void APIENTRY (*)(GLenum target, GLfloat s)) ldg_find("glMultiTexCoord1fARB", lib);
	GL_CHECK(gl.MultiTexCoord1fARB);
	gl.MultiTexCoord1fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord1fv", lib);
	GL_CHECK(gl.MultiTexCoord1fv);
	gl.MultiTexCoord1fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord1fvARB", lib);
	GL_CHECK(gl.MultiTexCoord1fvARB);
	gl.MultiTexCoord1hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s)) ldg_find("glMultiTexCoord1hNV", lib);
	GL_CHECK(gl.MultiTexCoord1hNV);
	gl.MultiTexCoord1hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord1hvNV", lib);
	GL_CHECK(gl.MultiTexCoord1hvNV);
	gl.MultiTexCoord1i = (void APIENTRY (*)(GLenum target, GLint s)) ldg_find("glMultiTexCoord1i", lib);
	GL_CHECK(gl.MultiTexCoord1i);
	gl.MultiTexCoord1iARB = (void APIENTRY (*)(GLenum target, GLint s)) ldg_find("glMultiTexCoord1iARB", lib);
	GL_CHECK(gl.MultiTexCoord1iARB);
	gl.MultiTexCoord1iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord1iv", lib);
	GL_CHECK(gl.MultiTexCoord1iv);
	gl.MultiTexCoord1ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord1ivARB", lib);
	GL_CHECK(gl.MultiTexCoord1ivARB);
	gl.MultiTexCoord1s = (void APIENTRY (*)(GLenum target, GLshort32 s)) ldg_find("glMultiTexCoord1s", lib);
	GL_CHECK(gl.MultiTexCoord1s);
	gl.MultiTexCoord1sARB = (void APIENTRY (*)(GLenum target, GLshort32 s)) ldg_find("glMultiTexCoord1sARB", lib);
	GL_CHECK(gl.MultiTexCoord1sARB);
	gl.MultiTexCoord1sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord1sv", lib);
	GL_CHECK(gl.MultiTexCoord1sv);
	gl.MultiTexCoord1svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord1svARB", lib);
	GL_CHECK(gl.MultiTexCoord1svARB);
	gl.MultiTexCoord1xOES = (void APIENTRY (*)(GLenum texture, GLfixed s)) ldg_find("glMultiTexCoord1xOES", lib);
	GL_CHECK(gl.MultiTexCoord1xOES);
	gl.MultiTexCoord1xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord1xvOES", lib);
	GL_CHECK(gl.MultiTexCoord1xvOES);
	gl.MultiTexCoord2bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s, GLbyte32 t)) ldg_find("glMultiTexCoord2bOES", lib);
	GL_CHECK(gl.MultiTexCoord2bOES);
	gl.MultiTexCoord2bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord2bvOES", lib);
	GL_CHECK(gl.MultiTexCoord2bvOES);
	gl.MultiTexCoord2d = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t)) ldg_find("glMultiTexCoord2d", lib);
	GL_CHECK(gl.MultiTexCoord2d);
	gl.MultiTexCoord2dARB = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t)) ldg_find("glMultiTexCoord2dARB", lib);
	GL_CHECK(gl.MultiTexCoord2dARB);
	gl.MultiTexCoord2dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord2dv", lib);
	GL_CHECK(gl.MultiTexCoord2dv);
	gl.MultiTexCoord2dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord2dvARB", lib);
	GL_CHECK(gl.MultiTexCoord2dvARB);
	gl.MultiTexCoord2f = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t)) ldg_find("glMultiTexCoord2f", lib);
	GL_CHECK(gl.MultiTexCoord2f);
	gl.MultiTexCoord2fARB = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t)) ldg_find("glMultiTexCoord2fARB", lib);
	GL_CHECK(gl.MultiTexCoord2fARB);
	gl.MultiTexCoord2fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord2fv", lib);
	GL_CHECK(gl.MultiTexCoord2fv);
	gl.MultiTexCoord2fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord2fvARB", lib);
	GL_CHECK(gl.MultiTexCoord2fvARB);
	gl.MultiTexCoord2hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s, GLhalfNV32 t)) ldg_find("glMultiTexCoord2hNV", lib);
	GL_CHECK(gl.MultiTexCoord2hNV);
	gl.MultiTexCoord2hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord2hvNV", lib);
	GL_CHECK(gl.MultiTexCoord2hvNV);
	gl.MultiTexCoord2i = (void APIENTRY (*)(GLenum target, GLint s, GLint t)) ldg_find("glMultiTexCoord2i", lib);
	GL_CHECK(gl.MultiTexCoord2i);
	gl.MultiTexCoord2iARB = (void APIENTRY (*)(GLenum target, GLint s, GLint t)) ldg_find("glMultiTexCoord2iARB", lib);
	GL_CHECK(gl.MultiTexCoord2iARB);
	gl.MultiTexCoord2iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord2iv", lib);
	GL_CHECK(gl.MultiTexCoord2iv);
	gl.MultiTexCoord2ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord2ivARB", lib);
	GL_CHECK(gl.MultiTexCoord2ivARB);
	gl.MultiTexCoord2s = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t)) ldg_find("glMultiTexCoord2s", lib);
	GL_CHECK(gl.MultiTexCoord2s);
	gl.MultiTexCoord2sARB = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t)) ldg_find("glMultiTexCoord2sARB", lib);
	GL_CHECK(gl.MultiTexCoord2sARB);
	gl.MultiTexCoord2sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord2sv", lib);
	GL_CHECK(gl.MultiTexCoord2sv);
	gl.MultiTexCoord2svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord2svARB", lib);
	GL_CHECK(gl.MultiTexCoord2svARB);
	gl.MultiTexCoord2xOES = (void APIENTRY (*)(GLenum texture, GLfixed s, GLfixed t)) ldg_find("glMultiTexCoord2xOES", lib);
	GL_CHECK(gl.MultiTexCoord2xOES);
	gl.MultiTexCoord2xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord2xvOES", lib);
	GL_CHECK(gl.MultiTexCoord2xvOES);
	gl.MultiTexCoord3bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s, GLbyte32 t, GLbyte32 r)) ldg_find("glMultiTexCoord3bOES", lib);
	GL_CHECK(gl.MultiTexCoord3bOES);
	gl.MultiTexCoord3bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord3bvOES", lib);
	GL_CHECK(gl.MultiTexCoord3bvOES);
	gl.MultiTexCoord3d = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r)) ldg_find("glMultiTexCoord3d", lib);
	GL_CHECK(gl.MultiTexCoord3d);
	gl.MultiTexCoord3dARB = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r)) ldg_find("glMultiTexCoord3dARB", lib);
	GL_CHECK(gl.MultiTexCoord3dARB);
	gl.MultiTexCoord3dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord3dv", lib);
	GL_CHECK(gl.MultiTexCoord3dv);
	gl.MultiTexCoord3dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord3dvARB", lib);
	GL_CHECK(gl.MultiTexCoord3dvARB);
	gl.MultiTexCoord3f = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r)) ldg_find("glMultiTexCoord3f", lib);
	GL_CHECK(gl.MultiTexCoord3f);
	gl.MultiTexCoord3fARB = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r)) ldg_find("glMultiTexCoord3fARB", lib);
	GL_CHECK(gl.MultiTexCoord3fARB);
	gl.MultiTexCoord3fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord3fv", lib);
	GL_CHECK(gl.MultiTexCoord3fv);
	gl.MultiTexCoord3fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord3fvARB", lib);
	GL_CHECK(gl.MultiTexCoord3fvARB);
	gl.MultiTexCoord3hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r)) ldg_find("glMultiTexCoord3hNV", lib);
	GL_CHECK(gl.MultiTexCoord3hNV);
	gl.MultiTexCoord3hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord3hvNV", lib);
	GL_CHECK(gl.MultiTexCoord3hvNV);
	gl.MultiTexCoord3i = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r)) ldg_find("glMultiTexCoord3i", lib);
	GL_CHECK(gl.MultiTexCoord3i);
	gl.MultiTexCoord3iARB = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r)) ldg_find("glMultiTexCoord3iARB", lib);
	GL_CHECK(gl.MultiTexCoord3iARB);
	gl.MultiTexCoord3iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord3iv", lib);
	GL_CHECK(gl.MultiTexCoord3iv);
	gl.MultiTexCoord3ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord3ivARB", lib);
	GL_CHECK(gl.MultiTexCoord3ivARB);
	gl.MultiTexCoord3s = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r)) ldg_find("glMultiTexCoord3s", lib);
	GL_CHECK(gl.MultiTexCoord3s);
	gl.MultiTexCoord3sARB = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r)) ldg_find("glMultiTexCoord3sARB", lib);
	GL_CHECK(gl.MultiTexCoord3sARB);
	gl.MultiTexCoord3sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord3sv", lib);
	GL_CHECK(gl.MultiTexCoord3sv);
	gl.MultiTexCoord3svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord3svARB", lib);
	GL_CHECK(gl.MultiTexCoord3svARB);
	gl.MultiTexCoord3xOES = (void APIENTRY (*)(GLenum texture, GLfixed s, GLfixed t, GLfixed r)) ldg_find("glMultiTexCoord3xOES", lib);
	GL_CHECK(gl.MultiTexCoord3xOES);
	gl.MultiTexCoord3xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord3xvOES", lib);
	GL_CHECK(gl.MultiTexCoord3xvOES);
	gl.MultiTexCoord4bOES = (void APIENTRY (*)(GLenum texture, GLbyte32 s, GLbyte32 t, GLbyte32 r, GLbyte32 q)) ldg_find("glMultiTexCoord4bOES", lib);
	GL_CHECK(gl.MultiTexCoord4bOES);
	gl.MultiTexCoord4bvOES = (void APIENTRY (*)(GLenum texture, const GLbyte *coords)) ldg_find("glMultiTexCoord4bvOES", lib);
	GL_CHECK(gl.MultiTexCoord4bvOES);
	gl.MultiTexCoord4d = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)) ldg_find("glMultiTexCoord4d", lib);
	GL_CHECK(gl.MultiTexCoord4d);
	gl.MultiTexCoord4dARB = (void APIENTRY (*)(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)) ldg_find("glMultiTexCoord4dARB", lib);
	GL_CHECK(gl.MultiTexCoord4dARB);
	gl.MultiTexCoord4dv = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord4dv", lib);
	GL_CHECK(gl.MultiTexCoord4dv);
	gl.MultiTexCoord4dvARB = (void APIENTRY (*)(GLenum target, const GLdouble *v)) ldg_find("glMultiTexCoord4dvARB", lib);
	GL_CHECK(gl.MultiTexCoord4dvARB);
	gl.MultiTexCoord4f = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)) ldg_find("glMultiTexCoord4f", lib);
	GL_CHECK(gl.MultiTexCoord4f);
	gl.MultiTexCoord4fARB = (void APIENTRY (*)(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)) ldg_find("glMultiTexCoord4fARB", lib);
	GL_CHECK(gl.MultiTexCoord4fARB);
	gl.MultiTexCoord4fv = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord4fv", lib);
	GL_CHECK(gl.MultiTexCoord4fv);
	gl.MultiTexCoord4fvARB = (void APIENTRY (*)(GLenum target, const GLfloat *v)) ldg_find("glMultiTexCoord4fvARB", lib);
	GL_CHECK(gl.MultiTexCoord4fvARB);
	gl.MultiTexCoord4hNV = (void APIENTRY (*)(GLenum target, GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r, GLhalfNV32 q)) ldg_find("glMultiTexCoord4hNV", lib);
	GL_CHECK(gl.MultiTexCoord4hNV);
	gl.MultiTexCoord4hvNV = (void APIENTRY (*)(GLenum target, const GLhalfNV *v)) ldg_find("glMultiTexCoord4hvNV", lib);
	GL_CHECK(gl.MultiTexCoord4hvNV);
	gl.MultiTexCoord4i = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r, GLint q)) ldg_find("glMultiTexCoord4i", lib);
	GL_CHECK(gl.MultiTexCoord4i);
	gl.MultiTexCoord4iARB = (void APIENTRY (*)(GLenum target, GLint s, GLint t, GLint r, GLint q)) ldg_find("glMultiTexCoord4iARB", lib);
	GL_CHECK(gl.MultiTexCoord4iARB);
	gl.MultiTexCoord4iv = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord4iv", lib);
	GL_CHECK(gl.MultiTexCoord4iv);
	gl.MultiTexCoord4ivARB = (void APIENTRY (*)(GLenum target, const GLint *v)) ldg_find("glMultiTexCoord4ivARB", lib);
	GL_CHECK(gl.MultiTexCoord4ivARB);
	gl.MultiTexCoord4s = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)) ldg_find("glMultiTexCoord4s", lib);
	GL_CHECK(gl.MultiTexCoord4s);
	gl.MultiTexCoord4sARB = (void APIENTRY (*)(GLenum target, GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)) ldg_find("glMultiTexCoord4sARB", lib);
	GL_CHECK(gl.MultiTexCoord4sARB);
	gl.MultiTexCoord4sv = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord4sv", lib);
	GL_CHECK(gl.MultiTexCoord4sv);
	gl.MultiTexCoord4svARB = (void APIENTRY (*)(GLenum target, const GLshort *v)) ldg_find("glMultiTexCoord4svARB", lib);
	GL_CHECK(gl.MultiTexCoord4svARB);
	gl.MultiTexCoord4xOES = (void APIENTRY (*)(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)) ldg_find("glMultiTexCoord4xOES", lib);
	GL_CHECK(gl.MultiTexCoord4xOES);
	gl.MultiTexCoord4xvOES = (void APIENTRY (*)(GLenum texture, const GLfixed *coords)) ldg_find("glMultiTexCoord4xvOES", lib);
	GL_CHECK(gl.MultiTexCoord4xvOES);
	gl.MultiTexCoordP1ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP1ui", lib);
	GL_CHECK(gl.MultiTexCoordP1ui);
	gl.MultiTexCoordP1uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP1uiv", lib);
	GL_CHECK(gl.MultiTexCoordP1uiv);
	gl.MultiTexCoordP2ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP2ui", lib);
	GL_CHECK(gl.MultiTexCoordP2ui);
	gl.MultiTexCoordP2uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP2uiv", lib);
	GL_CHECK(gl.MultiTexCoordP2uiv);
	gl.MultiTexCoordP3ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP3ui", lib);
	GL_CHECK(gl.MultiTexCoordP3ui);
	gl.MultiTexCoordP3uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP3uiv", lib);
	GL_CHECK(gl.MultiTexCoordP3uiv);
	gl.MultiTexCoordP4ui = (void APIENTRY (*)(GLenum texture, GLenum type, GLuint coords)) ldg_find("glMultiTexCoordP4ui", lib);
	GL_CHECK(gl.MultiTexCoordP4ui);
	gl.MultiTexCoordP4uiv = (void APIENTRY (*)(GLenum texture, GLenum type, const GLuint *coords)) ldg_find("glMultiTexCoordP4uiv", lib);
	GL_CHECK(gl.MultiTexCoordP4uiv);
	gl.MultiTexCoordPointerEXT = (void APIENTRY (*)(GLenum texunit, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glMultiTexCoordPointerEXT", lib);
	GL_CHECK(gl.MultiTexCoordPointerEXT);
	gl.MultiTexEnvfEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat param)) ldg_find("glMultiTexEnvfEXT", lib);
	GL_CHECK(gl.MultiTexEnvfEXT);
	gl.MultiTexEnvfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glMultiTexEnvfvEXT", lib);
	GL_CHECK(gl.MultiTexEnvfvEXT);
	gl.MultiTexEnviEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint param)) ldg_find("glMultiTexEnviEXT", lib);
	GL_CHECK(gl.MultiTexEnviEXT);
	gl.MultiTexEnvivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLint *params)) ldg_find("glMultiTexEnvivEXT", lib);
	GL_CHECK(gl.MultiTexEnvivEXT);
	gl.MultiTexGendEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLdouble param)) ldg_find("glMultiTexGendEXT", lib);
	GL_CHECK(gl.MultiTexGendEXT);
	gl.MultiTexGendvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params)) ldg_find("glMultiTexGendvEXT", lib);
	GL_CHECK(gl.MultiTexGendvEXT);
	gl.MultiTexGenfEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLfloat param)) ldg_find("glMultiTexGenfEXT", lib);
	GL_CHECK(gl.MultiTexGenfEXT);
	gl.MultiTexGenfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params)) ldg_find("glMultiTexGenfvEXT", lib);
	GL_CHECK(gl.MultiTexGenfvEXT);
	gl.MultiTexGeniEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, GLint param)) ldg_find("glMultiTexGeniEXT", lib);
	GL_CHECK(gl.MultiTexGeniEXT);
	gl.MultiTexGenivEXT = (void APIENTRY (*)(GLenum texunit, GLenum coord, GLenum pname, const GLint *params)) ldg_find("glMultiTexGenivEXT", lib);
	GL_CHECK(gl.MultiTexGenivEXT);
	gl.MultiTexImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexImage1DEXT", lib);
	GL_CHECK(gl.MultiTexImage1DEXT);
	gl.MultiTexImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexImage2DEXT", lib);
	GL_CHECK(gl.MultiTexImage2DEXT);
	gl.MultiTexImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexImage3DEXT", lib);
	GL_CHECK(gl.MultiTexImage3DEXT);
	gl.MultiTexParameterIivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLint *params)) ldg_find("glMultiTexParameterIivEXT", lib);
	GL_CHECK(gl.MultiTexParameterIivEXT);
	gl.MultiTexParameterIuivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLuint *params)) ldg_find("glMultiTexParameterIuivEXT", lib);
	GL_CHECK(gl.MultiTexParameterIuivEXT);
	gl.MultiTexParameterfEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLfloat param)) ldg_find("glMultiTexParameterfEXT", lib);
	GL_CHECK(gl.MultiTexParameterfEXT);
	gl.MultiTexParameterfvEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glMultiTexParameterfvEXT", lib);
	GL_CHECK(gl.MultiTexParameterfvEXT);
	gl.MultiTexParameteriEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, GLint param)) ldg_find("glMultiTexParameteriEXT", lib);
	GL_CHECK(gl.MultiTexParameteriEXT);
	gl.MultiTexParameterivEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLenum pname, const GLint *params)) ldg_find("glMultiTexParameterivEXT", lib);
	GL_CHECK(gl.MultiTexParameterivEXT);
	gl.MultiTexRenderbufferEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLuint renderbuffer)) ldg_find("glMultiTexRenderbufferEXT", lib);
	GL_CHECK(gl.MultiTexRenderbufferEXT);
	gl.MultiTexSubImage1DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexSubImage1DEXT", lib);
	GL_CHECK(gl.MultiTexSubImage1DEXT);
	gl.MultiTexSubImage2DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexSubImage2DEXT", lib);
	GL_CHECK(gl.MultiTexSubImage2DEXT);
	gl.MultiTexSubImage3DEXT = (void APIENTRY (*)(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glMultiTexSubImage3DEXT", lib);
	GL_CHECK(gl.MultiTexSubImage3DEXT);
	gl.NamedBufferDataEXT = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage)) ldg_find("glNamedBufferDataEXT", lib);
	GL_CHECK(gl.NamedBufferDataEXT);
	gl.NamedBufferStorageEXT = (void APIENTRY (*)(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags)) ldg_find("glNamedBufferStorageEXT", lib);
	GL_CHECK(gl.NamedBufferStorageEXT);
	gl.NamedBufferSubDataEXT = (void APIENTRY (*)(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data)) ldg_find("glNamedBufferSubDataEXT", lib);
	GL_CHECK(gl.NamedBufferSubDataEXT);
	gl.NamedCopyBufferSubDataEXT = (void APIENTRY (*)(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)) ldg_find("glNamedCopyBufferSubDataEXT", lib);
	GL_CHECK(gl.NamedCopyBufferSubDataEXT);
	gl.NamedFramebufferParameteriEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum pname, GLint param)) ldg_find("glNamedFramebufferParameteriEXT", lib);
	GL_CHECK(gl.NamedFramebufferParameteriEXT);
	gl.NamedFramebufferRenderbufferEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)) ldg_find("glNamedFramebufferRenderbufferEXT", lib);
	GL_CHECK(gl.NamedFramebufferRenderbufferEXT);
	gl.NamedFramebufferTexture1DEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTexture1DEXT", lib);
	GL_CHECK(gl.NamedFramebufferTexture1DEXT);
	gl.NamedFramebufferTexture2DEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTexture2DEXT", lib);
	GL_CHECK(gl.NamedFramebufferTexture2DEXT);
	gl.NamedFramebufferTexture3DEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)) ldg_find("glNamedFramebufferTexture3DEXT", lib);
	GL_CHECK(gl.NamedFramebufferTexture3DEXT);
	gl.NamedFramebufferTextureEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)) ldg_find("glNamedFramebufferTextureEXT", lib);
	GL_CHECK(gl.NamedFramebufferTextureEXT);
	gl.NamedFramebufferTextureFaceEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face)) ldg_find("glNamedFramebufferTextureFaceEXT", lib);
	GL_CHECK(gl.NamedFramebufferTextureFaceEXT);
	gl.NamedFramebufferTextureLayerEXT = (void APIENTRY (*)(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)) ldg_find("glNamedFramebufferTextureLayerEXT", lib);
	GL_CHECK(gl.NamedFramebufferTextureLayerEXT);
	gl.NamedProgramLocalParameter4dEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glNamedProgramLocalParameter4dEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameter4dEXT);
	gl.NamedProgramLocalParameter4dvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLdouble *params)) ldg_find("glNamedProgramLocalParameter4dvEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameter4dvEXT);
	gl.NamedProgramLocalParameter4fEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glNamedProgramLocalParameter4fEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameter4fEXT);
	gl.NamedProgramLocalParameter4fvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLfloat *params)) ldg_find("glNamedProgramLocalParameter4fvEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameter4fvEXT);
	gl.NamedProgramLocalParameterI4iEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glNamedProgramLocalParameterI4iEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameterI4iEXT);
	gl.NamedProgramLocalParameterI4ivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLint *params)) ldg_find("glNamedProgramLocalParameterI4ivEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameterI4ivEXT);
	gl.NamedProgramLocalParameterI4uiEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glNamedProgramLocalParameterI4uiEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameterI4uiEXT);
	gl.NamedProgramLocalParameterI4uivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, const GLuint *params)) ldg_find("glNamedProgramLocalParameterI4uivEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameterI4uivEXT);
	gl.NamedProgramLocalParameters4fvEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params)) ldg_find("glNamedProgramLocalParameters4fvEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParameters4fvEXT);
	gl.NamedProgramLocalParametersI4ivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params)) ldg_find("glNamedProgramLocalParametersI4ivEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParametersI4ivEXT);
	gl.NamedProgramLocalParametersI4uivEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params)) ldg_find("glNamedProgramLocalParametersI4uivEXT", lib);
	GL_CHECK(gl.NamedProgramLocalParametersI4uivEXT);
	gl.NamedProgramStringEXT = (void APIENTRY (*)(GLuint program, GLenum target, GLenum format, GLsizei len, const void *string)) ldg_find("glNamedProgramStringEXT", lib);
	GL_CHECK(gl.NamedProgramStringEXT);
	gl.NamedRenderbufferStorageEXT = (void APIENTRY (*)(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageEXT", lib);
	GL_CHECK(gl.NamedRenderbufferStorageEXT);
	gl.NamedRenderbufferStorageMultisampleCoverageEXT = (void APIENTRY (*)(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageMultisampleCoverageEXT", lib);
	GL_CHECK(gl.NamedRenderbufferStorageMultisampleCoverageEXT);
	gl.NamedRenderbufferStorageMultisampleEXT = (void APIENTRY (*)(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glNamedRenderbufferStorageMultisampleEXT", lib);
	GL_CHECK(gl.NamedRenderbufferStorageMultisampleEXT);
	gl.NamedStringARB = (void APIENTRY (*)(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string)) ldg_find("glNamedStringARB", lib);
	GL_CHECK(gl.NamedStringARB);
	gl.NewList = (void APIENTRY (*)(GLuint list, GLenum mode)) ldg_find("glNewList", lib);
	GL_CHECK(gl.NewList);
	gl.NewObjectBufferATI = (GLuint APIENTRY (*)(GLsizei size, const void *pointer, GLenum usage)) ldg_find("glNewObjectBufferATI", lib);
	GL_CHECK(gl.NewObjectBufferATI);
	gl.NewTraceMESA = (void APIENTRY (*)(GLbitfield mask, const GLubyte *traceName)) ldg_find("glNewTraceMESA", lib);
	GL_CHECK(gl.NewTraceMESA);
	gl.Normal3b = (void APIENTRY (*)(GLbyte32 nx, GLbyte32 ny, GLbyte32 nz)) ldg_find("glNormal3b", lib);
	GL_CHECK(gl.Normal3b);
	gl.Normal3bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glNormal3bv", lib);
	GL_CHECK(gl.Normal3bv);
	gl.Normal3d = (void APIENTRY (*)(GLdouble nx, GLdouble ny, GLdouble nz)) ldg_find("glNormal3d", lib);
	GL_CHECK(gl.Normal3d);
	gl.Normal3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glNormal3dv", lib);
	GL_CHECK(gl.Normal3dv);
	gl.Normal3f = (void APIENTRY (*)(GLfloat nx, GLfloat ny, GLfloat nz)) ldg_find("glNormal3f", lib);
	GL_CHECK(gl.Normal3f);
	gl.Normal3fVertex3fSUN = (void APIENTRY (*)(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.Normal3fVertex3fSUN);
	gl.Normal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *n, const GLfloat *v)) ldg_find("glNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.Normal3fVertex3fvSUN);
	gl.Normal3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glNormal3fv", lib);
	GL_CHECK(gl.Normal3fv);
	gl.Normal3hNV = (void APIENTRY (*)(GLhalfNV32 nx, GLhalfNV32 ny, GLhalfNV32 nz)) ldg_find("glNormal3hNV", lib);
	GL_CHECK(gl.Normal3hNV);
	gl.Normal3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glNormal3hvNV", lib);
	GL_CHECK(gl.Normal3hvNV);
	gl.Normal3i = (void APIENTRY (*)(GLint nx, GLint ny, GLint nz)) ldg_find("glNormal3i", lib);
	GL_CHECK(gl.Normal3i);
	gl.Normal3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glNormal3iv", lib);
	GL_CHECK(gl.Normal3iv);
	gl.Normal3s = (void APIENTRY (*)(GLshort32 nx, GLshort32 ny, GLshort32 nz)) ldg_find("glNormal3s", lib);
	GL_CHECK(gl.Normal3s);
	gl.Normal3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glNormal3sv", lib);
	GL_CHECK(gl.Normal3sv);
	gl.Normal3xOES = (void APIENTRY (*)(GLfixed nx, GLfixed ny, GLfixed nz)) ldg_find("glNormal3xOES", lib);
	GL_CHECK(gl.Normal3xOES);
	gl.Normal3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glNormal3xvOES", lib);
	GL_CHECK(gl.Normal3xvOES);
	gl.NormalFormatNV = (void APIENTRY (*)(GLenum type, GLsizei stride)) ldg_find("glNormalFormatNV", lib);
	GL_CHECK(gl.NormalFormatNV);
	gl.NormalP3ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glNormalP3ui", lib);
	GL_CHECK(gl.NormalP3ui);
	gl.NormalP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glNormalP3uiv", lib);
	GL_CHECK(gl.NormalP3uiv);
	gl.NormalPointer = (void APIENTRY (*)(GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glNormalPointer", lib);
	GL_CHECK(gl.NormalPointer);
	gl.NormalPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glNormalPointerEXT", lib);
	GL_CHECK(gl.NormalPointerEXT);
	gl.NormalPointerListIBM = (void APIENTRY (*)(GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glNormalPointerListIBM", lib);
	GL_CHECK(gl.NormalPointerListIBM);
	gl.NormalPointervINTEL = (void APIENTRY (*)(GLenum type, const void * *pointer)) ldg_find("glNormalPointervINTEL", lib);
	GL_CHECK(gl.NormalPointervINTEL);
	gl.NormalStream3bATI = (void APIENTRY (*)(GLenum stream, GLbyte32 nx, GLbyte32 ny, GLbyte32 nz)) ldg_find("glNormalStream3bATI", lib);
	GL_CHECK(gl.NormalStream3bATI);
	gl.NormalStream3bvATI = (void APIENTRY (*)(GLenum stream, const GLbyte *coords)) ldg_find("glNormalStream3bvATI", lib);
	GL_CHECK(gl.NormalStream3bvATI);
	gl.NormalStream3dATI = (void APIENTRY (*)(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz)) ldg_find("glNormalStream3dATI", lib);
	GL_CHECK(gl.NormalStream3dATI);
	gl.NormalStream3dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glNormalStream3dvATI", lib);
	GL_CHECK(gl.NormalStream3dvATI);
	gl.NormalStream3fATI = (void APIENTRY (*)(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz)) ldg_find("glNormalStream3fATI", lib);
	GL_CHECK(gl.NormalStream3fATI);
	gl.NormalStream3fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glNormalStream3fvATI", lib);
	GL_CHECK(gl.NormalStream3fvATI);
	gl.NormalStream3iATI = (void APIENTRY (*)(GLenum stream, GLint nx, GLint ny, GLint nz)) ldg_find("glNormalStream3iATI", lib);
	GL_CHECK(gl.NormalStream3iATI);
	gl.NormalStream3ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glNormalStream3ivATI", lib);
	GL_CHECK(gl.NormalStream3ivATI);
	gl.NormalStream3sATI = (void APIENTRY (*)(GLenum stream, GLshort32 nx, GLshort32 ny, GLshort32 nz)) ldg_find("glNormalStream3sATI", lib);
	GL_CHECK(gl.NormalStream3sATI);
	gl.NormalStream3svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glNormalStream3svATI", lib);
	GL_CHECK(gl.NormalStream3svATI);
	gl.ObjectLabel = (void APIENTRY (*)(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)) ldg_find("glObjectLabel", lib);
	GL_CHECK(gl.ObjectLabel);
	gl.ObjectPtrLabel = (void APIENTRY (*)(const void *ptr, GLsizei length, const GLchar *label)) ldg_find("glObjectPtrLabel", lib);
	GL_CHECK(gl.ObjectPtrLabel);
	gl.ObjectPurgeableAPPLE = (GLenum APIENTRY (*)(GLenum objectType, GLuint name, GLenum option)) ldg_find("glObjectPurgeableAPPLE", lib);
	GL_CHECK(gl.ObjectPurgeableAPPLE);
	gl.ObjectUnpurgeableAPPLE = (GLenum APIENTRY (*)(GLenum objectType, GLuint name, GLenum option)) ldg_find("glObjectUnpurgeableAPPLE", lib);
	GL_CHECK(gl.ObjectUnpurgeableAPPLE);
	gl.Ortho = (void APIENTRY (*)(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)) ldg_find("glOrthod", lib);
	GL_CHECK(gl.Ortho);
	gl.Orthof = (void APIENTRY (*)(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat near_val, GLfloat far_val)) ldg_find("glOrtho", lib);
	GL_CHECK(gl.Orthof);
	gl.OrthofOES = (void APIENTRY (*)(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)) ldg_find("glOrthofOES", lib);
	GL_CHECK(gl.OrthofOES);
	gl.OrthoxOES = (void APIENTRY (*)(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)) ldg_find("glOrthoxOES", lib);
	GL_CHECK(gl.OrthoxOES);
	gl.PNTrianglesfATI = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPNTrianglesfATI", lib);
	GL_CHECK(gl.PNTrianglesfATI);
	gl.PNTrianglesiATI = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPNTrianglesiATI", lib);
	GL_CHECK(gl.PNTrianglesiATI);
	gl.PassTexCoordATI = (void APIENTRY (*)(GLuint dst, GLuint coord, GLenum swizzle)) ldg_find("glPassTexCoordATI", lib);
	GL_CHECK(gl.PassTexCoordATI);
	gl.PassThrough = (void APIENTRY (*)(GLfloat token)) ldg_find("glPassThrough", lib);
	GL_CHECK(gl.PassThrough);
	gl.PassThroughxOES = (void APIENTRY (*)(GLfixed token)) ldg_find("glPassThroughxOES", lib);
	GL_CHECK(gl.PassThroughxOES);
	gl.PatchParameterfv = (void APIENTRY (*)(GLenum pname, const GLfloat *values)) ldg_find("glPatchParameterfv", lib);
	GL_CHECK(gl.PatchParameterfv);
	gl.PatchParameteri = (void APIENTRY (*)(GLenum pname, GLint value)) ldg_find("glPatchParameteri", lib);
	GL_CHECK(gl.PatchParameteri);
	gl.PathColorGenNV = (void APIENTRY (*)(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs)) ldg_find("glPathColorGenNV", lib);
	GL_CHECK(gl.PathColorGenNV);
	gl.PathCommandsNV = (void APIENTRY (*)(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathCommandsNV", lib);
	GL_CHECK(gl.PathCommandsNV);
	gl.PathCoordsNV = (void APIENTRY (*)(GLuint path, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathCoordsNV", lib);
	GL_CHECK(gl.PathCoordsNV);
	gl.PathCoverDepthFuncNV = (void APIENTRY (*)(GLenum func)) ldg_find("glPathCoverDepthFuncNV", lib);
	GL_CHECK(gl.PathCoverDepthFuncNV);
	gl.PathDashArrayNV = (void APIENTRY (*)(GLuint path, GLsizei dashCount, const GLfloat *dashArray)) ldg_find("glPathDashArrayNV", lib);
	GL_CHECK(gl.PathDashArrayNV);
	gl.PathFogGenNV = (void APIENTRY (*)(GLenum genMode)) ldg_find("glPathFogGenNV", lib);
	GL_CHECK(gl.PathFogGenNV);
	gl.PathGlyphRangeNV = (void APIENTRY (*)(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)) ldg_find("glPathGlyphRangeNV", lib);
	GL_CHECK(gl.PathGlyphRangeNV);
	gl.PathGlyphsNV = (void APIENTRY (*)(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)) ldg_find("glPathGlyphsNV", lib);
	GL_CHECK(gl.PathGlyphsNV);
	gl.PathParameterfNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLfloat value)) ldg_find("glPathParameterfNV", lib);
	GL_CHECK(gl.PathParameterfNV);
	gl.PathParameterfvNV = (void APIENTRY (*)(GLuint path, GLenum pname, const GLfloat *value)) ldg_find("glPathParameterfvNV", lib);
	GL_CHECK(gl.PathParameterfvNV);
	gl.PathParameteriNV = (void APIENTRY (*)(GLuint path, GLenum pname, GLint value)) ldg_find("glPathParameteriNV", lib);
	GL_CHECK(gl.PathParameteriNV);
	gl.PathParameterivNV = (void APIENTRY (*)(GLuint path, GLenum pname, const GLint *value)) ldg_find("glPathParameterivNV", lib);
	GL_CHECK(gl.PathParameterivNV);
	gl.PathStencilDepthOffsetNV = (void APIENTRY (*)(GLfloat factor, GLfloat units)) ldg_find("glPathStencilDepthOffsetNV", lib);
	GL_CHECK(gl.PathStencilDepthOffsetNV);
	gl.PathStencilFuncNV = (void APIENTRY (*)(GLenum func, GLint ref, GLuint mask)) ldg_find("glPathStencilFuncNV", lib);
	GL_CHECK(gl.PathStencilFuncNV);
	gl.PathStringNV = (void APIENTRY (*)(GLuint path, GLenum format, GLsizei length, const void *pathString)) ldg_find("glPathStringNV", lib);
	GL_CHECK(gl.PathStringNV);
	gl.PathSubCommandsNV = (void APIENTRY (*)(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathSubCommandsNV", lib);
	GL_CHECK(gl.PathSubCommandsNV);
	gl.PathSubCoordsNV = (void APIENTRY (*)(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords)) ldg_find("glPathSubCoordsNV", lib);
	GL_CHECK(gl.PathSubCoordsNV);
	gl.PathTexGenNV = (void APIENTRY (*)(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs)) ldg_find("glPathTexGenNV", lib);
	GL_CHECK(gl.PathTexGenNV);
	gl.PauseTransformFeedback = (void APIENTRY (*)(void)) ldg_find("glPauseTransformFeedback", lib);
	GL_CHECK(gl.PauseTransformFeedback);
	gl.PauseTransformFeedbackNV = (void APIENTRY (*)(void)) ldg_find("glPauseTransformFeedbackNV", lib);
	GL_CHECK(gl.PauseTransformFeedbackNV);
	gl.PixelDataRangeNV = (void APIENTRY (*)(GLenum target, GLsizei length, const void *pointer)) ldg_find("glPixelDataRangeNV", lib);
	GL_CHECK(gl.PixelDataRangeNV);
	gl.PixelMapfv = (void APIENTRY (*)(GLenum map, GLsizei mapsize, const GLfloat *values)) ldg_find("glPixelMapfv", lib);
	GL_CHECK(gl.PixelMapfv);
	gl.PixelMapuiv = (void APIENTRY (*)(GLenum map, GLsizei mapsize, const GLuint *values)) ldg_find("glPixelMapuiv", lib);
	GL_CHECK(gl.PixelMapuiv);
	gl.PixelMapusv = (void APIENTRY (*)(GLenum map, GLsizei mapsize, const GLushort *values)) ldg_find("glPixelMapusv", lib);
	GL_CHECK(gl.PixelMapusv);
	gl.PixelMapx = (void APIENTRY (*)(GLenum map, GLint size, const GLfixed *values)) ldg_find("glPixelMapx", lib);
	GL_CHECK(gl.PixelMapx);
	gl.PixelStoref = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPixelStoref", lib);
	GL_CHECK(gl.PixelStoref);
	gl.PixelStorei = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPixelStorei", lib);
	GL_CHECK(gl.PixelStorei);
	gl.PixelStorex = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glPixelStorex", lib);
	GL_CHECK(gl.PixelStorex);
	gl.PixelTexGenParameterfSGIS = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPixelTexGenParameterfSGIS", lib);
	GL_CHECK(gl.PixelTexGenParameterfSGIS);
	gl.PixelTexGenParameterfvSGIS = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPixelTexGenParameterfvSGIS", lib);
	GL_CHECK(gl.PixelTexGenParameterfvSGIS);
	gl.PixelTexGenParameteriSGIS = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPixelTexGenParameteriSGIS", lib);
	GL_CHECK(gl.PixelTexGenParameteriSGIS);
	gl.PixelTexGenParameterivSGIS = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glPixelTexGenParameterivSGIS", lib);
	GL_CHECK(gl.PixelTexGenParameterivSGIS);
	gl.PixelTexGenSGIX = (void APIENTRY (*)(GLenum mode)) ldg_find("glPixelTexGenSGIX", lib);
	GL_CHECK(gl.PixelTexGenSGIX);
	gl.PixelTransferf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPixelTransferf", lib);
	GL_CHECK(gl.PixelTransferf);
	gl.PixelTransferi = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPixelTransferi", lib);
	GL_CHECK(gl.PixelTransferi);
	gl.PixelTransferxOES = (void APIENTRY (*)(GLenum pname, GLfixed param)) ldg_find("glPixelTransferxOES", lib);
	GL_CHECK(gl.PixelTransferxOES);
	gl.PixelTransformParameterfEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glPixelTransformParameterfEXT", lib);
	GL_CHECK(gl.PixelTransformParameterfEXT);
	gl.PixelTransformParameterfvEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glPixelTransformParameterfvEXT", lib);
	GL_CHECK(gl.PixelTransformParameterfvEXT);
	gl.PixelTransformParameteriEXT = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glPixelTransformParameteriEXT", lib);
	GL_CHECK(gl.PixelTransformParameteriEXT);
	gl.PixelTransformParameterivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glPixelTransformParameterivEXT", lib);
	GL_CHECK(gl.PixelTransformParameterivEXT);
	gl.PixelZoom = (void APIENTRY (*)(GLfloat xfactor, GLfloat yfactor)) ldg_find("glPixelZoom", lib);
	GL_CHECK(gl.PixelZoom);
	gl.PixelZoomxOES = (void APIENTRY (*)(GLfixed xfactor, GLfixed yfactor)) ldg_find("glPixelZoomxOES", lib);
	GL_CHECK(gl.PixelZoomxOES);
	gl.PointAlongPathNV = (GLboolean APIENTRY (*)(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY)) ldg_find("glPointAlongPathNV", lib);
	GL_CHECK(gl.PointAlongPathNV);
	gl.PointParameterf = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterf", lib);
	GL_CHECK(gl.PointParameterf);
	gl.PointParameterfARB = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterfARB", lib);
	GL_CHECK(gl.PointParameterfARB);
	gl.PointParameterfEXT = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterfEXT", lib);
	GL_CHECK(gl.PointParameterfEXT);
	gl.PointParameterfSGIS = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glPointParameterfSGIS", lib);
	GL_CHECK(gl.PointParameterfSGIS);
	gl.PointParameterfv = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfv", lib);
	GL_CHECK(gl.PointParameterfv);
	gl.PointParameterfvARB = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfvARB", lib);
	GL_CHECK(gl.PointParameterfvARB);
	gl.PointParameterfvEXT = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfvEXT", lib);
	GL_CHECK(gl.PointParameterfvEXT);
	gl.PointParameterfvSGIS = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glPointParameterfvSGIS", lib);
	GL_CHECK(gl.PointParameterfvSGIS);
	gl.PointParameteri = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPointParameteri", lib);
	GL_CHECK(gl.PointParameteri);
	gl.PointParameteriNV = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glPointParameteriNV", lib);
	GL_CHECK(gl.PointParameteriNV);
	gl.PointParameteriv = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glPointParameteriv", lib);
	GL_CHECK(gl.PointParameteriv);
	gl.PointParameterivNV = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glPointParameterivNV", lib);
	GL_CHECK(gl.PointParameterivNV);
	gl.PointParameterxvOES = (void APIENTRY (*)(GLenum pname, const GLfixed *params)) ldg_find("glPointParameterxvOES", lib);
	GL_CHECK(gl.PointParameterxvOES);
	gl.PointSize = (void APIENTRY (*)(GLfloat size)) ldg_find("glPointSize", lib);
	GL_CHECK(gl.PointSize);
	gl.PointSizePointerAPPLE = (void APIENTRY (*)(GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glPointSizePointerAPPLE", lib);
	GL_CHECK(gl.PointSizePointerAPPLE);
	gl.PointSizexOES = (void APIENTRY (*)(GLfixed size)) ldg_find("glPointSizexOES", lib);
	GL_CHECK(gl.PointSizexOES);
	gl.PollAsyncSGIX = (GLint APIENTRY (*)(GLuint *markerp)) ldg_find("glPollAsyncSGIX", lib);
	GL_CHECK(gl.PollAsyncSGIX);
	gl.PollInstrumentsSGIX = (GLint APIENTRY (*)(GLint *marker_p)) ldg_find("glPollInstrumentsSGIX", lib);
	GL_CHECK(gl.PollInstrumentsSGIX);
	gl.PolygonMode = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glPolygonMode", lib);
	GL_CHECK(gl.PolygonMode);
	gl.PolygonOffset = (void APIENTRY (*)(GLfloat factor, GLfloat units)) ldg_find("glPolygonOffset", lib);
	GL_CHECK(gl.PolygonOffset);
	gl.PolygonOffsetEXT = (void APIENTRY (*)(GLfloat factor, GLfloat bias)) ldg_find("glPolygonOffsetEXT", lib);
	GL_CHECK(gl.PolygonOffsetEXT);
	gl.PolygonOffsetxOES = (void APIENTRY (*)(GLfixed factor, GLfixed units)) ldg_find("glPolygonOffsetxOES", lib);
	GL_CHECK(gl.PolygonOffsetxOES);
	gl.PolygonStipple = (void APIENTRY (*)(const GLubyte *mask)) ldg_find("glPolygonStipple", lib);
	GL_CHECK(gl.PolygonStipple);
	gl.PopAttrib = (void APIENTRY (*)(void)) ldg_find("glPopAttrib", lib);
	GL_CHECK(gl.PopAttrib);
	gl.PopClientAttrib = (void APIENTRY (*)(void)) ldg_find("glPopClientAttrib", lib);
	GL_CHECK(gl.PopClientAttrib);
	gl.PopDebugGroup = (void APIENTRY (*)(void)) ldg_find("glPopDebugGroup", lib);
	GL_CHECK(gl.PopDebugGroup);
	gl.PopGroupMarkerEXT = (void APIENTRY (*)(void)) ldg_find("glPopGroupMarkerEXT", lib);
	GL_CHECK(gl.PopGroupMarkerEXT);
	gl.PopMatrix = (void APIENTRY (*)(void)) ldg_find("glPopMatrix", lib);
	GL_CHECK(gl.PopMatrix);
	gl.PopName = (void APIENTRY (*)(void)) ldg_find("glPopName", lib);
	GL_CHECK(gl.PopName);
	gl.PresentFrameDualFillNV = (void APIENTRY (*)(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3)) ldg_find("glPresentFrameDualFillNV", lib);
	GL_CHECK(gl.PresentFrameDualFillNV);
	gl.PresentFrameKeyedNV = (void APIENTRY (*)(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1)) ldg_find("glPresentFrameKeyedNV", lib);
	GL_CHECK(gl.PresentFrameKeyedNV);
	gl.PrimitiveRestartIndex = (void APIENTRY (*)(GLuint index)) ldg_find("glPrimitiveRestartIndex", lib);
	GL_CHECK(gl.PrimitiveRestartIndex);
	gl.PrimitiveRestartIndexNV = (void APIENTRY (*)(GLuint index)) ldg_find("glPrimitiveRestartIndexNV", lib);
	GL_CHECK(gl.PrimitiveRestartIndexNV);
	gl.PrimitiveRestartNV = (void APIENTRY (*)(void)) ldg_find("glPrimitiveRestartNV", lib);
	GL_CHECK(gl.PrimitiveRestartNV);
	gl.PrioritizeTextures = (void APIENTRY (*)(GLsizei n, const GLuint *textures, const GLclampf *priorities)) ldg_find("glPrioritizeTextures", lib);
	GL_CHECK(gl.PrioritizeTextures);
	gl.PrioritizeTexturesEXT = (void APIENTRY (*)(GLsizei n, const GLuint *textures, const GLclampf *priorities)) ldg_find("glPrioritizeTexturesEXT", lib);
	GL_CHECK(gl.PrioritizeTexturesEXT);
	gl.PrioritizeTexturesxOES = (void APIENTRY (*)(GLsizei n, const GLuint *textures, const GLfixed *priorities)) ldg_find("glPrioritizeTexturesxOES", lib);
	GL_CHECK(gl.PrioritizeTexturesxOES);
	gl.ProgramBinary = (void APIENTRY (*)(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length)) ldg_find("glProgramBinary", lib);
	GL_CHECK(gl.ProgramBinary);
	gl.ProgramBufferParametersIivNV = (void APIENTRY (*)(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLint *params)) ldg_find("glProgramBufferParametersIivNV", lib);
	GL_CHECK(gl.ProgramBufferParametersIivNV);
	gl.ProgramBufferParametersIuivNV = (void APIENTRY (*)(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLuint *params)) ldg_find("glProgramBufferParametersIuivNV", lib);
	GL_CHECK(gl.ProgramBufferParametersIuivNV);
	gl.ProgramBufferParametersfvNV = (void APIENTRY (*)(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLfloat *params)) ldg_find("glProgramBufferParametersfvNV", lib);
	GL_CHECK(gl.ProgramBufferParametersfvNV);
	gl.ProgramCallbackMESA = (void APIENTRY (*)(GLenum target, GLprogramcallbackMESA callback, GLvoid *data)) ldg_find("glProgramCallbackMESA", lib);
	GL_CHECK(gl.ProgramCallbackMESA);
	gl.ProgramEnvParameter4dARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramEnvParameter4dARB", lib);
	GL_CHECK(gl.ProgramEnvParameter4dARB);
	gl.ProgramEnvParameter4dvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLdouble *params)) ldg_find("glProgramEnvParameter4dvARB", lib);
	GL_CHECK(gl.ProgramEnvParameter4dvARB);
	gl.ProgramEnvParameter4fARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramEnvParameter4fARB", lib);
	GL_CHECK(gl.ProgramEnvParameter4fARB);
	gl.ProgramEnvParameter4fvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLfloat *params)) ldg_find("glProgramEnvParameter4fvARB", lib);
	GL_CHECK(gl.ProgramEnvParameter4fvARB);
	gl.ProgramEnvParameterI4iNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glProgramEnvParameterI4iNV", lib);
	GL_CHECK(gl.ProgramEnvParameterI4iNV);
	gl.ProgramEnvParameterI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLint *params)) ldg_find("glProgramEnvParameterI4ivNV", lib);
	GL_CHECK(gl.ProgramEnvParameterI4ivNV);
	gl.ProgramEnvParameterI4uiNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glProgramEnvParameterI4uiNV", lib);
	GL_CHECK(gl.ProgramEnvParameterI4uiNV);
	gl.ProgramEnvParameterI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLuint *params)) ldg_find("glProgramEnvParameterI4uivNV", lib);
	GL_CHECK(gl.ProgramEnvParameterI4uivNV);
	gl.ProgramEnvParameters4fvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLfloat *params)) ldg_find("glProgramEnvParameters4fvEXT", lib);
	GL_CHECK(gl.ProgramEnvParameters4fvEXT);
	gl.ProgramEnvParametersI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLint *params)) ldg_find("glProgramEnvParametersI4ivNV", lib);
	GL_CHECK(gl.ProgramEnvParametersI4ivNV);
	gl.ProgramEnvParametersI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLuint *params)) ldg_find("glProgramEnvParametersI4uivNV", lib);
	GL_CHECK(gl.ProgramEnvParametersI4uivNV);
	gl.ProgramLocalParameter4dARB = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramLocalParameter4dARB", lib);
	GL_CHECK(gl.ProgramLocalParameter4dARB);
	gl.ProgramLocalParameter4dvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLdouble *params)) ldg_find("glProgramLocalParameter4dvARB", lib);
	GL_CHECK(gl.ProgramLocalParameter4dvARB);
	gl.ProgramLocalParameter4fARB = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramLocalParameter4fARB", lib);
	GL_CHECK(gl.ProgramLocalParameter4fARB);
	gl.ProgramLocalParameter4fvARB = (void APIENTRY (*)(GLenum target, GLuint index, const GLfloat *params)) ldg_find("glProgramLocalParameter4fvARB", lib);
	GL_CHECK(gl.ProgramLocalParameter4fvARB);
	gl.ProgramLocalParameterI4iNV = (void APIENTRY (*)(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glProgramLocalParameterI4iNV", lib);
	GL_CHECK(gl.ProgramLocalParameterI4iNV);
	gl.ProgramLocalParameterI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLint *params)) ldg_find("glProgramLocalParameterI4ivNV", lib);
	GL_CHECK(gl.ProgramLocalParameterI4ivNV);
	gl.ProgramLocalParameterI4uiNV = (void APIENTRY (*)(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glProgramLocalParameterI4uiNV", lib);
	GL_CHECK(gl.ProgramLocalParameterI4uiNV);
	gl.ProgramLocalParameterI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLuint *params)) ldg_find("glProgramLocalParameterI4uivNV", lib);
	GL_CHECK(gl.ProgramLocalParameterI4uivNV);
	gl.ProgramLocalParameters4fvEXT = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLfloat *params)) ldg_find("glProgramLocalParameters4fvEXT", lib);
	GL_CHECK(gl.ProgramLocalParameters4fvEXT);
	gl.ProgramLocalParametersI4ivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLint *params)) ldg_find("glProgramLocalParametersI4ivNV", lib);
	GL_CHECK(gl.ProgramLocalParametersI4ivNV);
	gl.ProgramLocalParametersI4uivNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLuint *params)) ldg_find("glProgramLocalParametersI4uivNV", lib);
	GL_CHECK(gl.ProgramLocalParametersI4uivNV);
	gl.ProgramNamedParameter4dNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramNamedParameter4dNV", lib);
	GL_CHECK(gl.ProgramNamedParameter4dNV);
	gl.ProgramNamedParameter4dvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v)) ldg_find("glProgramNamedParameter4dvNV", lib);
	GL_CHECK(gl.ProgramNamedParameter4dvNV);
	gl.ProgramNamedParameter4fNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramNamedParameter4fNV", lib);
	GL_CHECK(gl.ProgramNamedParameter4fNV);
	gl.ProgramNamedParameter4fvNV = (void APIENTRY (*)(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v)) ldg_find("glProgramNamedParameter4fvNV", lib);
	GL_CHECK(gl.ProgramNamedParameter4fvNV);
	gl.ProgramParameter4dNV = (void APIENTRY (*)(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramParameter4dNV", lib);
	GL_CHECK(gl.ProgramParameter4dNV);
	gl.ProgramParameter4dvNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLdouble *v)) ldg_find("glProgramParameter4dvNV", lib);
	GL_CHECK(gl.ProgramParameter4dvNV);
	gl.ProgramParameter4fNV = (void APIENTRY (*)(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glProgramParameter4fNV", lib);
	GL_CHECK(gl.ProgramParameter4fNV);
	gl.ProgramParameter4fvNV = (void APIENTRY (*)(GLenum target, GLuint index, const GLfloat *v)) ldg_find("glProgramParameter4fvNV", lib);
	GL_CHECK(gl.ProgramParameter4fvNV);
	gl.ProgramParameteri = (void APIENTRY (*)(GLuint program, GLenum pname, GLint value)) ldg_find("glProgramParameteri", lib);
	GL_CHECK(gl.ProgramParameteri);
	gl.ProgramParameteriARB = (void APIENTRY (*)(GLuint program, GLenum pname, GLint value)) ldg_find("glProgramParameteriARB", lib);
	GL_CHECK(gl.ProgramParameteriARB);
	gl.ProgramParameteriEXT = (void APIENTRY (*)(GLuint program, GLenum pname, GLint value)) ldg_find("glProgramParameteriEXT", lib);
	GL_CHECK(gl.ProgramParameteriEXT);
	gl.ProgramParameters4dvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glProgramParameters4dvNV", lib);
	GL_CHECK(gl.ProgramParameters4dvNV);
	gl.ProgramParameters4fvNV = (void APIENTRY (*)(GLenum target, GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glProgramParameters4fvNV", lib);
	GL_CHECK(gl.ProgramParameters4fvNV);
	gl.ProgramStringARB = (void APIENTRY (*)(GLenum target, GLenum format, GLsizei len, const void *string)) ldg_find("glProgramStringARB", lib);
	GL_CHECK(gl.ProgramStringARB);
	gl.ProgramSubroutineParametersuivNV = (void APIENTRY (*)(GLenum target, GLsizei count, const GLuint *params)) ldg_find("glProgramSubroutineParametersuivNV", lib);
	GL_CHECK(gl.ProgramSubroutineParametersuivNV);
	gl.ProgramUniform1d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0)) ldg_find("glProgramUniform1d", lib);
	GL_CHECK(gl.ProgramUniform1d);
	gl.ProgramUniform1dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x)) ldg_find("glProgramUniform1dEXT", lib);
	GL_CHECK(gl.ProgramUniform1dEXT);
	gl.ProgramUniform1dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform1dv", lib);
	GL_CHECK(gl.ProgramUniform1dv);
	gl.ProgramUniform1dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform1dvEXT", lib);
	GL_CHECK(gl.ProgramUniform1dvEXT);
	gl.ProgramUniform1f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0)) ldg_find("glProgramUniform1f", lib);
	GL_CHECK(gl.ProgramUniform1f);
	gl.ProgramUniform1fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0)) ldg_find("glProgramUniform1fEXT", lib);
	GL_CHECK(gl.ProgramUniform1fEXT);
	gl.ProgramUniform1fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform1fv", lib);
	GL_CHECK(gl.ProgramUniform1fv);
	gl.ProgramUniform1fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform1fvEXT", lib);
	GL_CHECK(gl.ProgramUniform1fvEXT);
	gl.ProgramUniform1i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0)) ldg_find("glProgramUniform1i", lib);
	GL_CHECK(gl.ProgramUniform1i);
	gl.ProgramUniform1i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x)) ldg_find("glProgramUniform1i64NV", lib);
	GL_CHECK(gl.ProgramUniform1i64NV);
	gl.ProgramUniform1i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform1i64vNV", lib);
	GL_CHECK(gl.ProgramUniform1i64vNV);
	gl.ProgramUniform1iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0)) ldg_find("glProgramUniform1iEXT", lib);
	GL_CHECK(gl.ProgramUniform1iEXT);
	gl.ProgramUniform1iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform1iv", lib);
	GL_CHECK(gl.ProgramUniform1iv);
	gl.ProgramUniform1ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform1ivEXT", lib);
	GL_CHECK(gl.ProgramUniform1ivEXT);
	gl.ProgramUniform1ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0)) ldg_find("glProgramUniform1ui", lib);
	GL_CHECK(gl.ProgramUniform1ui);
	gl.ProgramUniform1ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x)) ldg_find("glProgramUniform1ui64NV", lib);
	GL_CHECK(gl.ProgramUniform1ui64NV);
	gl.ProgramUniform1ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform1ui64vNV", lib);
	GL_CHECK(gl.ProgramUniform1ui64vNV);
	gl.ProgramUniform1uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0)) ldg_find("glProgramUniform1uiEXT", lib);
	GL_CHECK(gl.ProgramUniform1uiEXT);
	gl.ProgramUniform1uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform1uiv", lib);
	GL_CHECK(gl.ProgramUniform1uiv);
	gl.ProgramUniform1uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform1uivEXT", lib);
	GL_CHECK(gl.ProgramUniform1uivEXT);
	gl.ProgramUniform2d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0, GLdouble v1)) ldg_find("glProgramUniform2d", lib);
	GL_CHECK(gl.ProgramUniform2d);
	gl.ProgramUniform2dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x, GLdouble y)) ldg_find("glProgramUniform2dEXT", lib);
	GL_CHECK(gl.ProgramUniform2dEXT);
	gl.ProgramUniform2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform2dv", lib);
	GL_CHECK(gl.ProgramUniform2dv);
	gl.ProgramUniform2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform2dvEXT", lib);
	GL_CHECK(gl.ProgramUniform2dvEXT);
	gl.ProgramUniform2f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1)) ldg_find("glProgramUniform2f", lib);
	GL_CHECK(gl.ProgramUniform2f);
	gl.ProgramUniform2fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1)) ldg_find("glProgramUniform2fEXT", lib);
	GL_CHECK(gl.ProgramUniform2fEXT);
	gl.ProgramUniform2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform2fv", lib);
	GL_CHECK(gl.ProgramUniform2fv);
	gl.ProgramUniform2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform2fvEXT", lib);
	GL_CHECK(gl.ProgramUniform2fvEXT);
	gl.ProgramUniform2i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1)) ldg_find("glProgramUniform2i", lib);
	GL_CHECK(gl.ProgramUniform2i);
	gl.ProgramUniform2i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y)) ldg_find("glProgramUniform2i64NV", lib);
	GL_CHECK(gl.ProgramUniform2i64NV);
	gl.ProgramUniform2i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform2i64vNV", lib);
	GL_CHECK(gl.ProgramUniform2i64vNV);
	gl.ProgramUniform2iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1)) ldg_find("glProgramUniform2iEXT", lib);
	GL_CHECK(gl.ProgramUniform2iEXT);
	gl.ProgramUniform2iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform2iv", lib);
	GL_CHECK(gl.ProgramUniform2iv);
	gl.ProgramUniform2ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform2ivEXT", lib);
	GL_CHECK(gl.ProgramUniform2ivEXT);
	gl.ProgramUniform2ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1)) ldg_find("glProgramUniform2ui", lib);
	GL_CHECK(gl.ProgramUniform2ui);
	gl.ProgramUniform2ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y)) ldg_find("glProgramUniform2ui64NV", lib);
	GL_CHECK(gl.ProgramUniform2ui64NV);
	gl.ProgramUniform2ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform2ui64vNV", lib);
	GL_CHECK(gl.ProgramUniform2ui64vNV);
	gl.ProgramUniform2uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1)) ldg_find("glProgramUniform2uiEXT", lib);
	GL_CHECK(gl.ProgramUniform2uiEXT);
	gl.ProgramUniform2uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform2uiv", lib);
	GL_CHECK(gl.ProgramUniform2uiv);
	gl.ProgramUniform2uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform2uivEXT", lib);
	GL_CHECK(gl.ProgramUniform2uivEXT);
	gl.ProgramUniform3d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)) ldg_find("glProgramUniform3d", lib);
	GL_CHECK(gl.ProgramUniform3d);
	gl.ProgramUniform3dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glProgramUniform3dEXT", lib);
	GL_CHECK(gl.ProgramUniform3dEXT);
	gl.ProgramUniform3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform3dv", lib);
	GL_CHECK(gl.ProgramUniform3dv);
	gl.ProgramUniform3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform3dvEXT", lib);
	GL_CHECK(gl.ProgramUniform3dvEXT);
	gl.ProgramUniform3f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glProgramUniform3f", lib);
	GL_CHECK(gl.ProgramUniform3f);
	gl.ProgramUniform3fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glProgramUniform3fEXT", lib);
	GL_CHECK(gl.ProgramUniform3fEXT);
	gl.ProgramUniform3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform3fv", lib);
	GL_CHECK(gl.ProgramUniform3fv);
	gl.ProgramUniform3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform3fvEXT", lib);
	GL_CHECK(gl.ProgramUniform3fvEXT);
	gl.ProgramUniform3i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glProgramUniform3i", lib);
	GL_CHECK(gl.ProgramUniform3i);
	gl.ProgramUniform3i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)) ldg_find("glProgramUniform3i64NV", lib);
	GL_CHECK(gl.ProgramUniform3i64NV);
	gl.ProgramUniform3i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform3i64vNV", lib);
	GL_CHECK(gl.ProgramUniform3i64vNV);
	gl.ProgramUniform3iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glProgramUniform3iEXT", lib);
	GL_CHECK(gl.ProgramUniform3iEXT);
	gl.ProgramUniform3iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform3iv", lib);
	GL_CHECK(gl.ProgramUniform3iv);
	gl.ProgramUniform3ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform3ivEXT", lib);
	GL_CHECK(gl.ProgramUniform3ivEXT);
	gl.ProgramUniform3ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glProgramUniform3ui", lib);
	GL_CHECK(gl.ProgramUniform3ui);
	gl.ProgramUniform3ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)) ldg_find("glProgramUniform3ui64NV", lib);
	GL_CHECK(gl.ProgramUniform3ui64NV);
	gl.ProgramUniform3ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform3ui64vNV", lib);
	GL_CHECK(gl.ProgramUniform3ui64vNV);
	gl.ProgramUniform3uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glProgramUniform3uiEXT", lib);
	GL_CHECK(gl.ProgramUniform3uiEXT);
	gl.ProgramUniform3uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform3uiv", lib);
	GL_CHECK(gl.ProgramUniform3uiv);
	gl.ProgramUniform3uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform3uivEXT", lib);
	GL_CHECK(gl.ProgramUniform3uivEXT);
	gl.ProgramUniform4d = (void APIENTRY (*)(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3)) ldg_find("glProgramUniform4d", lib);
	GL_CHECK(gl.ProgramUniform4d);
	gl.ProgramUniform4dEXT = (void APIENTRY (*)(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glProgramUniform4dEXT", lib);
	GL_CHECK(gl.ProgramUniform4dEXT);
	gl.ProgramUniform4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform4dv", lib);
	GL_CHECK(gl.ProgramUniform4dv);
	gl.ProgramUniform4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLdouble *value)) ldg_find("glProgramUniform4dvEXT", lib);
	GL_CHECK(gl.ProgramUniform4dvEXT);
	gl.ProgramUniform4f = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glProgramUniform4f", lib);
	GL_CHECK(gl.ProgramUniform4f);
	gl.ProgramUniform4fEXT = (void APIENTRY (*)(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glProgramUniform4fEXT", lib);
	GL_CHECK(gl.ProgramUniform4fEXT);
	gl.ProgramUniform4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform4fv", lib);
	GL_CHECK(gl.ProgramUniform4fv);
	gl.ProgramUniform4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLfloat *value)) ldg_find("glProgramUniform4fvEXT", lib);
	GL_CHECK(gl.ProgramUniform4fvEXT);
	gl.ProgramUniform4i = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glProgramUniform4i", lib);
	GL_CHECK(gl.ProgramUniform4i);
	gl.ProgramUniform4i64NV = (void APIENTRY (*)(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)) ldg_find("glProgramUniform4i64NV", lib);
	GL_CHECK(gl.ProgramUniform4i64NV);
	gl.ProgramUniform4i64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glProgramUniform4i64vNV", lib);
	GL_CHECK(gl.ProgramUniform4i64vNV);
	gl.ProgramUniform4iEXT = (void APIENTRY (*)(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glProgramUniform4iEXT", lib);
	GL_CHECK(gl.ProgramUniform4iEXT);
	gl.ProgramUniform4iv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform4iv", lib);
	GL_CHECK(gl.ProgramUniform4iv);
	gl.ProgramUniform4ivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLint *value)) ldg_find("glProgramUniform4ivEXT", lib);
	GL_CHECK(gl.ProgramUniform4ivEXT);
	gl.ProgramUniform4ui = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glProgramUniform4ui", lib);
	GL_CHECK(gl.ProgramUniform4ui);
	gl.ProgramUniform4ui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)) ldg_find("glProgramUniform4ui64NV", lib);
	GL_CHECK(gl.ProgramUniform4ui64NV);
	gl.ProgramUniform4ui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniform4ui64vNV", lib);
	GL_CHECK(gl.ProgramUniform4ui64vNV);
	gl.ProgramUniform4uiEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glProgramUniform4uiEXT", lib);
	GL_CHECK(gl.ProgramUniform4uiEXT);
	gl.ProgramUniform4uiv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform4uiv", lib);
	GL_CHECK(gl.ProgramUniform4uiv);
	gl.ProgramUniform4uivEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint *value)) ldg_find("glProgramUniform4uivEXT", lib);
	GL_CHECK(gl.ProgramUniform4uivEXT);
	gl.ProgramUniformHandleui64ARB = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 value)) ldg_find("glProgramUniformHandleui64ARB", lib);
	GL_CHECK(gl.ProgramUniformHandleui64ARB);
	gl.ProgramUniformHandleui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64 value)) ldg_find("glProgramUniformHandleui64NV", lib);
	GL_CHECK(gl.ProgramUniformHandleui64NV);
	gl.ProgramUniformHandleui64vARB = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *values)) ldg_find("glProgramUniformHandleui64vARB", lib);
	GL_CHECK(gl.ProgramUniformHandleui64vARB);
	gl.ProgramUniformHandleui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64 *values)) ldg_find("glProgramUniformHandleui64vNV", lib);
	GL_CHECK(gl.ProgramUniformHandleui64vNV);
	gl.ProgramUniformMatrix2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix2dv);
	gl.ProgramUniformMatrix2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix2dvEXT);
	gl.ProgramUniformMatrix2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix2fv);
	gl.ProgramUniformMatrix2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix2fvEXT);
	gl.ProgramUniformMatrix2x3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x3dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x3dv);
	gl.ProgramUniformMatrix2x3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x3dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x3dvEXT);
	gl.ProgramUniformMatrix2x3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x3fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x3fv);
	gl.ProgramUniformMatrix2x3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x3fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x3fvEXT);
	gl.ProgramUniformMatrix2x4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x4dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x4dv);
	gl.ProgramUniformMatrix2x4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix2x4dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x4dvEXT);
	gl.ProgramUniformMatrix2x4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x4fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x4fv);
	gl.ProgramUniformMatrix2x4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix2x4fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix2x4fvEXT);
	gl.ProgramUniformMatrix3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix3dv);
	gl.ProgramUniformMatrix3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix3dvEXT);
	gl.ProgramUniformMatrix3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix3fv);
	gl.ProgramUniformMatrix3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix3fvEXT);
	gl.ProgramUniformMatrix3x2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x2dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x2dv);
	gl.ProgramUniformMatrix3x2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x2dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x2dvEXT);
	gl.ProgramUniformMatrix3x2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x2fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x2fv);
	gl.ProgramUniformMatrix3x2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x2fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x2fvEXT);
	gl.ProgramUniformMatrix3x4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x4dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x4dv);
	gl.ProgramUniformMatrix3x4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix3x4dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x4dvEXT);
	gl.ProgramUniformMatrix3x4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x4fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x4fv);
	gl.ProgramUniformMatrix3x4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix3x4fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix3x4fvEXT);
	gl.ProgramUniformMatrix4dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix4dv);
	gl.ProgramUniformMatrix4dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix4dvEXT);
	gl.ProgramUniformMatrix4fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix4fv);
	gl.ProgramUniformMatrix4fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix4fvEXT);
	gl.ProgramUniformMatrix4x2dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x2dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x2dv);
	gl.ProgramUniformMatrix4x2dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x2dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x2dvEXT);
	gl.ProgramUniformMatrix4x2fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x2fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x2fv);
	gl.ProgramUniformMatrix4x2fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x2fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x2fvEXT);
	gl.ProgramUniformMatrix4x3dv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x3dv", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x3dv);
	gl.ProgramUniformMatrix4x3dvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glProgramUniformMatrix4x3dvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x3dvEXT);
	gl.ProgramUniformMatrix4x3fv = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x3fv", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x3fv);
	gl.ProgramUniformMatrix4x3fvEXT = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glProgramUniformMatrix4x3fvEXT", lib);
	GL_CHECK(gl.ProgramUniformMatrix4x3fvEXT);
	gl.ProgramUniformui64NV = (void APIENTRY (*)(GLuint program, GLint location, GLuint64EXT value)) ldg_find("glProgramUniformui64NV", lib);
	GL_CHECK(gl.ProgramUniformui64NV);
	gl.ProgramUniformui64vNV = (void APIENTRY (*)(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glProgramUniformui64vNV", lib);
	GL_CHECK(gl.ProgramUniformui64vNV);
	gl.ProgramVertexLimitNV = (void APIENTRY (*)(GLenum target, GLint limit)) ldg_find("glProgramVertexLimitNV", lib);
	GL_CHECK(gl.ProgramVertexLimitNV);
	gl.ProvokingVertex = (void APIENTRY (*)(GLenum mode)) ldg_find("glProvokingVertex", lib);
	GL_CHECK(gl.ProvokingVertex);
	gl.ProvokingVertexEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glProvokingVertexEXT", lib);
	GL_CHECK(gl.ProvokingVertexEXT);
	gl.PushAttrib = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glPushAttrib", lib);
	GL_CHECK(gl.PushAttrib);
	gl.PushClientAttrib = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glPushClientAttrib", lib);
	GL_CHECK(gl.PushClientAttrib);
	gl.PushClientAttribDefaultEXT = (void APIENTRY (*)(GLbitfield mask)) ldg_find("glPushClientAttribDefaultEXT", lib);
	GL_CHECK(gl.PushClientAttribDefaultEXT);
	gl.PushDebugGroup = (void APIENTRY (*)(GLenum source, GLuint id, GLsizei length, const GLchar *message)) ldg_find("glPushDebugGroup", lib);
	GL_CHECK(gl.PushDebugGroup);
	gl.PushGroupMarkerEXT = (void APIENTRY (*)(GLsizei length, const GLchar *marker)) ldg_find("glPushGroupMarkerEXT", lib);
	GL_CHECK(gl.PushGroupMarkerEXT);
	gl.PushMatrix = (void APIENTRY (*)(void)) ldg_find("glPushMatrix", lib);
	GL_CHECK(gl.PushMatrix);
	gl.PushName = (void APIENTRY (*)(GLuint name)) ldg_find("glPushName", lib);
	GL_CHECK(gl.PushName);
	gl.QueryCounter = (void APIENTRY (*)(GLuint id, GLenum target)) ldg_find("glQueryCounter", lib);
	GL_CHECK(gl.QueryCounter);
	gl.QueryMatrixxOES = (GLbitfield APIENTRY (*)(GLfixed *mantissa, GLint *exponent)) ldg_find("glQueryMatrixxOES", lib);
	GL_CHECK(gl.QueryMatrixxOES);
	gl.QueryObjectParameteruiAMD = (void APIENTRY (*)(GLenum target, GLuint id, GLenum pname, GLuint param)) ldg_find("glQueryObjectParameteruiAMD", lib);
	GL_CHECK(gl.QueryObjectParameteruiAMD);
	gl.RasterPos2d = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glRasterPos2d", lib);
	GL_CHECK(gl.RasterPos2d);
	gl.RasterPos2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glRasterPos2dv", lib);
	GL_CHECK(gl.RasterPos2dv);
	gl.RasterPos2f = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glRasterPos2f", lib);
	GL_CHECK(gl.RasterPos2f);
	gl.RasterPos2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glRasterPos2fv", lib);
	GL_CHECK(gl.RasterPos2fv);
	gl.RasterPos2i = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glRasterPos2i", lib);
	GL_CHECK(gl.RasterPos2i);
	gl.RasterPos2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glRasterPos2iv", lib);
	GL_CHECK(gl.RasterPos2iv);
	gl.RasterPos2s = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glRasterPos2s", lib);
	GL_CHECK(gl.RasterPos2s);
	gl.RasterPos2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glRasterPos2sv", lib);
	GL_CHECK(gl.RasterPos2sv);
	gl.RasterPos2xOES = (void APIENTRY (*)(GLfixed x, GLfixed y)) ldg_find("glRasterPos2xOES", lib);
	GL_CHECK(gl.RasterPos2xOES);
	gl.RasterPos2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glRasterPos2xvOES", lib);
	GL_CHECK(gl.RasterPos2xvOES);
	gl.RasterPos3d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glRasterPos3d", lib);
	GL_CHECK(gl.RasterPos3d);
	gl.RasterPos3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glRasterPos3dv", lib);
	GL_CHECK(gl.RasterPos3dv);
	gl.RasterPos3f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glRasterPos3f", lib);
	GL_CHECK(gl.RasterPos3f);
	gl.RasterPos3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glRasterPos3fv", lib);
	GL_CHECK(gl.RasterPos3fv);
	gl.RasterPos3i = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glRasterPos3i", lib);
	GL_CHECK(gl.RasterPos3i);
	gl.RasterPos3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glRasterPos3iv", lib);
	GL_CHECK(gl.RasterPos3iv);
	gl.RasterPos3s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glRasterPos3s", lib);
	GL_CHECK(gl.RasterPos3s);
	gl.RasterPos3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glRasterPos3sv", lib);
	GL_CHECK(gl.RasterPos3sv);
	gl.RasterPos3xOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glRasterPos3xOES", lib);
	GL_CHECK(gl.RasterPos3xOES);
	gl.RasterPos3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glRasterPos3xvOES", lib);
	GL_CHECK(gl.RasterPos3xvOES);
	gl.RasterPos4d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glRasterPos4d", lib);
	GL_CHECK(gl.RasterPos4d);
	gl.RasterPos4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glRasterPos4dv", lib);
	GL_CHECK(gl.RasterPos4dv);
	gl.RasterPos4f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glRasterPos4f", lib);
	GL_CHECK(gl.RasterPos4f);
	gl.RasterPos4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glRasterPos4fv", lib);
	GL_CHECK(gl.RasterPos4fv);
	gl.RasterPos4i = (void APIENTRY (*)(GLint x, GLint y, GLint z, GLint w)) ldg_find("glRasterPos4i", lib);
	GL_CHECK(gl.RasterPos4i);
	gl.RasterPos4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glRasterPos4iv", lib);
	GL_CHECK(gl.RasterPos4iv);
	gl.RasterPos4s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glRasterPos4s", lib);
	GL_CHECK(gl.RasterPos4s);
	gl.RasterPos4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glRasterPos4sv", lib);
	GL_CHECK(gl.RasterPos4sv);
	gl.RasterPos4xOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z, GLfixed w)) ldg_find("glRasterPos4xOES", lib);
	GL_CHECK(gl.RasterPos4xOES);
	gl.RasterPos4xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glRasterPos4xvOES", lib);
	GL_CHECK(gl.RasterPos4xvOES);
	gl.ReadBuffer = (void APIENTRY (*)(GLenum mode)) ldg_find("glReadBuffer", lib);
	GL_CHECK(gl.ReadBuffer);
	gl.ReadInstrumentsSGIX = (void APIENTRY (*)(GLint marker)) ldg_find("glReadInstrumentsSGIX", lib);
	GL_CHECK(gl.ReadInstrumentsSGIX);
	gl.ReadPixels = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)) ldg_find("glReadPixels", lib);
	GL_CHECK(gl.ReadPixels);
	gl.ReadnPixelsARB = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data)) ldg_find("glReadnPixelsARB", lib);
	GL_CHECK(gl.ReadnPixelsARB);
	gl.Rectd = (void APIENTRY (*)(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)) ldg_find("glRectd", lib);
	GL_CHECK(gl.Rectd);
	gl.Rectdv = (void APIENTRY (*)(const GLdouble *v1, const GLdouble *v2)) ldg_find("glRectdv", lib);
	GL_CHECK(gl.Rectdv);
	gl.Rectf = (void APIENTRY (*)(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)) ldg_find("glRectf", lib);
	GL_CHECK(gl.Rectf);
	gl.Rectfv = (void APIENTRY (*)(const GLfloat *v1, const GLfloat *v2)) ldg_find("glRectfv", lib);
	GL_CHECK(gl.Rectfv);
	gl.Recti = (void APIENTRY (*)(GLint x1, GLint y1, GLint x2, GLint y2)) ldg_find("glRecti", lib);
	GL_CHECK(gl.Recti);
	gl.Rectiv = (void APIENTRY (*)(const GLint *v1, const GLint *v2)) ldg_find("glRectiv", lib);
	GL_CHECK(gl.Rectiv);
	gl.Rects = (void APIENTRY (*)(GLshort32 x1, GLshort32 y1, GLshort32 x2, GLshort32 y2)) ldg_find("glRects", lib);
	GL_CHECK(gl.Rects);
	gl.Rectsv = (void APIENTRY (*)(const GLshort *v1, const GLshort *v2)) ldg_find("glRectsv", lib);
	GL_CHECK(gl.Rectsv);
	gl.RectxOES = (void APIENTRY (*)(GLfixed x1, GLfixed y1, GLfixed x2, GLfixed y2)) ldg_find("glRectxOES", lib);
	GL_CHECK(gl.RectxOES);
	gl.RectxvOES = (void APIENTRY (*)(const GLfixed *v1, const GLfixed *v2)) ldg_find("glRectxvOES", lib);
	GL_CHECK(gl.RectxvOES);
	gl.ReferencePlaneSGIX = (void APIENTRY (*)(const GLdouble *equation)) ldg_find("glReferencePlaneSGIX", lib);
	GL_CHECK(gl.ReferencePlaneSGIX);
	gl.ReleaseShaderCompiler = (void APIENTRY (*)(void)) ldg_find("glReleaseShaderCompiler", lib);
	GL_CHECK(gl.ReleaseShaderCompiler);
	gl.RenderMode = (GLint APIENTRY (*)(GLenum mode)) ldg_find("glRenderMode", lib);
	GL_CHECK(gl.RenderMode);
	gl.RenderbufferStorage = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorage", lib);
	GL_CHECK(gl.RenderbufferStorage);
	gl.RenderbufferStorageEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageEXT", lib);
	GL_CHECK(gl.RenderbufferStorageEXT);
	gl.RenderbufferStorageMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageMultisample", lib);
	GL_CHECK(gl.RenderbufferStorageMultisample);
	gl.RenderbufferStorageMultisampleCoverageNV = (void APIENTRY (*)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageMultisampleCoverageNV", lib);
	GL_CHECK(gl.RenderbufferStorageMultisampleCoverageNV);
	gl.RenderbufferStorageMultisampleEXT = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glRenderbufferStorageMultisampleEXT", lib);
	GL_CHECK(gl.RenderbufferStorageMultisampleEXT);
	gl.ReplacementCodePointerSUN = (void APIENTRY (*)(GLenum type, GLsizei stride, const void * *pointer)) ldg_find("glReplacementCodePointerSUN", lib);
	GL_CHECK(gl.ReplacementCodePointerSUN);
	gl.ReplacementCodeubSUN = (void APIENTRY (*)(GLubyte32 code)) ldg_find("glReplacementCodeubSUN", lib);
	GL_CHECK(gl.ReplacementCodeubSUN);
	gl.ReplacementCodeubvSUN = (void APIENTRY (*)(const GLubyte *code)) ldg_find("glReplacementCodeubvSUN", lib);
	GL_CHECK(gl.ReplacementCodeubvSUN);
	gl.ReplacementCodeuiColor3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiColor3fVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiColor3fVertex3fSUN);
	gl.ReplacementCodeuiColor3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *c, const GLfloat *v)) ldg_find("glReplacementCodeuiColor3fVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiColor3fVertex3fvSUN);
	gl.ReplacementCodeuiColor4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiColor4fNormal3fVertex3fSUN);
	gl.ReplacementCodeuiColor4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiColor4fNormal3fVertex3fvSUN);
	gl.ReplacementCodeuiColor4ubVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiColor4ubVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiColor4ubVertex3fSUN);
	gl.ReplacementCodeuiColor4ubVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLubyte *c, const GLfloat *v)) ldg_find("glReplacementCodeuiColor4ubVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiColor4ubVertex3fvSUN);
	gl.ReplacementCodeuiNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiNormal3fVertex3fSUN);
	gl.ReplacementCodeuiNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiNormal3fVertex3fvSUN);
	gl.ReplacementCodeuiSUN = (void APIENTRY (*)(GLuint code)) ldg_find("glReplacementCodeuiSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiSUN);
	gl.ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN);
	gl.ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN);
	gl.ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN);
	gl.ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v)) ldg_find("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN);
	gl.ReplacementCodeuiTexCoord2fVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiTexCoord2fVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiTexCoord2fVertex3fSUN);
	gl.ReplacementCodeuiTexCoord2fVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *tc, const GLfloat *v)) ldg_find("glReplacementCodeuiTexCoord2fVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiTexCoord2fVertex3fvSUN);
	gl.ReplacementCodeuiVertex3fSUN = (void APIENTRY (*)(GLuint rc, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glReplacementCodeuiVertex3fSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiVertex3fSUN);
	gl.ReplacementCodeuiVertex3fvSUN = (void APIENTRY (*)(const GLuint *rc, const GLfloat *v)) ldg_find("glReplacementCodeuiVertex3fvSUN", lib);
	GL_CHECK(gl.ReplacementCodeuiVertex3fvSUN);
	gl.ReplacementCodeuivSUN = (void APIENTRY (*)(const GLuint *code)) ldg_find("glReplacementCodeuivSUN", lib);
	GL_CHECK(gl.ReplacementCodeuivSUN);
	gl.ReplacementCodeusSUN = (void APIENTRY (*)(GLushort32 code)) ldg_find("glReplacementCodeusSUN", lib);
	GL_CHECK(gl.ReplacementCodeusSUN);
	gl.ReplacementCodeusvSUN = (void APIENTRY (*)(const GLushort *code)) ldg_find("glReplacementCodeusvSUN", lib);
	GL_CHECK(gl.ReplacementCodeusvSUN);
	gl.RequestResidentProgramsNV = (void APIENTRY (*)(GLsizei n, const GLuint *programs)) ldg_find("glRequestResidentProgramsNV", lib);
	GL_CHECK(gl.RequestResidentProgramsNV);
	gl.ResetHistogram = (void APIENTRY (*)(GLenum target)) ldg_find("glResetHistogram", lib);
	GL_CHECK(gl.ResetHistogram);
	gl.ResetHistogramEXT = (void APIENTRY (*)(GLenum target)) ldg_find("glResetHistogramEXT", lib);
	GL_CHECK(gl.ResetHistogramEXT);
	gl.ResetMinmax = (void APIENTRY (*)(GLenum target)) ldg_find("glResetMinmax", lib);
	GL_CHECK(gl.ResetMinmax);
	gl.ResetMinmaxEXT = (void APIENTRY (*)(GLenum target)) ldg_find("glResetMinmaxEXT", lib);
	GL_CHECK(gl.ResetMinmaxEXT);
	gl.ResizeBuffersMESA = (void APIENTRY (*)(void)) ldg_find("glResizeBuffersMESA", lib);
	GL_CHECK(gl.ResizeBuffersMESA);
	gl.ResumeTransformFeedback = (void APIENTRY (*)(void)) ldg_find("glResumeTransformFeedback", lib);
	GL_CHECK(gl.ResumeTransformFeedback);
	gl.ResumeTransformFeedbackNV = (void APIENTRY (*)(void)) ldg_find("glResumeTransformFeedbackNV", lib);
	GL_CHECK(gl.ResumeTransformFeedbackNV);
	gl.Rotated = (void APIENTRY (*)(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glRotated", lib);
	GL_CHECK(gl.Rotated);
	gl.Rotatef = (void APIENTRY (*)(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glRotatef", lib);
	GL_CHECK(gl.Rotatef);
	gl.RotatexOES = (void APIENTRY (*)(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)) ldg_find("glRotatexOES", lib);
	GL_CHECK(gl.RotatexOES);
	gl.SampleCoverage = (void APIENTRY (*)(GLfloat value, GLboolean32 invert)) ldg_find("glSampleCoverage", lib);
	GL_CHECK(gl.SampleCoverage);
	gl.SampleCoverageARB = (void APIENTRY (*)(GLfloat value, GLboolean32 invert)) ldg_find("glSampleCoverageARB", lib);
	GL_CHECK(gl.SampleCoverageARB);
	gl.SampleCoverageOES = (void APIENTRY (*)(GLfixed value, GLboolean32 invert)) ldg_find("glSampleCoverageOES", lib);
	GL_CHECK(gl.SampleCoverageOES);
	gl.SampleMapATI = (void APIENTRY (*)(GLuint dst, GLuint interp, GLenum swizzle)) ldg_find("glSampleMapATI", lib);
	GL_CHECK(gl.SampleMapATI);
	gl.SampleMaskEXT = (void APIENTRY (*)(GLclampf value, GLboolean32 invert)) ldg_find("glSampleMaskEXT", lib);
	GL_CHECK(gl.SampleMaskEXT);
	gl.SampleMaskIndexedNV = (void APIENTRY (*)(GLuint index, GLbitfield mask)) ldg_find("glSampleMaskIndexedNV", lib);
	GL_CHECK(gl.SampleMaskIndexedNV);
	gl.SampleMaskSGIS = (void APIENTRY (*)(GLclampf value, GLboolean32 invert)) ldg_find("glSampleMaskSGIS", lib);
	GL_CHECK(gl.SampleMaskSGIS);
	gl.SampleMaski = (void APIENTRY (*)(GLuint maskNumber, GLbitfield mask)) ldg_find("glSampleMaski", lib);
	GL_CHECK(gl.SampleMaski);
	gl.SamplePass = (void APIENTRY (*)(GLenum mode)) ldg_find("glSamplePass", lib);
	GL_CHECK(gl.SamplePass);
	gl.SamplePassARB = (void APIENTRY (*)(GLenum mode)) ldg_find("glSamplePassARB", lib);
	GL_CHECK(gl.SamplePassARB);
	gl.SamplePatternEXT = (void APIENTRY (*)(GLenum pattern)) ldg_find("glSamplePatternEXT", lib);
	GL_CHECK(gl.SamplePatternEXT);
	gl.SamplePatternSGIS = (void APIENTRY (*)(GLenum pattern)) ldg_find("glSamplePatternSGIS", lib);
	GL_CHECK(gl.SamplePatternSGIS);
	gl.SamplerParameterIiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLint *param)) ldg_find("glSamplerParameterIiv", lib);
	GL_CHECK(gl.SamplerParameterIiv);
	gl.SamplerParameterIuiv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLuint *param)) ldg_find("glSamplerParameterIuiv", lib);
	GL_CHECK(gl.SamplerParameterIuiv);
	gl.SamplerParameterf = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLfloat param)) ldg_find("glSamplerParameterf", lib);
	GL_CHECK(gl.SamplerParameterf);
	gl.SamplerParameterfv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLfloat *param)) ldg_find("glSamplerParameterfv", lib);
	GL_CHECK(gl.SamplerParameterfv);
	gl.SamplerParameteri = (void APIENTRY (*)(GLuint sampler, GLenum pname, GLint param)) ldg_find("glSamplerParameteri", lib);
	GL_CHECK(gl.SamplerParameteri);
	gl.SamplerParameteriv = (void APIENTRY (*)(GLuint sampler, GLenum pname, const GLint *param)) ldg_find("glSamplerParameteriv", lib);
	GL_CHECK(gl.SamplerParameteriv);
	gl.Scaled = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glScaled", lib);
	GL_CHECK(gl.Scaled);
	gl.Scalef = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glScalef", lib);
	GL_CHECK(gl.Scalef);
	gl.ScalexOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glScalexOES", lib);
	GL_CHECK(gl.ScalexOES);
	gl.Scissor = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glScissor", lib);
	GL_CHECK(gl.Scissor);
	gl.ScissorArrayv = (void APIENTRY (*)(GLuint first, GLsizei count, const GLint *v)) ldg_find("glScissorArrayv", lib);
	GL_CHECK(gl.ScissorArrayv);
	gl.ScissorIndexed = (void APIENTRY (*)(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)) ldg_find("glScissorIndexed", lib);
	GL_CHECK(gl.ScissorIndexed);
	gl.ScissorIndexedv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glScissorIndexedv", lib);
	GL_CHECK(gl.ScissorIndexedv);
	gl.SecondaryColor3b = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue)) ldg_find("glSecondaryColor3b", lib);
	GL_CHECK(gl.SecondaryColor3b);
	gl.SecondaryColor3bEXT = (void APIENTRY (*)(GLbyte32 red, GLbyte32 green, GLbyte32 blue)) ldg_find("glSecondaryColor3bEXT", lib);
	GL_CHECK(gl.SecondaryColor3bEXT);
	gl.SecondaryColor3bv = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glSecondaryColor3bv", lib);
	GL_CHECK(gl.SecondaryColor3bv);
	gl.SecondaryColor3bvEXT = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glSecondaryColor3bvEXT", lib);
	GL_CHECK(gl.SecondaryColor3bvEXT);
	gl.SecondaryColor3d = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue)) ldg_find("glSecondaryColor3d", lib);
	GL_CHECK(gl.SecondaryColor3d);
	gl.SecondaryColor3dEXT = (void APIENTRY (*)(GLdouble red, GLdouble green, GLdouble blue)) ldg_find("glSecondaryColor3dEXT", lib);
	GL_CHECK(gl.SecondaryColor3dEXT);
	gl.SecondaryColor3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glSecondaryColor3dv", lib);
	GL_CHECK(gl.SecondaryColor3dv);
	gl.SecondaryColor3dvEXT = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glSecondaryColor3dvEXT", lib);
	GL_CHECK(gl.SecondaryColor3dvEXT);
	gl.SecondaryColor3f = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue)) ldg_find("glSecondaryColor3f", lib);
	GL_CHECK(gl.SecondaryColor3f);
	gl.SecondaryColor3fEXT = (void APIENTRY (*)(GLfloat red, GLfloat green, GLfloat blue)) ldg_find("glSecondaryColor3fEXT", lib);
	GL_CHECK(gl.SecondaryColor3fEXT);
	gl.SecondaryColor3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glSecondaryColor3fv", lib);
	GL_CHECK(gl.SecondaryColor3fv);
	gl.SecondaryColor3fvEXT = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glSecondaryColor3fvEXT", lib);
	GL_CHECK(gl.SecondaryColor3fvEXT);
	gl.SecondaryColor3hNV = (void APIENTRY (*)(GLhalfNV32 red, GLhalfNV32 green, GLhalfNV32 blue)) ldg_find("glSecondaryColor3hNV", lib);
	GL_CHECK(gl.SecondaryColor3hNV);
	gl.SecondaryColor3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glSecondaryColor3hvNV", lib);
	GL_CHECK(gl.SecondaryColor3hvNV);
	gl.SecondaryColor3i = (void APIENTRY (*)(GLint red, GLint green, GLint blue)) ldg_find("glSecondaryColor3i", lib);
	GL_CHECK(gl.SecondaryColor3i);
	gl.SecondaryColor3iEXT = (void APIENTRY (*)(GLint red, GLint green, GLint blue)) ldg_find("glSecondaryColor3iEXT", lib);
	GL_CHECK(gl.SecondaryColor3iEXT);
	gl.SecondaryColor3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glSecondaryColor3iv", lib);
	GL_CHECK(gl.SecondaryColor3iv);
	gl.SecondaryColor3ivEXT = (void APIENTRY (*)(const GLint *v)) ldg_find("glSecondaryColor3ivEXT", lib);
	GL_CHECK(gl.SecondaryColor3ivEXT);
	gl.SecondaryColor3s = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue)) ldg_find("glSecondaryColor3s", lib);
	GL_CHECK(gl.SecondaryColor3s);
	gl.SecondaryColor3sEXT = (void APIENTRY (*)(GLshort32 red, GLshort32 green, GLshort32 blue)) ldg_find("glSecondaryColor3sEXT", lib);
	GL_CHECK(gl.SecondaryColor3sEXT);
	gl.SecondaryColor3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glSecondaryColor3sv", lib);
	GL_CHECK(gl.SecondaryColor3sv);
	gl.SecondaryColor3svEXT = (void APIENTRY (*)(const GLshort *v)) ldg_find("glSecondaryColor3svEXT", lib);
	GL_CHECK(gl.SecondaryColor3svEXT);
	gl.SecondaryColor3ub = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue)) ldg_find("glSecondaryColor3ub", lib);
	GL_CHECK(gl.SecondaryColor3ub);
	gl.SecondaryColor3ubEXT = (void APIENTRY (*)(GLubyte32 red, GLubyte32 green, GLubyte32 blue)) ldg_find("glSecondaryColor3ubEXT", lib);
	GL_CHECK(gl.SecondaryColor3ubEXT);
	gl.SecondaryColor3ubv = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glSecondaryColor3ubv", lib);
	GL_CHECK(gl.SecondaryColor3ubv);
	gl.SecondaryColor3ubvEXT = (void APIENTRY (*)(const GLubyte *v)) ldg_find("glSecondaryColor3ubvEXT", lib);
	GL_CHECK(gl.SecondaryColor3ubvEXT);
	gl.SecondaryColor3ui = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue)) ldg_find("glSecondaryColor3ui", lib);
	GL_CHECK(gl.SecondaryColor3ui);
	gl.SecondaryColor3uiEXT = (void APIENTRY (*)(GLuint red, GLuint green, GLuint blue)) ldg_find("glSecondaryColor3uiEXT", lib);
	GL_CHECK(gl.SecondaryColor3uiEXT);
	gl.SecondaryColor3uiv = (void APIENTRY (*)(const GLuint *v)) ldg_find("glSecondaryColor3uiv", lib);
	GL_CHECK(gl.SecondaryColor3uiv);
	gl.SecondaryColor3uivEXT = (void APIENTRY (*)(const GLuint *v)) ldg_find("glSecondaryColor3uivEXT", lib);
	GL_CHECK(gl.SecondaryColor3uivEXT);
	gl.SecondaryColor3us = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue)) ldg_find("glSecondaryColor3us", lib);
	GL_CHECK(gl.SecondaryColor3us);
	gl.SecondaryColor3usEXT = (void APIENTRY (*)(GLushort32 red, GLushort32 green, GLushort32 blue)) ldg_find("glSecondaryColor3usEXT", lib);
	GL_CHECK(gl.SecondaryColor3usEXT);
	gl.SecondaryColor3usv = (void APIENTRY (*)(const GLushort *v)) ldg_find("glSecondaryColor3usv", lib);
	GL_CHECK(gl.SecondaryColor3usv);
	gl.SecondaryColor3usvEXT = (void APIENTRY (*)(const GLushort *v)) ldg_find("glSecondaryColor3usvEXT", lib);
	GL_CHECK(gl.SecondaryColor3usvEXT);
	gl.SecondaryColorFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glSecondaryColorFormatNV", lib);
	GL_CHECK(gl.SecondaryColorFormatNV);
	gl.SecondaryColorP3ui = (void APIENTRY (*)(GLenum type, GLuint color)) ldg_find("glSecondaryColorP3ui", lib);
	GL_CHECK(gl.SecondaryColorP3ui);
	gl.SecondaryColorP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *color)) ldg_find("glSecondaryColorP3uiv", lib);
	GL_CHECK(gl.SecondaryColorP3uiv);
	gl.SecondaryColorPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glSecondaryColorPointer", lib);
	GL_CHECK(gl.SecondaryColorPointer);
	gl.SecondaryColorPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glSecondaryColorPointerEXT", lib);
	GL_CHECK(gl.SecondaryColorPointerEXT);
	gl.SecondaryColorPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glSecondaryColorPointerListIBM", lib);
	GL_CHECK(gl.SecondaryColorPointerListIBM);
	gl.SelectBuffer = (void APIENTRY (*)(GLsizei size, GLuint *buffer)) ldg_find("glSelectBuffer", lib);
	GL_CHECK(gl.SelectBuffer);
	gl.SelectPerfMonitorCountersAMD = (void APIENTRY (*)(GLuint monitor, GLboolean32 enable, GLuint group, GLint numCounters, GLuint *counterList)) ldg_find("glSelectPerfMonitorCountersAMD", lib);
	GL_CHECK(gl.SelectPerfMonitorCountersAMD);
	gl.SeparableFilter2D = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column)) ldg_find("glSeparableFilter2D", lib);
	GL_CHECK(gl.SeparableFilter2D);
	gl.SeparableFilter2DEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column)) ldg_find("glSeparableFilter2DEXT", lib);
	GL_CHECK(gl.SeparableFilter2DEXT);
	gl.SetFenceAPPLE = (void APIENTRY (*)(GLuint fence)) ldg_find("glSetFenceAPPLE", lib);
	GL_CHECK(gl.SetFenceAPPLE);
	gl.SetFenceNV = (void APIENTRY (*)(GLuint fence, GLenum condition)) ldg_find("glSetFenceNV", lib);
	GL_CHECK(gl.SetFenceNV);
	gl.SetFragmentShaderConstantATI = (void APIENTRY (*)(GLuint dst, const GLfloat *value)) ldg_find("glSetFragmentShaderConstantATI", lib);
	GL_CHECK(gl.SetFragmentShaderConstantATI);
	gl.SetInvariantEXT = (void APIENTRY (*)(GLuint id, GLenum type, const void *addr)) ldg_find("glSetInvariantEXT", lib);
	GL_CHECK(gl.SetInvariantEXT);
	gl.SetLocalConstantEXT = (void APIENTRY (*)(GLuint id, GLenum type, const void *addr)) ldg_find("glSetLocalConstantEXT", lib);
	GL_CHECK(gl.SetLocalConstantEXT);
	gl.SetMultisamplefvAMD = (void APIENTRY (*)(GLenum pname, GLuint index, const GLfloat *val)) ldg_find("glSetMultisamplefvAMD", lib);
	GL_CHECK(gl.SetMultisamplefvAMD);
	gl.ShadeModel = (void APIENTRY (*)(GLenum mode)) ldg_find("glShadeModel", lib);
	GL_CHECK(gl.ShadeModel);
	gl.ShaderBinary = (void APIENTRY (*)(GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length)) ldg_find("glShaderBinary", lib);
	GL_CHECK(gl.ShaderBinary);
	gl.ShaderOp1EXT = (void APIENTRY (*)(GLenum op, GLuint res, GLuint arg1)) ldg_find("glShaderOp1EXT", lib);
	GL_CHECK(gl.ShaderOp1EXT);
	gl.ShaderOp2EXT = (void APIENTRY (*)(GLenum op, GLuint res, GLuint arg1, GLuint arg2)) ldg_find("glShaderOp2EXT", lib);
	GL_CHECK(gl.ShaderOp2EXT);
	gl.ShaderOp3EXT = (void APIENTRY (*)(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3)) ldg_find("glShaderOp3EXT", lib);
	GL_CHECK(gl.ShaderOp3EXT);
	gl.ShaderSource = (void APIENTRY (*)(GLuint shader, GLsizei count, const GLchar *const *string, const GLint *length)) ldg_find("glShaderSource", lib);
	GL_CHECK(gl.ShaderSource);
	gl.ShaderSourceARB = (void APIENTRY (*)(GLhandleARB shaderObj, GLsizei count, const GLcharARB * *string, const GLint *length)) ldg_find("glShaderSourceARB", lib);
	GL_CHECK(gl.ShaderSourceARB);
	gl.ShaderStorageBlockBinding = (void APIENTRY (*)(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding)) ldg_find("glShaderStorageBlockBinding", lib);
	GL_CHECK(gl.ShaderStorageBlockBinding);
	gl.SharpenTexFuncSGIS = (void APIENTRY (*)(GLenum target, GLsizei n, const GLfloat *points)) ldg_find("glSharpenTexFuncSGIS", lib);
	GL_CHECK(gl.SharpenTexFuncSGIS);
	gl.SpriteParameterfSGIX = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glSpriteParameterfSGIX", lib);
	GL_CHECK(gl.SpriteParameterfSGIX);
	gl.SpriteParameterfvSGIX = (void APIENTRY (*)(GLenum pname, const GLfloat *params)) ldg_find("glSpriteParameterfvSGIX", lib);
	GL_CHECK(gl.SpriteParameterfvSGIX);
	gl.SpriteParameteriSGIX = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glSpriteParameteriSGIX", lib);
	GL_CHECK(gl.SpriteParameteriSGIX);
	gl.SpriteParameterivSGIX = (void APIENTRY (*)(GLenum pname, const GLint *params)) ldg_find("glSpriteParameterivSGIX", lib);
	GL_CHECK(gl.SpriteParameterivSGIX);
	gl.StartInstrumentsSGIX = (void APIENTRY (*)(void)) ldg_find("glStartInstrumentsSGIX", lib);
	GL_CHECK(gl.StartInstrumentsSGIX);
	gl.StencilClearTagEXT = (void APIENTRY (*)(GLsizei stencilTagBits, GLuint stencilClearTag)) ldg_find("glStencilClearTagEXT", lib);
	GL_CHECK(gl.StencilClearTagEXT);
	gl.StencilFillPathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues)) ldg_find("glStencilFillPathInstancedNV", lib);
	GL_CHECK(gl.StencilFillPathInstancedNV);
	gl.StencilFillPathNV = (void APIENTRY (*)(GLuint path, GLenum fillMode, GLuint mask)) ldg_find("glStencilFillPathNV", lib);
	GL_CHECK(gl.StencilFillPathNV);
	gl.StencilFunc = (void APIENTRY (*)(GLenum func, GLint ref, GLuint mask)) ldg_find("glStencilFunc", lib);
	GL_CHECK(gl.StencilFunc);
	gl.StencilFuncSeparate = (void APIENTRY (*)(GLenum face, GLenum func, GLint ref, GLuint mask)) ldg_find("glStencilFuncSeparate", lib);
	GL_CHECK(gl.StencilFuncSeparate);
	gl.StencilFuncSeparateATI = (void APIENTRY (*)(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)) ldg_find("glStencilFuncSeparateATI", lib);
	GL_CHECK(gl.StencilFuncSeparateATI);
	gl.StencilMask = (void APIENTRY (*)(GLuint mask)) ldg_find("glStencilMask", lib);
	GL_CHECK(gl.StencilMask);
	gl.StencilMaskSeparate = (void APIENTRY (*)(GLenum face, GLuint mask)) ldg_find("glStencilMaskSeparate", lib);
	GL_CHECK(gl.StencilMaskSeparate);
	gl.StencilOp = (void APIENTRY (*)(GLenum fail, GLenum zfail, GLenum zpass)) ldg_find("glStencilOp", lib);
	GL_CHECK(gl.StencilOp);
	gl.StencilOpSeparate = (void APIENTRY (*)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)) ldg_find("glStencilOpSeparate", lib);
	GL_CHECK(gl.StencilOpSeparate);
	gl.StencilOpSeparateATI = (void APIENTRY (*)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)) ldg_find("glStencilOpSeparateATI", lib);
	GL_CHECK(gl.StencilOpSeparateATI);
	gl.StencilOpValueAMD = (void APIENTRY (*)(GLenum face, GLuint value)) ldg_find("glStencilOpValueAMD", lib);
	GL_CHECK(gl.StencilOpValueAMD);
	gl.StencilStrokePathInstancedNV = (void APIENTRY (*)(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues)) ldg_find("glStencilStrokePathInstancedNV", lib);
	GL_CHECK(gl.StencilStrokePathInstancedNV);
	gl.StencilStrokePathNV = (void APIENTRY (*)(GLuint path, GLint reference, GLuint mask)) ldg_find("glStencilStrokePathNV", lib);
	GL_CHECK(gl.StencilStrokePathNV);
	gl.StopInstrumentsSGIX = (void APIENTRY (*)(GLint marker)) ldg_find("glStopInstrumentsSGIX", lib);
	GL_CHECK(gl.StopInstrumentsSGIX);
	gl.StringMarkerGREMEDY = (void APIENTRY (*)(GLsizei len, const void *string)) ldg_find("glStringMarkerGREMEDY", lib);
	GL_CHECK(gl.StringMarkerGREMEDY);
	gl.SwapAPPLE = (void APIENTRY (*)(void)) ldg_find("glSwapAPPLE", lib);
	GL_CHECK(gl.SwapAPPLE);
	gl.SwizzleEXT = (void APIENTRY (*)(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)) ldg_find("glSwizzleEXT", lib);
	GL_CHECK(gl.SwizzleEXT);
	gl.SyncTextureINTEL = (void APIENTRY (*)(GLuint texture)) ldg_find("glSyncTextureINTEL", lib);
	GL_CHECK(gl.SyncTextureINTEL);
	gl.TagSampleBufferSGIX = (void APIENTRY (*)(void)) ldg_find("glTagSampleBufferSGIX", lib);
	GL_CHECK(gl.TagSampleBufferSGIX);
	gl.Tangent3bEXT = (void APIENTRY (*)(GLbyte32 tx, GLbyte32 ty, GLbyte32 tz)) ldg_find("glTangent3bEXT", lib);
	GL_CHECK(gl.Tangent3bEXT);
	gl.Tangent3bvEXT = (void APIENTRY (*)(const GLbyte *v)) ldg_find("glTangent3bvEXT", lib);
	GL_CHECK(gl.Tangent3bvEXT);
	gl.Tangent3dEXT = (void APIENTRY (*)(GLdouble tx, GLdouble ty, GLdouble tz)) ldg_find("glTangent3dEXT", lib);
	GL_CHECK(gl.Tangent3dEXT);
	gl.Tangent3dvEXT = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTangent3dvEXT", lib);
	GL_CHECK(gl.Tangent3dvEXT);
	gl.Tangent3fEXT = (void APIENTRY (*)(GLfloat tx, GLfloat ty, GLfloat tz)) ldg_find("glTangent3fEXT", lib);
	GL_CHECK(gl.Tangent3fEXT);
	gl.Tangent3fvEXT = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTangent3fvEXT", lib);
	GL_CHECK(gl.Tangent3fvEXT);
	gl.Tangent3iEXT = (void APIENTRY (*)(GLint tx, GLint ty, GLint tz)) ldg_find("glTangent3iEXT", lib);
	GL_CHECK(gl.Tangent3iEXT);
	gl.Tangent3ivEXT = (void APIENTRY (*)(const GLint *v)) ldg_find("glTangent3ivEXT", lib);
	GL_CHECK(gl.Tangent3ivEXT);
	gl.Tangent3sEXT = (void APIENTRY (*)(GLshort32 tx, GLshort32 ty, GLshort32 tz)) ldg_find("glTangent3sEXT", lib);
	GL_CHECK(gl.Tangent3sEXT);
	gl.Tangent3svEXT = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTangent3svEXT", lib);
	GL_CHECK(gl.Tangent3svEXT);
	gl.TangentPointerEXT = (void APIENTRY (*)(GLenum type, GLsizei stride, const void *pointer)) ldg_find("glTangentPointerEXT", lib);
	GL_CHECK(gl.TangentPointerEXT);
	gl.TbufferMask3DFX = (void APIENTRY (*)(GLuint mask)) ldg_find("glTbufferMask3DFX", lib);
	GL_CHECK(gl.TbufferMask3DFX);
	gl.TessellationFactorAMD = (void APIENTRY (*)(GLfloat factor)) ldg_find("glTessellationFactorAMD", lib);
	GL_CHECK(gl.TessellationFactorAMD);
	gl.TessellationModeAMD = (void APIENTRY (*)(GLenum mode)) ldg_find("glTessellationModeAMD", lib);
	GL_CHECK(gl.TessellationModeAMD);
	gl.TestFenceAPPLE = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glTestFenceAPPLE", lib);
	GL_CHECK(gl.TestFenceAPPLE);
	gl.TestFenceNV = (GLboolean APIENTRY (*)(GLuint fence)) ldg_find("glTestFenceNV", lib);
	GL_CHECK(gl.TestFenceNV);
	gl.TestObjectAPPLE = (GLboolean APIENTRY (*)(GLenum object, GLuint name)) ldg_find("glTestObjectAPPLE", lib);
	GL_CHECK(gl.TestObjectAPPLE);
	gl.TexBuffer = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTexBuffer", lib);
	GL_CHECK(gl.TexBuffer);
	gl.TexBufferARB = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTexBufferARB", lib);
	GL_CHECK(gl.TexBufferARB);
	gl.TexBufferEXT = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTexBufferEXT", lib);
	GL_CHECK(gl.TexBufferEXT);
	gl.TexBufferRange = (void APIENTRY (*)(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glTexBufferRange", lib);
	GL_CHECK(gl.TexBufferRange);
	gl.TexBumpParameterfvATI = (void APIENTRY (*)(GLenum pname, const GLfloat *param)) ldg_find("glTexBumpParameterfvATI", lib);
	GL_CHECK(gl.TexBumpParameterfvATI);
	gl.TexBumpParameterivATI = (void APIENTRY (*)(GLenum pname, const GLint *param)) ldg_find("glTexBumpParameterivATI", lib);
	GL_CHECK(gl.TexBumpParameterivATI);
	gl.TexCoord1bOES = (void APIENTRY (*)(GLbyte32 s)) ldg_find("glTexCoord1bOES", lib);
	GL_CHECK(gl.TexCoord1bOES);
	gl.TexCoord1bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord1bvOES", lib);
	GL_CHECK(gl.TexCoord1bvOES);
	gl.TexCoord1d = (void APIENTRY (*)(GLdouble s)) ldg_find("glTexCoord1d", lib);
	GL_CHECK(gl.TexCoord1d);
	gl.TexCoord1dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord1dv", lib);
	GL_CHECK(gl.TexCoord1dv);
	gl.TexCoord1f = (void APIENTRY (*)(GLfloat s)) ldg_find("glTexCoord1f", lib);
	GL_CHECK(gl.TexCoord1f);
	gl.TexCoord1fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord1fv", lib);
	GL_CHECK(gl.TexCoord1fv);
	gl.TexCoord1hNV = (void APIENTRY (*)(GLhalfNV32 s)) ldg_find("glTexCoord1hNV", lib);
	GL_CHECK(gl.TexCoord1hNV);
	gl.TexCoord1hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord1hvNV", lib);
	GL_CHECK(gl.TexCoord1hvNV);
	gl.TexCoord1i = (void APIENTRY (*)(GLint s)) ldg_find("glTexCoord1i", lib);
	GL_CHECK(gl.TexCoord1i);
	gl.TexCoord1iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord1iv", lib);
	GL_CHECK(gl.TexCoord1iv);
	gl.TexCoord1s = (void APIENTRY (*)(GLshort32 s)) ldg_find("glTexCoord1s", lib);
	GL_CHECK(gl.TexCoord1s);
	gl.TexCoord1sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord1sv", lib);
	GL_CHECK(gl.TexCoord1sv);
	gl.TexCoord1xOES = (void APIENTRY (*)(GLfixed s)) ldg_find("glTexCoord1xOES", lib);
	GL_CHECK(gl.TexCoord1xOES);
	gl.TexCoord1xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord1xvOES", lib);
	GL_CHECK(gl.TexCoord1xvOES);
	gl.TexCoord2bOES = (void APIENTRY (*)(GLbyte32 s, GLbyte32 t)) ldg_find("glTexCoord2bOES", lib);
	GL_CHECK(gl.TexCoord2bOES);
	gl.TexCoord2bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord2bvOES", lib);
	GL_CHECK(gl.TexCoord2bvOES);
	gl.TexCoord2d = (void APIENTRY (*)(GLdouble s, GLdouble t)) ldg_find("glTexCoord2d", lib);
	GL_CHECK(gl.TexCoord2d);
	gl.TexCoord2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord2dv", lib);
	GL_CHECK(gl.TexCoord2dv);
	gl.TexCoord2f = (void APIENTRY (*)(GLfloat s, GLfloat t)) ldg_find("glTexCoord2f", lib);
	GL_CHECK(gl.TexCoord2f);
	gl.TexCoord2fColor3fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fColor3fVertex3fSUN", lib);
	GL_CHECK(gl.TexCoord2fColor3fVertex3fSUN);
	gl.TexCoord2fColor3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *c, const GLfloat *v)) ldg_find("glTexCoord2fColor3fVertex3fvSUN", lib);
	GL_CHECK(gl.TexCoord2fColor3fVertex3fvSUN);
	gl.TexCoord2fColor4fNormal3fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fColor4fNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.TexCoord2fColor4fNormal3fVertex3fSUN);
	gl.TexCoord2fColor4fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glTexCoord2fColor4fNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.TexCoord2fColor4fNormal3fVertex3fvSUN);
	gl.TexCoord2fColor4ubVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLubyte32 r, GLubyte32 g, GLubyte32 b, GLubyte32 a, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fColor4ubVertex3fSUN", lib);
	GL_CHECK(gl.TexCoord2fColor4ubVertex3fSUN);
	gl.TexCoord2fColor4ubVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLubyte *c, const GLfloat *v)) ldg_find("glTexCoord2fColor4ubVertex3fvSUN", lib);
	GL_CHECK(gl.TexCoord2fColor4ubVertex3fvSUN);
	gl.TexCoord2fNormal3fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fNormal3fVertex3fSUN", lib);
	GL_CHECK(gl.TexCoord2fNormal3fVertex3fSUN);
	gl.TexCoord2fNormal3fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *n, const GLfloat *v)) ldg_find("glTexCoord2fNormal3fVertex3fvSUN", lib);
	GL_CHECK(gl.TexCoord2fNormal3fVertex3fvSUN);
	gl.TexCoord2fVertex3fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTexCoord2fVertex3fSUN", lib);
	GL_CHECK(gl.TexCoord2fVertex3fSUN);
	gl.TexCoord2fVertex3fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *v)) ldg_find("glTexCoord2fVertex3fvSUN", lib);
	GL_CHECK(gl.TexCoord2fVertex3fvSUN);
	gl.TexCoord2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord2fv", lib);
	GL_CHECK(gl.TexCoord2fv);
	gl.TexCoord2hNV = (void APIENTRY (*)(GLhalfNV32 s, GLhalfNV32 t)) ldg_find("glTexCoord2hNV", lib);
	GL_CHECK(gl.TexCoord2hNV);
	gl.TexCoord2hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord2hvNV", lib);
	GL_CHECK(gl.TexCoord2hvNV);
	gl.TexCoord2i = (void APIENTRY (*)(GLint s, GLint t)) ldg_find("glTexCoord2i", lib);
	GL_CHECK(gl.TexCoord2i);
	gl.TexCoord2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord2iv", lib);
	GL_CHECK(gl.TexCoord2iv);
	gl.TexCoord2s = (void APIENTRY (*)(GLshort32 s, GLshort32 t)) ldg_find("glTexCoord2s", lib);
	GL_CHECK(gl.TexCoord2s);
	gl.TexCoord2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord2sv", lib);
	GL_CHECK(gl.TexCoord2sv);
	gl.TexCoord2xOES = (void APIENTRY (*)(GLfixed s, GLfixed t)) ldg_find("glTexCoord2xOES", lib);
	GL_CHECK(gl.TexCoord2xOES);
	gl.TexCoord2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord2xvOES", lib);
	GL_CHECK(gl.TexCoord2xvOES);
	gl.TexCoord3bOES = (void APIENTRY (*)(GLbyte32 s, GLbyte32 t, GLbyte32 r)) ldg_find("glTexCoord3bOES", lib);
	GL_CHECK(gl.TexCoord3bOES);
	gl.TexCoord3bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord3bvOES", lib);
	GL_CHECK(gl.TexCoord3bvOES);
	gl.TexCoord3d = (void APIENTRY (*)(GLdouble s, GLdouble t, GLdouble r)) ldg_find("glTexCoord3d", lib);
	GL_CHECK(gl.TexCoord3d);
	gl.TexCoord3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord3dv", lib);
	GL_CHECK(gl.TexCoord3dv);
	gl.TexCoord3f = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r)) ldg_find("glTexCoord3f", lib);
	GL_CHECK(gl.TexCoord3f);
	gl.TexCoord3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord3fv", lib);
	GL_CHECK(gl.TexCoord3fv);
	gl.TexCoord3hNV = (void APIENTRY (*)(GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r)) ldg_find("glTexCoord3hNV", lib);
	GL_CHECK(gl.TexCoord3hNV);
	gl.TexCoord3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord3hvNV", lib);
	GL_CHECK(gl.TexCoord3hvNV);
	gl.TexCoord3i = (void APIENTRY (*)(GLint s, GLint t, GLint r)) ldg_find("glTexCoord3i", lib);
	GL_CHECK(gl.TexCoord3i);
	gl.TexCoord3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord3iv", lib);
	GL_CHECK(gl.TexCoord3iv);
	gl.TexCoord3s = (void APIENTRY (*)(GLshort32 s, GLshort32 t, GLshort32 r)) ldg_find("glTexCoord3s", lib);
	GL_CHECK(gl.TexCoord3s);
	gl.TexCoord3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord3sv", lib);
	GL_CHECK(gl.TexCoord3sv);
	gl.TexCoord3xOES = (void APIENTRY (*)(GLfixed s, GLfixed t, GLfixed r)) ldg_find("glTexCoord3xOES", lib);
	GL_CHECK(gl.TexCoord3xOES);
	gl.TexCoord3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord3xvOES", lib);
	GL_CHECK(gl.TexCoord3xvOES);
	gl.TexCoord4bOES = (void APIENTRY (*)(GLbyte32 s, GLbyte32 t, GLbyte32 r, GLbyte32 q)) ldg_find("glTexCoord4bOES", lib);
	GL_CHECK(gl.TexCoord4bOES);
	gl.TexCoord4bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glTexCoord4bvOES", lib);
	GL_CHECK(gl.TexCoord4bvOES);
	gl.TexCoord4d = (void APIENTRY (*)(GLdouble s, GLdouble t, GLdouble r, GLdouble q)) ldg_find("glTexCoord4d", lib);
	GL_CHECK(gl.TexCoord4d);
	gl.TexCoord4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glTexCoord4dv", lib);
	GL_CHECK(gl.TexCoord4dv);
	gl.TexCoord4f = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat r, GLfloat q)) ldg_find("glTexCoord4f", lib);
	GL_CHECK(gl.TexCoord4f);
	gl.TexCoord4fColor4fNormal3fVertex4fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glTexCoord4fColor4fNormal3fVertex4fSUN", lib);
	GL_CHECK(gl.TexCoord4fColor4fNormal3fVertex4fSUN);
	gl.TexCoord4fColor4fNormal3fVertex4fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v)) ldg_find("glTexCoord4fColor4fNormal3fVertex4fvSUN", lib);
	GL_CHECK(gl.TexCoord4fColor4fNormal3fVertex4fvSUN);
	gl.TexCoord4fVertex4fSUN = (void APIENTRY (*)(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glTexCoord4fVertex4fSUN", lib);
	GL_CHECK(gl.TexCoord4fVertex4fSUN);
	gl.TexCoord4fVertex4fvSUN = (void APIENTRY (*)(const GLfloat *tc, const GLfloat *v)) ldg_find("glTexCoord4fVertex4fvSUN", lib);
	GL_CHECK(gl.TexCoord4fVertex4fvSUN);
	gl.TexCoord4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glTexCoord4fv", lib);
	GL_CHECK(gl.TexCoord4fv);
	gl.TexCoord4hNV = (void APIENTRY (*)(GLhalfNV32 s, GLhalfNV32 t, GLhalfNV32 r, GLhalfNV32 q)) ldg_find("glTexCoord4hNV", lib);
	GL_CHECK(gl.TexCoord4hNV);
	gl.TexCoord4hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glTexCoord4hvNV", lib);
	GL_CHECK(gl.TexCoord4hvNV);
	gl.TexCoord4i = (void APIENTRY (*)(GLint s, GLint t, GLint r, GLint q)) ldg_find("glTexCoord4i", lib);
	GL_CHECK(gl.TexCoord4i);
	gl.TexCoord4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glTexCoord4iv", lib);
	GL_CHECK(gl.TexCoord4iv);
	gl.TexCoord4s = (void APIENTRY (*)(GLshort32 s, GLshort32 t, GLshort32 r, GLshort32 q)) ldg_find("glTexCoord4s", lib);
	GL_CHECK(gl.TexCoord4s);
	gl.TexCoord4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glTexCoord4sv", lib);
	GL_CHECK(gl.TexCoord4sv);
	gl.TexCoord4xOES = (void APIENTRY (*)(GLfixed s, GLfixed t, GLfixed r, GLfixed q)) ldg_find("glTexCoord4xOES", lib);
	GL_CHECK(gl.TexCoord4xOES);
	gl.TexCoord4xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glTexCoord4xvOES", lib);
	GL_CHECK(gl.TexCoord4xvOES);
	gl.TexCoordFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glTexCoordFormatNV", lib);
	GL_CHECK(gl.TexCoordFormatNV);
	gl.TexCoordP1ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP1ui", lib);
	GL_CHECK(gl.TexCoordP1ui);
	gl.TexCoordP1uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP1uiv", lib);
	GL_CHECK(gl.TexCoordP1uiv);
	gl.TexCoordP2ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP2ui", lib);
	GL_CHECK(gl.TexCoordP2ui);
	gl.TexCoordP2uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP2uiv", lib);
	GL_CHECK(gl.TexCoordP2uiv);
	gl.TexCoordP3ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP3ui", lib);
	GL_CHECK(gl.TexCoordP3ui);
	gl.TexCoordP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP3uiv", lib);
	GL_CHECK(gl.TexCoordP3uiv);
	gl.TexCoordP4ui = (void APIENTRY (*)(GLenum type, GLuint coords)) ldg_find("glTexCoordP4ui", lib);
	GL_CHECK(gl.TexCoordP4ui);
	gl.TexCoordP4uiv = (void APIENTRY (*)(GLenum type, const GLuint *coords)) ldg_find("glTexCoordP4uiv", lib);
	GL_CHECK(gl.TexCoordP4uiv);
	gl.TexCoordPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glTexCoordPointer", lib);
	GL_CHECK(gl.TexCoordPointer);
	gl.TexCoordPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glTexCoordPointerEXT", lib);
	GL_CHECK(gl.TexCoordPointerEXT);
	gl.TexCoordPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glTexCoordPointerListIBM", lib);
	GL_CHECK(gl.TexCoordPointerListIBM);
	gl.TexCoordPointervINTEL = (void APIENTRY (*)(GLint size, GLenum type, const void * *pointer)) ldg_find("glTexCoordPointervINTEL", lib);
	GL_CHECK(gl.TexCoordPointervINTEL);
	gl.TexEnvf = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glTexEnvf", lib);
	GL_CHECK(gl.TexEnvf);
	gl.TexEnvfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glTexEnvfv", lib);
	GL_CHECK(gl.TexEnvfv);
	gl.TexEnvi = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glTexEnvi", lib);
	GL_CHECK(gl.TexEnvi);
	gl.TexEnviv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexEnviv", lib);
	GL_CHECK(gl.TexEnviv);
	gl.TexEnvxOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed param)) ldg_find("glTexEnvxOES", lib);
	GL_CHECK(gl.TexEnvxOES);
	gl.TexEnvxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfixed *params)) ldg_find("glTexEnvxvOES", lib);
	GL_CHECK(gl.TexEnvxvOES);
	gl.TexFilterFuncSGIS = (void APIENTRY (*)(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights)) ldg_find("glTexFilterFuncSGIS", lib);
	GL_CHECK(gl.TexFilterFuncSGIS);
	gl.TexGend = (void APIENTRY (*)(GLenum coord, GLenum pname, GLdouble param)) ldg_find("glTexGend", lib);
	GL_CHECK(gl.TexGend);
	gl.TexGendv = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLdouble *params)) ldg_find("glTexGendv", lib);
	GL_CHECK(gl.TexGendv);
	gl.TexGenf = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfloat param)) ldg_find("glTexGenf", lib);
	GL_CHECK(gl.TexGenf);
	gl.TexGenfv = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLfloat *params)) ldg_find("glTexGenfv", lib);
	GL_CHECK(gl.TexGenfv);
	gl.TexGeni = (void APIENTRY (*)(GLenum coord, GLenum pname, GLint param)) ldg_find("glTexGeni", lib);
	GL_CHECK(gl.TexGeni);
	gl.TexGeniv = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLint *params)) ldg_find("glTexGeniv", lib);
	GL_CHECK(gl.TexGeniv);
	gl.TexGenxOES = (void APIENTRY (*)(GLenum coord, GLenum pname, GLfixed param)) ldg_find("glTexGenxOES", lib);
	GL_CHECK(gl.TexGenxOES);
	gl.TexGenxvOES = (void APIENTRY (*)(GLenum coord, GLenum pname, const GLfixed *params)) ldg_find("glTexGenxvOES", lib);
	GL_CHECK(gl.TexGenxvOES);
	gl.TexImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexImage1D", lib);
	GL_CHECK(gl.TexImage1D);
	gl.TexImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexImage2D", lib);
	GL_CHECK(gl.TexImage2D);
	gl.TexImage2DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTexImage2DMultisample", lib);
	GL_CHECK(gl.TexImage2DMultisample);
	gl.TexImage2DMultisampleCoverageNV = (void APIENTRY (*)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)) ldg_find("glTexImage2DMultisampleCoverageNV", lib);
	GL_CHECK(gl.TexImage2DMultisampleCoverageNV);
	gl.TexImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexImage3D", lib);
	GL_CHECK(gl.TexImage3D);
	gl.TexImage3DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexImage3DEXT", lib);
	GL_CHECK(gl.TexImage3DEXT);
	gl.TexImage3DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTexImage3DMultisample", lib);
	GL_CHECK(gl.TexImage3DMultisample);
	gl.TexImage3DMultisampleCoverageNV = (void APIENTRY (*)(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)) ldg_find("glTexImage3DMultisampleCoverageNV", lib);
	GL_CHECK(gl.TexImage3DMultisampleCoverageNV);
	gl.TexImage4DSGIS = (void APIENTRY (*)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexImage4DSGIS", lib);
	GL_CHECK(gl.TexImage4DSGIS);
	gl.TexPageCommitmentARB = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 resident)) ldg_find("glTexPageCommitmentARB", lib);
	GL_CHECK(gl.TexPageCommitmentARB);
	gl.TexParameterIiv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexParameterIiv", lib);
	GL_CHECK(gl.TexParameterIiv);
	gl.TexParameterIivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexParameterIivEXT", lib);
	GL_CHECK(gl.TexParameterIivEXT);
	gl.TexParameterIuiv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLuint *params)) ldg_find("glTexParameterIuiv", lib);
	GL_CHECK(gl.TexParameterIuiv);
	gl.TexParameterIuivEXT = (void APIENTRY (*)(GLenum target, GLenum pname, const GLuint *params)) ldg_find("glTexParameterIuivEXT", lib);
	GL_CHECK(gl.TexParameterIuivEXT);
	gl.TexParameterf = (void APIENTRY (*)(GLenum target, GLenum pname, GLfloat param)) ldg_find("glTexParameterf", lib);
	GL_CHECK(gl.TexParameterf);
	gl.TexParameterfv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glTexParameterfv", lib);
	GL_CHECK(gl.TexParameterfv);
	gl.TexParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) ldg_find("glTexParameteri", lib);
	GL_CHECK(gl.TexParameteri);
	gl.TexParameteriv = (void APIENTRY (*)(GLenum target, GLenum pname, const GLint *params)) ldg_find("glTexParameteriv", lib);
	GL_CHECK(gl.TexParameteriv);
	gl.TexParameterxOES = (void APIENTRY (*)(GLenum target, GLenum pname, GLfixed param)) ldg_find("glTexParameterxOES", lib);
	GL_CHECK(gl.TexParameterxOES);
	gl.TexParameterxvOES = (void APIENTRY (*)(GLenum target, GLenum pname, const GLfixed *params)) ldg_find("glTexParameterxvOES", lib);
	GL_CHECK(gl.TexParameterxvOES);
	gl.TexRenderbufferNV = (void APIENTRY (*)(GLenum target, GLuint renderbuffer)) ldg_find("glTexRenderbufferNV", lib);
	GL_CHECK(gl.TexRenderbufferNV);
	gl.TexScissorFuncINTEL = (void APIENTRY (*)(GLenum target, GLenum lfunc, GLenum hfunc)) ldg_find("glTexScissorFuncINTEL", lib);
	GL_CHECK(gl.TexScissorFuncINTEL);
	gl.TexScissorINTEL = (void APIENTRY (*)(GLenum target, GLclampf tlow, GLclampf thigh)) ldg_find("glTexScissorINTEL", lib);
	GL_CHECK(gl.TexScissorINTEL);
	gl.TexStorage1D = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)) ldg_find("glTexStorage1D", lib);
	GL_CHECK(gl.TexStorage1D);
	gl.TexStorage2D = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glTexStorage2D", lib);
	GL_CHECK(gl.TexStorage2D);
	gl.TexStorage2DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTexStorage2DMultisample", lib);
	GL_CHECK(gl.TexStorage2DMultisample);
	gl.TexStorage3D = (void APIENTRY (*)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glTexStorage3D", lib);
	GL_CHECK(gl.TexStorage3D);
	gl.TexStorage3DMultisample = (void APIENTRY (*)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTexStorage3DMultisample", lib);
	GL_CHECK(gl.TexStorage3DMultisample);
	gl.TexStorageSparseAMD = (void APIENTRY (*)(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)) ldg_find("glTexStorageSparseAMD", lib);
	GL_CHECK(gl.TexStorageSparseAMD);
	gl.TexSubImage1D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexSubImage1D", lib);
	GL_CHECK(gl.TexSubImage1D);
	gl.TexSubImage1DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage1DEXT", lib);
	GL_CHECK(gl.TexSubImage1DEXT);
	gl.TexSubImage2D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)) ldg_find("glTexSubImage2D", lib);
	GL_CHECK(gl.TexSubImage2D);
	gl.TexSubImage2DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage2DEXT", lib);
	GL_CHECK(gl.TexSubImage2DEXT);
	gl.TexSubImage3D = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage3D", lib);
	GL_CHECK(gl.TexSubImage3D);
	gl.TexSubImage3DEXT = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage3DEXT", lib);
	GL_CHECK(gl.TexSubImage3DEXT);
	gl.TexSubImage4DSGIS = (void APIENTRY (*)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const void *pixels)) ldg_find("glTexSubImage4DSGIS", lib);
	GL_CHECK(gl.TexSubImage4DSGIS);
	gl.TextureBarrierNV = (void APIENTRY (*)(void)) ldg_find("glTextureBarrierNV", lib);
	GL_CHECK(gl.TextureBarrierNV);
	gl.TextureBufferEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer)) ldg_find("glTextureBufferEXT", lib);
	GL_CHECK(gl.TextureBufferEXT);
	gl.TextureBufferRangeEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)) ldg_find("glTextureBufferRangeEXT", lib);
	GL_CHECK(gl.TextureBufferRangeEXT);
	gl.TextureColorMaskSGIS = (void APIENTRY (*)(GLboolean32 red, GLboolean32 green, GLboolean32 blue, GLboolean32 alpha)) ldg_find("glTextureColorMaskSGIS", lib);
	GL_CHECK(gl.TextureColorMaskSGIS);
	gl.TextureFogSGIX = (void APIENTRY (*)(GLenum pname)) ldg_find("glTextureFogSGIX", lib);
	GL_CHECK(gl.TextureFogSGIX);
	gl.TextureImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureImage1DEXT", lib);
	GL_CHECK(gl.TextureImage1DEXT);
	gl.TextureImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureImage2DEXT", lib);
	GL_CHECK(gl.TextureImage2DEXT);
	gl.TextureImage2DMultisampleCoverageNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage2DMultisampleCoverageNV", lib);
	GL_CHECK(gl.TextureImage2DMultisampleCoverageNV);
	gl.TextureImage2DMultisampleNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage2DMultisampleNV", lib);
	GL_CHECK(gl.TextureImage2DMultisampleNV);
	gl.TextureImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureImage3DEXT", lib);
	GL_CHECK(gl.TextureImage3DEXT);
	gl.TextureImage3DMultisampleCoverageNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage3DMultisampleCoverageNV", lib);
	GL_CHECK(gl.TextureImage3DMultisampleCoverageNV);
	gl.TextureImage3DMultisampleNV = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedSampleLocations)) ldg_find("glTextureImage3DMultisampleNV", lib);
	GL_CHECK(gl.TextureImage3DMultisampleNV);
	gl.TextureLightEXT = (void APIENTRY (*)(GLenum pname)) ldg_find("glTextureLightEXT", lib);
	GL_CHECK(gl.TextureLightEXT);
	gl.TextureMaterialEXT = (void APIENTRY (*)(GLenum face, GLenum mode)) ldg_find("glTextureMaterialEXT", lib);
	GL_CHECK(gl.TextureMaterialEXT);
	gl.TextureNormalEXT = (void APIENTRY (*)(GLenum mode)) ldg_find("glTextureNormalEXT", lib);
	GL_CHECK(gl.TextureNormalEXT);
	gl.TexturePageCommitmentEXT = (void APIENTRY (*)(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 resident)) ldg_find("glTexturePageCommitmentEXT", lib);
	GL_CHECK(gl.TexturePageCommitmentEXT);
	gl.TextureParameterIivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLint *params)) ldg_find("glTextureParameterIivEXT", lib);
	GL_CHECK(gl.TextureParameterIivEXT);
	gl.TextureParameterIuivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLuint *params)) ldg_find("glTextureParameterIuivEXT", lib);
	GL_CHECK(gl.TextureParameterIuivEXT);
	gl.TextureParameterfEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLfloat param)) ldg_find("glTextureParameterfEXT", lib);
	GL_CHECK(gl.TextureParameterfEXT);
	gl.TextureParameterfvEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLfloat *params)) ldg_find("glTextureParameterfvEXT", lib);
	GL_CHECK(gl.TextureParameterfvEXT);
	gl.TextureParameteriEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, GLint param)) ldg_find("glTextureParameteriEXT", lib);
	GL_CHECK(gl.TextureParameteriEXT);
	gl.TextureParameterivEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum pname, const GLint *params)) ldg_find("glTextureParameterivEXT", lib);
	GL_CHECK(gl.TextureParameterivEXT);
	gl.TextureRangeAPPLE = (void APIENTRY (*)(GLenum target, GLsizei length, const void *pointer)) ldg_find("glTextureRangeAPPLE", lib);
	GL_CHECK(gl.TextureRangeAPPLE);
	gl.TextureRenderbufferEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLuint renderbuffer)) ldg_find("glTextureRenderbufferEXT", lib);
	GL_CHECK(gl.TextureRenderbufferEXT);
	gl.TextureStorage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)) ldg_find("glTextureStorage1DEXT", lib);
	GL_CHECK(gl.TextureStorage1DEXT);
	gl.TextureStorage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)) ldg_find("glTextureStorage2DEXT", lib);
	GL_CHECK(gl.TextureStorage2DEXT);
	gl.TextureStorage2DMultisampleEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean32 fixedsamplelocations)) ldg_find("glTextureStorage2DMultisampleEXT", lib);
	GL_CHECK(gl.TextureStorage2DMultisampleEXT);
	gl.TextureStorage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)) ldg_find("glTextureStorage3DEXT", lib);
	GL_CHECK(gl.TextureStorage3DEXT);
	gl.TextureStorage3DMultisampleEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean32 fixedsamplelocations)) ldg_find("glTextureStorage3DMultisampleEXT", lib);
	GL_CHECK(gl.TextureStorage3DMultisampleEXT);
	gl.TextureStorageSparseAMD = (void APIENTRY (*)(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)) ldg_find("glTextureStorageSparseAMD", lib);
	GL_CHECK(gl.TextureStorageSparseAMD);
	gl.TextureSubImage1DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage1DEXT", lib);
	GL_CHECK(gl.TextureSubImage1DEXT);
	gl.TextureSubImage2DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage2DEXT", lib);
	GL_CHECK(gl.TextureSubImage2DEXT);
	gl.TextureSubImage3DEXT = (void APIENTRY (*)(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels)) ldg_find("glTextureSubImage3DEXT", lib);
	GL_CHECK(gl.TextureSubImage3DEXT);
	gl.TextureView = (void APIENTRY (*)(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers)) ldg_find("glTextureView", lib);
	GL_CHECK(gl.TextureView);
	gl.TraceAssertAttribMESA = (void APIENTRY (*)(GLbitfield attribMask)) ldg_find("glTraceAssertAttribMESA", lib);
	GL_CHECK(gl.TraceAssertAttribMESA);
	gl.TraceCommentMESA = (void APIENTRY (*)(const GLubyte *comment)) ldg_find("glTraceCommentMESA", lib);
	GL_CHECK(gl.TraceCommentMESA);
	gl.TraceListMESA = (void APIENTRY (*)(GLuint name, const GLubyte *comment)) ldg_find("glTraceListMESA", lib);
	GL_CHECK(gl.TraceListMESA);
	gl.TracePointerMESA = (void APIENTRY (*)(GLvoid *pointer, const GLubyte *comment)) ldg_find("glTracePointerMESA", lib);
	GL_CHECK(gl.TracePointerMESA);
	gl.TracePointerRangeMESA = (void APIENTRY (*)(const GLvoid *first, const GLvoid *last, const GLubyte *comment)) ldg_find("glTracePointerRangeMESA", lib);
	GL_CHECK(gl.TracePointerRangeMESA);
	gl.TraceTextureMESA = (void APIENTRY (*)(GLuint name, const GLubyte *comment)) ldg_find("glTraceTextureMESA", lib);
	GL_CHECK(gl.TraceTextureMESA);
	gl.TrackMatrixNV = (void APIENTRY (*)(GLenum target, GLuint address, GLenum matrix, GLenum transform)) ldg_find("glTrackMatrixNV", lib);
	GL_CHECK(gl.TrackMatrixNV);
	gl.TransformFeedbackAttribsNV = (void APIENTRY (*)(GLuint count, const GLint *attribs, GLenum bufferMode)) ldg_find("glTransformFeedbackAttribsNV", lib);
	GL_CHECK(gl.TransformFeedbackAttribsNV);
	gl.TransformFeedbackStreamAttribsNV = (void APIENTRY (*)(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode)) ldg_find("glTransformFeedbackStreamAttribsNV", lib);
	GL_CHECK(gl.TransformFeedbackStreamAttribsNV);
	gl.TransformFeedbackVaryings = (void APIENTRY (*)(GLuint program, GLsizei count, const GLchar *const *varyings, GLenum bufferMode)) ldg_find("glTransformFeedbackVaryings", lib);
	GL_CHECK(gl.TransformFeedbackVaryings);
	gl.TransformFeedbackVaryingsEXT = (void APIENTRY (*)(GLuint program, GLsizei count, const GLchar *const *varyings, GLenum bufferMode)) ldg_find("glTransformFeedbackVaryingsEXT", lib);
	GL_CHECK(gl.TransformFeedbackVaryingsEXT);
	gl.TransformFeedbackVaryingsNV = (void APIENTRY (*)(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode)) ldg_find("glTransformFeedbackVaryingsNV", lib);
	GL_CHECK(gl.TransformFeedbackVaryingsNV);
	gl.TransformPathNV = (void APIENTRY (*)(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues)) ldg_find("glTransformPathNV", lib);
	GL_CHECK(gl.TransformPathNV);
	gl.Translated = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glTranslated", lib);
	GL_CHECK(gl.Translated);
	gl.Translatef = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glTranslatef", lib);
	GL_CHECK(gl.Translatef);
	gl.TranslatexOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glTranslatexOES", lib);
	GL_CHECK(gl.TranslatexOES);
	gl.Uniform1d = (void APIENTRY (*)(GLint location, GLdouble x)) ldg_find("glUniform1d", lib);
	GL_CHECK(gl.Uniform1d);
	gl.Uniform1dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform1dv", lib);
	GL_CHECK(gl.Uniform1dv);
	gl.Uniform1f = (void APIENTRY (*)(GLint location, GLfloat v0)) ldg_find("glUniform1f", lib);
	GL_CHECK(gl.Uniform1f);
	gl.Uniform1fARB = (void APIENTRY (*)(GLint location, GLfloat v0)) ldg_find("glUniform1fARB", lib);
	GL_CHECK(gl.Uniform1fARB);
	gl.Uniform1fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform1fv", lib);
	GL_CHECK(gl.Uniform1fv);
	gl.Uniform1fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform1fvARB", lib);
	GL_CHECK(gl.Uniform1fvARB);
	gl.Uniform1i = (void APIENTRY (*)(GLint location, GLint v0)) ldg_find("glUniform1i", lib);
	GL_CHECK(gl.Uniform1i);
	gl.Uniform1i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x)) ldg_find("glUniform1i64NV", lib);
	GL_CHECK(gl.Uniform1i64NV);
	gl.Uniform1i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform1i64vNV", lib);
	GL_CHECK(gl.Uniform1i64vNV);
	gl.Uniform1iARB = (void APIENTRY (*)(GLint location, GLint v0)) ldg_find("glUniform1iARB", lib);
	GL_CHECK(gl.Uniform1iARB);
	gl.Uniform1iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform1iv", lib);
	GL_CHECK(gl.Uniform1iv);
	gl.Uniform1ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform1ivARB", lib);
	GL_CHECK(gl.Uniform1ivARB);
	gl.Uniform1ui = (void APIENTRY (*)(GLint location, GLuint v0)) ldg_find("glUniform1ui", lib);
	GL_CHECK(gl.Uniform1ui);
	gl.Uniform1ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x)) ldg_find("glUniform1ui64NV", lib);
	GL_CHECK(gl.Uniform1ui64NV);
	gl.Uniform1ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform1ui64vNV", lib);
	GL_CHECK(gl.Uniform1ui64vNV);
	gl.Uniform1uiEXT = (void APIENTRY (*)(GLint location, GLuint v0)) ldg_find("glUniform1uiEXT", lib);
	GL_CHECK(gl.Uniform1uiEXT);
	gl.Uniform1uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform1uiv", lib);
	GL_CHECK(gl.Uniform1uiv);
	gl.Uniform1uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform1uivEXT", lib);
	GL_CHECK(gl.Uniform1uivEXT);
	gl.Uniform2d = (void APIENTRY (*)(GLint location, GLdouble x, GLdouble y)) ldg_find("glUniform2d", lib);
	GL_CHECK(gl.Uniform2d);
	gl.Uniform2dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform2dv", lib);
	GL_CHECK(gl.Uniform2dv);
	gl.Uniform2f = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1)) ldg_find("glUniform2f", lib);
	GL_CHECK(gl.Uniform2f);
	gl.Uniform2fARB = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1)) ldg_find("glUniform2fARB", lib);
	GL_CHECK(gl.Uniform2fARB);
	gl.Uniform2fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform2fv", lib);
	GL_CHECK(gl.Uniform2fv);
	gl.Uniform2fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform2fvARB", lib);
	GL_CHECK(gl.Uniform2fvARB);
	gl.Uniform2i = (void APIENTRY (*)(GLint location, GLint v0, GLint v1)) ldg_find("glUniform2i", lib);
	GL_CHECK(gl.Uniform2i);
	gl.Uniform2i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x, GLint64EXT y)) ldg_find("glUniform2i64NV", lib);
	GL_CHECK(gl.Uniform2i64NV);
	gl.Uniform2i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform2i64vNV", lib);
	GL_CHECK(gl.Uniform2i64vNV);
	gl.Uniform2iARB = (void APIENTRY (*)(GLint location, GLint v0, GLint v1)) ldg_find("glUniform2iARB", lib);
	GL_CHECK(gl.Uniform2iARB);
	gl.Uniform2iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform2iv", lib);
	GL_CHECK(gl.Uniform2iv);
	gl.Uniform2ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform2ivARB", lib);
	GL_CHECK(gl.Uniform2ivARB);
	gl.Uniform2ui = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1)) ldg_find("glUniform2ui", lib);
	GL_CHECK(gl.Uniform2ui);
	gl.Uniform2ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x, GLuint64EXT y)) ldg_find("glUniform2ui64NV", lib);
	GL_CHECK(gl.Uniform2ui64NV);
	gl.Uniform2ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform2ui64vNV", lib);
	GL_CHECK(gl.Uniform2ui64vNV);
	gl.Uniform2uiEXT = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1)) ldg_find("glUniform2uiEXT", lib);
	GL_CHECK(gl.Uniform2uiEXT);
	gl.Uniform2uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform2uiv", lib);
	GL_CHECK(gl.Uniform2uiv);
	gl.Uniform2uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform2uivEXT", lib);
	GL_CHECK(gl.Uniform2uivEXT);
	gl.Uniform3d = (void APIENTRY (*)(GLint location, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glUniform3d", lib);
	GL_CHECK(gl.Uniform3d);
	gl.Uniform3dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform3dv", lib);
	GL_CHECK(gl.Uniform3dv);
	gl.Uniform3f = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glUniform3f", lib);
	GL_CHECK(gl.Uniform3f);
	gl.Uniform3fARB = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)) ldg_find("glUniform3fARB", lib);
	GL_CHECK(gl.Uniform3fARB);
	gl.Uniform3fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform3fv", lib);
	GL_CHECK(gl.Uniform3fv);
	gl.Uniform3fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform3fvARB", lib);
	GL_CHECK(gl.Uniform3fvARB);
	gl.Uniform3i = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glUniform3i", lib);
	GL_CHECK(gl.Uniform3i);
	gl.Uniform3i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)) ldg_find("glUniform3i64NV", lib);
	GL_CHECK(gl.Uniform3i64NV);
	gl.Uniform3i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform3i64vNV", lib);
	GL_CHECK(gl.Uniform3i64vNV);
	gl.Uniform3iARB = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2)) ldg_find("glUniform3iARB", lib);
	GL_CHECK(gl.Uniform3iARB);
	gl.Uniform3iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform3iv", lib);
	GL_CHECK(gl.Uniform3iv);
	gl.Uniform3ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform3ivARB", lib);
	GL_CHECK(gl.Uniform3ivARB);
	gl.Uniform3ui = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glUniform3ui", lib);
	GL_CHECK(gl.Uniform3ui);
	gl.Uniform3ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)) ldg_find("glUniform3ui64NV", lib);
	GL_CHECK(gl.Uniform3ui64NV);
	gl.Uniform3ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform3ui64vNV", lib);
	GL_CHECK(gl.Uniform3ui64vNV);
	gl.Uniform3uiEXT = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2)) ldg_find("glUniform3uiEXT", lib);
	GL_CHECK(gl.Uniform3uiEXT);
	gl.Uniform3uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform3uiv", lib);
	GL_CHECK(gl.Uniform3uiv);
	gl.Uniform3uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform3uivEXT", lib);
	GL_CHECK(gl.Uniform3uivEXT);
	gl.Uniform4d = (void APIENTRY (*)(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glUniform4d", lib);
	GL_CHECK(gl.Uniform4d);
	gl.Uniform4dv = (void APIENTRY (*)(GLint location, GLsizei count, const GLdouble *value)) ldg_find("glUniform4dv", lib);
	GL_CHECK(gl.Uniform4dv);
	gl.Uniform4f = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glUniform4f", lib);
	GL_CHECK(gl.Uniform4f);
	gl.Uniform4fARB = (void APIENTRY (*)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)) ldg_find("glUniform4fARB", lib);
	GL_CHECK(gl.Uniform4fARB);
	gl.Uniform4fv = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform4fv", lib);
	GL_CHECK(gl.Uniform4fv);
	gl.Uniform4fvARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLfloat *value)) ldg_find("glUniform4fvARB", lib);
	GL_CHECK(gl.Uniform4fvARB);
	gl.Uniform4i = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glUniform4i", lib);
	GL_CHECK(gl.Uniform4i);
	gl.Uniform4i64NV = (void APIENTRY (*)(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)) ldg_find("glUniform4i64NV", lib);
	GL_CHECK(gl.Uniform4i64NV);
	gl.Uniform4i64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLint64EXT *value)) ldg_find("glUniform4i64vNV", lib);
	GL_CHECK(gl.Uniform4i64vNV);
	gl.Uniform4iARB = (void APIENTRY (*)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)) ldg_find("glUniform4iARB", lib);
	GL_CHECK(gl.Uniform4iARB);
	gl.Uniform4iv = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform4iv", lib);
	GL_CHECK(gl.Uniform4iv);
	gl.Uniform4ivARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLint *value)) ldg_find("glUniform4ivARB", lib);
	GL_CHECK(gl.Uniform4ivARB);
	gl.Uniform4ui = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glUniform4ui", lib);
	GL_CHECK(gl.Uniform4ui);
	gl.Uniform4ui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)) ldg_find("glUniform4ui64NV", lib);
	GL_CHECK(gl.Uniform4ui64NV);
	gl.Uniform4ui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniform4ui64vNV", lib);
	GL_CHECK(gl.Uniform4ui64vNV);
	gl.Uniform4uiEXT = (void APIENTRY (*)(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)) ldg_find("glUniform4uiEXT", lib);
	GL_CHECK(gl.Uniform4uiEXT);
	gl.Uniform4uiv = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform4uiv", lib);
	GL_CHECK(gl.Uniform4uiv);
	gl.Uniform4uivEXT = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint *value)) ldg_find("glUniform4uivEXT", lib);
	GL_CHECK(gl.Uniform4uivEXT);
	gl.UniformBlockBinding = (void APIENTRY (*)(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)) ldg_find("glUniformBlockBinding", lib);
	GL_CHECK(gl.UniformBlockBinding);
	gl.UniformBufferEXT = (void APIENTRY (*)(GLuint program, GLint location, GLuint buffer)) ldg_find("glUniformBufferEXT", lib);
	GL_CHECK(gl.UniformBufferEXT);
	gl.UniformHandleui64ARB = (void APIENTRY (*)(GLint location, GLuint64 value)) ldg_find("glUniformHandleui64ARB", lib);
	GL_CHECK(gl.UniformHandleui64ARB);
	gl.UniformHandleui64NV = (void APIENTRY (*)(GLint location, GLuint64 value)) ldg_find("glUniformHandleui64NV", lib);
	GL_CHECK(gl.UniformHandleui64NV);
	gl.UniformHandleui64vARB = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniformHandleui64vARB", lib);
	GL_CHECK(gl.UniformHandleui64vARB);
	gl.UniformHandleui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64 *value)) ldg_find("glUniformHandleui64vNV", lib);
	GL_CHECK(gl.UniformHandleui64vNV);
	gl.UniformMatrix2dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix2dv", lib);
	GL_CHECK(gl.UniformMatrix2dv);
	gl.UniformMatrix2fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2fv", lib);
	GL_CHECK(gl.UniformMatrix2fv);
	gl.UniformMatrix2fvARB = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2fvARB", lib);
	GL_CHECK(gl.UniformMatrix2fvARB);
	gl.UniformMatrix2x3dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix2x3dv", lib);
	GL_CHECK(gl.UniformMatrix2x3dv);
	gl.UniformMatrix2x3fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2x3fv", lib);
	GL_CHECK(gl.UniformMatrix2x3fv);
	gl.UniformMatrix2x4dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix2x4dv", lib);
	GL_CHECK(gl.UniformMatrix2x4dv);
	gl.UniformMatrix2x4fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix2x4fv", lib);
	GL_CHECK(gl.UniformMatrix2x4fv);
	gl.UniformMatrix3dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix3dv", lib);
	GL_CHECK(gl.UniformMatrix3dv);
	gl.UniformMatrix3fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3fv", lib);
	GL_CHECK(gl.UniformMatrix3fv);
	gl.UniformMatrix3fvARB = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3fvARB", lib);
	GL_CHECK(gl.UniformMatrix3fvARB);
	gl.UniformMatrix3x2dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix3x2dv", lib);
	GL_CHECK(gl.UniformMatrix3x2dv);
	gl.UniformMatrix3x2fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3x2fv", lib);
	GL_CHECK(gl.UniformMatrix3x2fv);
	gl.UniformMatrix3x4dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix3x4dv", lib);
	GL_CHECK(gl.UniformMatrix3x4dv);
	gl.UniformMatrix3x4fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix3x4fv", lib);
	GL_CHECK(gl.UniformMatrix3x4fv);
	gl.UniformMatrix4dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix4dv", lib);
	GL_CHECK(gl.UniformMatrix4dv);
	gl.UniformMatrix4fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4fv", lib);
	GL_CHECK(gl.UniformMatrix4fv);
	gl.UniformMatrix4fvARB = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4fvARB", lib);
	GL_CHECK(gl.UniformMatrix4fvARB);
	gl.UniformMatrix4x2dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix4x2dv", lib);
	GL_CHECK(gl.UniformMatrix4x2dv);
	gl.UniformMatrix4x2fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4x2fv", lib);
	GL_CHECK(gl.UniformMatrix4x2fv);
	gl.UniformMatrix4x3dv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLdouble *value)) ldg_find("glUniformMatrix4x3dv", lib);
	GL_CHECK(gl.UniformMatrix4x3dv);
	gl.UniformMatrix4x3fv = (void APIENTRY (*)(GLint location, GLsizei count, GLboolean32 transpose, const GLfloat *value)) ldg_find("glUniformMatrix4x3fv", lib);
	GL_CHECK(gl.UniformMatrix4x3fv);
	gl.UniformSubroutinesuiv = (void APIENTRY (*)(GLenum shadertype, GLsizei count, const GLuint *indices)) ldg_find("glUniformSubroutinesuiv", lib);
	GL_CHECK(gl.UniformSubroutinesuiv);
	gl.Uniformui64NV = (void APIENTRY (*)(GLint location, GLuint64EXT value)) ldg_find("glUniformui64NV", lib);
	GL_CHECK(gl.Uniformui64NV);
	gl.Uniformui64vNV = (void APIENTRY (*)(GLint location, GLsizei count, const GLuint64EXT *value)) ldg_find("glUniformui64vNV", lib);
	GL_CHECK(gl.Uniformui64vNV);
	gl.UnlockArraysEXT = (void APIENTRY (*)(void)) ldg_find("glUnlockArraysEXT", lib);
	GL_CHECK(gl.UnlockArraysEXT);
	gl.UnmapBuffer = (GLboolean APIENTRY (*)(GLenum target)) ldg_find("glUnmapBuffer", lib);
	GL_CHECK(gl.UnmapBuffer);
	gl.UnmapBufferARB = (GLboolean APIENTRY (*)(GLenum target)) ldg_find("glUnmapBufferARB", lib);
	GL_CHECK(gl.UnmapBufferARB);
	gl.UnmapNamedBufferEXT = (GLboolean APIENTRY (*)(GLuint buffer)) ldg_find("glUnmapNamedBufferEXT", lib);
	GL_CHECK(gl.UnmapNamedBufferEXT);
	gl.UnmapObjectBufferATI = (void APIENTRY (*)(GLuint buffer)) ldg_find("glUnmapObjectBufferATI", lib);
	GL_CHECK(gl.UnmapObjectBufferATI);
	gl.UnmapTexture2DINTEL = (void APIENTRY (*)(GLuint texture, GLint level)) ldg_find("glUnmapTexture2DINTEL", lib);
	GL_CHECK(gl.UnmapTexture2DINTEL);
	gl.UpdateObjectBufferATI = (void APIENTRY (*)(GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve)) ldg_find("glUpdateObjectBufferATI", lib);
	GL_CHECK(gl.UpdateObjectBufferATI);
	gl.UseProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glUseProgram", lib);
	GL_CHECK(gl.UseProgram);
	gl.UseProgramObjectARB = (void APIENTRY (*)(GLhandleARB programObj)) ldg_find("glUseProgramObjectARB", lib);
	GL_CHECK(gl.UseProgramObjectARB);
	gl.UseProgramStages = (void APIENTRY (*)(GLuint pipeline, GLbitfield stages, GLuint program)) ldg_find("glUseProgramStages", lib);
	GL_CHECK(gl.UseProgramStages);
	gl.UseShaderProgramEXT = (void APIENTRY (*)(GLenum type, GLuint program)) ldg_find("glUseShaderProgramEXT", lib);
	GL_CHECK(gl.UseShaderProgramEXT);
	gl.VDPAUFiniNV = (void APIENTRY (*)(void)) ldg_find("glVDPAUFiniNV", lib);
	GL_CHECK(gl.VDPAUFiniNV);
	gl.VDPAUGetSurfaceivNV = (void APIENTRY (*)(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)) ldg_find("glVDPAUGetSurfaceivNV", lib);
	GL_CHECK(gl.VDPAUGetSurfaceivNV);
	gl.VDPAUInitNV = (void APIENTRY (*)(const void *vdpDevice, const void *getProcAddress)) ldg_find("glVDPAUInitNV", lib);
	GL_CHECK(gl.VDPAUInitNV);
	gl.VDPAUIsSurfaceNV = (GLboolean APIENTRY (*)(GLvdpauSurfaceNV surface)) ldg_find("glVDPAUIsSurfaceNV", lib);
	GL_CHECK(gl.VDPAUIsSurfaceNV);
	gl.VDPAUMapSurfacesNV = (void APIENTRY (*)(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces)) ldg_find("glVDPAUMapSurfacesNV", lib);
	GL_CHECK(gl.VDPAUMapSurfacesNV);
	gl.VDPAURegisterOutputSurfaceNV = (GLvdpauSurfaceNV APIENTRY (*)(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)) ldg_find("glVDPAURegisterOutputSurfaceNV", lib);
	GL_CHECK(gl.VDPAURegisterOutputSurfaceNV);
	gl.VDPAURegisterVideoSurfaceNV = (GLvdpauSurfaceNV APIENTRY (*)(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)) ldg_find("glVDPAURegisterVideoSurfaceNV", lib);
	GL_CHECK(gl.VDPAURegisterVideoSurfaceNV);
	gl.VDPAUSurfaceAccessNV = (void APIENTRY (*)(GLvdpauSurfaceNV surface, GLenum access)) ldg_find("glVDPAUSurfaceAccessNV", lib);
	GL_CHECK(gl.VDPAUSurfaceAccessNV);
	gl.VDPAUUnmapSurfacesNV = (void APIENTRY (*)(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces)) ldg_find("glVDPAUUnmapSurfacesNV", lib);
	GL_CHECK(gl.VDPAUUnmapSurfacesNV);
	gl.VDPAUUnregisterSurfaceNV = (void APIENTRY (*)(GLvdpauSurfaceNV surface)) ldg_find("glVDPAUUnregisterSurfaceNV", lib);
	GL_CHECK(gl.VDPAUUnregisterSurfaceNV);
	gl.ValidateProgram = (void APIENTRY (*)(GLuint program)) ldg_find("glValidateProgram", lib);
	GL_CHECK(gl.ValidateProgram);
	gl.ValidateProgramARB = (void APIENTRY (*)(GLhandleARB programObj)) ldg_find("glValidateProgramARB", lib);
	GL_CHECK(gl.ValidateProgramARB);
	gl.ValidateProgramPipeline = (void APIENTRY (*)(GLuint pipeline)) ldg_find("glValidateProgramPipeline", lib);
	GL_CHECK(gl.ValidateProgramPipeline);
	gl.VariantArrayObjectATI = (void APIENTRY (*)(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset)) ldg_find("glVariantArrayObjectATI", lib);
	GL_CHECK(gl.VariantArrayObjectATI);
	gl.VariantPointerEXT = (void APIENTRY (*)(GLuint id, GLenum type, GLuint stride, const void *addr)) ldg_find("glVariantPointerEXT", lib);
	GL_CHECK(gl.VariantPointerEXT);
	gl.VariantbvEXT = (void APIENTRY (*)(GLuint id, const GLbyte *addr)) ldg_find("glVariantbvEXT", lib);
	GL_CHECK(gl.VariantbvEXT);
	gl.VariantdvEXT = (void APIENTRY (*)(GLuint id, const GLdouble *addr)) ldg_find("glVariantdvEXT", lib);
	GL_CHECK(gl.VariantdvEXT);
	gl.VariantfvEXT = (void APIENTRY (*)(GLuint id, const GLfloat *addr)) ldg_find("glVariantfvEXT", lib);
	GL_CHECK(gl.VariantfvEXT);
	gl.VariantivEXT = (void APIENTRY (*)(GLuint id, const GLint *addr)) ldg_find("glVariantivEXT", lib);
	GL_CHECK(gl.VariantivEXT);
	gl.VariantsvEXT = (void APIENTRY (*)(GLuint id, const GLshort *addr)) ldg_find("glVariantsvEXT", lib);
	GL_CHECK(gl.VariantsvEXT);
	gl.VariantubvEXT = (void APIENTRY (*)(GLuint id, const GLubyte *addr)) ldg_find("glVariantubvEXT", lib);
	GL_CHECK(gl.VariantubvEXT);
	gl.VariantuivEXT = (void APIENTRY (*)(GLuint id, const GLuint *addr)) ldg_find("glVariantuivEXT", lib);
	GL_CHECK(gl.VariantuivEXT);
	gl.VariantusvEXT = (void APIENTRY (*)(GLuint id, const GLushort *addr)) ldg_find("glVariantusvEXT", lib);
	GL_CHECK(gl.VariantusvEXT);
	gl.Vertex2bOES = (void APIENTRY (*)(GLbyte32 x)) ldg_find("glVertex2bOES", lib);
	GL_CHECK(gl.Vertex2bOES);
	gl.Vertex2bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glVertex2bvOES", lib);
	GL_CHECK(gl.Vertex2bvOES);
	gl.Vertex2d = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glVertex2d", lib);
	GL_CHECK(gl.Vertex2d);
	gl.Vertex2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glVertex2dv", lib);
	GL_CHECK(gl.Vertex2dv);
	gl.Vertex2f = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glVertex2f", lib);
	GL_CHECK(gl.Vertex2f);
	gl.Vertex2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glVertex2fv", lib);
	GL_CHECK(gl.Vertex2fv);
	gl.Vertex2hNV = (void APIENTRY (*)(GLhalfNV32 x, GLhalfNV32 y)) ldg_find("glVertex2hNV", lib);
	GL_CHECK(gl.Vertex2hNV);
	gl.Vertex2hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glVertex2hvNV", lib);
	GL_CHECK(gl.Vertex2hvNV);
	gl.Vertex2i = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glVertex2i", lib);
	GL_CHECK(gl.Vertex2i);
	gl.Vertex2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glVertex2iv", lib);
	GL_CHECK(gl.Vertex2iv);
	gl.Vertex2s = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glVertex2s", lib);
	GL_CHECK(gl.Vertex2s);
	gl.Vertex2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glVertex2sv", lib);
	GL_CHECK(gl.Vertex2sv);
	gl.Vertex2xOES = (void APIENTRY (*)(GLfixed x)) ldg_find("glVertex2xOES", lib);
	GL_CHECK(gl.Vertex2xOES);
	gl.Vertex2xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glVertex2xvOES", lib);
	GL_CHECK(gl.Vertex2xvOES);
	gl.Vertex3bOES = (void APIENTRY (*)(GLbyte32 x, GLbyte32 y)) ldg_find("glVertex3bOES", lib);
	GL_CHECK(gl.Vertex3bOES);
	gl.Vertex3bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glVertex3bvOES", lib);
	GL_CHECK(gl.Vertex3bvOES);
	gl.Vertex3d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertex3d", lib);
	GL_CHECK(gl.Vertex3d);
	gl.Vertex3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glVertex3dv", lib);
	GL_CHECK(gl.Vertex3dv);
	gl.Vertex3f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertex3f", lib);
	GL_CHECK(gl.Vertex3f);
	gl.Vertex3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glVertex3fv", lib);
	GL_CHECK(gl.Vertex3fv);
	gl.Vertex3hNV = (void APIENTRY (*)(GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z)) ldg_find("glVertex3hNV", lib);
	GL_CHECK(gl.Vertex3hNV);
	gl.Vertex3hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glVertex3hvNV", lib);
	GL_CHECK(gl.Vertex3hvNV);
	gl.Vertex3i = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glVertex3i", lib);
	GL_CHECK(gl.Vertex3i);
	gl.Vertex3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glVertex3iv", lib);
	GL_CHECK(gl.Vertex3iv);
	gl.Vertex3s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertex3s", lib);
	GL_CHECK(gl.Vertex3s);
	gl.Vertex3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glVertex3sv", lib);
	GL_CHECK(gl.Vertex3sv);
	gl.Vertex3xOES = (void APIENTRY (*)(GLfixed x, GLfixed y)) ldg_find("glVertex3xOES", lib);
	GL_CHECK(gl.Vertex3xOES);
	gl.Vertex3xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glVertex3xvOES", lib);
	GL_CHECK(gl.Vertex3xvOES);
	gl.Vertex4bOES = (void APIENTRY (*)(GLbyte32 x, GLbyte32 y, GLbyte32 z)) ldg_find("glVertex4bOES", lib);
	GL_CHECK(gl.Vertex4bOES);
	gl.Vertex4bvOES = (void APIENTRY (*)(const GLbyte *coords)) ldg_find("glVertex4bvOES", lib);
	GL_CHECK(gl.Vertex4bvOES);
	gl.Vertex4d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertex4d", lib);
	GL_CHECK(gl.Vertex4d);
	gl.Vertex4dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glVertex4dv", lib);
	GL_CHECK(gl.Vertex4dv);
	gl.Vertex4f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertex4f", lib);
	GL_CHECK(gl.Vertex4f);
	gl.Vertex4fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glVertex4fv", lib);
	GL_CHECK(gl.Vertex4fv);
	gl.Vertex4hNV = (void APIENTRY (*)(GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z, GLhalfNV32 w)) ldg_find("glVertex4hNV", lib);
	GL_CHECK(gl.Vertex4hNV);
	gl.Vertex4hvNV = (void APIENTRY (*)(const GLhalfNV *v)) ldg_find("glVertex4hvNV", lib);
	GL_CHECK(gl.Vertex4hvNV);
	gl.Vertex4i = (void APIENTRY (*)(GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertex4i", lib);
	GL_CHECK(gl.Vertex4i);
	gl.Vertex4iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glVertex4iv", lib);
	GL_CHECK(gl.Vertex4iv);
	gl.Vertex4s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertex4s", lib);
	GL_CHECK(gl.Vertex4s);
	gl.Vertex4sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glVertex4sv", lib);
	GL_CHECK(gl.Vertex4sv);
	gl.Vertex4xOES = (void APIENTRY (*)(GLfixed x, GLfixed y, GLfixed z)) ldg_find("glVertex4xOES", lib);
	GL_CHECK(gl.Vertex4xOES);
	gl.Vertex4xvOES = (void APIENTRY (*)(const GLfixed *coords)) ldg_find("glVertex4xvOES", lib);
	GL_CHECK(gl.Vertex4xvOES);
	gl.VertexArrayBindVertexBufferEXT = (void APIENTRY (*)(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)) ldg_find("glVertexArrayBindVertexBufferEXT", lib);
	GL_CHECK(gl.VertexArrayBindVertexBufferEXT);
	gl.VertexArrayColorOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayColorOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayColorOffsetEXT);
	gl.VertexArrayEdgeFlagOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayEdgeFlagOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayEdgeFlagOffsetEXT);
	gl.VertexArrayFogCoordOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayFogCoordOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayFogCoordOffsetEXT);
	gl.VertexArrayIndexOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayIndexOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayIndexOffsetEXT);
	gl.VertexArrayMultiTexCoordOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayMultiTexCoordOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayMultiTexCoordOffsetEXT);
	gl.VertexArrayNormalOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayNormalOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayNormalOffsetEXT);
	gl.VertexArrayParameteriAPPLE = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glVertexArrayParameteriAPPLE", lib);
	GL_CHECK(gl.VertexArrayParameteriAPPLE);
	gl.VertexArrayRangeAPPLE = (void APIENTRY (*)(GLsizei length, void *pointer)) ldg_find("glVertexArrayRangeAPPLE", lib);
	GL_CHECK(gl.VertexArrayRangeAPPLE);
	gl.VertexArrayRangeNV = (void APIENTRY (*)(GLsizei length, const void *pointer)) ldg_find("glVertexArrayRangeNV", lib);
	GL_CHECK(gl.VertexArrayRangeNV);
	gl.VertexArraySecondaryColorOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArraySecondaryColorOffsetEXT", lib);
	GL_CHECK(gl.VertexArraySecondaryColorOffsetEXT);
	gl.VertexArrayTexCoordOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayTexCoordOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayTexCoordOffsetEXT);
	gl.VertexArrayVertexAttribBindingEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLuint bindingindex)) ldg_find("glVertexArrayVertexAttribBindingEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribBindingEXT);
	gl.VertexArrayVertexAttribDivisorEXT = (void APIENTRY (*)(GLuint vaobj, GLuint index, GLuint divisor)) ldg_find("glVertexArrayVertexAttribDivisorEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribDivisorEXT);
	gl.VertexArrayVertexAttribFormatEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)) ldg_find("glVertexArrayVertexAttribFormatEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribFormatEXT);
	gl.VertexArrayVertexAttribIFormatEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexArrayVertexAttribIFormatEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribIFormatEXT);
	gl.VertexArrayVertexAttribIOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexAttribIOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribIOffsetEXT);
	gl.VertexArrayVertexAttribLFormatEXT = (void APIENTRY (*)(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexArrayVertexAttribLFormatEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribLFormatEXT);
	gl.VertexArrayVertexAttribLOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexAttribLOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribLOffsetEXT);
	gl.VertexArrayVertexAttribOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexAttribOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayVertexAttribOffsetEXT);
	gl.VertexArrayVertexBindingDivisorEXT = (void APIENTRY (*)(GLuint vaobj, GLuint bindingindex, GLuint divisor)) ldg_find("glVertexArrayVertexBindingDivisorEXT", lib);
	GL_CHECK(gl.VertexArrayVertexBindingDivisorEXT);
	gl.VertexArrayVertexOffsetEXT = (void APIENTRY (*)(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)) ldg_find("glVertexArrayVertexOffsetEXT", lib);
	GL_CHECK(gl.VertexArrayVertexOffsetEXT);
	gl.VertexAttrib1d = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttrib1d", lib);
	GL_CHECK(gl.VertexAttrib1d);
	gl.VertexAttrib1dARB = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttrib1dARB", lib);
	GL_CHECK(gl.VertexAttrib1dARB);
	gl.VertexAttrib1dNV = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttrib1dNV", lib);
	GL_CHECK(gl.VertexAttrib1dNV);
	gl.VertexAttrib1dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib1dv", lib);
	GL_CHECK(gl.VertexAttrib1dv);
	gl.VertexAttrib1dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib1dvARB", lib);
	GL_CHECK(gl.VertexAttrib1dvARB);
	gl.VertexAttrib1dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib1dvNV", lib);
	GL_CHECK(gl.VertexAttrib1dvNV);
	gl.VertexAttrib1f = (void APIENTRY (*)(GLuint index, GLfloat x)) ldg_find("glVertexAttrib1f", lib);
	GL_CHECK(gl.VertexAttrib1f);
	gl.VertexAttrib1fARB = (void APIENTRY (*)(GLuint index, GLfloat x)) ldg_find("glVertexAttrib1fARB", lib);
	GL_CHECK(gl.VertexAttrib1fARB);
	gl.VertexAttrib1fNV = (void APIENTRY (*)(GLuint index, GLfloat x)) ldg_find("glVertexAttrib1fNV", lib);
	GL_CHECK(gl.VertexAttrib1fNV);
	gl.VertexAttrib1fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib1fv", lib);
	GL_CHECK(gl.VertexAttrib1fv);
	gl.VertexAttrib1fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib1fvARB", lib);
	GL_CHECK(gl.VertexAttrib1fvARB);
	gl.VertexAttrib1fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib1fvNV", lib);
	GL_CHECK(gl.VertexAttrib1fvNV);
	gl.VertexAttrib1hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x)) ldg_find("glVertexAttrib1hNV", lib);
	GL_CHECK(gl.VertexAttrib1hNV);
	gl.VertexAttrib1hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib1hvNV", lib);
	GL_CHECK(gl.VertexAttrib1hvNV);
	gl.VertexAttrib1s = (void APIENTRY (*)(GLuint index, GLshort32 x)) ldg_find("glVertexAttrib1s", lib);
	GL_CHECK(gl.VertexAttrib1s);
	gl.VertexAttrib1sARB = (void APIENTRY (*)(GLuint index, GLshort32 x)) ldg_find("glVertexAttrib1sARB", lib);
	GL_CHECK(gl.VertexAttrib1sARB);
	gl.VertexAttrib1sNV = (void APIENTRY (*)(GLuint index, GLshort32 x)) ldg_find("glVertexAttrib1sNV", lib);
	GL_CHECK(gl.VertexAttrib1sNV);
	gl.VertexAttrib1sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib1sv", lib);
	GL_CHECK(gl.VertexAttrib1sv);
	gl.VertexAttrib1svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib1svARB", lib);
	GL_CHECK(gl.VertexAttrib1svARB);
	gl.VertexAttrib1svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib1svNV", lib);
	GL_CHECK(gl.VertexAttrib1svNV);
	gl.VertexAttrib2d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttrib2d", lib);
	GL_CHECK(gl.VertexAttrib2d);
	gl.VertexAttrib2dARB = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttrib2dARB", lib);
	GL_CHECK(gl.VertexAttrib2dARB);
	gl.VertexAttrib2dNV = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttrib2dNV", lib);
	GL_CHECK(gl.VertexAttrib2dNV);
	gl.VertexAttrib2dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib2dv", lib);
	GL_CHECK(gl.VertexAttrib2dv);
	gl.VertexAttrib2dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib2dvARB", lib);
	GL_CHECK(gl.VertexAttrib2dvARB);
	gl.VertexAttrib2dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib2dvNV", lib);
	GL_CHECK(gl.VertexAttrib2dvNV);
	gl.VertexAttrib2f = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y)) ldg_find("glVertexAttrib2f", lib);
	GL_CHECK(gl.VertexAttrib2f);
	gl.VertexAttrib2fARB = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y)) ldg_find("glVertexAttrib2fARB", lib);
	GL_CHECK(gl.VertexAttrib2fARB);
	gl.VertexAttrib2fNV = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y)) ldg_find("glVertexAttrib2fNV", lib);
	GL_CHECK(gl.VertexAttrib2fNV);
	gl.VertexAttrib2fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib2fv", lib);
	GL_CHECK(gl.VertexAttrib2fv);
	gl.VertexAttrib2fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib2fvARB", lib);
	GL_CHECK(gl.VertexAttrib2fvARB);
	gl.VertexAttrib2fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib2fvNV", lib);
	GL_CHECK(gl.VertexAttrib2fvNV);
	gl.VertexAttrib2hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x, GLhalfNV32 y)) ldg_find("glVertexAttrib2hNV", lib);
	GL_CHECK(gl.VertexAttrib2hNV);
	gl.VertexAttrib2hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib2hvNV", lib);
	GL_CHECK(gl.VertexAttrib2hvNV);
	gl.VertexAttrib2s = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y)) ldg_find("glVertexAttrib2s", lib);
	GL_CHECK(gl.VertexAttrib2s);
	gl.VertexAttrib2sARB = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y)) ldg_find("glVertexAttrib2sARB", lib);
	GL_CHECK(gl.VertexAttrib2sARB);
	gl.VertexAttrib2sNV = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y)) ldg_find("glVertexAttrib2sNV", lib);
	GL_CHECK(gl.VertexAttrib2sNV);
	gl.VertexAttrib2sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib2sv", lib);
	GL_CHECK(gl.VertexAttrib2sv);
	gl.VertexAttrib2svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib2svARB", lib);
	GL_CHECK(gl.VertexAttrib2svARB);
	gl.VertexAttrib2svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib2svNV", lib);
	GL_CHECK(gl.VertexAttrib2svNV);
	gl.VertexAttrib3d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttrib3d", lib);
	GL_CHECK(gl.VertexAttrib3d);
	gl.VertexAttrib3dARB = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttrib3dARB", lib);
	GL_CHECK(gl.VertexAttrib3dARB);
	gl.VertexAttrib3dNV = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttrib3dNV", lib);
	GL_CHECK(gl.VertexAttrib3dNV);
	gl.VertexAttrib3dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib3dv", lib);
	GL_CHECK(gl.VertexAttrib3dv);
	gl.VertexAttrib3dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib3dvARB", lib);
	GL_CHECK(gl.VertexAttrib3dvARB);
	gl.VertexAttrib3dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib3dvNV", lib);
	GL_CHECK(gl.VertexAttrib3dvNV);
	gl.VertexAttrib3f = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexAttrib3f", lib);
	GL_CHECK(gl.VertexAttrib3f);
	gl.VertexAttrib3fARB = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexAttrib3fARB", lib);
	GL_CHECK(gl.VertexAttrib3fARB);
	gl.VertexAttrib3fNV = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexAttrib3fNV", lib);
	GL_CHECK(gl.VertexAttrib3fNV);
	gl.VertexAttrib3fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib3fv", lib);
	GL_CHECK(gl.VertexAttrib3fv);
	gl.VertexAttrib3fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib3fvARB", lib);
	GL_CHECK(gl.VertexAttrib3fvARB);
	gl.VertexAttrib3fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib3fvNV", lib);
	GL_CHECK(gl.VertexAttrib3fvNV);
	gl.VertexAttrib3hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z)) ldg_find("glVertexAttrib3hNV", lib);
	GL_CHECK(gl.VertexAttrib3hNV);
	gl.VertexAttrib3hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib3hvNV", lib);
	GL_CHECK(gl.VertexAttrib3hvNV);
	gl.VertexAttrib3s = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexAttrib3s", lib);
	GL_CHECK(gl.VertexAttrib3s);
	gl.VertexAttrib3sARB = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexAttrib3sARB", lib);
	GL_CHECK(gl.VertexAttrib3sARB);
	gl.VertexAttrib3sNV = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexAttrib3sNV", lib);
	GL_CHECK(gl.VertexAttrib3sNV);
	gl.VertexAttrib3sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib3sv", lib);
	GL_CHECK(gl.VertexAttrib3sv);
	gl.VertexAttrib3svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib3svARB", lib);
	GL_CHECK(gl.VertexAttrib3svARB);
	gl.VertexAttrib3svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib3svNV", lib);
	GL_CHECK(gl.VertexAttrib3svNV);
	gl.VertexAttrib4Nbv = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4Nbv", lib);
	GL_CHECK(gl.VertexAttrib4Nbv);
	gl.VertexAttrib4NbvARB = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4NbvARB", lib);
	GL_CHECK(gl.VertexAttrib4NbvARB);
	gl.VertexAttrib4Niv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4Niv", lib);
	GL_CHECK(gl.VertexAttrib4Niv);
	gl.VertexAttrib4NivARB = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4NivARB", lib);
	GL_CHECK(gl.VertexAttrib4NivARB);
	gl.VertexAttrib4Nsv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4Nsv", lib);
	GL_CHECK(gl.VertexAttrib4Nsv);
	gl.VertexAttrib4NsvARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4NsvARB", lib);
	GL_CHECK(gl.VertexAttrib4NsvARB);
	gl.VertexAttrib4Nub = (void APIENTRY (*)(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)) ldg_find("glVertexAttrib4Nub", lib);
	GL_CHECK(gl.VertexAttrib4Nub);
	gl.VertexAttrib4NubARB = (void APIENTRY (*)(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)) ldg_find("glVertexAttrib4NubARB", lib);
	GL_CHECK(gl.VertexAttrib4NubARB);
	gl.VertexAttrib4Nubv = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4Nubv", lib);
	GL_CHECK(gl.VertexAttrib4Nubv);
	gl.VertexAttrib4NubvARB = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4NubvARB", lib);
	GL_CHECK(gl.VertexAttrib4NubvARB);
	gl.VertexAttrib4Nuiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4Nuiv", lib);
	GL_CHECK(gl.VertexAttrib4Nuiv);
	gl.VertexAttrib4NuivARB = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4NuivARB", lib);
	GL_CHECK(gl.VertexAttrib4NuivARB);
	gl.VertexAttrib4Nusv = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4Nusv", lib);
	GL_CHECK(gl.VertexAttrib4Nusv);
	gl.VertexAttrib4NusvARB = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4NusvARB", lib);
	GL_CHECK(gl.VertexAttrib4NusvARB);
	gl.VertexAttrib4bv = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4bv", lib);
	GL_CHECK(gl.VertexAttrib4bv);
	gl.VertexAttrib4bvARB = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttrib4bvARB", lib);
	GL_CHECK(gl.VertexAttrib4bvARB);
	gl.VertexAttrib4d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttrib4d", lib);
	GL_CHECK(gl.VertexAttrib4d);
	gl.VertexAttrib4dARB = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttrib4dARB", lib);
	GL_CHECK(gl.VertexAttrib4dARB);
	gl.VertexAttrib4dNV = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttrib4dNV", lib);
	GL_CHECK(gl.VertexAttrib4dNV);
	gl.VertexAttrib4dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib4dv", lib);
	GL_CHECK(gl.VertexAttrib4dv);
	gl.VertexAttrib4dvARB = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib4dvARB", lib);
	GL_CHECK(gl.VertexAttrib4dvARB);
	gl.VertexAttrib4dvNV = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttrib4dvNV", lib);
	GL_CHECK(gl.VertexAttrib4dvNV);
	gl.VertexAttrib4f = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexAttrib4f", lib);
	GL_CHECK(gl.VertexAttrib4f);
	gl.VertexAttrib4fARB = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexAttrib4fARB", lib);
	GL_CHECK(gl.VertexAttrib4fARB);
	gl.VertexAttrib4fNV = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexAttrib4fNV", lib);
	GL_CHECK(gl.VertexAttrib4fNV);
	gl.VertexAttrib4fv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib4fv", lib);
	GL_CHECK(gl.VertexAttrib4fv);
	gl.VertexAttrib4fvARB = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib4fvARB", lib);
	GL_CHECK(gl.VertexAttrib4fvARB);
	gl.VertexAttrib4fvNV = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glVertexAttrib4fvNV", lib);
	GL_CHECK(gl.VertexAttrib4fvNV);
	gl.VertexAttrib4hNV = (void APIENTRY (*)(GLuint index, GLhalfNV32 x, GLhalfNV32 y, GLhalfNV32 z, GLhalfNV32 w)) ldg_find("glVertexAttrib4hNV", lib);
	GL_CHECK(gl.VertexAttrib4hNV);
	gl.VertexAttrib4hvNV = (void APIENTRY (*)(GLuint index, const GLhalfNV *v)) ldg_find("glVertexAttrib4hvNV", lib);
	GL_CHECK(gl.VertexAttrib4hvNV);
	gl.VertexAttrib4iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4iv", lib);
	GL_CHECK(gl.VertexAttrib4iv);
	gl.VertexAttrib4ivARB = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttrib4ivARB", lib);
	GL_CHECK(gl.VertexAttrib4ivARB);
	gl.VertexAttrib4s = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexAttrib4s", lib);
	GL_CHECK(gl.VertexAttrib4s);
	gl.VertexAttrib4sARB = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexAttrib4sARB", lib);
	GL_CHECK(gl.VertexAttrib4sARB);
	gl.VertexAttrib4sNV = (void APIENTRY (*)(GLuint index, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexAttrib4sNV", lib);
	GL_CHECK(gl.VertexAttrib4sNV);
	gl.VertexAttrib4sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4sv", lib);
	GL_CHECK(gl.VertexAttrib4sv);
	gl.VertexAttrib4svARB = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4svARB", lib);
	GL_CHECK(gl.VertexAttrib4svARB);
	gl.VertexAttrib4svNV = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttrib4svNV", lib);
	GL_CHECK(gl.VertexAttrib4svNV);
	gl.VertexAttrib4ubNV = (void APIENTRY (*)(GLuint index, GLubyte32 x, GLubyte32 y, GLubyte32 z, GLubyte32 w)) ldg_find("glVertexAttrib4ubNV", lib);
	GL_CHECK(gl.VertexAttrib4ubNV);
	gl.VertexAttrib4ubv = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4ubv", lib);
	GL_CHECK(gl.VertexAttrib4ubv);
	gl.VertexAttrib4ubvARB = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4ubvARB", lib);
	GL_CHECK(gl.VertexAttrib4ubvARB);
	gl.VertexAttrib4ubvNV = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttrib4ubvNV", lib);
	GL_CHECK(gl.VertexAttrib4ubvNV);
	gl.VertexAttrib4uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4uiv", lib);
	GL_CHECK(gl.VertexAttrib4uiv);
	gl.VertexAttrib4uivARB = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttrib4uivARB", lib);
	GL_CHECK(gl.VertexAttrib4uivARB);
	gl.VertexAttrib4usv = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4usv", lib);
	GL_CHECK(gl.VertexAttrib4usv);
	gl.VertexAttrib4usvARB = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttrib4usvARB", lib);
	GL_CHECK(gl.VertexAttrib4usvARB);
	gl.VertexAttribArrayObjectATI = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, GLuint buffer, GLuint offset)) ldg_find("glVertexAttribArrayObjectATI", lib);
	GL_CHECK(gl.VertexAttribArrayObjectATI);
	gl.VertexAttribBinding = (void APIENTRY (*)(GLuint attribindex, GLuint bindingindex)) ldg_find("glVertexAttribBinding", lib);
	GL_CHECK(gl.VertexAttribBinding);
	gl.VertexAttribDivisor = (void APIENTRY (*)(GLuint index, GLuint divisor)) ldg_find("glVertexAttribDivisor", lib);
	GL_CHECK(gl.VertexAttribDivisor);
	gl.VertexAttribDivisorARB = (void APIENTRY (*)(GLuint index, GLuint divisor)) ldg_find("glVertexAttribDivisorARB", lib);
	GL_CHECK(gl.VertexAttribDivisorARB);
	gl.VertexAttribFormat = (void APIENTRY (*)(GLuint attribindex, GLint size, GLenum type, GLboolean32 normalized, GLuint relativeoffset)) ldg_find("glVertexAttribFormat", lib);
	GL_CHECK(gl.VertexAttribFormat);
	gl.VertexAttribFormatNV = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride)) ldg_find("glVertexAttribFormatNV", lib);
	GL_CHECK(gl.VertexAttribFormatNV);
	gl.VertexAttribI1i = (void APIENTRY (*)(GLuint index, GLint x)) ldg_find("glVertexAttribI1i", lib);
	GL_CHECK(gl.VertexAttribI1i);
	gl.VertexAttribI1iEXT = (void APIENTRY (*)(GLuint index, GLint x)) ldg_find("glVertexAttribI1iEXT", lib);
	GL_CHECK(gl.VertexAttribI1iEXT);
	gl.VertexAttribI1iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI1iv", lib);
	GL_CHECK(gl.VertexAttribI1iv);
	gl.VertexAttribI1ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI1ivEXT", lib);
	GL_CHECK(gl.VertexAttribI1ivEXT);
	gl.VertexAttribI1ui = (void APIENTRY (*)(GLuint index, GLuint x)) ldg_find("glVertexAttribI1ui", lib);
	GL_CHECK(gl.VertexAttribI1ui);
	gl.VertexAttribI1uiEXT = (void APIENTRY (*)(GLuint index, GLuint x)) ldg_find("glVertexAttribI1uiEXT", lib);
	GL_CHECK(gl.VertexAttribI1uiEXT);
	gl.VertexAttribI1uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI1uiv", lib);
	GL_CHECK(gl.VertexAttribI1uiv);
	gl.VertexAttribI1uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI1uivEXT", lib);
	GL_CHECK(gl.VertexAttribI1uivEXT);
	gl.VertexAttribI2i = (void APIENTRY (*)(GLuint index, GLint x, GLint y)) ldg_find("glVertexAttribI2i", lib);
	GL_CHECK(gl.VertexAttribI2i);
	gl.VertexAttribI2iEXT = (void APIENTRY (*)(GLuint index, GLint x, GLint y)) ldg_find("glVertexAttribI2iEXT", lib);
	GL_CHECK(gl.VertexAttribI2iEXT);
	gl.VertexAttribI2iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI2iv", lib);
	GL_CHECK(gl.VertexAttribI2iv);
	gl.VertexAttribI2ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI2ivEXT", lib);
	GL_CHECK(gl.VertexAttribI2ivEXT);
	gl.VertexAttribI2ui = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y)) ldg_find("glVertexAttribI2ui", lib);
	GL_CHECK(gl.VertexAttribI2ui);
	gl.VertexAttribI2uiEXT = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y)) ldg_find("glVertexAttribI2uiEXT", lib);
	GL_CHECK(gl.VertexAttribI2uiEXT);
	gl.VertexAttribI2uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI2uiv", lib);
	GL_CHECK(gl.VertexAttribI2uiv);
	gl.VertexAttribI2uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI2uivEXT", lib);
	GL_CHECK(gl.VertexAttribI2uivEXT);
	gl.VertexAttribI3i = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z)) ldg_find("glVertexAttribI3i", lib);
	GL_CHECK(gl.VertexAttribI3i);
	gl.VertexAttribI3iEXT = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z)) ldg_find("glVertexAttribI3iEXT", lib);
	GL_CHECK(gl.VertexAttribI3iEXT);
	gl.VertexAttribI3iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI3iv", lib);
	GL_CHECK(gl.VertexAttribI3iv);
	gl.VertexAttribI3ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI3ivEXT", lib);
	GL_CHECK(gl.VertexAttribI3ivEXT);
	gl.VertexAttribI3ui = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z)) ldg_find("glVertexAttribI3ui", lib);
	GL_CHECK(gl.VertexAttribI3ui);
	gl.VertexAttribI3uiEXT = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z)) ldg_find("glVertexAttribI3uiEXT", lib);
	GL_CHECK(gl.VertexAttribI3uiEXT);
	gl.VertexAttribI3uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI3uiv", lib);
	GL_CHECK(gl.VertexAttribI3uiv);
	gl.VertexAttribI3uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI3uivEXT", lib);
	GL_CHECK(gl.VertexAttribI3uivEXT);
	gl.VertexAttribI4bv = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttribI4bv", lib);
	GL_CHECK(gl.VertexAttribI4bv);
	gl.VertexAttribI4bvEXT = (void APIENTRY (*)(GLuint index, const GLbyte *v)) ldg_find("glVertexAttribI4bvEXT", lib);
	GL_CHECK(gl.VertexAttribI4bvEXT);
	gl.VertexAttribI4i = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertexAttribI4i", lib);
	GL_CHECK(gl.VertexAttribI4i);
	gl.VertexAttribI4iEXT = (void APIENTRY (*)(GLuint index, GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertexAttribI4iEXT", lib);
	GL_CHECK(gl.VertexAttribI4iEXT);
	gl.VertexAttribI4iv = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI4iv", lib);
	GL_CHECK(gl.VertexAttribI4iv);
	gl.VertexAttribI4ivEXT = (void APIENTRY (*)(GLuint index, const GLint *v)) ldg_find("glVertexAttribI4ivEXT", lib);
	GL_CHECK(gl.VertexAttribI4ivEXT);
	gl.VertexAttribI4sv = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttribI4sv", lib);
	GL_CHECK(gl.VertexAttribI4sv);
	gl.VertexAttribI4svEXT = (void APIENTRY (*)(GLuint index, const GLshort *v)) ldg_find("glVertexAttribI4svEXT", lib);
	GL_CHECK(gl.VertexAttribI4svEXT);
	gl.VertexAttribI4ubv = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttribI4ubv", lib);
	GL_CHECK(gl.VertexAttribI4ubv);
	gl.VertexAttribI4ubvEXT = (void APIENTRY (*)(GLuint index, const GLubyte *v)) ldg_find("glVertexAttribI4ubvEXT", lib);
	GL_CHECK(gl.VertexAttribI4ubvEXT);
	gl.VertexAttribI4ui = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glVertexAttribI4ui", lib);
	GL_CHECK(gl.VertexAttribI4ui);
	gl.VertexAttribI4uiEXT = (void APIENTRY (*)(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)) ldg_find("glVertexAttribI4uiEXT", lib);
	GL_CHECK(gl.VertexAttribI4uiEXT);
	gl.VertexAttribI4uiv = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI4uiv", lib);
	GL_CHECK(gl.VertexAttribI4uiv);
	gl.VertexAttribI4uivEXT = (void APIENTRY (*)(GLuint index, const GLuint *v)) ldg_find("glVertexAttribI4uivEXT", lib);
	GL_CHECK(gl.VertexAttribI4uivEXT);
	gl.VertexAttribI4usv = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttribI4usv", lib);
	GL_CHECK(gl.VertexAttribI4usv);
	gl.VertexAttribI4usvEXT = (void APIENTRY (*)(GLuint index, const GLushort *v)) ldg_find("glVertexAttribI4usvEXT", lib);
	GL_CHECK(gl.VertexAttribI4usvEXT);
	gl.VertexAttribIFormat = (void APIENTRY (*)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexAttribIFormat", lib);
	GL_CHECK(gl.VertexAttribIFormat);
	gl.VertexAttribIFormatNV = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride)) ldg_find("glVertexAttribIFormatNV", lib);
	GL_CHECK(gl.VertexAttribIFormatNV);
	gl.VertexAttribIPointer = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribIPointer", lib);
	GL_CHECK(gl.VertexAttribIPointer);
	gl.VertexAttribIPointerEXT = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribIPointerEXT", lib);
	GL_CHECK(gl.VertexAttribIPointerEXT);
	gl.VertexAttribL1d = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttribL1d", lib);
	GL_CHECK(gl.VertexAttribL1d);
	gl.VertexAttribL1dEXT = (void APIENTRY (*)(GLuint index, GLdouble x)) ldg_find("glVertexAttribL1dEXT", lib);
	GL_CHECK(gl.VertexAttribL1dEXT);
	gl.VertexAttribL1dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL1dv", lib);
	GL_CHECK(gl.VertexAttribL1dv);
	gl.VertexAttribL1dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL1dvEXT", lib);
	GL_CHECK(gl.VertexAttribL1dvEXT);
	gl.VertexAttribL1i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x)) ldg_find("glVertexAttribL1i64NV", lib);
	GL_CHECK(gl.VertexAttribL1i64NV);
	gl.VertexAttribL1i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL1i64vNV", lib);
	GL_CHECK(gl.VertexAttribL1i64vNV);
	gl.VertexAttribL1ui64ARB = (void APIENTRY (*)(GLuint index, GLuint64EXT x)) ldg_find("glVertexAttribL1ui64ARB", lib);
	GL_CHECK(gl.VertexAttribL1ui64ARB);
	gl.VertexAttribL1ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x)) ldg_find("glVertexAttribL1ui64NV", lib);
	GL_CHECK(gl.VertexAttribL1ui64NV);
	gl.VertexAttribL1ui64vARB = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL1ui64vARB", lib);
	GL_CHECK(gl.VertexAttribL1ui64vARB);
	gl.VertexAttribL1ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL1ui64vNV", lib);
	GL_CHECK(gl.VertexAttribL1ui64vNV);
	gl.VertexAttribL2d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttribL2d", lib);
	GL_CHECK(gl.VertexAttribL2d);
	gl.VertexAttribL2dEXT = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y)) ldg_find("glVertexAttribL2dEXT", lib);
	GL_CHECK(gl.VertexAttribL2dEXT);
	gl.VertexAttribL2dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL2dv", lib);
	GL_CHECK(gl.VertexAttribL2dv);
	gl.VertexAttribL2dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL2dvEXT", lib);
	GL_CHECK(gl.VertexAttribL2dvEXT);
	gl.VertexAttribL2i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x, GLint64EXT y)) ldg_find("glVertexAttribL2i64NV", lib);
	GL_CHECK(gl.VertexAttribL2i64NV);
	gl.VertexAttribL2i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL2i64vNV", lib);
	GL_CHECK(gl.VertexAttribL2i64vNV);
	gl.VertexAttribL2ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x, GLuint64EXT y)) ldg_find("glVertexAttribL2ui64NV", lib);
	GL_CHECK(gl.VertexAttribL2ui64NV);
	gl.VertexAttribL2ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL2ui64vNV", lib);
	GL_CHECK(gl.VertexAttribL2ui64vNV);
	gl.VertexAttribL3d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttribL3d", lib);
	GL_CHECK(gl.VertexAttribL3d);
	gl.VertexAttribL3dEXT = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexAttribL3dEXT", lib);
	GL_CHECK(gl.VertexAttribL3dEXT);
	gl.VertexAttribL3dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL3dv", lib);
	GL_CHECK(gl.VertexAttribL3dv);
	gl.VertexAttribL3dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL3dvEXT", lib);
	GL_CHECK(gl.VertexAttribL3dvEXT);
	gl.VertexAttribL3i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z)) ldg_find("glVertexAttribL3i64NV", lib);
	GL_CHECK(gl.VertexAttribL3i64NV);
	gl.VertexAttribL3i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL3i64vNV", lib);
	GL_CHECK(gl.VertexAttribL3i64vNV);
	gl.VertexAttribL3ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)) ldg_find("glVertexAttribL3ui64NV", lib);
	GL_CHECK(gl.VertexAttribL3ui64NV);
	gl.VertexAttribL3ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL3ui64vNV", lib);
	GL_CHECK(gl.VertexAttribL3ui64vNV);
	gl.VertexAttribL4d = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttribL4d", lib);
	GL_CHECK(gl.VertexAttribL4d);
	gl.VertexAttribL4dEXT = (void APIENTRY (*)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexAttribL4dEXT", lib);
	GL_CHECK(gl.VertexAttribL4dEXT);
	gl.VertexAttribL4dv = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL4dv", lib);
	GL_CHECK(gl.VertexAttribL4dv);
	gl.VertexAttribL4dvEXT = (void APIENTRY (*)(GLuint index, const GLdouble *v)) ldg_find("glVertexAttribL4dvEXT", lib);
	GL_CHECK(gl.VertexAttribL4dvEXT);
	gl.VertexAttribL4i64NV = (void APIENTRY (*)(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)) ldg_find("glVertexAttribL4i64NV", lib);
	GL_CHECK(gl.VertexAttribL4i64NV);
	gl.VertexAttribL4i64vNV = (void APIENTRY (*)(GLuint index, const GLint64EXT *v)) ldg_find("glVertexAttribL4i64vNV", lib);
	GL_CHECK(gl.VertexAttribL4i64vNV);
	gl.VertexAttribL4ui64NV = (void APIENTRY (*)(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)) ldg_find("glVertexAttribL4ui64NV", lib);
	GL_CHECK(gl.VertexAttribL4ui64NV);
	gl.VertexAttribL4ui64vNV = (void APIENTRY (*)(GLuint index, const GLuint64EXT *v)) ldg_find("glVertexAttribL4ui64vNV", lib);
	GL_CHECK(gl.VertexAttribL4ui64vNV);
	gl.VertexAttribLFormat = (void APIENTRY (*)(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)) ldg_find("glVertexAttribLFormat", lib);
	GL_CHECK(gl.VertexAttribLFormat);
	gl.VertexAttribLFormatNV = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride)) ldg_find("glVertexAttribLFormatNV", lib);
	GL_CHECK(gl.VertexAttribLFormatNV);
	gl.VertexAttribLPointer = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribLPointer", lib);
	GL_CHECK(gl.VertexAttribLPointer);
	gl.VertexAttribLPointerEXT = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribLPointerEXT", lib);
	GL_CHECK(gl.VertexAttribLPointerEXT);
	gl.VertexAttribP1ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP1ui", lib);
	GL_CHECK(gl.VertexAttribP1ui);
	gl.VertexAttribP1uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP1uiv", lib);
	GL_CHECK(gl.VertexAttribP1uiv);
	gl.VertexAttribP2ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP2ui", lib);
	GL_CHECK(gl.VertexAttribP2ui);
	gl.VertexAttribP2uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP2uiv", lib);
	GL_CHECK(gl.VertexAttribP2uiv);
	gl.VertexAttribP3ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP3ui", lib);
	GL_CHECK(gl.VertexAttribP3ui);
	gl.VertexAttribP3uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP3uiv", lib);
	GL_CHECK(gl.VertexAttribP3uiv);
	gl.VertexAttribP4ui = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, GLuint value)) ldg_find("glVertexAttribP4ui", lib);
	GL_CHECK(gl.VertexAttribP4ui);
	gl.VertexAttribP4uiv = (void APIENTRY (*)(GLuint index, GLenum type, GLboolean32 normalized, const GLuint *value)) ldg_find("glVertexAttribP4uiv", lib);
	GL_CHECK(gl.VertexAttribP4uiv);
	gl.VertexAttribParameteriAMD = (void APIENTRY (*)(GLuint index, GLenum pname, GLint param)) ldg_find("glVertexAttribParameteriAMD", lib);
	GL_CHECK(gl.VertexAttribParameteriAMD);
	gl.VertexAttribPointer = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribPointer", lib);
	GL_CHECK(gl.VertexAttribPointer);
	gl.VertexAttribPointerARB = (void APIENTRY (*)(GLuint index, GLint size, GLenum type, GLboolean32 normalized, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribPointerARB", lib);
	GL_CHECK(gl.VertexAttribPointerARB);
	gl.VertexAttribPointerNV = (void APIENTRY (*)(GLuint index, GLint fsize, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexAttribPointerNV", lib);
	GL_CHECK(gl.VertexAttribPointerNV);
	gl.VertexAttribs1dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs1dvNV", lib);
	GL_CHECK(gl.VertexAttribs1dvNV);
	gl.VertexAttribs1fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs1fvNV", lib);
	GL_CHECK(gl.VertexAttribs1fvNV);
	gl.VertexAttribs1hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs1hvNV", lib);
	GL_CHECK(gl.VertexAttribs1hvNV);
	gl.VertexAttribs1svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs1svNV", lib);
	GL_CHECK(gl.VertexAttribs1svNV);
	gl.VertexAttribs2dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs2dvNV", lib);
	GL_CHECK(gl.VertexAttribs2dvNV);
	gl.VertexAttribs2fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs2fvNV", lib);
	GL_CHECK(gl.VertexAttribs2fvNV);
	gl.VertexAttribs2hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs2hvNV", lib);
	GL_CHECK(gl.VertexAttribs2hvNV);
	gl.VertexAttribs2svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs2svNV", lib);
	GL_CHECK(gl.VertexAttribs2svNV);
	gl.VertexAttribs3dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs3dvNV", lib);
	GL_CHECK(gl.VertexAttribs3dvNV);
	gl.VertexAttribs3fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs3fvNV", lib);
	GL_CHECK(gl.VertexAttribs3fvNV);
	gl.VertexAttribs3hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs3hvNV", lib);
	GL_CHECK(gl.VertexAttribs3hvNV);
	gl.VertexAttribs3svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs3svNV", lib);
	GL_CHECK(gl.VertexAttribs3svNV);
	gl.VertexAttribs4dvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLdouble *v)) ldg_find("glVertexAttribs4dvNV", lib);
	GL_CHECK(gl.VertexAttribs4dvNV);
	gl.VertexAttribs4fvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLfloat *v)) ldg_find("glVertexAttribs4fvNV", lib);
	GL_CHECK(gl.VertexAttribs4fvNV);
	gl.VertexAttribs4hvNV = (void APIENTRY (*)(GLuint index, GLsizei n, const GLhalfNV *v)) ldg_find("glVertexAttribs4hvNV", lib);
	GL_CHECK(gl.VertexAttribs4hvNV);
	gl.VertexAttribs4svNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLshort *v)) ldg_find("glVertexAttribs4svNV", lib);
	GL_CHECK(gl.VertexAttribs4svNV);
	gl.VertexAttribs4ubvNV = (void APIENTRY (*)(GLuint index, GLsizei count, const GLubyte *v)) ldg_find("glVertexAttribs4ubvNV", lib);
	GL_CHECK(gl.VertexAttribs4ubvNV);
	gl.VertexBindingDivisor = (void APIENTRY (*)(GLuint bindingindex, GLuint divisor)) ldg_find("glVertexBindingDivisor", lib);
	GL_CHECK(gl.VertexBindingDivisor);
	gl.VertexBlendARB = (void APIENTRY (*)(GLint count)) ldg_find("glVertexBlendARB", lib);
	GL_CHECK(gl.VertexBlendARB);
	gl.VertexBlendEnvfATI = (void APIENTRY (*)(GLenum pname, GLfloat param)) ldg_find("glVertexBlendEnvfATI", lib);
	GL_CHECK(gl.VertexBlendEnvfATI);
	gl.VertexBlendEnviATI = (void APIENTRY (*)(GLenum pname, GLint param)) ldg_find("glVertexBlendEnviATI", lib);
	GL_CHECK(gl.VertexBlendEnviATI);
	gl.VertexFormatNV = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride)) ldg_find("glVertexFormatNV", lib);
	GL_CHECK(gl.VertexFormatNV);
	gl.VertexP2ui = (void APIENTRY (*)(GLenum type, GLuint value)) ldg_find("glVertexP2ui", lib);
	GL_CHECK(gl.VertexP2ui);
	gl.VertexP2uiv = (void APIENTRY (*)(GLenum type, const GLuint *value)) ldg_find("glVertexP2uiv", lib);
	GL_CHECK(gl.VertexP2uiv);
	gl.VertexP3ui = (void APIENTRY (*)(GLenum type, GLuint value)) ldg_find("glVertexP3ui", lib);
	GL_CHECK(gl.VertexP3ui);
	gl.VertexP3uiv = (void APIENTRY (*)(GLenum type, const GLuint *value)) ldg_find("glVertexP3uiv", lib);
	GL_CHECK(gl.VertexP3uiv);
	gl.VertexP4ui = (void APIENTRY (*)(GLenum type, GLuint value)) ldg_find("glVertexP4ui", lib);
	GL_CHECK(gl.VertexP4ui);
	gl.VertexP4uiv = (void APIENTRY (*)(GLenum type, const GLuint *value)) ldg_find("glVertexP4uiv", lib);
	GL_CHECK(gl.VertexP4uiv);
	gl.VertexPointSizefAPPLE = (void APIENTRY (*)(GLfloat size)) ldg_find("glVertexPointSizefAPPLE", lib);
	GL_CHECK(gl.VertexPointSizefAPPLE);
	gl.VertexPointer = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)) ldg_find("glVertexPointer", lib);
	GL_CHECK(gl.VertexPointer);
	gl.VertexPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer)) ldg_find("glVertexPointerEXT", lib);
	GL_CHECK(gl.VertexPointerEXT);
	gl.VertexPointerListIBM = (void APIENTRY (*)(GLint size, GLenum type, GLint stride, const void * *pointer, GLint ptrstride)) ldg_find("glVertexPointerListIBM", lib);
	GL_CHECK(gl.VertexPointerListIBM);
	gl.VertexPointervINTEL = (void APIENTRY (*)(GLint size, GLenum type, const void * *pointer)) ldg_find("glVertexPointervINTEL", lib);
	GL_CHECK(gl.VertexPointervINTEL);
	gl.VertexStream1dATI = (void APIENTRY (*)(GLenum stream, GLdouble x)) ldg_find("glVertexStream1dATI", lib);
	GL_CHECK(gl.VertexStream1dATI);
	gl.VertexStream1dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream1dvATI", lib);
	GL_CHECK(gl.VertexStream1dvATI);
	gl.VertexStream1fATI = (void APIENTRY (*)(GLenum stream, GLfloat x)) ldg_find("glVertexStream1fATI", lib);
	GL_CHECK(gl.VertexStream1fATI);
	gl.VertexStream1fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream1fvATI", lib);
	GL_CHECK(gl.VertexStream1fvATI);
	gl.VertexStream1iATI = (void APIENTRY (*)(GLenum stream, GLint x)) ldg_find("glVertexStream1iATI", lib);
	GL_CHECK(gl.VertexStream1iATI);
	gl.VertexStream1ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream1ivATI", lib);
	GL_CHECK(gl.VertexStream1ivATI);
	gl.VertexStream1sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x)) ldg_find("glVertexStream1sATI", lib);
	GL_CHECK(gl.VertexStream1sATI);
	gl.VertexStream1svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream1svATI", lib);
	GL_CHECK(gl.VertexStream1svATI);
	gl.VertexStream2dATI = (void APIENTRY (*)(GLenum stream, GLdouble x, GLdouble y)) ldg_find("glVertexStream2dATI", lib);
	GL_CHECK(gl.VertexStream2dATI);
	gl.VertexStream2dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream2dvATI", lib);
	GL_CHECK(gl.VertexStream2dvATI);
	gl.VertexStream2fATI = (void APIENTRY (*)(GLenum stream, GLfloat x, GLfloat y)) ldg_find("glVertexStream2fATI", lib);
	GL_CHECK(gl.VertexStream2fATI);
	gl.VertexStream2fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream2fvATI", lib);
	GL_CHECK(gl.VertexStream2fvATI);
	gl.VertexStream2iATI = (void APIENTRY (*)(GLenum stream, GLint x, GLint y)) ldg_find("glVertexStream2iATI", lib);
	GL_CHECK(gl.VertexStream2iATI);
	gl.VertexStream2ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream2ivATI", lib);
	GL_CHECK(gl.VertexStream2ivATI);
	gl.VertexStream2sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x, GLshort32 y)) ldg_find("glVertexStream2sATI", lib);
	GL_CHECK(gl.VertexStream2sATI);
	gl.VertexStream2svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream2svATI", lib);
	GL_CHECK(gl.VertexStream2svATI);
	gl.VertexStream3dATI = (void APIENTRY (*)(GLenum stream, GLdouble x, GLdouble y, GLdouble z)) ldg_find("glVertexStream3dATI", lib);
	GL_CHECK(gl.VertexStream3dATI);
	gl.VertexStream3dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream3dvATI", lib);
	GL_CHECK(gl.VertexStream3dvATI);
	gl.VertexStream3fATI = (void APIENTRY (*)(GLenum stream, GLfloat x, GLfloat y, GLfloat z)) ldg_find("glVertexStream3fATI", lib);
	GL_CHECK(gl.VertexStream3fATI);
	gl.VertexStream3fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream3fvATI", lib);
	GL_CHECK(gl.VertexStream3fvATI);
	gl.VertexStream3iATI = (void APIENTRY (*)(GLenum stream, GLint x, GLint y, GLint z)) ldg_find("glVertexStream3iATI", lib);
	GL_CHECK(gl.VertexStream3iATI);
	gl.VertexStream3ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream3ivATI", lib);
	GL_CHECK(gl.VertexStream3ivATI);
	gl.VertexStream3sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glVertexStream3sATI", lib);
	GL_CHECK(gl.VertexStream3sATI);
	gl.VertexStream3svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream3svATI", lib);
	GL_CHECK(gl.VertexStream3svATI);
	gl.VertexStream4dATI = (void APIENTRY (*)(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glVertexStream4dATI", lib);
	GL_CHECK(gl.VertexStream4dATI);
	gl.VertexStream4dvATI = (void APIENTRY (*)(GLenum stream, const GLdouble *coords)) ldg_find("glVertexStream4dvATI", lib);
	GL_CHECK(gl.VertexStream4dvATI);
	gl.VertexStream4fATI = (void APIENTRY (*)(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glVertexStream4fATI", lib);
	GL_CHECK(gl.VertexStream4fATI);
	gl.VertexStream4fvATI = (void APIENTRY (*)(GLenum stream, const GLfloat *coords)) ldg_find("glVertexStream4fvATI", lib);
	GL_CHECK(gl.VertexStream4fvATI);
	gl.VertexStream4iATI = (void APIENTRY (*)(GLenum stream, GLint x, GLint y, GLint z, GLint w)) ldg_find("glVertexStream4iATI", lib);
	GL_CHECK(gl.VertexStream4iATI);
	gl.VertexStream4ivATI = (void APIENTRY (*)(GLenum stream, const GLint *coords)) ldg_find("glVertexStream4ivATI", lib);
	GL_CHECK(gl.VertexStream4ivATI);
	gl.VertexStream4sATI = (void APIENTRY (*)(GLenum stream, GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glVertexStream4sATI", lib);
	GL_CHECK(gl.VertexStream4sATI);
	gl.VertexStream4svATI = (void APIENTRY (*)(GLenum stream, const GLshort *coords)) ldg_find("glVertexStream4svATI", lib);
	GL_CHECK(gl.VertexStream4svATI);
	gl.VertexWeightPointerEXT = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glVertexWeightPointerEXT", lib);
	GL_CHECK(gl.VertexWeightPointerEXT);
	gl.VertexWeightfEXT = (void APIENTRY (*)(GLfloat weight)) ldg_find("glVertexWeightfEXT", lib);
	GL_CHECK(gl.VertexWeightfEXT);
	gl.VertexWeightfvEXT = (void APIENTRY (*)(const GLfloat *weight)) ldg_find("glVertexWeightfvEXT", lib);
	GL_CHECK(gl.VertexWeightfvEXT);
	gl.VertexWeighthNV = (void APIENTRY (*)(GLhalfNV32 weight)) ldg_find("glVertexWeighthNV", lib);
	GL_CHECK(gl.VertexWeighthNV);
	gl.VertexWeighthvNV = (void APIENTRY (*)(const GLhalfNV *weight)) ldg_find("glVertexWeighthvNV", lib);
	GL_CHECK(gl.VertexWeighthvNV);
	gl.VideoCaptureNV = (GLenum APIENTRY (*)(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time)) ldg_find("glVideoCaptureNV", lib);
	GL_CHECK(gl.VideoCaptureNV);
	gl.VideoCaptureStreamParameterdvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params)) ldg_find("glVideoCaptureStreamParameterdvNV", lib);
	GL_CHECK(gl.VideoCaptureStreamParameterdvNV);
	gl.VideoCaptureStreamParameterfvNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params)) ldg_find("glVideoCaptureStreamParameterfvNV", lib);
	GL_CHECK(gl.VideoCaptureStreamParameterfvNV);
	gl.VideoCaptureStreamParameterivNV = (void APIENTRY (*)(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params)) ldg_find("glVideoCaptureStreamParameterivNV", lib);
	GL_CHECK(gl.VideoCaptureStreamParameterivNV);
	gl.Viewport = (void APIENTRY (*)(GLint x, GLint y, GLsizei width, GLsizei height)) ldg_find("glViewport", lib);
	GL_CHECK(gl.Viewport);
	gl.ViewportArrayv = (void APIENTRY (*)(GLuint first, GLsizei count, const GLfloat *v)) ldg_find("glViewportArrayv", lib);
	GL_CHECK(gl.ViewportArrayv);
	gl.ViewportIndexedf = (void APIENTRY (*)(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)) ldg_find("glViewportIndexedf", lib);
	GL_CHECK(gl.ViewportIndexedf);
	gl.ViewportIndexedfv = (void APIENTRY (*)(GLuint index, const GLfloat *v)) ldg_find("glViewportIndexedfv", lib);
	GL_CHECK(gl.ViewportIndexedfv);
	gl.WaitSync = (void APIENTRY (*)(GLsync sync, GLbitfield flags, GLuint64 timeout)) ldg_find("glWaitSync", lib);
	GL_CHECK(gl.WaitSync);
	gl.WeightPathsNV = (void APIENTRY (*)(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights)) ldg_find("glWeightPathsNV", lib);
	GL_CHECK(gl.WeightPathsNV);
	gl.WeightPointerARB = (void APIENTRY (*)(GLint size, GLenum type, GLsizei stride, const void *pointer)) ldg_find("glWeightPointerARB", lib);
	GL_CHECK(gl.WeightPointerARB);
	gl.WeightbvARB = (void APIENTRY (*)(GLint size, const GLbyte *weights)) ldg_find("glWeightbvARB", lib);
	GL_CHECK(gl.WeightbvARB);
	gl.WeightdvARB = (void APIENTRY (*)(GLint size, const GLdouble *weights)) ldg_find("glWeightdvARB", lib);
	GL_CHECK(gl.WeightdvARB);
	gl.WeightfvARB = (void APIENTRY (*)(GLint size, const GLfloat *weights)) ldg_find("glWeightfvARB", lib);
	GL_CHECK(gl.WeightfvARB);
	gl.WeightivARB = (void APIENTRY (*)(GLint size, const GLint *weights)) ldg_find("glWeightivARB", lib);
	GL_CHECK(gl.WeightivARB);
	gl.WeightsvARB = (void APIENTRY (*)(GLint size, const GLshort *weights)) ldg_find("glWeightsvARB", lib);
	GL_CHECK(gl.WeightsvARB);
	gl.WeightubvARB = (void APIENTRY (*)(GLint size, const GLubyte *weights)) ldg_find("glWeightubvARB", lib);
	GL_CHECK(gl.WeightubvARB);
	gl.WeightuivARB = (void APIENTRY (*)(GLint size, const GLuint *weights)) ldg_find("glWeightuivARB", lib);
	GL_CHECK(gl.WeightuivARB);
	gl.WeightusvARB = (void APIENTRY (*)(GLint size, const GLushort *weights)) ldg_find("glWeightusvARB", lib);
	GL_CHECK(gl.WeightusvARB);
	gl.WindowPos2d = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glWindowPos2d", lib);
	GL_CHECK(gl.WindowPos2d);
	gl.WindowPos2dARB = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glWindowPos2dARB", lib);
	GL_CHECK(gl.WindowPos2dARB);
	gl.WindowPos2dMESA = (void APIENTRY (*)(GLdouble x, GLdouble y)) ldg_find("glWindowPos2dMESA", lib);
	GL_CHECK(gl.WindowPos2dMESA);
	gl.WindowPos2dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos2dv", lib);
	GL_CHECK(gl.WindowPos2dv);
	gl.WindowPos2dvARB = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos2dvARB", lib);
	GL_CHECK(gl.WindowPos2dvARB);
	gl.WindowPos2dvMESA = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos2dvMESA", lib);
	GL_CHECK(gl.WindowPos2dvMESA);
	gl.WindowPos2f = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glWindowPos2f", lib);
	GL_CHECK(gl.WindowPos2f);
	gl.WindowPos2fARB = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glWindowPos2fARB", lib);
	GL_CHECK(gl.WindowPos2fARB);
	gl.WindowPos2fMESA = (void APIENTRY (*)(GLfloat x, GLfloat y)) ldg_find("glWindowPos2fMESA", lib);
	GL_CHECK(gl.WindowPos2fMESA);
	gl.WindowPos2fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos2fv", lib);
	GL_CHECK(gl.WindowPos2fv);
	gl.WindowPos2fvARB = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos2fvARB", lib);
	GL_CHECK(gl.WindowPos2fvARB);
	gl.WindowPos2fvMESA = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos2fvMESA", lib);
	GL_CHECK(gl.WindowPos2fvMESA);
	gl.WindowPos2i = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glWindowPos2i", lib);
	GL_CHECK(gl.WindowPos2i);
	gl.WindowPos2iARB = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glWindowPos2iARB", lib);
	GL_CHECK(gl.WindowPos2iARB);
	gl.WindowPos2iMESA = (void APIENTRY (*)(GLint x, GLint y)) ldg_find("glWindowPos2iMESA", lib);
	GL_CHECK(gl.WindowPos2iMESA);
	gl.WindowPos2iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos2iv", lib);
	GL_CHECK(gl.WindowPos2iv);
	gl.WindowPos2ivARB = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos2ivARB", lib);
	GL_CHECK(gl.WindowPos2ivARB);
	gl.WindowPos2ivMESA = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos2ivMESA", lib);
	GL_CHECK(gl.WindowPos2ivMESA);
	gl.WindowPos2s = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glWindowPos2s", lib);
	GL_CHECK(gl.WindowPos2s);
	gl.WindowPos2sARB = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glWindowPos2sARB", lib);
	GL_CHECK(gl.WindowPos2sARB);
	gl.WindowPos2sMESA = (void APIENTRY (*)(GLshort32 x, GLshort32 y)) ldg_find("glWindowPos2sMESA", lib);
	GL_CHECK(gl.WindowPos2sMESA);
	gl.WindowPos2sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos2sv", lib);
	GL_CHECK(gl.WindowPos2sv);
	gl.WindowPos2svARB = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos2svARB", lib);
	GL_CHECK(gl.WindowPos2svARB);
	gl.WindowPos2svMESA = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos2svMESA", lib);
	GL_CHECK(gl.WindowPos2svMESA);
	gl.WindowPos3d = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glWindowPos3d", lib);
	GL_CHECK(gl.WindowPos3d);
	gl.WindowPos3dARB = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glWindowPos3dARB", lib);
	GL_CHECK(gl.WindowPos3dARB);
	gl.WindowPos3dMESA = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z)) ldg_find("glWindowPos3dMESA", lib);
	GL_CHECK(gl.WindowPos3dMESA);
	gl.WindowPos3dv = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos3dv", lib);
	GL_CHECK(gl.WindowPos3dv);
	gl.WindowPos3dvARB = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos3dvARB", lib);
	GL_CHECK(gl.WindowPos3dvARB);
	gl.WindowPos3dvMESA = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos3dvMESA", lib);
	GL_CHECK(gl.WindowPos3dvMESA);
	gl.WindowPos3f = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glWindowPos3f", lib);
	GL_CHECK(gl.WindowPos3f);
	gl.WindowPos3fARB = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glWindowPos3fARB", lib);
	GL_CHECK(gl.WindowPos3fARB);
	gl.WindowPos3fMESA = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z)) ldg_find("glWindowPos3fMESA", lib);
	GL_CHECK(gl.WindowPos3fMESA);
	gl.WindowPos3fv = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos3fv", lib);
	GL_CHECK(gl.WindowPos3fv);
	gl.WindowPos3fvARB = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos3fvARB", lib);
	GL_CHECK(gl.WindowPos3fvARB);
	gl.WindowPos3fvMESA = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos3fvMESA", lib);
	GL_CHECK(gl.WindowPos3fvMESA);
	gl.WindowPos3i = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glWindowPos3i", lib);
	GL_CHECK(gl.WindowPos3i);
	gl.WindowPos3iARB = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glWindowPos3iARB", lib);
	GL_CHECK(gl.WindowPos3iARB);
	gl.WindowPos3iMESA = (void APIENTRY (*)(GLint x, GLint y, GLint z)) ldg_find("glWindowPos3iMESA", lib);
	GL_CHECK(gl.WindowPos3iMESA);
	gl.WindowPos3iv = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos3iv", lib);
	GL_CHECK(gl.WindowPos3iv);
	gl.WindowPos3ivARB = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos3ivARB", lib);
	GL_CHECK(gl.WindowPos3ivARB);
	gl.WindowPos3ivMESA = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos3ivMESA", lib);
	GL_CHECK(gl.WindowPos3ivMESA);
	gl.WindowPos3s = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glWindowPos3s", lib);
	GL_CHECK(gl.WindowPos3s);
	gl.WindowPos3sARB = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glWindowPos3sARB", lib);
	GL_CHECK(gl.WindowPos3sARB);
	gl.WindowPos3sMESA = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z)) ldg_find("glWindowPos3sMESA", lib);
	GL_CHECK(gl.WindowPos3sMESA);
	gl.WindowPos3sv = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos3sv", lib);
	GL_CHECK(gl.WindowPos3sv);
	gl.WindowPos3svARB = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos3svARB", lib);
	GL_CHECK(gl.WindowPos3svARB);
	gl.WindowPos3svMESA = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos3svMESA", lib);
	GL_CHECK(gl.WindowPos3svMESA);
	gl.WindowPos4dMESA = (void APIENTRY (*)(GLdouble x, GLdouble y, GLdouble z, GLdouble w)) ldg_find("glWindowPos4dMESA", lib);
	GL_CHECK(gl.WindowPos4dMESA);
	gl.WindowPos4dvMESA = (void APIENTRY (*)(const GLdouble *v)) ldg_find("glWindowPos4dvMESA", lib);
	GL_CHECK(gl.WindowPos4dvMESA);
	gl.WindowPos4fMESA = (void APIENTRY (*)(GLfloat x, GLfloat y, GLfloat z, GLfloat w)) ldg_find("glWindowPos4fMESA", lib);
	GL_CHECK(gl.WindowPos4fMESA);
	gl.WindowPos4fvMESA = (void APIENTRY (*)(const GLfloat *v)) ldg_find("glWindowPos4fvMESA", lib);
	GL_CHECK(gl.WindowPos4fvMESA);
	gl.WindowPos4iMESA = (void APIENTRY (*)(GLint x, GLint y, GLint z, GLint w)) ldg_find("glWindowPos4iMESA", lib);
	GL_CHECK(gl.WindowPos4iMESA);
	gl.WindowPos4ivMESA = (void APIENTRY (*)(const GLint *v)) ldg_find("glWindowPos4ivMESA", lib);
	GL_CHECK(gl.WindowPos4ivMESA);
	gl.WindowPos4sMESA = (void APIENTRY (*)(GLshort32 x, GLshort32 y, GLshort32 z, GLshort32 w)) ldg_find("glWindowPos4sMESA", lib);
	GL_CHECK(gl.WindowPos4sMESA);
	gl.WindowPos4svMESA = (void APIENTRY (*)(const GLshort *v)) ldg_find("glWindowPos4svMESA", lib);
	GL_CHECK(gl.WindowPos4svMESA);
	gl.WriteMaskEXT = (void APIENTRY (*)(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW)) ldg_find("glWriteMaskEXT", lib);
	GL_CHECK(gl.WriteMaskEXT);
	gl.gluLookAt = (void APIENTRY (*)(GLdouble eyeX, GLdouble eyeY, GLdouble eyeZ, GLdouble centerX, GLdouble centerY, GLdouble centerZ, GLdouble upX, GLdouble upY, GLdouble upZ)) ldg_find("gluLookAtd", lib);
	GL_CHECK(gl.gluLookAt);
	gl.gluLookAtf = (void APIENTRY (*)(GLfloat eyeX, GLfloat eyeY, GLfloat eyeZ, GLfloat centerX, GLfloat centerY, GLfloat centerZ, GLfloat upX, GLfloat upY, GLfloat upZ)) ldg_find("gluLookAt", lib);
	GL_CHECK(gl.gluLookAtf);
	gl.information = (void APIENTRY (*)(void)) ldg_find("information", lib);
	GL_CHECK(gl.information);
	gl.max_height = (GLsizei APIENTRY (*)(void)) ldg_find("max_height", lib);
	GL_CHECK(gl.max_height);
	gl.max_width = (GLsizei APIENTRY (*)(void)) ldg_find("max_width", lib);
	GL_CHECK(gl.max_width);
	gl.swapbuffer = (void APIENTRY (*)(void *buffer)) ldg_find("swapbuffer", lib);
	GL_CHECK(gl.swapbuffer);
	return result;
}
#undef GL_CHECK


LDG *ldg_load_osmesa(const char *libname, _WORD *gl)
{
	LDG *lib;
	
	if (libname == NULL)
		libname = "osmesa.ldg";
	if (gl == NULL)
		gl = ldg_global;
	lib = ldg_open(libname, gl);
	if (lib != NULL)
		ldg_init_osmesa(lib);
	return lib;
}


void ldg_unload_osmesa(LDG *lib, _WORD *gl)
{
	if (lib != NULL)
	{
		if (gl == NULL)
			gl = ldg_global;
		ldg_close(lib, gl);
	}
}


#ifdef TEST

#include <mint/arch/nf_ops.h>

int main(void)
{
	LDG *lib;
	
	lib = ldg_load_osmesa(0, 0);
	if (lib == NULL)
		lib = ldg_load_osmesa("c:/gemsys/ldg/osmesa.ldg", 0);
	if (lib == NULL)
	{
		nf_debugprintf("osmesa.ldg not found\n");
		return 1;
	}
	nf_debugprintf("%s: %lx\n", "glBegin", gl.Begin);
	nf_debugprintf("%s: %lx\n", "glOrtho", gl.Ortho);
	nf_debugprintf("%s: %lx\n", "glOrthof", gl.Orthof);
	ldg_unload_osmesa(lib, NULL);
	return 0;
}

#endif
