dnl
dnl Argus Client Software.  Tools to read, analyze and manage Argus data.
dnl Copyright (C) 2000-2004 QoSient, LLC.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl 
dnl
dnl Copyright (c) 1995, 1996, 1997, 1998
dnl	The Regents of the University of California.  All rights reserved.
dnl
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that: (1) source code distributions
dnl retain the above copyright notice and this paragraph in its entirety, (2)
dnl distributions including binary code include the above copyright notice and
dnl this paragraph in its entirety in the documentation or other materials
dnl provided with the distribution, and (3) all advertising materials mentioning
dnl features or use of this software display the following acknowledgement:
dnl ``This product includes software developed by the University of California,
dnl Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
dnl the University nor the names of its contributors may be used to endorse
dnl or promote products derived from this software without specific prior
dnl written permission.
dnl THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
dnl WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
dnl MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
dnl
dnl QOSIENT and LBL autoconf macros
dnl
dnl
dnl Check for flex require flex 2.4 or higher
dnl Check for bison define the yy prefix string
dnl
dnl usage:
dnl
dnl	AC_QOSIENT_LEX_AND_YACC(lex, yacc, yyprefix)
dnl
dnl results:
dnl
dnl	$1 (lex set)
dnl	$2 (yacc appended)
dnl	$3 (optional flex and bison -P prefix)
dnl
AC_DEFUN(AC_QOSIENT_LEX_AND_YACC,
   [AC_CHECK_PROGS($1, flex, lex)
   if test "$$1" = flex ; then
      AC_MSG_CHECKING(for flex 2.4 or higher)
      AC_CACHE_VAL(ac_cv_lbl_flex_v24,
         if flex -V >/dev/null 2>&1; then
            ac_cv_lbl_flex_v24=yes
         else
            ac_cv_lbl_flex_v24=no
         fi)
      AC_MSG_RESULT($ac_cv_lbl_flex_v24)
      if test $ac_cv_lbl_flex_v24 = no ; then
         s="2.4 or higher required"
         AC_MSG_WARN(ignoring obsolete flex executable ($s))
         $1=lex
      fi
   else
      AC_MSG_ERROR(flex not found. see the INSTALL for more info)
   fi

   AC_CHECK_PROGS($2, bison, yacc)

   if test "$$2" = bison ; then
      $2="$$2 -y"
   else
      AC_MSG_ERROR(bison not found. see the INSTALL for more info)
   fi

   if test "$$1" = flex -a -n "$3" ; then
      $1="$$1 -P$3"
      $2="$$2 -p $3"
   fi])

dnl
dnl Determine which compiler we're using (cc or gcc)
dnl If using gcc, determine the version number
dnl If using cc, require that it support ansi prototypes
dnl If using gcc, use -O2 (otherwise use -O)
dnl If using cc, explicitly specify /usr/local/include
dnl
dnl usage:
dnl
dnl	AC_LBL_C_INIT(copt, incls)
dnl
dnl results:
dnl
dnl	$1 (copt set)
dnl	$2 (incls set)
dnl	CC
dnl	LDFLAGS
dnl	ac_cv_lbl_gcc_vers
dnl	LBL_CFLAGS
dnl
AC_DEFUN(AC_LBL_C_INIT,
    [AC_PREREQ(2.12)
    AC_BEFORE([$0], [AC_PROG_CC])
    AC_BEFORE([$0], [AC_LBL_FIXINCLUDES])
    AC_BEFORE([$0], [AC_LBL_DEVEL])
    AC_BEFORE([$0], [AC_QOSIENT_DEBUG])
    AC_ARG_WITH(gcc, [  --without-gcc           don't use gcc])
    $1="-O"
    $2=""
    if test "${srcdir}" != "." ; then
	    $2="-I\$(srcdir)"
    fi
    if test "${CFLAGS+set}" = set; then
	    LBL_CFLAGS="$CFLAGS"
    fi
    if test -z "$CC" ; then
	    case "$target_os" in

	    bsdi*)
		    AC_CHECK_PROG(SHLICC2, shlicc2, yes, no)
		    if test $SHLICC2 = yes ; then
			    CC=shlicc2
			    export CC
		    fi
		    ;;
	    esac
    fi
    if test -z "$CC" -a "$with_gcc" = no ; then
	    CC=cc
	    export CC
    fi
    AC_PROG_CC
    if test "$GCC" = yes ; then
	    if test "$SHLICC2" = yes ; then
		    ac_cv_lbl_gcc_vers=2
		    $1="-O2"
	    else
		    AC_MSG_CHECKING(gcc version)
		    AC_CACHE_VAL(ac_cv_lbl_gcc_vers,
			ac_cv_lbl_gcc_vers=`$CC -v 2>&1 | \
			    sed -e '/^gcc version /!d' \
				-e 's/^gcc version //' \
				-e 's/ .*//' -e 's/^[[[^0-9]]]*//' \
				-e 's/\..*//'`)
		    AC_MSG_RESULT($ac_cv_lbl_gcc_vers)
		    if test $ac_cv_lbl_gcc_vers -gt 1 ; then
			    $1="-O2"
		    fi
	    fi
    else
	    AC_MSG_CHECKING(that $CC handles ansi prototypes)
	    AC_CACHE_VAL(ac_cv_lbl_cc_ansi_prototypes,
		AC_TRY_COMPILE(
		    [#include <sys/types.h>],
		    [int frob(int, char *)],
		    ac_cv_lbl_cc_ansi_prototypes=yes,
		    ac_cv_lbl_cc_ansi_prototypes=no))
	    AC_MSG_RESULT($ac_cv_lbl_cc_ansi_prototypes)
	    if test $ac_cv_lbl_cc_ansi_prototypes = no ; then
		    case "$target_os" in

		    hpux*)
			    AC_MSG_CHECKING(for HP-UX ansi compiler ($CC -Aa -D_HPUX_SOURCE))
			    savedcflags="$CFLAGS"
			    CFLAGS="-Aa -D_HPUX_SOURCE $CFLAGS"
			    AC_CACHE_VAL(ac_cv_lbl_cc_hpux_cc_aa,
				AC_TRY_COMPILE(
				    [#include <sys/types.h>],
				    [int frob(int, char *)],
				    ac_cv_lbl_cc_hpux_cc_aa=yes,
				    ac_cv_lbl_cc_hpux_cc_aa=no))
			    AC_MSG_RESULT($ac_cv_lbl_cc_hpux_cc_aa)
			    if test $ac_cv_lbl_cc_hpux_cc_aa = no ; then
				    AC_MSG_ERROR(see the INSTALL doc for more info)
			    fi
			    CFLAGS="$savedcflags"
			    V_CCOPT="-Aa $V_CCOPT"
			    AC_DEFINE(_HPUX_SOURCE,1,[needed on HP-UX])
			    ;;

		    *)
			    AC_MSG_ERROR(see the INSTALL doc for more info)
			    ;;
		    esac
	    fi
	    $2="$$2 -I/usr/local/include"
	    LDFLAGS="$LDFLAGS -L/usr/local/lib"

	    case "$target_os" in

	    irix*)
		    V_CCOPT="$V_CCOPT -xansi -signed -g3"
		    ;;

	    osf*)
		    V_CCOPT="$V_CCOPT -std1 -g3"
		    ;;

	    ultrix*)
		    AC_MSG_CHECKING(that Ultrix $CC hacks const in prototypes)
		    AC_CACHE_VAL(ac_cv_lbl_cc_const_proto,
			AC_TRY_COMPILE(
			    [#include <sys/types.h>],
			    [struct a { int b; };
			    void c(const struct a *)],
			    ac_cv_lbl_cc_const_proto=yes,
			    ac_cv_lbl_cc_const_proto=no))
		    AC_MSG_RESULT($ac_cv_lbl_cc_const_proto)
		    if test $ac_cv_lbl_cc_const_proto = no ; then
			    AC_DEFINE(const,)
		    fi
		    ;;
	    esac
    fi
])


dnl
dnl Checks to see if unaligned memory accesses fail
dnl
dnl usage:
dnl
dnl	AC_LBL_UNALIGNED_ACCESS
dnl
dnl results:
dnl
dnl	LBL_ALIGN (DEFINED)
dnl
AC_DEFUN(AC_LBL_UNALIGNED_ACCESS,
    [AC_MSG_CHECKING(if unaligned accesses fail)
    AC_CACHE_VAL(ac_cv_lbl_unaligned_fail,
	[case "$target_cpu" in

	# XXX: should also check that they don't do weird things (like on arm)
	alpha*|arm*|hp*|mips|sparc)
		ac_cv_lbl_unaligned_fail=yes
		;;

	*)
		cat >conftest.c <<EOF
#		include <sys/types.h>
#		include <sys/wait.h>
#		include <stdio.h>
		unsigned char a[[5]] = { 1, 2, 3, 4, 5 };
		main() {
		unsigned int i;
		pid_t pid;
		int status;
		/* avoid "core dumped" message */
		pid = fork();
		if (pid <  0)
			exit(2);
		if (pid > 0) {
			/* parent */
			pid = waitpid(pid, &status, 0);
			if (pid < 0)
				exit(3);
			exit(!WIFEXITED(status));
		}
		/* child */
		i = *(unsigned int *)&a[[1]];
		printf("%d\n", i);
		exit(0);
		}
EOF
		${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS \
		    conftest.c $LIBS >/dev/null 2>&1
		if test ! -x conftest ; then
			dnl failed to compile for some reason
			ac_cv_lbl_unaligned_fail=yes
		else
			./conftest >conftest.out
			if test ! -s conftest.out ; then
				ac_cv_lbl_unaligned_fail=yes
			else
				ac_cv_lbl_unaligned_fail=no
			fi
		fi
		rm -f conftest* core core.conftest
		;;
	esac])
    AC_MSG_RESULT($ac_cv_lbl_unaligned_fail)
    if test $ac_cv_lbl_unaligned_fail = yes ; then
	    AC_DEFINE(LBL_ALIGN)
    fi])



dnl
dnl If using gcc and the file .devel exists:
dnl	Compile with -g (if supported) and -Wall
dnl	If using gcc 2, do extra prototype checking
dnl	If an os prototype include exists, symlink os-proto.h to it
dnl
dnl usage:
dnl
dnl	AC_LBL_DEVEL(copt)
dnl
dnl results:
dnl
dnl	$1 (copt appended)
dnl

AC_DEFUN(AC_LBL_DEVEL,
    [rm -f os-proto.h
    if test "${LBL_CFLAGS+set}" = set; then
	    $1="$$1 ${LBL_CFLAGS}"
    fi
    if test -f .devel ; then
	    if test "$GCC" = yes ; then
		    if test "${LBL_CFLAGS+set}" != set; then
			    if test "$ac_cv_prog_cc_g" = yes ; then
				    $1="-g $$1"
			    fi
			    $1="$$1 -Wall"
			    if test $ac_cv_lbl_gcc_vers -gt 1 ; then
				    $1="$$1 -Wmissing-prototypes -Wstrict-prototypes"
			    fi
		    fi
	    else
		    case "$target_os" in

		    irix6*)
			    V_CCOPT="$V_CCOPT -n32"
			    ;;

		    *)
			    ;;
		    esac
	    fi
    fi])

dnl
dnl If the file .debug exists:
dnl	Add ARGUS_DEBUG to the condefs.h file.
dnl
dnl usage:
dnl
dnl	AC_QOSIENT_DEBUG(copt)
dnl
dnl results:
dnl
dnl	$1 (copt appended)
dnl


AC_DEFUN(AC_QOSIENT_DEBUG,
    [
    if test -f .debug ; then
        cat >> confdefs.h <<\EOF
#define ARGUSDEBUG 1
EOF
    fi])


dnl sasl.m4--sasl libraries and includes
dnl Derrick Brashear
dnl from KTH sasl and Arla

AC_DEFUN(AC_CMU_SASL_INC_WHERE1, [
   AC_REQUIRE([AC_PROG_CC_GNU])
   saved_CPPFLAGS=$CPPFLAGS
   CPPFLAGS="$saved_CPPFLAGS -I$1"
   CMU_CHECK_HEADER_NOCACHE(sasl.h, ac_cv_found_sasl_inc=yes, ac_cv_found_sasl_inc=no)
   CPPFLAGS=$saved_CPPFLAGS
])

AC_DEFUN(AC_CMU_SASL_INC_WHERE, [
   for i in $1; do
      AC_CMU_SASL_INC_WHERE1($i)
      CMU_TEST_INCPATH($i, sasl)
      if test "$ac_cv_found_sasl_inc" = "yes"; then
        ac_cv_sasl_where_inc=$i
        break
      fi
    done
])

AC_DEFUN(AC_CMU_SASL_LIB_WHERE1, [
   AC_REQUIRE([AC_PROG_CC_GNU])
   saved_LIBS=$LIBS
   LIBS="$saved_LIBS -L$1 -lsasl"
   AC_TRY_LINK(,
      [sasl_getprop();],
      [ac_cv_found_sasl_lib=yes],
      ac_cv_found_sasl_lib=no)
   LIBS=$saved_LIBS
])

AC_DEFUN(AC_CMU_SASL_LIB_WHERE, [
   for i in $1; do
      AC_CMU_SASL_LIB_WHERE1($i)
      dnl deal with false positives from implicit link paths
      CMU_TEST_LIBPATH($i, sasl)
      if test "$ac_cv_found_sasl_lib" = "yes" ; then
        ac_cv_sasl_where_lib=$i
        break
      fi
    done
])

AC_DEFUN(AC_CMU_SASL, [
   AC_ARG_WITH(sasl,
      [  --with-sasl=DIR         use libsasl in <DIR> [yes]],
      with_sasl="$withval", with_sasl=yes)

   SASLFLAGS=""
   LIB_SASL=""

   if test "$with_sasl" != no ; then
      cmu_saved_CPPFLAGS=$CPPFLAGS
      cmu_saved_LDFLAGS=$LDFLAGS
      cmu_saved_LIBS=$LIBS
   
      if test -d ${with_sasl}; then
          ac_cv_sasl_where_lib=${with_sasl}/lib
          ac_cv_sasl_where_inc=${with_sasl}/include
   
          SASLFLAGS="-I$ac_cv_sasl_where_inc"
          LIB_SASL="-L$ac_cv_sasl_where_lib"
          CPPFLAGS="${cmu_saved_CPPFLAGS} -I${ac_cv_sasl_where_inc}"
          LDFLAGS="${cmu_saved_LDFLAGS} -L${ac_cv_sasl_where_lib}"
      fi
   
      AC_CHECK_HEADER(sasl.h,
           AC_CHECK_LIB(sasl, sasl_getprop, 
                  ac_cv_found_sasl=yes, ac_cv_found_sasl=no), 
                  ac_cv_found_sasl=no)
   
      LIBS="$cmu_saved_LIBS"
      LDFLAGS="$cmu_saved_LDFLAGS"
      CPPFLAGS="$cmu_saved_CPPFLAGS"
   
      if test "$ac_cv_found_sasl" = yes; then
         LIB_SASL="$LIB_SASL -lsasl"

         if test "$with_sasl" != no; then
            AC_DEFINE(ARGUS_SASL, 1)
            AC_SUBST(LIB_SASL)
            AC_SUBST(SASLFLAGS)
         fi
      else
         LIB_SASL=""
         SASLFLAGS=""
      fi
   fi
])



AC_DEFUN(AC_QOSIENT_LARGEFILE_TEST,
[AC_CACHE_CHECK([for LARGEFILE support],
  ac_cv_decl_sys_largefile,
[AC_TRY_COMPILE([
#define _FILE_OFFSET_BITS	64
#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
 /* Check that off_t can represent 2**63 - 1 correctly.
    We can't simply define LARGE_OFF_T to be 9223372036854775807,
    since some C++ compilers masquerading as C compilers
    incorrectly reject 9223372036854775807.  */
#define LARGE_OFF_T (((off_t) 1 << 62) - 1 + ((off_t) 1 << 62))],
[
int off_t_is_large = (LARGE_OFF_T % 2147483629 == 721 && LARGE_OFF_T % 2147483647 == 1) ? 1 : -1;
exit (off_t_is_large);],
  ac_cv_decl_sys_largefile=yes, ac_cv_decl_sys_largefile=no)])
if test $ac_cv_decl_sys_largefile = yes; then
  AC_DEFINE(_LARGEFILE_SOURCE,1,)
  AC_DEFINE(_FILE_OFFSET_BITS,64,)
fi
])


# AC_QOSIENT_LARGEFILE
# ----------------
# By default, many hosts won't let programs access large files;
# one must use special compiler options to get large-file access to work.
# For more details about this brain damage please see:
# http://www.sas.com/standards/large.file/x_open.20Mar96.html

AC_DEFUN(AC_QOSIENT_LARGEFILE,
   [AC_ARG_WITH(largefile,
      [  --without-largefile     don't use large file support],
      with_largefile="$withval", with_largefile=yes)

   if test "$with_largefile" != no; then
     AC_QOSIENT_LARGEFILE_TEST()
   fi
   ])# AC_QOSIENT_LARGEFILE



dnl	Kevin Miller
dnl	Carnegie Mellon University


AC_DEFUN(AC_CMU_MYSQL,
   [AC_ARG_WITH(mysql,
      [  --with-mysql=DIR        use mysql in <DIR> [yes]],
      with_mysql="$withval", with_mysql="/usr")

MYSQL_CFLAGS=""
MYSQL_LDFLAGS=""
ARGUS_MYSQL=""

   if test "$with_mysql" != no; then
      saved_CPPFLAGS=$CPPFLAGS
      saved_LDFLAGS=$LDFLAGS
      saved_LIBS=$LIBS 
  
      if test -d ${with_mysql}; then
         ac_cv_mysql_where_lib=${with_mysql}/lib/mysql
         ac_cv_mysql_where_inc=${with_mysql}/include/mysql
         MYSQL_CFLAGS="-I$ac_cv_mysql_where_inc"
         MYSQL_LDFLAGS="-L${with_mysql}/lib -L$ac_cv_mysql_where_lib"
         LDFLAGS="${saved_LDFLAGS} ${MYSQL_LDFLAGS}"
         CPPFLAGS="${saved_CPPFLAGS} ${MYSQL_CFLAGS}"
      fi

      AC_CHECK_HEADER(mysql.h,
	    AC_CHECK_LIB(mysqlclient, mysql_init,
		    ac_cv_found_mysql=yes, ac_cv_found_mysql=no),
		    ac_cv_found_mysql=no)

      LIBS="$saved_LIBS"
      LDFLAGS="$saved_LDFLAGS"
      CPPFLAGS="$saved_CPPFLAGS"

      if test "$ac_cv_found_mysql" = yes; then
         MYSQL_LDFLAGS="$MYSQL_LDFLAGS -lmysqlclient"

         if test "$with_mysql" != no; then
            ARGUS_MYSQL="./ramysql"
            AC_SUBST(MYSQL_LDFLAGS)
            AC_SUBST(MYSQL_CFLAGS)
         fi
      else
         echo MySQL support not available
      fi
   fi

   AC_SUBST(ARGUS_MYSQL)

   ])# AC_CMU_MYSQL


