/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:38:06 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamQualifier;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class StreamQualifier_ESTest extends StreamQualifier_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      Qualifier qualifier0 = StreamQualifier.makeStreamQualifier("$1\"\"$2", "Duplicate allele added to VariantContext: ", simpleEntryInformation0);
      assertEquals("$1\"\"$2", qualifier0.getName());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      try { 
        StreamQualifier.makeStreamQualifier("org.apache.log4j.Level", "\"-V>o<S`0MB", mSPcrunchEntryInformation0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // unbalanced quotes: \"-V>o<S`0MB
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Key key0 = new Key("unbalanced quotes: ", true);
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("unbalanced quotes: ", 2667, keyVector0, keyVector0, false);
      Qualifier qualifier0 = new Qualifier("0I\"~15R1)pI 5Y-");
      StringVector stringVector0 = StreamQualifier.toStringVector(qualifierInfo0, qualifier0);
      Qualifier qualifier1 = new Qualifier("", stringVector0);
      StringVector stringVector1 = StreamQualifier.toStringVector(qualifierInfo0, qualifier1);
      assertEquals("[/=\"/0I\"\"~15R1)pI 5Y-\"]", stringVector1.toString());
      assertNotNull(stringVector1);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      byteArray0[3] = (byte)25;
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      BufferedInputStream bufferedInputStream0 = new BufferedInputStream(byteArrayInputStream0, 1006);
      Charset charset0 = Charset.defaultCharset();
      InputStreamReader inputStreamReader0 = new InputStreamReader(bufferedInputStream0, charset0);
      BufferedReader bufferedReader0 = new BufferedReader(inputStreamReader0);
      String string0 = StreamQualifier.readValue(bufferedReader0);
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      byteArray0[0] = (byte) (-75);
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      BufferedInputStream bufferedInputStream0 = new BufferedInputStream(byteArrayInputStream0, 1006);
      Charset charset0 = Charset.defaultCharset();
      InputStreamReader inputStreamReader0 = new InputStreamReader(bufferedInputStream0, charset0);
      BufferedReader bufferedReader0 = new BufferedReader(inputStreamReader0);
      String string0 = StreamQualifier.readValue(bufferedReader0);
      assertEquals("\uFFFD", string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      // Undeclared exception!
      try { 
        StreamQualifier.toStringVector((QualifierInfo) null, (Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      // Undeclared exception!
      try { 
        StreamQualifier.toString((QualifierInfo) null, (Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      // Undeclared exception!
      try { 
        StreamQualifier.readValue((BufferedReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      BufferedReader bufferedReader0 = new BufferedReader(pipedReader0);
      try { 
        StreamQualifier.readValue(bufferedReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      // Undeclared exception!
      try { 
        StreamQualifier.readName((BufferedReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      BufferedReader bufferedReader0 = new BufferedReader(pipedReader0);
      try { 
        StreamQualifier.readName(bufferedReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      // Undeclared exception!
      try { 
        StreamQualifier.makeStreamQualifier((String) null, (String) null, mSPcrunchEntryInformation0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      try { 
        StreamQualifier.makeStreamQualifier("", "\"A2s7HCJVH1!", blastEntryInformation0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // unbalanced quotes: \"A2s7HCJVH1!
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo("/-l[[", (-1884), (KeyVector) null, (KeyVector) null, false);
      Qualifier qualifier0 = new Qualifier("/-l[[", "/-l[[");
      String string0 = StreamQualifier.toString(qualifierInfo0, qualifier0);
      assertEquals("//-l[[=\"/-l[[\"", string0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Qualifier qualifier0 = StreamQualifier.makeStreamQualifier("", "", blastEntryInformation0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("", 4, (KeyVector) null, (KeyVector) null, true);
      StringVector stringVector0 = StreamQualifier.toStringVector(qualifierInfo0, qualifier0);
      assertEquals("[/=\"\"]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      char[] charArray0 = new char[2];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LineNumberReader lineNumberReader0 = new LineNumberReader(charArrayReader0, 1076);
      String string0 = StreamQualifier.readValue(lineNumberReader0);
      assertEquals("", string0);
      
      String string1 = StreamQualifier.readValue(lineNumberReader0);
      assertTrue(string1.equals((Object)string0));
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      StringReader stringReader0 = new StringReader("n");
      LineNumberReader lineNumberReader0 = new LineNumberReader(stringReader0);
      try { 
        StreamQualifier.readName(lineNumberReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // failed to read a qualifier name from this string: nnull
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      char[] charArray0 = new char[1];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 1, 47);
      BufferedReader bufferedReader0 = new BufferedReader(charArrayReader0, 47);
      String string0 = StreamQualifier.readName(bufferedReader0);
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      KeyVector keyVector0 = simpleEntryInformation0.getValidKeys();
      Qualifier qualifier0 = StreamQualifier.makeStreamQualifier("[$JA36sXD&gx", "", simpleEntryInformation0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("", 597, keyVector0, keyVector0, true);
      StringVector stringVector0 = StreamQualifier.toStringVector(qualifierInfo0, qualifier0);
      assertEquals("[/[$JA36sXD&gx=]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo("F!v=+}BkPbm", 0, (KeyVector) null, (KeyVector) null, true);
      Qualifier qualifier0 = new Qualifier("F!v=+}BkPbm", (String) null);
      StringVector stringVector0 = StreamQualifier.toStringVector(qualifierInfo0, qualifier0);
      assertEquals("[/F!v=+}BkPbm]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("", (-2444), keyVector0, keyVector0, true);
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      Qualifier qualifier0 = StreamQualifier.makeStreamQualifier((String) null, "Tg.ghS", entryInformation0);
      qualifier0.addValues((StringVector) null);
      String string0 = StreamQualifier.toString(qualifierInfo0, qualifier0);
      assertEquals("/null=Tg.ghS/null", string0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier();
      String string0 = StreamQualifier.toString((QualifierInfo) null, qualifier0);
      assertEquals("/null", string0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Qualifier qualifier0 = StreamQualifier.makeStreamQualifier("", "w.", blastEntryInformation0);
      String string0 = StreamQualifier.toString((QualifierInfo) null, qualifier0);
      assertEquals("/=w.", string0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      try { 
        StreamQualifier.makeStreamQualifier("(jC<Qmvh;g]Z", "hit the end of line while looking for a \"", blastEntryInformation0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // unbalanced quotes: hit the end of line while looking for a \"
         //
         verifyException("uk.ac.sanger.artemis.io.StreamQualifier", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      StreamQualifier streamQualifier0 = new StreamQualifier();
  }
}
