open Printf
open Tyxml.Html

let href uri =
  a_href (uri_of_string uri)

let a_link url text =
  a ~a:[a_href (uri_of_string url)] [pcdata text]

let page ~title ~subtitle ~headers ~body ~footer =
  let headers =
    (meta
      ~a:[a_charset "utf-8"]
      ())
    ::
    (link ~rel:[`Stylesheet] ~href:"media/revamp.css" ())
    ::
    (link ~rel:[`Stylesheet] ~href:"media/styles.css" ())
    ::
    headers in
  html ~a:[a_xmlns `W3_org_1999_xhtml]
    (head
       (Tyxml.Html.title (pcdata title))
       headers
    )
    (Tyxml.Html.body ~a:[a_class ["debian"]] [
      h1 ~a:[a_id "title"] [pcdata "Ubuntu Release Management"];
      h2 ~a:[a_id "subtitle"] subtitle;
      div ~a:[a_id "body"] body;
      div ~a:[a_id "footer"] footer
    ])

open Template

let () =
  Benl_templates.register_template {
    name = "Ubuntu";
    page;
    intro = [];
    pts = (fun ~src -> sprintf "https://launchpad.net/ubuntu/+source/%s" src);
    changelog = (fun ~letter ~src ~ver -> sprintf "http://changelogs.ubuntu.com/changelogs/%s/%s_%s/changelog" letter src ver);
    buildd = (fun ~src ~ver -> sprintf "https://launchpad.net/ubuntu/+source/%s/%s" src ver);
    buildds = (fun ~srcs -> None);
    bugs = (fun ~src -> sprintf "https://bugs.launchpad.net/ubuntu/+source/%s" src);
    critical_bugs = (fun ~srcs -> None);
    msg_id = (fun ~mid -> sprintf "http://mid.gmane.org/%s" mid);
  }
