#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4cvs on Sat Jan 28 19:07:42 2006

import wx
import RefDisplayHTML,RefDisplay,RefDisplayKeys,RefDisplayDates,BIB

class DisplayPanel(wx.Panel):
	def __init__(self, *args, **kwds):
		self.ref = None		# currently displayed reference
		bibframe = kwds['bibframe']	# main bibus windows. We need it for callback
		del kwds['bibframe']
		# begin wxGlade: DisplayPanel.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.Display_notebook = wx.Notebook(self, -1, style=wx.NB_BOTTOM)
		self.RefDisplayHTML = RefDisplayHTML.RefDisplay(self.Display_notebook, -1)
		self.RefDisplayFull = RefDisplay.RefDisplay(self.Display_notebook, -1)
		self.RefDisplayKeys = RefDisplayKeys.RefDisplay(self.Display_notebook, -1)
		self.RefDisplayDates = RefDisplayDates.RefDisplay(self.Display_notebook, -1)

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_NOTEBOOK_PAGE_CHANGED, self.onPageChange, self.Display_notebook)
		# end wxGlade
		self.RefDisplayKeys.bibframe = bibframe
		self.RefDisplayDates.bibframe = bibframe
		self.Display_notebook.SetSelection(BIB.DISPLAY_FORMAT)
		
	def __set_properties(self):
		# begin wxGlade: DisplayPanel.__set_properties
		self.Display_notebook.SetFont(wx.Font(8, wx.ROMAN, wx.NORMAL, wx.NORMAL, 0, ""))
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: DisplayPanel.__do_layout
		sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
		self.Display_notebook.AddPage(self.RefDisplayHTML, _("Style"))
		self.Display_notebook.AddPage(self.RefDisplayFull, _("Details"))
		self.Display_notebook.AddPage(self.RefDisplayKeys, _("Keys"))
		self.Display_notebook.AddPage(self.RefDisplayDates, _("Modif"))
		sizer_1.Add(self.Display_notebook, 1, wx.EXPAND, 0)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		# end wxGlade

	def onPageChange(self, event): # wxGlade: DisplayPanel.<event_handler>
		"""We have changed the display"""
		self.Display_notebook.GetCurrentPage().display(self.ref)
		BIB.DISPLAY_FORMAT = self.Display_notebook.GetSelection()	# we save the value => saved on quit in config

	def Clear(self):
		self.Display_notebook.GetCurrentPage().Clear()
		
	def resetFormat(self,format):
		for page in xrange(self.Display_notebook.GetPageCount()):
			self.Display_notebook.GetPage(page).resetFormat(format)

	def display(self,ref):
		"""Display the reference ref"""
		self.ref = ref
		self.Display_notebook.GetCurrentPage().display(ref)
		
	def switchDisplay(self):
		"""Go to next panel of the notebook"""
		self.Display_notebook.SetSelection( (self.Display_notebook.GetSelection()+1) % self.Display_notebook.GetPageCount())
		
	def ShowKeysPage(self,show=True):
		"""Needed for switching between rr et rw/rk/ro users, since keys are not readable for rr"""
		#self.Display_notebook.DeletePage(2)
		self.RefDisplayKeys.Show(show)
		# Under windows we have to select the new page
		# otherwise update is not correct
		if show:
			select = BIB.DISPLAY_FORMAT
			self.Display_notebook.SetSelection(2)
			self.Display_notebook.SetSelection(select)
# end of class DisplayPanel


