//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Info/ComboSelectorDialog.h
//! @brief     Defines class ComboSelectorDialog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INFO_COMBOSELECTORDIALOG_H
#define BORNAGAIN_GUI_VIEW_INFO_COMBOSELECTORDIALOG_H

#include <QDialog>
#include <QString>

class QBoxLayout;
class QComboBox;
class QLabel;

//! A dialog similar to standard QMessageBox with combo box selector.

class ComboSelectorDialog : public QDialog {
    Q_OBJECT
public:
    ComboSelectorDialog(QWidget* parent = nullptr);

    void addItems(const QStringList& selection, const QString& currentItem = "");
    void setTextTop(const QString& text);
    void setTextBottom(const QString& text);

    QString currentText() const;

private:
    QBoxLayout* createLogoLayout();
    QBoxLayout* createInfoLayout();
    QBoxLayout* createButtonLayout();

    QLabel* m_topLabel;
    QComboBox* m_comboSelector;
    QLabel* m_bottomLabel;
};

#endif // BORNAGAIN_GUI_VIEW_INFO_COMBOSELECTORDIALOG_H
