//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotSpecular/SpecularPlotCanvas.cpp
//! @brief     Declares class SpecularPlotCanvas
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/PlotSpecular/SpecularPlotCanvas.h"
#include "GUI/Model/Data/SpecularDataItem.h"
#include "GUI/View/PlotSpecular/SpecularPlot.h"
#include "GUI/View/PlotUtil/FontScalingEvent.h"
#include "GUI/View/PlotUtil/PlotStatusLabel.h"

SpecularPlotCanvas::SpecularPlotCanvas(QWidget* parent)
    : QWidget(parent)
    , m_plot(new SpecularPlot(this))
    , m_canvasEvent(new FontScalingEvent(m_plot, this))
    , m_statusLabel(new PlotStatusLabel(m_plot, this))
{
    this->installEventFilter(m_canvasEvent);
    auto* layout = new QVBoxLayout;
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setSpacing(0);

    layout->addWidget(m_plot);
    layout->addWidget(m_statusLabel);

    setLayout(layout);

    setStatusLabelEnabled(false);
}

void SpecularPlotCanvas::setSpecularItems(const QList<SpecularDataItem*>& specularItems)
{
    m_plot->setSpecularItems(specularItems);
}

SpecularPlot* SpecularPlotCanvas::specularPlot()
{
    return m_plot;
}

QCustomPlot* SpecularPlotCanvas::customPlot()
{
    return m_plot->customPlot();
}

void SpecularPlotCanvas::setStatusLabelEnabled(bool flag)
{
    m_statusLabel->setLabelEnabled(flag);
    m_statusLabel->setHidden(!flag);
}
