#ifndef H_CDW_DIALOG
#define H_CDW_DIALOG


#include "cdw_ncurses.h"
#include "cdw_widgets.h"


/* a dialog can be either dialog with input field, or dialog with
   buttons; in future it may be possible that the two will be
   possible at the same time */
enum {
	CDW_DIALOG_BUTTONS = 1,
	CDW_DIALOG_INPUT = 2
};


/* number and type of buttons in dialog with buttons */
enum {
	CDW_BUTTONS_OK = 0,
	CDW_BUTTONS_OK_CANCEL = 3,
	CDW_BUTTONS_YES_NO_CANCEL = 4,
};



typedef struct {

	const char *window_title;    /* title of input window and error dialog windows */
	const char *prompt_message;  /* message in input window */
	char *error_message;         /* error message displayed in separate dialog at the end in case of failure */

	int attempts_max;            /* how many times should the widget ask for correct (i.e. without unsafe chars) string? */

	int input_type;              /* CDW_NCURSES_INPUT_{NONE | HIDDEN | INTEGER | NUMERIC } */

	int chars_max;               /* maximal allowed length of entered string, zero for no limit */
	char **buffer;               /* pointer to data buffer, the buffer must be provided by code using input dialog */

} cdw_input_data_t;


cdw_rv_t cdw_buttons_dialog(const char *title, const char *message, int button_types, cdw_colors_t colors);
cdw_rv_t cdw_input_dialog(cdw_input_data_t *data);


#endif /* #ifndef CDW_DIALOG_BASE */
