/****************************************************************************
 *    lib/c/DynamicRule.cpp - This file is part of coala					*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "DynamicRule.h"

using namespace C;

DynamicRule::DynamicRule(int line, Formula* F, Formula* G, Formula* H, Types* types) : Statement(line, types), StaticRule(line, F, G, types) {
	H_ = H;
}

DynamicRule::~DynamicRule () {
	delete H_;
}

void DynamicRule::printDirect(Printer* p) {
	p->setSection('c');

	FluentAction* f;
	FluentAction* g;
	string neg_f = p->neg;
	string neg_g = p->neg;

	// f1_fluent(T) :- not -g1_fluent(T), a_action(T-1).
	for(vector<Formula*>::iterator fluent_f = F_->begin(); fluent_f != F_->end(); ++fluent_f) {
		set<Variable*>* vars = new set<Variable*>();

		if(!(*fluent_f)->isFalse()) {
			// check for negation
			if((*fluent_f)->getType() == 'n') {
				f = (FluentAction*) (*fluent_f)->getFirstFormula();
				neg_f = p->neg;
			}
			else {
				f = (FluentAction*) *fluent_f;
				neg_f = "";
			}
			
			p->add(neg_f + f->print(p, p->T) + " :- ");
			
			delete vars;
			vars = f->getVariables();
		}
		else {
			p->add(":- ");
		}

		// print G part
		if(G_ && !G_->isTrue()) {
			for(vector<Formula*>::iterator fluent_g = G_->begin(); fluent_g != G_->end(); ++fluent_g) {
				// check for negation
				if((*fluent_g)->getType() == 'n') {
					g = (FluentAction*) (*fluent_g)->getFirstFormula();
					neg_g = "";
				}
				else {
					g = (FluentAction*) *fluent_g;
					neg_g = p->neg;
				}
				
				p->add("not " + neg_g + g->print(p, p->T) + ", ");
				
				// get the vars
				set<Variable*>* tmp_vars = g->getVariables();
				if(!tmp_vars->empty()) vars->insert(tmp_vars->begin(), tmp_vars->end());
				delete tmp_vars;
			}
		}
		// print H part
		H_->printAlsoActions(p, vars, p->T + "-1");

		if(!vars->empty()) {
			p->add(", ");
			types_.print(p, vars, line_);
		}
		p->add(".\n");
		delete vars;
	}
}

void DynamicRule::printNonDirect(Printer* p) {
	p->setSection('b');

	for(vector<Formula*>::iterator n = F_->begin(); n != F_->end(); ++n) {
		FluentAction* f;
		bool neg;

		if((*n)->getType() == 'n') {
			f = (FluentAction*) (*n)->getFirstFormula();
			neg = true;
		}
		else {
			f = (FluentAction*) *n;
			neg = false;
		}

		p->add("caused(");

		if(neg)	p->add("neg(" + f->print(p) + ")");
		else	p->add(f->print(p));

		set<Variable*>* vars = f->getVariables();

		p->add(", ");
		if(G_) G_->print(p, vars);
		else p->add("\"true\"");
		p->add(", ");
		H_->printAlsoActions(p, vars);
		p->add(")");

		if(vars->empty()) p->add(".\n");
		else {
			p->add(" :- ");
			types_.print(p, vars, line_);
			p->add(".\n");
		}
		delete vars;
	}

	//F_->printCompositeFluents(p, &types_);
	if(G_) G_->printCompositeFluents(p, &types_);
	H_->printCompositeFluentActions(p, &types_);
}
