% make_ssbfilt.m
% David Rowe May 2015
%
% creates SSB filter FIR coeffs

graphics_toolkit ("gnuplot");

ssbfilt_n = 100;
Fs = 8000;

ssbfilt_coeff  = fir2(ssbfilt_n,[0 400 600 2200 2600 4000]/(Fs/2),[0.001 0.001 1 1 0.001 0.001]);

figure(1)
clf;
h = freqz(ssbfilt_coeff,1,Fs/2);
plot(20*log10(abs(h)))
grid minor

% save coeffs to a C header file

f=fopen("../src/ssbfilt_coeff.h","wt");
fprintf(f,"/* 600 - 2600 Hz FIR filter coeffs */\n");
fprintf(f,"/* Generated by make_ssbfilt Octave script */\n");

fprintf(f,"\n#define SSBFILT_N %d\n\n", ssbfilt_n);

fprintf(f,"float ssbfilt_coeff[]={\n");
for r=1:ssbfilt_n
  if r < ssbfilt_n
    fprintf(f, "  %f,\n",  ssbfilt_coeff(r));
  else
    fprintf(f, "  %f\n};", ssbfilt_coeff(r));
  end
end

fclose(f);
