/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.IntToIntHashMap;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public class Translate
extends SystemFunction {
    private IntToIntHashMap staticMap = null;

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.typeCheck(staticContext, itemType);
        if (expression == this && this.argument[1] instanceof StringValue && this.argument[2] instanceof StringValue) {
            this.staticMap = Translate.buildMap((StringValue)this.argument[1], (StringValue)this.argument[2]);
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return StringValue.EMPTY_STRING;
        }
        if (this.staticMap != null) {
            CharSequence charSequence = stringValue.getStringValueCS();
            CharSequence charSequence2 = Translate.translateUsingMap(charSequence, this.staticMap);
            return new StringValue(charSequence2);
        }
        StringValue stringValue2 = (StringValue)this.argument[1].evaluateItem(xPathContext);
        StringValue stringValue3 = (StringValue)this.argument[2].evaluateItem(xPathContext);
        return StringValue.makeStringValue(Translate.translate(stringValue, stringValue2, stringValue3));
    }

    private static CharSequence translate(StringValue stringValue, StringValue stringValue2, StringValue stringValue3) {
        if (stringValue.containsSurrogatePairs() || stringValue2.containsSurrogatePairs() || stringValue3.containsSurrogatePairs()) {
            return Translate.translateUsingMap(stringValue.getStringValueCS(), Translate.buildMap(stringValue2, stringValue3));
        }
        if (stringValue.getLength() * stringValue2.getLength() > 60) {
            return Translate.translateUsingMap(stringValue.getStringValueCS(), Translate.buildMap(stringValue2, stringValue3));
        }
        CharSequence charSequence = stringValue.getStringValueCS();
        CharSequence charSequence2 = stringValue2.getStringValueCS();
        CharSequence charSequence3 = stringValue3.getStringValueCS();
        String string = charSequence2.toString();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        int n = charSequence3.length();
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            int n3 = string.indexOf(c);
            if (n3 >= n) continue;
            fastStringBuffer.append(n3 < 0 ? c : charSequence3.charAt(n3));
        }
        return fastStringBuffer;
    }

    private static IntToIntHashMap buildMap(StringValue stringValue, StringValue stringValue2) {
        int[] nArray = stringValue.expand();
        int[] nArray2 = stringValue2.expand();
        IntToIntHashMap intToIntHashMap = new IntToIntHashMap(nArray.length, 0.5);
        for (int i = 0; i < nArray.length; ++i) {
            if (intToIntHashMap.find(nArray[i])) continue;
            intToIntHashMap.put(nArray[i], i > nArray2.length - 1 ? -1 : nArray2[i]);
        }
        return intToIntHashMap;
    }

    private static CharSequence translateUsingMap(CharSequence charSequence, IntToIntHashMap intToIntHashMap) {
        int n = charSequence.length();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = charSequence.charAt(i);
            if (n3 >= 55296 && n3 <= 56319) {
                n2 = (n3 - 55296) * 1024 + (charSequence.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                n2 = n3;
            }
            int n4 = intToIntHashMap.get(n2);
            if (n4 == Integer.MAX_VALUE) {
                n4 = n2;
            }
            if (n4 == -1) continue;
            if (n4 < 65536) {
                fastStringBuffer.append((char)n4);
                continue;
            }
            fastStringBuffer.append((char)((n4 -= 65536) / 1024 + 55296));
            fastStringBuffer.append((char)(n4 % 1024 + 56320));
        }
        return fastStringBuffer;
    }
}

