#!/bin/bash

#
# Script executed via leak_check-test.c
# The unit tests in kmosp/recipes are setup to do esorex calls,
# if any memory leaks occur there, they won't be detected by executing 'make check'
# The script analyzes the log-files created during each unit test
#


sum=0;
for fn in $(ls log_*.txt)
do 
   # extract all active pointers from log file and remove "Number of active pointers:"-string
   fn_vals=$(grep "Number of" $fn | sed 's/[[:alpha:]]//g' | sed 's/[[:punct:]]//g')

   # sum up all active pointers for this fn
   fn_sum=0;
   for i in $fn_vals; do ((fn_sum += i)); done
   if [ $fn_sum -ne 0 ]
   then
      echo "[ ERROR ] " $fn "indicates" $fn_sum "active pointers!"
   fi

   # calculate total sum
   ((sum += fn_sum))
done

exit $sum
