DACSTRANSFORM(1)             DACS Commands Manual             DACSTRANSFORM(1)



[1mNAME[0m
       dacstransform - rule-based document transformation

[1mSYNOPSIS[0m
       [1mdacstransform [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-admin[22m] [[1m-ct [4m[22mstr[24m] [[1m-docs [4m[22mdir[24m] [[1m-f[22m]
                     [[1m-F [4m[22mfield_sep[24m] [[1m-fd [4m[22mdomain[24m] [[1m-fh [4m[22mhostname[24m] [[1m-fj [4m[22mjurname[24m]
                     [[1m-fn [4m[22mfedname[24m] [[1m-h [22m| [1m-help[22m] [[1m-i [4m[22mident[24m] [[1m-il [4m[22mident[24m]
                     [[1m-ilg [4m[22mident[24m] [[1m-ieuid[22m]
                     [[1m-ieuidg[22m] [[1m-iuid[22m] [[1m-insert[22m] [[1m-iuidg[22m] [[1m-lg[22m] [[1m-name [4m[22mstr[24m]
                     [[1m-prefix [4m[22mstr[24m] [[1m-roles [4m[22mroles_vfs[24m] [[1m-rprefix [4m[22mregex[24m]
                     [[1m-rsuffix [4m[22mregex[24m] [[1m-suffix [4m[22mstr[24m] [{[1m-r [22m| [1m-rules[22m} [4mrules_uri[24m]
                     [[1m-var [4m[22mname=value[24m] [[1m-x[22m] [[1m--[22m] {[1m- [22m| [4mfile[24m}

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.


       [1mdacstransform [22msupplies the functionality of [1mdacs_transform [22mfrom the
       command-line. Because the two programs are almost identical, please
       refer to [34m[1mdacs_transform(8)[0m[1m[22m[2] for details.

       If the program is executed through the system's "#!" mechanism
       ([34m[1mexecve(2)[0m[1m[22m[3]), one or more command line arguments can be given:

           #!/usr/local/dacs/bin/dacstransform -Dfoo=val -ct ''
           Hello, world

           Bye

       Such programs always use the script file as input, therefore no
       expression or other file can be specified on the "#!" line.

           [1mNote[0m
           The program has some limitations, including missing configuration
           capabilities and features, that might be expected in a production
           version but which have not yet been implemented.

[1mOPTIONS[0m
       The arguments are processed as they are examined (left-to-right) and
       their ordering can be significant. Command line arguments override [1mDACS[0m
       configuration (see below).

       Please refer to [34m[1mdacscheck(1)[0m[1m[22m[4] for a description of the flags related
       to setting identities and [1mDACS [22mcontext. If no identity is specified,
       the program will use the values of the environment variables
       [1mREMOTE_USER [22mand [1mDACS_ROLES [22mif they are available and valid.

       The following command line flags are recognized:

       [1m-ct [4m[22mstr[0m
           Set the MIME Content-Type to [4mstr[24m. The default is not to emit this
           header.

       [1m-docs [4m[22mdir[0m
           Set the directory containing the documents to [4mdir[24m - the [4mfile[0m
           argument will be relative to [4mdir[24m. If [4mdir[24m is the empty string,
           however, this mapping will not be performed. The mapping is also
           disabled if the [1m-f [22mis given or if the standard input is read. This
           argument overrides any configuration of transform_docs or default
           behaviour.

       [1m-f[0m
           Disable input file location mapping.

       [1m-h[0m
       [1m-help[0m
           Prints the usage blurb, which includes a listing of the program's
           defaults.

       [1m-insert [4m[22mdir[0m
           If a relative path is given for the value of a filename attribute
           with the insert, insertv, or expand directive, prefix the relative
           path with the string [4mdir[24m.

       [1m-name [4m[22mstr[0m
           The name of the input document is [4mstr[24m. This is used to associate a
           rule with the document; that is, it is matched against a rule's
           service or delegate element. By default, it is the name of the
           input file or the path component of the input URI. If the effective
           name does not begin with a slash character, one is prepended. The
           argument should probably be given if the standard input is being
           read.

       [1m-prefix [4m[22mstr[0m
           A directive is introduced by [4mstr[24m appearing at the beginning of an
           input line. The default is "<--DACS ".

       [1m-suffix [4m[22mstr[0m
           A directive is terminated by [4mstr[24m appearing at the end of a
           directive line. The default is "-->".

       [1m-r [4m[22mrules_uri[0m
       [1m-rules [4m[22mrules_uri[0m
           The location of the ruleset to be applied to the document, as a
           [1mDACS [22mVFS URI.

       [1m-rprefix [4m[22mregex[0m
           A line whose beginning matches [4mregex[24m introduces a directive. This
           overrides the default and any [1m-prefix [22mflag. IEEE Std 1003.2
           ("POSIX.2") "extended" regular expressions are supported
           ([34m[1mregex(3)[0m[1m[22m[5]).

       [1m-rsuffix [4m[22mregex[0m
           A directive is terminated by a string that matches [4mregex[24m, followed
           immediately by the end of the line. This overrides the default and
           any [1m-suffix [22mflag. IEEE Std 1003.2 ("POSIX.2") "extended" regular
           expressions are supported ([34m[1mregex(3)[0m[1m[22m[5]).

       [1m-var [4m[22mname=value[0m
           Add a variable definition to the [4mDACS[24m namespace. The variable
           [4m${DACS::name}[24m will be assigned the string [4mvalue[24m. The [4mname[24m must be
           syntactically valid. This flag is equivalent to the [34m[1mdacsoptions[0m[1m[22m[1]
           flag [1m-D[4m[22mname=value[24m. This flag may be repeated. It is best to avoid
           the variable name [4mstdin[24m, which has a special purpose. If [4mname[24m is
           defined more than once its value is indeterminate.

           In a directive, an attribute value that is enclosed within backtick
           quotes is evaluated as an expression, which may include variable
           references. Variables from the [4mEnv[24m namespace and, if available, the
           [4mConf[24m are also instantiated. The current directive's attributes are
           accessible in the [4mAttr[24m namespace; these attribute values are
           [4munevaluated[24m and quoted.

       [1m-x[0m
           Run as a command, not a web service. This is often required when
           [1mdacstransform [22mis run as a CGI program.

       [1m--[0m
           Flags end. An input source argument may follow.

       After the flags, the input source can be specified. By default, or if [1m-[0m
       is given, the standard input is read, otherwise [4mfile[24m is read.

       Whitespace is not ignored at the beginning or end of an input line with
       respect to directive prefix and suffix matching.

   [1mConfiguration[0m
       Configuration variables can be set to change some of the program's
       defaults, but each one is overridden if a value is also given on the
       command line:

       +o   [4mtransform_docs[24m: This is the full pathname of the root directory in
           which original documents are kept. By default, the program will use
           a subdirectory [4m${Conf::DACS_HOME}[24mdacs_transform/docs. (default:
           /usr/local/dacs/dacs_transform/docs)

               [1mSecurity[0m
               Change the default with care. In the absence of an appropriate
               access control rule, setting the pathname to "/" or the empty
               string, would provide access to any file on the server that can
               be read by this web service.

       +o   [4mtransform_acls[24m: This is the VFS specification for the rules. By
           default, the program will use
           [4m${Conf::DACS_HOME}[24mdacs_transform/acls. (default:
           [transform-acls]dacs-fs:/usr/local/dacs/dacs_transform/acls)

       +o   [4mtransform_annotation[24m: This is the annotation to interpolate in
           redacted text instead of the default.

       +o   [4mtransform_prefix[24m: Instead of the default prefix string used to
           introduce a directive, the value of this variable is used. It must
           appear at the beginning of a line.

       +o   [4mtransform_suffix[24m: Instead of the default string used to end a
           directive, the value of this variable is used.

       +o   [4mtransform_rprefix[24m: A line whose beginning matches the specified
           regular expression introduces a directive.

       +o   [4mtransform_rsuffix[24m: The end of a directive is found by matching the
           specified regular expression.


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_transform(8)[0m[1m[22m[2], [34m[1mdacs.exprs(5)[0m[1m[22m[6], [34m[1mdacs.acls(5)[0m[1m[22m[7]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[8])

[1mCOPYING[0m
       Copyright (C) 2003-2018 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[9] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_transform(8)
           http://dacs.dss.ca/man/dacs_transform.8.html

        3. execve(2)
           https://www.freebsd.org/cgi/man.cgi?query=execve&apropos=0&esektion=2&emanpath=FreeBSD+10.3-RELEASE&format=html

        4. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        5. regex(3)
           https://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&esektion=3&emanpath=FreeBSD+10.3-RELEASE&format=html

        6. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

        7. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.40                       02/01/2018                  DACSTRANSFORM(1)
