info = {
    "name": "id",
    "date_order": "DMY",
    "january": [
        "jan",
        "januari"
    ],
    "february": [
        "feb",
        "februari"
    ],
    "march": [
        "mar",
        "maret"
    ],
    "april": [
        "apr",
        "april"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "jun",
        "juni"
    ],
    "july": [
        "jul",
        "juli"
    ],
    "august": [
        "agt",
        "agustus",
        "Agu"
    ],
    "september": [
        "sep",
        "september",
        "Sept"
    ],
    "october": [
        "okt",
        "oktober"
    ],
    "november": [
        "nov",
        "november"
    ],
    "december": [
        "des",
        "desember"
    ],
    "monday": [
        "sen",
        "senin"
    ],
    "tuesday": [
        "sel",
        "selasa"
    ],
    "wednesday": [
        "rab",
        "rabu"
    ],
    "thursday": [
        "kam",
        "kamis"
    ],
    "friday": [
        "jum",
        "jumat"
    ],
    "saturday": [
        "sab",
        "sabtu"
    ],
    "sunday": [
        "min",
        "minggu",
        "Ahad"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "tahun",
        "thn"
    ],
    "month": [
        "bln",
        "bulan"
    ],
    "week": [
        "mgg",
        "minggu"
    ],
    "day": [
        "h",
        "hari"
    ],
    "hour": [
        "j",
        "jam"
    ],
    "minute": [
        "m",
        "menit",
        "mnt"
    ],
    "second": [
        "d",
        "detik",
        "dtk"
    ],
    "relative-type": {
        "0 day ago": [
            "hari ini"
        ],
        "0 hour ago": [
            "jam ini"
        ],
        "0 minute ago": [
            "menit ini"
        ],
        "0 month ago": [
            "bulan ini"
        ],
        "0 second ago": [
            "sekarang",
            "baru saja"
        ],
        "0 week ago": [
            "minggu ini"
        ],
        "0 year ago": [
            "tahun ini"
        ],
        "1 day ago": [
            "kemarin"
        ],
        "1 month ago": [
            "bulan lalu"
        ],
        "1 week ago": [
            "minggu lalu"
        ],
        "1 year ago": [
            "tahun lalu"
        ],
        "in 1 day": [
            "besok"
        ],
        "in 1 month": [
            "bulan berikutnya"
        ],
        "in 1 week": [
            "minggu depan"
        ],
        "in 1 year": [
            "tahun depan"
        ],
        "1 year": [
            "setahun"
        ],
        "1 month": [
            "sebulan"
        ],
        "1 week": [
            "seminggu"
        ],
        "2 day ago": [
            "kemarin lusa"
        ],
        "1 day": [
            "sehari"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) h lalu",
            "(\\d+[.,]?\\d*) hari yang lalu"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) jam lalu",
            "(\\d+[.,]?\\d*) jam yang lalu"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) menit yang lalu",
            "(\\d+[.,]?\\d*) mnt lalu"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) bln lalu",
            "(\\d+[.,]?\\d*) bulan yang lalu",
            "(\\d+[.,]?\\d*) bulan lalu"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) detik yang lalu",
            "(\\d+[.,]?\\d*) dtk lalu"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) mgg lalu",
            "(\\d+[.,]?\\d*) minggu yang lalu",
            "(\\d+[.,]?\\d*) minggu lalu"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) tahun yang lalu",
            "(\\d+[.,]?\\d*) thn lalu",
            "(\\d+[.,]?\\d*) tahun lalu"
        ],
        "in \\1 day": [
            "dalam (\\d+[.,]?\\d*) h",
            "dalam (\\d+[.,]?\\d*) hari"
        ],
        "in \\1 hour": [
            "dalam (\\d+[.,]?\\d*) jam"
        ],
        "in \\1 minute": [
            "dalam (\\d+[.,]?\\d*) menit",
            "dlm (\\d+[.,]?\\d*) mnt"
        ],
        "in \\1 month": [
            "dalam (\\d+[.,]?\\d*) bulan",
            "dlm (\\d+[.,]?\\d*) bln"
        ],
        "in \\1 second": [
            "dalam (\\d+[.,]?\\d*) detik",
            "dlm (\\d+[.,]?\\d*) dtk"
        ],
        "in \\1 week": [
            "dalam (\\d+[.,]?\\d*) minggu",
            "dlm (\\d+[.,]?\\d*) mgg"
        ],
        "in \\1 year": [
            "dalam (\\d+[.,]?\\d*) tahun",
            "dlm (\\d+[.,]?\\d*) thn"
        ],
        "\\1 week": [
            "(\\d+[.,]?\\d*) minggu"
        ],
        "sunday": [
            "minggu"
        ]
    },
    "locale_specific": {},
    "skip": [
        "pukul",
        "tanggal",
        "yang",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "lalu"
    ],
    "in": [
        "dalam"
    ]
}
