/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __basic_editor
#define __basic_editor

#include "viewwin.h"
#include "point.h"
#include "help.h"
#include "mocap.h"
#include "ui.h"
#include "textboard.h"

#include <map>

struct basic_editor : ui {
	
  window win; // edit window

  // object space <> window space mapping
  point<int> win_chunk;
  point<float> obj_chunk;
  point<float> win_per_obj;
  point<float> obj_per_win;
  int win_resolution;
  float obj_resolution;

  // snapping support
  int snap_what;
  enum {SNAP_NONE, SNAP_X, SNAP_Y, SNAP_BOTH};
  void snap (float& x, float& y);
  int is_snapx ();
  int is_snapy ();

  static const int buf_size = 1024;
  static char buf [buf_size];

  help helptext;

  mocap mocap0;

  int pan, zoom; // pan & zoom deltas to control pan and zoom speed

  basic_editor (const std::string& settingsf = "../data/basic_editor.txt", const std::string& helpf = "../data/basic_editor_help.txt");
  virtual ~basic_editor ();

  void obj2win (const point<float>& p, float& wx, float& wy);
  void obj2win (const float& ox, const float& oy, float& wx, float& wy);
  void win2obj (const float& dx, const float& dy, float& cx, float& cy);

  void calc_win_mouse ();

  inline const point<float>& get_obj_chunk () {
    return obj_chunk;
  }

  inline float get_obj_resolution () {
    return obj_resolution;
  }

  void load (const std::string& fname);
  void load (std::ifstream& file);
  void save (std::ofstream& file);

  void set_win_chunk (int x, int y);
  bool handle_input ();

  void project ();
  void unproject ();

  void draw ();
  void draw_cursor ();
  
  int update_snaps;
  std::vector<int> xlines, ylines;
  int nxpts, nypts;
  int startx, endx, starty, endy;
  void draw_snaps ();
  void calc_snaps ();

  textboard tb;
  int ntexts;
  
  static const int KB_KB_ATTACK = 1857;
  float susx, susy;
  box<float> susbox;
  void update_sustain (float s);
  void calc_visual_params ();
  int edit_sustain;
  int lmb_clicked;

};
#endif
