/**********************************************************************************************************************/
/* Function table */

static const StretchFunctionTable TABLE_NAME = {
#define FUNC_NAME_(K,P,F)      FUNC_NAME(up,K,P,F)
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].up[STRETCH_NONE]             = FUNC_NAME_(_,_,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].up[STRETCH_PROTECT]          = FUNC_NAME_(_,P,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].up[STRETCH_SRCKEY]           = FUNC_NAME_(K,_,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].up[STRETCH_SRCKEY_PROTECT]   = FUNC_NAME_(K,P,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].up[STRETCH_NONE]              = FUNC_NAME_(_,_,DSPF_LUT8),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].up[STRETCH_PROTECT]           = FUNC_NAME_(_,P,DSPF_LUT8),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].up[STRETCH_SRCKEY]            = FUNC_NAME_(K,_,DSPF_LUT8),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].up[STRETCH_SRCKEY_PROTECT]    = FUNC_NAME_(K,P,DSPF_LUT8),
#undef FUNC_NAME_

#define FUNC_NAME_(K,P,F)      FUNC_NAME(down,K,P,F)
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].down[STRETCH_NONE]           = FUNC_NAME_(_,_,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].down[STRETCH_PROTECT]        = FUNC_NAME_(_,P,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].down[STRETCH_SRCKEY]         = FUNC_NAME_(K,_,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DST_FORMAT)].down[STRETCH_SRCKEY_PROTECT] = FUNC_NAME_(K,P,DST_FORMAT),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].down[STRETCH_NONE]            = FUNC_NAME_(_,_,DSPF_LUT8),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].down[STRETCH_PROTECT]         = FUNC_NAME_(_,P,DSPF_LUT8),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].down[STRETCH_SRCKEY]          = FUNC_NAME_(K,_,DSPF_LUT8),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_LUT8)].down[STRETCH_SRCKEY_PROTECT]  = FUNC_NAME_(K,P,DSPF_LUT8),
#undef FUNC_NAME_

/* FIXME: DST_FORMAT == DSPF_RGB16 doesn't work */
#ifdef FORMAT_RGB16
#define FUNC_NAME_(K,P,F)      FUNC_NAME(up,K,P,F)
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].up[STRETCH_NONE]             = FUNC_NAME_(_,_,DSPF_ARGB4444),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].up[STRETCH_PROTECT]          = FUNC_NAME_(_,P,DSPF_ARGB4444),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].up[STRETCH_SRCKEY]           = FUNC_NAME_(K,_,DSPF_ARGB4444),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].up[STRETCH_SRCKEY_PROTECT]   = FUNC_NAME_(K,P,DSPF_ARGB4444),
#undef FUNC_NAME_
#define FUNC_NAME_(K,P,F)      FUNC_NAME(down,K,P,F)
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].down[STRETCH_NONE]           = FUNC_NAME_(_,_,DSPF_ARGB4444),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].down[STRETCH_PROTECT]        = FUNC_NAME_(_,P,DSPF_ARGB4444),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].down[STRETCH_SRCKEY]         = FUNC_NAME_(K,_,DSPF_ARGB4444),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_ARGB4444)].down[STRETCH_SRCKEY_PROTECT] = FUNC_NAME_(K,P,DSPF_ARGB4444),
#undef FUNC_NAME_
#endif

/* FIXME: DST_FORMAT == DSPF_ARGB4444 doesn't work */
#ifdef FORMAT_ARGB4444
#define FUNC_NAME_(K,P,F)      FUNC_NAME(up,K,P,F)
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].up[STRETCH_NONE]             = FUNC_NAME_(_,_,DSPF_RGB16),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].up[STRETCH_PROTECT]          = FUNC_NAME_(_,P,DSPF_RGB16),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].up[STRETCH_SRCKEY]           = FUNC_NAME_(K,_,DSPF_RGB16),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].up[STRETCH_SRCKEY_PROTECT]   = FUNC_NAME_(K,P,DSPF_RGB16),
#undef FUNC_NAME_
#define FUNC_NAME_(K,P,F)      FUNC_NAME(down,K,P,F)
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].down[STRETCH_NONE]           = FUNC_NAME_(_,_,DSPF_RGB16),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].down[STRETCH_PROTECT]        = FUNC_NAME_(_,P,DSPF_RGB16),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].down[STRETCH_SRCKEY]         = FUNC_NAME_(K,_,DSPF_RGB16),
     .f[DFB_PIXELFORMAT_INDEX(DSPF_RGB16)].down[STRETCH_SRCKEY_PROTECT] = FUNC_NAME_(K,P,DSPF_RGB16),
#undef FUNC_NAME_
#endif
};

