/* DBCS (double-byte) charset to unicode. 0x0000 means no mapping */
/* hi = (code >> 6) */
/* lo = code & 0x3F */
/* rawoff = cp932_to_unicode_hitbl[hi] */
/* if (rawoff != 0xFFFF) ucode = _raw[rawoff+lo] */
const uint16_t cp932_to_unicode_raw[8512] = {
	/* codebase=0x0000 rawbase=0x0000 */
	0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, /* 0x0000-0x0007 */
	0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* 0x0008-0x000F */
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, /* 0x0010-0x0017 */
	0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* 0x0018-0x001F */
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, /* 0x0020-0x0027 */
	0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* 0x0028-0x002F */
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, /* 0x0030-0x0037 */
	0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 0x0038-0x003F */
	/* codebase=0x0040 rawbase=0x0040 */
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, /* 0x0040-0x0047 */
	0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* 0x0048-0x004F */
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, /* 0x0050-0x0057 */
	0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 0x0058-0x005F */
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, /* 0x0060-0x0067 */
	0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* 0x0068-0x006F */
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, /* 0x0070-0x0077 */
	0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 0x0078-0x007F */
	/* codebase=0x0080 rawbase=0x0080 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0080-0x0087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0088-0x008F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0090-0x0097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x0098-0x009F */
	0x0000,0xff61,0xff62,0xff63,0xff64,0xff65,0xff66,0xff67, /* 0x00A0-0x00A7 */
	0xff68,0xff69,0xff6a,0xff6b,0xff6c,0xff6d,0xff6e,0xff6f, /* 0x00A8-0x00AF */
	0xff70,0xff71,0xff72,0xff73,0xff74,0xff75,0xff76,0xff77, /* 0x00B0-0x00B7 */
	0xff78,0xff79,0xff7a,0xff7b,0xff7c,0xff7d,0xff7e,0xff7f, /* 0x00B8-0x00BF */
	/* codebase=0x00c0 rawbase=0x00c0 */
	0xff80,0xff81,0xff82,0xff83,0xff84,0xff85,0xff86,0xff87, /* 0x00C0-0x00C7 */
	0xff88,0xff89,0xff8a,0xff8b,0xff8c,0xff8d,0xff8e,0xff8f, /* 0x00C8-0x00CF */
	0xff90,0xff91,0xff92,0xff93,0xff94,0xff95,0xff96,0xff97, /* 0x00D0-0x00D7 */
	0xff98,0xff99,0xff9a,0xff9b,0xff9c,0xff9d,0xff9e,0xff9f, /* 0x00D8-0x00DF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00E0-0x00E7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00E8-0x00EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00F0-0x00F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x00F8-0x00FF */
	/* codebase=0x8140 rawbase=0x0100 */
	0x3000,0x3001,0x3002,0xff0c,0xff0e,0x30fb,0xff1a,0xff1b, /* 0x8140-0x8147 */
	0xff1f,0xff01,0x309b,0x309c,0x00b4,0xff40,0x00a8,0xff3e, /* 0x8148-0x814F */
	0xffe3,0xff3f,0x30fd,0x30fe,0x309d,0x309e,0x3003,0x4edd, /* 0x8150-0x8157 */
	0x3005,0x3006,0x3007,0x30fc,0x2015,0x2010,0xff0f,0xff3c, /* 0x8158-0x815F */
	0xff5e,0x2225,0xff5c,0x2026,0x2025,0x2018,0x2019,0x201c, /* 0x8160-0x8167 */
	0x201d,0xff08,0xff09,0x3014,0x3015,0xff3b,0xff3d,0xff5b, /* 0x8168-0x816F */
	0xff5d,0x3008,0x3009,0x300a,0x300b,0x300c,0x300d,0x300e, /* 0x8170-0x8177 */
	0x300f,0x3010,0x3011,0xff0b,0xff0d,0x00b1,0x00d7,0x0000, /* 0x8178-0x817F */
	/* codebase=0x8180 rawbase=0x0140 */
	0x00f7,0xff1d,0x2260,0xff1c,0xff1e,0x2266,0x2267,0x221e, /* 0x8180-0x8187 */
	0x2234,0x2642,0x2640,0x00b0,0x2032,0x2033,0x2103,0xffe5, /* 0x8188-0x818F */
	0xff04,0xffe0,0xffe1,0xff05,0xff03,0xff06,0xff0a,0xff20, /* 0x8190-0x8197 */
	0x00a7,0x2606,0x2605,0x25cb,0x25cf,0x25ce,0x25c7,0x25c6, /* 0x8198-0x819F */
	0x25a1,0x25a0,0x25b3,0x25b2,0x25bd,0x25bc,0x203b,0x3012, /* 0x81A0-0x81A7 */
	0x2192,0x2190,0x2191,0x2193,0x3013,0x0000,0x0000,0x0000, /* 0x81A8-0x81AF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x81B0-0x81B7 */
	0x2208,0x220b,0x2286,0x2287,0x2282,0x2283,0x222a,0x2229, /* 0x81B8-0x81BF */
	/* codebase=0x81c0 rawbase=0x0180 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x81C0-0x81C7 */
	0x2227,0x2228,0xffe2,0x21d2,0x21d4,0x2200,0x2203,0x0000, /* 0x81C8-0x81CF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x81D0-0x81D7 */
	0x0000,0x0000,0x2220,0x22a5,0x2312,0x2202,0x2207,0x2261, /* 0x81D8-0x81DF */
	0x2252,0x226a,0x226b,0x221a,0x223d,0x221d,0x2235,0x222b, /* 0x81E0-0x81E7 */
	0x222c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x81E8-0x81EF */
	0x212b,0x2030,0x266f,0x266d,0x266a,0x2020,0x2021,0x00b6, /* 0x81F0-0x81F7 */
	0x0000,0x0000,0x0000,0x0000,0x25ef,0x0000,0x0000,0x0000, /* 0x81F8-0x81FF */
	/* codebase=0x8240 rawbase=0x01c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8240-0x8247 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff10, /* 0x8248-0x824F */
	0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18, /* 0x8250-0x8257 */
	0xff19,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8258-0x825F */
	0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28, /* 0x8260-0x8267 */
	0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30, /* 0x8268-0x826F */
	0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38, /* 0x8270-0x8277 */
	0xff39,0xff3a,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8278-0x827F */
	/* codebase=0x8280 rawbase=0x0200 */
	0x0000,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47, /* 0x8280-0x8287 */
	0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f, /* 0x8288-0x828F */
	0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57, /* 0x8290-0x8297 */
	0xff58,0xff59,0xff5a,0x0000,0x0000,0x0000,0x0000,0x3041, /* 0x8298-0x829F */
	0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049, /* 0x82A0-0x82A7 */
	0x304a,0x304b,0x304c,0x304d,0x304e,0x304f,0x3050,0x3051, /* 0x82A8-0x82AF */
	0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x3059, /* 0x82B0-0x82B7 */
	0x305a,0x305b,0x305c,0x305d,0x305e,0x305f,0x3060,0x3061, /* 0x82B8-0x82BF */
	/* codebase=0x82c0 rawbase=0x0240 */
	0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069, /* 0x82C0-0x82C7 */
	0x306a,0x306b,0x306c,0x306d,0x306e,0x306f,0x3070,0x3071, /* 0x82C8-0x82CF */
	0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,0x3078,0x3079, /* 0x82D0-0x82D7 */
	0x307a,0x307b,0x307c,0x307d,0x307e,0x307f,0x3080,0x3081, /* 0x82D8-0x82DF */
	0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089, /* 0x82E0-0x82E7 */
	0x308a,0x308b,0x308c,0x308d,0x308e,0x308f,0x3090,0x3091, /* 0x82E8-0x82EF */
	0x3092,0x3093,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x82F0-0x82F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x82F8-0x82FF */
	/* codebase=0x8340 rawbase=0x0280 */
	0x30a1,0x30a2,0x30a3,0x30a4,0x30a5,0x30a6,0x30a7,0x30a8, /* 0x8340-0x8347 */
	0x30a9,0x30aa,0x30ab,0x30ac,0x30ad,0x30ae,0x30af,0x30b0, /* 0x8348-0x834F */
	0x30b1,0x30b2,0x30b3,0x30b4,0x30b5,0x30b6,0x30b7,0x30b8, /* 0x8350-0x8357 */
	0x30b9,0x30ba,0x30bb,0x30bc,0x30bd,0x30be,0x30bf,0x30c0, /* 0x8358-0x835F */
	0x30c1,0x30c2,0x30c3,0x30c4,0x30c5,0x30c6,0x30c7,0x30c8, /* 0x8360-0x8367 */
	0x30c9,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d0, /* 0x8368-0x836F */
	0x30d1,0x30d2,0x30d3,0x30d4,0x30d5,0x30d6,0x30d7,0x30d8, /* 0x8370-0x8377 */
	0x30d9,0x30da,0x30db,0x30dc,0x30dd,0x30de,0x30df,0x0000, /* 0x8378-0x837F */
	/* codebase=0x8380 rawbase=0x02c0 */
	0x30e0,0x30e1,0x30e2,0x30e3,0x30e4,0x30e5,0x30e6,0x30e7, /* 0x8380-0x8387 */
	0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ee,0x30ef, /* 0x8388-0x838F */
	0x30f0,0x30f1,0x30f2,0x30f3,0x30f4,0x30f5,0x30f6,0x0000, /* 0x8390-0x8397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0391, /* 0x8398-0x839F */
	0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399, /* 0x83A0-0x83A7 */
	0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1, /* 0x83A8-0x83AF */
	0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x0000, /* 0x83B0-0x83B7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x03b1, /* 0x83B8-0x83BF */
	/* codebase=0x83c0 rawbase=0x0300 */
	0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9, /* 0x83C0-0x83C7 */
	0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1, /* 0x83C8-0x83CF */
	0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x0000, /* 0x83D0-0x83D7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x83D8-0x83DF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x83E0-0x83E7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x83E8-0x83EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x83F0-0x83F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x83F8-0x83FF */
	/* codebase=0x8440 rawbase=0x0340 */
	0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401,0x0416, /* 0x8440-0x8447 */
	0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d,0x041e, /* 0x8448-0x844F */
	0x041f,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,0x0426, /* 0x8450-0x8457 */
	0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d,0x042e, /* 0x8458-0x845F */
	0x042f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8460-0x8467 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8468-0x846F */
	0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451,0x0436, /* 0x8470-0x8477 */
	0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d,0x0000, /* 0x8478-0x847F */
	/* codebase=0x8480 rawbase=0x0380 */
	0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445, /* 0x8480-0x8487 */
	0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d, /* 0x8488-0x848F */
	0x044e,0x044f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8490-0x8497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2500, /* 0x8498-0x849F */
	0x2502,0x250c,0x2510,0x2518,0x2514,0x251c,0x252c,0x2524, /* 0x84A0-0x84A7 */
	0x2534,0x253c,0x2501,0x2503,0x250f,0x2513,0x251b,0x2517, /* 0x84A8-0x84AF */
	0x2523,0x2533,0x252b,0x253b,0x254b,0x2520,0x252f,0x2528, /* 0x84B0-0x84B7 */
	0x2537,0x253f,0x251d,0x2530,0x2525,0x2538,0x2542,0x0000, /* 0x84B8-0x84BF */
	/* codebase=0x8740 rawbase=0x03c0 */
	0x2460,0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467, /* 0x8740-0x8747 */
	0x2468,0x2469,0x246a,0x246b,0x246c,0x246d,0x246e,0x246f, /* 0x8748-0x874F */
	0x2470,0x2471,0x2472,0x2473,0x2160,0x2161,0x2162,0x2163, /* 0x8750-0x8757 */
	0x2164,0x2165,0x2166,0x2167,0x2168,0x2169,0x0000,0x3349, /* 0x8758-0x875F */
	0x3314,0x3322,0x334d,0x3318,0x3327,0x3303,0x3336,0x3351, /* 0x8760-0x8767 */
	0x3357,0x330d,0x3326,0x3323,0x332b,0x334a,0x333b,0x339c, /* 0x8768-0x876F */
	0x339d,0x339e,0x338e,0x338f,0x33c4,0x33a1,0x0000,0x0000, /* 0x8770-0x8777 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x337b,0x0000, /* 0x8778-0x877F */
	/* codebase=0x8780 rawbase=0x0400 */
	0x301d,0x301f,0x2116,0x33cd,0x2121,0x32a4,0x32a5,0x32a6, /* 0x8780-0x8787 */
	0x32a7,0x32a8,0x3231,0x3232,0x3239,0x337e,0x337d,0x337c, /* 0x8788-0x878F */
	0x2252,0x2261,0x222b,0x222e,0x2211,0x221a,0x22a5,0x2220, /* 0x8790-0x8797 */
	0x221f,0x22bf,0x2235,0x2229,0x222a,0x0000,0x0000,0x0000, /* 0x8798-0x879F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x87A0-0x87A7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x87A8-0x87AF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x87B0-0x87B7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x87B8-0x87BF */
	/* codebase=0x8880 rawbase=0x0440 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8880-0x8887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8888-0x888F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8890-0x8897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4e9c, /* 0x8898-0x889F */
	0x5516,0x5a03,0x963f,0x54c0,0x611b,0x6328,0x59f6,0x9022, /* 0x88A0-0x88A7 */
	0x8475,0x831c,0x7a50,0x60aa,0x63e1,0x6e25,0x65ed,0x8466, /* 0x88A8-0x88AF */
	0x82a6,0x9bf5,0x6893,0x5727,0x65a1,0x6271,0x5b9b,0x59d0, /* 0x88B0-0x88B7 */
	0x867b,0x98f4,0x7d62,0x7dbe,0x9b8e,0x6216,0x7c9f,0x88b7, /* 0x88B8-0x88BF */
	/* codebase=0x88c0 rawbase=0x0480 */
	0x5b89,0x5eb5,0x6309,0x6697,0x6848,0x95c7,0x978d,0x674f, /* 0x88C0-0x88C7 */
	0x4ee5,0x4f0a,0x4f4d,0x4f9d,0x5049,0x56f2,0x5937,0x59d4, /* 0x88C8-0x88CF */
	0x5a01,0x5c09,0x60df,0x610f,0x6170,0x6613,0x6905,0x70ba, /* 0x88D0-0x88D7 */
	0x754f,0x7570,0x79fb,0x7dad,0x7def,0x80c3,0x840e,0x8863, /* 0x88D8-0x88DF */
	0x8b02,0x9055,0x907a,0x533b,0x4e95,0x4ea5,0x57df,0x80b2, /* 0x88E0-0x88E7 */
	0x90c1,0x78ef,0x4e00,0x58f1,0x6ea2,0x9038,0x7a32,0x8328, /* 0x88E8-0x88EF */
	0x828b,0x9c2f,0x5141,0x5370,0x54bd,0x54e1,0x56e0,0x59fb, /* 0x88F0-0x88F7 */
	0x5f15,0x98f2,0x6deb,0x80e4,0x852d,0x0000,0x0000,0x0000, /* 0x88F8-0x88FF */
	/* codebase=0x8940 rawbase=0x04c0 */
	0x9662,0x9670,0x96a0,0x97fb,0x540b,0x53f3,0x5b87,0x70cf, /* 0x8940-0x8947 */
	0x7fbd,0x8fc2,0x96e8,0x536f,0x9d5c,0x7aba,0x4e11,0x7893, /* 0x8948-0x894F */
	0x81fc,0x6e26,0x5618,0x5504,0x6b1d,0x851a,0x9c3b,0x59e5, /* 0x8950-0x8957 */
	0x53a9,0x6d66,0x74dc,0x958f,0x5642,0x4e91,0x904b,0x96f2, /* 0x8958-0x895F */
	0x834f,0x990c,0x53e1,0x55b6,0x5b30,0x5f71,0x6620,0x66f3, /* 0x8960-0x8967 */
	0x6804,0x6c38,0x6cf3,0x6d29,0x745b,0x76c8,0x7a4e,0x9834, /* 0x8968-0x896F */
	0x82f1,0x885b,0x8a60,0x92ed,0x6db2,0x75ab,0x76ca,0x99c5, /* 0x8970-0x8977 */
	0x60a6,0x8b01,0x8d8a,0x95b2,0x698e,0x53ad,0x5186,0x0000, /* 0x8978-0x897F */
	/* codebase=0x8980 rawbase=0x0500 */
	0x5712,0x5830,0x5944,0x5bb4,0x5ef6,0x6028,0x63a9,0x63f4, /* 0x8980-0x8987 */
	0x6cbf,0x6f14,0x708e,0x7114,0x7159,0x71d5,0x733f,0x7e01, /* 0x8988-0x898F */
	0x8276,0x82d1,0x8597,0x9060,0x925b,0x9d1b,0x5869,0x65bc, /* 0x8990-0x8997 */
	0x6c5a,0x7525,0x51f9,0x592e,0x5965,0x5f80,0x5fdc,0x62bc, /* 0x8998-0x899F */
	0x65fa,0x6a2a,0x6b27,0x6bb4,0x738b,0x7fc1,0x8956,0x9d2c, /* 0x89A0-0x89A7 */
	0x9d0e,0x9ec4,0x5ca1,0x6c96,0x837b,0x5104,0x5c4b,0x61b6, /* 0x89A8-0x89AF */
	0x81c6,0x6876,0x7261,0x4e59,0x4ffa,0x5378,0x6069,0x6e29, /* 0x89B0-0x89B7 */
	0x7a4f,0x97f3,0x4e0b,0x5316,0x4eee,0x4f55,0x4f3d,0x4fa1, /* 0x89B8-0x89BF */
	/* codebase=0x89c0 rawbase=0x0540 */
	0x4f73,0x52a0,0x53ef,0x5609,0x590f,0x5ac1,0x5bb6,0x5be1, /* 0x89C0-0x89C7 */
	0x79d1,0x6687,0x679c,0x67b6,0x6b4c,0x6cb3,0x706b,0x73c2, /* 0x89C8-0x89CF */
	0x798d,0x79be,0x7a3c,0x7b87,0x82b1,0x82db,0x8304,0x8377, /* 0x89D0-0x89D7 */
	0x83ef,0x83d3,0x8766,0x8ab2,0x5629,0x8ca8,0x8fe6,0x904e, /* 0x89D8-0x89DF */
	0x971e,0x868a,0x4fc4,0x5ce8,0x6211,0x7259,0x753b,0x81e5, /* 0x89E0-0x89E7 */
	0x82bd,0x86fe,0x8cc0,0x96c5,0x9913,0x99d5,0x4ecb,0x4f1a, /* 0x89E8-0x89EF */
	0x89e3,0x56de,0x584a,0x58ca,0x5efb,0x5feb,0x602a,0x6094, /* 0x89F0-0x89F7 */
	0x6062,0x61d0,0x6212,0x62d0,0x6539,0x0000,0x0000,0x0000, /* 0x89F8-0x89FF */
	/* codebase=0x8a40 rawbase=0x0580 */
	0x9b41,0x6666,0x68b0,0x6d77,0x7070,0x754c,0x7686,0x7d75, /* 0x8A40-0x8A47 */
	0x82a5,0x87f9,0x958b,0x968e,0x8c9d,0x51f1,0x52be,0x5916, /* 0x8A48-0x8A4F */
	0x54b3,0x5bb3,0x5d16,0x6168,0x6982,0x6daf,0x788d,0x84cb, /* 0x8A50-0x8A57 */
	0x8857,0x8a72,0x93a7,0x9ab8,0x6d6c,0x99a8,0x86d9,0x57a3, /* 0x8A58-0x8A5F */
	0x67ff,0x86ce,0x920e,0x5283,0x5687,0x5404,0x5ed3,0x62e1, /* 0x8A60-0x8A67 */
	0x64b9,0x683c,0x6838,0x6bbb,0x7372,0x78ba,0x7a6b,0x899a, /* 0x8A68-0x8A6F */
	0x89d2,0x8d6b,0x8f03,0x90ed,0x95a3,0x9694,0x9769,0x5b66, /* 0x8A70-0x8A77 */
	0x5cb3,0x697d,0x984d,0x984e,0x639b,0x7b20,0x6a2b,0x0000, /* 0x8A78-0x8A7F */
	/* codebase=0x8a80 rawbase=0x05c0 */
	0x6a7f,0x68b6,0x9c0d,0x6f5f,0x5272,0x559d,0x6070,0x62ec, /* 0x8A80-0x8A87 */
	0x6d3b,0x6e07,0x6ed1,0x845b,0x8910,0x8f44,0x4e14,0x9c39, /* 0x8A88-0x8A8F */
	0x53f6,0x691b,0x6a3a,0x9784,0x682a,0x515c,0x7ac3,0x84b2, /* 0x8A90-0x8A97 */
	0x91dc,0x938c,0x565b,0x9d28,0x6822,0x8305,0x8431,0x7ca5, /* 0x8A98-0x8A9F */
	0x5208,0x82c5,0x74e6,0x4e7e,0x4f83,0x51a0,0x5bd2,0x520a, /* 0x8AA0-0x8AA7 */
	0x52d8,0x52e7,0x5dfb,0x559a,0x582a,0x59e6,0x5b8c,0x5b98, /* 0x8AA8-0x8AAF */
	0x5bdb,0x5e72,0x5e79,0x60a3,0x611f,0x6163,0x61be,0x63db, /* 0x8AB0-0x8AB7 */
	0x6562,0x67d1,0x6853,0x68fa,0x6b3e,0x6b53,0x6c57,0x6f22, /* 0x8AB8-0x8ABF */
	/* codebase=0x8ac0 rawbase=0x0600 */
	0x6f97,0x6f45,0x74b0,0x7518,0x76e3,0x770b,0x7aff,0x7ba1, /* 0x8AC0-0x8AC7 */
	0x7c21,0x7de9,0x7f36,0x7ff0,0x809d,0x8266,0x839e,0x89b3, /* 0x8AC8-0x8ACF */
	0x8acc,0x8cab,0x9084,0x9451,0x9593,0x9591,0x95a2,0x9665, /* 0x8AD0-0x8AD7 */
	0x97d3,0x9928,0x8218,0x4e38,0x542b,0x5cb8,0x5dcc,0x73a9, /* 0x8AD8-0x8ADF */
	0x764c,0x773c,0x5ca9,0x7feb,0x8d0b,0x96c1,0x9811,0x9854, /* 0x8AE0-0x8AE7 */
	0x9858,0x4f01,0x4f0e,0x5371,0x559c,0x5668,0x57fa,0x5947, /* 0x8AE8-0x8AEF */
	0x5b09,0x5bc4,0x5c90,0x5e0c,0x5e7e,0x5fcc,0x63ee,0x673a, /* 0x8AF0-0x8AF7 */
	0x65d7,0x65e2,0x671f,0x68cb,0x68c4,0x0000,0x0000,0x0000, /* 0x8AF8-0x8AFF */
	/* codebase=0x8b40 rawbase=0x0640 */
	0x6a5f,0x5e30,0x6bc5,0x6c17,0x6c7d,0x757f,0x7948,0x5b63, /* 0x8B40-0x8B47 */
	0x7a00,0x7d00,0x5fbd,0x898f,0x8a18,0x8cb4,0x8d77,0x8ecc, /* 0x8B48-0x8B4F */
	0x8f1d,0x98e2,0x9a0e,0x9b3c,0x4e80,0x507d,0x5100,0x5993, /* 0x8B50-0x8B57 */
	0x5b9c,0x622f,0x6280,0x64ec,0x6b3a,0x72a0,0x7591,0x7947, /* 0x8B58-0x8B5F */
	0x7fa9,0x87fb,0x8abc,0x8b70,0x63ac,0x83ca,0x97a0,0x5409, /* 0x8B60-0x8B67 */
	0x5403,0x55ab,0x6854,0x6a58,0x8a70,0x7827,0x6775,0x9ecd, /* 0x8B68-0x8B6F */
	0x5374,0x5ba2,0x811a,0x8650,0x9006,0x4e18,0x4e45,0x4ec7, /* 0x8B70-0x8B77 */
	0x4f11,0x53ca,0x5438,0x5bae,0x5f13,0x6025,0x6551,0x0000, /* 0x8B78-0x8B7F */
	/* codebase=0x8b80 rawbase=0x0680 */
	0x673d,0x6c42,0x6c72,0x6ce3,0x7078,0x7403,0x7a76,0x7aae, /* 0x8B80-0x8B87 */
	0x7b08,0x7d1a,0x7cfe,0x7d66,0x65e7,0x725b,0x53bb,0x5c45, /* 0x8B88-0x8B8F */
	0x5de8,0x62d2,0x62e0,0x6319,0x6e20,0x865a,0x8a31,0x8ddd, /* 0x8B90-0x8B97 */
	0x92f8,0x6f01,0x79a6,0x9b5a,0x4ea8,0x4eab,0x4eac,0x4f9b, /* 0x8B98-0x8B9F */
	0x4fa0,0x50d1,0x5147,0x7af6,0x5171,0x51f6,0x5354,0x5321, /* 0x8BA0-0x8BA7 */
	0x537f,0x53eb,0x55ac,0x5883,0x5ce1,0x5f37,0x5f4a,0x602f, /* 0x8BA8-0x8BAF */
	0x6050,0x606d,0x631f,0x6559,0x6a4b,0x6cc1,0x72c2,0x72ed, /* 0x8BB0-0x8BB7 */
	0x77ef,0x80f8,0x8105,0x8208,0x854e,0x90f7,0x93e1,0x97ff, /* 0x8BB8-0x8BBF */
	/* codebase=0x8bc0 rawbase=0x06c0 */
	0x9957,0x9a5a,0x4ef0,0x51dd,0x5c2d,0x6681,0x696d,0x5c40, /* 0x8BC0-0x8BC7 */
	0x66f2,0x6975,0x7389,0x6850,0x7c81,0x50c5,0x52e4,0x5747, /* 0x8BC8-0x8BCF */
	0x5dfe,0x9326,0x65a4,0x6b23,0x6b3d,0x7434,0x7981,0x79bd, /* 0x8BD0-0x8BD7 */
	0x7b4b,0x7dca,0x82b9,0x83cc,0x887f,0x895f,0x8b39,0x8fd1, /* 0x8BD8-0x8BDF */
	0x91d1,0x541f,0x9280,0x4e5d,0x5036,0x53e5,0x533a,0x72d7, /* 0x8BE0-0x8BE7 */
	0x7396,0x77e9,0x82e6,0x8eaf,0x99c6,0x99c8,0x99d2,0x5177, /* 0x8BE8-0x8BEF */
	0x611a,0x865e,0x55b0,0x7a7a,0x5076,0x5bd3,0x9047,0x9685, /* 0x8BF0-0x8BF7 */
	0x4e32,0x6adb,0x91e7,0x5c51,0x5c48,0x0000,0x0000,0x0000, /* 0x8BF8-0x8BFF */
	/* codebase=0x8c40 rawbase=0x0700 */
	0x6398,0x7a9f,0x6c93,0x9774,0x8f61,0x7aaa,0x718a,0x9688, /* 0x8C40-0x8C47 */
	0x7c82,0x6817,0x7e70,0x6851,0x936c,0x52f2,0x541b,0x85ab, /* 0x8C48-0x8C4F */
	0x8a13,0x7fa4,0x8ecd,0x90e1,0x5366,0x8888,0x7941,0x4fc2, /* 0x8C50-0x8C57 */
	0x50be,0x5211,0x5144,0x5553,0x572d,0x73ea,0x578b,0x5951, /* 0x8C58-0x8C5F */
	0x5f62,0x5f84,0x6075,0x6176,0x6167,0x61a9,0x63b2,0x643a, /* 0x8C60-0x8C67 */
	0x656c,0x666f,0x6842,0x6e13,0x7566,0x7a3d,0x7cfb,0x7d4c, /* 0x8C68-0x8C6F */
	0x7d99,0x7e4b,0x7f6b,0x830e,0x834a,0x86cd,0x8a08,0x8a63, /* 0x8C70-0x8C77 */
	0x8b66,0x8efd,0x981a,0x9d8f,0x82b8,0x8fce,0x9be8,0x0000, /* 0x8C78-0x8C7F */
	/* codebase=0x8c80 rawbase=0x0740 */
	0x5287,0x621f,0x6483,0x6fc0,0x9699,0x6841,0x5091,0x6b20, /* 0x8C80-0x8C87 */
	0x6c7a,0x6f54,0x7a74,0x7d50,0x8840,0x8a23,0x6708,0x4ef6, /* 0x8C88-0x8C8F */
	0x5039,0x5026,0x5065,0x517c,0x5238,0x5263,0x55a7,0x570f, /* 0x8C90-0x8C97 */
	0x5805,0x5acc,0x5efa,0x61b2,0x61f8,0x62f3,0x6372,0x691c, /* 0x8C98-0x8C9F */
	0x6a29,0x727d,0x72ac,0x732e,0x7814,0x786f,0x7d79,0x770c, /* 0x8CA0-0x8CA7 */
	0x80a9,0x898b,0x8b19,0x8ce2,0x8ed2,0x9063,0x9375,0x967a, /* 0x8CA8-0x8CAF */
	0x9855,0x9a13,0x9e78,0x5143,0x539f,0x53b3,0x5e7b,0x5f26, /* 0x8CB0-0x8CB7 */
	0x6e1b,0x6e90,0x7384,0x73fe,0x7d43,0x8237,0x8a00,0x8afa, /* 0x8CB8-0x8CBF */
	/* codebase=0x8cc0 rawbase=0x0780 */
	0x9650,0x4e4e,0x500b,0x53e4,0x547c,0x56fa,0x59d1,0x5b64, /* 0x8CC0-0x8CC7 */
	0x5df1,0x5eab,0x5f27,0x6238,0x6545,0x67af,0x6e56,0x72d0, /* 0x8CC8-0x8CCF */
	0x7cca,0x88b4,0x80a1,0x80e1,0x83f0,0x864e,0x8a87,0x8de8, /* 0x8CD0-0x8CD7 */
	0x9237,0x96c7,0x9867,0x9f13,0x4e94,0x4e92,0x4f0d,0x5348, /* 0x8CD8-0x8CDF */
	0x5449,0x543e,0x5a2f,0x5f8c,0x5fa1,0x609f,0x68a7,0x6a8e, /* 0x8CE0-0x8CE7 */
	0x745a,0x7881,0x8a9e,0x8aa4,0x8b77,0x9190,0x4e5e,0x9bc9, /* 0x8CE8-0x8CEF */
	0x4ea4,0x4f7c,0x4faf,0x5019,0x5016,0x5149,0x516c,0x529f, /* 0x8CF0-0x8CF7 */
	0x52b9,0x52fe,0x539a,0x53e3,0x5411,0x0000,0x0000,0x0000, /* 0x8CF8-0x8CFF */
	/* codebase=0x8d40 rawbase=0x07c0 */
	0x540e,0x5589,0x5751,0x57a2,0x597d,0x5b54,0x5b5d,0x5b8f, /* 0x8D40-0x8D47 */
	0x5de5,0x5de7,0x5df7,0x5e78,0x5e83,0x5e9a,0x5eb7,0x5f18, /* 0x8D48-0x8D4F */
	0x6052,0x614c,0x6297,0x62d8,0x63a7,0x653b,0x6602,0x6643, /* 0x8D50-0x8D57 */
	0x66f4,0x676d,0x6821,0x6897,0x69cb,0x6c5f,0x6d2a,0x6d69, /* 0x8D58-0x8D5F */
	0x6e2f,0x6e9d,0x7532,0x7687,0x786c,0x7a3f,0x7ce0,0x7d05, /* 0x8D60-0x8D67 */
	0x7d18,0x7d5e,0x7db1,0x8015,0x8003,0x80af,0x80b1,0x8154, /* 0x8D68-0x8D6F */
	0x818f,0x822a,0x8352,0x884c,0x8861,0x8b1b,0x8ca2,0x8cfc, /* 0x8D70-0x8D77 */
	0x90ca,0x9175,0x9271,0x783f,0x92fc,0x95a4,0x964d,0x0000, /* 0x8D78-0x8D7F */
	/* codebase=0x8d80 rawbase=0x0800 */
	0x9805,0x9999,0x9ad8,0x9d3b,0x525b,0x52ab,0x53f7,0x5408, /* 0x8D80-0x8D87 */
	0x58d5,0x62f7,0x6fe0,0x8c6a,0x8f5f,0x9eb9,0x514b,0x523b, /* 0x8D88-0x8D8F */
	0x544a,0x56fd,0x7a40,0x9177,0x9d60,0x9ed2,0x7344,0x6f09, /* 0x8D90-0x8D97 */
	0x8170,0x7511,0x5ffd,0x60da,0x9aa8,0x72db,0x8fbc,0x6b64, /* 0x8D98-0x8D9F */
	0x9803,0x4eca,0x56f0,0x5764,0x58be,0x5a5a,0x6068,0x61c7, /* 0x8DA0-0x8DA7 */
	0x660f,0x6606,0x6839,0x68b1,0x6df7,0x75d5,0x7d3a,0x826e, /* 0x8DA8-0x8DAF */
	0x9b42,0x4e9b,0x4f50,0x53c9,0x5506,0x5d6f,0x5de6,0x5dee, /* 0x8DB0-0x8DB7 */
	0x67fb,0x6c99,0x7473,0x7802,0x8a50,0x9396,0x88df,0x5750, /* 0x8DB8-0x8DBF */
	/* codebase=0x8dc0 rawbase=0x0840 */
	0x5ea7,0x632b,0x50b5,0x50ac,0x518d,0x6700,0x54c9,0x585e, /* 0x8DC0-0x8DC7 */
	0x59bb,0x5bb0,0x5f69,0x624d,0x63a1,0x683d,0x6b73,0x6e08, /* 0x8DC8-0x8DCF */
	0x707d,0x91c7,0x7280,0x7815,0x7826,0x796d,0x658e,0x7d30, /* 0x8DD0-0x8DD7 */
	0x83dc,0x88c1,0x8f09,0x969b,0x5264,0x5728,0x6750,0x7f6a, /* 0x8DD8-0x8DDF */
	0x8ca1,0x51b4,0x5742,0x962a,0x583a,0x698a,0x80b4,0x54b2, /* 0x8DE0-0x8DE7 */
	0x5d0e,0x57fc,0x7895,0x9dfa,0x4f5c,0x524a,0x548b,0x643e, /* 0x8DE8-0x8DEF */
	0x6628,0x6714,0x67f5,0x7a84,0x7b56,0x7d22,0x932f,0x685c, /* 0x8DF0-0x8DF7 */
	0x9bad,0x7b39,0x5319,0x518a,0x5237,0x0000,0x0000,0x0000, /* 0x8DF8-0x8DFF */
	/* codebase=0x8e40 rawbase=0x0880 */
	0x5bdf,0x62f6,0x64ae,0x64e6,0x672d,0x6bba,0x85a9,0x96d1, /* 0x8E40-0x8E47 */
	0x7690,0x9bd6,0x634c,0x9306,0x9bab,0x76bf,0x6652,0x4e09, /* 0x8E48-0x8E4F */
	0x5098,0x53c2,0x5c71,0x60e8,0x6492,0x6563,0x685f,0x71e6, /* 0x8E50-0x8E57 */
	0x73ca,0x7523,0x7b97,0x7e82,0x8695,0x8b83,0x8cdb,0x9178, /* 0x8E58-0x8E5F */
	0x9910,0x65ac,0x66ab,0x6b8b,0x4ed5,0x4ed4,0x4f3a,0x4f7f, /* 0x8E60-0x8E67 */
	0x523a,0x53f8,0x53f2,0x55e3,0x56db,0x58eb,0x59cb,0x59c9, /* 0x8E68-0x8E6F */
	0x59ff,0x5b50,0x5c4d,0x5e02,0x5e2b,0x5fd7,0x601d,0x6307, /* 0x8E70-0x8E77 */
	0x652f,0x5b5c,0x65af,0x65bd,0x65e8,0x679d,0x6b62,0x0000, /* 0x8E78-0x8E7F */
	/* codebase=0x8e80 rawbase=0x08c0 */
	0x6b7b,0x6c0f,0x7345,0x7949,0x79c1,0x7cf8,0x7d19,0x7d2b, /* 0x8E80-0x8E87 */
	0x80a2,0x8102,0x81f3,0x8996,0x8a5e,0x8a69,0x8a66,0x8a8c, /* 0x8E88-0x8E8F */
	0x8aee,0x8cc7,0x8cdc,0x96cc,0x98fc,0x6b6f,0x4e8b,0x4f3c, /* 0x8E90-0x8E97 */
	0x4f8d,0x5150,0x5b57,0x5bfa,0x6148,0x6301,0x6642,0x6b21, /* 0x8E98-0x8E9F */
	0x6ecb,0x6cbb,0x723e,0x74bd,0x75d4,0x78c1,0x793a,0x800c, /* 0x8EA0-0x8EA7 */
	0x8033,0x81ea,0x8494,0x8f9e,0x6c50,0x9e7f,0x5f0f,0x8b58, /* 0x8EA8-0x8EAF */
	0x9d2b,0x7afa,0x8ef8,0x5b8d,0x96eb,0x4e03,0x53f1,0x57f7, /* 0x8EB0-0x8EB7 */
	0x5931,0x5ac9,0x5ba4,0x6089,0x6e7f,0x6f06,0x75be,0x8cea, /* 0x8EB8-0x8EBF */
	/* codebase=0x8ec0 rawbase=0x0900 */
	0x5b9f,0x8500,0x7be0,0x5072,0x67f4,0x829d,0x5c61,0x854a, /* 0x8EC0-0x8EC7 */
	0x7e1e,0x820e,0x5199,0x5c04,0x6368,0x8d66,0x659c,0x716e, /* 0x8EC8-0x8ECF */
	0x793e,0x7d17,0x8005,0x8b1d,0x8eca,0x906e,0x86c7,0x90aa, /* 0x8ED0-0x8ED7 */
	0x501f,0x52fa,0x5c3a,0x6753,0x707c,0x7235,0x914c,0x91c8, /* 0x8ED8-0x8EDF */
	0x932b,0x82e5,0x5bc2,0x5f31,0x60f9,0x4e3b,0x53d6,0x5b88, /* 0x8EE0-0x8EE7 */
	0x624b,0x6731,0x6b8a,0x72e9,0x73e0,0x7a2e,0x816b,0x8da3, /* 0x8EE8-0x8EEF */
	0x9152,0x9996,0x5112,0x53d7,0x546a,0x5bff,0x6388,0x6a39, /* 0x8EF0-0x8EF7 */
	0x7dac,0x9700,0x56da,0x53ce,0x5468,0x0000,0x0000,0x0000, /* 0x8EF8-0x8EFF */
	/* codebase=0x8f40 rawbase=0x0940 */
	0x5b97,0x5c31,0x5dde,0x4fee,0x6101,0x62fe,0x6d32,0x79c0, /* 0x8F40-0x8F47 */
	0x79cb,0x7d42,0x7e4d,0x7fd2,0x81ed,0x821f,0x8490,0x8846, /* 0x8F48-0x8F4F */
	0x8972,0x8b90,0x8e74,0x8f2f,0x9031,0x914b,0x916c,0x96c6, /* 0x8F50-0x8F57 */
	0x919c,0x4ec0,0x4f4f,0x5145,0x5341,0x5f93,0x620e,0x67d4, /* 0x8F58-0x8F5F */
	0x6c41,0x6e0b,0x7363,0x7e26,0x91cd,0x9283,0x53d4,0x5919, /* 0x8F60-0x8F67 */
	0x5bbf,0x6dd1,0x795d,0x7e2e,0x7c9b,0x587e,0x719f,0x51fa, /* 0x8F68-0x8F6F */
	0x8853,0x8ff0,0x4fca,0x5cfb,0x6625,0x77ac,0x7ae3,0x821c, /* 0x8F70-0x8F77 */
	0x99ff,0x51c6,0x5faa,0x65ec,0x696f,0x6b89,0x6df3,0x0000, /* 0x8F78-0x8F7F */
	/* codebase=0x8f80 rawbase=0x0980 */
	0x6e96,0x6f64,0x76fe,0x7d14,0x5de1,0x9075,0x9187,0x9806, /* 0x8F80-0x8F87 */
	0x51e6,0x521d,0x6240,0x6691,0x66d9,0x6e1a,0x5eb6,0x7dd2, /* 0x8F88-0x8F8F */
	0x7f72,0x66f8,0x85af,0x85f7,0x8af8,0x52a9,0x53d9,0x5973, /* 0x8F90-0x8F97 */
	0x5e8f,0x5f90,0x6055,0x92e4,0x9664,0x50b7,0x511f,0x52dd, /* 0x8F98-0x8F9F */
	0x5320,0x5347,0x53ec,0x54e8,0x5546,0x5531,0x5617,0x5968, /* 0x8FA0-0x8FA7 */
	0x59be,0x5a3c,0x5bb5,0x5c06,0x5c0f,0x5c11,0x5c1a,0x5e84, /* 0x8FA8-0x8FAF */
	0x5e8a,0x5ee0,0x5f70,0x627f,0x6284,0x62db,0x638c,0x6377, /* 0x8FB0-0x8FB7 */
	0x6607,0x660c,0x662d,0x6676,0x677e,0x68a2,0x6a1f,0x6a35, /* 0x8FB8-0x8FBF */
	/* codebase=0x8fc0 rawbase=0x09c0 */
	0x6cbc,0x6d88,0x6e09,0x6e58,0x713c,0x7126,0x7167,0x75c7, /* 0x8FC0-0x8FC7 */
	0x7701,0x785d,0x7901,0x7965,0x79f0,0x7ae0,0x7b11,0x7ca7, /* 0x8FC8-0x8FCF */
	0x7d39,0x8096,0x83d6,0x848b,0x8549,0x885d,0x88f3,0x8a1f, /* 0x8FD0-0x8FD7 */
	0x8a3c,0x8a54,0x8a73,0x8c61,0x8cde,0x91a4,0x9266,0x937e, /* 0x8FD8-0x8FDF */
	0x9418,0x969c,0x9798,0x4e0a,0x4e08,0x4e1e,0x4e57,0x5197, /* 0x8FE0-0x8FE7 */
	0x5270,0x57ce,0x5834,0x58cc,0x5b22,0x5e38,0x60c5,0x64fe, /* 0x8FE8-0x8FEF */
	0x6761,0x6756,0x6d44,0x72b6,0x7573,0x7a63,0x84b8,0x8b72, /* 0x8FF0-0x8FF7 */
	0x91b8,0x9320,0x5631,0x57f4,0x98fe,0x0000,0x0000,0x0000, /* 0x8FF8-0x8FFF */
	/* codebase=0x9040 rawbase=0x0a00 */
	0x62ed,0x690d,0x6b96,0x71ed,0x7e54,0x8077,0x8272,0x89e6, /* 0x9040-0x9047 */
	0x98df,0x8755,0x8fb1,0x5c3b,0x4f38,0x4fe1,0x4fb5,0x5507, /* 0x9048-0x904F */
	0x5a20,0x5bdd,0x5be9,0x5fc3,0x614e,0x632f,0x65b0,0x664b, /* 0x9050-0x9057 */
	0x68ee,0x699b,0x6d78,0x6df1,0x7533,0x75b9,0x771f,0x795e, /* 0x9058-0x905F */
	0x79e6,0x7d33,0x81e3,0x82af,0x85aa,0x89aa,0x8a3a,0x8eab, /* 0x9060-0x9067 */
	0x8f9b,0x9032,0x91dd,0x9707,0x4eba,0x4ec1,0x5203,0x5875, /* 0x9068-0x906F */
	0x58ec,0x5c0b,0x751a,0x5c3d,0x814e,0x8a0a,0x8fc5,0x9663, /* 0x9070-0x9077 */
	0x976d,0x7b25,0x8acf,0x9808,0x9162,0x56f3,0x53a8,0x0000, /* 0x9078-0x907F */
	/* codebase=0x9080 rawbase=0x0a40 */
	0x9017,0x5439,0x5782,0x5e25,0x63a8,0x6c34,0x708a,0x7761, /* 0x9080-0x9087 */
	0x7c8b,0x7fe0,0x8870,0x9042,0x9154,0x9310,0x9318,0x968f, /* 0x9088-0x908F */
	0x745e,0x9ac4,0x5d07,0x5d69,0x6570,0x67a2,0x8da8,0x96db, /* 0x9090-0x9097 */
	0x636e,0x6749,0x6919,0x83c5,0x9817,0x96c0,0x88fe,0x6f84, /* 0x9098-0x909F */
	0x647a,0x5bf8,0x4e16,0x702c,0x755d,0x662f,0x51c4,0x5236, /* 0x90A0-0x90A7 */
	0x52e2,0x59d3,0x5f81,0x6027,0x6210,0x653f,0x6574,0x661f, /* 0x90A8-0x90AF */
	0x6674,0x68f2,0x6816,0x6b63,0x6e05,0x7272,0x751f,0x76db, /* 0x90B0-0x90B7 */
	0x7cbe,0x8056,0x58f0,0x88fd,0x897f,0x8aa0,0x8a93,0x8acb, /* 0x90B8-0x90BF */
	/* codebase=0x90c0 rawbase=0x0a80 */
	0x901d,0x9192,0x9752,0x9759,0x6589,0x7a0e,0x8106,0x96bb, /* 0x90C0-0x90C7 */
	0x5e2d,0x60dc,0x621a,0x65a5,0x6614,0x6790,0x77f3,0x7a4d, /* 0x90C8-0x90CF */
	0x7c4d,0x7e3e,0x810a,0x8cac,0x8d64,0x8de1,0x8e5f,0x78a9, /* 0x90D0-0x90D7 */
	0x5207,0x62d9,0x63a5,0x6442,0x6298,0x8a2d,0x7a83,0x7bc0, /* 0x90D8-0x90DF */
	0x8aac,0x96ea,0x7d76,0x820c,0x8749,0x4ed9,0x5148,0x5343, /* 0x90E0-0x90E7 */
	0x5360,0x5ba3,0x5c02,0x5c16,0x5ddd,0x6226,0x6247,0x64b0, /* 0x90E8-0x90EF */
	0x6813,0x6834,0x6cc9,0x6d45,0x6d17,0x67d3,0x6f5c,0x714e, /* 0x90F0-0x90F7 */
	0x717d,0x65cb,0x7a7f,0x7bad,0x7dda,0x0000,0x0000,0x0000, /* 0x90F8-0x90FF */
	/* codebase=0x9140 rawbase=0x0ac0 */
	0x7e4a,0x7fa8,0x817a,0x821b,0x8239,0x85a6,0x8a6e,0x8cce, /* 0x9140-0x9147 */
	0x8df5,0x9078,0x9077,0x92ad,0x9291,0x9583,0x9bae,0x524d, /* 0x9148-0x914F */
	0x5584,0x6f38,0x7136,0x5168,0x7985,0x7e55,0x81b3,0x7cce, /* 0x9150-0x9157 */
	0x564c,0x5851,0x5ca8,0x63aa,0x66fe,0x66fd,0x695a,0x72d9, /* 0x9158-0x915F */
	0x758f,0x758e,0x790e,0x7956,0x79df,0x7c97,0x7d20,0x7d44, /* 0x9160-0x9167 */
	0x8607,0x8a34,0x963b,0x9061,0x9f20,0x50e7,0x5275,0x53cc, /* 0x9168-0x916F */
	0x53e2,0x5009,0x55aa,0x58ee,0x594f,0x723d,0x5b8b,0x5c64, /* 0x9170-0x9177 */
	0x531d,0x60e3,0x60f3,0x635c,0x6383,0x633f,0x63bb,0x0000, /* 0x9178-0x917F */
	/* codebase=0x9180 rawbase=0x0b00 */
	0x64cd,0x65e9,0x66f9,0x5de3,0x69cd,0x69fd,0x6f15,0x71e5, /* 0x9180-0x9187 */
	0x4e89,0x75e9,0x76f8,0x7a93,0x7cdf,0x7dcf,0x7d9c,0x8061, /* 0x9188-0x918F */
	0x8349,0x8358,0x846c,0x84bc,0x85fb,0x88c5,0x8d70,0x9001, /* 0x9190-0x9197 */
	0x906d,0x9397,0x971c,0x9a12,0x50cf,0x5897,0x618e,0x81d3, /* 0x9198-0x919F */
	0x8535,0x8d08,0x9020,0x4fc3,0x5074,0x5247,0x5373,0x606f, /* 0x91A0-0x91A7 */
	0x6349,0x675f,0x6e2c,0x8db3,0x901f,0x4fd7,0x5c5e,0x8cca, /* 0x91A8-0x91AF */
	0x65cf,0x7d9a,0x5352,0x8896,0x5176,0x63c3,0x5b58,0x5b6b, /* 0x91B0-0x91B7 */
	0x5c0a,0x640d,0x6751,0x905c,0x4ed6,0x591a,0x592a,0x6c70, /* 0x91B8-0x91BF */
	/* codebase=0x91c0 rawbase=0x0b40 */
	0x8a51,0x553e,0x5815,0x59a5,0x60f0,0x6253,0x67c1,0x8235, /* 0x91C0-0x91C7 */
	0x6955,0x9640,0x99c4,0x9a28,0x4f53,0x5806,0x5bfe,0x8010, /* 0x91C8-0x91CF */
	0x5cb1,0x5e2f,0x5f85,0x6020,0x614b,0x6234,0x66ff,0x6cf0, /* 0x91D0-0x91D7 */
	0x6ede,0x80ce,0x817f,0x82d4,0x888b,0x8cb8,0x9000,0x902e, /* 0x91D8-0x91DF */
	0x968a,0x9edb,0x9bdb,0x4ee3,0x53f0,0x5927,0x7b2c,0x918d, /* 0x91E0-0x91E7 */
	0x984c,0x9df9,0x6edd,0x7027,0x5353,0x5544,0x5b85,0x6258, /* 0x91E8-0x91EF */
	0x629e,0x62d3,0x6ca2,0x6fef,0x7422,0x8a17,0x9438,0x6fc1, /* 0x91F0-0x91F7 */
	0x8afe,0x8338,0x51e7,0x86f8,0x53ea,0x0000,0x0000,0x0000, /* 0x91F8-0x91FF */
	/* codebase=0x9240 rawbase=0x0b80 */
	0x53e9,0x4f46,0x9054,0x8fb0,0x596a,0x8131,0x5dfd,0x7aea, /* 0x9240-0x9247 */
	0x8fbf,0x68da,0x8c37,0x72f8,0x9c48,0x6a3d,0x8ab0,0x4e39, /* 0x9248-0x924F */
	0x5358,0x5606,0x5766,0x62c5,0x63a2,0x65e6,0x6b4e,0x6de1, /* 0x9250-0x9257 */
	0x6e5b,0x70ad,0x77ed,0x7aef,0x7baa,0x7dbb,0x803d,0x80c6, /* 0x9258-0x925F */
	0x86cb,0x8a95,0x935b,0x56e3,0x58c7,0x5f3e,0x65ad,0x6696, /* 0x9260-0x9267 */
	0x6a80,0x6bb5,0x7537,0x8ac7,0x5024,0x77e5,0x5730,0x5f1b, /* 0x9268-0x926F */
	0x6065,0x667a,0x6c60,0x75f4,0x7a1a,0x7f6e,0x81f4,0x8718, /* 0x9270-0x9277 */
	0x9045,0x99b3,0x7bc9,0x755c,0x7af9,0x7b51,0x84c4,0x0000, /* 0x9278-0x927F */
	/* codebase=0x9280 rawbase=0x0bc0 */
	0x9010,0x79e9,0x7a92,0x8336,0x5ae1,0x7740,0x4e2d,0x4ef2, /* 0x9280-0x9287 */
	0x5b99,0x5fe0,0x62bd,0x663c,0x67f1,0x6ce8,0x866b,0x8877, /* 0x9288-0x928F */
	0x8a3b,0x914e,0x92f3,0x99d0,0x6a17,0x7026,0x732a,0x82e7, /* 0x9290-0x9297 */
	0x8457,0x8caf,0x4e01,0x5146,0x51cb,0x558b,0x5bf5,0x5e16, /* 0x9298-0x929F */
	0x5e33,0x5e81,0x5f14,0x5f35,0x5f6b,0x5fb4,0x61f2,0x6311, /* 0x92A0-0x92A7 */
	0x66a2,0x671d,0x6f6e,0x7252,0x753a,0x773a,0x8074,0x8139, /* 0x92A8-0x92AF */
	0x8178,0x8776,0x8abf,0x8adc,0x8d85,0x8df3,0x929a,0x9577, /* 0x92B0-0x92B7 */
	0x9802,0x9ce5,0x52c5,0x6357,0x76f4,0x6715,0x6c88,0x73cd, /* 0x92B8-0x92BF */
	/* codebase=0x92c0 rawbase=0x0c00 */
	0x8cc3,0x93ae,0x9673,0x6d25,0x589c,0x690e,0x69cc,0x8ffd, /* 0x92C0-0x92C7 */
	0x939a,0x75db,0x901a,0x585a,0x6802,0x63b4,0x69fb,0x4f43, /* 0x92C8-0x92CF */
	0x6f2c,0x67d8,0x8fbb,0x8526,0x7db4,0x9354,0x693f,0x6f70, /* 0x92D0-0x92D7 */
	0x576a,0x58f7,0x5b2c,0x7d2c,0x722a,0x540a,0x91e3,0x9db4, /* 0x92D8-0x92DF */
	0x4ead,0x4f4e,0x505c,0x5075,0x5243,0x8c9e,0x5448,0x5824, /* 0x92E0-0x92E7 */
	0x5b9a,0x5e1d,0x5e95,0x5ead,0x5ef7,0x5f1f,0x608c,0x62b5, /* 0x92E8-0x92EF */
	0x633a,0x63d0,0x68af,0x6c40,0x7887,0x798e,0x7a0b,0x7de0, /* 0x92F0-0x92F7 */
	0x8247,0x8a02,0x8ae6,0x8e44,0x9013,0x0000,0x0000,0x0000, /* 0x92F8-0x92FF */
	/* codebase=0x9340 rawbase=0x0c40 */
	0x90b8,0x912d,0x91d8,0x9f0e,0x6ce5,0x6458,0x64e2,0x6575, /* 0x9340-0x9347 */
	0x6ef4,0x7684,0x7b1b,0x9069,0x93d1,0x6eba,0x54f2,0x5fb9, /* 0x9348-0x934F */
	0x64a4,0x8f4d,0x8fed,0x9244,0x5178,0x586b,0x5929,0x5c55, /* 0x9350-0x9357 */
	0x5e97,0x6dfb,0x7e8f,0x751c,0x8cbc,0x8ee2,0x985b,0x70b9, /* 0x9358-0x935F */
	0x4f1d,0x6bbf,0x6fb1,0x7530,0x96fb,0x514e,0x5410,0x5835, /* 0x9360-0x9367 */
	0x5857,0x59ac,0x5c60,0x5f92,0x6597,0x675c,0x6e21,0x767b, /* 0x9368-0x936F */
	0x83df,0x8ced,0x9014,0x90fd,0x934d,0x7825,0x783a,0x52aa, /* 0x9370-0x9377 */
	0x5ea6,0x571f,0x5974,0x6012,0x5012,0x515a,0x51ac,0x0000, /* 0x9378-0x937F */
	/* codebase=0x9380 rawbase=0x0c80 */
	0x51cd,0x5200,0x5510,0x5854,0x5858,0x5957,0x5b95,0x5cf6, /* 0x9380-0x9387 */
	0x5d8b,0x60bc,0x6295,0x642d,0x6771,0x6843,0x68bc,0x68df, /* 0x9388-0x938F */
	0x76d7,0x6dd8,0x6e6f,0x6d9b,0x706f,0x71c8,0x5f53,0x75d8, /* 0x9390-0x9397 */
	0x7977,0x7b49,0x7b54,0x7b52,0x7cd6,0x7d71,0x5230,0x8463, /* 0x9398-0x939F */
	0x8569,0x85e4,0x8a0e,0x8b04,0x8c46,0x8e0f,0x9003,0x900f, /* 0x93A0-0x93A7 */
	0x9419,0x9676,0x982d,0x9a30,0x95d8,0x50cd,0x52d5,0x540c, /* 0x93A8-0x93AF */
	0x5802,0x5c0e,0x61a7,0x649e,0x6d1e,0x77b3,0x7ae5,0x80f4, /* 0x93B0-0x93B7 */
	0x8404,0x9053,0x9285,0x5ce0,0x9d07,0x533f,0x5f97,0x5fb3, /* 0x93B8-0x93BF */
	/* codebase=0x93c0 rawbase=0x0cc0 */
	0x6d9c,0x7279,0x7763,0x79bf,0x7be4,0x6bd2,0x72ec,0x8aad, /* 0x93C0-0x93C7 */
	0x6803,0x6a61,0x51f8,0x7a81,0x6934,0x5c4a,0x9cf6,0x82eb, /* 0x93C8-0x93CF */
	0x5bc5,0x9149,0x701e,0x5678,0x5c6f,0x60c7,0x6566,0x6c8c, /* 0x93D0-0x93D7 */
	0x8c5a,0x9041,0x9813,0x5451,0x66c7,0x920d,0x5948,0x90a3, /* 0x93D8-0x93DF */
	0x5185,0x4e4d,0x51ea,0x8599,0x8b0e,0x7058,0x637a,0x934b, /* 0x93E0-0x93E7 */
	0x6962,0x99b4,0x7e04,0x7577,0x5357,0x6960,0x8edf,0x96e3, /* 0x93E8-0x93EF */
	0x6c5d,0x4e8c,0x5c3c,0x5f10,0x8fe9,0x5302,0x8cd1,0x8089, /* 0x93F0-0x93F7 */
	0x8679,0x5eff,0x65e5,0x4e73,0x5165,0x0000,0x0000,0x0000, /* 0x93F8-0x93FF */
	/* codebase=0x9440 rawbase=0x0d00 */
	0x5982,0x5c3f,0x97ee,0x4efb,0x598a,0x5fcd,0x8a8d,0x6fe1, /* 0x9440-0x9447 */
	0x79b0,0x7962,0x5be7,0x8471,0x732b,0x71b1,0x5e74,0x5ff5, /* 0x9448-0x944F */
	0x637b,0x649a,0x71c3,0x7c98,0x4e43,0x5efc,0x4e4b,0x57dc, /* 0x9450-0x9457 */
	0x56a2,0x60a9,0x6fc3,0x7d0d,0x80fd,0x8133,0x81bf,0x8fb2, /* 0x9458-0x945F */
	0x8997,0x86a4,0x5df4,0x628a,0x64ad,0x8987,0x6777,0x6ce2, /* 0x9460-0x9467 */
	0x6d3e,0x7436,0x7834,0x5a46,0x7f75,0x82ad,0x99ac,0x4ff3, /* 0x9468-0x946F */
	0x5ec3,0x62dd,0x6392,0x6557,0x676f,0x76c3,0x724c,0x80cc, /* 0x9470-0x9477 */
	0x80ba,0x8f29,0x914d,0x500d,0x57f9,0x5a92,0x6885,0x0000, /* 0x9478-0x947F */
	/* codebase=0x9480 rawbase=0x0d40 */
	0x6973,0x7164,0x72fd,0x8cb7,0x58f2,0x8ce0,0x966a,0x9019, /* 0x9480-0x9487 */
	0x877f,0x79e4,0x77e7,0x8429,0x4f2f,0x5265,0x535a,0x62cd, /* 0x9488-0x948F */
	0x67cf,0x6cca,0x767d,0x7b94,0x7c95,0x8236,0x8584,0x8feb, /* 0x9490-0x9497 */
	0x66dd,0x6f20,0x7206,0x7e1b,0x83ab,0x99c1,0x9ea6,0x51fd, /* 0x9498-0x949F */
	0x7bb1,0x7872,0x7bb8,0x8087,0x7b48,0x6ae8,0x5e61,0x808c, /* 0x94A0-0x94A7 */
	0x7551,0x7560,0x516b,0x9262,0x6e8c,0x767a,0x9197,0x9aea, /* 0x94A8-0x94AF */
	0x4f10,0x7f70,0x629c,0x7b4f,0x95a5,0x9ce9,0x567a,0x5859, /* 0x94B0-0x94B7 */
	0x86e4,0x96bc,0x4f34,0x5224,0x534a,0x53cd,0x53db,0x5e06, /* 0x94B8-0x94BF */
	/* codebase=0x94c0 rawbase=0x0d80 */
	0x642c,0x6591,0x677f,0x6c3e,0x6c4e,0x7248,0x72af,0x73ed, /* 0x94C0-0x94C7 */
	0x7554,0x7e41,0x822c,0x85e9,0x8ca9,0x7bc4,0x91c6,0x7169, /* 0x94C8-0x94CF */
	0x9812,0x98ef,0x633d,0x6669,0x756a,0x76e4,0x78d0,0x8543, /* 0x94D0-0x94D7 */
	0x86ee,0x532a,0x5351,0x5426,0x5983,0x5e87,0x5f7c,0x60b2, /* 0x94D8-0x94DF */
	0x6249,0x6279,0x62ab,0x6590,0x6bd4,0x6ccc,0x75b2,0x76ae, /* 0x94E0-0x94E7 */
	0x7891,0x79d8,0x7dcb,0x7f77,0x80a5,0x88ab,0x8ab9,0x8cbb, /* 0x94E8-0x94EF */
	0x907f,0x975e,0x98db,0x6a0b,0x7c38,0x5099,0x5c3e,0x5fae, /* 0x94F0-0x94F7 */
	0x6787,0x6bd8,0x7435,0x7709,0x7f8e,0x0000,0x0000,0x0000, /* 0x94F8-0x94FF */
	/* codebase=0x9540 rawbase=0x0dc0 */
	0x9f3b,0x67ca,0x7a17,0x5339,0x758b,0x9aed,0x5f66,0x819d, /* 0x9540-0x9547 */
	0x83f1,0x8098,0x5f3c,0x5fc5,0x7562,0x7b46,0x903c,0x6867, /* 0x9548-0x954F */
	0x59eb,0x5a9b,0x7d10,0x767e,0x8b2c,0x4ff5,0x5f6a,0x6a19, /* 0x9550-0x9557 */
	0x6c37,0x6f02,0x74e2,0x7968,0x8868,0x8a55,0x8c79,0x5edf, /* 0x9558-0x955F */
	0x63cf,0x75c5,0x79d2,0x82d7,0x9328,0x92f2,0x849c,0x86ed, /* 0x9560-0x9567 */
	0x9c2d,0x54c1,0x5f6c,0x658c,0x6d5c,0x7015,0x8ca7,0x8cd3, /* 0x9568-0x956F */
	0x983b,0x654f,0x74f6,0x4e0d,0x4ed8,0x57e0,0x592b,0x5a66, /* 0x9570-0x9577 */
	0x5bcc,0x51a8,0x5e03,0x5e9c,0x6016,0x6276,0x6577,0x0000, /* 0x9578-0x957F */
	/* codebase=0x9580 rawbase=0x0e00 */
	0x65a7,0x666e,0x6d6e,0x7236,0x7b26,0x8150,0x819a,0x8299, /* 0x9580-0x9587 */
	0x8b5c,0x8ca0,0x8ce6,0x8d74,0x961c,0x9644,0x4fae,0x64ab, /* 0x9588-0x958F */
	0x6b66,0x821e,0x8461,0x856a,0x90e8,0x5c01,0x6953,0x98a8, /* 0x9590-0x9597 */
	0x847a,0x8557,0x4f0f,0x526f,0x5fa9,0x5e45,0x670d,0x798f, /* 0x9598-0x959F */
	0x8179,0x8907,0x8986,0x6df5,0x5f17,0x6255,0x6cb8,0x4ecf, /* 0x95A0-0x95A7 */
	0x7269,0x9b92,0x5206,0x543b,0x5674,0x58b3,0x61a4,0x626e, /* 0x95A8-0x95AF */
	0x711a,0x596e,0x7c89,0x7cde,0x7d1b,0x96f0,0x6587,0x805e, /* 0x95B0-0x95B7 */
	0x4e19,0x4f75,0x5175,0x5840,0x5e63,0x5e73,0x5f0a,0x67c4, /* 0x95B8-0x95BF */
	/* codebase=0x95c0 rawbase=0x0e40 */
	0x4e26,0x853d,0x9589,0x965b,0x7c73,0x9801,0x50fb,0x58c1, /* 0x95C0-0x95C7 */
	0x7656,0x78a7,0x5225,0x77a5,0x8511,0x7b86,0x504f,0x5909, /* 0x95C8-0x95CF */
	0x7247,0x7bc7,0x7de8,0x8fba,0x8fd4,0x904d,0x4fbf,0x52c9, /* 0x95D0-0x95D7 */
	0x5a29,0x5f01,0x97ad,0x4fdd,0x8217,0x92ea,0x5703,0x6355, /* 0x95D8-0x95DF */
	0x6b69,0x752b,0x88dc,0x8f14,0x7a42,0x52df,0x5893,0x6155, /* 0x95E0-0x95E7 */
	0x620a,0x66ae,0x6bcd,0x7c3f,0x83e9,0x5023,0x4ff8,0x5305, /* 0x95E8-0x95EF */
	0x5446,0x5831,0x5949,0x5b9d,0x5cf0,0x5cef,0x5d29,0x5e96, /* 0x95F0-0x95F7 */
	0x62b1,0x6367,0x653e,0x65b9,0x670b,0x0000,0x0000,0x0000, /* 0x95F8-0x95FF */
	/* codebase=0x9640 rawbase=0x0e80 */
	0x6cd5,0x6ce1,0x70f9,0x7832,0x7e2b,0x80de,0x82b3,0x840c, /* 0x9640-0x9647 */
	0x84ec,0x8702,0x8912,0x8a2a,0x8c4a,0x90a6,0x92d2,0x98fd, /* 0x9648-0x964F */
	0x9cf3,0x9d6c,0x4e4f,0x4ea1,0x508d,0x5256,0x574a,0x59a8, /* 0x9650-0x9657 */
	0x5e3d,0x5fd8,0x5fd9,0x623f,0x66b4,0x671b,0x67d0,0x68d2, /* 0x9658-0x965F */
	0x5192,0x7d21,0x80aa,0x81a8,0x8b00,0x8c8c,0x8cbf,0x927e, /* 0x9660-0x9667 */
	0x9632,0x5420,0x982c,0x5317,0x50d5,0x535c,0x58a8,0x64b2, /* 0x9668-0x966F */
	0x6734,0x7267,0x7766,0x7a46,0x91e6,0x52c3,0x6ca1,0x6b86, /* 0x9670-0x9677 */
	0x5800,0x5e4c,0x5954,0x672c,0x7ffb,0x51e1,0x76c6,0x0000, /* 0x9678-0x967F */
	/* codebase=0x9680 rawbase=0x0ec0 */
	0x6469,0x78e8,0x9b54,0x9ebb,0x57cb,0x59b9,0x6627,0x679a, /* 0x9680-0x9687 */
	0x6bce,0x54e9,0x69d9,0x5e55,0x819c,0x6795,0x9baa,0x67fe, /* 0x9688-0x968F */
	0x9c52,0x685d,0x4ea6,0x4fe3,0x53c8,0x62b9,0x672b,0x6cab, /* 0x9690-0x9697 */
	0x8fc4,0x4fad,0x7e6d,0x9ebf,0x4e07,0x6162,0x6e80,0x6f2b, /* 0x9698-0x969F */
	0x8513,0x5473,0x672a,0x9b45,0x5df3,0x7b95,0x5cac,0x5bc6, /* 0x96A0-0x96A7 */
	0x871c,0x6e4a,0x84d1,0x7a14,0x8108,0x5999,0x7c8d,0x6c11, /* 0x96A8-0x96AF */
	0x7720,0x52d9,0x5922,0x7121,0x725f,0x77db,0x9727,0x9d61, /* 0x96B0-0x96B7 */
	0x690b,0x5a7f,0x5a18,0x51a5,0x540d,0x547d,0x660e,0x76df, /* 0x96B8-0x96BF */
	/* codebase=0x96c0 rawbase=0x0f00 */
	0x8ff7,0x9298,0x9cf4,0x59ea,0x725d,0x6ec5,0x514d,0x68c9, /* 0x96C0-0x96C7 */
	0x7dbf,0x7dec,0x9762,0x9eba,0x6478,0x6a21,0x8302,0x5984, /* 0x96C8-0x96CF */
	0x5b5f,0x6bdb,0x731b,0x76f2,0x7db2,0x8017,0x8499,0x5132, /* 0x96D0-0x96D7 */
	0x6728,0x9ed9,0x76ee,0x6762,0x52ff,0x9905,0x5c24,0x623b, /* 0x96D8-0x96DF */
	0x7c7e,0x8cb0,0x554f,0x60b6,0x7d0b,0x9580,0x5301,0x4e5f, /* 0x96E0-0x96E7 */
	0x51b6,0x591c,0x723a,0x8036,0x91ce,0x5f25,0x77e2,0x5384, /* 0x96E8-0x96EF */
	0x5f79,0x7d04,0x85ac,0x8a33,0x8e8d,0x9756,0x67f3,0x85ae, /* 0x96F0-0x96F7 */
	0x9453,0x6109,0x6108,0x6cb9,0x7652,0x0000,0x0000,0x0000, /* 0x96F8-0x96FF */
	/* codebase=0x9740 rawbase=0x0f40 */
	0x8aed,0x8f38,0x552f,0x4f51,0x512a,0x52c7,0x53cb,0x5ba5, /* 0x9740-0x9747 */
	0x5e7d,0x60a0,0x6182,0x63d6,0x6709,0x67da,0x6e67,0x6d8c, /* 0x9748-0x974F */
	0x7336,0x7337,0x7531,0x7950,0x88d5,0x8a98,0x904a,0x9091, /* 0x9750-0x9757 */
	0x90f5,0x96c4,0x878d,0x5915,0x4e88,0x4f59,0x4e0e,0x8a89, /* 0x9758-0x975F */
	0x8f3f,0x9810,0x50ad,0x5e7c,0x5996,0x5bb9,0x5eb8,0x63da, /* 0x9760-0x9767 */
	0x63fa,0x64c1,0x66dc,0x694a,0x69d8,0x6d0b,0x6eb6,0x7194, /* 0x9768-0x976F */
	0x7528,0x7aaf,0x7f8a,0x8000,0x8449,0x84c9,0x8981,0x8b21, /* 0x9770-0x9777 */
	0x8e0a,0x9065,0x967d,0x990a,0x617e,0x6291,0x6b32,0x0000, /* 0x9778-0x977F */
	/* codebase=0x9780 rawbase=0x0f80 */
	0x6c83,0x6d74,0x7fcc,0x7ffc,0x6dc0,0x7f85,0x87ba,0x88f8, /* 0x9780-0x9787 */
	0x6765,0x83b1,0x983c,0x96f7,0x6d1b,0x7d61,0x843d,0x916a, /* 0x9788-0x978F */
	0x4e71,0x5375,0x5d50,0x6b04,0x6feb,0x85cd,0x862d,0x89a7, /* 0x9790-0x9797 */
	0x5229,0x540f,0x5c65,0x674e,0x68a8,0x7406,0x7483,0x75e2, /* 0x9798-0x979F */
	0x88cf,0x88e1,0x91cc,0x96e2,0x9678,0x5f8b,0x7387,0x7acb, /* 0x97A0-0x97A7 */
	0x844e,0x63a0,0x7565,0x5289,0x6d41,0x6e9c,0x7409,0x7559, /* 0x97A8-0x97AF */
	0x786b,0x7c92,0x9686,0x7adc,0x9f8d,0x4fb6,0x616e,0x65c5, /* 0x97B0-0x97B7 */
	0x865c,0x4e86,0x4eae,0x50da,0x4e21,0x51cc,0x5bee,0x6599, /* 0x97B8-0x97BF */
	/* codebase=0x97c0 rawbase=0x0fc0 */
	0x6881,0x6dbc,0x731f,0x7642,0x77ad,0x7a1c,0x7ce7,0x826f, /* 0x97C0-0x97C7 */
	0x8ad2,0x907c,0x91cf,0x9675,0x9818,0x529b,0x7dd1,0x502b, /* 0x97C8-0x97CF */
	0x5398,0x6797,0x6dcb,0x71d0,0x7433,0x81e8,0x8f2a,0x96a3, /* 0x97D0-0x97D7 */
	0x9c57,0x9e9f,0x7460,0x5841,0x6d99,0x7d2f,0x985e,0x4ee4, /* 0x97D8-0x97DF */
	0x4f36,0x4f8b,0x51b7,0x52b1,0x5dba,0x601c,0x73b2,0x793c, /* 0x97E0-0x97E7 */
	0x82d3,0x9234,0x96b7,0x96f6,0x970a,0x9e97,0x9f62,0x66a6, /* 0x97E8-0x97EF */
	0x6b74,0x5217,0x52a3,0x70c8,0x88c2,0x5ec9,0x604b,0x6190, /* 0x97F0-0x97F7 */
	0x6f23,0x7149,0x7c3e,0x7df4,0x806f,0x0000,0x0000,0x0000, /* 0x97F8-0x97FF */
	/* codebase=0x9840 rawbase=0x1000 */
	0x84ee,0x9023,0x932c,0x5442,0x9b6f,0x6ad3,0x7089,0x8cc2, /* 0x9840-0x9847 */
	0x8def,0x9732,0x52b4,0x5a41,0x5eca,0x5f04,0x6717,0x697c, /* 0x9848-0x984F */
	0x6994,0x6d6a,0x6f0f,0x7262,0x72fc,0x7bed,0x8001,0x807e, /* 0x9850-0x9857 */
	0x874b,0x90ce,0x516d,0x9e93,0x7984,0x808b,0x9332,0x8ad6, /* 0x9858-0x985F */
	0x502d,0x548c,0x8a71,0x6b6a,0x8cc4,0x8107,0x60d1,0x67a0, /* 0x9860-0x9867 */
	0x9df2,0x4e99,0x4e98,0x9c10,0x8a6b,0x85c1,0x8568,0x6900, /* 0x9868-0x986F */
	0x6e7e,0x7897,0x8155,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9870-0x9877 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9878-0x987F */
	/* codebase=0x9880 rawbase=0x1040 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9880-0x9887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9888-0x988F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9890-0x9897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x5f0c, /* 0x9898-0x989F */
	0x4e10,0x4e15,0x4e2a,0x4e31,0x4e36,0x4e3c,0x4e3f,0x4e42, /* 0x98A0-0x98A7 */
	0x4e56,0x4e58,0x4e82,0x4e85,0x8c6b,0x4e8a,0x8212,0x5f0d, /* 0x98A8-0x98AF */
	0x4e8e,0x4e9e,0x4e9f,0x4ea0,0x4ea2,0x4eb0,0x4eb3,0x4eb6, /* 0x98B0-0x98B7 */
	0x4ece,0x4ecd,0x4ec4,0x4ec6,0x4ec2,0x4ed7,0x4ede,0x4eed, /* 0x98B8-0x98BF */
	/* codebase=0x98c0 rawbase=0x1080 */
	0x4edf,0x4ef7,0x4f09,0x4f5a,0x4f30,0x4f5b,0x4f5d,0x4f57, /* 0x98C0-0x98C7 */
	0x4f47,0x4f76,0x4f88,0x4f8f,0x4f98,0x4f7b,0x4f69,0x4f70, /* 0x98C8-0x98CF */
	0x4f91,0x4f6f,0x4f86,0x4f96,0x5118,0x4fd4,0x4fdf,0x4fce, /* 0x98D0-0x98D7 */
	0x4fd8,0x4fdb,0x4fd1,0x4fda,0x4fd0,0x4fe4,0x4fe5,0x501a, /* 0x98D8-0x98DF */
	0x5028,0x5014,0x502a,0x5025,0x5005,0x4f1c,0x4ff6,0x5021, /* 0x98E0-0x98E7 */
	0x5029,0x502c,0x4ffe,0x4fef,0x5011,0x5006,0x5043,0x5047, /* 0x98E8-0x98EF */
	0x6703,0x5055,0x5050,0x5048,0x505a,0x5056,0x506c,0x5078, /* 0x98F0-0x98F7 */
	0x5080,0x509a,0x5085,0x50b4,0x50b2,0x0000,0x0000,0x0000, /* 0x98F8-0x98FF */
	/* codebase=0x9940 rawbase=0x10c0 */
	0x50c9,0x50ca,0x50b3,0x50c2,0x50d6,0x50de,0x50e5,0x50ed, /* 0x9940-0x9947 */
	0x50e3,0x50ee,0x50f9,0x50f5,0x5109,0x5101,0x5102,0x5116, /* 0x9948-0x994F */
	0x5115,0x5114,0x511a,0x5121,0x513a,0x5137,0x513c,0x513b, /* 0x9950-0x9957 */
	0x513f,0x5140,0x5152,0x514c,0x5154,0x5162,0x7af8,0x5169, /* 0x9958-0x995F */
	0x516a,0x516e,0x5180,0x5182,0x56d8,0x518c,0x5189,0x518f, /* 0x9960-0x9967 */
	0x5191,0x5193,0x5195,0x5196,0x51a4,0x51a6,0x51a2,0x51a9, /* 0x9968-0x996F */
	0x51aa,0x51ab,0x51b3,0x51b1,0x51b2,0x51b0,0x51b5,0x51bd, /* 0x9970-0x9977 */
	0x51c5,0x51c9,0x51db,0x51e0,0x8655,0x51e9,0x51ed,0x0000, /* 0x9978-0x997F */
	/* codebase=0x9980 rawbase=0x1100 */
	0x51f0,0x51f5,0x51fe,0x5204,0x520b,0x5214,0x520e,0x5227, /* 0x9980-0x9987 */
	0x522a,0x522e,0x5233,0x5239,0x524f,0x5244,0x524b,0x524c, /* 0x9988-0x998F */
	0x525e,0x5254,0x526a,0x5274,0x5269,0x5273,0x527f,0x527d, /* 0x9990-0x9997 */
	0x528d,0x5294,0x5292,0x5271,0x5288,0x5291,0x8fa8,0x8fa7, /* 0x9998-0x999F */
	0x52ac,0x52ad,0x52bc,0x52b5,0x52c1,0x52cd,0x52d7,0x52de, /* 0x99A0-0x99A7 */
	0x52e3,0x52e6,0x98ed,0x52e0,0x52f3,0x52f5,0x52f8,0x52f9, /* 0x99A8-0x99AF */
	0x5306,0x5308,0x7538,0x530d,0x5310,0x530f,0x5315,0x531a, /* 0x99B0-0x99B7 */
	0x5323,0x532f,0x5331,0x5333,0x5338,0x5340,0x5346,0x5345, /* 0x99B8-0x99BF */
	/* codebase=0x99c0 rawbase=0x1140 */
	0x4e17,0x5349,0x534d,0x51d6,0x535e,0x5369,0x536e,0x5918, /* 0x99C0-0x99C7 */
	0x537b,0x5377,0x5382,0x5396,0x53a0,0x53a6,0x53a5,0x53ae, /* 0x99C8-0x99CF */
	0x53b0,0x53b6,0x53c3,0x7c12,0x96d9,0x53df,0x66fc,0x71ee, /* 0x99D0-0x99D7 */
	0x53ee,0x53e8,0x53ed,0x53fa,0x5401,0x543d,0x5440,0x542c, /* 0x99D8-0x99DF */
	0x542d,0x543c,0x542e,0x5436,0x5429,0x541d,0x544e,0x548f, /* 0x99E0-0x99E7 */
	0x5475,0x548e,0x545f,0x5471,0x5477,0x5470,0x5492,0x547b, /* 0x99E8-0x99EF */
	0x5480,0x5476,0x5484,0x5490,0x5486,0x54c7,0x54a2,0x54b8, /* 0x99F0-0x99F7 */
	0x54a5,0x54ac,0x54c4,0x54c8,0x54a8,0x0000,0x0000,0x0000, /* 0x99F8-0x99FF */
	/* codebase=0x9a40 rawbase=0x1180 */
	0x54ab,0x54c2,0x54a4,0x54be,0x54bc,0x54d8,0x54e5,0x54e6, /* 0x9A40-0x9A47 */
	0x550f,0x5514,0x54fd,0x54ee,0x54ed,0x54fa,0x54e2,0x5539, /* 0x9A48-0x9A4F */
	0x5540,0x5563,0x554c,0x552e,0x555c,0x5545,0x5556,0x5557, /* 0x9A50-0x9A57 */
	0x5538,0x5533,0x555d,0x5599,0x5580,0x54af,0x558a,0x559f, /* 0x9A58-0x9A5F */
	0x557b,0x557e,0x5598,0x559e,0x55ae,0x557c,0x5583,0x55a9, /* 0x9A60-0x9A67 */
	0x5587,0x55a8,0x55da,0x55c5,0x55df,0x55c4,0x55dc,0x55e4, /* 0x9A68-0x9A6F */
	0x55d4,0x5614,0x55f7,0x5616,0x55fe,0x55fd,0x561b,0x55f9, /* 0x9A70-0x9A77 */
	0x564e,0x5650,0x71df,0x5634,0x5636,0x5632,0x5638,0x0000, /* 0x9A78-0x9A7F */
	/* codebase=0x9a80 rawbase=0x11c0 */
	0x566b,0x5664,0x562f,0x566c,0x566a,0x5686,0x5680,0x568a, /* 0x9A80-0x9A87 */
	0x56a0,0x5694,0x568f,0x56a5,0x56ae,0x56b6,0x56b4,0x56c2, /* 0x9A88-0x9A8F */
	0x56bc,0x56c1,0x56c3,0x56c0,0x56c8,0x56ce,0x56d1,0x56d3, /* 0x9A90-0x9A97 */
	0x56d7,0x56ee,0x56f9,0x5700,0x56ff,0x5704,0x5709,0x5708, /* 0x9A98-0x9A9F */
	0x570b,0x570d,0x5713,0x5718,0x5716,0x55c7,0x571c,0x5726, /* 0x9AA0-0x9AA7 */
	0x5737,0x5738,0x574e,0x573b,0x5740,0x574f,0x5769,0x57c0, /* 0x9AA8-0x9AAF */
	0x5788,0x5761,0x577f,0x5789,0x5793,0x57a0,0x57b3,0x57a4, /* 0x9AB0-0x9AB7 */
	0x57aa,0x57b0,0x57c3,0x57c6,0x57d4,0x57d2,0x57d3,0x580a, /* 0x9AB8-0x9ABF */
	/* codebase=0x9ac0 rawbase=0x1200 */
	0x57d6,0x57e3,0x580b,0x5819,0x581d,0x5872,0x5821,0x5862, /* 0x9AC0-0x9AC7 */
	0x584b,0x5870,0x6bc0,0x5852,0x583d,0x5879,0x5885,0x58b9, /* 0x9AC8-0x9ACF */
	0x589f,0x58ab,0x58ba,0x58de,0x58bb,0x58b8,0x58ae,0x58c5, /* 0x9AD0-0x9AD7 */
	0x58d3,0x58d1,0x58d7,0x58d9,0x58d8,0x58e5,0x58dc,0x58e4, /* 0x9AD8-0x9ADF */
	0x58df,0x58ef,0x58fa,0x58f9,0x58fb,0x58fc,0x58fd,0x5902, /* 0x9AE0-0x9AE7 */
	0x590a,0x5910,0x591b,0x68a6,0x5925,0x592c,0x592d,0x5932, /* 0x9AE8-0x9AEF */
	0x5938,0x593e,0x7ad2,0x5955,0x5950,0x594e,0x595a,0x5958, /* 0x9AF0-0x9AF7 */
	0x5962,0x5960,0x5967,0x596c,0x5969,0x0000,0x0000,0x0000, /* 0x9AF8-0x9AFF */
	/* codebase=0x9b40 rawbase=0x1240 */
	0x5978,0x5981,0x599d,0x4f5e,0x4fab,0x59a3,0x59b2,0x59c6, /* 0x9B40-0x9B47 */
	0x59e8,0x59dc,0x598d,0x59d9,0x59da,0x5a25,0x5a1f,0x5a11, /* 0x9B48-0x9B4F */
	0x5a1c,0x5a09,0x5a1a,0x5a40,0x5a6c,0x5a49,0x5a35,0x5a36, /* 0x9B50-0x9B57 */
	0x5a62,0x5a6a,0x5a9a,0x5abc,0x5abe,0x5acb,0x5ac2,0x5abd, /* 0x9B58-0x9B5F */
	0x5ae3,0x5ad7,0x5ae6,0x5ae9,0x5ad6,0x5afa,0x5afb,0x5b0c, /* 0x9B60-0x9B67 */
	0x5b0b,0x5b16,0x5b32,0x5ad0,0x5b2a,0x5b36,0x5b3e,0x5b43, /* 0x9B68-0x9B6F */
	0x5b45,0x5b40,0x5b51,0x5b55,0x5b5a,0x5b5b,0x5b65,0x5b69, /* 0x9B70-0x9B77 */
	0x5b70,0x5b73,0x5b75,0x5b78,0x6588,0x5b7a,0x5b80,0x0000, /* 0x9B78-0x9B7F */
	/* codebase=0x9b80 rawbase=0x1280 */
	0x5b83,0x5ba6,0x5bb8,0x5bc3,0x5bc7,0x5bc9,0x5bd4,0x5bd0, /* 0x9B80-0x9B87 */
	0x5be4,0x5be6,0x5be2,0x5bde,0x5be5,0x5beb,0x5bf0,0x5bf6, /* 0x9B88-0x9B8F */
	0x5bf3,0x5c05,0x5c07,0x5c08,0x5c0d,0x5c13,0x5c20,0x5c22, /* 0x9B90-0x9B97 */
	0x5c28,0x5c38,0x5c39,0x5c41,0x5c46,0x5c4e,0x5c53,0x5c50, /* 0x9B98-0x9B9F */
	0x5c4f,0x5b71,0x5c6c,0x5c6e,0x4e62,0x5c76,0x5c79,0x5c8c, /* 0x9BA0-0x9BA7 */
	0x5c91,0x5c94,0x599b,0x5cab,0x5cbb,0x5cb6,0x5cbc,0x5cb7, /* 0x9BA8-0x9BAF */
	0x5cc5,0x5cbe,0x5cc7,0x5cd9,0x5ce9,0x5cfd,0x5cfa,0x5ced, /* 0x9BB0-0x9BB7 */
	0x5d8c,0x5cea,0x5d0b,0x5d15,0x5d17,0x5d5c,0x5d1f,0x5d1b, /* 0x9BB8-0x9BBF */
	/* codebase=0x9bc0 rawbase=0x12c0 */
	0x5d11,0x5d14,0x5d22,0x5d1a,0x5d19,0x5d18,0x5d4c,0x5d52, /* 0x9BC0-0x9BC7 */
	0x5d4e,0x5d4b,0x5d6c,0x5d73,0x5d76,0x5d87,0x5d84,0x5d82, /* 0x9BC8-0x9BCF */
	0x5da2,0x5d9d,0x5dac,0x5dae,0x5dbd,0x5d90,0x5db7,0x5dbc, /* 0x9BD0-0x9BD7 */
	0x5dc9,0x5dcd,0x5dd3,0x5dd2,0x5dd6,0x5ddb,0x5deb,0x5df2, /* 0x9BD8-0x9BDF */
	0x5df5,0x5e0b,0x5e1a,0x5e19,0x5e11,0x5e1b,0x5e36,0x5e37, /* 0x9BE0-0x9BE7 */
	0x5e44,0x5e43,0x5e40,0x5e4e,0x5e57,0x5e54,0x5e5f,0x5e62, /* 0x9BE8-0x9BEF */
	0x5e64,0x5e47,0x5e75,0x5e76,0x5e7a,0x9ebc,0x5e7f,0x5ea0, /* 0x9BF0-0x9BF7 */
	0x5ec1,0x5ec2,0x5ec8,0x5ed0,0x5ecf,0x0000,0x0000,0x0000, /* 0x9BF8-0x9BFF */
	/* codebase=0x9c40 rawbase=0x1300 */
	0x5ed6,0x5ee3,0x5edd,0x5eda,0x5edb,0x5ee2,0x5ee1,0x5ee8, /* 0x9C40-0x9C47 */
	0x5ee9,0x5eec,0x5ef1,0x5ef3,0x5ef0,0x5ef4,0x5ef8,0x5efe, /* 0x9C48-0x9C4F */
	0x5f03,0x5f09,0x5f5d,0x5f5c,0x5f0b,0x5f11,0x5f16,0x5f29, /* 0x9C50-0x9C57 */
	0x5f2d,0x5f38,0x5f41,0x5f48,0x5f4c,0x5f4e,0x5f2f,0x5f51, /* 0x9C58-0x9C5F */
	0x5f56,0x5f57,0x5f59,0x5f61,0x5f6d,0x5f73,0x5f77,0x5f83, /* 0x9C60-0x9C67 */
	0x5f82,0x5f7f,0x5f8a,0x5f88,0x5f91,0x5f87,0x5f9e,0x5f99, /* 0x9C68-0x9C6F */
	0x5f98,0x5fa0,0x5fa8,0x5fad,0x5fbc,0x5fd6,0x5ffb,0x5fe4, /* 0x9C70-0x9C77 */
	0x5ff8,0x5ff1,0x5fdd,0x60b3,0x5fff,0x6021,0x6060,0x0000, /* 0x9C78-0x9C7F */
	/* codebase=0x9c80 rawbase=0x1340 */
	0x6019,0x6010,0x6029,0x600e,0x6031,0x601b,0x6015,0x602b, /* 0x9C80-0x9C87 */
	0x6026,0x600f,0x603a,0x605a,0x6041,0x606a,0x6077,0x605f, /* 0x9C88-0x9C8F */
	0x604a,0x6046,0x604d,0x6063,0x6043,0x6064,0x6042,0x606c, /* 0x9C90-0x9C97 */
	0x606b,0x6059,0x6081,0x608d,0x60e7,0x6083,0x609a,0x6084, /* 0x9C98-0x9C9F */
	0x609b,0x6096,0x6097,0x6092,0x60a7,0x608b,0x60e1,0x60b8, /* 0x9CA0-0x9CA7 */
	0x60e0,0x60d3,0x60b4,0x5ff0,0x60bd,0x60c6,0x60b5,0x60d8, /* 0x9CA8-0x9CAF */
	0x614d,0x6115,0x6106,0x60f6,0x60f7,0x6100,0x60f4,0x60fa, /* 0x9CB0-0x9CB7 */
	0x6103,0x6121,0x60fb,0x60f1,0x610d,0x610e,0x6147,0x613e, /* 0x9CB8-0x9CBF */
	/* codebase=0x9cc0 rawbase=0x1380 */
	0x6128,0x6127,0x614a,0x613f,0x613c,0x612c,0x6134,0x613d, /* 0x9CC0-0x9CC7 */
	0x6142,0x6144,0x6173,0x6177,0x6158,0x6159,0x615a,0x616b, /* 0x9CC8-0x9CCF */
	0x6174,0x616f,0x6165,0x6171,0x615f,0x615d,0x6153,0x6175, /* 0x9CD0-0x9CD7 */
	0x6199,0x6196,0x6187,0x61ac,0x6194,0x619a,0x618a,0x6191, /* 0x9CD8-0x9CDF */
	0x61ab,0x61ae,0x61cc,0x61ca,0x61c9,0x61f7,0x61c8,0x61c3, /* 0x9CE0-0x9CE7 */
	0x61c6,0x61ba,0x61cb,0x7f79,0x61cd,0x61e6,0x61e3,0x61f6, /* 0x9CE8-0x9CEF */
	0x61fa,0x61f4,0x61ff,0x61fd,0x61fc,0x61fe,0x6200,0x6208, /* 0x9CF0-0x9CF7 */
	0x6209,0x620d,0x620c,0x6214,0x621b,0x0000,0x0000,0x0000, /* 0x9CF8-0x9CFF */
	/* codebase=0x9d40 rawbase=0x13c0 */
	0x621e,0x6221,0x622a,0x622e,0x6230,0x6232,0x6233,0x6241, /* 0x9D40-0x9D47 */
	0x624e,0x625e,0x6263,0x625b,0x6260,0x6268,0x627c,0x6282, /* 0x9D48-0x9D4F */
	0x6289,0x627e,0x6292,0x6293,0x6296,0x62d4,0x6283,0x6294, /* 0x9D50-0x9D57 */
	0x62d7,0x62d1,0x62bb,0x62cf,0x62ff,0x62c6,0x64d4,0x62c8, /* 0x9D58-0x9D5F */
	0x62dc,0x62cc,0x62ca,0x62c2,0x62c7,0x629b,0x62c9,0x630c, /* 0x9D60-0x9D67 */
	0x62ee,0x62f1,0x6327,0x6302,0x6308,0x62ef,0x62f5,0x6350, /* 0x9D68-0x9D6F */
	0x633e,0x634d,0x641c,0x634f,0x6396,0x638e,0x6380,0x63ab, /* 0x9D70-0x9D77 */
	0x6376,0x63a3,0x638f,0x6389,0x639f,0x63b5,0x636b,0x0000, /* 0x9D78-0x9D7F */
	/* codebase=0x9d80 rawbase=0x1400 */
	0x6369,0x63be,0x63e9,0x63c0,0x63c6,0x63e3,0x63c9,0x63d2, /* 0x9D80-0x9D87 */
	0x63f6,0x63c4,0x6416,0x6434,0x6406,0x6413,0x6426,0x6436, /* 0x9D88-0x9D8F */
	0x651d,0x6417,0x6428,0x640f,0x6467,0x646f,0x6476,0x644e, /* 0x9D90-0x9D97 */
	0x652a,0x6495,0x6493,0x64a5,0x64a9,0x6488,0x64bc,0x64da, /* 0x9D98-0x9D9F */
	0x64d2,0x64c5,0x64c7,0x64bb,0x64d8,0x64c2,0x64f1,0x64e7, /* 0x9DA0-0x9DA7 */
	0x8209,0x64e0,0x64e1,0x62ac,0x64e3,0x64ef,0x652c,0x64f6, /* 0x9DA8-0x9DAF */
	0x64f4,0x64f2,0x64fa,0x6500,0x64fd,0x6518,0x651c,0x6505, /* 0x9DB0-0x9DB7 */
	0x6524,0x6523,0x652b,0x6534,0x6535,0x6537,0x6536,0x6538, /* 0x9DB8-0x9DBF */
	/* codebase=0x9dc0 rawbase=0x1440 */
	0x754b,0x6548,0x6556,0x6555,0x654d,0x6558,0x655e,0x655d, /* 0x9DC0-0x9DC7 */
	0x6572,0x6578,0x6582,0x6583,0x8b8a,0x659b,0x659f,0x65ab, /* 0x9DC8-0x9DCF */
	0x65b7,0x65c3,0x65c6,0x65c1,0x65c4,0x65cc,0x65d2,0x65db, /* 0x9DD0-0x9DD7 */
	0x65d9,0x65e0,0x65e1,0x65f1,0x6772,0x660a,0x6603,0x65fb, /* 0x9DD8-0x9DDF */
	0x6773,0x6635,0x6636,0x6634,0x661c,0x664f,0x6644,0x6649, /* 0x9DE0-0x9DE7 */
	0x6641,0x665e,0x665d,0x6664,0x6667,0x6668,0x665f,0x6662, /* 0x9DE8-0x9DEF */
	0x6670,0x6683,0x6688,0x668e,0x6689,0x6684,0x6698,0x669d, /* 0x9DF0-0x9DF7 */
	0x66c1,0x66b9,0x66c9,0x66be,0x66bc,0x0000,0x0000,0x0000, /* 0x9DF8-0x9DFF */
	/* codebase=0x9e40 rawbase=0x1480 */
	0x66c4,0x66b8,0x66d6,0x66da,0x66e0,0x663f,0x66e6,0x66e9, /* 0x9E40-0x9E47 */
	0x66f0,0x66f5,0x66f7,0x670f,0x6716,0x671e,0x6726,0x6727, /* 0x9E48-0x9E4F */
	0x9738,0x672e,0x673f,0x6736,0x6741,0x6738,0x6737,0x6746, /* 0x9E50-0x9E57 */
	0x675e,0x6760,0x6759,0x6763,0x6764,0x6789,0x6770,0x67a9, /* 0x9E58-0x9E5F */
	0x677c,0x676a,0x678c,0x678b,0x67a6,0x67a1,0x6785,0x67b7, /* 0x9E60-0x9E67 */
	0x67ef,0x67b4,0x67ec,0x67b3,0x67e9,0x67b8,0x67e4,0x67de, /* 0x9E68-0x9E6F */
	0x67dd,0x67e2,0x67ee,0x67b9,0x67ce,0x67c6,0x67e7,0x6a9c, /* 0x9E70-0x9E77 */
	0x681e,0x6846,0x6829,0x6840,0x684d,0x6832,0x684e,0x0000, /* 0x9E78-0x9E7F */
	/* codebase=0x9e80 rawbase=0x14c0 */
	0x68b3,0x682b,0x6859,0x6863,0x6877,0x687f,0x689f,0x688f, /* 0x9E80-0x9E87 */
	0x68ad,0x6894,0x689d,0x689b,0x6883,0x6aae,0x68b9,0x6874, /* 0x9E88-0x9E8F */
	0x68b5,0x68a0,0x68ba,0x690f,0x688d,0x687e,0x6901,0x68ca, /* 0x9E90-0x9E97 */
	0x6908,0x68d8,0x6922,0x6926,0x68e1,0x690c,0x68cd,0x68d4, /* 0x9E98-0x9E9F */
	0x68e7,0x68d5,0x6936,0x6912,0x6904,0x68d7,0x68e3,0x6925, /* 0x9EA0-0x9EA7 */
	0x68f9,0x68e0,0x68ef,0x6928,0x692a,0x691a,0x6923,0x6921, /* 0x9EA8-0x9EAF */
	0x68c6,0x6979,0x6977,0x695c,0x6978,0x696b,0x6954,0x697e, /* 0x9EB0-0x9EB7 */
	0x696e,0x6939,0x6974,0x693d,0x6959,0x6930,0x6961,0x695e, /* 0x9EB8-0x9EBF */
	/* codebase=0x9ec0 rawbase=0x1500 */
	0x695d,0x6981,0x696a,0x69b2,0x69ae,0x69d0,0x69bf,0x69c1, /* 0x9EC0-0x9EC7 */
	0x69d3,0x69be,0x69ce,0x5be8,0x69ca,0x69dd,0x69bb,0x69c3, /* 0x9EC8-0x9ECF */
	0x69a7,0x6a2e,0x6991,0x69a0,0x699c,0x6995,0x69b4,0x69de, /* 0x9ED0-0x9ED7 */
	0x69e8,0x6a02,0x6a1b,0x69ff,0x6b0a,0x69f9,0x69f2,0x69e7, /* 0x9ED8-0x9EDF */
	0x6a05,0x69b1,0x6a1e,0x69ed,0x6a14,0x69eb,0x6a0a,0x6a12, /* 0x9EE0-0x9EE7 */
	0x6ac1,0x6a23,0x6a13,0x6a44,0x6a0c,0x6a72,0x6a36,0x6a78, /* 0x9EE8-0x9EEF */
	0x6a47,0x6a62,0x6a59,0x6a66,0x6a48,0x6a38,0x6a22,0x6a90, /* 0x9EF0-0x9EF7 */
	0x6a8d,0x6aa0,0x6a84,0x6aa2,0x6aa3,0x0000,0x0000,0x0000, /* 0x9EF8-0x9EFF */
	/* codebase=0x9f40 rawbase=0x1540 */
	0x6a97,0x8617,0x6abb,0x6ac3,0x6ac2,0x6ab8,0x6ab3,0x6aac, /* 0x9F40-0x9F47 */
	0x6ade,0x6ad1,0x6adf,0x6aaa,0x6ada,0x6aea,0x6afb,0x6b05, /* 0x9F48-0x9F4F */
	0x8616,0x6afa,0x6b12,0x6b16,0x9b31,0x6b1f,0x6b38,0x6b37, /* 0x9F50-0x9F57 */
	0x76dc,0x6b39,0x98ee,0x6b47,0x6b43,0x6b49,0x6b50,0x6b59, /* 0x9F58-0x9F5F */
	0x6b54,0x6b5b,0x6b5f,0x6b61,0x6b78,0x6b79,0x6b7f,0x6b80, /* 0x9F60-0x9F67 */
	0x6b84,0x6b83,0x6b8d,0x6b98,0x6b95,0x6b9e,0x6ba4,0x6baa, /* 0x9F68-0x9F6F */
	0x6bab,0x6baf,0x6bb2,0x6bb1,0x6bb3,0x6bb7,0x6bbc,0x6bc6, /* 0x9F70-0x9F77 */
	0x6bcb,0x6bd3,0x6bdf,0x6bec,0x6beb,0x6bf3,0x6bef,0x0000, /* 0x9F78-0x9F7F */
	/* codebase=0x9f80 rawbase=0x1580 */
	0x9ebe,0x6c08,0x6c13,0x6c14,0x6c1b,0x6c24,0x6c23,0x6c5e, /* 0x9F80-0x9F87 */
	0x6c55,0x6c62,0x6c6a,0x6c82,0x6c8d,0x6c9a,0x6c81,0x6c9b, /* 0x9F88-0x9F8F */
	0x6c7e,0x6c68,0x6c73,0x6c92,0x6c90,0x6cc4,0x6cf1,0x6cd3, /* 0x9F90-0x9F97 */
	0x6cbd,0x6cd7,0x6cc5,0x6cdd,0x6cae,0x6cb1,0x6cbe,0x6cba, /* 0x9F98-0x9F9F */
	0x6cdb,0x6cef,0x6cd9,0x6cea,0x6d1f,0x884d,0x6d36,0x6d2b, /* 0x9FA0-0x9FA7 */
	0x6d3d,0x6d38,0x6d19,0x6d35,0x6d33,0x6d12,0x6d0c,0x6d63, /* 0x9FA8-0x9FAF */
	0x6d93,0x6d64,0x6d5a,0x6d79,0x6d59,0x6d8e,0x6d95,0x6fe4, /* 0x9FB0-0x9FB7 */
	0x6d85,0x6df9,0x6e15,0x6e0a,0x6db5,0x6dc7,0x6de6,0x6db8, /* 0x9FB8-0x9FBF */
	/* codebase=0x9fc0 rawbase=0x15c0 */
	0x6dc6,0x6dec,0x6dde,0x6dcc,0x6de8,0x6dd2,0x6dc5,0x6dfa, /* 0x9FC0-0x9FC7 */
	0x6dd9,0x6de4,0x6dd5,0x6dea,0x6dee,0x6e2d,0x6e6e,0x6e2e, /* 0x9FC8-0x9FCF */
	0x6e19,0x6e72,0x6e5f,0x6e3e,0x6e23,0x6e6b,0x6e2b,0x6e76, /* 0x9FD0-0x9FD7 */
	0x6e4d,0x6e1f,0x6e43,0x6e3a,0x6e4e,0x6e24,0x6eff,0x6e1d, /* 0x9FD8-0x9FDF */
	0x6e38,0x6e82,0x6eaa,0x6e98,0x6ec9,0x6eb7,0x6ed3,0x6ebd, /* 0x9FE0-0x9FE7 */
	0x6eaf,0x6ec4,0x6eb2,0x6ed4,0x6ed5,0x6e8f,0x6ea5,0x6ec2, /* 0x9FE8-0x9FEF */
	0x6e9f,0x6f41,0x6f11,0x704c,0x6eec,0x6ef8,0x6efe,0x6f3f, /* 0x9FF0-0x9FF7 */
	0x6ef2,0x6f31,0x6eef,0x6f32,0x6ecc,0x0000,0x0000,0x0000, /* 0x9FF8-0x9FFF */
	/* codebase=0xe040 rawbase=0x1600 */
	0x6f3e,0x6f13,0x6ef7,0x6f86,0x6f7a,0x6f78,0x6f81,0x6f80, /* 0xE040-0xE047 */
	0x6f6f,0x6f5b,0x6ff3,0x6f6d,0x6f82,0x6f7c,0x6f58,0x6f8e, /* 0xE048-0xE04F */
	0x6f91,0x6fc2,0x6f66,0x6fb3,0x6fa3,0x6fa1,0x6fa4,0x6fb9, /* 0xE050-0xE057 */
	0x6fc6,0x6faa,0x6fdf,0x6fd5,0x6fec,0x6fd4,0x6fd8,0x6ff1, /* 0xE058-0xE05F */
	0x6fee,0x6fdb,0x7009,0x700b,0x6ffa,0x7011,0x7001,0x700f, /* 0xE060-0xE067 */
	0x6ffe,0x701b,0x701a,0x6f74,0x701d,0x7018,0x701f,0x7030, /* 0xE068-0xE06F */
	0x703e,0x7032,0x7051,0x7063,0x7099,0x7092,0x70af,0x70f1, /* 0xE070-0xE077 */
	0x70ac,0x70b8,0x70b3,0x70ae,0x70df,0x70cb,0x70dd,0x0000, /* 0xE078-0xE07F */
	/* codebase=0xe080 rawbase=0x1640 */
	0x70d9,0x7109,0x70fd,0x711c,0x7119,0x7165,0x7155,0x7188, /* 0xE080-0xE087 */
	0x7166,0x7162,0x714c,0x7156,0x716c,0x718f,0x71fb,0x7184, /* 0xE088-0xE08F */
	0x7195,0x71a8,0x71ac,0x71d7,0x71b9,0x71be,0x71d2,0x71c9, /* 0xE090-0xE097 */
	0x71d4,0x71ce,0x71e0,0x71ec,0x71e7,0x71f5,0x71fc,0x71f9, /* 0xE098-0xE09F */
	0x71ff,0x720d,0x7210,0x721b,0x7228,0x722d,0x722c,0x7230, /* 0xE0A0-0xE0A7 */
	0x7232,0x723b,0x723c,0x723f,0x7240,0x7246,0x724b,0x7258, /* 0xE0A8-0xE0AF */
	0x7274,0x727e,0x7282,0x7281,0x7287,0x7292,0x7296,0x72a2, /* 0xE0B0-0xE0B7 */
	0x72a7,0x72b9,0x72b2,0x72c3,0x72c6,0x72c4,0x72ce,0x72d2, /* 0xE0B8-0xE0BF */
	/* codebase=0xe0c0 rawbase=0x1680 */
	0x72e2,0x72e0,0x72e1,0x72f9,0x72f7,0x500f,0x7317,0x730a, /* 0xE0C0-0xE0C7 */
	0x731c,0x7316,0x731d,0x7334,0x732f,0x7329,0x7325,0x733e, /* 0xE0C8-0xE0CF */
	0x734e,0x734f,0x9ed8,0x7357,0x736a,0x7368,0x7370,0x7378, /* 0xE0D0-0xE0D7 */
	0x7375,0x737b,0x737a,0x73c8,0x73b3,0x73ce,0x73bb,0x73c0, /* 0xE0D8-0xE0DF */
	0x73e5,0x73ee,0x73de,0x74a2,0x7405,0x746f,0x7425,0x73f8, /* 0xE0E0-0xE0E7 */
	0x7432,0x743a,0x7455,0x743f,0x745f,0x7459,0x7441,0x745c, /* 0xE0E8-0xE0EF */
	0x7469,0x7470,0x7463,0x746a,0x7476,0x747e,0x748b,0x749e, /* 0xE0F0-0xE0F7 */
	0x74a7,0x74ca,0x74cf,0x74d4,0x73f1,0x0000,0x0000,0x0000, /* 0xE0F8-0xE0FF */
	/* codebase=0xe140 rawbase=0x16c0 */
	0x74e0,0x74e3,0x74e7,0x74e9,0x74ee,0x74f2,0x74f0,0x74f1, /* 0xE140-0xE147 */
	0x74f8,0x74f7,0x7504,0x7503,0x7505,0x750c,0x750e,0x750d, /* 0xE148-0xE14F */
	0x7515,0x7513,0x751e,0x7526,0x752c,0x753c,0x7544,0x754d, /* 0xE150-0xE157 */
	0x754a,0x7549,0x755b,0x7546,0x755a,0x7569,0x7564,0x7567, /* 0xE158-0xE15F */
	0x756b,0x756d,0x7578,0x7576,0x7586,0x7587,0x7574,0x758a, /* 0xE160-0xE167 */
	0x7589,0x7582,0x7594,0x759a,0x759d,0x75a5,0x75a3,0x75c2, /* 0xE168-0xE16F */
	0x75b3,0x75c3,0x75b5,0x75bd,0x75b8,0x75bc,0x75b1,0x75cd, /* 0xE170-0xE177 */
	0x75ca,0x75d2,0x75d9,0x75e3,0x75de,0x75fe,0x75ff,0x0000, /* 0xE178-0xE17F */
	/* codebase=0xe180 rawbase=0x1700 */
	0x75fc,0x7601,0x75f0,0x75fa,0x75f2,0x75f3,0x760b,0x760d, /* 0xE180-0xE187 */
	0x7609,0x761f,0x7627,0x7620,0x7621,0x7622,0x7624,0x7634, /* 0xE188-0xE18F */
	0x7630,0x763b,0x7647,0x7648,0x7646,0x765c,0x7658,0x7661, /* 0xE190-0xE197 */
	0x7662,0x7668,0x7669,0x766a,0x7667,0x766c,0x7670,0x7672, /* 0xE198-0xE19F */
	0x7676,0x7678,0x767c,0x7680,0x7683,0x7688,0x768b,0x768e, /* 0xE1A0-0xE1A7 */
	0x7696,0x7693,0x7699,0x769a,0x76b0,0x76b4,0x76b8,0x76b9, /* 0xE1A8-0xE1AF */
	0x76ba,0x76c2,0x76cd,0x76d6,0x76d2,0x76de,0x76e1,0x76e5, /* 0xE1B0-0xE1B7 */
	0x76e7,0x76ea,0x862f,0x76fb,0x7708,0x7707,0x7704,0x7729, /* 0xE1B8-0xE1BF */
	/* codebase=0xe1c0 rawbase=0x1740 */
	0x7724,0x771e,0x7725,0x7726,0x771b,0x7737,0x7738,0x7747, /* 0xE1C0-0xE1C7 */
	0x775a,0x7768,0x776b,0x775b,0x7765,0x777f,0x777e,0x7779, /* 0xE1C8-0xE1CF */
	0x778e,0x778b,0x7791,0x77a0,0x779e,0x77b0,0x77b6,0x77b9, /* 0xE1D0-0xE1D7 */
	0x77bf,0x77bc,0x77bd,0x77bb,0x77c7,0x77cd,0x77d7,0x77da, /* 0xE1D8-0xE1DF */
	0x77dc,0x77e3,0x77ee,0x77fc,0x780c,0x7812,0x7926,0x7820, /* 0xE1E0-0xE1E7 */
	0x792a,0x7845,0x788e,0x7874,0x7886,0x787c,0x789a,0x788c, /* 0xE1E8-0xE1EF */
	0x78a3,0x78b5,0x78aa,0x78af,0x78d1,0x78c6,0x78cb,0x78d4, /* 0xE1F0-0xE1F7 */
	0x78be,0x78bc,0x78c5,0x78ca,0x78ec,0x0000,0x0000,0x0000, /* 0xE1F8-0xE1FF */
	/* codebase=0xe240 rawbase=0x1780 */
	0x78e7,0x78da,0x78fd,0x78f4,0x7907,0x7912,0x7911,0x7919, /* 0xE240-0xE247 */
	0x792c,0x792b,0x7940,0x7960,0x7957,0x795f,0x795a,0x7955, /* 0xE248-0xE24F */
	0x7953,0x797a,0x797f,0x798a,0x799d,0x79a7,0x9f4b,0x79aa, /* 0xE250-0xE257 */
	0x79ae,0x79b3,0x79b9,0x79ba,0x79c9,0x79d5,0x79e7,0x79ec, /* 0xE258-0xE25F */
	0x79e1,0x79e3,0x7a08,0x7a0d,0x7a18,0x7a19,0x7a20,0x7a1f, /* 0xE260-0xE267 */
	0x7980,0x7a31,0x7a3b,0x7a3e,0x7a37,0x7a43,0x7a57,0x7a49, /* 0xE268-0xE26F */
	0x7a61,0x7a62,0x7a69,0x9f9d,0x7a70,0x7a79,0x7a7d,0x7a88, /* 0xE270-0xE277 */
	0x7a97,0x7a95,0x7a98,0x7a96,0x7aa9,0x7ac8,0x7ab0,0x0000, /* 0xE278-0xE27F */
	/* codebase=0xe280 rawbase=0x17c0 */
	0x7ab6,0x7ac5,0x7ac4,0x7abf,0x9083,0x7ac7,0x7aca,0x7acd, /* 0xE280-0xE287 */
	0x7acf,0x7ad5,0x7ad3,0x7ad9,0x7ada,0x7add,0x7ae1,0x7ae2, /* 0xE288-0xE28F */
	0x7ae6,0x7aed,0x7af0,0x7b02,0x7b0f,0x7b0a,0x7b06,0x7b33, /* 0xE290-0xE297 */
	0x7b18,0x7b19,0x7b1e,0x7b35,0x7b28,0x7b36,0x7b50,0x7b7a, /* 0xE298-0xE29F */
	0x7b04,0x7b4d,0x7b0b,0x7b4c,0x7b45,0x7b75,0x7b65,0x7b74, /* 0xE2A0-0xE2A7 */
	0x7b67,0x7b70,0x7b71,0x7b6c,0x7b6e,0x7b9d,0x7b98,0x7b9f, /* 0xE2A8-0xE2AF */
	0x7b8d,0x7b9c,0x7b9a,0x7b8b,0x7b92,0x7b8f,0x7b5d,0x7b99, /* 0xE2B0-0xE2B7 */
	0x7bcb,0x7bc1,0x7bcc,0x7bcf,0x7bb4,0x7bc6,0x7bdd,0x7be9, /* 0xE2B8-0xE2BF */
	/* codebase=0xe2c0 rawbase=0x1800 */
	0x7c11,0x7c14,0x7be6,0x7be5,0x7c60,0x7c00,0x7c07,0x7c13, /* 0xE2C0-0xE2C7 */
	0x7bf3,0x7bf7,0x7c17,0x7c0d,0x7bf6,0x7c23,0x7c27,0x7c2a, /* 0xE2C8-0xE2CF */
	0x7c1f,0x7c37,0x7c2b,0x7c3d,0x7c4c,0x7c43,0x7c54,0x7c4f, /* 0xE2D0-0xE2D7 */
	0x7c40,0x7c50,0x7c58,0x7c5f,0x7c64,0x7c56,0x7c65,0x7c6c, /* 0xE2D8-0xE2DF */
	0x7c75,0x7c83,0x7c90,0x7ca4,0x7cad,0x7ca2,0x7cab,0x7ca1, /* 0xE2E0-0xE2E7 */
	0x7ca8,0x7cb3,0x7cb2,0x7cb1,0x7cae,0x7cb9,0x7cbd,0x7cc0, /* 0xE2E8-0xE2EF */
	0x7cc5,0x7cc2,0x7cd8,0x7cd2,0x7cdc,0x7ce2,0x9b3b,0x7cef, /* 0xE2F0-0xE2F7 */
	0x7cf2,0x7cf4,0x7cf6,0x7cfa,0x7d06,0x0000,0x0000,0x0000, /* 0xE2F8-0xE2FF */
	/* codebase=0xe340 rawbase=0x1840 */
	0x7d02,0x7d1c,0x7d15,0x7d0a,0x7d45,0x7d4b,0x7d2e,0x7d32, /* 0xE340-0xE347 */
	0x7d3f,0x7d35,0x7d46,0x7d73,0x7d56,0x7d4e,0x7d72,0x7d68, /* 0xE348-0xE34F */
	0x7d6e,0x7d4f,0x7d63,0x7d93,0x7d89,0x7d5b,0x7d8f,0x7d7d, /* 0xE350-0xE357 */
	0x7d9b,0x7dba,0x7dae,0x7da3,0x7db5,0x7dc7,0x7dbd,0x7dab, /* 0xE358-0xE35F */
	0x7e3d,0x7da2,0x7daf,0x7ddc,0x7db8,0x7d9f,0x7db0,0x7dd8, /* 0xE360-0xE367 */
	0x7ddd,0x7de4,0x7dde,0x7dfb,0x7df2,0x7de1,0x7e05,0x7e0a, /* 0xE368-0xE36F */
	0x7e23,0x7e21,0x7e12,0x7e31,0x7e1f,0x7e09,0x7e0b,0x7e22, /* 0xE370-0xE377 */
	0x7e46,0x7e66,0x7e3b,0x7e35,0x7e39,0x7e43,0x7e37,0x0000, /* 0xE378-0xE37F */
	/* codebase=0xe380 rawbase=0x1880 */
	0x7e32,0x7e3a,0x7e67,0x7e5d,0x7e56,0x7e5e,0x7e59,0x7e5a, /* 0xE380-0xE387 */
	0x7e79,0x7e6a,0x7e69,0x7e7c,0x7e7b,0x7e83,0x7dd5,0x7e7d, /* 0xE388-0xE38F */
	0x8fae,0x7e7f,0x7e88,0x7e89,0x7e8c,0x7e92,0x7e90,0x7e93, /* 0xE390-0xE397 */
	0x7e94,0x7e96,0x7e8e,0x7e9b,0x7e9c,0x7f38,0x7f3a,0x7f45, /* 0xE398-0xE39F */
	0x7f4c,0x7f4d,0x7f4e,0x7f50,0x7f51,0x7f55,0x7f54,0x7f58, /* 0xE3A0-0xE3A7 */
	0x7f5f,0x7f60,0x7f68,0x7f69,0x7f67,0x7f78,0x7f82,0x7f86, /* 0xE3A8-0xE3AF */
	0x7f83,0x7f88,0x7f87,0x7f8c,0x7f94,0x7f9e,0x7f9d,0x7f9a, /* 0xE3B0-0xE3B7 */
	0x7fa3,0x7faf,0x7fb2,0x7fb9,0x7fae,0x7fb6,0x7fb8,0x8b71, /* 0xE3B8-0xE3BF */
	/* codebase=0xe3c0 rawbase=0x18c0 */
	0x7fc5,0x7fc6,0x7fca,0x7fd5,0x7fd4,0x7fe1,0x7fe6,0x7fe9, /* 0xE3C0-0xE3C7 */
	0x7ff3,0x7ff9,0x98dc,0x8006,0x8004,0x800b,0x8012,0x8018, /* 0xE3C8-0xE3CF */
	0x8019,0x801c,0x8021,0x8028,0x803f,0x803b,0x804a,0x8046, /* 0xE3D0-0xE3D7 */
	0x8052,0x8058,0x805a,0x805f,0x8062,0x8068,0x8073,0x8072, /* 0xE3D8-0xE3DF */
	0x8070,0x8076,0x8079,0x807d,0x807f,0x8084,0x8086,0x8085, /* 0xE3E0-0xE3E7 */
	0x809b,0x8093,0x809a,0x80ad,0x5190,0x80ac,0x80db,0x80e5, /* 0xE3E8-0xE3EF */
	0x80d9,0x80dd,0x80c4,0x80da,0x80d6,0x8109,0x80ef,0x80f1, /* 0xE3F0-0xE3F7 */
	0x811b,0x8129,0x8123,0x812f,0x814b,0x0000,0x0000,0x0000, /* 0xE3F8-0xE3FF */
	/* codebase=0xe440 rawbase=0x1900 */
	0x968b,0x8146,0x813e,0x8153,0x8151,0x80fc,0x8171,0x816e, /* 0xE440-0xE447 */
	0x8165,0x8166,0x8174,0x8183,0x8188,0x818a,0x8180,0x8182, /* 0xE448-0xE44F */
	0x81a0,0x8195,0x81a4,0x81a3,0x815f,0x8193,0x81a9,0x81b0, /* 0xE450-0xE457 */
	0x81b5,0x81be,0x81b8,0x81bd,0x81c0,0x81c2,0x81ba,0x81c9, /* 0xE458-0xE45F */
	0x81cd,0x81d1,0x81d9,0x81d8,0x81c8,0x81da,0x81df,0x81e0, /* 0xE460-0xE467 */
	0x81e7,0x81fa,0x81fb,0x81fe,0x8201,0x8202,0x8205,0x8207, /* 0xE468-0xE46F */
	0x820a,0x820d,0x8210,0x8216,0x8229,0x822b,0x8238,0x8233, /* 0xE470-0xE477 */
	0x8240,0x8259,0x8258,0x825d,0x825a,0x825f,0x8264,0x0000, /* 0xE478-0xE47F */
	/* codebase=0xe480 rawbase=0x1940 */
	0x8262,0x8268,0x826a,0x826b,0x822e,0x8271,0x8277,0x8278, /* 0xE480-0xE487 */
	0x827e,0x828d,0x8292,0x82ab,0x829f,0x82bb,0x82ac,0x82e1, /* 0xE488-0xE48F */
	0x82e3,0x82df,0x82d2,0x82f4,0x82f3,0x82fa,0x8393,0x8303, /* 0xE490-0xE497 */
	0x82fb,0x82f9,0x82de,0x8306,0x82dc,0x8309,0x82d9,0x8335, /* 0xE498-0xE49F */
	0x8334,0x8316,0x8332,0x8331,0x8340,0x8339,0x8350,0x8345, /* 0xE4A0-0xE4A7 */
	0x832f,0x832b,0x8317,0x8318,0x8385,0x839a,0x83aa,0x839f, /* 0xE4A8-0xE4AF */
	0x83a2,0x8396,0x8323,0x838e,0x8387,0x838a,0x837c,0x83b5, /* 0xE4B0-0xE4B7 */
	0x8373,0x8375,0x83a0,0x8389,0x83a8,0x83f4,0x8413,0x83eb, /* 0xE4B8-0xE4BF */
	/* codebase=0xe4c0 rawbase=0x1980 */
	0x83ce,0x83fd,0x8403,0x83d8,0x840b,0x83c1,0x83f7,0x8407, /* 0xE4C0-0xE4C7 */
	0x83e0,0x83f2,0x840d,0x8422,0x8420,0x83bd,0x8438,0x8506, /* 0xE4C8-0xE4CF */
	0x83fb,0x846d,0x842a,0x843c,0x855a,0x8484,0x8477,0x846b, /* 0xE4D0-0xE4D7 */
	0x84ad,0x846e,0x8482,0x8469,0x8446,0x842c,0x846f,0x8479, /* 0xE4D8-0xE4DF */
	0x8435,0x84ca,0x8462,0x84b9,0x84bf,0x849f,0x84d9,0x84cd, /* 0xE4E0-0xE4E7 */
	0x84bb,0x84da,0x84d0,0x84c1,0x84c6,0x84d6,0x84a1,0x8521, /* 0xE4E8-0xE4EF */
	0x84ff,0x84f4,0x8517,0x8518,0x852c,0x851f,0x8515,0x8514, /* 0xE4F0-0xE4F7 */
	0x84fc,0x8540,0x8563,0x8558,0x8548,0x0000,0x0000,0x0000, /* 0xE4F8-0xE4FF */
	/* codebase=0xe540 rawbase=0x19c0 */
	0x8541,0x8602,0x854b,0x8555,0x8580,0x85a4,0x8588,0x8591, /* 0xE540-0xE547 */
	0x858a,0x85a8,0x856d,0x8594,0x859b,0x85ea,0x8587,0x859c, /* 0xE548-0xE54F */
	0x8577,0x857e,0x8590,0x85c9,0x85ba,0x85cf,0x85b9,0x85d0, /* 0xE550-0xE557 */
	0x85d5,0x85dd,0x85e5,0x85dc,0x85f9,0x860a,0x8613,0x860b, /* 0xE558-0xE55F */
	0x85fe,0x85fa,0x8606,0x8622,0x861a,0x8630,0x863f,0x864d, /* 0xE560-0xE567 */
	0x4e55,0x8654,0x865f,0x8667,0x8671,0x8693,0x86a3,0x86a9, /* 0xE568-0xE56F */
	0x86aa,0x868b,0x868c,0x86b6,0x86af,0x86c4,0x86c6,0x86b0, /* 0xE570-0xE577 */
	0x86c9,0x8823,0x86ab,0x86d4,0x86de,0x86e9,0x86ec,0x0000, /* 0xE578-0xE57F */
	/* codebase=0xe580 rawbase=0x1a00 */
	0x86df,0x86db,0x86ef,0x8712,0x8706,0x8708,0x8700,0x8703, /* 0xE580-0xE587 */
	0x86fb,0x8711,0x8709,0x870d,0x86f9,0x870a,0x8734,0x873f, /* 0xE588-0xE58F */
	0x8737,0x873b,0x8725,0x8729,0x871a,0x8760,0x875f,0x8778, /* 0xE590-0xE597 */
	0x874c,0x874e,0x8774,0x8757,0x8768,0x876e,0x8759,0x8753, /* 0xE598-0xE59F */
	0x8763,0x876a,0x8805,0x87a2,0x879f,0x8782,0x87af,0x87cb, /* 0xE5A0-0xE5A7 */
	0x87bd,0x87c0,0x87d0,0x96d6,0x87ab,0x87c4,0x87b3,0x87c7, /* 0xE5A8-0xE5AF */
	0x87c6,0x87bb,0x87ef,0x87f2,0x87e0,0x880f,0x880d,0x87fe, /* 0xE5B0-0xE5B7 */
	0x87f6,0x87f7,0x880e,0x87d2,0x8811,0x8816,0x8815,0x8822, /* 0xE5B8-0xE5BF */
	/* codebase=0xe5c0 rawbase=0x1a40 */
	0x8821,0x8831,0x8836,0x8839,0x8827,0x883b,0x8844,0x8842, /* 0xE5C0-0xE5C7 */
	0x8852,0x8859,0x885e,0x8862,0x886b,0x8881,0x887e,0x889e, /* 0xE5C8-0xE5CF */
	0x8875,0x887d,0x88b5,0x8872,0x8882,0x8897,0x8892,0x88ae, /* 0xE5D0-0xE5D7 */
	0x8899,0x88a2,0x888d,0x88a4,0x88b0,0x88bf,0x88b1,0x88c3, /* 0xE5D8-0xE5DF */
	0x88c4,0x88d4,0x88d8,0x88d9,0x88dd,0x88f9,0x8902,0x88fc, /* 0xE5E0-0xE5E7 */
	0x88f4,0x88e8,0x88f2,0x8904,0x890c,0x890a,0x8913,0x8943, /* 0xE5E8-0xE5EF */
	0x891e,0x8925,0x892a,0x892b,0x8941,0x8944,0x893b,0x8936, /* 0xE5F0-0xE5F7 */
	0x8938,0x894c,0x891d,0x8960,0x895e,0x0000,0x0000,0x0000, /* 0xE5F8-0xE5FF */
	/* codebase=0xe640 rawbase=0x1a80 */
	0x8966,0x8964,0x896d,0x896a,0x896f,0x8974,0x8977,0x897e, /* 0xE640-0xE647 */
	0x8983,0x8988,0x898a,0x8993,0x8998,0x89a1,0x89a9,0x89a6, /* 0xE648-0xE64F */
	0x89ac,0x89af,0x89b2,0x89ba,0x89bd,0x89bf,0x89c0,0x89da, /* 0xE650-0xE657 */
	0x89dc,0x89dd,0x89e7,0x89f4,0x89f8,0x8a03,0x8a16,0x8a10, /* 0xE658-0xE65F */
	0x8a0c,0x8a1b,0x8a1d,0x8a25,0x8a36,0x8a41,0x8a5b,0x8a52, /* 0xE660-0xE667 */
	0x8a46,0x8a48,0x8a7c,0x8a6d,0x8a6c,0x8a62,0x8a85,0x8a82, /* 0xE668-0xE66F */
	0x8a84,0x8aa8,0x8aa1,0x8a91,0x8aa5,0x8aa6,0x8a9a,0x8aa3, /* 0xE670-0xE677 */
	0x8ac4,0x8acd,0x8ac2,0x8ada,0x8aeb,0x8af3,0x8ae7,0x0000, /* 0xE678-0xE67F */
	/* codebase=0xe680 rawbase=0x1ac0 */
	0x8ae4,0x8af1,0x8b14,0x8ae0,0x8ae2,0x8af7,0x8ade,0x8adb, /* 0xE680-0xE687 */
	0x8b0c,0x8b07,0x8b1a,0x8ae1,0x8b16,0x8b10,0x8b17,0x8b20, /* 0xE688-0xE68F */
	0x8b33,0x97ab,0x8b26,0x8b2b,0x8b3e,0x8b28,0x8b41,0x8b4c, /* 0xE690-0xE697 */
	0x8b4f,0x8b4e,0x8b49,0x8b56,0x8b5b,0x8b5a,0x8b6b,0x8b5f, /* 0xE698-0xE69F */
	0x8b6c,0x8b6f,0x8b74,0x8b7d,0x8b80,0x8b8c,0x8b8e,0x8b92, /* 0xE6A0-0xE6A7 */
	0x8b93,0x8b96,0x8b99,0x8b9a,0x8c3a,0x8c41,0x8c3f,0x8c48, /* 0xE6A8-0xE6AF */
	0x8c4c,0x8c4e,0x8c50,0x8c55,0x8c62,0x8c6c,0x8c78,0x8c7a, /* 0xE6B0-0xE6B7 */
	0x8c82,0x8c89,0x8c85,0x8c8a,0x8c8d,0x8c8e,0x8c94,0x8c7c, /* 0xE6B8-0xE6BF */
	/* codebase=0xe6c0 rawbase=0x1b00 */
	0x8c98,0x621d,0x8cad,0x8caa,0x8cbd,0x8cb2,0x8cb3,0x8cae, /* 0xE6C0-0xE6C7 */
	0x8cb6,0x8cc8,0x8cc1,0x8ce4,0x8ce3,0x8cda,0x8cfd,0x8cfa, /* 0xE6C8-0xE6CF */
	0x8cfb,0x8d04,0x8d05,0x8d0a,0x8d07,0x8d0f,0x8d0d,0x8d10, /* 0xE6D0-0xE6D7 */
	0x9f4e,0x8d13,0x8ccd,0x8d14,0x8d16,0x8d67,0x8d6d,0x8d71, /* 0xE6D8-0xE6DF */
	0x8d73,0x8d81,0x8d99,0x8dc2,0x8dbe,0x8dba,0x8dcf,0x8dda, /* 0xE6E0-0xE6E7 */
	0x8dd6,0x8dcc,0x8ddb,0x8dcb,0x8dea,0x8deb,0x8ddf,0x8de3, /* 0xE6E8-0xE6EF */
	0x8dfc,0x8e08,0x8e09,0x8dff,0x8e1d,0x8e1e,0x8e10,0x8e1f, /* 0xE6F0-0xE6F7 */
	0x8e42,0x8e35,0x8e30,0x8e34,0x8e4a,0x0000,0x0000,0x0000, /* 0xE6F8-0xE6FF */
	/* codebase=0xe740 rawbase=0x1b40 */
	0x8e47,0x8e49,0x8e4c,0x8e50,0x8e48,0x8e59,0x8e64,0x8e60, /* 0xE740-0xE747 */
	0x8e2a,0x8e63,0x8e55,0x8e76,0x8e72,0x8e7c,0x8e81,0x8e87, /* 0xE748-0xE74F */
	0x8e85,0x8e84,0x8e8b,0x8e8a,0x8e93,0x8e91,0x8e94,0x8e99, /* 0xE750-0xE757 */
	0x8eaa,0x8ea1,0x8eac,0x8eb0,0x8ec6,0x8eb1,0x8ebe,0x8ec5, /* 0xE758-0xE75F */
	0x8ec8,0x8ecb,0x8edb,0x8ee3,0x8efc,0x8efb,0x8eeb,0x8efe, /* 0xE760-0xE767 */
	0x8f0a,0x8f05,0x8f15,0x8f12,0x8f19,0x8f13,0x8f1c,0x8f1f, /* 0xE768-0xE76F */
	0x8f1b,0x8f0c,0x8f26,0x8f33,0x8f3b,0x8f39,0x8f45,0x8f42, /* 0xE770-0xE777 */
	0x8f3e,0x8f4c,0x8f49,0x8f46,0x8f4e,0x8f57,0x8f5c,0x0000, /* 0xE778-0xE77F */
	/* codebase=0xe780 rawbase=0x1b80 */
	0x8f62,0x8f63,0x8f64,0x8f9c,0x8f9f,0x8fa3,0x8fad,0x8faf, /* 0xE780-0xE787 */
	0x8fb7,0x8fda,0x8fe5,0x8fe2,0x8fea,0x8fef,0x9087,0x8ff4, /* 0xE788-0xE78F */
	0x9005,0x8ff9,0x8ffa,0x9011,0x9015,0x9021,0x900d,0x901e, /* 0xE790-0xE797 */
	0x9016,0x900b,0x9027,0x9036,0x9035,0x9039,0x8ff8,0x904f, /* 0xE798-0xE79F */
	0x9050,0x9051,0x9052,0x900e,0x9049,0x903e,0x9056,0x9058, /* 0xE7A0-0xE7A7 */
	0x905e,0x9068,0x906f,0x9076,0x96a8,0x9072,0x9082,0x907d, /* 0xE7A8-0xE7AF */
	0x9081,0x9080,0x908a,0x9089,0x908f,0x90a8,0x90af,0x90b1, /* 0xE7B0-0xE7B7 */
	0x90b5,0x90e2,0x90e4,0x6248,0x90db,0x9102,0x9112,0x9119, /* 0xE7B8-0xE7BF */
	/* codebase=0xe7c0 rawbase=0x1bc0 */
	0x9132,0x9130,0x914a,0x9156,0x9158,0x9163,0x9165,0x9169, /* 0xE7C0-0xE7C7 */
	0x9173,0x9172,0x918b,0x9189,0x9182,0x91a2,0x91ab,0x91af, /* 0xE7C8-0xE7CF */
	0x91aa,0x91b5,0x91b4,0x91ba,0x91c0,0x91c1,0x91c9,0x91cb, /* 0xE7D0-0xE7D7 */
	0x91d0,0x91d6,0x91df,0x91e1,0x91db,0x91fc,0x91f5,0x91f6, /* 0xE7D8-0xE7DF */
	0x921e,0x91ff,0x9214,0x922c,0x9215,0x9211,0x925e,0x9257, /* 0xE7E0-0xE7E7 */
	0x9245,0x9249,0x9264,0x9248,0x9295,0x923f,0x924b,0x9250, /* 0xE7E8-0xE7EF */
	0x929c,0x9296,0x9293,0x929b,0x925a,0x92cf,0x92b9,0x92b7, /* 0xE7F0-0xE7F7 */
	0x92e9,0x930f,0x92fa,0x9344,0x932e,0x0000,0x0000,0x0000, /* 0xE7F8-0xE7FF */
	/* codebase=0xe840 rawbase=0x1c00 */
	0x9319,0x9322,0x931a,0x9323,0x933a,0x9335,0x933b,0x935c, /* 0xE840-0xE847 */
	0x9360,0x937c,0x936e,0x9356,0x93b0,0x93ac,0x93ad,0x9394, /* 0xE848-0xE84F */
	0x93b9,0x93d6,0x93d7,0x93e8,0x93e5,0x93d8,0x93c3,0x93dd, /* 0xE850-0xE857 */
	0x93d0,0x93c8,0x93e4,0x941a,0x9414,0x9413,0x9403,0x9407, /* 0xE858-0xE85F */
	0x9410,0x9436,0x942b,0x9435,0x9421,0x943a,0x9441,0x9452, /* 0xE860-0xE867 */
	0x9444,0x945b,0x9460,0x9462,0x945e,0x946a,0x9229,0x9470, /* 0xE868-0xE86F */
	0x9475,0x9477,0x947d,0x945a,0x947c,0x947e,0x9481,0x947f, /* 0xE870-0xE877 */
	0x9582,0x9587,0x958a,0x9594,0x9596,0x9598,0x9599,0x0000, /* 0xE878-0xE87F */
	/* codebase=0xe880 rawbase=0x1c40 */
	0x95a0,0x95a8,0x95a7,0x95ad,0x95bc,0x95bb,0x95b9,0x95be, /* 0xE880-0xE887 */
	0x95ca,0x6ff6,0x95c3,0x95cd,0x95cc,0x95d5,0x95d4,0x95d6, /* 0xE888-0xE88F */
	0x95dc,0x95e1,0x95e5,0x95e2,0x9621,0x9628,0x962e,0x962f, /* 0xE890-0xE897 */
	0x9642,0x964c,0x964f,0x964b,0x9677,0x965c,0x965e,0x965d, /* 0xE898-0xE89F */
	0x965f,0x9666,0x9672,0x966c,0x968d,0x9698,0x9695,0x9697, /* 0xE8A0-0xE8A7 */
	0x96aa,0x96a7,0x96b1,0x96b2,0x96b0,0x96b4,0x96b6,0x96b8, /* 0xE8A8-0xE8AF */
	0x96b9,0x96ce,0x96cb,0x96c9,0x96cd,0x894d,0x96dc,0x970d, /* 0xE8B0-0xE8B7 */
	0x96d5,0x96f9,0x9704,0x9706,0x9708,0x9713,0x970e,0x9711, /* 0xE8B8-0xE8BF */
	/* codebase=0xe8c0 rawbase=0x1c80 */
	0x970f,0x9716,0x9719,0x9724,0x972a,0x9730,0x9739,0x973d, /* 0xE8C0-0xE8C7 */
	0x973e,0x9744,0x9746,0x9748,0x9742,0x9749,0x975c,0x9760, /* 0xE8C8-0xE8CF */
	0x9764,0x9766,0x9768,0x52d2,0x976b,0x9771,0x9779,0x9785, /* 0xE8D0-0xE8D7 */
	0x977c,0x9781,0x977a,0x9786,0x978b,0x978f,0x9790,0x979c, /* 0xE8D8-0xE8DF */
	0x97a8,0x97a6,0x97a3,0x97b3,0x97b4,0x97c3,0x97c6,0x97c8, /* 0xE8E0-0xE8E7 */
	0x97cb,0x97dc,0x97ed,0x9f4f,0x97f2,0x7adf,0x97f6,0x97f5, /* 0xE8E8-0xE8EF */
	0x980f,0x980c,0x9838,0x9824,0x9821,0x9837,0x983d,0x9846, /* 0xE8F0-0xE8F7 */
	0x984f,0x984b,0x986b,0x986f,0x9870,0x0000,0x0000,0x0000, /* 0xE8F8-0xE8FF */
	/* codebase=0xe940 rawbase=0x1cc0 */
	0x9871,0x9874,0x9873,0x98aa,0x98af,0x98b1,0x98b6,0x98c4, /* 0xE940-0xE947 */
	0x98c3,0x98c6,0x98e9,0x98eb,0x9903,0x9909,0x9912,0x9914, /* 0xE948-0xE94F */
	0x9918,0x9921,0x991d,0x991e,0x9924,0x9920,0x992c,0x992e, /* 0xE950-0xE957 */
	0x993d,0x993e,0x9942,0x9949,0x9945,0x9950,0x994b,0x9951, /* 0xE958-0xE95F */
	0x9952,0x994c,0x9955,0x9997,0x9998,0x99a5,0x99ad,0x99ae, /* 0xE960-0xE967 */
	0x99bc,0x99df,0x99db,0x99dd,0x99d8,0x99d1,0x99ed,0x99ee, /* 0xE968-0xE96F */
	0x99f1,0x99f2,0x99fb,0x99f8,0x9a01,0x9a0f,0x9a05,0x99e2, /* 0xE970-0xE977 */
	0x9a19,0x9a2b,0x9a37,0x9a45,0x9a42,0x9a40,0x9a43,0x0000, /* 0xE978-0xE97F */
	/* codebase=0xe980 rawbase=0x1d00 */
	0x9a3e,0x9a55,0x9a4d,0x9a5b,0x9a57,0x9a5f,0x9a62,0x9a65, /* 0xE980-0xE987 */
	0x9a64,0x9a69,0x9a6b,0x9a6a,0x9aad,0x9ab0,0x9abc,0x9ac0, /* 0xE988-0xE98F */
	0x9acf,0x9ad1,0x9ad3,0x9ad4,0x9ade,0x9adf,0x9ae2,0x9ae3, /* 0xE990-0xE997 */
	0x9ae6,0x9aef,0x9aeb,0x9aee,0x9af4,0x9af1,0x9af7,0x9afb, /* 0xE998-0xE99F */
	0x9b06,0x9b18,0x9b1a,0x9b1f,0x9b22,0x9b23,0x9b25,0x9b27, /* 0xE9A0-0xE9A7 */
	0x9b28,0x9b29,0x9b2a,0x9b2e,0x9b2f,0x9b32,0x9b44,0x9b43, /* 0xE9A8-0xE9AF */
	0x9b4f,0x9b4d,0x9b4e,0x9b51,0x9b58,0x9b74,0x9b93,0x9b83, /* 0xE9B0-0xE9B7 */
	0x9b91,0x9b96,0x9b97,0x9b9f,0x9ba0,0x9ba8,0x9bb4,0x9bc0, /* 0xE9B8-0xE9BF */
	/* codebase=0xe9c0 rawbase=0x1d40 */
	0x9bca,0x9bb9,0x9bc6,0x9bcf,0x9bd1,0x9bd2,0x9be3,0x9be2, /* 0xE9C0-0xE9C7 */
	0x9be4,0x9bd4,0x9be1,0x9c3a,0x9bf2,0x9bf1,0x9bf0,0x9c15, /* 0xE9C8-0xE9CF */
	0x9c14,0x9c09,0x9c13,0x9c0c,0x9c06,0x9c08,0x9c12,0x9c0a, /* 0xE9D0-0xE9D7 */
	0x9c04,0x9c2e,0x9c1b,0x9c25,0x9c24,0x9c21,0x9c30,0x9c47, /* 0xE9D8-0xE9DF */
	0x9c32,0x9c46,0x9c3e,0x9c5a,0x9c60,0x9c67,0x9c76,0x9c78, /* 0xE9E0-0xE9E7 */
	0x9ce7,0x9cec,0x9cf0,0x9d09,0x9d08,0x9ceb,0x9d03,0x9d06, /* 0xE9E8-0xE9EF */
	0x9d2a,0x9d26,0x9daf,0x9d23,0x9d1f,0x9d44,0x9d15,0x9d12, /* 0xE9F0-0xE9F7 */
	0x9d41,0x9d3f,0x9d3e,0x9d46,0x9d48,0x0000,0x0000,0x0000, /* 0xE9F8-0xE9FF */
	/* codebase=0xea40 rawbase=0x1d80 */
	0x9d5d,0x9d5e,0x9d64,0x9d51,0x9d50,0x9d59,0x9d72,0x9d89, /* 0xEA40-0xEA47 */
	0x9d87,0x9dab,0x9d6f,0x9d7a,0x9d9a,0x9da4,0x9da9,0x9db2, /* 0xEA48-0xEA4F */
	0x9dc4,0x9dc1,0x9dbb,0x9db8,0x9dba,0x9dc6,0x9dcf,0x9dc2, /* 0xEA50-0xEA57 */
	0x9dd9,0x9dd3,0x9df8,0x9de6,0x9ded,0x9def,0x9dfd,0x9e1a, /* 0xEA58-0xEA5F */
	0x9e1b,0x9e1e,0x9e75,0x9e79,0x9e7d,0x9e81,0x9e88,0x9e8b, /* 0xEA60-0xEA67 */
	0x9e8c,0x9e92,0x9e95,0x9e91,0x9e9d,0x9ea5,0x9ea9,0x9eb8, /* 0xEA68-0xEA6F */
	0x9eaa,0x9ead,0x9761,0x9ecc,0x9ece,0x9ecf,0x9ed0,0x9ed4, /* 0xEA70-0xEA77 */
	0x9edc,0x9ede,0x9edd,0x9ee0,0x9ee5,0x9ee8,0x9eef,0x0000, /* 0xEA78-0xEA7F */
	/* codebase=0xea80 rawbase=0x1dc0 */
	0x9ef4,0x9ef6,0x9ef7,0x9ef9,0x9efb,0x9efc,0x9efd,0x9f07, /* 0xEA80-0xEA87 */
	0x9f08,0x76b7,0x9f15,0x9f21,0x9f2c,0x9f3e,0x9f4a,0x9f52, /* 0xEA88-0xEA8F */
	0x9f54,0x9f63,0x9f5f,0x9f60,0x9f61,0x9f66,0x9f67,0x9f6c, /* 0xEA90-0xEA97 */
	0x9f6a,0x9f77,0x9f72,0x9f76,0x9f95,0x9f9c,0x9fa0,0x582f, /* 0xEA98-0xEA9F */
	0x69c7,0x9059,0x7464,0x51dc,0x7199,0x0000,0x0000,0x0000, /* 0xEAA0-0xEAA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEAA8-0xEAAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEAB0-0xEAB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEAB8-0xEABF */
	/* codebase=0xed40 rawbase=0x1e00 */
	0x7e8a,0x891c,0x9348,0x9288,0x84dc,0x4fc9,0x70bb,0x6631, /* 0xED40-0xED47 */
	0x68c8,0x92f9,0x66fb,0x5f45,0x4e28,0x4ee1,0x4efc,0x4f00, /* 0xED48-0xED4F */
	0x4f03,0x4f39,0x4f56,0x4f92,0x4f8a,0x4f9a,0x4f94,0x4fcd, /* 0xED50-0xED57 */
	0x5040,0x5022,0x4fff,0x501e,0x5046,0x5070,0x5042,0x5094, /* 0xED58-0xED5F */
	0x50f4,0x50d8,0x514a,0x5164,0x519d,0x51be,0x51ec,0x5215, /* 0xED60-0xED67 */
	0x529c,0x52a6,0x52c0,0x52db,0x5300,0x5307,0x5324,0x5372, /* 0xED68-0xED6F */
	0x5393,0x53b2,0x53dd,0xfa0e,0x549c,0x548a,0x54a9,0x54ff, /* 0xED70-0xED77 */
	0x5586,0x5759,0x5765,0x57ac,0x57c8,0x57c7,0xfa0f,0x0000, /* 0xED78-0xED7F */
	/* codebase=0xed80 rawbase=0x1e40 */
	0xfa10,0x589e,0x58b2,0x590b,0x5953,0x595b,0x595d,0x5963, /* 0xED80-0xED87 */
	0x59a4,0x59ba,0x5b56,0x5bc0,0x752f,0x5bd8,0x5bec,0x5c1e, /* 0xED88-0xED8F */
	0x5ca6,0x5cba,0x5cf5,0x5d27,0x5d53,0xfa11,0x5d42,0x5d6d, /* 0xED90-0xED97 */
	0x5db8,0x5db9,0x5dd0,0x5f21,0x5f34,0x5f67,0x5fb7,0x5fde, /* 0xED98-0xED9F */
	0x605d,0x6085,0x608a,0x60de,0x60d5,0x6120,0x60f2,0x6111, /* 0xEDA0-0xEDA7 */
	0x6137,0x6130,0x6198,0x6213,0x62a6,0x63f5,0x6460,0x649d, /* 0xEDA8-0xEDAF */
	0x64ce,0x654e,0x6600,0x6615,0x663b,0x6609,0x662e,0x661e, /* 0xEDB0-0xEDB7 */
	0x6624,0x6665,0x6657,0x6659,0xfa12,0x6673,0x6699,0x66a0, /* 0xEDB8-0xEDBF */
	/* codebase=0xedc0 rawbase=0x1e80 */
	0x66b2,0x66bf,0x66fa,0x670e,0xf929,0x6766,0x67bb,0x6852, /* 0xEDC0-0xEDC7 */
	0x67c0,0x6801,0x6844,0x68cf,0xfa13,0x6968,0xfa14,0x6998, /* 0xEDC8-0xEDCF */
	0x69e2,0x6a30,0x6a6b,0x6a46,0x6a73,0x6a7e,0x6ae2,0x6ae4, /* 0xEDD0-0xEDD7 */
	0x6bd6,0x6c3f,0x6c5c,0x6c86,0x6c6f,0x6cda,0x6d04,0x6d87, /* 0xEDD8-0xEDDF */
	0x6d6f,0x6d96,0x6dac,0x6dcf,0x6df8,0x6df2,0x6dfc,0x6e39, /* 0xEDE0-0xEDE7 */
	0x6e5c,0x6e27,0x6e3c,0x6ebf,0x6f88,0x6fb5,0x6ff5,0x7005, /* 0xEDE8-0xEDEF */
	0x7007,0x7028,0x7085,0x70ab,0x710f,0x7104,0x715c,0x7146, /* 0xEDF0-0xEDF7 */
	0x7147,0xfa15,0x71c1,0x71fe,0x72b1,0x0000,0x0000,0x0000, /* 0xEDF8-0xEDFF */
	/* codebase=0xee40 rawbase=0x1ec0 */
	0x72be,0x7324,0xfa16,0x7377,0x73bd,0x73c9,0x73d6,0x73e3, /* 0xEE40-0xEE47 */
	0x73d2,0x7407,0x73f5,0x7426,0x742a,0x7429,0x742e,0x7462, /* 0xEE48-0xEE4F */
	0x7489,0x749f,0x7501,0x756f,0x7682,0x769c,0x769e,0x769b, /* 0xEE50-0xEE57 */
	0x76a6,0xfa17,0x7746,0x52af,0x7821,0x784e,0x7864,0x787a, /* 0xEE58-0xEE5F */
	0x7930,0xfa18,0xfa19,0xfa1a,0x7994,0xfa1b,0x799b,0x7ad1, /* 0xEE60-0xEE67 */
	0x7ae7,0xfa1c,0x7aeb,0x7b9e,0xfa1d,0x7d48,0x7d5c,0x7db7, /* 0xEE68-0xEE6F */
	0x7da0,0x7dd6,0x7e52,0x7f47,0x7fa1,0xfa1e,0x8301,0x8362, /* 0xEE70-0xEE77 */
	0x837f,0x83c7,0x83f6,0x8448,0x84b4,0x8553,0x8559,0x0000, /* 0xEE78-0xEE7F */
	/* codebase=0xee80 rawbase=0x1f00 */
	0x856b,0xfa1f,0x85b0,0xfa20,0xfa21,0x8807,0x88f5,0x8a12, /* 0xEE80-0xEE87 */
	0x8a37,0x8a79,0x8aa7,0x8abe,0x8adf,0xfa22,0x8af6,0x8b53, /* 0xEE88-0xEE8F */
	0x8b7f,0x8cf0,0x8cf4,0x8d12,0x8d76,0xfa23,0x8ecf,0xfa24, /* 0xEE90-0xEE97 */
	0xfa25,0x9067,0x90de,0xfa26,0x9115,0x9127,0x91da,0x91d7, /* 0xEE98-0xEE9F */
	0x91de,0x91ed,0x91ee,0x91e4,0x91e5,0x9206,0x9210,0x920a, /* 0xEEA0-0xEEA7 */
	0x923a,0x9240,0x923c,0x924e,0x9259,0x9251,0x9239,0x9267, /* 0xEEA8-0xEEAF */
	0x92a7,0x9277,0x9278,0x92e7,0x92d7,0x92d9,0x92d0,0xfa27, /* 0xEEB0-0xEEB7 */
	0x92d5,0x92e0,0x92d3,0x9325,0x9321,0x92fb,0xfa28,0x931e, /* 0xEEB8-0xEEBF */
	/* codebase=0xeec0 rawbase=0x1f40 */
	0x92ff,0x931d,0x9302,0x9370,0x9357,0x93a4,0x93c6,0x93de, /* 0xEEC0-0xEEC7 */
	0x93f8,0x9431,0x9445,0x9448,0x9592,0xf9dc,0xfa29,0x969d, /* 0xEEC8-0xEECF */
	0x96af,0x9733,0x973b,0x9743,0x974d,0x974f,0x9751,0x9755, /* 0xEED0-0xEED7 */
	0x9857,0x9865,0xfa2a,0xfa2b,0x9927,0xfa2c,0x999e,0x9a4e, /* 0xEED8-0xEEDF */
	0x9ad9,0x9adc,0x9b75,0x9b72,0x9b8f,0x9bb1,0x9bbb,0x9c00, /* 0xEEE0-0xEEE7 */
	0x9d70,0x9d6b,0xfa2d,0x9e19,0x9ed1,0x0000,0x0000,0x2170, /* 0xEEE8-0xEEEF */
	0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,0x2177,0x2178, /* 0xEEF0-0xEEF7 */
	0x2179,0xffe2,0xffe4,0xff07,0xff02,0x0000,0x0000,0x0000, /* 0xEEF8-0xEEFF */
	/* codebase=0xfa40 rawbase=0x1f80 */
	0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,0x2177, /* 0xFA40-0xFA47 */
	0x2178,0x2179,0x2160,0x2161,0x2162,0x2163,0x2164,0x2165, /* 0xFA48-0xFA4F */
	0x2166,0x2167,0x2168,0x2169,0xffe2,0xffe4,0xff07,0xff02, /* 0xFA50-0xFA57 */
	0x3231,0x2116,0x2121,0x2235,0x7e8a,0x891c,0x9348,0x9288, /* 0xFA58-0xFA5F */
	0x84dc,0x4fc9,0x70bb,0x6631,0x68c8,0x92f9,0x66fb,0x5f45, /* 0xFA60-0xFA67 */
	0x4e28,0x4ee1,0x4efc,0x4f00,0x4f03,0x4f39,0x4f56,0x4f92, /* 0xFA68-0xFA6F */
	0x4f8a,0x4f9a,0x4f94,0x4fcd,0x5040,0x5022,0x4fff,0x501e, /* 0xFA70-0xFA77 */
	0x5046,0x5070,0x5042,0x5094,0x50f4,0x50d8,0x514a,0x0000, /* 0xFA78-0xFA7F */
	/* codebase=0xfa80 rawbase=0x1fc0 */
	0x5164,0x519d,0x51be,0x51ec,0x5215,0x529c,0x52a6,0x52c0, /* 0xFA80-0xFA87 */
	0x52db,0x5300,0x5307,0x5324,0x5372,0x5393,0x53b2,0x53dd, /* 0xFA88-0xFA8F */
	0xfa0e,0x549c,0x548a,0x54a9,0x54ff,0x5586,0x5759,0x5765, /* 0xFA90-0xFA97 */
	0x57ac,0x57c8,0x57c7,0xfa0f,0xfa10,0x589e,0x58b2,0x590b, /* 0xFA98-0xFA9F */
	0x5953,0x595b,0x595d,0x5963,0x59a4,0x59ba,0x5b56,0x5bc0, /* 0xFAA0-0xFAA7 */
	0x752f,0x5bd8,0x5bec,0x5c1e,0x5ca6,0x5cba,0x5cf5,0x5d27, /* 0xFAA8-0xFAAF */
	0x5d53,0xfa11,0x5d42,0x5d6d,0x5db8,0x5db9,0x5dd0,0x5f21, /* 0xFAB0-0xFAB7 */
	0x5f34,0x5f67,0x5fb7,0x5fde,0x605d,0x6085,0x608a,0x60de, /* 0xFAB8-0xFABF */
	/* codebase=0xfac0 rawbase=0x2000 */
	0x60d5,0x6120,0x60f2,0x6111,0x6137,0x6130,0x6198,0x6213, /* 0xFAC0-0xFAC7 */
	0x62a6,0x63f5,0x6460,0x649d,0x64ce,0x654e,0x6600,0x6615, /* 0xFAC8-0xFACF */
	0x663b,0x6609,0x662e,0x661e,0x6624,0x6665,0x6657,0x6659, /* 0xFAD0-0xFAD7 */
	0xfa12,0x6673,0x6699,0x66a0,0x66b2,0x66bf,0x66fa,0x670e, /* 0xFAD8-0xFADF */
	0xf929,0x6766,0x67bb,0x6852,0x67c0,0x6801,0x6844,0x68cf, /* 0xFAE0-0xFAE7 */
	0xfa13,0x6968,0xfa14,0x6998,0x69e2,0x6a30,0x6a6b,0x6a46, /* 0xFAE8-0xFAEF */
	0x6a73,0x6a7e,0x6ae2,0x6ae4,0x6bd6,0x6c3f,0x6c5c,0x6c86, /* 0xFAF0-0xFAF7 */
	0x6c6f,0x6cda,0x6d04,0x6d87,0x6d6f,0x0000,0x0000,0x0000, /* 0xFAF8-0xFAFF */
	/* codebase=0xfb40 rawbase=0x2040 */
	0x6d96,0x6dac,0x6dcf,0x6df8,0x6df2,0x6dfc,0x6e39,0x6e5c, /* 0xFB40-0xFB47 */
	0x6e27,0x6e3c,0x6ebf,0x6f88,0x6fb5,0x6ff5,0x7005,0x7007, /* 0xFB48-0xFB4F */
	0x7028,0x7085,0x70ab,0x710f,0x7104,0x715c,0x7146,0x7147, /* 0xFB50-0xFB57 */
	0xfa15,0x71c1,0x71fe,0x72b1,0x72be,0x7324,0xfa16,0x7377, /* 0xFB58-0xFB5F */
	0x73bd,0x73c9,0x73d6,0x73e3,0x73d2,0x7407,0x73f5,0x7426, /* 0xFB60-0xFB67 */
	0x742a,0x7429,0x742e,0x7462,0x7489,0x749f,0x7501,0x756f, /* 0xFB68-0xFB6F */
	0x7682,0x769c,0x769e,0x769b,0x76a6,0xfa17,0x7746,0x52af, /* 0xFB70-0xFB77 */
	0x7821,0x784e,0x7864,0x787a,0x7930,0xfa18,0xfa19,0x0000, /* 0xFB78-0xFB7F */
	/* codebase=0xfb80 rawbase=0x2080 */
	0xfa1a,0x7994,0xfa1b,0x799b,0x7ad1,0x7ae7,0xfa1c,0x7aeb, /* 0xFB80-0xFB87 */
	0x7b9e,0xfa1d,0x7d48,0x7d5c,0x7db7,0x7da0,0x7dd6,0x7e52, /* 0xFB88-0xFB8F */
	0x7f47,0x7fa1,0xfa1e,0x8301,0x8362,0x837f,0x83c7,0x83f6, /* 0xFB90-0xFB97 */
	0x8448,0x84b4,0x8553,0x8559,0x856b,0xfa1f,0x85b0,0xfa20, /* 0xFB98-0xFB9F */
	0xfa21,0x8807,0x88f5,0x8a12,0x8a37,0x8a79,0x8aa7,0x8abe, /* 0xFBA0-0xFBA7 */
	0x8adf,0xfa22,0x8af6,0x8b53,0x8b7f,0x8cf0,0x8cf4,0x8d12, /* 0xFBA8-0xFBAF */
	0x8d76,0xfa23,0x8ecf,0xfa24,0xfa25,0x9067,0x90de,0xfa26, /* 0xFBB0-0xFBB7 */
	0x9115,0x9127,0x91da,0x91d7,0x91de,0x91ed,0x91ee,0x91e4, /* 0xFBB8-0xFBBF */
	/* codebase=0xfbc0 rawbase=0x20c0 */
	0x91e5,0x9206,0x9210,0x920a,0x923a,0x9240,0x923c,0x924e, /* 0xFBC0-0xFBC7 */
	0x9259,0x9251,0x9239,0x9267,0x92a7,0x9277,0x9278,0x92e7, /* 0xFBC8-0xFBCF */
	0x92d7,0x92d9,0x92d0,0xfa27,0x92d5,0x92e0,0x92d3,0x9325, /* 0xFBD0-0xFBD7 */
	0x9321,0x92fb,0xfa28,0x931e,0x92ff,0x931d,0x9302,0x9370, /* 0xFBD8-0xFBDF */
	0x9357,0x93a4,0x93c6,0x93de,0x93f8,0x9431,0x9445,0x9448, /* 0xFBE0-0xFBE7 */
	0x9592,0xf9dc,0xfa29,0x969d,0x96af,0x9733,0x973b,0x9743, /* 0xFBE8-0xFBEF */
	0x974d,0x974f,0x9751,0x9755,0x9857,0x9865,0xfa2a,0xfa2b, /* 0xFBF0-0xFBF7 */
	0x9927,0xfa2c,0x999e,0x9a4e,0x9ad9,0x0000,0x0000,0x0000, /* 0xFBF8-0xFBFF */
	/* codebase=0xfc40 rawbase=0x2100 */
	0x9adc,0x9b75,0x9b72,0x9b8f,0x9bb1,0x9bbb,0x9c00,0x9d70, /* 0xFC40-0xFC47 */
	0x9d6b,0xfa2d,0x9e19,0x9ed1,0x0000,0x0000,0x0000,0x0000, /* 0xFC48-0xFC4F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC50-0xFC57 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC58-0xFC5F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC60-0xFC67 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC68-0xFC6F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC70-0xFC77 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC78-0xFC7F */
};
const uint16_t cp932_to_unicode_hitbl[1024] = {
	0x0000, /* 0x0000-0x003F */
	0x0040, /* 0x0040-0x007F */
	0x0080, /* 0x0080-0x00BF */
	0x00c0, /* 0x00c0-0x00FF */
	0xffff, /* 0x0100-0x013F NOT PRESENT */
	0xffff, /* 0x0140-0x017F NOT PRESENT */
	0xffff, /* 0x0180-0x01BF NOT PRESENT */
	0xffff, /* 0x01c0-0x01FF NOT PRESENT */
	0xffff, /* 0x0200-0x023F NOT PRESENT */
	0xffff, /* 0x0240-0x027F NOT PRESENT */
	0xffff, /* 0x0280-0x02BF NOT PRESENT */
	0xffff, /* 0x02c0-0x02FF NOT PRESENT */
	0xffff, /* 0x0300-0x033F NOT PRESENT */
	0xffff, /* 0x0340-0x037F NOT PRESENT */
	0xffff, /* 0x0380-0x03BF NOT PRESENT */
	0xffff, /* 0x03c0-0x03FF NOT PRESENT */
	0xffff, /* 0x0400-0x043F NOT PRESENT */
	0xffff, /* 0x0440-0x047F NOT PRESENT */
	0xffff, /* 0x0480-0x04BF NOT PRESENT */
	0xffff, /* 0x04c0-0x04FF NOT PRESENT */
	0xffff, /* 0x0500-0x053F NOT PRESENT */
	0xffff, /* 0x0540-0x057F NOT PRESENT */
	0xffff, /* 0x0580-0x05BF NOT PRESENT */
	0xffff, /* 0x05c0-0x05FF NOT PRESENT */
	0xffff, /* 0x0600-0x063F NOT PRESENT */
	0xffff, /* 0x0640-0x067F NOT PRESENT */
	0xffff, /* 0x0680-0x06BF NOT PRESENT */
	0xffff, /* 0x06c0-0x06FF NOT PRESENT */
	0xffff, /* 0x0700-0x073F NOT PRESENT */
	0xffff, /* 0x0740-0x077F NOT PRESENT */
	0xffff, /* 0x0780-0x07BF NOT PRESENT */
	0xffff, /* 0x07c0-0x07FF NOT PRESENT */
	0xffff, /* 0x0800-0x083F NOT PRESENT */
	0xffff, /* 0x0840-0x087F NOT PRESENT */
	0xffff, /* 0x0880-0x08BF NOT PRESENT */
	0xffff, /* 0x08c0-0x08FF NOT PRESENT */
	0xffff, /* 0x0900-0x093F NOT PRESENT */
	0xffff, /* 0x0940-0x097F NOT PRESENT */
	0xffff, /* 0x0980-0x09BF NOT PRESENT */
	0xffff, /* 0x09c0-0x09FF NOT PRESENT */
	0xffff, /* 0x0a00-0x0A3F NOT PRESENT */
	0xffff, /* 0x0a40-0x0A7F NOT PRESENT */
	0xffff, /* 0x0a80-0x0ABF NOT PRESENT */
	0xffff, /* 0x0ac0-0x0AFF NOT PRESENT */
	0xffff, /* 0x0b00-0x0B3F NOT PRESENT */
	0xffff, /* 0x0b40-0x0B7F NOT PRESENT */
	0xffff, /* 0x0b80-0x0BBF NOT PRESENT */
	0xffff, /* 0x0bc0-0x0BFF NOT PRESENT */
	0xffff, /* 0x0c00-0x0C3F NOT PRESENT */
	0xffff, /* 0x0c40-0x0C7F NOT PRESENT */
	0xffff, /* 0x0c80-0x0CBF NOT PRESENT */
	0xffff, /* 0x0cc0-0x0CFF NOT PRESENT */
	0xffff, /* 0x0d00-0x0D3F NOT PRESENT */
	0xffff, /* 0x0d40-0x0D7F NOT PRESENT */
	0xffff, /* 0x0d80-0x0DBF NOT PRESENT */
	0xffff, /* 0x0dc0-0x0DFF NOT PRESENT */
	0xffff, /* 0x0e00-0x0E3F NOT PRESENT */
	0xffff, /* 0x0e40-0x0E7F NOT PRESENT */
	0xffff, /* 0x0e80-0x0EBF NOT PRESENT */
	0xffff, /* 0x0ec0-0x0EFF NOT PRESENT */
	0xffff, /* 0x0f00-0x0F3F NOT PRESENT */
	0xffff, /* 0x0f40-0x0F7F NOT PRESENT */
	0xffff, /* 0x0f80-0x0FBF NOT PRESENT */
	0xffff, /* 0x0fc0-0x0FFF NOT PRESENT */
	0xffff, /* 0x1000-0x103F NOT PRESENT */
	0xffff, /* 0x1040-0x107F NOT PRESENT */
	0xffff, /* 0x1080-0x10BF NOT PRESENT */
	0xffff, /* 0x10c0-0x10FF NOT PRESENT */
	0xffff, /* 0x1100-0x113F NOT PRESENT */
	0xffff, /* 0x1140-0x117F NOT PRESENT */
	0xffff, /* 0x1180-0x11BF NOT PRESENT */
	0xffff, /* 0x11c0-0x11FF NOT PRESENT */
	0xffff, /* 0x1200-0x123F NOT PRESENT */
	0xffff, /* 0x1240-0x127F NOT PRESENT */
	0xffff, /* 0x1280-0x12BF NOT PRESENT */
	0xffff, /* 0x12c0-0x12FF NOT PRESENT */
	0xffff, /* 0x1300-0x133F NOT PRESENT */
	0xffff, /* 0x1340-0x137F NOT PRESENT */
	0xffff, /* 0x1380-0x13BF NOT PRESENT */
	0xffff, /* 0x13c0-0x13FF NOT PRESENT */
	0xffff, /* 0x1400-0x143F NOT PRESENT */
	0xffff, /* 0x1440-0x147F NOT PRESENT */
	0xffff, /* 0x1480-0x14BF NOT PRESENT */
	0xffff, /* 0x14c0-0x14FF NOT PRESENT */
	0xffff, /* 0x1500-0x153F NOT PRESENT */
	0xffff, /* 0x1540-0x157F NOT PRESENT */
	0xffff, /* 0x1580-0x15BF NOT PRESENT */
	0xffff, /* 0x15c0-0x15FF NOT PRESENT */
	0xffff, /* 0x1600-0x163F NOT PRESENT */
	0xffff, /* 0x1640-0x167F NOT PRESENT */
	0xffff, /* 0x1680-0x16BF NOT PRESENT */
	0xffff, /* 0x16c0-0x16FF NOT PRESENT */
	0xffff, /* 0x1700-0x173F NOT PRESENT */
	0xffff, /* 0x1740-0x177F NOT PRESENT */
	0xffff, /* 0x1780-0x17BF NOT PRESENT */
	0xffff, /* 0x17c0-0x17FF NOT PRESENT */
	0xffff, /* 0x1800-0x183F NOT PRESENT */
	0xffff, /* 0x1840-0x187F NOT PRESENT */
	0xffff, /* 0x1880-0x18BF NOT PRESENT */
	0xffff, /* 0x18c0-0x18FF NOT PRESENT */
	0xffff, /* 0x1900-0x193F NOT PRESENT */
	0xffff, /* 0x1940-0x197F NOT PRESENT */
	0xffff, /* 0x1980-0x19BF NOT PRESENT */
	0xffff, /* 0x19c0-0x19FF NOT PRESENT */
	0xffff, /* 0x1a00-0x1A3F NOT PRESENT */
	0xffff, /* 0x1a40-0x1A7F NOT PRESENT */
	0xffff, /* 0x1a80-0x1ABF NOT PRESENT */
	0xffff, /* 0x1ac0-0x1AFF NOT PRESENT */
	0xffff, /* 0x1b00-0x1B3F NOT PRESENT */
	0xffff, /* 0x1b40-0x1B7F NOT PRESENT */
	0xffff, /* 0x1b80-0x1BBF NOT PRESENT */
	0xffff, /* 0x1bc0-0x1BFF NOT PRESENT */
	0xffff, /* 0x1c00-0x1C3F NOT PRESENT */
	0xffff, /* 0x1c40-0x1C7F NOT PRESENT */
	0xffff, /* 0x1c80-0x1CBF NOT PRESENT */
	0xffff, /* 0x1cc0-0x1CFF NOT PRESENT */
	0xffff, /* 0x1d00-0x1D3F NOT PRESENT */
	0xffff, /* 0x1d40-0x1D7F NOT PRESENT */
	0xffff, /* 0x1d80-0x1DBF NOT PRESENT */
	0xffff, /* 0x1dc0-0x1DFF NOT PRESENT */
	0xffff, /* 0x1e00-0x1E3F NOT PRESENT */
	0xffff, /* 0x1e40-0x1E7F NOT PRESENT */
	0xffff, /* 0x1e80-0x1EBF NOT PRESENT */
	0xffff, /* 0x1ec0-0x1EFF NOT PRESENT */
	0xffff, /* 0x1f00-0x1F3F NOT PRESENT */
	0xffff, /* 0x1f40-0x1F7F NOT PRESENT */
	0xffff, /* 0x1f80-0x1FBF NOT PRESENT */
	0xffff, /* 0x1fc0-0x1FFF NOT PRESENT */
	0xffff, /* 0x2000-0x203F NOT PRESENT */
	0xffff, /* 0x2040-0x207F NOT PRESENT */
	0xffff, /* 0x2080-0x20BF NOT PRESENT */
	0xffff, /* 0x20c0-0x20FF NOT PRESENT */
	0xffff, /* 0x2100-0x213F NOT PRESENT */
	0xffff, /* 0x2140-0x217F NOT PRESENT */
	0xffff, /* 0x2180-0x21BF NOT PRESENT */
	0xffff, /* 0x21c0-0x21FF NOT PRESENT */
	0xffff, /* 0x2200-0x223F NOT PRESENT */
	0xffff, /* 0x2240-0x227F NOT PRESENT */
	0xffff, /* 0x2280-0x22BF NOT PRESENT */
	0xffff, /* 0x22c0-0x22FF NOT PRESENT */
	0xffff, /* 0x2300-0x233F NOT PRESENT */
	0xffff, /* 0x2340-0x237F NOT PRESENT */
	0xffff, /* 0x2380-0x23BF NOT PRESENT */
	0xffff, /* 0x23c0-0x23FF NOT PRESENT */
	0xffff, /* 0x2400-0x243F NOT PRESENT */
	0xffff, /* 0x2440-0x247F NOT PRESENT */
	0xffff, /* 0x2480-0x24BF NOT PRESENT */
	0xffff, /* 0x24c0-0x24FF NOT PRESENT */
	0xffff, /* 0x2500-0x253F NOT PRESENT */
	0xffff, /* 0x2540-0x257F NOT PRESENT */
	0xffff, /* 0x2580-0x25BF NOT PRESENT */
	0xffff, /* 0x25c0-0x25FF NOT PRESENT */
	0xffff, /* 0x2600-0x263F NOT PRESENT */
	0xffff, /* 0x2640-0x267F NOT PRESENT */
	0xffff, /* 0x2680-0x26BF NOT PRESENT */
	0xffff, /* 0x26c0-0x26FF NOT PRESENT */
	0xffff, /* 0x2700-0x273F NOT PRESENT */
	0xffff, /* 0x2740-0x277F NOT PRESENT */
	0xffff, /* 0x2780-0x27BF NOT PRESENT */
	0xffff, /* 0x27c0-0x27FF NOT PRESENT */
	0xffff, /* 0x2800-0x283F NOT PRESENT */
	0xffff, /* 0x2840-0x287F NOT PRESENT */
	0xffff, /* 0x2880-0x28BF NOT PRESENT */
	0xffff, /* 0x28c0-0x28FF NOT PRESENT */
	0xffff, /* 0x2900-0x293F NOT PRESENT */
	0xffff, /* 0x2940-0x297F NOT PRESENT */
	0xffff, /* 0x2980-0x29BF NOT PRESENT */
	0xffff, /* 0x29c0-0x29FF NOT PRESENT */
	0xffff, /* 0x2a00-0x2A3F NOT PRESENT */
	0xffff, /* 0x2a40-0x2A7F NOT PRESENT */
	0xffff, /* 0x2a80-0x2ABF NOT PRESENT */
	0xffff, /* 0x2ac0-0x2AFF NOT PRESENT */
	0xffff, /* 0x2b00-0x2B3F NOT PRESENT */
	0xffff, /* 0x2b40-0x2B7F NOT PRESENT */
	0xffff, /* 0x2b80-0x2BBF NOT PRESENT */
	0xffff, /* 0x2bc0-0x2BFF NOT PRESENT */
	0xffff, /* 0x2c00-0x2C3F NOT PRESENT */
	0xffff, /* 0x2c40-0x2C7F NOT PRESENT */
	0xffff, /* 0x2c80-0x2CBF NOT PRESENT */
	0xffff, /* 0x2cc0-0x2CFF NOT PRESENT */
	0xffff, /* 0x2d00-0x2D3F NOT PRESENT */
	0xffff, /* 0x2d40-0x2D7F NOT PRESENT */
	0xffff, /* 0x2d80-0x2DBF NOT PRESENT */
	0xffff, /* 0x2dc0-0x2DFF NOT PRESENT */
	0xffff, /* 0x2e00-0x2E3F NOT PRESENT */
	0xffff, /* 0x2e40-0x2E7F NOT PRESENT */
	0xffff, /* 0x2e80-0x2EBF NOT PRESENT */
	0xffff, /* 0x2ec0-0x2EFF NOT PRESENT */
	0xffff, /* 0x2f00-0x2F3F NOT PRESENT */
	0xffff, /* 0x2f40-0x2F7F NOT PRESENT */
	0xffff, /* 0x2f80-0x2FBF NOT PRESENT */
	0xffff, /* 0x2fc0-0x2FFF NOT PRESENT */
	0xffff, /* 0x3000-0x303F NOT PRESENT */
	0xffff, /* 0x3040-0x307F NOT PRESENT */
	0xffff, /* 0x3080-0x30BF NOT PRESENT */
	0xffff, /* 0x30c0-0x30FF NOT PRESENT */
	0xffff, /* 0x3100-0x313F NOT PRESENT */
	0xffff, /* 0x3140-0x317F NOT PRESENT */
	0xffff, /* 0x3180-0x31BF NOT PRESENT */
	0xffff, /* 0x31c0-0x31FF NOT PRESENT */
	0xffff, /* 0x3200-0x323F NOT PRESENT */
	0xffff, /* 0x3240-0x327F NOT PRESENT */
	0xffff, /* 0x3280-0x32BF NOT PRESENT */
	0xffff, /* 0x32c0-0x32FF NOT PRESENT */
	0xffff, /* 0x3300-0x333F NOT PRESENT */
	0xffff, /* 0x3340-0x337F NOT PRESENT */
	0xffff, /* 0x3380-0x33BF NOT PRESENT */
	0xffff, /* 0x33c0-0x33FF NOT PRESENT */
	0xffff, /* 0x3400-0x343F NOT PRESENT */
	0xffff, /* 0x3440-0x347F NOT PRESENT */
	0xffff, /* 0x3480-0x34BF NOT PRESENT */
	0xffff, /* 0x34c0-0x34FF NOT PRESENT */
	0xffff, /* 0x3500-0x353F NOT PRESENT */
	0xffff, /* 0x3540-0x357F NOT PRESENT */
	0xffff, /* 0x3580-0x35BF NOT PRESENT */
	0xffff, /* 0x35c0-0x35FF NOT PRESENT */
	0xffff, /* 0x3600-0x363F NOT PRESENT */
	0xffff, /* 0x3640-0x367F NOT PRESENT */
	0xffff, /* 0x3680-0x36BF NOT PRESENT */
	0xffff, /* 0x36c0-0x36FF NOT PRESENT */
	0xffff, /* 0x3700-0x373F NOT PRESENT */
	0xffff, /* 0x3740-0x377F NOT PRESENT */
	0xffff, /* 0x3780-0x37BF NOT PRESENT */
	0xffff, /* 0x37c0-0x37FF NOT PRESENT */
	0xffff, /* 0x3800-0x383F NOT PRESENT */
	0xffff, /* 0x3840-0x387F NOT PRESENT */
	0xffff, /* 0x3880-0x38BF NOT PRESENT */
	0xffff, /* 0x38c0-0x38FF NOT PRESENT */
	0xffff, /* 0x3900-0x393F NOT PRESENT */
	0xffff, /* 0x3940-0x397F NOT PRESENT */
	0xffff, /* 0x3980-0x39BF NOT PRESENT */
	0xffff, /* 0x39c0-0x39FF NOT PRESENT */
	0xffff, /* 0x3a00-0x3A3F NOT PRESENT */
	0xffff, /* 0x3a40-0x3A7F NOT PRESENT */
	0xffff, /* 0x3a80-0x3ABF NOT PRESENT */
	0xffff, /* 0x3ac0-0x3AFF NOT PRESENT */
	0xffff, /* 0x3b00-0x3B3F NOT PRESENT */
	0xffff, /* 0x3b40-0x3B7F NOT PRESENT */
	0xffff, /* 0x3b80-0x3BBF NOT PRESENT */
	0xffff, /* 0x3bc0-0x3BFF NOT PRESENT */
	0xffff, /* 0x3c00-0x3C3F NOT PRESENT */
	0xffff, /* 0x3c40-0x3C7F NOT PRESENT */
	0xffff, /* 0x3c80-0x3CBF NOT PRESENT */
	0xffff, /* 0x3cc0-0x3CFF NOT PRESENT */
	0xffff, /* 0x3d00-0x3D3F NOT PRESENT */
	0xffff, /* 0x3d40-0x3D7F NOT PRESENT */
	0xffff, /* 0x3d80-0x3DBF NOT PRESENT */
	0xffff, /* 0x3dc0-0x3DFF NOT PRESENT */
	0xffff, /* 0x3e00-0x3E3F NOT PRESENT */
	0xffff, /* 0x3e40-0x3E7F NOT PRESENT */
	0xffff, /* 0x3e80-0x3EBF NOT PRESENT */
	0xffff, /* 0x3ec0-0x3EFF NOT PRESENT */
	0xffff, /* 0x3f00-0x3F3F NOT PRESENT */
	0xffff, /* 0x3f40-0x3F7F NOT PRESENT */
	0xffff, /* 0x3f80-0x3FBF NOT PRESENT */
	0xffff, /* 0x3fc0-0x3FFF NOT PRESENT */
	0xffff, /* 0x4000-0x403F NOT PRESENT */
	0xffff, /* 0x4040-0x407F NOT PRESENT */
	0xffff, /* 0x4080-0x40BF NOT PRESENT */
	0xffff, /* 0x40c0-0x40FF NOT PRESENT */
	0xffff, /* 0x4100-0x413F NOT PRESENT */
	0xffff, /* 0x4140-0x417F NOT PRESENT */
	0xffff, /* 0x4180-0x41BF NOT PRESENT */
	0xffff, /* 0x41c0-0x41FF NOT PRESENT */
	0xffff, /* 0x4200-0x423F NOT PRESENT */
	0xffff, /* 0x4240-0x427F NOT PRESENT */
	0xffff, /* 0x4280-0x42BF NOT PRESENT */
	0xffff, /* 0x42c0-0x42FF NOT PRESENT */
	0xffff, /* 0x4300-0x433F NOT PRESENT */
	0xffff, /* 0x4340-0x437F NOT PRESENT */
	0xffff, /* 0x4380-0x43BF NOT PRESENT */
	0xffff, /* 0x43c0-0x43FF NOT PRESENT */
	0xffff, /* 0x4400-0x443F NOT PRESENT */
	0xffff, /* 0x4440-0x447F NOT PRESENT */
	0xffff, /* 0x4480-0x44BF NOT PRESENT */
	0xffff, /* 0x44c0-0x44FF NOT PRESENT */
	0xffff, /* 0x4500-0x453F NOT PRESENT */
	0xffff, /* 0x4540-0x457F NOT PRESENT */
	0xffff, /* 0x4580-0x45BF NOT PRESENT */
	0xffff, /* 0x45c0-0x45FF NOT PRESENT */
	0xffff, /* 0x4600-0x463F NOT PRESENT */
	0xffff, /* 0x4640-0x467F NOT PRESENT */
	0xffff, /* 0x4680-0x46BF NOT PRESENT */
	0xffff, /* 0x46c0-0x46FF NOT PRESENT */
	0xffff, /* 0x4700-0x473F NOT PRESENT */
	0xffff, /* 0x4740-0x477F NOT PRESENT */
	0xffff, /* 0x4780-0x47BF NOT PRESENT */
	0xffff, /* 0x47c0-0x47FF NOT PRESENT */
	0xffff, /* 0x4800-0x483F NOT PRESENT */
	0xffff, /* 0x4840-0x487F NOT PRESENT */
	0xffff, /* 0x4880-0x48BF NOT PRESENT */
	0xffff, /* 0x48c0-0x48FF NOT PRESENT */
	0xffff, /* 0x4900-0x493F NOT PRESENT */
	0xffff, /* 0x4940-0x497F NOT PRESENT */
	0xffff, /* 0x4980-0x49BF NOT PRESENT */
	0xffff, /* 0x49c0-0x49FF NOT PRESENT */
	0xffff, /* 0x4a00-0x4A3F NOT PRESENT */
	0xffff, /* 0x4a40-0x4A7F NOT PRESENT */
	0xffff, /* 0x4a80-0x4ABF NOT PRESENT */
	0xffff, /* 0x4ac0-0x4AFF NOT PRESENT */
	0xffff, /* 0x4b00-0x4B3F NOT PRESENT */
	0xffff, /* 0x4b40-0x4B7F NOT PRESENT */
	0xffff, /* 0x4b80-0x4BBF NOT PRESENT */
	0xffff, /* 0x4bc0-0x4BFF NOT PRESENT */
	0xffff, /* 0x4c00-0x4C3F NOT PRESENT */
	0xffff, /* 0x4c40-0x4C7F NOT PRESENT */
	0xffff, /* 0x4c80-0x4CBF NOT PRESENT */
	0xffff, /* 0x4cc0-0x4CFF NOT PRESENT */
	0xffff, /* 0x4d00-0x4D3F NOT PRESENT */
	0xffff, /* 0x4d40-0x4D7F NOT PRESENT */
	0xffff, /* 0x4d80-0x4DBF NOT PRESENT */
	0xffff, /* 0x4dc0-0x4DFF NOT PRESENT */
	0xffff, /* 0x4e00-0x4E3F NOT PRESENT */
	0xffff, /* 0x4e40-0x4E7F NOT PRESENT */
	0xffff, /* 0x4e80-0x4EBF NOT PRESENT */
	0xffff, /* 0x4ec0-0x4EFF NOT PRESENT */
	0xffff, /* 0x4f00-0x4F3F NOT PRESENT */
	0xffff, /* 0x4f40-0x4F7F NOT PRESENT */
	0xffff, /* 0x4f80-0x4FBF NOT PRESENT */
	0xffff, /* 0x4fc0-0x4FFF NOT PRESENT */
	0xffff, /* 0x5000-0x503F NOT PRESENT */
	0xffff, /* 0x5040-0x507F NOT PRESENT */
	0xffff, /* 0x5080-0x50BF NOT PRESENT */
	0xffff, /* 0x50c0-0x50FF NOT PRESENT */
	0xffff, /* 0x5100-0x513F NOT PRESENT */
	0xffff, /* 0x5140-0x517F NOT PRESENT */
	0xffff, /* 0x5180-0x51BF NOT PRESENT */
	0xffff, /* 0x51c0-0x51FF NOT PRESENT */
	0xffff, /* 0x5200-0x523F NOT PRESENT */
	0xffff, /* 0x5240-0x527F NOT PRESENT */
	0xffff, /* 0x5280-0x52BF NOT PRESENT */
	0xffff, /* 0x52c0-0x52FF NOT PRESENT */
	0xffff, /* 0x5300-0x533F NOT PRESENT */
	0xffff, /* 0x5340-0x537F NOT PRESENT */
	0xffff, /* 0x5380-0x53BF NOT PRESENT */
	0xffff, /* 0x53c0-0x53FF NOT PRESENT */
	0xffff, /* 0x5400-0x543F NOT PRESENT */
	0xffff, /* 0x5440-0x547F NOT PRESENT */
	0xffff, /* 0x5480-0x54BF NOT PRESENT */
	0xffff, /* 0x54c0-0x54FF NOT PRESENT */
	0xffff, /* 0x5500-0x553F NOT PRESENT */
	0xffff, /* 0x5540-0x557F NOT PRESENT */
	0xffff, /* 0x5580-0x55BF NOT PRESENT */
	0xffff, /* 0x55c0-0x55FF NOT PRESENT */
	0xffff, /* 0x5600-0x563F NOT PRESENT */
	0xffff, /* 0x5640-0x567F NOT PRESENT */
	0xffff, /* 0x5680-0x56BF NOT PRESENT */
	0xffff, /* 0x56c0-0x56FF NOT PRESENT */
	0xffff, /* 0x5700-0x573F NOT PRESENT */
	0xffff, /* 0x5740-0x577F NOT PRESENT */
	0xffff, /* 0x5780-0x57BF NOT PRESENT */
	0xffff, /* 0x57c0-0x57FF NOT PRESENT */
	0xffff, /* 0x5800-0x583F NOT PRESENT */
	0xffff, /* 0x5840-0x587F NOT PRESENT */
	0xffff, /* 0x5880-0x58BF NOT PRESENT */
	0xffff, /* 0x58c0-0x58FF NOT PRESENT */
	0xffff, /* 0x5900-0x593F NOT PRESENT */
	0xffff, /* 0x5940-0x597F NOT PRESENT */
	0xffff, /* 0x5980-0x59BF NOT PRESENT */
	0xffff, /* 0x59c0-0x59FF NOT PRESENT */
	0xffff, /* 0x5a00-0x5A3F NOT PRESENT */
	0xffff, /* 0x5a40-0x5A7F NOT PRESENT */
	0xffff, /* 0x5a80-0x5ABF NOT PRESENT */
	0xffff, /* 0x5ac0-0x5AFF NOT PRESENT */
	0xffff, /* 0x5b00-0x5B3F NOT PRESENT */
	0xffff, /* 0x5b40-0x5B7F NOT PRESENT */
	0xffff, /* 0x5b80-0x5BBF NOT PRESENT */
	0xffff, /* 0x5bc0-0x5BFF NOT PRESENT */
	0xffff, /* 0x5c00-0x5C3F NOT PRESENT */
	0xffff, /* 0x5c40-0x5C7F NOT PRESENT */
	0xffff, /* 0x5c80-0x5CBF NOT PRESENT */
	0xffff, /* 0x5cc0-0x5CFF NOT PRESENT */
	0xffff, /* 0x5d00-0x5D3F NOT PRESENT */
	0xffff, /* 0x5d40-0x5D7F NOT PRESENT */
	0xffff, /* 0x5d80-0x5DBF NOT PRESENT */
	0xffff, /* 0x5dc0-0x5DFF NOT PRESENT */
	0xffff, /* 0x5e00-0x5E3F NOT PRESENT */
	0xffff, /* 0x5e40-0x5E7F NOT PRESENT */
	0xffff, /* 0x5e80-0x5EBF NOT PRESENT */
	0xffff, /* 0x5ec0-0x5EFF NOT PRESENT */
	0xffff, /* 0x5f00-0x5F3F NOT PRESENT */
	0xffff, /* 0x5f40-0x5F7F NOT PRESENT */
	0xffff, /* 0x5f80-0x5FBF NOT PRESENT */
	0xffff, /* 0x5fc0-0x5FFF NOT PRESENT */
	0xffff, /* 0x6000-0x603F NOT PRESENT */
	0xffff, /* 0x6040-0x607F NOT PRESENT */
	0xffff, /* 0x6080-0x60BF NOT PRESENT */
	0xffff, /* 0x60c0-0x60FF NOT PRESENT */
	0xffff, /* 0x6100-0x613F NOT PRESENT */
	0xffff, /* 0x6140-0x617F NOT PRESENT */
	0xffff, /* 0x6180-0x61BF NOT PRESENT */
	0xffff, /* 0x61c0-0x61FF NOT PRESENT */
	0xffff, /* 0x6200-0x623F NOT PRESENT */
	0xffff, /* 0x6240-0x627F NOT PRESENT */
	0xffff, /* 0x6280-0x62BF NOT PRESENT */
	0xffff, /* 0x62c0-0x62FF NOT PRESENT */
	0xffff, /* 0x6300-0x633F NOT PRESENT */
	0xffff, /* 0x6340-0x637F NOT PRESENT */
	0xffff, /* 0x6380-0x63BF NOT PRESENT */
	0xffff, /* 0x63c0-0x63FF NOT PRESENT */
	0xffff, /* 0x6400-0x643F NOT PRESENT */
	0xffff, /* 0x6440-0x647F NOT PRESENT */
	0xffff, /* 0x6480-0x64BF NOT PRESENT */
	0xffff, /* 0x64c0-0x64FF NOT PRESENT */
	0xffff, /* 0x6500-0x653F NOT PRESENT */
	0xffff, /* 0x6540-0x657F NOT PRESENT */
	0xffff, /* 0x6580-0x65BF NOT PRESENT */
	0xffff, /* 0x65c0-0x65FF NOT PRESENT */
	0xffff, /* 0x6600-0x663F NOT PRESENT */
	0xffff, /* 0x6640-0x667F NOT PRESENT */
	0xffff, /* 0x6680-0x66BF NOT PRESENT */
	0xffff, /* 0x66c0-0x66FF NOT PRESENT */
	0xffff, /* 0x6700-0x673F NOT PRESENT */
	0xffff, /* 0x6740-0x677F NOT PRESENT */
	0xffff, /* 0x6780-0x67BF NOT PRESENT */
	0xffff, /* 0x67c0-0x67FF NOT PRESENT */
	0xffff, /* 0x6800-0x683F NOT PRESENT */
	0xffff, /* 0x6840-0x687F NOT PRESENT */
	0xffff, /* 0x6880-0x68BF NOT PRESENT */
	0xffff, /* 0x68c0-0x68FF NOT PRESENT */
	0xffff, /* 0x6900-0x693F NOT PRESENT */
	0xffff, /* 0x6940-0x697F NOT PRESENT */
	0xffff, /* 0x6980-0x69BF NOT PRESENT */
	0xffff, /* 0x69c0-0x69FF NOT PRESENT */
	0xffff, /* 0x6a00-0x6A3F NOT PRESENT */
	0xffff, /* 0x6a40-0x6A7F NOT PRESENT */
	0xffff, /* 0x6a80-0x6ABF NOT PRESENT */
	0xffff, /* 0x6ac0-0x6AFF NOT PRESENT */
	0xffff, /* 0x6b00-0x6B3F NOT PRESENT */
	0xffff, /* 0x6b40-0x6B7F NOT PRESENT */
	0xffff, /* 0x6b80-0x6BBF NOT PRESENT */
	0xffff, /* 0x6bc0-0x6BFF NOT PRESENT */
	0xffff, /* 0x6c00-0x6C3F NOT PRESENT */
	0xffff, /* 0x6c40-0x6C7F NOT PRESENT */
	0xffff, /* 0x6c80-0x6CBF NOT PRESENT */
	0xffff, /* 0x6cc0-0x6CFF NOT PRESENT */
	0xffff, /* 0x6d00-0x6D3F NOT PRESENT */
	0xffff, /* 0x6d40-0x6D7F NOT PRESENT */
	0xffff, /* 0x6d80-0x6DBF NOT PRESENT */
	0xffff, /* 0x6dc0-0x6DFF NOT PRESENT */
	0xffff, /* 0x6e00-0x6E3F NOT PRESENT */
	0xffff, /* 0x6e40-0x6E7F NOT PRESENT */
	0xffff, /* 0x6e80-0x6EBF NOT PRESENT */
	0xffff, /* 0x6ec0-0x6EFF NOT PRESENT */
	0xffff, /* 0x6f00-0x6F3F NOT PRESENT */
	0xffff, /* 0x6f40-0x6F7F NOT PRESENT */
	0xffff, /* 0x6f80-0x6FBF NOT PRESENT */
	0xffff, /* 0x6fc0-0x6FFF NOT PRESENT */
	0xffff, /* 0x7000-0x703F NOT PRESENT */
	0xffff, /* 0x7040-0x707F NOT PRESENT */
	0xffff, /* 0x7080-0x70BF NOT PRESENT */
	0xffff, /* 0x70c0-0x70FF NOT PRESENT */
	0xffff, /* 0x7100-0x713F NOT PRESENT */
	0xffff, /* 0x7140-0x717F NOT PRESENT */
	0xffff, /* 0x7180-0x71BF NOT PRESENT */
	0xffff, /* 0x71c0-0x71FF NOT PRESENT */
	0xffff, /* 0x7200-0x723F NOT PRESENT */
	0xffff, /* 0x7240-0x727F NOT PRESENT */
	0xffff, /* 0x7280-0x72BF NOT PRESENT */
	0xffff, /* 0x72c0-0x72FF NOT PRESENT */
	0xffff, /* 0x7300-0x733F NOT PRESENT */
	0xffff, /* 0x7340-0x737F NOT PRESENT */
	0xffff, /* 0x7380-0x73BF NOT PRESENT */
	0xffff, /* 0x73c0-0x73FF NOT PRESENT */
	0xffff, /* 0x7400-0x743F NOT PRESENT */
	0xffff, /* 0x7440-0x747F NOT PRESENT */
	0xffff, /* 0x7480-0x74BF NOT PRESENT */
	0xffff, /* 0x74c0-0x74FF NOT PRESENT */
	0xffff, /* 0x7500-0x753F NOT PRESENT */
	0xffff, /* 0x7540-0x757F NOT PRESENT */
	0xffff, /* 0x7580-0x75BF NOT PRESENT */
	0xffff, /* 0x75c0-0x75FF NOT PRESENT */
	0xffff, /* 0x7600-0x763F NOT PRESENT */
	0xffff, /* 0x7640-0x767F NOT PRESENT */
	0xffff, /* 0x7680-0x76BF NOT PRESENT */
	0xffff, /* 0x76c0-0x76FF NOT PRESENT */
	0xffff, /* 0x7700-0x773F NOT PRESENT */
	0xffff, /* 0x7740-0x777F NOT PRESENT */
	0xffff, /* 0x7780-0x77BF NOT PRESENT */
	0xffff, /* 0x77c0-0x77FF NOT PRESENT */
	0xffff, /* 0x7800-0x783F NOT PRESENT */
	0xffff, /* 0x7840-0x787F NOT PRESENT */
	0xffff, /* 0x7880-0x78BF NOT PRESENT */
	0xffff, /* 0x78c0-0x78FF NOT PRESENT */
	0xffff, /* 0x7900-0x793F NOT PRESENT */
	0xffff, /* 0x7940-0x797F NOT PRESENT */
	0xffff, /* 0x7980-0x79BF NOT PRESENT */
	0xffff, /* 0x79c0-0x79FF NOT PRESENT */
	0xffff, /* 0x7a00-0x7A3F NOT PRESENT */
	0xffff, /* 0x7a40-0x7A7F NOT PRESENT */
	0xffff, /* 0x7a80-0x7ABF NOT PRESENT */
	0xffff, /* 0x7ac0-0x7AFF NOT PRESENT */
	0xffff, /* 0x7b00-0x7B3F NOT PRESENT */
	0xffff, /* 0x7b40-0x7B7F NOT PRESENT */
	0xffff, /* 0x7b80-0x7BBF NOT PRESENT */
	0xffff, /* 0x7bc0-0x7BFF NOT PRESENT */
	0xffff, /* 0x7c00-0x7C3F NOT PRESENT */
	0xffff, /* 0x7c40-0x7C7F NOT PRESENT */
	0xffff, /* 0x7c80-0x7CBF NOT PRESENT */
	0xffff, /* 0x7cc0-0x7CFF NOT PRESENT */
	0xffff, /* 0x7d00-0x7D3F NOT PRESENT */
	0xffff, /* 0x7d40-0x7D7F NOT PRESENT */
	0xffff, /* 0x7d80-0x7DBF NOT PRESENT */
	0xffff, /* 0x7dc0-0x7DFF NOT PRESENT */
	0xffff, /* 0x7e00-0x7E3F NOT PRESENT */
	0xffff, /* 0x7e40-0x7E7F NOT PRESENT */
	0xffff, /* 0x7e80-0x7EBF NOT PRESENT */
	0xffff, /* 0x7ec0-0x7EFF NOT PRESENT */
	0xffff, /* 0x7f00-0x7F3F NOT PRESENT */
	0xffff, /* 0x7f40-0x7F7F NOT PRESENT */
	0xffff, /* 0x7f80-0x7FBF NOT PRESENT */
	0xffff, /* 0x7fc0-0x7FFF NOT PRESENT */
	0xffff, /* 0x8000-0x803F NOT PRESENT */
	0xffff, /* 0x8040-0x807F NOT PRESENT */
	0xffff, /* 0x8080-0x80BF NOT PRESENT */
	0xffff, /* 0x80c0-0x80FF NOT PRESENT */
	0xffff, /* 0x8100-0x813F NOT PRESENT */
	0x0100, /* 0x8140-0x817F */
	0x0140, /* 0x8180-0x81BF */
	0x0180, /* 0x81c0-0x81FF */
	0xffff, /* 0x8200-0x823F NOT PRESENT */
	0x01c0, /* 0x8240-0x827F */
	0x0200, /* 0x8280-0x82BF */
	0x0240, /* 0x82c0-0x82FF */
	0xffff, /* 0x8300-0x833F NOT PRESENT */
	0x0280, /* 0x8340-0x837F */
	0x02c0, /* 0x8380-0x83BF */
	0x0300, /* 0x83c0-0x83FF */
	0xffff, /* 0x8400-0x843F NOT PRESENT */
	0x0340, /* 0x8440-0x847F */
	0x0380, /* 0x8480-0x84BF */
	0xffff, /* 0x84c0-0x84FF NOT PRESENT */
	0xffff, /* 0x8500-0x853F NOT PRESENT */
	0xffff, /* 0x8540-0x857F NOT PRESENT */
	0xffff, /* 0x8580-0x85BF NOT PRESENT */
	0xffff, /* 0x85c0-0x85FF NOT PRESENT */
	0xffff, /* 0x8600-0x863F NOT PRESENT */
	0xffff, /* 0x8640-0x867F NOT PRESENT */
	0xffff, /* 0x8680-0x86BF NOT PRESENT */
	0xffff, /* 0x86c0-0x86FF NOT PRESENT */
	0xffff, /* 0x8700-0x873F NOT PRESENT */
	0x03c0, /* 0x8740-0x877F */
	0x0400, /* 0x8780-0x87BF */
	0xffff, /* 0x87c0-0x87FF NOT PRESENT */
	0xffff, /* 0x8800-0x883F NOT PRESENT */
	0xffff, /* 0x8840-0x887F NOT PRESENT */
	0x0440, /* 0x8880-0x88BF */
	0x0480, /* 0x88c0-0x88FF */
	0xffff, /* 0x8900-0x893F NOT PRESENT */
	0x04c0, /* 0x8940-0x897F */
	0x0500, /* 0x8980-0x89BF */
	0x0540, /* 0x89c0-0x89FF */
	0xffff, /* 0x8a00-0x8A3F NOT PRESENT */
	0x0580, /* 0x8a40-0x8A7F */
	0x05c0, /* 0x8a80-0x8ABF */
	0x0600, /* 0x8ac0-0x8AFF */
	0xffff, /* 0x8b00-0x8B3F NOT PRESENT */
	0x0640, /* 0x8b40-0x8B7F */
	0x0680, /* 0x8b80-0x8BBF */
	0x06c0, /* 0x8bc0-0x8BFF */
	0xffff, /* 0x8c00-0x8C3F NOT PRESENT */
	0x0700, /* 0x8c40-0x8C7F */
	0x0740, /* 0x8c80-0x8CBF */
	0x0780, /* 0x8cc0-0x8CFF */
	0xffff, /* 0x8d00-0x8D3F NOT PRESENT */
	0x07c0, /* 0x8d40-0x8D7F */
	0x0800, /* 0x8d80-0x8DBF */
	0x0840, /* 0x8dc0-0x8DFF */
	0xffff, /* 0x8e00-0x8E3F NOT PRESENT */
	0x0880, /* 0x8e40-0x8E7F */
	0x08c0, /* 0x8e80-0x8EBF */
	0x0900, /* 0x8ec0-0x8EFF */
	0xffff, /* 0x8f00-0x8F3F NOT PRESENT */
	0x0940, /* 0x8f40-0x8F7F */
	0x0980, /* 0x8f80-0x8FBF */
	0x09c0, /* 0x8fc0-0x8FFF */
	0xffff, /* 0x9000-0x903F NOT PRESENT */
	0x0a00, /* 0x9040-0x907F */
	0x0a40, /* 0x9080-0x90BF */
	0x0a80, /* 0x90c0-0x90FF */
	0xffff, /* 0x9100-0x913F NOT PRESENT */
	0x0ac0, /* 0x9140-0x917F */
	0x0b00, /* 0x9180-0x91BF */
	0x0b40, /* 0x91c0-0x91FF */
	0xffff, /* 0x9200-0x923F NOT PRESENT */
	0x0b80, /* 0x9240-0x927F */
	0x0bc0, /* 0x9280-0x92BF */
	0x0c00, /* 0x92c0-0x92FF */
	0xffff, /* 0x9300-0x933F NOT PRESENT */
	0x0c40, /* 0x9340-0x937F */
	0x0c80, /* 0x9380-0x93BF */
	0x0cc0, /* 0x93c0-0x93FF */
	0xffff, /* 0x9400-0x943F NOT PRESENT */
	0x0d00, /* 0x9440-0x947F */
	0x0d40, /* 0x9480-0x94BF */
	0x0d80, /* 0x94c0-0x94FF */
	0xffff, /* 0x9500-0x953F NOT PRESENT */
	0x0dc0, /* 0x9540-0x957F */
	0x0e00, /* 0x9580-0x95BF */
	0x0e40, /* 0x95c0-0x95FF */
	0xffff, /* 0x9600-0x963F NOT PRESENT */
	0x0e80, /* 0x9640-0x967F */
	0x0ec0, /* 0x9680-0x96BF */
	0x0f00, /* 0x96c0-0x96FF */
	0xffff, /* 0x9700-0x973F NOT PRESENT */
	0x0f40, /* 0x9740-0x977F */
	0x0f80, /* 0x9780-0x97BF */
	0x0fc0, /* 0x97c0-0x97FF */
	0xffff, /* 0x9800-0x983F NOT PRESENT */
	0x1000, /* 0x9840-0x987F */
	0x1040, /* 0x9880-0x98BF */
	0x1080, /* 0x98c0-0x98FF */
	0xffff, /* 0x9900-0x993F NOT PRESENT */
	0x10c0, /* 0x9940-0x997F */
	0x1100, /* 0x9980-0x99BF */
	0x1140, /* 0x99c0-0x99FF */
	0xffff, /* 0x9a00-0x9A3F NOT PRESENT */
	0x1180, /* 0x9a40-0x9A7F */
	0x11c0, /* 0x9a80-0x9ABF */
	0x1200, /* 0x9ac0-0x9AFF */
	0xffff, /* 0x9b00-0x9B3F NOT PRESENT */
	0x1240, /* 0x9b40-0x9B7F */
	0x1280, /* 0x9b80-0x9BBF */
	0x12c0, /* 0x9bc0-0x9BFF */
	0xffff, /* 0x9c00-0x9C3F NOT PRESENT */
	0x1300, /* 0x9c40-0x9C7F */
	0x1340, /* 0x9c80-0x9CBF */
	0x1380, /* 0x9cc0-0x9CFF */
	0xffff, /* 0x9d00-0x9D3F NOT PRESENT */
	0x13c0, /* 0x9d40-0x9D7F */
	0x1400, /* 0x9d80-0x9DBF */
	0x1440, /* 0x9dc0-0x9DFF */
	0xffff, /* 0x9e00-0x9E3F NOT PRESENT */
	0x1480, /* 0x9e40-0x9E7F */
	0x14c0, /* 0x9e80-0x9EBF */
	0x1500, /* 0x9ec0-0x9EFF */
	0xffff, /* 0x9f00-0x9F3F NOT PRESENT */
	0x1540, /* 0x9f40-0x9F7F */
	0x1580, /* 0x9f80-0x9FBF */
	0x15c0, /* 0x9fc0-0x9FFF */
	0xffff, /* 0xa000-0xA03F NOT PRESENT */
	0xffff, /* 0xa040-0xA07F NOT PRESENT */
	0xffff, /* 0xa080-0xA0BF NOT PRESENT */
	0xffff, /* 0xa0c0-0xA0FF NOT PRESENT */
	0xffff, /* 0xa100-0xA13F NOT PRESENT */
	0xffff, /* 0xa140-0xA17F NOT PRESENT */
	0xffff, /* 0xa180-0xA1BF NOT PRESENT */
	0xffff, /* 0xa1c0-0xA1FF NOT PRESENT */
	0xffff, /* 0xa200-0xA23F NOT PRESENT */
	0xffff, /* 0xa240-0xA27F NOT PRESENT */
	0xffff, /* 0xa280-0xA2BF NOT PRESENT */
	0xffff, /* 0xa2c0-0xA2FF NOT PRESENT */
	0xffff, /* 0xa300-0xA33F NOT PRESENT */
	0xffff, /* 0xa340-0xA37F NOT PRESENT */
	0xffff, /* 0xa380-0xA3BF NOT PRESENT */
	0xffff, /* 0xa3c0-0xA3FF NOT PRESENT */
	0xffff, /* 0xa400-0xA43F NOT PRESENT */
	0xffff, /* 0xa440-0xA47F NOT PRESENT */
	0xffff, /* 0xa480-0xA4BF NOT PRESENT */
	0xffff, /* 0xa4c0-0xA4FF NOT PRESENT */
	0xffff, /* 0xa500-0xA53F NOT PRESENT */
	0xffff, /* 0xa540-0xA57F NOT PRESENT */
	0xffff, /* 0xa580-0xA5BF NOT PRESENT */
	0xffff, /* 0xa5c0-0xA5FF NOT PRESENT */
	0xffff, /* 0xa600-0xA63F NOT PRESENT */
	0xffff, /* 0xa640-0xA67F NOT PRESENT */
	0xffff, /* 0xa680-0xA6BF NOT PRESENT */
	0xffff, /* 0xa6c0-0xA6FF NOT PRESENT */
	0xffff, /* 0xa700-0xA73F NOT PRESENT */
	0xffff, /* 0xa740-0xA77F NOT PRESENT */
	0xffff, /* 0xa780-0xA7BF NOT PRESENT */
	0xffff, /* 0xa7c0-0xA7FF NOT PRESENT */
	0xffff, /* 0xa800-0xA83F NOT PRESENT */
	0xffff, /* 0xa840-0xA87F NOT PRESENT */
	0xffff, /* 0xa880-0xA8BF NOT PRESENT */
	0xffff, /* 0xa8c0-0xA8FF NOT PRESENT */
	0xffff, /* 0xa900-0xA93F NOT PRESENT */
	0xffff, /* 0xa940-0xA97F NOT PRESENT */
	0xffff, /* 0xa980-0xA9BF NOT PRESENT */
	0xffff, /* 0xa9c0-0xA9FF NOT PRESENT */
	0xffff, /* 0xaa00-0xAA3F NOT PRESENT */
	0xffff, /* 0xaa40-0xAA7F NOT PRESENT */
	0xffff, /* 0xaa80-0xAABF NOT PRESENT */
	0xffff, /* 0xaac0-0xAAFF NOT PRESENT */
	0xffff, /* 0xab00-0xAB3F NOT PRESENT */
	0xffff, /* 0xab40-0xAB7F NOT PRESENT */
	0xffff, /* 0xab80-0xABBF NOT PRESENT */
	0xffff, /* 0xabc0-0xABFF NOT PRESENT */
	0xffff, /* 0xac00-0xAC3F NOT PRESENT */
	0xffff, /* 0xac40-0xAC7F NOT PRESENT */
	0xffff, /* 0xac80-0xACBF NOT PRESENT */
	0xffff, /* 0xacc0-0xACFF NOT PRESENT */
	0xffff, /* 0xad00-0xAD3F NOT PRESENT */
	0xffff, /* 0xad40-0xAD7F NOT PRESENT */
	0xffff, /* 0xad80-0xADBF NOT PRESENT */
	0xffff, /* 0xadc0-0xADFF NOT PRESENT */
	0xffff, /* 0xae00-0xAE3F NOT PRESENT */
	0xffff, /* 0xae40-0xAE7F NOT PRESENT */
	0xffff, /* 0xae80-0xAEBF NOT PRESENT */
	0xffff, /* 0xaec0-0xAEFF NOT PRESENT */
	0xffff, /* 0xaf00-0xAF3F NOT PRESENT */
	0xffff, /* 0xaf40-0xAF7F NOT PRESENT */
	0xffff, /* 0xaf80-0xAFBF NOT PRESENT */
	0xffff, /* 0xafc0-0xAFFF NOT PRESENT */
	0xffff, /* 0xb000-0xB03F NOT PRESENT */
	0xffff, /* 0xb040-0xB07F NOT PRESENT */
	0xffff, /* 0xb080-0xB0BF NOT PRESENT */
	0xffff, /* 0xb0c0-0xB0FF NOT PRESENT */
	0xffff, /* 0xb100-0xB13F NOT PRESENT */
	0xffff, /* 0xb140-0xB17F NOT PRESENT */
	0xffff, /* 0xb180-0xB1BF NOT PRESENT */
	0xffff, /* 0xb1c0-0xB1FF NOT PRESENT */
	0xffff, /* 0xb200-0xB23F NOT PRESENT */
	0xffff, /* 0xb240-0xB27F NOT PRESENT */
	0xffff, /* 0xb280-0xB2BF NOT PRESENT */
	0xffff, /* 0xb2c0-0xB2FF NOT PRESENT */
	0xffff, /* 0xb300-0xB33F NOT PRESENT */
	0xffff, /* 0xb340-0xB37F NOT PRESENT */
	0xffff, /* 0xb380-0xB3BF NOT PRESENT */
	0xffff, /* 0xb3c0-0xB3FF NOT PRESENT */
	0xffff, /* 0xb400-0xB43F NOT PRESENT */
	0xffff, /* 0xb440-0xB47F NOT PRESENT */
	0xffff, /* 0xb480-0xB4BF NOT PRESENT */
	0xffff, /* 0xb4c0-0xB4FF NOT PRESENT */
	0xffff, /* 0xb500-0xB53F NOT PRESENT */
	0xffff, /* 0xb540-0xB57F NOT PRESENT */
	0xffff, /* 0xb580-0xB5BF NOT PRESENT */
	0xffff, /* 0xb5c0-0xB5FF NOT PRESENT */
	0xffff, /* 0xb600-0xB63F NOT PRESENT */
	0xffff, /* 0xb640-0xB67F NOT PRESENT */
	0xffff, /* 0xb680-0xB6BF NOT PRESENT */
	0xffff, /* 0xb6c0-0xB6FF NOT PRESENT */
	0xffff, /* 0xb700-0xB73F NOT PRESENT */
	0xffff, /* 0xb740-0xB77F NOT PRESENT */
	0xffff, /* 0xb780-0xB7BF NOT PRESENT */
	0xffff, /* 0xb7c0-0xB7FF NOT PRESENT */
	0xffff, /* 0xb800-0xB83F NOT PRESENT */
	0xffff, /* 0xb840-0xB87F NOT PRESENT */
	0xffff, /* 0xb880-0xB8BF NOT PRESENT */
	0xffff, /* 0xb8c0-0xB8FF NOT PRESENT */
	0xffff, /* 0xb900-0xB93F NOT PRESENT */
	0xffff, /* 0xb940-0xB97F NOT PRESENT */
	0xffff, /* 0xb980-0xB9BF NOT PRESENT */
	0xffff, /* 0xb9c0-0xB9FF NOT PRESENT */
	0xffff, /* 0xba00-0xBA3F NOT PRESENT */
	0xffff, /* 0xba40-0xBA7F NOT PRESENT */
	0xffff, /* 0xba80-0xBABF NOT PRESENT */
	0xffff, /* 0xbac0-0xBAFF NOT PRESENT */
	0xffff, /* 0xbb00-0xBB3F NOT PRESENT */
	0xffff, /* 0xbb40-0xBB7F NOT PRESENT */
	0xffff, /* 0xbb80-0xBBBF NOT PRESENT */
	0xffff, /* 0xbbc0-0xBBFF NOT PRESENT */
	0xffff, /* 0xbc00-0xBC3F NOT PRESENT */
	0xffff, /* 0xbc40-0xBC7F NOT PRESENT */
	0xffff, /* 0xbc80-0xBCBF NOT PRESENT */
	0xffff, /* 0xbcc0-0xBCFF NOT PRESENT */
	0xffff, /* 0xbd00-0xBD3F NOT PRESENT */
	0xffff, /* 0xbd40-0xBD7F NOT PRESENT */
	0xffff, /* 0xbd80-0xBDBF NOT PRESENT */
	0xffff, /* 0xbdc0-0xBDFF NOT PRESENT */
	0xffff, /* 0xbe00-0xBE3F NOT PRESENT */
	0xffff, /* 0xbe40-0xBE7F NOT PRESENT */
	0xffff, /* 0xbe80-0xBEBF NOT PRESENT */
	0xffff, /* 0xbec0-0xBEFF NOT PRESENT */
	0xffff, /* 0xbf00-0xBF3F NOT PRESENT */
	0xffff, /* 0xbf40-0xBF7F NOT PRESENT */
	0xffff, /* 0xbf80-0xBFBF NOT PRESENT */
	0xffff, /* 0xbfc0-0xBFFF NOT PRESENT */
	0xffff, /* 0xc000-0xC03F NOT PRESENT */
	0xffff, /* 0xc040-0xC07F NOT PRESENT */
	0xffff, /* 0xc080-0xC0BF NOT PRESENT */
	0xffff, /* 0xc0c0-0xC0FF NOT PRESENT */
	0xffff, /* 0xc100-0xC13F NOT PRESENT */
	0xffff, /* 0xc140-0xC17F NOT PRESENT */
	0xffff, /* 0xc180-0xC1BF NOT PRESENT */
	0xffff, /* 0xc1c0-0xC1FF NOT PRESENT */
	0xffff, /* 0xc200-0xC23F NOT PRESENT */
	0xffff, /* 0xc240-0xC27F NOT PRESENT */
	0xffff, /* 0xc280-0xC2BF NOT PRESENT */
	0xffff, /* 0xc2c0-0xC2FF NOT PRESENT */
	0xffff, /* 0xc300-0xC33F NOT PRESENT */
	0xffff, /* 0xc340-0xC37F NOT PRESENT */
	0xffff, /* 0xc380-0xC3BF NOT PRESENT */
	0xffff, /* 0xc3c0-0xC3FF NOT PRESENT */
	0xffff, /* 0xc400-0xC43F NOT PRESENT */
	0xffff, /* 0xc440-0xC47F NOT PRESENT */
	0xffff, /* 0xc480-0xC4BF NOT PRESENT */
	0xffff, /* 0xc4c0-0xC4FF NOT PRESENT */
	0xffff, /* 0xc500-0xC53F NOT PRESENT */
	0xffff, /* 0xc540-0xC57F NOT PRESENT */
	0xffff, /* 0xc580-0xC5BF NOT PRESENT */
	0xffff, /* 0xc5c0-0xC5FF NOT PRESENT */
	0xffff, /* 0xc600-0xC63F NOT PRESENT */
	0xffff, /* 0xc640-0xC67F NOT PRESENT */
	0xffff, /* 0xc680-0xC6BF NOT PRESENT */
	0xffff, /* 0xc6c0-0xC6FF NOT PRESENT */
	0xffff, /* 0xc700-0xC73F NOT PRESENT */
	0xffff, /* 0xc740-0xC77F NOT PRESENT */
	0xffff, /* 0xc780-0xC7BF NOT PRESENT */
	0xffff, /* 0xc7c0-0xC7FF NOT PRESENT */
	0xffff, /* 0xc800-0xC83F NOT PRESENT */
	0xffff, /* 0xc840-0xC87F NOT PRESENT */
	0xffff, /* 0xc880-0xC8BF NOT PRESENT */
	0xffff, /* 0xc8c0-0xC8FF NOT PRESENT */
	0xffff, /* 0xc900-0xC93F NOT PRESENT */
	0xffff, /* 0xc940-0xC97F NOT PRESENT */
	0xffff, /* 0xc980-0xC9BF NOT PRESENT */
	0xffff, /* 0xc9c0-0xC9FF NOT PRESENT */
	0xffff, /* 0xca00-0xCA3F NOT PRESENT */
	0xffff, /* 0xca40-0xCA7F NOT PRESENT */
	0xffff, /* 0xca80-0xCABF NOT PRESENT */
	0xffff, /* 0xcac0-0xCAFF NOT PRESENT */
	0xffff, /* 0xcb00-0xCB3F NOT PRESENT */
	0xffff, /* 0xcb40-0xCB7F NOT PRESENT */
	0xffff, /* 0xcb80-0xCBBF NOT PRESENT */
	0xffff, /* 0xcbc0-0xCBFF NOT PRESENT */
	0xffff, /* 0xcc00-0xCC3F NOT PRESENT */
	0xffff, /* 0xcc40-0xCC7F NOT PRESENT */
	0xffff, /* 0xcc80-0xCCBF NOT PRESENT */
	0xffff, /* 0xccc0-0xCCFF NOT PRESENT */
	0xffff, /* 0xcd00-0xCD3F NOT PRESENT */
	0xffff, /* 0xcd40-0xCD7F NOT PRESENT */
	0xffff, /* 0xcd80-0xCDBF NOT PRESENT */
	0xffff, /* 0xcdc0-0xCDFF NOT PRESENT */
	0xffff, /* 0xce00-0xCE3F NOT PRESENT */
	0xffff, /* 0xce40-0xCE7F NOT PRESENT */
	0xffff, /* 0xce80-0xCEBF NOT PRESENT */
	0xffff, /* 0xcec0-0xCEFF NOT PRESENT */
	0xffff, /* 0xcf00-0xCF3F NOT PRESENT */
	0xffff, /* 0xcf40-0xCF7F NOT PRESENT */
	0xffff, /* 0xcf80-0xCFBF NOT PRESENT */
	0xffff, /* 0xcfc0-0xCFFF NOT PRESENT */
	0xffff, /* 0xd000-0xD03F NOT PRESENT */
	0xffff, /* 0xd040-0xD07F NOT PRESENT */
	0xffff, /* 0xd080-0xD0BF NOT PRESENT */
	0xffff, /* 0xd0c0-0xD0FF NOT PRESENT */
	0xffff, /* 0xd100-0xD13F NOT PRESENT */
	0xffff, /* 0xd140-0xD17F NOT PRESENT */
	0xffff, /* 0xd180-0xD1BF NOT PRESENT */
	0xffff, /* 0xd1c0-0xD1FF NOT PRESENT */
	0xffff, /* 0xd200-0xD23F NOT PRESENT */
	0xffff, /* 0xd240-0xD27F NOT PRESENT */
	0xffff, /* 0xd280-0xD2BF NOT PRESENT */
	0xffff, /* 0xd2c0-0xD2FF NOT PRESENT */
	0xffff, /* 0xd300-0xD33F NOT PRESENT */
	0xffff, /* 0xd340-0xD37F NOT PRESENT */
	0xffff, /* 0xd380-0xD3BF NOT PRESENT */
	0xffff, /* 0xd3c0-0xD3FF NOT PRESENT */
	0xffff, /* 0xd400-0xD43F NOT PRESENT */
	0xffff, /* 0xd440-0xD47F NOT PRESENT */
	0xffff, /* 0xd480-0xD4BF NOT PRESENT */
	0xffff, /* 0xd4c0-0xD4FF NOT PRESENT */
	0xffff, /* 0xd500-0xD53F NOT PRESENT */
	0xffff, /* 0xd540-0xD57F NOT PRESENT */
	0xffff, /* 0xd580-0xD5BF NOT PRESENT */
	0xffff, /* 0xd5c0-0xD5FF NOT PRESENT */
	0xffff, /* 0xd600-0xD63F NOT PRESENT */
	0xffff, /* 0xd640-0xD67F NOT PRESENT */
	0xffff, /* 0xd680-0xD6BF NOT PRESENT */
	0xffff, /* 0xd6c0-0xD6FF NOT PRESENT */
	0xffff, /* 0xd700-0xD73F NOT PRESENT */
	0xffff, /* 0xd740-0xD77F NOT PRESENT */
	0xffff, /* 0xd780-0xD7BF NOT PRESENT */
	0xffff, /* 0xd7c0-0xD7FF NOT PRESENT */
	0xffff, /* 0xd800-0xD83F NOT PRESENT */
	0xffff, /* 0xd840-0xD87F NOT PRESENT */
	0xffff, /* 0xd880-0xD8BF NOT PRESENT */
	0xffff, /* 0xd8c0-0xD8FF NOT PRESENT */
	0xffff, /* 0xd900-0xD93F NOT PRESENT */
	0xffff, /* 0xd940-0xD97F NOT PRESENT */
	0xffff, /* 0xd980-0xD9BF NOT PRESENT */
	0xffff, /* 0xd9c0-0xD9FF NOT PRESENT */
	0xffff, /* 0xda00-0xDA3F NOT PRESENT */
	0xffff, /* 0xda40-0xDA7F NOT PRESENT */
	0xffff, /* 0xda80-0xDABF NOT PRESENT */
	0xffff, /* 0xdac0-0xDAFF NOT PRESENT */
	0xffff, /* 0xdb00-0xDB3F NOT PRESENT */
	0xffff, /* 0xdb40-0xDB7F NOT PRESENT */
	0xffff, /* 0xdb80-0xDBBF NOT PRESENT */
	0xffff, /* 0xdbc0-0xDBFF NOT PRESENT */
	0xffff, /* 0xdc00-0xDC3F NOT PRESENT */
	0xffff, /* 0xdc40-0xDC7F NOT PRESENT */
	0xffff, /* 0xdc80-0xDCBF NOT PRESENT */
	0xffff, /* 0xdcc0-0xDCFF NOT PRESENT */
	0xffff, /* 0xdd00-0xDD3F NOT PRESENT */
	0xffff, /* 0xdd40-0xDD7F NOT PRESENT */
	0xffff, /* 0xdd80-0xDDBF NOT PRESENT */
	0xffff, /* 0xddc0-0xDDFF NOT PRESENT */
	0xffff, /* 0xde00-0xDE3F NOT PRESENT */
	0xffff, /* 0xde40-0xDE7F NOT PRESENT */
	0xffff, /* 0xde80-0xDEBF NOT PRESENT */
	0xffff, /* 0xdec0-0xDEFF NOT PRESENT */
	0xffff, /* 0xdf00-0xDF3F NOT PRESENT */
	0xffff, /* 0xdf40-0xDF7F NOT PRESENT */
	0xffff, /* 0xdf80-0xDFBF NOT PRESENT */
	0xffff, /* 0xdfc0-0xDFFF NOT PRESENT */
	0xffff, /* 0xe000-0xE03F NOT PRESENT */
	0x1600, /* 0xe040-0xE07F */
	0x1640, /* 0xe080-0xE0BF */
	0x1680, /* 0xe0c0-0xE0FF */
	0xffff, /* 0xe100-0xE13F NOT PRESENT */
	0x16c0, /* 0xe140-0xE17F */
	0x1700, /* 0xe180-0xE1BF */
	0x1740, /* 0xe1c0-0xE1FF */
	0xffff, /* 0xe200-0xE23F NOT PRESENT */
	0x1780, /* 0xe240-0xE27F */
	0x17c0, /* 0xe280-0xE2BF */
	0x1800, /* 0xe2c0-0xE2FF */
	0xffff, /* 0xe300-0xE33F NOT PRESENT */
	0x1840, /* 0xe340-0xE37F */
	0x1880, /* 0xe380-0xE3BF */
	0x18c0, /* 0xe3c0-0xE3FF */
	0xffff, /* 0xe400-0xE43F NOT PRESENT */
	0x1900, /* 0xe440-0xE47F */
	0x1940, /* 0xe480-0xE4BF */
	0x1980, /* 0xe4c0-0xE4FF */
	0xffff, /* 0xe500-0xE53F NOT PRESENT */
	0x19c0, /* 0xe540-0xE57F */
	0x1a00, /* 0xe580-0xE5BF */
	0x1a40, /* 0xe5c0-0xE5FF */
	0xffff, /* 0xe600-0xE63F NOT PRESENT */
	0x1a80, /* 0xe640-0xE67F */
	0x1ac0, /* 0xe680-0xE6BF */
	0x1b00, /* 0xe6c0-0xE6FF */
	0xffff, /* 0xe700-0xE73F NOT PRESENT */
	0x1b40, /* 0xe740-0xE77F */
	0x1b80, /* 0xe780-0xE7BF */
	0x1bc0, /* 0xe7c0-0xE7FF */
	0xffff, /* 0xe800-0xE83F NOT PRESENT */
	0x1c00, /* 0xe840-0xE87F */
	0x1c40, /* 0xe880-0xE8BF */
	0x1c80, /* 0xe8c0-0xE8FF */
	0xffff, /* 0xe900-0xE93F NOT PRESENT */
	0x1cc0, /* 0xe940-0xE97F */
	0x1d00, /* 0xe980-0xE9BF */
	0x1d40, /* 0xe9c0-0xE9FF */
	0xffff, /* 0xea00-0xEA3F NOT PRESENT */
	0x1d80, /* 0xea40-0xEA7F */
	0x1dc0, /* 0xea80-0xEABF */
	0xffff, /* 0xeac0-0xEAFF NOT PRESENT */
	0xffff, /* 0xeb00-0xEB3F NOT PRESENT */
	0xffff, /* 0xeb40-0xEB7F NOT PRESENT */
	0xffff, /* 0xeb80-0xEBBF NOT PRESENT */
	0xffff, /* 0xebc0-0xEBFF NOT PRESENT */
	0xffff, /* 0xec00-0xEC3F NOT PRESENT */
	0xffff, /* 0xec40-0xEC7F NOT PRESENT */
	0xffff, /* 0xec80-0xECBF NOT PRESENT */
	0xffff, /* 0xecc0-0xECFF NOT PRESENT */
	0xffff, /* 0xed00-0xED3F NOT PRESENT */
	0x1e00, /* 0xed40-0xED7F */
	0x1e40, /* 0xed80-0xEDBF */
	0x1e80, /* 0xedc0-0xEDFF */
	0xffff, /* 0xee00-0xEE3F NOT PRESENT */
	0x1ec0, /* 0xee40-0xEE7F */
	0x1f00, /* 0xee80-0xEEBF */
	0x1f40, /* 0xeec0-0xEEFF */
	0xffff, /* 0xef00-0xEF3F NOT PRESENT */
	0xffff, /* 0xef40-0xEF7F NOT PRESENT */
	0xffff, /* 0xef80-0xEFBF NOT PRESENT */
	0xffff, /* 0xefc0-0xEFFF NOT PRESENT */
	0xffff, /* 0xf000-0xF03F NOT PRESENT */
	0xffff, /* 0xf040-0xF07F NOT PRESENT */
	0xffff, /* 0xf080-0xF0BF NOT PRESENT */
	0xffff, /* 0xf0c0-0xF0FF NOT PRESENT */
	0xffff, /* 0xf100-0xF13F NOT PRESENT */
	0xffff, /* 0xf140-0xF17F NOT PRESENT */
	0xffff, /* 0xf180-0xF1BF NOT PRESENT */
	0xffff, /* 0xf1c0-0xF1FF NOT PRESENT */
	0xffff, /* 0xf200-0xF23F NOT PRESENT */
	0xffff, /* 0xf240-0xF27F NOT PRESENT */
	0xffff, /* 0xf280-0xF2BF NOT PRESENT */
	0xffff, /* 0xf2c0-0xF2FF NOT PRESENT */
	0xffff, /* 0xf300-0xF33F NOT PRESENT */
	0xffff, /* 0xf340-0xF37F NOT PRESENT */
	0xffff, /* 0xf380-0xF3BF NOT PRESENT */
	0xffff, /* 0xf3c0-0xF3FF NOT PRESENT */
	0xffff, /* 0xf400-0xF43F NOT PRESENT */
	0xffff, /* 0xf440-0xF47F NOT PRESENT */
	0xffff, /* 0xf480-0xF4BF NOT PRESENT */
	0xffff, /* 0xf4c0-0xF4FF NOT PRESENT */
	0xffff, /* 0xf500-0xF53F NOT PRESENT */
	0xffff, /* 0xf540-0xF57F NOT PRESENT */
	0xffff, /* 0xf580-0xF5BF NOT PRESENT */
	0xffff, /* 0xf5c0-0xF5FF NOT PRESENT */
	0xffff, /* 0xf600-0xF63F NOT PRESENT */
	0xffff, /* 0xf640-0xF67F NOT PRESENT */
	0xffff, /* 0xf680-0xF6BF NOT PRESENT */
	0xffff, /* 0xf6c0-0xF6FF NOT PRESENT */
	0xffff, /* 0xf700-0xF73F NOT PRESENT */
	0xffff, /* 0xf740-0xF77F NOT PRESENT */
	0xffff, /* 0xf780-0xF7BF NOT PRESENT */
	0xffff, /* 0xf7c0-0xF7FF NOT PRESENT */
	0xffff, /* 0xf800-0xF83F NOT PRESENT */
	0xffff, /* 0xf840-0xF87F NOT PRESENT */
	0xffff, /* 0xf880-0xF8BF NOT PRESENT */
	0xffff, /* 0xf8c0-0xF8FF NOT PRESENT */
	0xffff, /* 0xf900-0xF93F NOT PRESENT */
	0xffff, /* 0xf940-0xF97F NOT PRESENT */
	0xffff, /* 0xf980-0xF9BF NOT PRESENT */
	0xffff, /* 0xf9c0-0xF9FF NOT PRESENT */
	0xffff, /* 0xfa00-0xFA3F NOT PRESENT */
	0x1f80, /* 0xfa40-0xFA7F */
	0x1fc0, /* 0xfa80-0xFABF */
	0x2000, /* 0xfac0-0xFAFF */
	0xffff, /* 0xfb00-0xFB3F NOT PRESENT */
	0x2040, /* 0xfb40-0xFB7F */
	0x2080, /* 0xfb80-0xFBBF */
	0x20c0, /* 0xfbc0-0xFBFF */
	0xffff, /* 0xfc00-0xFC3F NOT PRESENT */
	0x2100, /* 0xfc40-0xFC7F */
	0xffff, /* 0xfc80-0xFCBF NOT PRESENT */
	0xffff, /* 0xfcc0-0xFCFF NOT PRESENT */
	0xffff, /* 0xfd00-0xFD3F NOT PRESENT */
	0xffff, /* 0xfd40-0xFD7F NOT PRESENT */
	0xffff, /* 0xfd80-0xFDBF NOT PRESENT */
	0xffff, /* 0xfdc0-0xFDFF NOT PRESENT */
	0xffff, /* 0xfe00-0xFE3F NOT PRESENT */
	0xffff, /* 0xfe40-0xFE7F NOT PRESENT */
	0xffff, /* 0xfe80-0xFEBF NOT PRESENT */
	0xffff, /* 0xfec0-0xFEFF NOT PRESENT */
	0xffff, /* 0xff00-0xFF3F NOT PRESENT */
	0xffff, /* 0xff40-0xFF7F NOT PRESENT */
	0xffff, /* 0xff80-0xFFBF NOT PRESENT */
	0xffff  /* 0xffc0-0xFFFF NOT PRESENT */
};
