/*
 * Decompiled with CFR 0.152.
 */
package dumphd.bdplus;

import dumphd.bdplus.Segment;
import dumphd.util.ByteArray;
import dumphd.util.ByteSource;
import dumphd.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class SubTable {
    private long tableOffset = 0L;
    private long tableId = 0L;
    private ArrayList<Segment> segments = new ArrayList();

    public SubTable() {
    }

    public SubTable(ByteSource source) throws IOException {
        this.tableOffset = source.getPosition();
        if (source.read(Utils.buffer, 0, 6) != 6) {
            throw new IOException("Unexpected EOF, subtable too small for header");
        }
        this.tableId = ByteArray.getUInt(Utils.buffer, 0);
        int segmentCount = ByteArray.getUShort(Utils.buffer, 4);
        this.segments.ensureCapacity(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            source.setPosition(this.tableOffset + 6L + (long)(i * 4));
            if (source.read(Utils.buffer, 0, 4) != 4) {
                throw new IOException("Unexpected EOF, segment index section too small");
            }
            long index = ByteArray.getUInt(Utils.buffer, 0);
            source.setPosition(index);
            Segment segment = new Segment(source, i);
            this.segments.add(segment);
            ++i;
        }
    }

    public int parse(byte[] raw, int offset) throws IndexOutOfBoundsException {
        this.tableOffset = offset;
        this.tableId = ByteArray.getUInt(raw, offset);
        int segmentCount = ByteArray.getUShort(raw, offset += 4);
        offset += 2;
        this.segments.ensureCapacity(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            long index = ByteArray.getUInt(raw, (int)this.tableOffset + 6 + i * 4);
            Segment segment = new Segment(i);
            offset = segment.parse(raw, (int)index);
            this.segments.add(segment);
            ++i;
        }
        return offset;
    }

    public long getTableOffset() {
        return this.tableOffset;
    }

    public long getTableId() {
        return this.tableId;
    }

    public int size() {
        return this.segments.size();
    }

    public Segment getSegment(int index) {
        return this.segments.get(index);
    }

    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public PatchIterator patchIterator() {
        return new PatchIterator();
    }

    public class PatchIterator {
        private Iterator<Segment> segmentIterator = null;
        private Segment currentSegment = null;
        private int currentSegmentIndex = 0;
        private boolean currentSegmentFirstPatch = true;

        public PatchIterator() {
            this.segmentIterator = SubTable.this.segments.iterator();
            this.nextSegment();
        }

        public boolean isValid() {
            return this.currentSegment != null;
        }

        public void increment() {
            if (this.currentSegment == null) {
                throw new IllegalStateException();
            }
            if (this.currentSegmentIndex < this.currentSegment.size()) {
                if (this.currentSegmentFirstPatch) {
                    this.currentSegmentFirstPatch = false;
                    return;
                }
                this.currentSegmentFirstPatch = true;
                ++this.currentSegmentIndex;
            }
            if (this.currentSegmentIndex == this.currentSegment.size()) {
                this.nextSegment();
            }
        }

        public long getAddress() {
            if (this.currentSegment == null) {
                throw new IllegalStateException();
            }
            if (this.currentSegmentFirstPatch) {
                return this.currentSegment.getAddress0(this.currentSegmentIndex);
            }
            return this.currentSegment.getAddress1(this.currentSegmentIndex);
        }

        public void getPatch(byte[] dst, int offset) {
            if (this.currentSegment == null) {
                throw new IllegalStateException();
            }
            if (this.currentSegmentFirstPatch) {
                this.currentSegment.getPatch0(this.currentSegmentIndex, dst, offset);
            } else {
                this.currentSegment.getPatch1(this.currentSegmentIndex, dst, offset);
            }
        }

        public int getPatchLength() {
            return 5;
        }

        private void nextSegment() {
            this.currentSegmentIndex = 0;
            this.currentSegmentFirstPatch = true;
            while (this.segmentIterator.hasNext()) {
                this.currentSegment = this.segmentIterator.next();
                if (this.currentSegment.size() <= 0) continue;
                return;
            }
            this.currentSegment = null;
        }
    }
}

