# - Try to find the PCRE library and headers
# Once done this will define
#
#  PCRE_INCLUDE_DIR - the PCRE include directory
#  PCRE_LIBRARIES - link these to use PCRE

if(PCRE_INCLUDE_DIR AND PCRE_LIBRARY AND PCRECPP_LIBRARY)
  set(PCRE_FIND_QUIETLY TRUE)
endif(PCRE_INCLUDE_DIR AND PCRE_LIBRARY AND PCRECPP_LIBRARY)

# Include dir
find_path(PCRE_INCLUDE_DIR NAMES pcre.h)

# Libraries
find_library(PCRE_LIBRARY NAMES pcre)
find_library(PCRECPP_LIBRARY NAMES pcrecpp)

if(PCRE_LIBRARY AND PCRECPP_LIBRARY)
  set(PCRE_LIBRARIES ${PCRECPP_LIBRARY} ${PCRE_LIBRARY})
endif(PCRE_LIBRARY AND PCRECPP_LIBRARY)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(PCRE DEFAULT_MSG PCRE_LIBRARIES PCRE_INCLUDE_DIR)

MARK_AS_ADVANCED(PCRE_LIBRARIES PCRE_INCLUDE_DIR PCRE_LIBRARY PCRECPP_LIBRARY)

