/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Cursor;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.filetree.FileSave;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class FileSaving {
    private boolean lsaved = false;
    private String fileSelected;
    private String cwd;

    public FileSaving(JTextPane seqText, byte[] pngContent, JembossParams mysettings) {
        Cursor cbusy = new Cursor(3);
        Cursor cdone = new Cursor(0);
        String fs = new String(System.getProperty("file.separator"));
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        JFileChooser fc = new JFileChooser(mysettings.getUserHome());
        System.setSecurityManager(sm);
        fc.addChoosableFileFilter(new SequenceFilter());
        int returnVal = fc.showSaveDialog(fc);
        if (returnVal == 0) {
            File files = fc.getSelectedFile();
            this.cwd = fc.getCurrentDirectory().getAbsolutePath();
            this.fileSelected = files.getName();
            seqText.setCursor(cbusy);
            FileSave fsave = new FileSave(new File(this.cwd + fs + this.fileSelected));
            if (fsave.doWrite()) {
                if (pngContent != null) {
                    fsave.fileSaving(pngContent);
                } else {
                    fsave.fileSaving(seqText.getText());
                }
                if (fsave.writeOK()) {
                    this.lsaved = true;
                }
            }
            seqText.setCursor(cdone);
        }
    }

    public boolean writeOK() {
        return this.lsaved;
    }

    public String getFileName() {
        return this.fileSelected;
    }

    public String getPath() {
        return this.cwd;
    }
}

