/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.gui.ShowResultSet;
import org.emboss.jemboss.gui.filetree.FileNode;
import org.emboss.jemboss.gui.filetree.RemoteFileNode;
import org.emboss.jemboss.soap.FileList;
import org.emboss.jemboss.soap.FileRoots;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class RemoteDragTree
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
ActionListener,
Autoscroll {
    private JembossParams mysettings;
    private static FileRoots froots;
    private JPopupMenu popup;
    private String ls = new String(System.getProperty("line.separator"));
    private Vector openNode;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private static final int AUTOSCROLL_MARGIN = 45;
    private Insets autoscrollInsets = new Insets(0, 0, 0, 0);
    public static final String REMOTE_HOME = " ";
    JMenuItem openMenu;
    JMenuItem renameMenuItem;
    JMenuItem deleteMenuItem;

    public RemoteDragTree(final JembossParams mysettings, FileRoots froots) {
        this.mysettings = mysettings;
        RemoteDragTree.froots = froots;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
        DefaultTreeModel model = this.createTreeModel(REMOTE_HOME);
        this.setModel(model);
        this.createTreeModelListener();
        this.getSelectionModel().setSelectionMode(4);
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.popup.add(new JSeparator());
        this.openMenu = new JMenu("Open With");
        this.popup.add(this.openMenu);
        menuItem = new JMenuItem("Jemboss Aligmnment Editor");
        menuItem.addActionListener(this);
        this.openMenu.add(menuItem);
        menuItem = new JMenuItem("Text Editor");
        menuItem.addActionListener(this);
        this.openMenu.add(menuItem);
        this.renameMenuItem = new JMenuItem("Rename...");
        this.renameMenuItem.addActionListener(this);
        this.popup.add(this.renameMenuItem);
        menuItem = new JMenuItem("New Folder...");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.deleteMenuItem = new JMenuItem("Delete...");
        this.deleteMenuItem.addActionListener(this);
        this.popup.add(this.deleteMenuItem);
        this.popup.add(new JSeparator());
        menuItem = new JMenuItem("De-select All");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2 && RemoteDragTree.this.isFileSelection()) {
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cbusy);
                    RemoteFileNode node = (RemoteFileNode)RemoteDragTree.this.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    if (node.isLeaf()) {
                        RemoteDragTree.showFilePane(node.getFullName(), mysettings);
                    }
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cdone);
                }
            }

            public void mousePressed(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
            }

            public void mouseExited(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                if (path != null) {
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cbusy);
                    RemoteFileNode node = (RemoteFileNode)path.getLastPathComponent();
                    if (!node.isExplored()) {
                        RemoteDragTree.this.exploreNode(node);
                    }
                    RemoteDragTree.this.setCursor(RemoteDragTree.this.cdone);
                }
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
    }

    public void refreshRoot() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model = this.createTreeModel(REMOTE_HOME);
        this.setModel(model);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        RemoteFileNode node = this.getSelectedNode();
        if (node == null) {
            JOptionPane.showMessageDialog(null, "No file selected.", "Warning", 2);
            return;
        }
        String fn = node.getFullName();
        String parent = node.getPathName();
        String rootPath = node.getRootDir();
        RemoteFileNode pn = node;
        if (source.getText().equals("Refresh")) {
            this.refreshRoot();
        } else if (source.getText().equals("Jemboss Aligmnment Editor")) {
            Vector<String> params = new Vector<String>();
            String options = "fileroot=" + froots.getCurrentRoot();
            params.addElement(options);
            params.addElement(fn);
            try {
                PrivateRequest gReq = new PrivateRequest(this.mysettings, "EmbreoFile", "get_file", params);
                AlignJFrame ajFrame = new AlignJFrame((String)gReq.getHash().get("contents"), fn);
                ajFrame.setVisible(true);
            }
            catch (JembossSoapException eae) {
                System.out.println("RemoteDragTree :: JembossSoapException " + fn);
            }
        } else if (source.getText().equals("Text Editor")) {
            RemoteDragTree.showFilePane(fn, this.mysettings);
        } else if (source.getText().equals("New Folder...")) {
            String inputValue = JOptionPane.showInputDialog(null, "Folder Name", "Create New Folder in", 3);
            String dropDest = null;
            if (node.isLeaf()) {
                pn = (RemoteFileNode)node.getParent();
                dropDest = pn.getFullName() + "/" + inputValue;
            } else {
                dropDest = node.getFullName() + "/" + inputValue;
            }
            String newNode = pn.getServerName();
            if (!newNode.endsWith("/")) {
                newNode = newNode.concat("/");
            }
            if (this.nodeExists(pn, newNode = newNode.concat(inputValue))) {
                return;
            }
            if (inputValue != null && !inputValue.equals("")) {
                RemoteFileNode pnn = pn;
                Vector<String> params = new Vector<String>();
                params.addElement("fileroot=" + rootPath);
                params.addElement(dropDest);
                try {
                    this.setCursor(this.cbusy);
                    new PrivateRequest(this.mysettings, "EmbreoFile", "mkdir", params);
                    this.setCursor(this.cdone);
                    RemoteFileNode child = this.addObject(pnn, inputValue, true);
                    this.expandPath(new TreePath(child.getPath()));
                }
                catch (JembossSoapException jse) {
                    this.setCursor(this.cdone);
                }
            }
        } else if (source.getText().equals("Delete...")) {
            RemoteFileNode[] nodes = this.getSelectedNodes();
            String sname = "";
            for (int i = 0; i < nodes.length; ++i) {
                sname = sname.concat(nodes[i].getServerName() + this.ls);
            }
            int n = JOptionPane.showConfirmDialog(null, "Delete" + this.ls + sname + "?", "Delete " + sname, 0);
            if (n == 0) {
                for (int i = 0; i < nodes.length; ++i) {
                    this.deleteNode(nodes[i]);
                }
            }
        } else if (source.getText().equals("De-select All")) {
            this.clearSelection();
        } else if (source.getText().equals("Rename...")) {
            String inputValue = (String)JOptionPane.showInputDialog(null, "New " + (node.isLeaf() ? "file" : "folder") + " name", "Rename " + node.getFile(), 3, null, null, node.getFile());
            pn = (RemoteFileNode)node.getParent();
            if (inputValue != null && !inputValue.equals("")) {
                RemoteFileNode parentNode;
                String newfile = null;
                newfile = parent.endsWith("/") ? parent + inputValue : parent + "/" + inputValue;
                String dir = ((RemoteFileNode)node.getParent()).getFullName();
                if (inputValue.indexOf("/") > 0) {
                    int index = inputValue.lastIndexOf("/");
                    dir = inputValue.substring(0, index);
                }
                if (!this.nodeExists(parentNode = this.getNode(dir), newfile)) {
                    this.rename(rootPath, fn, parent, inputValue, node, parentNode);
                }
            }
        }
    }

    private void deleteNode(final RemoteFileNode node) {
        this.setCursor(this.cbusy);
        String rootPath = node.getRootDir();
        String dropDest = node.getFullName();
        Vector<String> params = new Vector<String>();
        params.addElement("fileroot=" + rootPath);
        params.addElement(dropDest);
        if (node.isLeaf()) {
            try {
                new PrivateRequest(this.mysettings, "EmbreoFile", "delFile", params);
                Runnable deleteFileFromTree = new Runnable(){

                    public void run() {
                        RemoteDragTree.this.deleteObject(node);
                    }
                };
                SwingUtilities.invokeLater(deleteFileFromTree);
            }
            catch (JembossSoapException jse) {
                this.setCursor(this.cdone);
            }
        } else {
            try {
                FileList efl = new FileList(this.mysettings, rootPath, dropDest);
                Vector children = efl.fileVector();
                if (children.size() > 0) {
                    JOptionPane.showMessageDialog(null, "Cannot delete" + this.ls + node.getServerName() + this.ls + "this directory is not empty", "Warning", 0);
                } else {
                    PrivateRequest r = new PrivateRequest(this.mysettings, "EmbreoFile", "delDir", params);
                    if (!r.getVal("msg").equals("NOT OK")) {
                        Runnable deleteFileFromTree = new Runnable(){

                            public void run() {
                                RemoteDragTree.this.deleteObject(node);
                            }
                        };
                        SwingUtilities.invokeLater(deleteFileFromTree);
                    }
                }
            }
            catch (JembossSoapException jse) {
                this.setCursor(this.cdone);
            }
        }
        this.setCursor(this.cdone);
    }

    public void exploreNode(RemoteFileNode dirNode) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        dirNode.explore();
        this.openNode.add(dirNode);
        model.nodeStructureChanged(dirNode);
    }

    public boolean nodeExists(RemoteFileNode parentNode, String child) {
        RemoteFileNode childNode = this.getChildNode(parentNode, child);
        if (childNode != null) {
            String ls = System.getProperty("line.separator");
            JOptionPane.showMessageDialog(null, child + ls + " already exists!", "File Exists", 0);
            return true;
        }
        return false;
    }

    private void rename(String rootPath, String fullname, String pathToNewFile, final String newfile, final RemoteFileNode node, final RemoteFileNode parentNode) {
        Vector<String> params = new Vector<String>();
        params.addElement("fileroot=" + rootPath);
        params.addElement(fullname);
        params.addElement(pathToNewFile + "/" + newfile);
        try {
            this.setCursor(this.cbusy);
            new PrivateRequest(this.mysettings, "EmbreoFile", "rename", params);
            this.setCursor(this.cdone);
            Runnable deleteFileFromTree = new Runnable(){

                public void run() {
                    RemoteDragTree.this.addObject(parentNode, newfile, node.isDirectory());
                    RemoteDragTree.this.deleteObject(node);
                }
            };
            SwingUtilities.invokeLater(deleteFileFromTree);
        }
        catch (JembossSoapException jse) {
            this.setCursor(this.cdone);
        }
    }

    public RemoteFileNode addObject(RemoteFileNode parentNode, String child, boolean ldir) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (parentNode == null) {
            return null;
        }
        String path = parentNode.getFullName();
        if (path.equals(REMOTE_HOME)) {
            path = "";
        }
        if (child.indexOf("/") > -1) {
            child = child.substring(child.lastIndexOf("/") + 1);
        }
        RemoteFileNode childNode = null;
        if (!parentNode.isExplored()) {
            this.exploreNode(parentNode);
            childNode = this.getNode(parentNode.getServerName() + "/" + child);
        } else {
            int num;
            childNode = new RemoteFileNode(this.mysettings, froots, child, null, path, ldir);
            int childIndex = num = parentNode.getChildCount();
            for (int i = 0; i < num; ++i) {
                String nodeName = ((RemoteFileNode)parentNode.getChildAt(i)).getFile();
                if (nodeName.compareTo(child) > 0) {
                    childIndex = i;
                    break;
                }
                if (nodeName.compareTo(child) != 0) continue;
                childIndex = -1;
                break;
            }
            if (childIndex != -1) {
                model.insertNodeInto(childNode, parentNode, childIndex);
            }
        }
        this.scrollPathToVisible(new TreePath(childNode.getPath()));
        return childNode;
    }

    public void deleteObject(RemoteFileNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.removeNodeFromParent(node);
    }

    public byte[] getLocalFile(File name) {
        byte[] b = null;
        try {
            long s = name.length();
            b = new byte[(int)s];
            FileInputStream fi = new FileInputStream(name);
            fi.read(b);
            fi.close();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + name);
        }
        return b;
    }

    public RemoteFileNode getSelectedNode() {
        TreePath path = this.getLeadSelectionPath();
        if (path == null) {
            return null;
        }
        RemoteFileNode node = (RemoteFileNode)path.getLastPathComponent();
        return node;
    }

    public RemoteFileNode[] getSelectedNodes() {
        TreePath[] path = this.getSelectionPaths();
        if (path == null) {
            return null;
        }
        int numberSelected = path.length;
        RemoteFileNode[] nodes = new RemoteFileNode[numberSelected];
        for (int i = 0; i < numberSelected; ++i) {
            nodes[i] = (RemoteFileNode)path[i].getLastPathComponent();
        }
        return nodes;
    }

    public boolean isFileSelection() {
        TreePath path = this.getLeadSelectionPath();
        if (path == null) {
            return false;
        }
        RemoteFileNode node = (RemoteFileNode)path.getLastPathComponent();
        return !node.isDirectory();
    }

    public String getFilename() {
        TreePath path = this.getLeadSelectionPath();
        RemoteFileNode node = (RemoteFileNode)path.getLastPathComponent();
        return node.getServerName();
    }

    private DefaultTreeModel createTreeModel(String root) {
        this.setCursor(this.cbusy);
        RemoteFileNode rootNode = new RemoteFileNode(this.mysettings, froots, root, null, null);
        rootNode.explore();
        this.openNode = new Vector();
        this.openNode.add(rootNode);
        this.setCursor(this.cdone);
        return new DefaultTreeModel(rootNode);
    }

    private RemoteFileNode getNode(String path) {
        Enumeration en = this.openNode.elements();
        while (en.hasMoreElements()) {
            RemoteFileNode node = (RemoteFileNode)en.nextElement();
            String nodeName = node.getFullName();
            if (!nodeName.equals(path)) continue;
            return node;
        }
        en = this.openNode.elements();
        while (en.hasMoreElements()) {
            RemoteFileNode child = this.getChildNode((RemoteFileNode)en.nextElement(), path);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private RemoteFileNode getChildNode(RemoteFileNode parent, String childName) {
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            RemoteFileNode childNode = (RemoteFileNode)children.nextElement();
            String nodeName = childNode.getServerName();
            if (!childName.equals(nodeName)) continue;
            return childNode;
        }
        return null;
    }

    public static void showFilePane(String filename, JembossParams mysettings) {
        try {
            Vector<String> params = new Vector<String>();
            String options = "fileroot=" + froots.getCurrentRoot();
            params.addElement(options);
            params.addElement(filename);
            PrivateRequest gReq = new PrivateRequest(mysettings, "EmbreoFile", "get_file", params);
            Hashtable<String, byte[]> hfile = new Hashtable<String, byte[]>();
            Object contents = gReq.getHash().get("contents");
            if (contents == null) {
                JOptionPane.showMessageDialog(null, "file was empty", "error", 0);
                return;
            }
            if (contents instanceof String) {
                hfile.put(filename, ((String)contents).getBytes());
            } else {
                hfile.put(filename, (byte[])contents);
            }
            ShowResultSet srs = new ShowResultSet(hfile, mysettings);
            srs.setTitle("Remote File");
        }
        catch (JembossSoapException jembossSoapException) {
            // empty catch block
        }
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        InputEvent ie = e.getTriggerEvent();
        if (ie instanceof MouseEvent && ((MouseEvent)ie).isPopupTrigger()) {
            return;
        }
        if (this.isFileSelection()) {
            e.startDrag(DragSource.DefaultCopyDrop, this.getSelectedNode(), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE) || e.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            e.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent e) {
        block15: {
            Transferable t = e.getTransferable();
            if (t.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
                try {
                    Point ploc = e.getLocation();
                    TreePath dropPath = this.getPathForLocation(ploc.x, ploc.y);
                    if (dropPath == null) break block15;
                    RemoteFileNode fn = (RemoteFileNode)t.getTransferData(RemoteFileNode.REMOTEFILENODE);
                    fn = this.getNode(fn.getServerName());
                    RemoteFileNode fdropPath = (RemoteFileNode)dropPath.getLastPathComponent();
                    String dropFile = null;
                    dropFile = fdropPath.getFile().equals(REMOTE_HOME) ? fn.getFile() : fdropPath.getFile() + "/" + fn.getFile();
                    if (!this.nodeExists(fdropPath, fdropPath.getServerName() + fn.getFile())) {
                        this.rename(fn.getRootDir(), fn.getFullName(), fdropPath.getPathName(), dropFile, fn, fdropPath);
                    }
                }
                catch (Exception ex) {}
            } else if (t.isDataFlavorSupported(FileNode.FILENODE)) {
                try {
                    Point ploc = e.getLocation();
                    TreePath dropPath = this.getPathForLocation(ploc.x, ploc.y);
                    if (dropPath == null) break block15;
                    FileNode fn = (FileNode)t.getTransferData(FileNode.FILENODE);
                    File lfn = fn.getFile();
                    String dropDest = null;
                    RemoteFileNode fdropPath = (RemoteFileNode)dropPath.getLastPathComponent();
                    String dropRoot = fdropPath.getRootDir();
                    RemoteFileNode pn = fdropPath;
                    if (fdropPath.isLeaf()) {
                        pn = (RemoteFileNode)fdropPath.getParent();
                        dropDest = pn.getFullName() + "/" + lfn.getName();
                    } else {
                        dropDest = fdropPath.getFullName() + "/" + lfn.getName();
                    }
                    if (!this.nodeExists(pn, pn.getServerName() + lfn.getName())) {
                        try {
                            Vector<Object> params = new Vector<Object>();
                            byte[] fileData = this.getLocalFile(lfn);
                            params.addElement("fileroot=" + dropRoot);
                            params.addElement(dropDest);
                            params.addElement(fileData);
                            this.setCursor(this.cbusy);
                            new PrivateRequest(this.mysettings, "EmbreoFile", "put_file", params);
                            this.setCursor(this.cdone);
                            RemoteFileNode parentNode = fdropPath;
                            parentNode = parentNode.isLeaf() ? (RemoteFileNode)fdropPath.getParent() : fdropPath;
                            if (parentNode.isExplored()) {
                                this.addObject(parentNode, lfn.getName(), false);
                                break block15;
                            }
                            this.exploreNode(parentNode);
                            RemoteFileNode childNode = this.getNode(parentNode.getServerName() + "/" + lfn.getName());
                            this.scrollPathToVisible(new TreePath(childNode.getPath()));
                        }
                        catch (Exception exp) {
                            this.setCursor(this.cdone);
                            System.out.println("RemoteDragTree: caught exception " + dropRoot + " Destination: " + dropDest + " Local File " + lfn.toString());
                        }
                        break block15;
                    }
                    e.rejectDrop();
                }
                catch (Exception exception) {}
            } else {
                e.rejectDrop();
            }
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(FileNode.FILENODE)) {
            Point ploc = e.getLocation();
            TreePath ePath = this.getPathForLocation(ploc.x, ploc.y);
            if (ePath == null) {
                e.rejectDrag();
            } else {
                this.setSelectionPath(ePath);
                e.acceptDrag(3);
            }
        } else if (e.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            Point ploc = e.getLocation();
            TreePath ePath = this.getPathForLocation(ploc.x, ploc.y);
            if (ePath == null) {
                e.rejectDrag();
                return;
            }
            RemoteFileNode node = (RemoteFileNode)ePath.getLastPathComponent();
            if (!node.isDirectory()) {
                e.rejectDrag();
            } else {
                this.setSelectionPath(ePath);
                e.acceptDrag(3);
            }
        } else {
            e.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void autoscroll(Point location) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        int bottomEdge = rect.y + rect.height;
        int rightEdge = rect.x + rect.width;
        if (location.y - rect.y < 45 && rect.y > 0) {
            top = 45;
        }
        if (location.x - rect.x < 45 && rect.x > 0) {
            left = 45;
        }
        if (bottomEdge - location.y < 45 && bottomEdge < size.height) {
            bottom = 45;
        }
        if (rightEdge - location.x < 45 && rightEdge < size.width) {
            right = 45;
        }
        rect.x += right - left;
        rect.y += bottom - top;
        this.scrollRectToVisible(rect);
    }

    public Insets getAutoscrollInsets() {
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        this.autoscrollInsets.top = rect.y + 45;
        this.autoscrollInsets.left = rect.x + 45;
        this.autoscrollInsets.bottom = size.height - (rect.y + rect.height) + 45;
        this.autoscrollInsets.right = size.width - (rect.x + rect.width) + 45;
        return this.autoscrollInsets;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            RemoteFileNode node = RemoteDragTree.this.getSelectedNode();
            if (node != null && e.isPopupTrigger()) {
                if (node.getFile().equals(RemoteDragTree.REMOTE_HOME)) {
                    RemoteDragTree.this.renameMenuItem.setEnabled(false);
                    RemoteDragTree.this.deleteMenuItem.setEnabled(false);
                    RemoteDragTree.this.openMenu.setEnabled(false);
                } else {
                    RemoteDragTree.this.renameMenuItem.setEnabled(true);
                    RemoteDragTree.this.deleteMenuItem.setEnabled(true);
                    if (!node.isDirectory()) {
                        RemoteDragTree.this.openMenu.setEnabled(true);
                    } else {
                        RemoteDragTree.this.openMenu.setEnabled(false);
                    }
                }
                RemoteDragTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

