//
// File: Encadreur.h
// Created by: Éric Laly <elaly@free.fr>
// Created on: Mon Jul 31 19:57:35 2006
//

#ifndef _ENCADREUR_H_
#define _ENCADREUR_H_
#include <string>
using std::string;
#include <wx/wx.h>
#include <Magick++.h>
using namespace Magick;
#include <queue>
using std::queue;
#include <vector>
using std::vector;

class Encadreur
{
	private:
		vector <double> pourcentages_cadres;
		vector <Color> couleurs_cadres;
        vector <bool> couleur_auto_cadres;
        bool dominante_deja_calcule;
        Color couleur_dominante_image;
		Color couleur_fonte_signature;
        bool couleur_auto_signature;
		double pourcentage_fonte_signature;
		GravityType position_signature;
		string signature;
		int qualite;
		string prefixe_nom_image_encadree;
		string image_a_encadrer;
		string repertoire_source;
		string repertoire_destination;
		int taille_cadre_interieur;
		int taille_cadre_exterieur;
		int taille_fonte_signature;
        int redimensionnement;
	
	public:
		Encadreur();
		 ~Encadreur();

        bool SetPourcentagesCadres(vector<double> pourcentages);
		bool SetPourcentageFonteSignature(double pourcentage);
		bool SetPositionSignature(wxString position);
		bool SetCouleursCadres(vector <wxColor> couleurs);
		void SetCouleursAutoCadres(vector <bool> couleursauto);
		bool SetCouleurSignature(wxColor couleur);
        void SetCouleurAutoSignature(bool couleurauto);
		void SetSignature(wxString chaine);
		void SetRepertoireSource(wxString chaine);
		void SetRepertoireDestination(wxString chaine);
		void SetPrefixeFichier(wxString chaine);
		bool SetQualiteEnregistrement(int pourcentage);
        void SetRedimensionnement(int dimension);
        wxString Encadre(wxString image_a_encadrer);

	private:
		bool ConversionEnPourcentage(double pourcentage, double &valeur_pourcentage);
		Geometry GeometrieSignature(Image image,int taille_cadres);
        Color ChercheDominante(Image image);

};

#endif	//_ENCADREUR_H_
