/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.util.Date;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakUtil;

public final class GempakLookup
implements GridTableLookup {
    private GempakGridRecord sample;

    public GempakLookup(GempakGridRecord sample) {
        this.sample = sample;
    }

    public String getShapeName(GridDefRecord gds) {
        return "Spherical";
    }

    public final String getGridName(GridDefRecord gds) {
        return this.getProjectionName(gds);
    }

    public final GridParameter getParameter(GridRecord gr) {
        String name = gr.getParameterName();
        GempakParameter gp = GempakGridParameterTable.getParameter(name);
        if (gp != null) {
            return gp;
        }
        return new GridParameter(0, name, name, "");
    }

    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    public final String getLevelName(GridRecord gr) {
        String levelName = GempakUtil.LV_CCRD(gr.getLevelType1());
        return levelName;
    }

    public final String getLevelDescription(GridRecord gr) {
        String levelName = this.getLevelName(gr);
        if (levelName.equals("PRES")) {
            return "pressure";
        }
        if (levelName.equals("NONE")) {
            return "surface";
        }
        if (levelName.equals("HGHT")) {
            return "height_above_ground";
        }
        if (levelName.equals("THTA")) {
            return "isentropic";
        }
        if (levelName.equals("SGMA")) {
            return "sigma";
        }
        if (levelName.equals("DPTH")) {
            return "depth";
        }
        if (levelName.equals("PDLY")) {
            return "layer_between_two_pressure_difference_from_ground";
        }
        if (levelName.equals("FRZL")) {
            return "zeroDegC_isotherm";
        }
        if (levelName.equals("TROP")) {
            return "tropopause";
        }
        if (levelName.equals("CLDL")) {
            return "cloud_base";
        }
        if (levelName.equals("CLDT")) {
            return "cloud_tops";
        }
        if (levelName.equals("MWSL")) {
            return "maximum_wind_level";
        }
        return levelName;
    }

    public final String getLevelUnit(GridRecord gr) {
        String levelName = this.getLevelName(gr);
        if (levelName.equals("PRES")) {
            return "hPa";
        }
        if (levelName.equals("HGHT")) {
            return "m";
        }
        if (levelName.equals("THTA")) {
            return "K";
        }
        if (levelName.equals("SGMA")) {
            return "";
        }
        if (levelName.equals("DPTH")) {
            return "m";
        }
        if (levelName.equals("PDLY")) {
            return "hPa";
        }
        return "";
    }

    public final String getFirstTimeRangeUnitName() {
        return "minute";
    }

    public final Date getFirstBaseTime() {
        return this.sample.getReferenceTime();
    }

    public final boolean isLatLon(GridDefRecord gds) {
        return this.getProjectionName(gds).equals("CED");
    }

    public final int getProjectionType(GridDefRecord gds) {
        String name = this.getProjectionName(gds).trim();
        if (name.equals("CED")) {
            return -1;
        }
        if (name.equals("MER")) {
            return 3;
        }
        if (name.equals("MCD")) {
            return 3;
        }
        if (name.equals("LCC")) {
            return 2;
        }
        if (name.equals("SCC")) {
            return 2;
        }
        if (name.equals("PS")) {
            return 1;
        }
        if (name.equals("STR")) {
            return 1;
        }
        return -1;
    }

    public final boolean isVerticalCoordinate(GridRecord gr) {
        int type = gr.getLevelType1();
        return type > GempakUtil.vertCoords.length || !GempakUtil.vertCoords[type].equals("NONE");
    }

    public final boolean isPositiveUp(GridRecord gr) {
        int type = gr.getLevelType1();
        return type != 1 && type != 5;
    }

    public final float getFirstMissingValue() {
        return -9999.0f;
    }

    public boolean isLayer(GridRecord gr) {
        return gr.getLevel2() != -1.0;
    }

    private String getProjectionName(GridDefRecord gds) {
        return gds.getParam("ProjFlag");
    }

    public String getGridType() {
        return "GEMPAK";
    }
}

