/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import java.rmi.RemoteException;
import ucar.multiarray.Accessor;
import ucar.multiarray.IndexIterator;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.Dimension;
import ucar.netcdf.ProtoVariable;
import visad.Data;
import visad.Field;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.out.CoordVar;
import visad.data.netcdf.out.DependentRealVar;
import visad.data.netcdf.out.DependentTextVar;
import visad.data.netcdf.out.FieldAccessor;
import visad.data.netcdf.out.IndependentVar;
import visad.data.netcdf.out.RealAccessor;
import visad.data.netcdf.out.TextAccessor;
import visad.data.netcdf.out.TrivialAccessor;
import visad.data.netcdf.out.TupleAccessor;
import visad.data.netcdf.out.VisADAccessor;

public class VisADAdapter
extends AbstractNetcdf {
    public VisADAdapter(Data data) throws BadFormException, VisADException, RemoteException, IOException {
        try {
            this.visit(data, (VisADAccessor)new TrivialAccessor(data));
        }
        catch (UnimplementedException e) {
            throw new BadFormException(e.getMessage());
        }
    }

    protected void visit(Data data, VisADAccessor outerAccessor) throws UnimplementedException, BadFormException, VisADException, RemoteException, IOException {
        if (data instanceof Text) {
            this.visit((Text)data, outerAccessor);
        } else if (data instanceof Real) {
            this.visit((Real)data, outerAccessor);
        } else if (data instanceof Tuple) {
            this.visit((Tuple)data, outerAccessor);
        } else if (data instanceof Field) {
            this.visit((Field)data, outerAccessor);
        } else {
            throw new UnimplementedException("VisAD data type not yet supported: " + data.getClass().getName());
        }
    }

    protected void visit(Text text, VisADAccessor outerAccessor) throws BadFormException, IOException {
        int charLen = 1;
        IndexIterator index = new IndexIterator(outerAccessor.getLengths());
        while (index.notDone()) {
            int len = ((Text)outerAccessor.get(index.value())).getValue().length();
            if (len > charLen) {
                charLen = len;
            }
            index.incr();
        }
        String dimName = ((ScalarType)text.getType()).getName() + "_len";
        Dimension charDim = new Dimension(dimName, charLen);
        this.putDimension(charDim);
        DependentTextVar var = new DependentTextVar(text, new TextAccessor(charDim, outerAccessor));
        try {
            this.add(var, var);
        }
        catch (Exception e) {
            throw new BadFormException(e.getMessage());
        }
    }

    protected void visit(Real real, VisADAccessor outerAccessor) throws BadFormException, VisADException {
        DependentRealVar var = new DependentRealVar(real, new RealAccessor(outerAccessor));
        try {
            this.add(var, var);
        }
        catch (Exception e) {
            throw new BadFormException(e.getMessage());
        }
    }

    protected void visit(Tuple tuple, VisADAccessor outerAccessor) throws VisADException, RemoteException, IOException {
        int componentCount = tuple.getDimension();
        for (int i = 0; i < componentCount; ++i) {
            this.visit(tuple.getComponent(i), (VisADAccessor)new TupleAccessor(i, outerAccessor));
        }
    }

    protected void visit(Field field, VisADAccessor outerAccessor) throws RemoteException, VisADException, BadFormException, UnimplementedException, IOException {
        Dimension[] dims;
        Set set = field.getDomainSet();
        if (set instanceof LinearSet) {
            dims = this.defineLinearSetDims((GriddedSet)set);
        } else if (set instanceof SampledSet) {
            dims = new Dimension[]{this.defineSampledSetDim((SampledSet)set)};
        } else {
            throw new BadFormException("Can't handle a " + set.getClass().getName() + " domain set");
        }
        this.visit(field.getSample(0), (VisADAccessor)new FieldAccessor(this.reverse(dims), outerAccessor));
    }

    protected Dimension[] defineLinearSetDims(GriddedSet set) throws VisADException, BadFormException {
        int rank = set.getDimension();
        Dimension[] dims = new Dimension[rank];
        RealTupleType domainType = ((SetType)set.getType()).getDomain();
        Unit[] units = set.getSetUnits();
        for (int idim = 0; idim < rank; ++idim) {
            Linear1DSet linear1DSet = ((LinearSet)((Object)set)).getLinear1DComponent(idim);
            int length = linear1DSet.getLength(0);
            String name = ((RealType)domainType.getComponent(idim)).getName();
            dims[idim] = new Dimension(name, length);
            if (linear1DSet.getFirst() == 0.0 && linear1DSet.getStep() == 1.0) continue;
            CoordVar var = new CoordVar(name, dims[idim], units[idim], linear1DSet);
            try {
                this.add(var, var);
                continue;
            }
            catch (Exception e) {
                throw new BadFormException(e.getMessage());
            }
        }
        return dims;
    }

    protected Dimension defineSampledSetDim(SampledSet set) throws VisADException, BadFormException {
        int rank = set.getManifoldDimension();
        return rank == 1 ? this.define1DDim(set) : this.defineNDDim(set);
    }

    protected Dimension define1DDim(SampledSet set) throws VisADException, BadFormException {
        RealTupleType domainType = ((SetType)set.getType()).getDomain();
        String name = ((RealType)domainType.getComponent(0)).getName();
        Dimension dim = new Dimension(name, set.getLength());
        Unit[] units = set.getSetUnits();
        if (!(set instanceof Gridded1DSet)) {
            throw new BadFormException("Domain set not Gridded1DSet");
        }
        CoordVar var = new CoordVar(name, dim, units[0], (Gridded1DSet)set);
        try {
            this.add(var, var);
        }
        catch (Exception e) {
            throw new BadFormException(e.getMessage());
        }
        return dim;
    }

    protected Dimension defineNDDim(SampledSet set) throws VisADException, BadFormException {
        int idim;
        RealTupleType domainType = ((SetType)set.getType()).getDomain();
        int rank = domainType.getDimension();
        Unit[] units = set.getSetUnits();
        String[] names = new String[rank];
        for (idim = 0; idim < rank; ++idim) {
            names[idim] = ((RealType)domainType.getComponent(idim)).getName();
        }
        int len = names[0].length();
        for (int idim2 = 1; idim2 < rank; ++idim2) {
            len += 1 + names[idim2].length();
        }
        StringBuffer name = new StringBuffer(len += 4);
        name.append(names[0]);
        for (int idim3 = 1; idim3 < rank; ++idim3) {
            name.append("_");
            name.append(names[idim3]);
        }
        name.append("_ndx");
        Dimension dim = new Dimension(name.toString(), set.getLength());
        for (idim = 0; idim < rank; ++idim) {
            IndependentVar var = new IndependentVar(names[idim], dim, units[idim], set, idim);
            try {
                this.add(var, var);
                continue;
            }
            catch (Exception e) {
                throw new BadFormException(e.getMessage());
            }
        }
        return dim;
    }

    protected Dimension[] reverse(Dimension[] inDims) {
        Dimension[] outDims = new Dimension[inDims.length];
        for (int i = 0; i < inDims.length; ++i) {
            outDims[i] = inDims[inDims.length - 1 - i];
        }
        return outDims;
    }

    public Accessor ioFactory(ProtoVariable protoVar) {
        throw new UnsupportedOperationException();
    }
}

