/*
 * Decompiled with CFR 0.152.
 */
package org.flightgear.fgfsclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class FGFSConnection {
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;

    public FGFSConnection(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        this.out.println("data\r");
    }

    public synchronized void close() throws IOException {
        this.out.println("quit\r");
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    public synchronized String get(String name) throws IOException {
        this.out.println("get " + name + '\r');
        return this.in.readLine();
    }

    public synchronized void set(String name, String value) throws IOException {
        this.out.println("set " + name + ' ' + value + '\r');
    }

    public boolean getBoolean(String name) throws IOException {
        return this.get(name).equals("true");
    }

    public int getInt(String name) throws IOException {
        return Integer.parseInt(this.get(name));
    }

    public long getLong(String name) throws IOException {
        return Long.parseLong(this.get(name));
    }

    public float getFloat(String name) throws IOException {
        return Float.parseFloat(this.get(name));
    }

    public double getDouble(String name) throws IOException {
        return Double.parseDouble(this.get(name));
    }

    public void setBoolean(String name, boolean value) throws IOException {
        this.set(name, value ? "true" : "false");
    }

    public void setInt(String name, int value) throws IOException {
        this.set(name, Integer.toString(value));
    }

    public void setLong(String name, long value) throws IOException {
        this.set(name, Long.toString(value));
    }

    public void setFloat(String name, float value) throws IOException {
        this.set(name, Float.toString(value));
    }

    public void setDouble(String name, double value) throws IOException {
        this.set(name, Double.toString(value));
    }
}

