/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.materialdesignicons;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on Material Design Icons v1.7.22
 * https://materialdesignicons.com
 *
 * @author Jens Deters (mail@jensd.de)
 */
public enum MaterialDesignIcon implements GlyphIcons {

    ACCESS_POINT("\uf002"),
    ACCESS_POINT_NETWORK("\uf003"),
    ACCOUNT("\uf004"),
    ACCOUNT_ALERT("\uf005"),
    ACCOUNT_BOX("\uf006"),
    ACCOUNT_BOX_OUTLINE("\uf007"),
    ACCOUNT_CARD_DETAILS("\uf5D2"),
    ACCOUNT_CHECK("\uf008"),
    ACCOUNT_CIRCLE("\uf009"),
    ACCOUNT_CONVERT("\uf00A"),
    ACCOUNT_EDIT("\uf6BB"),
    ACCOUNT_KEY("\uf00B"),
    ACCOUNT_LOCATION("\uf00C"),
    ACCOUNT_MINUS("\uf00D"),
    ACCOUNT_MULTIPLE("\uf00E"),
    ACCOUNT_MULTIPLE_MINUS("\uf5D3"),
    ACCOUNT_MULTIPLE_OUTLINE("\uf00F"),
    ACCOUNT_MULTIPLE_PLUS("\uf010"),
    ACCOUNT_NETWORK("\uf011"),
    ACCOUNT_OFF("\uf012"),
    ACCOUNT_OUTLINE("\uf013"),
    ACCOUNT_PLUS("\uf014"),
    ACCOUNT_REMOVE("\uf015"),
    ACCOUNT_SEARCH("\uf016"),
    ACCOUNT_SETTINGS("\uf630"),
    ACCOUNT_SETTINGS_VARIANT("\uf631"),
    ACCOUNT_STAR("\uf017"),
    ACCOUNT_SWITCH("\uf019"),
    ADJUST("\uf01A"),
    AIR_CONDITIONER("\uf01B"),
    AIRBALLOON("\uf01C"),
    AIRPLANE("\uf01D"),
    AIRPLANE_LANDING("\uf5D4"),
    AIRPLANE_OFF("\uf01E"),
    AIRPLANE_TAKEOFF("\uf5D5"),
    AIRPLAY("\uf01F"),
    ALARM("\uf020"),
    ALARM_BELL("\uf78D"),
    ALARM_CHECK("\uf021"),
    ALARM_LIGHT("\uf78E"),
    ALARM_MULTIPLE("\uf022"),
    ALARM_OFF("\uf023"),
    ALARM_PLUS("\uf024"),
    ALARM_SNOOZE("\uf68D"),
    ALBUM("\uf025"),
    ALERT("\uf026"),
    ALERT_BOX("\uf027"),
    ALERT_CIRCLE("\uf028"),
    ALERT_CIRCLE_OUTLINE("\uf5D6"),
    ALERT_DECAGRAM("\uf6BC"),
    ALERT_OCTAGON("\uf029"),
    ALERT_OCTAGRAM("\uf766"),
    ALERT_OUTLINE("\uf02A"),
    ALL_INCLUSIVE("\uf6BD"),
    ALPHA("\uf02B"),
    ALPHABETICAL("\uf02C"),
    ALTIMETER("\uf5D7"),
    AMAZON("\uf02D"),
    AMAZON_CLOUDDRIVE("\uf02E"),
    AMBULANCE("\uf02F"),
    AMPLIFIER("\uf030"),
    ANCHOR("\uf031"),
    ANDROID("\uf032"),
    ANDROID_DEBUG_BRIDGE("\uf033"),
    ANDROID_HEAD("\uf78F"),
    ANDROID_STUDIO("\uf034"),
    ANGULAR("\uf6B1"),
    ANGULARJS("\uf6BE"),
    ANIMATION("\uf5D8"),
    APPLE("\uf035"),
    APPLE_FINDER("\uf036"),
    APPLE_IOS("\uf037"),
    APPLE_KEYBOARD_CAPS("\uf632"),
    APPLE_KEYBOARD_COMMAND("\uf633"),
    APPLE_KEYBOARD_CONTROL("\uf634"),
    APPLE_KEYBOARD_OPTION("\uf635"),
    APPLE_KEYBOARD_SHIFT("\uf636"),
    APPLE_MOBILEME("\uf038"),
    APPLE_SAFARI("\uf039"),
    APPLICATION("\uf614"),
    APPROVAL("\uf790"),
    APPS("\uf03B"),
    ARCHIVE("\uf03C"),
    ARRANGE_BRING_FORWARD("\uf03D"),
    ARRANGE_BRING_TO_FRONT("\uf03E"),
    ARRANGE_SEND_BACKWARD("\uf03F"),
    ARRANGE_SEND_TO_BACK("\uf040"),
    ARROW_ALL("\uf041"),
    ARROW_BOTTOM_LEFT("\uf042"),
    ARROW_BOTTOM_RIGHT("\uf043"),
    ARROW_COLLAPSE("\uf615"),
    ARROW_COLLAPSE_ALL("\uf044"),
    ARROW_COLLAPSE_DOWN("\uf791"),
    ARROW_COLLAPSE_LEFT("\uf792"),
    ARROW_COLLAPSE_RIGHT("\uf793"),
    ARROW_COLLAPSE_UP("\uf794"),
    ARROW_DOWN("\uf045"),
    ARROW_DOWN_BOLD("\uf72D"),
    ARROW_DOWN_BOLD_BOX("\uf72E"),
    ARROW_DOWN_BOLD_BOX_OUTLINE("\uf72F"),
    ARROW_DOWN_BOLD_CIRCLE("\uf047"),
    ARROW_DOWN_BOLD_CIRCLE_OUTLINE("\uf048"),
    ARROW_DOWN_BOLD_HEXAGON_OUTLINE("\uf049"),
    ARROW_DOWN_BOX("\uf6BF"),
    ARROW_DOWN_DROP_CIRCLE("\uf04A"),
    ARROW_DOWN_DROP_CIRCLE_OUTLINE("\uf04B"),
    ARROW_DOWN_THICK("\uf046"),
    ARROW_EXPAND("\uf616"),
    ARROW_EXPAND_ALL("\uf04C"),
    ARROW_EXPAND_DOWN("\uf795"),
    ARROW_EXPAND_LEFT("\uf796"),
    ARROW_EXPAND_RIGHT("\uf797"),
    ARROW_EXPAND_UP("\uf798"),
    ARROW_LEFT("\uf04D"),
    ARROW_LEFT_BOLD("\uf730"),
    ARROW_LEFT_BOLD_BOX("\uf731"),
    ARROW_LEFT_BOLD_BOX_OUTLINE("\uf732"),
    ARROW_LEFT_BOLD_CIRCLE("\uf04F"),
    ARROW_LEFT_BOLD_CIRCLE_OUTLINE("\uf050"),
    ARROW_LEFT_BOLD_HEXAGON_OUTLINE("\uf051"),
    ARROW_LEFT_BOX("\uf6C0"),
    ARROW_LEFT_DROP_CIRCLE("\uf052"),
    ARROW_LEFT_DROP_CIRCLE_OUTLINE("\uf053"),
    ARROW_LEFT_THICK("\uf04E"),
    ARROW_RIGHT("\uf054"),
    ARROW_RIGHT_BOLD("\uf733"),
    ARROW_RIGHT_BOLD_BOX("\uf734"),
    ARROW_RIGHT_BOLD_BOX_OUTLINE("\uf735"),
    ARROW_RIGHT_BOLD_CIRCLE("\uf056"),
    ARROW_RIGHT_BOLD_CIRCLE_OUTLINE("\uf057"),
    ARROW_RIGHT_BOLD_HEXAGON_OUTLINE("\uf058"),
    ARROW_RIGHT_BOX("\uf6C1"),
    ARROW_RIGHT_DROP_CIRCLE("\uf059"),
    ARROW_RIGHT_DROP_CIRCLE_OUTLINE("\uf05A"),
    ARROW_RIGHT_THICK("\uf055"),
    ARROW_TOP_LEFT("\uf05B"),
    ARROW_TOP_RIGHT("\uf05C"),
    ARROW_UP("\uf05D"),
    ARROW_UP_BOLD("\uf736"),
    ARROW_UP_BOLD_BOX("\uf737"),
    ARROW_UP_BOLD_BOX_OUTLINE("\uf738"),
    ARROW_UP_BOLD_CIRCLE("\uf05F"),
    ARROW_UP_BOLD_CIRCLE_OUTLINE("\uf060"),
    ARROW_UP_BOLD_HEXAGON_OUTLINE("\uf061"),
    ARROW_UP_BOX("\uf6C2"),
    ARROW_UP_DROP_CIRCLE("\uf062"),
    ARROW_UP_DROP_CIRCLE_OUTLINE("\uf063"),
    ARROW_UP_THICK("\uf05E"),
    ASSISTANT("\uf064"),
    ASTERISK("\uf6C3"),
    AT("\uf065"),
    ATOM("\uf767"),
    ATTACHMENT("\uf066"),
    AUDIOBOOK("\uf067"),
    AUTO_FIX("\uf068"),
    AUTO_UPLOAD("\uf069"),
    AUTORENEW("\uf06A"),
    AV_TIMER("\uf06B"),
    BABY("\uf06C"),
    BABY_BUGGY("\uf68E"),
    BACKBURGER("\uf06D"),
    BACKSPACE("\uf06E"),
    BACKUP_RESTORE("\uf06F"),
    BANDCAMP("\uf674"),
    BANK("\uf070"),
    BARCODE("\uf071"),
    BARCODE_SCAN("\uf072"),
    BARLEY("\uf073"),
    BARREL("\uf074"),
    BASECAMP("\uf075"),
    BASKET("\uf076"),
    BASKET_FILL("\uf077"),
    BASKET_UNFILL("\uf078"),
    BATTERY("\uf079"),
    BATTERY_10("\uf07A"),
    BATTERY_20("\uf07B"),
    BATTERY_30("\uf07C"),
    BATTERY_40("\uf07D"),
    BATTERY_50("\uf07E"),
    BATTERY_60("\uf07F"),
    BATTERY_70("\uf080"),
    BATTERY_80("\uf081"),
    BATTERY_90("\uf082"),
    BATTERY_ALERT("\uf083"),
    BATTERY_CHARGING("\uf084"),
    BATTERY_CHARGING_100("\uf085"),
    BATTERY_CHARGING_20("\uf086"),
    BATTERY_CHARGING_30("\uf087"),
    BATTERY_CHARGING_40("\uf088"),
    BATTERY_CHARGING_60("\uf089"),
    BATTERY_CHARGING_80("\uf08A"),
    BATTERY_CHARGING_90("\uf08B"),
    BATTERY_MINUS("\uf08C"),
    BATTERY_NEGATIVE("\uf08D"),
    BATTERY_OUTLINE("\uf08E"),
    BATTERY_PLUS("\uf08F"),
    BATTERY_POSITIVE("\uf090"),
    BATTERY_UNKNOWN("\uf091"),
    BEACH("\uf092"),
    BEAKER("\uf68F"),
    BEATS("\uf097"),
    BEER("\uf098"),
    BEHANCE("\uf099"),
    BELL("\uf09A"),
    BELL_OFF("\uf09B"),
    BELL_OUTLINE("\uf09C"),
    BELL_PLUS("\uf09D"),
    BELL_RING("\uf09E"),
    BELL_RING_OUTLINE("\uf09F"),
    BELL_SLEEP("\uf0A0"),
    BETA("\uf0A1"),
    BIBLE("\uf0A2"),
    BIKE("\uf0A3"),
    BING("\uf0A4"),
    BINOCULARS("\uf0A5"),
    BIO("\uf0A6"),
    BIOHAZARD("\uf0A7"),
    BITBUCKET("\uf0A8"),
    BLACK_MESA("\uf0A9"),
    BLACKBERRY("\uf0AA"),
    BLENDER("\uf0AB"),
    BLINDS("\uf0AC"),
    BLOCK_HELPER("\uf0AD"),
    BLOGGER("\uf0AE"),
    BLUETOOTH("\uf0AF"),
    BLUETOOTH_AUDIO("\uf0B0"),
    BLUETOOTH_CONNECT("\uf0B1"),
    BLUETOOTH_OFF("\uf0B2"),
    BLUETOOTH_SETTINGS("\uf0B3"),
    BLUETOOTH_TRANSFER("\uf0B4"),
    BLUR("\uf0B5"),
    BLUR_LINEAR("\uf0B6"),
    BLUR_OFF("\uf0B7"),
    BLUR_RADIAL("\uf0B8"),
    BOMB("\uf690"),
    BOMB_OFF("\uf6C4"),
    BONE("\uf0B9"),
    BOOK("\uf0BA"),
    BOOK_MINUS("\uf5D9"),
    BOOK_MULTIPLE("\uf0BB"),
    BOOK_MULTIPLE_VARIANT("\uf0BC"),
    BOOK_OPEN("\uf0BD"),
    BOOK_OPEN_PAGE_VARIANT("\uf5DA"),
    BOOK_OPEN_VARIANT("\uf0BE"),
    BOOK_PLUS("\uf5DB"),
    BOOK_SECURE("\uf799"),
    BOOK_UNSECURE("\uf79A"),
    BOOK_VARIANT("\uf0BF"),
    BOOKMARK("\uf0C0"),
    BOOKMARK_CHECK("\uf0C1"),
    BOOKMARK_MUSIC("\uf0C2"),
    BOOKMARK_OUTLINE("\uf0C3"),
    BOOKMARK_PLUS("\uf0C5"),
    BOOKMARK_PLUS_OUTLINE("\uf0C4"),
    BOOKMARK_REMOVE("\uf0C6"),
    BOOMBOX("\uf5DC"),
    BOOTSTRAP("\uf6C5"),
    BORDER_ALL("\uf0C7"),
    BORDER_BOTTOM("\uf0C8"),
    BORDER_COLOR("\uf0C9"),
    BORDER_HORIZONTAL("\uf0CA"),
    BORDER_INSIDE("\uf0CB"),
    BORDER_LEFT("\uf0CC"),
    BORDER_NONE("\uf0CD"),
    BORDER_OUTSIDE("\uf0CE"),
    BORDER_RIGHT("\uf0CF"),
    BORDER_STYLE("\uf0D0"),
    BORDER_TOP("\uf0D1"),
    BORDER_VERTICAL("\uf0D2"),
    BOW_TIE("\uf677"),
    BOWL("\uf617"),
    BOWLING("\uf0D3"),
    BOX("\uf0D4"),
    BOX_CUTTER("\uf0D5"),
    BOX_SHADOW("\uf637"),
    BRIDGE("\uf618"),
    BRIEFCASE("\uf0D6"),
    BRIEFCASE_CHECK("\uf0D7"),
    BRIEFCASE_DOWNLOAD("\uf0D8"),
    BRIEFCASE_UPLOAD("\uf0D9"),
    BRIGHTNESS_1("\uf0DA"),
    BRIGHTNESS_2("\uf0DB"),
    BRIGHTNESS_3("\uf0DC"),
    BRIGHTNESS_4("\uf0DD"),
    BRIGHTNESS_5("\uf0DE"),
    BRIGHTNESS_6("\uf0DF"),
    BRIGHTNESS_7("\uf0E0"),
    BRIGHTNESS_AUTO("\uf0E1"),
    BROOM("\uf0E2"),
    BRUSH("\uf0E3"),
    BUFFER("\uf619"),
    BUG("\uf0E4"),
    BULLETIN_BOARD("\uf0E5"),
    BULLHORN("\uf0E6"),
    BULLSEYE("\uf5DD"),
    BURST_MODE("\uf5DE"),
    BUS("\uf0E7"),
    BUS_ARTICULATED_END("\uf79B"),
    BUS_ARTICULATED_FRONT("\uf79C"),
    BUS_DOUBLE_DECKER("\uf79D"),
    BUS_SCHOOL("\uf79E"),
    BUS_SIDE("\uf79F"),
    CACHED("\uf0E8"),
    CAKE("\uf0E9"),
    CAKE_LAYERED("\uf0EA"),
    CAKE_VARIANT("\uf0EB"),
    CALCULATOR("\uf0EC"),
    CALENDAR("\uf0ED"),
    CALENDAR_BLANK("\uf0EE"),
    CALENDAR_CHECK("\uf0EF"),
    CALENDAR_CLOCK("\uf0F0"),
    CALENDAR_MULTIPLE("\uf0F1"),
    CALENDAR_MULTIPLE_CHECK("\uf0F2"),
    CALENDAR_PLUS("\uf0F3"),
    CALENDAR_QUESTION("\uf691"),
    CALENDAR_RANGE("\uf678"),
    CALENDAR_REMOVE("\uf0F4"),
    CALENDAR_TEXT("\uf0F5"),
    CALENDAR_TODAY("\uf0F6"),
    CALL_MADE("\uf0F7"),
    CALL_MERGE("\uf0F8"),
    CALL_MISSED("\uf0F9"),
    CALL_RECEIVED("\uf0FA"),
    CALL_SPLIT("\uf0FB"),
    CAMCORDER("\uf0FC"),
    CAMCORDER_BOX("\uf0FD"),
    CAMCORDER_BOX_OFF("\uf0FE"),
    CAMCORDER_OFF("\uf0FF"),
    CAMERA("\uf100"),
    CAMERA_BURST("\uf692"),
    CAMERA_ENHANCE("\uf101"),
    CAMERA_FRONT("\uf102"),
    CAMERA_FRONT_VARIANT("\uf103"),
    CAMERA_GOPRO("\uf7A0"),
    CAMERA_IRIS("\uf104"),
    CAMERA_METERING_CENTER("\uf7A1"),
    CAMERA_METERING_MATRIX("\uf7A2"),
    CAMERA_METERING_PARTIAL("\uf7A3"),
    CAMERA_METERING_SPOT("\uf7A4"),
    CAMERA_OFF("\uf5DF"),
    CAMERA_PARTY_MODE("\uf105"),
    CAMERA_REAR("\uf106"),
    CAMERA_REAR_VARIANT("\uf107"),
    CAMERA_SWITCH("\uf108"),
    CAMERA_TIMER("\uf109"),
    CANCEL("\uf739"),
    CANDLE("\uf5E2"),
    CANDYCANE("\uf10A"),
    CANNABIS("\uf7A5"),
    CAR("\uf10B"),
    CAR_BATTERY("\uf10C"),
    CAR_CONNECTED("\uf10D"),
    CAR_CONVERTABLE("\uf7A6"),
    CAR_ESTATE("\uf7A7"),
    CAR_HATCHBACK("\uf7A8"),
    CAR_PICKUP("\uf7A9"),
    CAR_SIDE("\uf7AA"),
    CAR_SPORTS("\uf7AB"),
    CAR_WASH("\uf10E"),
    CARAVAN("\uf7AC"),
    CARDS("\uf638"),
    CARDS_OUTLINE("\uf639"),
    CARDS_PLAYING_OUTLINE("\uf63A"),
    CARDS_VARIANT("\uf6C6"),
    CARROT("\uf10F"),
    CART("\uf110"),
    CART_OFF("\uf66B"),
    CART_OUTLINE("\uf111"),
    CART_PLUS("\uf112"),
    CASE_SENSITIVE_ALT("\uf113"),
    CASH("\uf114"),
    CASH_100("\uf115"),
    CASH_MULTIPLE("\uf116"),
    CASH_USD("\uf117"),
    CAST("\uf118"),
    CAST_CONNECTED("\uf119"),
    CAST_OFF("\uf789"),
    CASTLE("\uf11A"),
    CAT("\uf11B"),
    CCTV("\uf7AD"),
    CEILING_LIGHT("\uf768"),
    CELLPHONE("\uf11C"),
    CELLPHONE_ANDROID("\uf11D"),
    CELLPHONE_BASIC("\uf11E"),
    CELLPHONE_DOCK("\uf11F"),
    CELLPHONE_IPHONE("\uf120"),
    CELLPHONE_LINK("\uf121"),
    CELLPHONE_LINK_OFF("\uf122"),
    CELLPHONE_SETTINGS("\uf123"),
    CERTIFICATE("\uf124"),
    CHAIR_SCHOOL("\uf125"),
    CHART_ARC("\uf126"),
    CHART_AREASPLINE("\uf127"),
    CHART_BAR("\uf128"),
    CHART_BAR_STACKED("\uf769"),
    CHART_BUBBLE("\uf5E3"),
    CHART_DONUT("\uf7AE"),
    CHART_DONUT_VARIANT("\uf7AF"),
    CHART_GANTT("\uf66C"),
    CHART_HISTOGRAM("\uf129"),
    CHART_LINE("\uf12A"),
    CHART_LINE_STACKED("\uf76A"),
    CHART_LINE_VARIANT("\uf7B0"),
    CHART_PIE("\uf12B"),
    CHART_SCATTERPLOT_HEXBIN("\uf66D"),
    CHART_TIMELINE("\uf66E"),
    CHECK("\uf12C"),
    CHECK_ALL("\uf12D"),
    CHECK_CIRCLE("\uf5E0"),
    CHECK_CIRCLE_OUTLINE("\uf5E1"),
    CHECKBOX_BLANK("\uf12E"),
    CHECKBOX_BLANK_CIRCLE("\uf12F"),
    CHECKBOX_BLANK_CIRCLE_OUTLINE("\uf130"),
    CHECKBOX_BLANK_OUTLINE("\uf131"),
    CHECKBOX_MARKED("\uf132"),
    CHECKBOX_MARKED_CIRCLE("\uf133"),
    CHECKBOX_MARKED_CIRCLE_OUTLINE("\uf134"),
    CHECKBOX_MARKED_OUTLINE("\uf135"),
    CHECKBOX_MULTIPLE_BLANK("\uf136"),
    CHECKBOX_MULTIPLE_BLANK_CIRCLE("\uf63B"),
    CHECKBOX_MULTIPLE_BLANK_CIRCLE_OUTLINE("\uf63C"),
    CHECKBOX_MULTIPLE_BLANK_OUTLINE("\uf137"),
    CHECKBOX_MULTIPLE_MARKED("\uf138"),
    CHECKBOX_MULTIPLE_MARKED_CIRCLE("\uf63D"),
    CHECKBOX_MULTIPLE_MARKED_CIRCLE_OUTLINE("\uf63E"),
    CHECKBOX_MULTIPLE_MARKED_OUTLINE("\uf139"),
    CHECKERBOARD("\uf13A"),
    CHEMICAL_WEAPON("\uf13B"),
    CHEVRON_DOUBLE_DOWN("\uf13C"),
    CHEVRON_DOUBLE_LEFT("\uf13D"),
    CHEVRON_DOUBLE_RIGHT("\uf13E"),
    CHEVRON_DOUBLE_UP("\uf13F"),
    CHEVRON_DOWN("\uf140"),
    CHEVRON_LEFT("\uf141"),
    CHEVRON_RIGHT("\uf142"),
    CHEVRON_UP("\uf143"),
    CHILI_HOT("\uf7B1"),
    CHILI_MEDIUM("\uf7B2"),
    CHILI_MILD("\uf7B3"),
    CHIP("\uf61A"),
    CHURCH("\uf144"),
    CIRCLE("\uf764"),
    CIRCLE_OUTLINE("\uf765"),
    CISCO_WEBEX("\uf145"),
    CITY("\uf146"),
    CLIPBOARD("\uf147"),
    CLIPBOARD_ACCOUNT("\uf148"),
    CLIPBOARD_ALERT("\uf149"),
    CLIPBOARD_ARROW_DOWN("\uf14A"),
    CLIPBOARD_ARROW_LEFT("\uf14B"),
    CLIPBOARD_CHECK("\uf14C"),
    CLIPBOARD_FLOW("\uf6C7"),
    CLIPBOARD_OUTLINE("\uf14D"),
    CLIPBOARD_PLUS("\uf750"),
    CLIPBOARD_TEXT("\uf14E"),
    CLIPPY("\uf14F"),
    CLOCK("\uf150"),
    CLOCK_ALERT("\uf5CE"),
    CLOCK_END("\uf151"),
    CLOCK_FAST("\uf152"),
    CLOCK_IN("\uf153"),
    CLOCK_OUT("\uf154"),
    CLOCK_START("\uf155"),
    CLOSE("\uf156"),
    CLOSE_BOX("\uf157"),
    CLOSE_BOX_OUTLINE("\uf158"),
    CLOSE_CIRCLE("\uf159"),
    CLOSE_CIRCLE_OUTLINE("\uf15A"),
    CLOSE_NETWORK("\uf15B"),
    CLOSE_OCTAGON("\uf15C"),
    CLOSE_OCTAGON_OUTLINE("\uf15D"),
    CLOSE_OUTLINE("\uf6C8"),
    CLOSED_CAPTION("\uf15E"),
    CLOUD("\uf15F"),
    CLOUD_BRACES("\uf7B4"),
    CLOUD_CHECK("\uf160"),
    CLOUD_CIRCLE("\uf161"),
    CLOUD_DOWNLOAD("\uf162"),
    CLOUD_OFF_OUTLINE("\uf164"),
    CLOUD_OUTLINE("\uf163"),
    CLOUD_PRINT("\uf165"),
    CLOUD_PRINT_OUTLINE("\uf166"),
    CLOUD_SYNC("\uf63F"),
    CLOUD_TAGS("\uf7B5"),
    CLOUD_UPLOAD("\uf167"),
    CODE_ARRAY("\uf168"),
    CODE_BRACES("\uf169"),
    CODE_BRACKETS("\uf16A"),
    CODE_EQUAL("\uf16B"),
    CODE_GREATER_THAN("\uf16C"),
    CODE_GREATER_THAN_OR_EQUAL("\uf16D"),
    CODE_LESS_THAN("\uf16E"),
    CODE_LESS_THAN_OR_EQUAL("\uf16F"),
    CODE_NOT_EQUAL("\uf170"),
    CODE_NOT_EQUAL_VARIANT("\uf171"),
    CODE_PARENTHESES("\uf172"),
    CODE_STRING("\uf173"),
    CODE_TAGS("\uf174"),
    CODE_TAGS_CHECK("\uf693"),
    CODEPEN("\uf175"),
    COFFEE("\uf176"),
    COFFEE_OUTLINE("\uf6C9"),
    COFFEE_TO_GO("\uf177"),
    COIN("\uf178"),
    COINS("\uf694"),
    COLLAGE("\uf640"),
    COLOR_HELPER("\uf179"),
    COMMENT("\uf17A"),
    COMMENT_ACCOUNT("\uf17B"),
    COMMENT_ACCOUNT_OUTLINE("\uf17C"),
    COMMENT_ALERT("\uf17D"),
    COMMENT_ALERT_OUTLINE("\uf17E"),
    COMMENT_CHECK("\uf17F"),
    COMMENT_CHECK_OUTLINE("\uf180"),
    COMMENT_MULTIPLE_OUTLINE("\uf181"),
    COMMENT_OUTLINE("\uf182"),
    COMMENT_PLUS_OUTLINE("\uf183"),
    COMMENT_PROCESSING("\uf184"),
    COMMENT_PROCESSING_OUTLINE("\uf185"),
    COMMENT_QUESTION_OUTLINE("\uf186"),
    COMMENT_REMOVE_OUTLINE("\uf187"),
    COMMENT_TEXT("\uf188"),
    COMMENT_TEXT_OUTLINE("\uf189"),
    COMPARE("\uf18A"),
    COMPASS("\uf18B"),
    COMPASS_OUTLINE("\uf18C"),
    CONSOLE("\uf18D"),
    CONSOLE_LINE("\uf7B6"),
    CONTACT_MAIL("\uf18E"),
    CONTACTS("\uf6CA"),
    CONTENT_COPY("\uf18F"),
    CONTENT_CUT("\uf190"),
    CONTENT_DUPLICATE("\uf191"),
    CONTENT_PASTE("\uf192"),
    CONTENT_SAVE("\uf193"),
    CONTENT_SAVE_ALL("\uf194"),
    CONTENT_SAVE_SETTINGS("\uf61B"),
    CONTRAST("\uf195"),
    CONTRAST_BOX("\uf196"),
    CONTRAST_CIRCLE("\uf197"),
    COOKIE("\uf198"),
    COPYRIGHT("\uf5E6"),
    CORN("\uf7B7"),
    COUNTER("\uf199"),
    COW("\uf19A"),
    CREATION("\uf1C9"),
    CREDIT_CARD("\uf19B"),
    CREDIT_CARD_MULTIPLE("\uf19C"),
    CREDIT_CARD_OFF("\uf5E4"),
    CREDIT_CARD_PLUS("\uf675"),
    CREDIT_CARD_SCAN("\uf19D"),
    CROP("\uf19E"),
    CROP_FREE("\uf19F"),
    CROP_LANDSCAPE("\uf1A0"),
    CROP_PORTRAIT("\uf1A1"),
    CROP_ROTATE("\uf695"),
    CROP_SQUARE("\uf1A2"),
    CROSSHAIRS("\uf1A3"),
    CROSSHAIRS_GPS("\uf1A4"),
    CROWN("\uf1A5"),
    CUBE("\uf1A6"),
    CUBE_OUTLINE("\uf1A7"),
    CUBE_SEND("\uf1A8"),
    CUBE_UNFOLDED("\uf1A9"),
    CUP("\uf1AA"),
    CUP_OFF("\uf5E5"),
    CUP_WATER("\uf1AB"),
    CURRENCY_BTC("\uf1AC"),
    CURRENCY_CHF("\uf7B8"),
    CURRENCY_CNY("\uf7B9"),
    CURRENCY_ETH("\uf7BA"),
    CURRENCY_EUR("\uf1AD"),
    CURRENCY_GBP("\uf1AE"),
    CURRENCY_INR("\uf1AF"),
    CURRENCY_JPY("\uf7BB"),
    CURRENCY_KRW("\uf7BC"),
    CURRENCY_NGN("\uf1B0"),
    CURRENCY_RUB("\uf1B1"),
    CURRENCY_SIGN("\uf7BD"),
    CURRENCY_TRY("\uf1B2"),
    CURRENCY_TWD("\uf7BE"),
    CURRENCY_USD("\uf1B3"),
    CURRENCY_USD_OFF("\uf679"),
    CURSOR_DEFAULT("\uf1B4"),
    CURSOR_DEFAULT_OUTLINE("\uf1B5"),
    CURSOR_MOVE("\uf1B6"),
    CURSOR_POINTER("\uf1B7"),
    CURSOR_TEXT("\uf5E7"),
    DATABASE("\uf1B8"),
    DATABASE_MINUS("\uf1B9"),
    DATABASE_PLUS("\uf1BA"),
    DEBUG_STEP_INTO("\uf1BB"),
    DEBUG_STEP_OUT("\uf1BC"),
    DEBUG_STEP_OVER("\uf1BD"),
    DECAGRAM("\uf76B"),
    DECAGRAM_OUTLINE("\uf76C"),
    DECIMAL_DECREASE("\uf1BE"),
    DECIMAL_INCREASE("\uf1BF"),
    DELETE("\uf1C0"),
    DELETE_CIRCLE("\uf682"),
    DELETE_EMPTY("\uf6CB"),
    DELETE_FOREVER("\uf5E8"),
    DELETE_SWEEP("\uf5E9"),
    DELETE_VARIANT("\uf1C1"),
    DELTA("\uf1C2"),
    DESKPHONE("\uf1C3"),
    DESKTOP_CLASSIC("\uf7BF"),
    DESKTOP_MAC("\uf1C4"),
    DESKTOP_TOWER("\uf1C5"),
    DETAILS("\uf1C6"),
    DEVELOPER_BOARD("\uf696"),
    DEVIANTART("\uf1C7"),
    DIALPAD("\uf61C"),
    DIAMOND("\uf1C8"),
    DICE_1("\uf1CA"),
    DICE_2("\uf1CB"),
    DICE_3("\uf1CC"),
    DICE_4("\uf1CD"),
    DICE_5("\uf1CE"),
    DICE_6("\uf1CF"),
    DICE_D10("\uf76E"),
    DICE_D20("\uf5EA"),
    DICE_D4("\uf5EB"),
    DICE_D6("\uf5EC"),
    DICE_D8("\uf5ED"),
    DICE_MULTIPLE("\uf76D"),
    DICTIONARY("\uf61D"),
    DIP_SWITCH("\uf7C0"),
    DIRECTIONS("\uf1D0"),
    DIRECTIONS_FORK("\uf641"),
    DISCORD("\uf66F"),
    DISK("\uf5EE"),
    DISK_ALERT("\uf1D1"),
    DISQUS("\uf1D2"),
    DISQUS_OUTLINE("\uf1D3"),
    DIVISION("\uf1D4"),
    DIVISION_BOX("\uf1D5"),
    DNA("\uf683"),
    DNS("\uf1D6"),
    DO_NOT_DISTURB("\uf697"),
    DO_NOT_DISTURB_OFF("\uf698"),
    DOLBY("\uf6B2"),
    DOMAIN("\uf1D7"),
    DONKEY("\uf7C1"),
    DOTS_HORIZONTAL("\uf1D8"),
    DOTS_HORIZONTAL_CIRCLE("\uf7C2"),
    DOTS_VERTICAL("\uf1D9"),
    DOTS_VERTICAL_CIRCLE("\uf7C3"),
    DOUBAN("\uf699"),
    DOWNLOAD("\uf1DA"),
    DOWNLOAD_NETWORK("\uf6F3"),
    DRAG("\uf1DB"),
    DRAG_HORIZONTAL("\uf1DC"),
    DRAG_VERTICAL("\uf1DD"),
    DRAWING("\uf1DE"),
    DRAWING_BOX("\uf1DF"),
    DRIBBBLE("\uf1E0"),
    DRIBBBLE_BOX("\uf1E1"),
    DRONE("\uf1E2"),
    DROPBOX("\uf1E3"),
    DRUPAL("\uf1E4"),
    DUCK("\uf1E5"),
    DUMBBELL("\uf1E6"),
    EAR_HEARING("\uf7C4"),
    EARTH("\uf1E7"),
    EARTH_BOX("\uf6CC"),
    EARTH_BOX_OFF("\uf6CD"),
    EARTH_OFF("\uf1E8"),
    EDGE("\uf1E9"),
    EJECT("\uf1EA"),
    ELEPHANT("\uf7C5"),
    ELEVATION_DECLINE("\uf1EB"),
    ELEVATION_RISE("\uf1EC"),
    ELEVATOR("\uf1ED"),
    EMAIL("\uf1EE"),
    EMAIL_ALERT("\uf6CE"),
    EMAIL_OPEN("\uf1EF"),
    EMAIL_OPEN_OUTLINE("\uf5EF"),
    EMAIL_OUTLINE("\uf1F0"),
    EMAIL_SECURE("\uf1F1"),
    EMAIL_VARIANT("\uf5F0"),
    EMBY("\uf6B3"),
    EMOTICON("\uf1F2"),
    EMOTICON_COOL("\uf1F3"),
    EMOTICON_DEAD("\uf69A"),
    EMOTICON_DEVIL("\uf1F4"),
    EMOTICON_EXCITED("\uf69B"),
    EMOTICON_HAPPY("\uf1F5"),
    EMOTICON_NEUTRAL("\uf1F6"),
    EMOTICON_POOP("\uf1F7"),
    EMOTICON_SAD("\uf1F8"),
    EMOTICON_TONGUE("\uf1F9"),
    ENGINE("\uf1FA"),
    ENGINE_OUTLINE("\uf1FB"),
    EQUAL("\uf1FC"),
    EQUAL_BOX("\uf1FD"),
    ERASER("\uf1FE"),
    ERASER_VARIANT("\uf642"),
    ESCALATOR("\uf1FF"),
    ETHERNET("\uf200"),
    ETHERNET_CABLE("\uf201"),
    ETHERNET_CABLE_OFF("\uf202"),
    ETSY("\uf203"),
    EV_STATION("\uf5F1"),
    EVENTBRITE("\uf7C6"),
    EVERNOTE("\uf204"),
    EXCLAMATION("\uf205"),
    EXIT_TO_APP("\uf206"),
    EXPORT("\uf207"),
    EYE("\uf208"),
    EYE_OFF("\uf209"),
    EYE_OFF_OUTLINE("\uf6D0"),
    EYE_OUTLINE("\uf6CF"),
    EYEDROPPER("\uf20A"),
    EYEDROPPER_VARIANT("\uf20B"),
    FACE("\uf643"),
    FACE_PROFILE("\uf644"),
    FACEBOOK("\uf20C"),
    FACEBOOK_BOX("\uf20D"),
    FACEBOOK_MESSENGER("\uf20E"),
    FACTORY("\uf20F"),
    FAN("\uf210"),
    FAST_FORWARD("\uf211"),
    FAST_FORWARD_OUTLINE("\uf6D1"),
    FAX("\uf212"),
    FEATHER("\uf6D2"),
    FERRY("\uf213"),
    FILE("\uf214"),
    FILE_ACCOUNT("\uf73A"),
    FILE_CHART("\uf215"),
    FILE_CHECK("\uf216"),
    FILE_CLOUD("\uf217"),
    FILE_DELIMITED("\uf218"),
    FILE_DOCUMENT("\uf219"),
    FILE_DOCUMENT_BOX("\uf21A"),
    FILE_EXCEL("\uf21B"),
    FILE_EXCEL_BOX("\uf21C"),
    FILE_EXPORT("\uf21D"),
    FILE_FIND("\uf21E"),
    FILE_HIDDEN("\uf613"),
    FILE_IMAGE("\uf21F"),
    FILE_IMPORT("\uf220"),
    FILE_LOCK("\uf221"),
    FILE_MULTIPLE("\uf222"),
    FILE_MUSIC("\uf223"),
    FILE_OUTLINE("\uf224"),
    FILE_PDF("\uf225"),
    FILE_PDF_BOX("\uf226"),
    FILE_PLUS("\uf751"),
    FILE_POWERPOINT("\uf227"),
    FILE_POWERPOINT_BOX("\uf228"),
    FILE_PRESENTATION_BOX("\uf229"),
    FILE_RESTORE("\uf670"),
    FILE_SEND("\uf22A"),
    FILE_TREE("\uf645"),
    FILE_VIDEO("\uf22B"),
    FILE_WORD("\uf22C"),
    FILE_WORD_BOX("\uf22D"),
    FILE_XML("\uf22E"),
    FILM("\uf22F"),
    FILMSTRIP("\uf230"),
    FILMSTRIP_OFF("\uf231"),
    FILTER("\uf232"),
    FILTER_OUTLINE("\uf233"),
    FILTER_REMOVE("\uf234"),
    FILTER_REMOVE_OUTLINE("\uf235"),
    FILTER_VARIANT("\uf236"),
    FIND_REPLACE("\uf6D3"),
    FINGERPRINT("\uf237"),
    FIRE("\uf238"),
    FIREFOX("\uf239"),
    FISH("\uf23A"),
    FLAG("\uf23B"),
    FLAG_CHECKERED("\uf23C"),
    FLAG_OUTLINE("\uf23D"),
    FLAG_OUTLINE_VARIANT("\uf23E"),
    FLAG_TRIANGLE("\uf23F"),
    FLAG_VARIANT("\uf240"),
    FLASH("\uf241"),
    FLASH_AUTO("\uf242"),
    FLASH_OFF("\uf243"),
    FLASH_OUTLINE("\uf6D4"),
    FLASH_RED_EYE("\uf67A"),
    FLASHLIGHT("\uf244"),
    FLASHLIGHT_OFF("\uf245"),
    FLASK("\uf093"),
    FLASK_EMPTY("\uf094"),
    FLASK_EMPTY_OUTLINE("\uf095"),
    FLASK_OUTLINE("\uf096"),
    FLATTR("\uf246"),
    FLIP_TO_BACK("\uf247"),
    FLIP_TO_FRONT("\uf248"),
    FLOPPY("\uf249"),
    FLOWER("\uf24A"),
    FOLDER("\uf24B"),
    FOLDER_ACCOUNT("\uf24C"),
    FOLDER_DOWNLOAD("\uf24D"),
    FOLDER_GOOGLE_DRIVE("\uf24E"),
    FOLDER_IMAGE("\uf24F"),
    FOLDER_LOCK("\uf250"),
    FOLDER_LOCK_OPEN("\uf251"),
    FOLDER_MOVE("\uf252"),
    FOLDER_MULTIPLE("\uf253"),
    FOLDER_MULTIPLE_IMAGE("\uf254"),
    FOLDER_MULTIPLE_OUTLINE("\uf255"),
    FOLDER_OPEN("\uf76F"),
    FOLDER_OUTLINE("\uf256"),
    FOLDER_PLUS("\uf257"),
    FOLDER_REMOVE("\uf258"),
    FOLDER_STAR("\uf69C"),
    FOLDER_UPLOAD("\uf259"),
    FONT_AWESOME("\uf03A"),
    FOOD("\uf25A"),
    FOOD_APPLE("\uf25B"),
    FOOD_CROISSANT("\uf7C7"),
    FOOD_FORK_DRINK("\uf5F2"),
    FOOD_OFF("\uf5F3"),
    FOOD_VARIANT("\uf25C"),
    FOOTBALL("\uf25D"),
    FOOTBALL_AUSTRALIAN("\uf25E"),
    FOOTBALL_HELMET("\uf25F"),
    FORKLIFT("\uf7C8"),
    FORMAT_ALIGN_BOTTOM("\uf752"),
    FORMAT_ALIGN_CENTER("\uf260"),
    FORMAT_ALIGN_JUSTIFY("\uf261"),
    FORMAT_ALIGN_LEFT("\uf262"),
    FORMAT_ALIGN_MIDDLE("\uf753"),
    FORMAT_ALIGN_RIGHT("\uf263"),
    FORMAT_ALIGN_TOP("\uf754"),
    FORMAT_ANNOTATION_PLUS("\uf646"),
    FORMAT_BOLD("\uf264"),
    FORMAT_CLEAR("\uf265"),
    FORMAT_COLOR_FILL("\uf266"),
    FORMAT_COLOR_TEXT("\uf69D"),
    FORMAT_FLOAT_CENTER("\uf267"),
    FORMAT_FLOAT_LEFT("\uf268"),
    FORMAT_FLOAT_NONE("\uf269"),
    FORMAT_FLOAT_RIGHT("\uf26A"),
    FORMAT_FONT("\uf6D5"),
    FORMAT_HEADER_1("\uf26B"),
    FORMAT_HEADER_2("\uf26C"),
    FORMAT_HEADER_3("\uf26D"),
    FORMAT_HEADER_4("\uf26E"),
    FORMAT_HEADER_5("\uf26F"),
    FORMAT_HEADER_6("\uf270"),
    FORMAT_HEADER_DECREASE("\uf271"),
    FORMAT_HEADER_EQUAL("\uf272"),
    FORMAT_HEADER_INCREASE("\uf273"),
    FORMAT_HEADER_POUND("\uf274"),
    FORMAT_HORIZONTAL_ALIGN_CENTER("\uf61E"),
    FORMAT_HORIZONTAL_ALIGN_LEFT("\uf61F"),
    FORMAT_HORIZONTAL_ALIGN_RIGHT("\uf620"),
    FORMAT_INDENT_DECREASE("\uf275"),
    FORMAT_INDENT_INCREASE("\uf276"),
    FORMAT_ITALIC("\uf277"),
    FORMAT_LINE_SPACING("\uf278"),
    FORMAT_LINE_STYLE("\uf5C8"),
    FORMAT_LINE_WEIGHT("\uf5C9"),
    FORMAT_LIST_BULLETED("\uf279"),
    FORMAT_LIST_BULLETED_TYPE("\uf27A"),
    FORMAT_LIST_CHECKS("\uf755"),
    FORMAT_LIST_NUMBERS("\uf27B"),
    FORMAT_PAGE_BREAK("\uf6D6"),
    FORMAT_PAINT("\uf27C"),
    FORMAT_PARAGRAPH("\uf27D"),
    FORMAT_PILCROW("\uf6D7"),
    FORMAT_QUOTE_CLOSE("\uf27E"),
    FORMAT_QUOTE_OPEN("\uf756"),
    FORMAT_ROTATE_90("\uf6A9"),
    FORMAT_SECTION("\uf69E"),
    FORMAT_SIZE("\uf27F"),
    FORMAT_STRIKETHROUGH("\uf280"),
    FORMAT_STRIKETHROUGH_VARIANT("\uf281"),
    FORMAT_SUBSCRIPT("\uf282"),
    FORMAT_SUPERSCRIPT("\uf283"),
    FORMAT_TEXT("\uf284"),
    FORMAT_TEXTDIRECTION_L_TO_R("\uf285"),
    FORMAT_TEXTDIRECTION_R_TO_L("\uf286"),
    FORMAT_TITLE("\uf5F4"),
    FORMAT_UNDERLINE("\uf287"),
    FORMAT_VERTICAL_ALIGN_BOTTOM("\uf621"),
    FORMAT_VERTICAL_ALIGN_CENTER("\uf622"),
    FORMAT_VERTICAL_ALIGN_TOP("\uf623"),
    FORMAT_WRAP_INLINE("\uf288"),
    FORMAT_WRAP_SQUARE("\uf289"),
    FORMAT_WRAP_TIGHT("\uf28A"),
    FORMAT_WRAP_TOP_BOTTOM("\uf28B"),
    FORUM("\uf28C"),
    FORWARD("\uf28D"),
    FOURSQUARE("\uf28E"),
    FRIDGE("\uf28F"),
    FRIDGE_FILLED("\uf290"),
    FRIDGE_FILLED_BOTTOM("\uf291"),
    FRIDGE_FILLED_TOP("\uf292"),
    FUEL("\uf7C9"),
    FULLSCREEN("\uf293"),
    FULLSCREEN_EXIT("\uf294"),
    FUNCTION("\uf295"),
    GAMEPAD("\uf296"),
    GAMEPAD_VARIANT("\uf297"),
    GARAGE("\uf6D8"),
    GARAGE_OPEN("\uf6D9"),
    GAS_CYLINDER("\uf647"),
    GAS_STATION("\uf298"),
    GATE("\uf299"),
    GAUGE("\uf29A"),
    GAVEL("\uf29B"),
    GENDER_FEMALE("\uf29C"),
    GENDER_MALE("\uf29D"),
    GENDER_MALE_FEMALE("\uf29E"),
    GENDER_TRANSGENDER("\uf29F"),
    GESTURE("\uf7CA"),
    GESTURE_DOUBLE_TAP("\uf73B"),
    GESTURE_SWIPE_DOWN("\uf73C"),
    GESTURE_SWIPE_LEFT("\uf73D"),
    GESTURE_SWIPE_RIGHT("\uf73E"),
    GESTURE_SWIPE_UP("\uf73F"),
    GESTURE_TAP("\uf740"),
    GESTURE_TWO_DOUBLE_TAP("\uf741"),
    GESTURE_TWO_TAP("\uf742"),
    GHOST("\uf2A0"),
    GIFT("\uf2A1"),
    GIT("\uf2A2"),
    GITHUB_BOX("\uf2A3"),
    GITHUB_CIRCLE("\uf2A4"),
    GITHUB_FACE("\uf6DA"),
    GLASS_FLUTE("\uf2A5"),
    GLASS_MUG("\uf2A6"),
    GLASS_STANGE("\uf2A7"),
    GLASS_TULIP("\uf2A8"),
    GLASSDOOR("\uf2A9"),
    GLASSES("\uf2AA"),
    GMAIL("\uf2AB"),
    GNOME("\uf2AC"),
    GONDOLA("\uf685"),
    GOOGLE("\uf2AD"),
    GOOGLE_ANALYTICS("\uf7CB"),
    GOOGLE_ASSISTANT("\uf7CC"),
    GOOGLE_CARDBOARD("\uf2AE"),
    GOOGLE_CHROME("\uf2AF"),
    GOOGLE_CIRCLES("\uf2B0"),
    GOOGLE_CIRCLES_COMMUNITIES("\uf2B1"),
    GOOGLE_CIRCLES_EXTENDED("\uf2B2"),
    GOOGLE_CIRCLES_GROUP("\uf2B3"),
    GOOGLE_CONTROLLER("\uf2B4"),
    GOOGLE_CONTROLLER_OFF("\uf2B5"),
    GOOGLE_DRIVE("\uf2B6"),
    GOOGLE_EARTH("\uf2B7"),
    GOOGLE_GLASS("\uf2B8"),
    GOOGLE_KEEP("\uf6DB"),
    GOOGLE_MAPS("\uf5F5"),
    GOOGLE_NEARBY("\uf2B9"),
    GOOGLE_PAGES("\uf2BA"),
    GOOGLE_PHOTOS("\uf6DC"),
    GOOGLE_PHYSICAL_WEB("\uf2BB"),
    GOOGLE_PLAY("\uf2BC"),
    GOOGLE_PLUS("\uf2BD"),
    GOOGLE_PLUS_BOX("\uf2BE"),
    GOOGLE_TRANSLATE("\uf2BF"),
    GOOGLE_WALLET("\uf2C0"),
    GRADIENT("\uf69F"),
    GREASE_PENCIL("\uf648"),
    GRID("\uf2C1"),
    GRID_LARGE("\uf757"),
    GRID_OFF("\uf2C2"),
    GROUP("\uf2C3"),
    GUITAR_ACOUSTIC("\uf770"),
    GUITAR_ELECTRIC("\uf2C4"),
    GUITAR_PICK("\uf2C5"),
    GUITAR_PICK_OUTLINE("\uf2C6"),
    HACKERNEWS("\uf624"),
    HAMBURGER("\uf684"),
    HAND_POINTING_RIGHT("\uf2C7"),
    HANGER("\uf2C8"),
    HANGOUTS("\uf2C9"),
    HARDDISK("\uf2CA"),
    HEADPHONES("\uf2CB"),
    HEADPHONES_BOX("\uf2CC"),
    HEADPHONES_OFF("\uf7CD"),
    HEADPHONES_SETTINGS("\uf2CD"),
    HEADSET("\uf2CE"),
    HEADSET_DOCK("\uf2CF"),
    HEADSET_OFF("\uf2D0"),
    HEART("\uf2D1"),
    HEART_BOX("\uf2D2"),
    HEART_BOX_OUTLINE("\uf2D3"),
    HEART_BROKEN("\uf2D4"),
    HEART_HALF("\uf6DE"),
    HEART_HALF_FULL("\uf6DD"),
    HEART_HALF_OUTLINE("\uf6DF"),
    HEART_OFF("\uf758"),
    HEART_OUTLINE("\uf2D5"),
    HEART_PULSE("\uf5F6"),
    HELP("\uf2D6"),
    HELP_BOX("\uf78A"),
    HELP_CIRCLE("\uf2D7"),
    HELP_CIRCLE_OUTLINE("\uf625"),
    HELP_NETWORK("\uf6F4"),
    HEXAGON("\uf2D8"),
    HEXAGON_MULTIPLE("\uf6E0"),
    HEXAGON_OUTLINE("\uf2D9"),
    HIGH_DEFINITION("\uf7CE"),
    HIGHWAY("\uf5F7"),
    HISTORY("\uf2DA"),
    HOLOLENS("\uf2DB"),
    HOME("\uf2DC"),
    HOME_ASSISTANT("\uf7CF"),
    HOME_AUTOMATION("\uf7D0"),
    HOME_CIRCLE("\uf7D1"),
    HOME_MAP_MARKER("\uf5F8"),
    HOME_MODERN("\uf2DD"),
    HOME_OUTLINE("\uf6A0"),
    HOME_VARIANT("\uf2DE"),
    HOOK("\uf6E1"),
    HOOK_OFF("\uf6E2"),
    HOPS("\uf2DF"),
    HOSPITAL("\uf2E0"),
    HOSPITAL_BUILDING("\uf2E1"),
    HOSPITAL_MARKER("\uf2E2"),
    HOTEL("\uf2E3"),
    HOUZZ("\uf2E4"),
    HOUZZ_BOX("\uf2E5"),
    HUMAN("\uf2E6"),
    HUMAN_CHILD("\uf2E7"),
    HUMAN_FEMALE("\uf649"),
    HUMAN_GREETING("\uf64A"),
    HUMAN_HANDSDOWN("\uf64B"),
    HUMAN_HANDSUP("\uf64C"),
    HUMAN_MALE("\uf64D"),
    HUMAN_MALE_FEMALE("\uf2E8"),
    HUMAN_PREGNANT("\uf5CF"),
    HUMBLE_BUNDLE("\uf743"),
    IMAGE("\uf2E9"),
    IMAGE_ALBUM("\uf2EA"),
    IMAGE_AREA("\uf2EB"),
    IMAGE_AREA_CLOSE("\uf2EC"),
    IMAGE_BROKEN("\uf2ED"),
    IMAGE_BROKEN_VARIANT("\uf2EE"),
    IMAGE_FILTER("\uf2EF"),
    IMAGE_FILTER_BLACK_WHITE("\uf2F0"),
    IMAGE_FILTER_CENTER_FOCUS("\uf2F1"),
    IMAGE_FILTER_CENTER_FOCUS_WEAK("\uf2F2"),
    IMAGE_FILTER_DRAMA("\uf2F3"),
    IMAGE_FILTER_FRAMES("\uf2F4"),
    IMAGE_FILTER_HDR("\uf2F5"),
    IMAGE_FILTER_NONE("\uf2F6"),
    IMAGE_FILTER_TILT_SHIFT("\uf2F7"),
    IMAGE_FILTER_VINTAGE("\uf2F8"),
    IMAGE_MULTIPLE("\uf2F9"),
    IMPORT("\uf2FA"),
    INBOX("\uf686"),
    INBOX_ARROW_DOWN("\uf2FB"),
    INBOX_ARROW_UP("\uf3D1"),
    INCOGNITO("\uf5F9"),
    INFINITY("\uf6E3"),
    INFORMATION("\uf2FC"),
    INFORMATION_OUTLINE("\uf2FD"),
    INFORMATION_VARIANT("\uf64E"),
    INSTAGRAM("\uf2FE"),
    INSTAPAPER("\uf2FF"),
    INTERNET_EXPLORER("\uf300"),
    INVERT_COLORS("\uf301"),
    ITUNES("\uf676"),
    JEEPNEY("\uf302"),
    JIRA("\uf303"),
    JSFIDDLE("\uf304"),
    JSON("\uf626"),
    KEG("\uf305"),
    KETTLE("\uf5FA"),
    KEY("\uf306"),
    KEY_CHANGE("\uf307"),
    KEY_MINUS("\uf308"),
    KEY_PLUS("\uf309"),
    KEY_REMOVE("\uf30A"),
    KEY_VARIANT("\uf30B"),
    KEYBOARD("\uf30C"),
    KEYBOARD_BACKSPACE("\uf30D"),
    KEYBOARD_CAPS("\uf30E"),
    KEYBOARD_CLOSE("\uf30F"),
    KEYBOARD_OFF("\uf310"),
    KEYBOARD_RETURN("\uf311"),
    KEYBOARD_TAB("\uf312"),
    KEYBOARD_VARIANT("\uf313"),
    KICKSTARTER("\uf744"),
    KODI("\uf314"),
    LABEL("\uf315"),
    LABEL_OUTLINE("\uf316"),
    LAMBDA("\uf627"),
    LAMP("\uf6B4"),
    LAN("\uf317"),
    LAN_CONNECT("\uf318"),
    LAN_DISCONNECT("\uf319"),
    LAN_PENDING("\uf31A"),
    LANGUAGE_C("\uf671"),
    LANGUAGE_CPP("\uf672"),
    LANGUAGE_CSHARP("\uf31B"),
    LANGUAGE_CSS3("\uf31C"),
    LANGUAGE_GO("\uf7D2"),
    LANGUAGE_HTML5("\uf31D"),
    LANGUAGE_JAVASCRIPT("\uf31E"),
    LANGUAGE_PHP("\uf31F"),
    LANGUAGE_PYTHON("\uf320"),
    LANGUAGE_PYTHON_TEXT("\uf321"),
    LANGUAGE_R("\uf7D3"),
    LANGUAGE_SWIFT("\uf6E4"),
    LANGUAGE_TYPESCRIPT("\uf6E5"),
    LAPTOP("\uf322"),
    LAPTOP_CHROMEBOOK("\uf323"),
    LAPTOP_MAC("\uf324"),
    LAPTOP_OFF("\uf6E6"),
    LAPTOP_WINDOWS("\uf325"),
    LASTFM("\uf326"),
    LAUNCH("\uf327"),
    LAVA_LAMP("\uf7D4"),
    LAYERS("\uf328"),
    LAYERS_OFF("\uf329"),
    LEAD_PENCIL("\uf64F"),
    LEAF("\uf32A"),
    LED_OFF("\uf32B"),
    LED_ON("\uf32C"),
    LED_OUTLINE("\uf32D"),
    LED_STRIP("\uf7D5"),
    LED_VARIANT_OFF("\uf32E"),
    LED_VARIANT_ON("\uf32F"),
    LED_VARIANT_OUTLINE("\uf330"),
    LIBRARY("\uf331"),
    LIBRARY_BOOKS("\uf332"),
    LIBRARY_MUSIC("\uf333"),
    LIBRARY_PLUS("\uf334"),
    LIGHTBULB("\uf335"),
    LIGHTBULB_ON("\uf6E7"),
    LIGHTBULB_ON_OUTLINE("\uf6E8"),
    LIGHTBULB_OUTLINE("\uf336"),
    LINK("\uf337"),
    LINK_OFF("\uf338"),
    LINK_VARIANT("\uf339"),
    LINK_VARIANT_OFF("\uf33A"),
    LINKEDIN("\uf33B"),
    LINKEDIN_BOX("\uf33C"),
    LINUX("\uf33D"),
    LOADING("\uf771"),
    LOCK("\uf33E"),
    LOCK_OPEN("\uf33F"),
    LOCK_OPEN_OUTLINE("\uf340"),
    LOCK_OUTLINE("\uf341"),
    LOCK_PATTERN("\uf6E9"),
    LOCK_PLUS("\uf5FB"),
    LOCK_RESET("\uf772"),
    LOCKER("\uf7D6"),
    LOCKER_MULTIPLE("\uf7D7"),
    LOGIN("\uf342"),
    LOGIN_VARIANT("\uf5FC"),
    LOGOUT("\uf343"),
    LOGOUT_VARIANT("\uf5FD"),
    LOOKS("\uf344"),
    LOOP("\uf6EA"),
    LOUPE("\uf345"),
    LUMX("\uf346"),
    MAGNET("\uf347"),
    MAGNET_ON("\uf348"),
    MAGNIFY("\uf349"),
    MAGNIFY_MINUS("\uf34A"),
    MAGNIFY_MINUS_OUTLINE("\uf6EB"),
    MAGNIFY_PLUS("\uf34B"),
    MAGNIFY_PLUS_OUTLINE("\uf6EC"),
    MAIL_RU("\uf34C"),
    MAILBOX("\uf6ED"),
    MAP("\uf34D"),
    MAP_MARKER("\uf34E"),
    MAP_MARKER_CIRCLE("\uf34F"),
    MAP_MARKER_MINUS("\uf650"),
    MAP_MARKER_MULTIPLE("\uf350"),
    MAP_MARKER_OFF("\uf351"),
    MAP_MARKER_OUTLINE("\uf7D8"),
    MAP_MARKER_PLUS("\uf651"),
    MAP_MARKER_RADIUS("\uf352"),
    MARGIN("\uf353"),
    MARKDOWN("\uf354"),
    MARKER("\uf652"),
    MARKER_CHECK("\uf355"),
    MARTINI("\uf356"),
    MATERIAL_UI("\uf357"),
    MATH_COMPASS("\uf358"),
    MATRIX("\uf628"),
    MAXCDN("\uf359"),
    MEDICAL_BAG("\uf6EE"),
    MEDIUM("\uf35A"),
    MEMORY("\uf35B"),
    MENU("\uf35C"),
    MENU_DOWN("\uf35D"),
    MENU_DOWN_OUTLINE("\uf6B5"),
    MENU_LEFT("\uf35E"),
    MENU_RIGHT("\uf35F"),
    MENU_UP("\uf360"),
    MENU_UP_OUTLINE("\uf6B6"),
    MESSAGE("\uf361"),
    MESSAGE_ALERT("\uf362"),
    MESSAGE_BULLETED("\uf6A1"),
    MESSAGE_BULLETED_OFF("\uf6A2"),
    MESSAGE_DRAW("\uf363"),
    MESSAGE_IMAGE("\uf364"),
    MESSAGE_OUTLINE("\uf365"),
    MESSAGE_PLUS("\uf653"),
    MESSAGE_PROCESSING("\uf366"),
    MESSAGE_REPLY("\uf367"),
    MESSAGE_REPLY_TEXT("\uf368"),
    MESSAGE_SETTINGS("\uf6EF"),
    MESSAGE_SETTINGS_VARIANT("\uf6F0"),
    MESSAGE_TEXT("\uf369"),
    MESSAGE_TEXT_OUTLINE("\uf36A"),
    MESSAGE_VIDEO("\uf36B"),
    METEOR("\uf629"),
    METRONOME("\uf7D9"),
    METRONOME_TICK("\uf7DA"),
    MICRO_SD("\uf7DB"),
    MICROPHONE("\uf36C"),
    MICROPHONE_OFF("\uf36D"),
    MICROPHONE_OUTLINE("\uf36E"),
    MICROPHONE_SETTINGS("\uf36F"),
    MICROPHONE_VARIANT("\uf370"),
    MICROPHONE_VARIANT_OFF("\uf371"),
    MICROSCOPE("\uf654"),
    MICROSOFT("\uf372"),
    MINECRAFT("\uf373"),
    MINUS("\uf374"),
    MINUS_BOX("\uf375"),
    MINUS_BOX_OUTLINE("\uf6F1"),
    MINUS_CIRCLE("\uf376"),
    MINUS_CIRCLE_OUTLINE("\uf377"),
    MINUS_NETWORK("\uf378"),
    MIXCLOUD("\uf62A"),
    MIXER("\uf7DC"),
    MONITOR("\uf379"),
    MONITOR_MULTIPLE("\uf37A"),
    MORE("\uf37B"),
    MOTORBIKE("\uf37C"),
    MOUSE("\uf37D"),
    MOUSE_OFF("\uf37E"),
    MOUSE_VARIANT("\uf37F"),
    MOUSE_VARIANT_OFF("\uf380"),
    MOVE_RESIZE("\uf655"),
    MOVE_RESIZE_VARIANT("\uf656"),
    MOVIE("\uf381"),
    MOVIE_ROLL("\uf7DD"),
    MULTIPLICATION("\uf382"),
    MULTIPLICATION_BOX("\uf383"),
    MUSHROOM("\uf7DE"),
    MUSHROOM_OUTLINE("\uf7DF"),
    MUSIC("\uf759"),
    MUSIC_BOX("\uf384"),
    MUSIC_BOX_OUTLINE("\uf385"),
    MUSIC_CIRCLE("\uf386"),
    MUSIC_NOTE("\uf387"),
    MUSIC_NOTE_BLUETOOTH("\uf5FE"),
    MUSIC_NOTE_BLUETOOTH_OFF("\uf5FF"),
    MUSIC_NOTE_EIGHTH("\uf388"),
    MUSIC_NOTE_HALF("\uf389"),
    MUSIC_NOTE_OFF("\uf38A"),
    MUSIC_NOTE_QUARTER("\uf38B"),
    MUSIC_NOTE_SIXTEENTH("\uf38C"),
    MUSIC_NOTE_WHOLE("\uf38D"),
    MUSIC_OFF("\uf75A"),
    NATURE("\uf38E"),
    NATURE_PEOPLE("\uf38F"),
    NAVIGATION("\uf390"),
    NEAR_ME("\uf5CD"),
    NEEDLE("\uf391"),
    NEST_PROTECT("\uf392"),
    NEST_THERMOSTAT("\uf393"),
    NETFLIX("\uf745"),
    NETWORK("\uf6F2"),
    NEW_BOX("\uf394"),
    NEWSPAPER("\uf395"),
    NFC("\uf396"),
    NFC_TAP("\uf397"),
    NFC_VARIANT("\uf398"),
    NINJA("\uf773"),
    NINTENDO_SWITCH("\uf7E0"),
    NODEJS("\uf399"),
    NOTE("\uf39A"),
    NOTE_MULTIPLE("\uf6B7"),
    NOTE_MULTIPLE_OUTLINE("\uf6B8"),
    NOTE_OUTLINE("\uf39B"),
    NOTE_PLUS("\uf39C"),
    NOTE_PLUS_OUTLINE("\uf39D"),
    NOTE_TEXT("\uf39E"),
    NOTIFICATION_CLEAR_ALL("\uf39F"),
    NPM("\uf6F6"),
    NUKE("\uf6A3"),
    NULL("\uf7E1"),
    NUMERIC("\uf3A0"),
    NUMERIC_0_BOX("\uf3A1"),
    NUMERIC_0_BOX_MULTIPLE_OUTLINE("\uf3A2"),
    NUMERIC_0_BOX_OUTLINE("\uf3A3"),
    NUMERIC_1_BOX("\uf3A4"),
    NUMERIC_1_BOX_MULTIPLE_OUTLINE("\uf3A5"),
    NUMERIC_1_BOX_OUTLINE("\uf3A6"),
    NUMERIC_2_BOX("\uf3A7"),
    NUMERIC_2_BOX_MULTIPLE_OUTLINE("\uf3A8"),
    NUMERIC_2_BOX_OUTLINE("\uf3A9"),
    NUMERIC_3_BOX("\uf3AA"),
    NUMERIC_3_BOX_MULTIPLE_OUTLINE("\uf3AB"),
    NUMERIC_3_BOX_OUTLINE("\uf3AC"),
    NUMERIC_4_BOX("\uf3AD"),
    NUMERIC_4_BOX_MULTIPLE_OUTLINE("\uf3AE"),
    NUMERIC_4_BOX_OUTLINE("\uf3AF"),
    NUMERIC_5_BOX("\uf3B0"),
    NUMERIC_5_BOX_MULTIPLE_OUTLINE("\uf3B1"),
    NUMERIC_5_BOX_OUTLINE("\uf3B2"),
    NUMERIC_6_BOX("\uf3B3"),
    NUMERIC_6_BOX_MULTIPLE_OUTLINE("\uf3B4"),
    NUMERIC_6_BOX_OUTLINE("\uf3B5"),
    NUMERIC_7_BOX("\uf3B6"),
    NUMERIC_7_BOX_MULTIPLE_OUTLINE("\uf3B7"),
    NUMERIC_7_BOX_OUTLINE("\uf3B8"),
    NUMERIC_8_BOX("\uf3B9"),
    NUMERIC_8_BOX_MULTIPLE_OUTLINE("\uf3BA"),
    NUMERIC_8_BOX_OUTLINE("\uf3BB"),
    NUMERIC_9_BOX("\uf3BC"),
    NUMERIC_9_BOX_MULTIPLE_OUTLINE("\uf3BD"),
    NUMERIC_9_BOX_OUTLINE("\uf3BE"),
    NUMERIC_9_PLUS_BOX("\uf3BF"),
    NUMERIC_9_PLUS_BOX_MULTIPLE_OUTLINE("\uf3C0"),
    NUMERIC_9_PLUS_BOX_OUTLINE("\uf3C1"),
    NUT("\uf6F7"),
    NUTRITION("\uf3C2"),
    OAR("\uf67B"),
    OCTAGON("\uf3C3"),
    OCTAGON_OUTLINE("\uf3C4"),
    OCTAGRAM("\uf6F8"),
    OCTAGRAM_OUTLINE("\uf774"),
    ODNOKLASSNIKI("\uf3C5"),
    OFFICE("\uf3C6"),
    OIL("\uf3C7"),
    OIL_TEMPERATURE("\uf3C8"),
    OMEGA("\uf3C9"),
    ONEDRIVE("\uf3CA"),
    ONENOTE("\uf746"),
    OPACITY("\uf5CC"),
    OPEN_IN_APP("\uf3CB"),
    OPEN_IN_NEW("\uf3CC"),
    OPENID("\uf3CD"),
    OPERA("\uf3CE"),
    ORBIT("\uf018"),
    ORNAMENT("\uf3CF"),
    ORNAMENT_VARIANT("\uf3D0"),
    OWL("\uf3D2"),
    PACKAGE("\uf3D3"),
    PACKAGE_DOWN("\uf3D4"),
    PACKAGE_UP("\uf3D5"),
    PACKAGE_VARIANT("\uf3D6"),
    PACKAGE_VARIANT_CLOSED("\uf3D7"),
    PAGE_FIRST("\uf600"),
    PAGE_LAST("\uf601"),
    PAGE_LAYOUT_BODY("\uf6F9"),
    PAGE_LAYOUT_FOOTER("\uf6FA"),
    PAGE_LAYOUT_HEADER("\uf6FB"),
    PAGE_LAYOUT_SIDEBAR_LEFT("\uf6FC"),
    PAGE_LAYOUT_SIDEBAR_RIGHT("\uf6FD"),
    PALETTE("\uf3D8"),
    PALETTE_ADVANCED("\uf3D9"),
    PANDA("\uf3DA"),
    PANDORA("\uf3DB"),
    PANORAMA("\uf3DC"),
    PANORAMA_FISHEYE("\uf3DD"),
    PANORAMA_HORIZONTAL("\uf3DE"),
    PANORAMA_VERTICAL("\uf3DF"),
    PANORAMA_WIDE_ANGLE("\uf3E0"),
    PAPER_CUT_VERTICAL("\uf3E1"),
    PAPERCLIP("\uf3E2"),
    PARKING("\uf3E3"),
    PASSPORT("\uf7E2"),
    PAUSE("\uf3E4"),
    PAUSE_CIRCLE("\uf3E5"),
    PAUSE_CIRCLE_OUTLINE("\uf3E6"),
    PAUSE_OCTAGON("\uf3E7"),
    PAUSE_OCTAGON_OUTLINE("\uf3E8"),
    PAW("\uf3E9"),
    PAW_OFF("\uf657"),
    PEN("\uf3EA"),
    PENCIL("\uf3EB"),
    PENCIL_BOX("\uf3EC"),
    PENCIL_BOX_OUTLINE("\uf3ED"),
    PENCIL_CIRCLE("\uf6FE"),
    PENCIL_CIRCLE_OUTLINE("\uf775"),
    PENCIL_LOCK("\uf3EE"),
    PENCIL_OFF("\uf3EF"),
    PENTAGON("\uf6FF"),
    PENTAGON_OUTLINE("\uf700"),
    PERCENT("\uf3F0"),
    PERIODIC_TABLE_CO2("\uf7E3"),
    PERISCOPE("\uf747"),
    PHARMACY("\uf3F1"),
    PHONE("\uf3F2"),
    PHONE_BLUETOOTH("\uf3F3"),
    PHONE_CLASSIC("\uf602"),
    PHONE_FORWARD("\uf3F4"),
    PHONE_HANGUP("\uf3F5"),
    PHONE_IN_TALK("\uf3F6"),
    PHONE_INCOMING("\uf3F7"),
    PHONE_LOCKED("\uf3F8"),
    PHONE_LOG("\uf3F9"),
    PHONE_MINUS("\uf658"),
    PHONE_MISSED("\uf3FA"),
    PHONE_OUTGOING("\uf3FB"),
    PHONE_PAUSED("\uf3FC"),
    PHONE_PLUS("\uf659"),
    PHONE_SETTINGS("\uf3FD"),
    PHONE_VOIP("\uf3FE"),
    PI("\uf3FF"),
    PI_BOX("\uf400"),
    PIANO("\uf67C"),
    PIG("\uf401"),
    PILL("\uf402"),
    PILLAR("\uf701"),
    PIN("\uf403"),
    PIN_OFF("\uf404"),
    PINE_TREE("\uf405"),
    PINE_TREE_BOX("\uf406"),
    PINTEREST("\uf407"),
    PINTEREST_BOX("\uf408"),
    PIPE("\uf7E4"),
    PIPE_DISCONNECTED("\uf7E5"),
    PISTOL("\uf702"),
    PIZZA("\uf409"),
    PLANE_SHIELD("\uf6BA"),
    PLAY("\uf40A"),
    PLAY_BOX_OUTLINE("\uf40B"),
    PLAY_CIRCLE("\uf40C"),
    PLAY_CIRCLE_OUTLINE("\uf40D"),
    PLAY_PAUSE("\uf40E"),
    PLAY_PROTECTED_CONTENT("\uf40F"),
    PLAYLIST_CHECK("\uf5C7"),
    PLAYLIST_MINUS("\uf410"),
    PLAYLIST_PLAY("\uf411"),
    PLAYLIST_PLUS("\uf412"),
    PLAYLIST_REMOVE("\uf413"),
    PLAYSTATION("\uf414"),
    PLEX("\uf6B9"),
    PLUS("\uf415"),
    PLUS_BOX("\uf416"),
    PLUS_BOX_OUTLINE("\uf703"),
    PLUS_CIRCLE("\uf417"),
    PLUS_CIRCLE_MULTIPLE_OUTLINE("\uf418"),
    PLUS_CIRCLE_OUTLINE("\uf419"),
    PLUS_NETWORK("\uf41A"),
    PLUS_ONE("\uf41B"),
    PLUS_OUTLINE("\uf704"),
    POCKET("\uf41C"),
    POKEBALL("\uf41D"),
    POLAROID("\uf41E"),
    POLL("\uf41F"),
    POLL_BOX("\uf420"),
    POLYMER("\uf421"),
    POOL("\uf606"),
    POPCORN("\uf422"),
    POT("\uf65A"),
    POT_MIX("\uf65B"),
    POUND("\uf423"),
    POUND_BOX("\uf424"),
    POWER("\uf425"),
    POWER_PLUG("\uf6A4"),
    POWER_PLUG_OFF("\uf6A5"),
    POWER_SETTINGS("\uf426"),
    POWER_SOCKET("\uf427"),
    POWER_SOCKET_EU("\uf7E6"),
    POWER_SOCKET_UK("\uf7E7"),
    POWER_SOCKET_US("\uf7E8"),
    PRESCRIPTION("\uf705"),
    PRESENTATION("\uf428"),
    PRESENTATION_PLAY("\uf429"),
    PRINTER("\uf42A"),
    PRINTER_3D("\uf42B"),
    PRINTER_ALERT("\uf42C"),
    PRINTER_SETTINGS("\uf706"),
    PRIORITY_HIGH("\uf603"),
    PRIORITY_LOW("\uf604"),
    PROFESSIONAL_HEXAGON("\uf42D"),
    PROJECTOR("\uf42E"),
    PROJECTOR_SCREEN("\uf42F"),
    PUBLISH("\uf6A6"),
    PULSE("\uf430"),
    PUZZLE("\uf431"),
    QQCHAT("\uf605"),
    QRCODE("\uf432"),
    QRCODE_SCAN("\uf433"),
    QUADCOPTER("\uf434"),
    QUALITY_HIGH("\uf435"),
    QUICKTIME("\uf436"),
    RADAR("\uf437"),
    RADIATOR("\uf438"),
    RADIO("\uf439"),
    RADIO_HANDHELD("\uf43A"),
    RADIO_TOWER("\uf43B"),
    RADIOACTIVE("\uf43C"),
    RADIOBOX_BLANK("\uf43D"),
    RADIOBOX_MARKED("\uf43E"),
    RASPBERRYPI("\uf43F"),
    RAY_END("\uf440"),
    RAY_END_ARROW("\uf441"),
    RAY_START("\uf442"),
    RAY_START_ARROW("\uf443"),
    RAY_START_END("\uf444"),
    RAY_VERTEX("\uf445"),
    RDIO("\uf446"),
    REACT("\uf707"),
    READ("\uf447"),
    READABILITY("\uf448"),
    RECEIPT("\uf449"),
    RECORD("\uf44A"),
    RECORD_REC("\uf44B"),
    RECYCLE("\uf44C"),
    REDDIT("\uf44D"),
    REDO("\uf44E"),
    REDO_VARIANT("\uf44F"),
    REFRESH("\uf450"),
    REGEX("\uf451"),
    RELATIVE_SCALE("\uf452"),
    RELOAD("\uf453"),
    REMOTE("\uf454"),
    RENAME_BOX("\uf455"),
    REORDER_HORIZONTAL("\uf687"),
    REORDER_VERTICAL("\uf688"),
    REPEAT("\uf456"),
    REPEAT_OFF("\uf457"),
    REPEAT_ONCE("\uf458"),
    REPLAY("\uf459"),
    REPLY("\uf45A"),
    REPLY_ALL("\uf45B"),
    REPRODUCTION("\uf45C"),
    RESIZE_BOTTOM_RIGHT("\uf45D"),
    RESPONSIVE("\uf45E"),
    RESTART("\uf708"),
    RESTORE("\uf6A7"),
    REWIND("\uf45F"),
    REWIND_OUTLINE("\uf709"),
    RHOMBUS("\uf70A"),
    RHOMBUS_OUTLINE("\uf70B"),
    RIBBON("\uf460"),
    RICE("\uf7E9"),
    RING("\uf7EA"),
    ROAD("\uf461"),
    ROAD_VARIANT("\uf462"),
    ROBOT("\uf6A8"),
    ROCKET("\uf463"),
    ROOMBA("\uf70C"),
    ROTATE_3D("\uf464"),
    ROTATE_LEFT("\uf465"),
    ROTATE_LEFT_VARIANT("\uf466"),
    ROTATE_RIGHT("\uf467"),
    ROTATE_RIGHT_VARIANT("\uf468"),
    ROUNDED_CORNER("\uf607"),
    ROUTER_WIRELESS("\uf469"),
    ROUTES("\uf46A"),
    ROWING("\uf608"),
    RSS("\uf46B"),
    RSS_BOX("\uf46C"),
    RULER("\uf46D"),
    RUN("\uf70D"),
    RUN_FAST("\uf46E"),
    SALE("\uf46F"),
    SASS("\uf7EB"),
    SATELLITE("\uf470"),
    SATELLITE_VARIANT("\uf471"),
    SAXOPHONE("\uf609"),
    SCALE("\uf472"),
    SCALE_BALANCE("\uf5D1"),
    SCALE_BATHROOM("\uf473"),
    SCANNER("\uf6AA"),
    SCHOOL("\uf474"),
    SCREEN_ROTATION("\uf475"),
    SCREEN_ROTATION_LOCK("\uf476"),
    SCREWDRIVER("\uf477"),
    SCRIPT("\uf478"),
    SD("\uf479"),
    SEAL("\uf47A"),
    SEARCH_WEB("\uf70E"),
    SEAT_FLAT("\uf47B"),
    SEAT_FLAT_ANGLED("\uf47C"),
    SEAT_INDIVIDUAL_SUITE("\uf47D"),
    SEAT_LEGROOM_EXTRA("\uf47E"),
    SEAT_LEGROOM_NORMAL("\uf47F"),
    SEAT_LEGROOM_REDUCED("\uf480"),
    SEAT_RECLINE_EXTRA("\uf481"),
    SEAT_RECLINE_NORMAL("\uf482"),
    SECURITY("\uf483"),
    SECURITY_HOME("\uf689"),
    SECURITY_NETWORK("\uf484"),
    SELECT("\uf485"),
    SELECT_ALL("\uf486"),
    SELECT_INVERSE("\uf487"),
    SELECT_OFF("\uf488"),
    SELECTION("\uf489"),
    SELECTION_OFF("\uf776"),
    SEND("\uf48A"),
    SEND_SECURE("\uf7EC"),
    SERIAL_PORT("\uf65C"),
    SERVER("\uf48B"),
    SERVER_MINUS("\uf48C"),
    SERVER_NETWORK("\uf48D"),
    SERVER_NETWORK_OFF("\uf48E"),
    SERVER_OFF("\uf48F"),
    SERVER_PLUS("\uf490"),
    SERVER_REMOVE("\uf491"),
    SERVER_SECURITY("\uf492"),
    SET_ALL("\uf777"),
    SET_CENTER("\uf778"),
    SET_CENTER_RIGHT("\uf779"),
    SET_LEFT("\uf77A"),
    SET_LEFT_CENTER("\uf77B"),
    SET_LEFT_RIGHT("\uf77C"),
    SET_NONE("\uf77D"),
    SET_RIGHT("\uf77E"),
    SETTINGS("\uf493"),
    SETTINGS_BOX("\uf494"),
    SHAPE_CIRCLE_PLUS("\uf65D"),
    SHAPE_PLUS("\uf495"),
    SHAPE_POLYGON_PLUS("\uf65E"),
    SHAPE_RECTANGLE_PLUS("\uf65F"),
    SHAPE_SQUARE_PLUS("\uf660"),
    SHARE("\uf496"),
    SHARE_VARIANT("\uf497"),
    SHIELD("\uf498"),
    SHIELD_HALF_FULL("\uf77F"),
    SHIELD_OUTLINE("\uf499"),
    SHOPPING("\uf49A"),
    SHOPPING_MUSIC("\uf49B"),
    SHOVEL("\uf70F"),
    SHOVEL_OFF("\uf710"),
    SHREDDER("\uf49C"),
    SHUFFLE("\uf49D"),
    SHUFFLE_DISABLED("\uf49E"),
    SHUFFLE_VARIANT("\uf49F"),
    SIGMA("\uf4A0"),
    SIGMA_LOWER("\uf62B"),
    SIGN_CAUTION("\uf4A1"),
    SIGN_DIRECTION("\uf780"),
    SIGN_TEXT("\uf781"),
    SIGNAL("\uf4A2"),
    SIGNAL_2G("\uf711"),
    SIGNAL_3G("\uf712"),
    SIGNAL_4G("\uf713"),
    SIGNAL_HSPA("\uf714"),
    SIGNAL_HSPA_PLUS("\uf715"),
    SIGNAL_OFF("\uf782"),
    SIGNAL_VARIANT("\uf60A"),
    SILVERWARE("\uf4A3"),
    SILVERWARE_FORK("\uf4A4"),
    SILVERWARE_SPOON("\uf4A5"),
    SILVERWARE_VARIANT("\uf4A6"),
    SIM("\uf4A7"),
    SIM_ALERT("\uf4A8"),
    SIM_OFF("\uf4A9"),
    SITEMAP("\uf4AA"),
    SKIP_BACKWARD("\uf4AB"),
    SKIP_FORWARD("\uf4AC"),
    SKIP_NEXT("\uf4AD"),
    SKIP_NEXT_CIRCLE("\uf661"),
    SKIP_NEXT_CIRCLE_OUTLINE("\uf662"),
    SKIP_PREVIOUS("\uf4AE"),
    SKIP_PREVIOUS_CIRCLE("\uf663"),
    SKIP_PREVIOUS_CIRCLE_OUTLINE("\uf664"),
    SKULL("\uf68B"),
    SKYPE("\uf4AF"),
    SKYPE_BUSINESS("\uf4B0"),
    SLACK("\uf4B1"),
    SLEEP("\uf4B2"),
    SLEEP_OFF("\uf4B3"),
    SMOKING("\uf4B4"),
    SMOKING_OFF("\uf4B5"),
    SNAPCHAT("\uf4B6"),
    SNOWFLAKE("\uf716"),
    SNOWMAN("\uf4B7"),
    SOCCER("\uf4B8"),
    SOFA("\uf4B9"),
    SOLID("\uf68C"),
    SORT("\uf4BA"),
    SORT_ALPHABETICAL("\uf4BB"),
    SORT_ASCENDING("\uf4BC"),
    SORT_DESCENDING("\uf4BD"),
    SORT_NUMERIC("\uf4BE"),
    SORT_VARIANT("\uf4BF"),
    SOUNDCLOUD("\uf4C0"),
    SOURCE_BRANCH("\uf62C"),
    SOURCE_COMMIT("\uf717"),
    SOURCE_COMMIT_END("\uf718"),
    SOURCE_COMMIT_END_LOCAL("\uf719"),
    SOURCE_COMMIT_LOCAL("\uf71A"),
    SOURCE_COMMIT_NEXT_LOCAL("\uf71B"),
    SOURCE_COMMIT_START("\uf71C"),
    SOURCE_COMMIT_START_NEXT_LOCAL("\uf71D"),
    SOURCE_FORK("\uf4C1"),
    SOURCE_MERGE("\uf62D"),
    SOURCE_PULL("\uf4C2"),
    SOY_SAUCE("\uf7ED"),
    SPEAKER("\uf4C3"),
    SPEAKER_OFF("\uf4C4"),
    SPEAKER_WIRELESS("\uf71E"),
    SPEEDOMETER("\uf4C5"),
    SPELLCHECK("\uf4C6"),
    SPOTIFY("\uf4C7"),
    SPOTLIGHT("\uf4C8"),
    SPOTLIGHT_BEAM("\uf4C9"),
    SPRAY("\uf665"),
    SQUARE("\uf763"),
    SQUARE_INC("\uf4CA"),
    SQUARE_INC_CASH("\uf4CB"),
    SQUARE_OUTLINE("\uf762"),
    SQUARE_ROOT("\uf783"),
    STACKEXCHANGE("\uf60B"),
    STACKOVERFLOW("\uf4CC"),
    STADIUM("\uf71F"),
    STAIRS("\uf4CD"),
    STANDARD_DEFINITION("\uf7EE"),
    STAR("\uf4CE"),
    STAR_CIRCLE("\uf4CF"),
    STAR_HALF("\uf4D0"),
    STAR_OFF("\uf4D1"),
    STAR_OUTLINE("\uf4D2"),
    STEAM("\uf4D3"),
    STEERING("\uf4D4"),
    STEP_BACKWARD("\uf4D5"),
    STEP_BACKWARD_2("\uf4D6"),
    STEP_FORWARD("\uf4D7"),
    STEP_FORWARD_2("\uf4D8"),
    STETHOSCOPE("\uf4D9"),
    STICKER("\uf5D0"),
    STICKER_EMOJI("\uf784"),
    STOCKING("\uf4DA"),
    STOP("\uf4DB"),
    STOP_CIRCLE("\uf666"),
    STOP_CIRCLE_OUTLINE("\uf667"),
    STORE("\uf4DC"),
    STORE_24_HOUR("\uf4DD"),
    STOVE("\uf4DE"),
    SUBDIRECTORY_ARROW_LEFT("\uf60C"),
    SUBDIRECTORY_ARROW_RIGHT("\uf60D"),
    SUBWAY("\uf6AB"),
    SUBWAY_VARIANT("\uf4DF"),
    SUMMIT("\uf785"),
    SUNGLASSES("\uf4E0"),
    SURROUND_SOUND("\uf5C5"),
    SURROUND_SOUND_2_0("\uf7EF"),
    SURROUND_SOUND_3_1("\uf7F0"),
    SURROUND_SOUND_5_1("\uf7F1"),
    SURROUND_SOUND_7_1("\uf7F2"),
    SVG("\uf720"),
    SWAP_HORIZONTAL("\uf4E1"),
    SWAP_VERTICAL("\uf4E2"),
    SWIM("\uf4E3"),
    SWITCH("\uf4E4"),
    SWORD("\uf4E5"),
    SWORD_CROSS("\uf786"),
    SYNC("\uf4E6"),
    SYNC_ALERT("\uf4E7"),
    SYNC_OFF("\uf4E8"),
    TAB("\uf4E9"),
    TAB_PLUS("\uf75B"),
    TAB_UNSELECTED("\uf4EA"),
    TABLE("\uf4EB"),
    TABLE_COLUMN_PLUS_AFTER("\uf4EC"),
    TABLE_COLUMN_PLUS_BEFORE("\uf4ED"),
    TABLE_COLUMN_REMOVE("\uf4EE"),
    TABLE_COLUMN_WIDTH("\uf4EF"),
    TABLE_EDIT("\uf4F0"),
    TABLE_LARGE("\uf4F1"),
    TABLE_ROW_HEIGHT("\uf4F2"),
    TABLE_ROW_PLUS_AFTER("\uf4F3"),
    TABLE_ROW_PLUS_BEFORE("\uf4F4"),
    TABLE_ROW_REMOVE("\uf4F5"),
    TABLET("\uf4F6"),
    TABLET_ANDROID("\uf4F7"),
    TABLET_IPAD("\uf4F8"),
    TACO("\uf761"),
    TAG("\uf4F9"),
    TAG_FACES("\uf4FA"),
    TAG_HEART("\uf68A"),
    TAG_MULTIPLE("\uf4FB"),
    TAG_OUTLINE("\uf4FC"),
    TAG_PLUS("\uf721"),
    TAG_REMOVE("\uf722"),
    TAG_TEXT_OUTLINE("\uf4FD"),
    TARGET("\uf4FE"),
    TAXI("\uf4FF"),
    TEAMVIEWER("\uf500"),
    TELEGRAM("\uf501"),
    TELEVISION("\uf502"),
    TELEVISION_CLASSIC("\uf7F3"),
    TELEVISION_GUIDE("\uf503"),
    TEMPERATURE_CELSIUS("\uf504"),
    TEMPERATURE_FAHRENHEIT("\uf505"),
    TEMPERATURE_KELVIN("\uf506"),
    TENNIS("\uf507"),
    TENT("\uf508"),
    TERRAIN("\uf509"),
    TEST_TUBE("\uf668"),
    TEXT_SHADOW("\uf669"),
    TEXT_TO_SPEECH("\uf50A"),
    TEXT_TO_SPEECH_OFF("\uf50B"),
    TEXTBOX("\uf60E"),
    TEXTBOX_PASSWORD("\uf7F4"),
    TEXTURE("\uf50C"),
    THEATER("\uf50D"),
    THEME_LIGHT_DARK("\uf50E"),
    THERMOMETER("\uf50F"),
    THERMOMETER_LINES("\uf510"),
    THOUGHT_BUBBLE("\uf7F5"),
    THOUGHT_BUBBLE_OUTLINE("\uf7F6"),
    THUMB_DOWN("\uf511"),
    THUMB_DOWN_OUTLINE("\uf512"),
    THUMB_UP("\uf513"),
    THUMB_UP_OUTLINE("\uf514"),
    THUMBS_UP_DOWN("\uf515"),
    TICKET("\uf516"),
    TICKET_ACCOUNT("\uf517"),
    TICKET_CONFIRMATION("\uf518"),
    TICKET_PERCENT("\uf723"),
    TIE("\uf519"),
    TILDE("\uf724"),
    TIMELAPSE("\uf51A"),
    TIMER("\uf51B"),
    TIMER_10("\uf51C"),
    TIMER_3("\uf51D"),
    TIMER_OFF("\uf51E"),
    TIMER_SAND("\uf51F"),
    TIMER_SAND_EMPTY("\uf6AC"),
    TIMER_SAND_FULL("\uf78B"),
    TIMETABLE("\uf520"),
    TOGGLE_SWITCH("\uf521"),
    TOGGLE_SWITCH_OFF("\uf522"),
    TOOLTIP("\uf523"),
    TOOLTIP_EDIT("\uf524"),
    TOOLTIP_IMAGE("\uf525"),
    TOOLTIP_OUTLINE("\uf526"),
    TOOLTIP_OUTLINE_PLUS("\uf527"),
    TOOLTIP_TEXT("\uf528"),
    TOOTH("\uf529"),
    TOR("\uf52A"),
    TOWER_BEACH("\uf680"),
    TOWER_FIRE("\uf681"),
    TRACKPAD("\uf7F7"),
    TRAFFIC_LIGHT("\uf52B"),
    TRAIN("\uf52C"),
    TRAM("\uf52D"),
    TRANSCRIBE("\uf52E"),
    TRANSCRIBE_CLOSE("\uf52F"),
    TRANSFER("\uf530"),
    TRANSIT_TRANSFER("\uf6AD"),
    TRANSLATE("\uf5CA"),
    TREASURE_CHEST("\uf725"),
    TREE("\uf531"),
    TRELLO("\uf532"),
    TRENDING_DOWN("\uf533"),
    TRENDING_NEUTRAL("\uf534"),
    TRENDING_UP("\uf535"),
    TRIANGLE("\uf536"),
    TRIANGLE_OUTLINE("\uf537"),
    TROPHY("\uf538"),
    TROPHY_AWARD("\uf539"),
    TROPHY_OUTLINE("\uf53A"),
    TROPHY_VARIANT("\uf53B"),
    TROPHY_VARIANT_OUTLINE("\uf53C"),
    TRUCK("\uf53D"),
    TRUCK_DELIVERY("\uf53E"),
    TRUCK_FAST("\uf787"),
    TRUCK_TRAILER("\uf726"),
    TSHIRT_CREW("\uf53F"),
    TSHIRT_V("\uf540"),
    TUMBLR("\uf541"),
    TUMBLR_REBLOG("\uf542"),
    TUNE("\uf62E"),
    TUNE_VERTICAL("\uf66A"),
    TWITCH("\uf543"),
    TWITTER("\uf544"),
    TWITTER_BOX("\uf545"),
    TWITTER_CIRCLE("\uf546"),
    TWITTER_RETWEET("\uf547"),
    UBER("\uf748"),
    UBUNTU("\uf548"),
    ULTRA_HIGH_DEFINITION("\uf7F8"),
    UMBRACO("\uf549"),
    UMBRELLA("\uf54A"),
    UMBRELLA_OUTLINE("\uf54B"),
    UNDO("\uf54C"),
    UNDO_VARIANT("\uf54D"),
    UNFOLD_LESS_HORIZONTAL("\uf54E"),
    UNFOLD_LESS_VERTICAL("\uf75F"),
    UNFOLD_MORE_HORIZONTAL("\uf54F"),
    UNFOLD_MORE_VERTICAL("\uf760"),
    UNGROUP("\uf550"),
    UNITY("\uf6AE"),
    UNTAPPD("\uf551"),
    UPDATE("\uf6AF"),
    UPLOAD("\uf552"),
    UPLOAD_NETWORK("\uf6F5"),
    USB("\uf553"),
    VAN_PASSENGER("\uf7F9"),
    VAN_UTILITY("\uf7FA"),
    VANISH("\uf7FB"),
    VECTOR_ARRANGE_ABOVE("\uf554"),
    VECTOR_ARRANGE_BELOW("\uf555"),
    VECTOR_CIRCLE("\uf556"),
    VECTOR_CIRCLE_VARIANT("\uf557"),
    VECTOR_COMBINE("\uf558"),
    VECTOR_CURVE("\uf559"),
    VECTOR_DIFFERENCE("\uf55A"),
    VECTOR_DIFFERENCE_AB("\uf55B"),
    VECTOR_DIFFERENCE_BA("\uf55C"),
    VECTOR_INTERSECTION("\uf55D"),
    VECTOR_LINE("\uf55E"),
    VECTOR_POINT("\uf55F"),
    VECTOR_POLYGON("\uf560"),
    VECTOR_POLYLINE("\uf561"),
    VECTOR_RADIUS("\uf749"),
    VECTOR_RECTANGLE("\uf5C6"),
    VECTOR_SELECTION("\uf562"),
    VECTOR_SQUARE("\uf001"),
    VECTOR_TRIANGLE("\uf563"),
    VECTOR_UNION("\uf564"),
    VERIFIED("\uf565"),
    VIBRATE("\uf566"),
    VIDEO("\uf567"),
    VIDEO_3D("\uf7FC"),
    VIDEO_OFF("\uf568"),
    VIDEO_SWITCH("\uf569"),
    VIEW_AGENDA("\uf56A"),
    VIEW_ARRAY("\uf56B"),
    VIEW_CAROUSEL("\uf56C"),
    VIEW_COLUMN("\uf56D"),
    VIEW_DASHBOARD("\uf56E"),
    VIEW_DAY("\uf56F"),
    VIEW_GRID("\uf570"),
    VIEW_HEADLINE("\uf571"),
    VIEW_LIST("\uf572"),
    VIEW_MODULE("\uf573"),
    VIEW_PARALLEL("\uf727"),
    VIEW_QUILT("\uf574"),
    VIEW_SEQUENTIAL("\uf728"),
    VIEW_STREAM("\uf575"),
    VIEW_WEEK("\uf576"),
    VIMEO("\uf577"),
    VINE("\uf578"),
    VIOLIN("\uf60F"),
    VISUALSTUDIO("\uf610"),
    VK("\uf579"),
    VK_BOX("\uf57A"),
    VK_CIRCLE("\uf57B"),
    VLC("\uf57C"),
    VOICE("\uf5CB"),
    VOICEMAIL("\uf57D"),
    VOLUME_HIGH("\uf57E"),
    VOLUME_LOW("\uf57F"),
    VOLUME_MEDIUM("\uf580"),
    VOLUME_MINUS("\uf75D"),
    VOLUME_MUTE("\uf75E"),
    VOLUME_OFF("\uf581"),
    VOLUME_PLUS("\uf75C"),
    VPN("\uf582"),
    WALK("\uf583"),
    WALL("\uf7FD"),
    WALLET("\uf584"),
    WALLET_GIFTCARD("\uf585"),
    WALLET_MEMBERSHIP("\uf586"),
    WALLET_TRAVEL("\uf587"),
    WAN("\uf588"),
    WASHING_MACHINE("\uf729"),
    WATCH("\uf589"),
    WATCH_EXPORT("\uf58A"),
    WATCH_IMPORT("\uf58B"),
    WATCH_VIBRATE("\uf6B0"),
    WATER("\uf58C"),
    WATER_OFF("\uf58D"),
    WATER_PERCENT("\uf58E"),
    WATER_PUMP("\uf58F"),
    WATERMARK("\uf612"),
    WAVES("\uf78C"),
    WEATHER_CLOUDY("\uf590"),
    WEATHER_FOG("\uf591"),
    WEATHER_HAIL("\uf592"),
    WEATHER_LIGHTNING("\uf593"),
    WEATHER_LIGHTNING_RAINY("\uf67D"),
    WEATHER_NIGHT("\uf594"),
    WEATHER_PARTLYCLOUDY("\uf595"),
    WEATHER_POURING("\uf596"),
    WEATHER_RAINY("\uf597"),
    WEATHER_SNOWY("\uf598"),
    WEATHER_SNOWY_RAINY("\uf67E"),
    WEATHER_SUNNY("\uf599"),
    WEATHER_SUNSET("\uf59A"),
    WEATHER_SUNSET_DOWN("\uf59B"),
    WEATHER_SUNSET_UP("\uf59C"),
    WEATHER_WINDY("\uf59D"),
    WEATHER_WINDY_VARIANT("\uf59E"),
    WEB("\uf59F"),
    WEBCAM("\uf5A0"),
    WEBHOOK("\uf62F"),
    WEBPACK("\uf72A"),
    WECHAT("\uf611"),
    WEIGHT("\uf5A1"),
    WEIGHT_KILOGRAM("\uf5A2"),
    WHATSAPP("\uf5A3"),
    WHEELCHAIR_ACCESSIBILITY("\uf5A4"),
    WHITE_BALANCE_AUTO("\uf5A5"),
    WHITE_BALANCE_INCANDESCENT("\uf5A6"),
    WHITE_BALANCE_IRIDESCENT("\uf5A7"),
    WHITE_BALANCE_SUNNY("\uf5A8"),
    WIDGETS("\uf72B"),
    WIFI("\uf5A9"),
    WIFI_OFF("\uf5AA"),
    WII("\uf5AB"),
    WIIU("\uf72C"),
    WIKIPEDIA("\uf5AC"),
    WINDOW_CLOSE("\uf5AD"),
    WINDOW_CLOSED("\uf5AE"),
    WINDOW_MAXIMIZE("\uf5AF"),
    WINDOW_MINIMIZE("\uf5B0"),
    WINDOW_OPEN("\uf5B1"),
    WINDOW_RESTORE("\uf5B2"),
    WINDOWS("\uf5B3"),
    WORDPRESS("\uf5B4"),
    WORKER("\uf5B5"),
    WRAP("\uf5B6"),
    WRENCH("\uf5B7"),
    WUNDERLIST("\uf5B8"),
    XAML("\uf673"),
    XBOX("\uf5B9"),
    XBOX_CONTROLLER("\uf5BA"),
    XBOX_CONTROLLER_BATTERY_ALERT("\uf74A"),
    XBOX_CONTROLLER_BATTERY_EMPTY("\uf74B"),
    XBOX_CONTROLLER_BATTERY_FULL("\uf74C"),
    XBOX_CONTROLLER_BATTERY_LOW("\uf74D"),
    XBOX_CONTROLLER_BATTERY_MEDIUM("\uf74E"),
    XBOX_CONTROLLER_BATTERY_UNKNOWN("\uf74F"),
    XBOX_CONTROLLER_OFF("\uf5BB"),
    XDA("\uf5BC"),
    XING("\uf5BD"),
    XING_BOX("\uf5BE"),
    XING_CIRCLE("\uf5BF"),
    XML("\uf5C0"),
    XMPP("\uf7FE"),
    YAMMER("\uf788"),
    YEAST("\uf5C1"),
    YELP("\uf5C2"),
    YIN_YANG("\uf67F"),
    YOUTUBE_PLAY("\uf5C3"),
    ZIP_BOX("\uf5C4");


    private final String unicode;

    private MaterialDesignIcon(String unicode) {
        this.unicode = unicode;
    }

    @Override
    public String unicode() {
        return unicode;
    }

    @Override
    public String fontFamily() {
        return "\'Material Design Icons\'";
    }

}
