/* fmfconv_scr.c: SCR output routine included into fmfconv.c
   Copyright (c) 2004-2005 Gergely Szasz

   $Id: fmfconv_scr.c 4777 2012-11-26 23:35:48Z sbaldovi $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: szaszg@hu.inter.net

*/
#include <config.h>

#include <stdio.h>
#include <stdlib.h>

#include "libspectrum.h"
#include "fmfconv.h"

/*
  perl -e 'for $k (0..2) { for $j (0..7) { print "  "; for $i (0..7){printf "0x%04x, ", (4+3*8*40+$i*40*8+$j*40+$k*8*8*40);} print "\n";} print "\n"}'
*/

static int screl_start[192] = {

  0x03c4, 0x0504, 0x0644, 0x0784, 0x08c4, 0x0a04, 0x0b44, 0x0c84, 
  0x03ec, 0x052c, 0x066c, 0x07ac, 0x08ec, 0x0a2c, 0x0b6c, 0x0cac, 
  0x0414, 0x0554, 0x0694, 0x07d4, 0x0914, 0x0a54, 0x0b94, 0x0cd4, 
  0x043c, 0x057c, 0x06bc, 0x07fc, 0x093c, 0x0a7c, 0x0bbc, 0x0cfc, 
  0x0464, 0x05a4, 0x06e4, 0x0824, 0x0964, 0x0aa4, 0x0be4, 0x0d24, 
  0x048c, 0x05cc, 0x070c, 0x084c, 0x098c, 0x0acc, 0x0c0c, 0x0d4c, 
  0x04b4, 0x05f4, 0x0734, 0x0874, 0x09b4, 0x0af4, 0x0c34, 0x0d74, 
  0x04dc, 0x061c, 0x075c, 0x089c, 0x09dc, 0x0b1c, 0x0c5c, 0x0d9c, 

  0x0dc4, 0x0f04, 0x1044, 0x1184, 0x12c4, 0x1404, 0x1544, 0x1684, 
  0x0dec, 0x0f2c, 0x106c, 0x11ac, 0x12ec, 0x142c, 0x156c, 0x16ac, 
  0x0e14, 0x0f54, 0x1094, 0x11d4, 0x1314, 0x1454, 0x1594, 0x16d4, 
  0x0e3c, 0x0f7c, 0x10bc, 0x11fc, 0x133c, 0x147c, 0x15bc, 0x16fc, 
  0x0e64, 0x0fa4, 0x10e4, 0x1224, 0x1364, 0x14a4, 0x15e4, 0x1724, 
  0x0e8c, 0x0fcc, 0x110c, 0x124c, 0x138c, 0x14cc, 0x160c, 0x174c, 
  0x0eb4, 0x0ff4, 0x1134, 0x1274, 0x13b4, 0x14f4, 0x1634, 0x1774, 
  0x0edc, 0x101c, 0x115c, 0x129c, 0x13dc, 0x151c, 0x165c, 0x179c, 

  0x17c4, 0x1904, 0x1a44, 0x1b84, 0x1cc4, 0x1e04, 0x1f44, 0x2084, 
  0x17ec, 0x192c, 0x1a6c, 0x1bac, 0x1cec, 0x1e2c, 0x1f6c, 0x20ac, 
  0x1814, 0x1954, 0x1a94, 0x1bd4, 0x1d14, 0x1e54, 0x1f94, 0x20d4, 
  0x183c, 0x197c, 0x1abc, 0x1bfc, 0x1d3c, 0x1e7c, 0x1fbc, 0x20fc, 
  0x1864, 0x19a4, 0x1ae4, 0x1c24, 0x1d64, 0x1ea4, 0x1fe4, 0x2124, 
  0x188c, 0x19cc, 0x1b0c, 0x1c4c, 0x1d8c, 0x1ecc, 0x200c, 0x214c, 
  0x18b4, 0x19f4, 0x1b34, 0x1c74, 0x1db4, 0x1ef4, 0x2034, 0x2174, 
  0x18dc, 0x1a1c, 0x1b5c, 0x1c9c, 0x1ddc, 0x1f1c, 0x205c, 0x219c, 
};

/*
  perl -e 'for $i (0..23){printf "0x%04x, ", (4+3*8*40+$i*40*8);} '
*/
static int attrb_start[24] = {
  0x03c4, 0x0504, 0x0644, 0x0784, 0x08c4, 0x0a04, 0x0b44, 0x0c84,
  0x0dc4, 0x0f04, 0x1044, 0x1184, 0x12c4, 0x1404, 0x1544, 0x1684,
  0x17c4, 0x1904, 0x1a44, 0x1b84, 0x1cc4, 0x1e04, 0x1f44, 0x2084,
};
/*
  4 32 4 = 40 byte every line

  24
  192
  24	240 line every screen
*/
int
out_write_scr( void )
{
  int i;

  for( i = 0; i < 192; i++ ) {
    if( fwrite( zxscr + screl_start[i], 32, 1, out ) != 1 ) return ERR_WRITE_OUT;
  }
  for( i = 0; i < 24; i++ ) {
    if( fwrite( attrs + attrb_start[i], 32, 1, out ) != 1 ) return ERR_WRITE_OUT;
  }

  printi( 2, "out_write_scr()\n" );

  return 0;
}
