(declare (extended-bindings) (not constant-fold) (not safe))

(define v1 (##s64vector -9223372036854775808 -111 0 111 9223372036854775807))
(define v2 (##make-s64vector 10 -9223372036854775808))
(define v3 (##make-s64vector 10 -111))
(define v4 (##make-s64vector 10))
(define v5 (##make-s64vector 10 111))
(define v6 (##make-s64vector 10 9223372036854775807))

(define (int= x y)
  (if (##fixnum? x)
      (and (##fixnum? y)
           (##fx= x y))
      (and (##bignum? x)
           (##bignum? y)
           (let ((len (##bignum.adigit-length x)))
             (and (##fx= len (##bignum.adigit-length y))
                  (let loop ((i (##fx- len 1)))
                    (if (##fx< i 0)
                        (and (##bignum.adigit-= x y i)
                             (loop (##fx- i 1)))
                        #t)))))))
        
(define (test v i expected)
  (println (##eq? v (##s64vector-set! v i 0)))
  (let ((val (##s64vector-ref v i))) 
    (println (if (int= val 0) "good" "bad")))
  (println (##eq? v (##s64vector-set! v i expected)))
  (let ((val (##s64vector-ref v i))) 
    (println (if (int= val expected) "good" "bad"))))

(test v1 0 -9223372036854775808)
(test v1 1 -111)
(test v1 2 0)
(test v1 3 111)
(test v1 4 9223372036854775807)

(test v2 9 -9223372036854775808)
(test v3 9 -111)
(test v4 9 0)
(test v5 9 111)
(test v6 9 9223372036854775807)
