
import OpenGL.GL as gl

import glitch

class Spread(glitch.Node):
    def __init__(self, x=0, y=0, z=0, **kw):
        glitch.Node.__init__(self, **kw)
        self.x = x
        self.y = y
        self.z = z

    def render(self, ctx):
        gl.glMatrixMode(gl.GL_MODELVIEW)
        gl.glPushMatrix()

        for child in self.children:
            child.render(ctx)
            gl.glTranslate(self.x, self.y, self.z)

        gl.glPopMatrix()

