// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef CURSESSCR_H
#define CURSESSCR_H

#ifdef USE_NCURSES
#include <curses.h>
#else
#include <stdio.h>
#include <termios.h>
#endif

class Sample;

class CursesScr
{
public:
  CursesScr(unsigned char);
  ~CursesScr();

  void moduleFile(const char *);
  void moduleTitle(const char *);
  void setChannels(int);
  void setType(const char *);
  void setMaxPosition(int);
  void setMem(int, int);
  void setPos(unsigned int, unsigned int);
  int getChar();

private:
  unsigned char background_;
#ifdef USE_NCURSES
  WINDOW *infoWin;
  WINDOW *memWin;
  WINDOW *posWin;
#else
  long oldFlags_;
  struct termios oldTermio_;
#endif
};

inline int
CursesScr::getChar()
{
  if (!background_)
    {
#ifdef USE_NCURSES
      return wgetch(posWin);
#else
      return getchar();
#endif
    }
  else
    return EOF;
}

#endif
